/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.LogCleaningAbortedException;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerManager$;
import kafka.log.LogCleaningAborted$;
import kafka.log.LogCleaningException;
import kafka.log.LogCleaningInProgress$;
import kafka.log.LogCleaningPaused;
import kafka.log.LogCleaningState;
import kafka.log.LogToClean;
import kafka.log.OffsetsToClean;
import kafka.log.PreCleanStats;
import kafka.log.UnifiedLog;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.LogDirFailureChannel;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Pool;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.Growable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.MapLike;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.math.Numeric;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\reb!\u0002\u001f>\u0001u\n\u0005\u0002\u0003+\u0001\u0005\u000b\u0007I\u0011\u0001,\t\u0011\u0015\u0004!\u0011!Q\u0001\n]C\u0001B\u001a\u0001\u0003\u0006\u0004%\ta\u001a\u0005\tu\u0002\u0011\t\u0011)A\u0005Q\"A1\u0010\u0001BC\u0002\u0013\u0005A\u0010C\u0005\u0002\b\u0001\u0011\t\u0011)A\u0005{\"9\u0011\u0011\u0002\u0001\u0005\u0002\u0005-\u0001bBA\u000b\u0001\u0011E\u0013q\u0003\u0005\u000b\u0003K\u0001!\u0019!C\u0001{\u0005]\u0001\u0002CA\u0014\u0001\u0001\u0006I!!\u0007\t\u0013\u0005%\u0002\u00011A\u0005\n\u0005-\u0002\"CA\"\u0001\u0001\u0007I\u0011BA#\u0011!\t\t\u0006\u0001Q!\n\u00055\u0002\"CA.\u0001\t\u0007I\u0011BA/\u0011!\t\t\b\u0001Q\u0001\n\u0005}\u0003\"CA:\u0001\t\u0007I\u0011BA;\u0011!\t\u0019\n\u0001Q\u0001\n\u0005]\u0004\"CAK\u0001\t\u0007I\u0011BAL\u0011!\ti\u000b\u0001Q\u0001\n\u0005e\u0005\"CAX\u0001\t\u0007I\u0011BAY\u0011!\tI\f\u0001Q\u0001\n\u0005M\u0006\"CA^\u0001\u0001\u0007I\u0011BA_\u0011%\t)\r\u0001a\u0001\n\u0013\t9\r\u0003\u0005\u0002L\u0002\u0001\u000b\u0015BA`\u0011%\ty\r\u0001a\u0001\n\u0013\t\t\u000eC\u0005\u0002Z\u0002\u0001\r\u0011\"\u0003\u0002\\\"A\u0011q\u001c\u0001!B\u0013\t\u0019\u000eC\u0004\u0002d\u0002!\t!!:\t\u0011\u0005-\b\u0001\"\u0001>\u0003[D\u0001\"!?\u0001\t\u0003i\u00141 \u0005\b\u0005\u0007\u0001A\u0011\u0001B\u0003\u0011%\u00119\u0003AI\u0001\n\u0003\u0011I\u0003C\u0004\u0003@\u0001!\tA!\u0011\t\u000f\t=\u0003\u0001\"\u0001\u0003B!9!\u0011\u000b\u0001\u0005\u0002\tM\u0003b\u0002B-\u0001\u0011\u0005!1\f\u0005\b\u0005?\u0002A\u0011\u0001B1\u0011\u001d\u0011I\u0007\u0001C\u0005\u0005WBqA!\u001f\u0001\t\u0013\u0011Y\bC\u0004\u0003\u0000\u0001!\tA!!\t\u000f\t\u0015\u0005\u0001\"\u0001\u0003\b\"I!1\u0014\u0001\u0012\u0002\u0013\u0005!Q\u0014\u0005\n\u0005C\u0003\u0011\u0013!C\u0001\u0005GCqAa*\u0001\t\u0003\u0011I\u000bC\u0004\u00036\u0002!\tAa.\t\u000f\tu\u0006\u0001\"\u0001\u0003@\"9!\u0011\u001a\u0001\u0005\u0002\t-\u0007b\u0002Bk\u0001\u0011\u0005!q\u001b\u0005\t\u0003g\u0002A\u0011A\u001f\u0003\\\"9!Q\u001d\u0001\u0005\u0002\t\u001d\bb\u0002Bx\u0001\u0011%!\u0011\u001f\u0005\b\u0005o\u0004A\u0011\u0001B}\u000f!\u0011Y0\u0010E\u0001{\tuha\u0002\u001f>\u0011\u0003i$q \u0005\b\u0003\u00131D\u0011AB\u0001\u0011\u001d\u0019\u0019A\u000eC\u0001\u0007\u000bAqa!\u00037\t\u0003\u0019Y\u0001C\u0004\u0004\u0018Y\"\ta!\u0007\t\u000f\r-b\u0007\"\u0001\u0004.\t\tBj\\4DY\u0016\fg.\u001a:NC:\fw-\u001a:\u000b\u0005yz\u0014a\u00017pO*\t\u0001)A\u0003lC\u001a\\\u0017m\u0005\u0003\u0001\u0005\"s\u0005CA\"G\u001b\u0005!%\"A#\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d#%AB!osJ+g\r\u0005\u0002J\u00196\t!J\u0003\u0002L\u007f\u0005)Q\u000f^5mg&\u0011QJ\u0013\u0002\b\u0019><w-\u001b8h!\ty%+D\u0001Q\u0015\t\tv(A\u0004nKR\u0014\u0018nY:\n\u0005M\u0003&!E&bM.\fW*\u001a;sS\u000e\u001cxI]8va\u00069An\\4ESJ\u001c8\u0001A\u000b\u0002/B\u0019\u0001lW/\u000e\u0003eS!A\u0017#\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002]3\n\u00191+Z9\u0011\u0005y\u001bW\"A0\u000b\u0005\u0001\f\u0017AA5p\u0015\u0005\u0011\u0017\u0001\u00026bm\u0006L!\u0001Z0\u0003\t\u0019KG.Z\u0001\tY><G)\u001b:tA\u0005!An\\4t+\u0005A\u0007\u0003B%jWZL!A\u001b&\u0003\tA{w\u000e\u001c\t\u0003YRl\u0011!\u001c\u0006\u0003]>\faaY8n[>t'B\u0001!q\u0015\t\t(/\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002g\u0006\u0019qN]4\n\u0005Ul'A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0003obl\u0011!P\u0005\u0003sv\u0012!\"\u00168jM&,G\rT8h\u0003\u0015awnZ:!\u0003Qawn\u001a#je\u001a\u000b\u0017\u000e\\;sK\u000eC\u0017M\u001c8fYV\tQ\u0010E\u0002\u007f\u0003\u0007i\u0011a \u0006\u0004\u0003\u0003y\u0014AB:feZ,'/C\u0002\u0002\u0006}\u0014A\u0003T8h\t&\u0014h)Y5mkJ,7\t[1o]\u0016d\u0017!\u00067pO\u0012K'OR1jYV\u0014Xm\u00115b]:,G\u000eI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011\u00055\u0011qBA\t\u0003'\u0001\"a\u001e\u0001\t\u000bQ;\u0001\u0019A,\t\u000b\u0019<\u0001\u0019\u00015\t\u000bm<\u0001\u0019A?\u0002\u00151|wmZ3s\u001d\u0006lW-\u0006\u0002\u0002\u001aA!\u00111DA\u0011\u001b\t\tiBC\u0002\u0002 \u0005\fA\u0001\\1oO&!\u00111EA\u000f\u0005\u0019\u0019FO]5oO\u0006!rN\u001a4tKR\u001c\u0005.Z2la>Lg\u000e\u001e$jY\u0016\fQc\u001c4gg\u0016$8\t[3dWB|\u0017N\u001c;GS2,\u0007%A\u0006dQ\u0016\u001c7\u000e]8j]R\u001cXCAA\u0017!\u001d\ty#!\u000e^\u0003si!!!\r\u000b\u0007\u0005M\u0012,A\u0005j[6,H/\u00192mK&!\u0011qGA\u0019\u0005\ri\u0015\r\u001d\t\u0005\u0003w\ty$\u0004\u0002\u0002>)\u0019\u0011\u0011F@\n\t\u0005\u0005\u0013Q\b\u0002\u0015\u001f\u001a47/\u001a;DQ\u0016\u001c7\u000e]8j]R4\u0015\u000e\\3\u0002\u001f\rDWmY6q_&tGo]0%KF$B!a\u0012\u0002NA\u00191)!\u0013\n\u0007\u0005-CI\u0001\u0003V]&$\b\"CA(\u0019\u0005\u0005\t\u0019AA\u0017\u0003\rAH%M\u0001\rG\",7m\u001b9pS:$8\u000f\t\u0015\u0004\u001b\u0005U\u0003cA\"\u0002X%\u0019\u0011\u0011\f#\u0003\u0011Y|G.\u0019;jY\u0016\f!\"\u001b8Qe><'/Z:t+\t\ty\u0006E\u0004\u0002b\u0005\u001d4.a\u001b\u000e\u0005\u0005\r$bAA33\u00069Q.\u001e;bE2,\u0017\u0002BA5\u0003G\u0012q\u0001S1tQ6\u000b\u0007\u000fE\u0002x\u0003[J1!a\u001c>\u0005AaunZ\"mK\u0006t\u0017N\\4Ti\u0006$X-A\u0006j]B\u0013xn\u001a:fgN\u0004\u0013!F;oG2,\u0017M\\1cY\u0016\u0004\u0016M\u001d;ji&|gn]\u000b\u0003\u0003o\u0002\u0002\"!\u0019\u0002h\u0005e\u0014Q\u0012\t\u0005\u0003w\nII\u0004\u0003\u0002~\u0005\u0015\u0005cAA@\t6\u0011\u0011\u0011\u0011\u0006\u0004\u0003\u0007+\u0016A\u0002\u001fs_>$h(C\u0002\u0002\b\u0012\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u0012\u0003\u0017S1!a\"E!\u0015\t\t'a$l\u0013\u0011\t\t*a\u0019\u0003\u0007M+G/\u0001\fv]\u000edW-\u00198bE2,\u0007+\u0019:uSRLwN\\:!\u0003\u0011awnY6\u0016\u0005\u0005e\u0005\u0003BAN\u0003Sk!!!(\u000b\t\u0005}\u0015\u0011U\u0001\u0006Y>\u001c7n\u001d\u0006\u0005\u0003G\u000b)+\u0001\u0006d_:\u001cWO\u001d:f]RT1!a*b\u0003\u0011)H/\u001b7\n\t\u0005-\u0016Q\u0014\u0002\u000e%\u0016,g\u000e\u001e:b]RdunY6\u0002\u000b1|7m\u001b\u0011\u0002%A\fWo]3e\u00072,\u0017M\\5oO\u000e{g\u000eZ\u000b\u0003\u0003g\u0003B!a'\u00026&!\u0011qWAO\u0005%\u0019uN\u001c3ji&|g.A\nqCV\u001cX\rZ\"mK\u0006t\u0017N\\4D_:$\u0007%A\reSJ$\u0018.Z:u\u0019><7\t\\3b]\u0006\u0014G.\u001a*bi&|WCAA`!\r\u0019\u0015\u0011Y\u0005\u0004\u0003\u0007$%A\u0002#pk\ndW-A\u000feSJ$\u0018.Z:u\u0019><7\t\\3b]\u0006\u0014G.\u001a*bi&|w\fJ3r)\u0011\t9%!3\t\u0013\u0005=s#!AA\u0002\u0005}\u0016A\u00073jeRLWm\u001d;M_\u001e\u001cE.Z1oC\ndWMU1uS>\u0004\u0003f\u0001\r\u0002V\u0005iA/[7f\u001f\u001ad\u0015m\u001d;Sk:,\"!a5\u0011\u0007\r\u000b).C\u0002\u0002X\u0012\u0013A\u0001T8oO\u0006\tB/[7f\u001f\u001ad\u0015m\u001d;Sk:|F%Z9\u0015\t\u0005\u001d\u0013Q\u001c\u0005\n\u0003\u001fR\u0012\u0011!a\u0001\u0003'\fa\u0002^5nK>3G*Y:u%Vt\u0007\u0005K\u0002\u001c\u0003+\nQ#\u00197m\u00072,\u0017M\\3s\u0007\",7m\u001b9pS:$8/\u0006\u0002\u0002hB9\u00111PAuW\u0006M\u0017\u0002BA\u001c\u0003\u0017\u000bQb\u00197fC:LgnZ*uCR,G\u0003BAx\u0003k\u0004RaQAy\u0003WJ1!a=E\u0005\u0019y\u0005\u000f^5p]\"1\u0011q_\u000fA\u0002-\f!\u0001\u001e9\u0002!M,Go\u00117fC:LgnZ*uCR,GCBA$\u0003{\fy\u0010\u0003\u0004\u0002xz\u0001\ra\u001b\u0005\b\u0005\u0003q\u0002\u0019AA6\u0003\u0015\u0019H/\u0019;f\u0003e9'/\u00192GS2$\b.[3ti\u000e{W\u000e]1di\u0016$Gj\\4\u0015\r\t\u001d!q\u0002B\u000f!\u0015\u0019\u0015\u0011\u001fB\u0005!\r9(1B\u0005\u0004\u0005\u001bi$A\u0003'pOR{7\t\\3b]\"9!\u0011C\u0010A\u0002\tM\u0011\u0001\u0002;j[\u0016\u0004BA!\u0006\u0003\u001a5\u0011!q\u0003\u0006\u0003\u00176LAAa\u0007\u0003\u0018\t!A+[7f\u0011%\u0011yb\bI\u0001\u0002\u0004\u0011\t#A\u0007qe\u0016\u001cE.Z1o'R\fGo\u001d\t\u0004o\n\r\u0012b\u0001B\u0013{\ti\u0001K]3DY\u0016\fgn\u0015;biN\f1e\u001a:bE\u001aKG\u000e\u001e5jKN$8i\\7qC\u000e$X\r\u001a'pO\u0012\"WMZ1vYR$#'\u0006\u0002\u0003,)\"!\u0011\u0005B\u0017W\t\u0011y\u0003\u0005\u0003\u00032\tmRB\u0001B\u001a\u0015\u0011\u0011)Da\u000e\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u001d\t\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\tu\"1\u0007\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017A\n9bkN,7\t\\3b]&twMR8s\u001d>t7i\\7qC\u000e$X\r\u001a)beRLG/[8ogR\u0011!1\t\t\u00061\n\u0015#\u0011J\u0005\u0004\u0005\u000fJ&\u0001C%uKJ\f'\r\\3\u0011\u000b\r\u0013Ye\u001b<\n\u0007\t5CI\u0001\u0004UkBdWMM\u0001\u000eI\u0016dW\r^1cY\u0016dunZ:\u0002\u001b\u0005\u0014wN\u001d;DY\u0016\fg.\u001b8h)\u0011\t9E!\u0016\t\r\t]3\u00051\u0001l\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\fQ#\u00192peR\fe\u000e\u001a)bkN,7\t\\3b]&tw\r\u0006\u0003\u0002H\tu\u0003B\u0002B,I\u0001\u00071.\u0001\bsKN,X.Z\"mK\u0006t\u0017N\\4\u0015\t\u0005\u001d#1\r\u0005\b\u0005K*\u0003\u0019\u0001B4\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c\b\u0003\u0002-\u0003F-\f\u0011#[:DY\u0016\fg.\u001b8h\u0013:\u001cF/\u0019;f)\u0019\u0011iGa\u001d\u0003vA\u00191Ia\u001c\n\u0007\tEDIA\u0004C_>dW-\u00198\t\r\t]c\u00051\u0001l\u0011\u001d\u00119H\na\u0001\u0003W\nQ\"\u001a=qK\u000e$X\rZ*uCR,\u0017aF5t\u00072,\u0017M\\5oO&s7\u000b^1uKB\u000bWo]3e)\u0011\u0011iG! \t\r\t]s\u00051\u0001l\u0003Q\u0019\u0007.Z2l\u00072,\u0017M\\5oO\u0006\u0013wN\u001d;fIR!\u0011q\tBB\u0011\u0019\u00119\u0006\u000ba\u0001W\u0006\tR\u000f\u001d3bi\u0016\u001c\u0005.Z2la>Lg\u000e^:\u0015\u0011\u0005\u001d#\u0011\u0012BG\u0005+CaAa#*\u0001\u0004i\u0016a\u00023bi\u0006$\u0015N\u001d\u0005\n\u0005\u001fK\u0003\u0013!a\u0001\u0005#\u000ba\u0003]1si&$\u0018n\u001c8U_V\u0003H-\u0019;f\u001fJ\fE\r\u001a\t\u0006\u0007\u0006E(1\u0013\t\u0007\u0007\n-3.a5\t\u0013\t]\u0015\u0006%AA\u0002\te\u0015!\u00059beRLG/[8o)>\u0014V-\\8wKB!1)!=l\u0003m)\b\u000fZ1uK\u000eCWmY6q_&tGo\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!q\u0014\u0016\u0005\u0005#\u0013i#A\u000eva\u0012\fG/Z\"iK\u000e\\\u0007o\\5oiN$C-\u001a4bk2$HeM\u000b\u0003\u0005KSCA!'\u0003.\u0005\u0011\u0012\r\u001c;fe\u000eCWmY6q_&tG\u000fR5s)!\t9Ea+\u0003.\nE\u0006B\u0002B,Y\u0001\u00071\u000e\u0003\u0004\u000302\u0002\r!X\u0001\rg>,(oY3M_\u001e$\u0015N\u001d\u0005\u0007\u0005gc\u0003\u0019A/\u0002\u0015\u0011,7\u000f\u001e'pO\u0012K'/A\niC:$G.\u001a'pO\u0012K'OR1jYV\u0014X\r\u0006\u0003\u0002H\te\u0006b\u0002B^[\u0001\u0007\u0011\u0011P\u0001\u0004I&\u0014\u0018aF7bs\n,GK];oG\u0006$Xm\u00115fG.\u0004x.\u001b8u)!\t9E!1\u0003D\n\u0015\u0007B\u0002BF]\u0001\u0007Q\f\u0003\u0004\u0003X9\u0002\ra\u001b\u0005\b\u0005\u000ft\u0003\u0019AAj\u0003\u0019ygMZ:fi\u0006aAm\u001c8f\u00072,\u0017M\\5oORA\u0011q\tBg\u0005\u001f\u0014\t\u000e\u0003\u0004\u0003X=\u0002\ra\u001b\u0005\u0007\u0005\u0017{\u0003\u0019A/\t\u000f\tMw\u00061\u0001\u0002T\u0006IQM\u001c3PM\u001a\u001cX\r^\u0001\rI>tW\rR3mKRLgn\u001a\u000b\u0005\u0003\u000f\u0012I\u000eC\u0004\u0003fA\u0002\rAa\u001a\u0015\t\tu'\u0011\u001d\t\u0006\u0003w\u0012yn[\u0005\u0005\u0003#\u000bY\tC\u0004\u0003dF\u0002\r!!\u001f\u0002\r1|w\rR5s\u0003ai\u0017M]6QCJ$\u0018\u000e^5p]Vs7\r\\3b]\u0006\u0014G.\u001a\u000b\u0007\u0003\u000f\u0012IOa;\t\u000f\t\r(\u00071\u0001\u0002z!1!Q\u001e\u001aA\u0002-\f\u0011\u0002]1si&$\u0018n\u001c8\u0002-%\u001cXK\\2mK\u0006t\u0017M\u00197f!\u0006\u0014H/\u001b;j_:$bA!\u001c\u0003t\nU\b\"\u0002 4\u0001\u00041\bB\u0002B,g\u0001\u00071.A\u000fnC&tG/Y5o+:\u001cG.Z1oC\ndW\rU1si&$\u0018n\u001c8t)\t\t9%A\tM_\u001e\u001cE.Z1oKJl\u0015M\\1hKJ\u0004\"a\u001e\u001c\u0014\u0007Y\u0012\u0005\n\u0006\u0002\u0003~\u0006\u0011\u0012n]\"p[B\f7\r^!oI\u0012+G.\u001a;f)\u0011\u0011iga\u0002\t\u000byB\u0004\u0019\u0001<\u0002%5\f\u0007pQ8na\u0006\u001cG/[8o\t\u0016d\u0017-\u001f\u000b\t\u0003'\u001ciaa\u0004\u0004\u0014!)a(\u000fa\u0001m\"91\u0011C\u001dA\u0002\u0005M\u0017\u0001\u00054jeN$H)\u001b:us>3gm]3u\u0011\u001d\u0019)\"\u000fa\u0001\u0003'\f1A\\8x\u0003A\u0019G.Z1oC\ndWm\u00144gg\u0016$8\u000f\u0006\u0005\u0004\u001c\r\u000521EB\u0015!\r98QD\u0005\u0004\u0007?i$AD(gMN,Go\u001d+p\u00072,\u0017M\u001c\u0005\u0006}i\u0002\rA\u001e\u0005\b\u0007KQ\u0004\u0019AB\u0014\u0003=a\u0017m\u001d;DY\u0016\fgn\u00144gg\u0016$\b#B\"\u0002r\u0006M\u0007bBB\u000bu\u0001\u0007\u00111[\u0001\u0018G\u0006d7-\u001e7bi\u0016\u001cE.Z1oC\ndWMQ=uKN$\u0002ba\f\u00042\rM2Q\u0007\t\b\u0007\n-\u00131[Aj\u0011\u0015q4\b1\u0001w\u0011\u001d\u0019\tb\u000fa\u0001\u0003'Dqaa\u000e<\u0001\u0004\t\u0019.A\tv]\u000edW-\u00198bE2,wJ\u001a4tKR\u0004")
public class LogCleanerManager
implements KafkaMetricsGroup {
    private final Seq<File> logDirs;
    private final Pool<TopicPartition, UnifiedLog> logs;
    private final LogDirFailureChannel logDirFailureChannel;
    private final String offsetCheckpointFile;
    private volatile scala.collection.immutable.Map<File, OffsetCheckpointFile> checkpoints;
    private final HashMap<TopicPartition, LogCleaningState> inProgress;
    private final HashMap<String, Set<TopicPartition>> uncleanablePartitions;
    private final ReentrantLock lock;
    private final Condition pausedCleaningCond;
    private volatile double dirtiestLogCleanableRatio;
    private volatile long timeOfLastRun;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Tuple2<Object, Object> calculateCleanableBytes(UnifiedLog unifiedLog, long l, long l2) {
        return LogCleanerManager$.MODULE$.calculateCleanableBytes(unifiedLog, l, l2);
    }

    public static OffsetsToClean cleanableOffsets(UnifiedLog unifiedLog, Option<Object> option, long l) {
        return LogCleanerManager$.MODULE$.cleanableOffsets(unifiedLog, option, l);
    }

    public static long maxCompactionDelay(UnifiedLog unifiedLog, long l, long l2) {
        return LogCleanerManager$.MODULE$.maxCompactionDelay(unifiedLog, l, l2);
    }

    public static boolean isCompactAndDelete(UnifiedLog unifiedLog) {
        return LogCleanerManager$.MODULE$.isCompactAndDelete(unifiedLog);
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Meter newMeter(MetricName metricName, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup.newMeter$(this, metricName, eventType, timeUnit);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Seq<File> logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, UnifiedLog> logs() {
        return this.logs;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    @Override
    public String loggerName() {
        return LogCleaner.class.getName();
    }

    public String offsetCheckpointFile() {
        return this.offsetCheckpointFile;
    }

    private scala.collection.immutable.Map<File, OffsetCheckpointFile> checkpoints() {
        return this.checkpoints;
    }

    private void checkpoints_$eq(scala.collection.immutable.Map<File, OffsetCheckpointFile> x$1) {
        this.checkpoints = x$1;
    }

    private HashMap<TopicPartition, LogCleaningState> inProgress() {
        return this.inProgress;
    }

    private HashMap<String, Set<TopicPartition>> uncleanablePartitions() {
        return this.uncleanablePartitions;
    }

    private ReentrantLock lock() {
        return this.lock;
    }

    private Condition pausedCleaningCond() {
        return this.pausedCleaningCond;
    }

    private double dirtiestLogCleanableRatio() {
        return this.dirtiestLogCleanableRatio;
    }

    private void dirtiestLogCleanableRatio_$eq(double x$1) {
        this.dirtiestLogCleanableRatio = x$1;
    }

    private long timeOfLastRun() {
        return this.timeOfLastRun;
    }

    private void timeOfLastRun_$eq(long x$1) {
        this.timeOfLastRun = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.immutable.Map<TopicPartition, Object> allCleanerCheckpoints() {
        scala.collection.immutable.Map map;
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            map = LogCleanerManager.$anonfun$allCleanerCheckpoints$1(this);
        }
        finally {
            inLock_lock.unlock();
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    public Option<LogCleaningState> cleaningState(TopicPartition tp) {
        Option option;
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            option = LogCleanerManager.$anonfun$cleaningState$1(this, tp);
        }
        finally {
            inLock_lock.unlock();
        }
        return option;
    }

    /*
     * WARNING - void declaration
     */
    public void setCleaningState(TopicPartition tp, LogCleaningState state) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$setCleaningState$1(this, tp, state);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public Option<LogToClean> grabFilthiestCompactedLog(Time time, PreCleanStats preCleanStats) {
        Option option;
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            option = LogCleanerManager.$anonfun$grabFilthiestCompactedLog$1(this, time, preCleanStats);
        }
        finally {
            inLock_lock.unlock();
        }
        return option;
    }

    public PreCleanStats grabFilthiestCompactedLog$default$2() {
        return new PreCleanStats();
    }

    /*
     * WARNING - void declaration
     */
    public Iterable<Tuple2<TopicPartition, UnifiedLog>> pauseCleaningForNonCompactedPartitions() {
        Iterable iterable;
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            iterable = LogCleanerManager.$anonfun$pauseCleaningForNonCompactedPartitions$1(this);
        }
        finally {
            inLock_lock.unlock();
        }
        return iterable;
    }

    /*
     * WARNING - void declaration
     */
    public Iterable<Tuple2<TopicPartition, UnifiedLog>> deletableLogs() {
        Iterable iterable;
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            iterable = LogCleanerManager.$anonfun$deletableLogs$1(this);
        }
        finally {
            inLock_lock.unlock();
        }
        return iterable;
    }

    /*
     * WARNING - void declaration
     */
    public void abortCleaning(TopicPartition topicPartition) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$abortCleaning$1(this, topicPartition);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$abortAndPauseCleaning$1(this, topicPartition);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void resumeCleaning(Iterable<TopicPartition> topicPartitions) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            topicPartitions.foreach((Function1 & Serializable & scala.Serializable)topicPartition -> {
                Option option = $this.inProgress().get(topicPartition);
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalStateException(new StringBuilder(67).append("Compaction for partition ").append(topicPartition).append(" cannot be resumed since it is not paused.").toString());
                }
                if (!(option instanceof Some)) throw new MatchError((Object)option);
                LogCleaningState state = (LogCleaningState)((Some)option).value();
                boolean bl = false;
                LogCleaningPaused logCleaningPaused = null;
                if (state instanceof LogCleaningPaused) {
                    bl = true;
                    logCleaningPaused = (LogCleaningPaused)state;
                    if (logCleaningPaused.pausedCount() == 1) {
                        return $this.inProgress().remove(topicPartition);
                    }
                }
                if (!bl) throw new IllegalStateException(new StringBuilder(66).append("Compaction for partition ").append(topicPartition).append(" cannot be resumed since it is in ").append(state).append(" state.").toString());
                int count = logCleaningPaused.pausedCount();
                if (count <= 1) throw new IllegalStateException(new StringBuilder(66).append("Compaction for partition ").append(topicPartition).append(" cannot be resumed since it is in ").append(state).append(" state.").toString());
                return $this.inProgress().put(topicPartition, (Object)new LogCleaningPaused(count - 1));
            });
        }
        finally {
            inLock_lock.unlock();
        }
    }

    private boolean isCleaningInState(TopicPartition topicPartition, LogCleaningState expectedState) {
        boolean bl;
        Option option = this.inProgress().get((Object)topicPartition);
        if (None$.MODULE$.equals(option)) {
            bl = false;
        } else if (option instanceof Some) {
            LogCleaningState logCleaningState = (LogCleaningState)((Some)option).value();
            bl = !(logCleaningState != null ? !logCleaningState.equals(expectedState) : expectedState != null);
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    private boolean isCleaningInStatePaused(TopicPartition topicPartition) {
        boolean bl;
        Option option = this.inProgress().get((Object)topicPartition);
        if (None$.MODULE$.equals(option)) {
            bl = false;
        } else if (option instanceof Some) {
            boolean bl2 = (LogCleaningState)((Some)option).value() instanceof LogCleaningPaused;
            bl = bl2;
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public void checkCleaningAborted(TopicPartition topicPartition) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$checkCleaningAborted$1(this, topicPartition);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void updateCheckpoints(File dataDir, Option<Tuple2<TopicPartition, Object>> partitionToUpdateOrAdd, Option<TopicPartition> partitionToRemove) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$updateCheckpoints$1(this, dataDir, partitionToRemove, partitionToUpdateOrAdd);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    public Option<Tuple2<TopicPartition, Object>> updateCheckpoints$default$2() {
        return None$.MODULE$;
    }

    public Option<TopicPartition> updateCheckpoints$default$3() {
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    public void alterCheckpointDir(TopicPartition topicPartition, File sourceLogDir, File destLogDir) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$alterCheckpointDir$1(this, sourceLogDir, topicPartition, destLogDir);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void handleLogDirFailure(String dir) {
        void inLock_lock;
        this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Stopping cleaning logs in dir ").append(dir).toString());
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            this.checkpoints_$eq((scala.collection.immutable.Map<File, OffsetCheckpointFile>)((scala.collection.immutable.Map)this.checkpoints().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$handleLogDirFailure$3(dir$3, x0$1)))));
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, long offset) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$maybeTruncateCheckpoint$1(this, topicPartition, dataDir, offset);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void doneCleaning(TopicPartition topicPartition, File dataDir, long endOffset) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$doneCleaning$1(this, topicPartition, dataDir, endOffset);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void doneDeleting(Iterable<TopicPartition> topicPartitions) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            topicPartitions.foreach((Function1 & Serializable & scala.Serializable)topicPartition -> {
                LogCleaningState logCleaningState;
                boolean bl = false;
                Some some = null;
                Option option = $this.inProgress().get(topicPartition);
                if (option instanceof Some) {
                    bl = true;
                    some = (Some)option;
                    LogCleaningState logCleaningState2 = (LogCleaningState)some.value();
                    if (LogCleaningInProgress$.MODULE$.equals(logCleaningState2)) {
                        return $this.inProgress().remove(topicPartition);
                    }
                }
                if (bl && LogCleaningAborted$.MODULE$.equals(logCleaningState = (LogCleaningState)some.value())) {
                    $this.inProgress().put(topicPartition, (Object)new LogCleaningPaused(1));
                    $this.pausedCleaningCond().signalAll();
                    return BoxedUnit.UNIT;
                }
                if (!None$.MODULE$.equals(option)) throw new IllegalStateException(new StringBuilder(43).append("In-progress partition ").append(topicPartition).append(" cannot be in ").append(option).append(" state.").toString());
                throw new IllegalStateException(new StringBuilder(34).append("State for partition ").append(topicPartition).append(" should exist.").toString());
            });
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.immutable.Set<TopicPartition> uncleanablePartitions(String logDir) {
        void inLock_lock;
        ObjectRef partitions = ObjectRef.create((Object)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            partitions.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)partitions.elem).$plus$plus((GenTraversableOnce)this.uncleanablePartitions().getOrElse((Object)logDir, (Function0 & Serializable & scala.Serializable)() -> (scala.collection.immutable.Set)partitions$1.elem));
        }
        finally {
            inLock_lock.unlock();
        }
        return (scala.collection.immutable.Set)partitions.elem;
    }

    /*
     * WARNING - void declaration
     */
    public void markPartitionUncleanable(String logDir, TopicPartition partition) {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$markPartitionUncleanable$1(this, logDir, partition);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isUncleanablePartition(UnifiedLog log, TopicPartition topicPartition) {
        boolean bl;
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            bl = LogCleanerManager.$anonfun$isUncleanablePartition$1(this, log, topicPartition);
        }
        finally {
            inLock_lock.unlock();
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public void maintainUncleanablePartitions() {
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            LogCleanerManager.$anonfun$maintainUncleanablePartitions$1(this);
        }
        finally {
            inLock_lock.unlock();
        }
    }

    public static final /* synthetic */ int $anonfun$new$3(LogCleanerManager $this, File dir$1) {
        return BoxesRunTime.unboxToInt((Object)$this.uncleanablePartitions().get((Object)dir$1.getAbsolutePath()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.size())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ int kafka$log$LogCleanerManager$$$anonfun$new$2(File dir$1) {
        int n;
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            n = LogCleanerManager.$anonfun$new$3(this, dir$1);
        }
        finally {
            inLock_lock.unlock();
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ long $anonfun$new$10(scala.collection.immutable.Map lastClean$1, TopicPartition tp$1, long now$1, UnifiedLog log) {
        void var8_7;
        Option lastCleanOffset = lastClean$1.get((Object)tp$1);
        OffsetsToClean offsetsToClean = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option<Object>)lastCleanOffset, now$1);
        Tuple2<Object, Object> tuple2 = LogCleanerManager$.MODULE$.calculateCleanableBytes(log, offsetsToClean.firstDirtyOffset(), offsetsToClean.firstUncleanableDirtyOffset());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long uncleanableBytes = tuple2._2$mcJ$sp();
        return (long)var8_7;
    }

    public static final /* synthetic */ long $anonfun$new$9(LogCleanerManager $this, scala.collection.immutable.Map lastClean$1, long now$1, TopicPartition tp) {
        return BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)$this.logs().get(tp)).map((Function1 & Serializable & scala.Serializable)log -> BoxesRunTime.boxToLong((long)LogCleanerManager.$anonfun$new$10(lastClean$1, tp, now$1, log))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
    }

    public static final /* synthetic */ long $anonfun$new$8(LogCleanerManager $this, File dir$2) {
        long l;
        Option option = $this.uncleanablePartitions().get((Object)dir$2.getAbsolutePath());
        if (option instanceof Some) {
            Set partitions = (Set)((Some)option).value();
            scala.collection.immutable.Map<TopicPartition, Object> lastClean = $this.allCleanerCheckpoints();
            long now = Time.SYSTEM.milliseconds();
            l = BoxesRunTime.unboxToLong((Object)partitions.iterator().map((Function1 & Serializable & scala.Serializable)tp -> BoxesRunTime.boxToLong((long)LogCleanerManager.$anonfun$new$9($this, lastClean, now, tp))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        } else if (None$.MODULE$.equals(option)) {
            l = 0L;
        } else {
            throw new MatchError((Object)option);
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ long kafka$log$LogCleanerManager$$$anonfun$new$7(File dir$2) {
        long l;
        void inLock_lock;
        ReentrantLock reentrantLock = this.lock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        inLock_lock.lock();
        try {
            l = LogCleanerManager.$anonfun$new$8(this, dir$2);
        }
        finally {
            inLock_lock.unlock();
        }
        return l;
    }

    public final /* synthetic */ int kafka$log$LogCleanerManager$$$anonfun$new$12() {
        return (int)((double)100 * this.dirtiestLogCleanableRatio());
    }

    public final /* synthetic */ long kafka$log$LogCleanerManager$$$anonfun$new$13() {
        return Time.SYSTEM.milliseconds() - this.timeOfLastRun();
    }

    public static final /* synthetic */ scala.collection.immutable.Map $anonfun$allCleanerCheckpoints$1(LogCleanerManager $this) {
        return ((TraversableOnce)$this.checkpoints().values().flatMap((Function1 & Serializable & scala.Serializable)checkpoint -> {
            try {
                return checkpoint.read();
            }
            catch (KafkaStorageException e) {
                $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Failed to access checkpoint file ").append(checkpoint.file().getName()).append(" in dir ").append(checkpoint.file().getParentFile().getAbsolutePath()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                return Predef$.MODULE$.Map().empty();
            }
        }, scala.collection.Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ Option $anonfun$cleaningState$1(LogCleanerManager $this, TopicPartition tp$2) {
        return $this.inProgress().get((Object)tp$2);
    }

    public static final /* synthetic */ Option $anonfun$setCleaningState$1(LogCleanerManager $this, TopicPartition tp$3, LogCleaningState state$1) {
        return $this.inProgress().put((Object)tp$3, (Object)state$1);
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$2(Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((UnifiedLog)x0$1._2()).config().compact();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$3(LogCleanerManager $this, Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        TopicPartition topicPartition = (TopicPartition)x0$2._1();
        UnifiedLog log = (UnifiedLog)x0$2._2();
        boolean bl = $this.inProgress().contains((Object)topicPartition) || $this.isUncleanablePartition(log, topicPartition);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$5(LogToClean ltc) {
        return ltc.totalBytes() > 0L;
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$6(LogToClean ltc) {
        return ltc.needCompactionNow() && ltc.cleanableBytes() > 0L || ltc.cleanableRatio() > Predef$.MODULE$.Double2double(ltc.log().config().minCleanableRatio());
    }

    public static final /* synthetic */ Option $anonfun$grabFilthiestCompactedLog$1(LogCleanerManager $this, Time time$1, PreCleanStats preCleanStats$1) {
        long now = time$1.milliseconds();
        $this.timeOfLastRun_$eq(now);
        scala.collection.immutable.Map<TopicPartition, Object> lastClean = $this.allCleanerCheckpoints();
        Iterable dirtyLogs = (Iterable)((TraversableLike)((TraversableLike)((TraversableLike)$this.logs().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$2(x0$1)))).filterNot((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$3($this, x0$2)))).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            LogToClean logToClean;
            if (x0$3 != null) {
                TopicPartition topicPartition = (TopicPartition)x0$3._1();
                UnifiedLog log = (UnifiedLog)x0$3._2();
                try {
                    Option lastCleanOffset = lastClean.get((Object)topicPartition);
                    OffsetsToClean offsetsToClean = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option<Object>)lastCleanOffset, now);
                    if (offsetsToClean.forceUpdateCheckpoint()) {
                        $this.updateCheckpoints(log.parentDirFile(), (Option<Tuple2<TopicPartition, Object>>)Option$.MODULE$.apply((Object)new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToLong((long)offsetsToClean.firstDirtyOffset()))), $this.updateCheckpoints$default$3());
                    }
                    long compactionDelayMs = LogCleanerManager$.MODULE$.maxCompactionDelay(log, offsetsToClean.firstDirtyOffset(), now);
                    preCleanStats$1.updateMaxCompactionDelay(compactionDelayMs);
                    logToClean = new LogToClean(topicPartition, log, offsetsToClean.firstDirtyOffset(), offsetsToClean.firstUncleanableDirtyOffset(), compactionDelayMs > 0L);
                }
                catch (Throwable e) {
                    throw new LogCleaningException(log, new StringBuilder(53).append("Failed to calculate log cleaning stats for partition ").append(topicPartition).toString(), e);
                }
            } else {
                throw new MatchError(null);
            }
            LogToClean logToClean2 = logToClean;
            return logToClean2;
        }, scala.collection.Iterable$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)ltc -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$5(ltc)));
        $this.dirtiestLogCleanableRatio_$eq(dirtyLogs.nonEmpty() ? ((LogToClean)dirtyLogs.max(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).cleanableRatio() : 0.0);
        Iterable cleanableLogs = (Iterable)dirtyLogs.filter((Function1 & Serializable & scala.Serializable)ltc -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$6(ltc)));
        if (cleanableLogs.isEmpty()) {
            return None$.MODULE$;
        }
        preCleanStats$1.recordCleanablePartitions(cleanableLogs.size());
        LogToClean filthiest = (LogToClean)cleanableLogs.max(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
        $this.inProgress().put((Object)filthiest.topicPartition(), (Object)LogCleaningInProgress$.MODULE$);
        return new Some((Object)filthiest);
    }

    public static final /* synthetic */ boolean $anonfun$pauseCleaningForNonCompactedPartitions$2(Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = !((UnifiedLog)x0$1._2()).config().compact();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$pauseCleaningForNonCompactedPartitions$3(LogCleanerManager $this, Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        TopicPartition topicPartition = (TopicPartition)x0$2._1();
        boolean bl = $this.inProgress().contains((Object)topicPartition);
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Iterable $anonfun$pauseCleaningForNonCompactedPartitions$1(LogCleanerManager $this) {
        void var1_1;
        Iterable deletableLogs = (Iterable)((TraversableLike)$this.logs().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$pauseCleaningForNonCompactedPartitions$2(x0$1)))).filterNot((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$pauseCleaningForNonCompactedPartitions$3($this, x0$2)));
        deletableLogs.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            if (x0$3 == null) {
                throw new MatchError(null);
            }
            TopicPartition topicPartition = (TopicPartition)x0$3._1();
            Option option = $this.inProgress().put((Object)topicPartition, (Object)new LogCleaningPaused(1));
            return option;
        });
        return var1_1;
    }

    public static final /* synthetic */ boolean $anonfun$deletableLogs$2(LogCleanerManager $this, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        TopicPartition topicPartition = (TopicPartition)x0$1._1();
        UnifiedLog log = (UnifiedLog)x0$1._2();
        boolean bl = !$this.inProgress().contains((Object)topicPartition) && log.config().compact() && !$this.isUncleanablePartition(log, topicPartition);
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Iterable $anonfun$deletableLogs$1(LogCleanerManager $this) {
        void var1_1;
        Iterable toClean = (Iterable)$this.logs().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$deletableLogs$2($this, x0$1)));
        toClean.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$2._1();
            Option option = $this.inProgress().put((Object)tp, (Object)LogCleaningInProgress$.MODULE$);
            return option;
        });
        return var1_1;
    }

    public static final /* synthetic */ void $anonfun$abortCleaning$1(LogCleanerManager $this, TopicPartition topicPartition$1) {
        $this.abortAndPauseCleaning(topicPartition$1);
        $this.resumeCleaning((Iterable<TopicPartition>)new .colon.colon((Object)topicPartition$1, (List)Nil$.MODULE$));
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$abortAndPauseCleaning$1(LogCleanerManager $this, TopicPartition topicPartition$2) {
        block7: {
            block6: {
                var2_2 = false;
                var3_3 = null;
                var4_4 = $this.inProgress().get((Object)topicPartition$2);
                if (!None$.MODULE$.equals(var4_4)) break block6;
                $this.inProgress().put((Object)topicPartition$2, (Object)new LogCleaningPaused(1));
                break block7;
            }
            if (!(var4_4 instanceof Some)) ** GOTO lbl-1000
            var2_2 = true;
            var3_3 = (Some)var4_4;
            var5_5 = (LogCleaningState)var3_3.value();
            if (LogCleaningInProgress$.MODULE$.equals(var5_5)) {
                $this.inProgress().put((Object)topicPartition$2, (Object)LogCleaningAborted$.MODULE$);
            } else if (var2_2 && (var6_6 = (LogCleaningState)var3_3.value()) instanceof LogCleaningPaused) {
                count = ((LogCleaningPaused)var6_6).pausedCount();
                $this.inProgress().put((Object)topicPartition$2, (Object)new LogCleaningPaused(count + 1));
            } else {
                if (var2_2) {
                    s = (LogCleaningState)var3_3.value();
                    throw new IllegalStateException(new StringBuilder(77).append("Compaction for partition ").append(topicPartition$2).append(" cannot be aborted and paused since it is in ").append(s).append(" state.").toString());
                }
                throw new MatchError((Object)var4_4);
            }
        }
        while (!$this.isCleaningInStatePaused(topicPartition$2)) {
            $this.pausedCleaningCond().await(100L, TimeUnit.MILLISECONDS);
        }
    }

    public static final /* synthetic */ void $anonfun$checkCleaningAborted$1(LogCleanerManager $this, TopicPartition topicPartition$3) {
        if ($this.isCleaningInState(topicPartition$3, LogCleaningAborted$.MODULE$)) {
            throw new LogCleaningAbortedException();
        }
    }

    public static final /* synthetic */ boolean $anonfun$updateCheckpoints$2(LogCleanerManager $this, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        TopicPartition tp = (TopicPartition)x0$1._1();
        boolean bl = $this.logs().keys().contains((Object)tp);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$updateCheckpoints$1(LogCleanerManager $this, File dataDir$1, Option partitionToRemove$1, Option partitionToUpdateOrAdd$1) {
        OffsetCheckpointFile checkpoint = (OffsetCheckpointFile)$this.checkpoints().apply((Object)dataDir$1);
        if (checkpoint != null) {
            try {
                scala.collection.immutable.Map map;
                scala.collection.immutable.Map map2;
                scala.collection.immutable.Map currentCheckpoint = ((TraversableOnce)checkpoint.read().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$updateCheckpoints$2($this, x0$1)))).toMap(Predef$.MODULE$.$conforms());
                if (partitionToRemove$1 instanceof Some) {
                    TopicPartition topicPartition = (TopicPartition)((Some)partitionToRemove$1).value();
                    map2 = (scala.collection.immutable.Map)currentCheckpoint.$minus((Object)topicPartition);
                } else if (None$.MODULE$.equals(partitionToRemove$1)) {
                    map2 = currentCheckpoint;
                } else {
                    throw new MatchError((Object)partitionToRemove$1);
                }
                if (partitionToUpdateOrAdd$1 instanceof Some) {
                    Tuple2 updatedOffset = (Tuple2)((Some)partitionToUpdateOrAdd$1).value();
                    map = map2.$plus(updatedOffset);
                } else if (None$.MODULE$.equals(partitionToUpdateOrAdd$1)) {
                    map = map2;
                } else {
                    throw new MatchError((Object)partitionToUpdateOrAdd$1);
                }
                checkpoint.write((Map<TopicPartition, Object>)map);
                return;
            }
            catch (KafkaStorageException e) {
                $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Failed to access checkpoint file ").append(checkpoint.file().getName()).append(" in dir ").append(checkpoint.file().getParentFile().getAbsolutePath()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                return;
            }
        }
    }

    public static final /* synthetic */ void $anonfun$alterCheckpointDir$1(LogCleanerManager $this, File sourceLogDir$1, TopicPartition topicPartition$4, File destLogDir$1) {
        try {
            Option option = $this.checkpoints().get((Object)sourceLogDir$1).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.read().get((Object)topicPartition$4));
            if (option instanceof Some) {
                long offset = BoxesRunTime.unboxToLong((Object)((Some)option).value());
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("Removing the partition offset data in checkpoint file for '").append(topicPartition$4).append("' ").append("from ").append(sourceLogDir$1.getAbsoluteFile()).append(" directory.").toString());
                Option x$22 = Option$.MODULE$.apply((Object)topicPartition$4);
                Option<Tuple2<TopicPartition, Object>> x$3 = $this.updateCheckpoints$default$2();
                $this.updateCheckpoints(sourceLogDir$1, x$3, (Option<TopicPartition>)x$22);
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(73).append("Adding the partition offset data in checkpoint file for '").append(topicPartition$4).append("' ").append("to ").append(destLogDir$1.getAbsoluteFile()).append(" directory.").toString());
                $this.updateCheckpoints(destLogDir$1, (Option<Tuple2<TopicPartition, Object>>)Option$.MODULE$.apply((Object)new Tuple2((Object)topicPartition$4, (Object)BoxesRunTime.boxToLong((long)offset))), $this.updateCheckpoints$default$3());
            } else if (!None$.MODULE$.equals(option)) {
                throw new MatchError((Object)option);
            }
        }
        catch (KafkaStorageException e) {
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Failed to access checkpoint file in dir ").append(sourceLogDir$1.getAbsolutePath()).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
        }
        Set logUncleanablePartitions = (Set)$this.uncleanablePartitions().getOrElse((Object)sourceLogDir$1.toString(), (Function0 & Serializable & scala.Serializable)() -> (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$));
        if (logUncleanablePartitions.contains((Object)topicPartition$4)) {
            logUncleanablePartitions.remove((Object)topicPartition$4);
            $this.markPartitionUncleanable(destLogDir$1.toString(), topicPartition$4);
        }
    }

    public static final /* synthetic */ boolean $anonfun$handleLogDirFailure$3(String dir$3, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        String string = ((File)x0$1._1()).getAbsolutePath();
        boolean bl = string == null ? dir$3 != null : !string.equals(dir$3);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$maybeTruncateCheckpoint$1(LogCleanerManager $this, TopicPartition topicPartition$5, File dataDir$2, long offset$1) {
        Map<TopicPartition, Object> existing;
        OffsetCheckpointFile checkpoint;
        if ($this.logs().get(topicPartition$5).config().compact() && (checkpoint = (OffsetCheckpointFile)$this.checkpoints().apply((Object)dataDir$2)) != null && BoxesRunTime.unboxToLong((Object)(existing = checkpoint.read()).getOrElse((Object)topicPartition$5, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)) > offset$1) {
            checkpoint.write((Map<TopicPartition, Object>)((Map)((MapLike)((Growable)Map$.MODULE$.apply((Seq)Nil$.MODULE$)).$plus$plus$eq(existing)).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition$5), (Object)BoxesRunTime.boxToLong((long)offset$1)))));
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ Object $anonfun$doneCleaning$1(LogCleanerManager $this, TopicPartition topicPartition$6, File dataDir$3, long endOffset$1) {
        LogCleaningState logCleaningState;
        boolean bl = false;
        Some some = null;
        Option option = $this.inProgress().get((Object)topicPartition$6);
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            LogCleaningState logCleaningState2 = (LogCleaningState)some.value();
            if (LogCleaningInProgress$.MODULE$.equals(logCleaningState2)) {
                $this.updateCheckpoints(dataDir$3, (Option<Tuple2<TopicPartition, Object>>)Option$.MODULE$.apply((Object)new Tuple2((Object)topicPartition$6, (Object)BoxesRunTime.boxToLong((long)endOffset$1))), $this.updateCheckpoints$default$3());
                return $this.inProgress().remove((Object)topicPartition$6);
            }
        }
        if (bl && LogCleaningAborted$.MODULE$.equals(logCleaningState = (LogCleaningState)some.value())) {
            $this.inProgress().put((Object)topicPartition$6, (Object)new LogCleaningPaused(1));
            $this.pausedCleaningCond().signalAll();
            return BoxedUnit.UNIT;
        }
        if (!None$.MODULE$.equals(option)) throw new IllegalStateException(new StringBuilder(43).append("In-progress partition ").append(topicPartition$6).append(" cannot be in ").append(option).append(" state.").toString());
        throw new IllegalStateException(new StringBuilder(34).append("State for partition ").append(topicPartition$6).append(" should exist.").toString());
    }

    public static final /* synthetic */ Object $anonfun$markPartitionUncleanable$1(LogCleanerManager $this, String logDir$2, TopicPartition partition$1) {
        Boolean bl;
        Option option = $this.uncleanablePartitions().get((Object)logDir$2);
        if (option instanceof Some) {
            bl = BoxesRunTime.boxToBoolean((boolean)((Set)((Some)option).value()).add((Object)partition$1));
        } else if (None$.MODULE$.equals(option)) {
            bl = $this.uncleanablePartitions().put((Object)logDir$2, (Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition$1})));
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$isUncleanablePartition$1(LogCleanerManager $this, UnifiedLog log$1, TopicPartition topicPartition$7) {
        return $this.uncleanablePartitions().get((Object)log$1.parentDir()).exists((Function1 & Serializable & scala.Serializable)partitions -> BoxesRunTime.boxToBoolean((boolean)partitions.contains((Object)topicPartition$7)));
    }

    public static final /* synthetic */ boolean $anonfun$maintainUncleanablePartitions$3(LogCleanerManager $this, TopicPartition x$3) {
        return $this.logs().contains(x$3);
    }

    public static final /* synthetic */ void $anonfun$maintainUncleanablePartitions$2(LogCleanerManager $this, Set partitions) {
        ((TraversableOnce)partitions.filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$maintainUncleanablePartitions$3($this, x$3)))).toList().foreach((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)partitions.remove((Object)x$4)));
    }

    public static final /* synthetic */ boolean $anonfun$maintainUncleanablePartitions$5(Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((Set)x0$1._2()).isEmpty();
        return bl;
    }

    public static final /* synthetic */ void $anonfun$maintainUncleanablePartitions$1(LogCleanerManager $this) {
        $this.uncleanablePartitions().values().foreach((Function1 & Serializable & scala.Serializable)partitions -> {
            LogCleanerManager.$anonfun$maintainUncleanablePartitions$2($this, partitions);
            return BoxedUnit.UNIT;
        });
        ((TraversableOnce)((TraversableLike)$this.uncleanablePartitions().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$maintainUncleanablePartitions$5(x0$1)))).map((Function1 & Serializable & scala.Serializable)x$5 -> (String)x$5._1(), Iterable$.MODULE$.canBuildFrom())).toList().foreach((Function1 & Serializable & scala.Serializable)x$6 -> $this.uncleanablePartitions().remove(x$6));
    }

    public LogCleanerManager(Seq<File> logDirs, Pool<TopicPartition, UnifiedLog> logs, LogDirFailureChannel logDirFailureChannel) {
        this.logDirs = logDirs;
        this.logs = logs;
        this.logDirFailureChannel = logDirFailureChannel;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.offsetCheckpointFile = "cleaner-offset-checkpoint";
        this.checkpoints = ((TraversableOnce)logDirs.map((Function1 & Serializable & scala.Serializable)dir -> new Tuple2(dir, (Object)new OffsetCheckpointFile(new File((File)dir, this.offsetCheckpointFile()), this.logDirFailureChannel())), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.inProgress = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.uncleanablePartitions = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.lock = new ReentrantLock();
        this.pausedCleaningCond = this.lock().newCondition();
        logDirs.foreach((Function1 & Serializable & scala.Serializable)dir -> this.newGauge("uncleanable-partitions-count", new Gauge<Object>(this, dir){
            private final /* synthetic */ LogCleanerManager $outer;
            private final File dir$1;

            public final int value() {
                return this.$outer.kafka$log$LogCleanerManager$$$anonfun$new$2(this.dir$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dir$1 = dir$1;
            }
        }, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logDirectory"), (Object)dir.getAbsolutePath())})))));
        logDirs.foreach((Function1 & Serializable & scala.Serializable)dir -> this.newGauge("uncleanable-bytes", new Gauge<Object>(this, dir){
            private final /* synthetic */ LogCleanerManager $outer;
            private final File dir$2;

            public final long value() {
                return this.$outer.kafka$log$LogCleanerManager$$$anonfun$new$7(this.dir$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dir$2 = dir$2;
            }
        }, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logDirectory"), (Object)dir.getAbsolutePath())})))));
        this.dirtiestLogCleanableRatio = 0.0;
        this.newGauge("max-dirty-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleanerManager $outer;

            public final int value() {
                return this.$outer.kafka$log$LogCleanerManager$$$anonfun$new$12();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.timeOfLastRun = Time.SYSTEM.milliseconds();
        this.newGauge("time-since-last-run-ms", new Gauge<Object>(this){
            private final /* synthetic */ LogCleanerManager $outer;

            public final long value() {
                return this.$outer.kafka$log$LogCleanerManager$$$anonfun$new$13();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
    }
}

