/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import kafka.metrics.KafkaMetricsGroup;
import kafka.network.AbstractServerThread;
import kafka.network.ConnectionQuotas;
import kafka.network.Processor$;
import kafka.network.Processor$ConnectionId$;
import kafka.network.RequestChannel;
import kafka.network.SocketServer$;
import kafka.security.CredentialProvider;
import kafka.server.ApiVersionManager;
import kafka.server.KafkaConfig;
import kafka.utils.CoreUtils$;
import kafka.utils.NotNothing$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Measurable;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.stats.CumulativeSum;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.NetworkSend;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.token.delegation.internals.DelegationTokenCache;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.LinkedHashMap$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0001\u0011}uA\u00027n\u0011\u0003y\u0017O\u0002\u0004t[\"\u0005q\u000e\u001e\u0005\u0006w\u0006!\t! \u0005\b}\u0006\u0011\r\u0011\"\u0001\u0000\u0011!\t\t\"\u0001Q\u0001\n\u0005\u0005\u0001\u0002CA\n\u0003\t\u0007I\u0011A@\t\u0011\u0005U\u0011\u0001)A\u0005\u0003\u0003A\u0001\"a\u0006\u0002\u0005\u0004%\ta \u0005\t\u00033\t\u0001\u0015!\u0003\u0002\u0002!I\u00111D\u0001C\u0002\u0013\u0005\u0011Q\u0004\u0005\t\u0003K\t\u0001\u0015!\u0003\u0002 \u001911/\u001c\u0001p\u0003OA!\"a\u000f\f\u0005\u000b\u0007I\u0011AA\u000f\u0011)\tid\u0003B\u0001B\u0003%\u0011q\u0004\u0005\u000b\u0003\u007fY!\u0011!Q\u0001\n\u0005\u0005\u0003BCA.\u0017\t\u0005\t\u0015!\u0003\u0002 !Q\u0011QL\u0006\u0003\u0002\u0003\u0006I!a\u0018\t\u0015\u0005\u00154B!A!\u0002\u0013\t9\u0007\u0003\u0006\u0002n-\u0011\t\u0011)A\u0005\u0003_B!\"!\u001e\f\u0005\u0003\u0005\u000b\u0011BA\u0010\u0011)\t9h\u0003B\u0001B\u0003%\u0011\u0011\u0010\u0005\u000b\u0003\u0007[!\u0011!Q\u0001\n\u0005\u0015\u0005BCAK\u0017\t\u0005\t\u0015!\u0003\u0002\u0018\"Q\u0011QG\u0006\u0003\u0002\u0003\u0006I!a)\t\u0015\u000556B!A!\u0002\u0013\ty\u000b\u0003\u0006\u0002:.\u0011\t\u0011)A\u0005\u0003wC!\"a2\f\u0005\u0003\u0005\u000b\u0011BAe\u0011)\tym\u0003B\u0001B\u0003%\u0011q\u0004\u0005\u000b\u0003#\\!\u0011!Q\u0001\n\u0005M\u0007BCAm\u0017\t\u0005\t\u0015!\u0003\u0002\\\"11p\u0003C\u0001\u0003C<qAa\u0002\f\u0011\u0013\u0011IAB\u0004\u0003\u000e-AIAa\u0004\t\rm\u0004C\u0011\u0001B\f\u0011\u001d\u0011I\u0002\tC\u0001\u00057A\u0011Ba4!\u0003\u0003%\tI!5\t\u0013\tu\u0007%!A\u0005\u0002\n}ga\u0002B\u0007\u0017\u0001k'Q\u0005\u0005\u000b\u0005[)#Q3A\u0005\u0002\t=\u0002B\u0003B#K\tE\t\u0015!\u0003\u00032!Q!qI\u0013\u0003\u0016\u0004%\t!!\b\t\u0015\t%SE!E!\u0002\u0013\ty\u0002\u0003\u0006\u0003L\u0015\u0012)\u001a!C\u0001\u0005_A!B!\u0014&\u0005#\u0005\u000b\u0011\u0002B\u0019\u0011)\u0011y%\nBK\u0002\u0013\u0005\u0011Q\u0004\u0005\u000b\u0005#*#\u0011#Q\u0001\n\u0005}\u0001B\u0003B*K\tU\r\u0011\"\u0001\u0002\u001e!Q!QK\u0013\u0003\u0012\u0003\u0006I!a\b\t\rm,C\u0011\u0001B,\u0011\u001d\u0011\u0019'\nC!\u0005KB\u0011Ba\u001a&\u0003\u0003%\tA!\u001b\t\u0013\tUT%%A\u0005\u0002\t]\u0004\"\u0003BGKE\u0005I\u0011\u0001BH\u0011%\u0011\u0019*JI\u0001\n\u0003\u00119\bC\u0005\u0003\u0016\u0016\n\n\u0011\"\u0001\u0003\u0010\"I!qS\u0013\u0012\u0002\u0013\u0005!q\u0012\u0005\t\u00053+\u0013\u0011!C!\u007f\"I!1T\u0013\u0002\u0002\u0013\u0005\u0011Q\u0004\u0005\n\u0005;+\u0013\u0011!C\u0001\u0005?C\u0011Ba+&\u0003\u0003%\tE!,\t\u0013\tmV%!A\u0005\u0002\tu\u0006\"\u0003BaK\u0005\u0005I\u0011\tBb\u0011%\u0011)-JA\u0001\n\u0003\u00129\rC\u0005\u0003n.\u0011\r\u0011\"\u0003\u0003p\"A1\u0011C\u0006!\u0002\u0013\u0011\t\u0010C\u0005\u0004\u0014-\u0011\r\u0011\"\u0003\u0004\u0016!A1\u0011G\u0006!\u0002\u0013\u00199\u0002C\u0005\u00044-\u0011\r\u0011\"\u0003\u00046!A1QH\u0006!\u0002\u0013\u00199\u0004\u0003\u0006\u0004@-\u0011\r\u0011\"\u0001p\u0007\u0003B\u0001b!\u0013\fA\u0003%11\t\u0005\n\u0007\u0017Z!\u0019!C\u0001\u0007\u001bB\u0001ba\u0017\fA\u0003%1q\n\u0005\n\u0007;Z!\u0019!C\u0005\u0007?B\u0001b!\u001b\fA\u0003%1\u0011\r\u0005\u000b\u0007WZ!\u0019!C\u0001[\u000e5\u0004\u0002CB;\u0017\u0001\u0006Iaa\u001c\t\u0011\r]4\u0002\"\u0005n\u0007sB\u0011b!\"\f\u0001\u0004%I!!\b\t\u0013\r\u001d5\u00021A\u0005\n\r%\u0005\u0002CBJ\u0017\u0001\u0006K!a\b\t\u000f\rU5\u0002\"\u0011\u0004\u0018\"A1\u0011T\u0006\u0005\u00025\u001cY\nC\u0004\u00048.!Ia!/\t\u000f\r\r7\u0002\"\u0003\u0004\u0018\"A1QY\u0006\u0005\u00125\u001c9\rC\u0004\u0004X.!Iaa&\t\u000f\re7\u0002\"\u0005\u0004\\\"91Q_\u0006\u0005\n\r]\u0005bBB|\u0017\u0011%1q\u0013\u0005\b\u0007s\\A\u0011BB~\u0011\u001d\u0019yp\u0003C\u0005\u0007/Cq\u0001\"\u0001\f\t\u0013\u00199\nC\u0004\u0005\u0004-!I\u0001\"\u0002\t\u000f\u0011-1\u0002\"\u0001\u0005\u000e!9A\u0011G\u0006\u0005\n\r]\u0005b\u0002C\u001a\u0017\u0011%1q\u0013\u0005\t\t\u0013YA\u0011C7\u00056!AAqI\u0006\u0005\u00025$I\u0005C\u0004\u0005N-!I\u0001b\u0014\t\u0011\u0011E3\u0002\"\u0001n\u0003;A\u0001\u0002b\u0015\f\t\u0003i\u0017Q\u0004\u0005\t\t+ZA\u0011A7\u0005X!9A1M\u0006\u0005\n\u0011\u0015\u0004b\u0002CH\u0017\u0011%A\u0011\u0013\u0005\t\t+[A\u0011A7\u0005\u0018\"9A1T\u0006\u0005B\r]\u0005b\u0002CO\u0017\u0011\u00053qS\u0001\n!J|7-Z:t_JT!A\\8\u0002\u000f9,Go^8sW*\t\u0001/A\u0003lC\u001a\\\u0017\r\u0005\u0002s\u00035\tQNA\u0005Qe>\u001cWm]:peN\u0011\u0011!\u001e\t\u0003mfl\u0011a\u001e\u0006\u0002q\u0006)1oY1mC&\u0011!p\u001e\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?\u0007\u0001!\u0012!]\u0001\u0016\u0013\u0012dW\rU3sG\u0016tG/T3ue&\u001cg*Y7f+\t\t\t\u0001\u0005\u0003\u0002\u0004\u00055QBAA\u0003\u0015\u0011\t9!!\u0003\u0002\t1\fgn\u001a\u0006\u0003\u0003\u0017\tAA[1wC&!\u0011qBA\u0003\u0005\u0019\u0019FO]5oO\u00061\u0012\n\u001a7f!\u0016\u00148-\u001a8u\u001b\u0016$(/[2OC6,\u0007%A\rOKR<xN]6Qe>\u001cWm]:pe6+GO]5d)\u0006<\u0017A\u0007(fi^|'o\u001b)s_\u000e,7o]8s\u001b\u0016$(/[2UC\u001e\u0004\u0013!\u0005'jgR,g.\u001a:NKR\u0014\u0018n\u0019+bO\u0006\u0011B*[:uK:,'/T3ue&\u001cG+Y4!\u0003M\u0019uN\u001c8fGRLwN\\)vKV,7+\u001b>f+\t\ty\u0002E\u0002w\u0003CI1!a\tx\u0005\rIe\u000e^\u0001\u0015\u0007>tg.Z2uS>t\u0017+^3vKNK'0\u001a\u0011\u0014\u000b-\tI#a\f\u0011\u0007I\fY#C\u0002\u0002.5\u0014A#\u00112tiJ\f7\r^*feZ,'\u000f\u00165sK\u0006$\u0007\u0003BA\u0019\u0003oi!!a\r\u000b\u0007\u0005Ur.A\u0004nKR\u0014\u0018nY:\n\t\u0005e\u00121\u0007\u0002\u0012\u0017\u000647.Y'fiJL7m]$s_V\u0004\u0018AA5e\u0003\rIG\rI\u0001\u0005i&lW\r\u0005\u0003\u0002D\u0005]SBAA#\u0015\u0011\t9%!\u0013\u0002\u000bU$\u0018\u000e\\:\u000b\t\u0005-\u0013QJ\u0001\u0007G>lWn\u001c8\u000b\u0007A\fyE\u0003\u0003\u0002R\u0005M\u0013AB1qC\u000eDWM\u0003\u0002\u0002V\u0005\u0019qN]4\n\t\u0005e\u0013Q\t\u0002\u0005)&lW-\u0001\bnCb\u0014V-];fgR\u001c\u0016N_3\u0002\u001dI,\u0017/^3ti\u000eC\u0017M\u001c8fYB\u0019!/!\u0019\n\u0007\u0005\rTN\u0001\bSKF,Xm\u001d;DQ\u0006tg.\u001a7\u0002!\r|gN\\3di&|g.U;pi\u0006\u001c\bc\u0001:\u0002j%\u0019\u00111N7\u0003!\r{gN\\3di&|g.U;pi\u0006\u001c\u0018\u0001F2p]:,7\r^5p]Nl\u0015\r_%eY\u0016l5\u000fE\u0002w\u0003cJ1!a\u001dx\u0005\u0011auN\\4\u00027\u0019\f\u0017\u000e\\3e\u0003V$\b.\u001a8uS\u000e\fG/[8o\t\u0016d\u0017-_'t\u00031a\u0017n\u001d;f]\u0016\u0014h*Y7f!\u0011\tY(a \u000e\u0005\u0005u$b\u00018\u0002J%!\u0011\u0011QA?\u00051a\u0015n\u001d;f]\u0016\u0014h*Y7f\u0003A\u0019XmY;sSRL\bK]8u_\u000e|G\u000e\u0005\u0003\u0002\b\u0006EUBAAE\u0015\u0011\tY)!$\u0002\t\u0005,H\u000f\u001b\u0006\u0005\u0003\u001f\u000bI%\u0001\u0005tK\u000e,(/\u001b;z\u0013\u0011\t\u0019*!#\u0003!M+7-\u001e:jif\u0004&o\u001c;pG>d\u0017AB2p]\u001aLw\r\u0005\u0003\u0002\u001a\u0006}UBAAN\u0015\r\tij\\\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005\u0005\u00161\u0014\u0002\f\u0017\u000647.Y\"p]\u001aLw\r\u0005\u0003\u0002&\u0006%VBAAT\u0015\u0011\t)$!\u0013\n\t\u0005-\u0016q\u0015\u0002\b\u001b\u0016$(/[2t\u0003I\u0019'/\u001a3f]RL\u0017\r\u001c)s_ZLG-\u001a:\u0011\t\u0005E\u0016QW\u0007\u0003\u0003gS1!a$p\u0013\u0011\t9,a-\u0003%\r\u0013X\rZ3oi&\fG\u000e\u0015:pm&$WM]\u0001\u000b[\u0016lwN]=Q_>d\u0007\u0003BA_\u0003\u0007l!!a0\u000b\t\u0005\u0005\u0017\u0011J\u0001\u0007[\u0016lwN]=\n\t\u0005\u0015\u0017q\u0018\u0002\u000b\u001b\u0016lwN]=Q_>d\u0017A\u00037pO\u000e{g\u000e^3yiB!\u00111IAf\u0013\u0011\ti-!\u0012\u0003\u00151{wmQ8oi\u0016DH/A\nd_:tWm\u0019;j_:\fV/Z;f'&TX-\u0001\u000bjgB\u0013\u0018N^5mK\u001e,G\rT5ti\u0016tWM\u001d\t\u0004m\u0006U\u0017bAAlo\n9!i\\8mK\u0006t\u0017!E1qSZ+'o]5p]6\u000bg.Y4feB!\u0011\u0011TAo\u0013\u0011\ty.a'\u0003#\u0005\u0003\u0018NV3sg&|g.T1oC\u001e,'\u000f\u0006\u0013\u0002d\u0006\u0015\u0018q]Au\u0003W\fi/a<\u0002r\u0006M\u0018Q_A|\u0003s\fY0!@\u0002\u0000\n\u0005!1\u0001B\u0003!\t\u00118\u0002C\u0004\u0002<y\u0001\r!a\b\t\u000f\u0005}b\u00041\u0001\u0002B!9\u00111\f\u0010A\u0002\u0005}\u0001bBA/=\u0001\u0007\u0011q\f\u0005\b\u0003Kr\u0002\u0019AA4\u0011\u001d\tiG\ba\u0001\u0003_Bq!!\u001e\u001f\u0001\u0004\ty\u0002C\u0004\u0002xy\u0001\r!!\u001f\t\u000f\u0005\re\u00041\u0001\u0002\u0006\"9\u0011Q\u0013\u0010A\u0002\u0005]\u0005bBA\u001b=\u0001\u0007\u00111\u0015\u0005\b\u0003[s\u0002\u0019AAX\u0011\u001d\tIL\ba\u0001\u0003wCq!a2\u001f\u0001\u0004\tI\rC\u0004\u0002Pz\u0001\r!a\b\t\u000f\u0005Eg\u00041\u0001\u0002T\"9\u0011\u0011\u001c\u0010A\u0002\u0005m\u0017\u0001D\"p]:,7\r^5p]&#\u0007c\u0001B\u0006A5\t1B\u0001\u0007D_:tWm\u0019;j_:LEm\u0005\u0003!k\nE\u0001c\u0001<\u0003\u0014%\u0019!QC<\u0003\u0019M+'/[1mSj\f'\r\\3\u0015\u0005\t%\u0011A\u00034s_6\u001cFO]5oOR!!Q\u0004Bf!\u00151(q\u0004B\u0012\u0013\r\u0011\tc\u001e\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007\t-Qe\u0005\u0004&k\n\u001d\"\u0011\u0003\t\u0004m\n%\u0012b\u0001B\u0016o\n9\u0001K]8ek\u000e$\u0018!\u00037pG\u0006d\u0007j\\:u+\t\u0011\t\u0004\u0005\u0003\u00034\t\u0005c\u0002\u0002B\u001b\u0005{\u00012Aa\u000ex\u001b\t\u0011IDC\u0002\u0003<q\fa\u0001\u0010:p_Rt\u0014b\u0001B o\u00061\u0001K]3eK\u001aLA!a\u0004\u0003D)\u0019!qH<\u0002\u00151|7-\u00197I_N$\b%A\u0005m_\u000e\fG\u000eU8si\u0006QAn\\2bYB{'\u000f\u001e\u0011\u0002\u0015I,Wn\u001c;f\u0011>\u001cH/A\u0006sK6|G/\u001a%pgR\u0004\u0013A\u0003:f[>$X\rU8si\u0006Y!/Z7pi\u0016\u0004vN\u001d;!\u0003\u0015Ig\u000eZ3y\u0003\u0019Ig\u000eZ3yAQa!1\u0005B-\u00057\u0012iFa\u0018\u0003b!9!Q\u0006\u0019A\u0002\tE\u0002b\u0002B$a\u0001\u0007\u0011q\u0004\u0005\b\u0005\u0017\u0002\u0004\u0019\u0001B\u0019\u0011\u001d\u0011y\u0005\ra\u0001\u0003?AqAa\u00151\u0001\u0004\ty\"\u0001\u0005u_N#(/\u001b8h)\t\u0011\t$\u0001\u0003d_BLH\u0003\u0004B\u0012\u0005W\u0012iGa\u001c\u0003r\tM\u0004\"\u0003B\u0017eA\u0005\t\u0019\u0001B\u0019\u0011%\u00119E\rI\u0001\u0002\u0004\ty\u0002C\u0005\u0003LI\u0002\n\u00111\u0001\u00032!I!q\n\u001a\u0011\u0002\u0003\u0007\u0011q\u0004\u0005\n\u0005'\u0012\u0004\u0013!a\u0001\u0003?\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003z)\"!\u0011\u0007B>W\t\u0011i\b\u0005\u0003\u0003\u0000\t%UB\u0001BA\u0015\u0011\u0011\u0019I!\"\u0002\u0013Ut7\r[3dW\u0016$'b\u0001BDo\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t-%\u0011\u0011\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0005#SC!a\b\u0003|\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014AD2paf$C-\u001a4bk2$H\u0005N\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00136\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jq\u0006a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002BQ\u0005O\u00032A\u001eBR\u0013\r\u0011)k\u001e\u0002\u0004\u0003:L\b\"\u0003BUu\u0005\u0005\t\u0019AA\u0010\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!q\u0016\t\u0007\u0005c\u00139L!)\u000e\u0005\tM&b\u0001B[o\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\te&1\u0017\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002T\n}\u0006\"\u0003BUy\u0005\u0005\t\u0019\u0001BQ\u0003!A\u0017m\u001d5D_\u0012,GCAA\u0010\u0003\u0019)\u0017/^1mgR!\u00111\u001bBe\u0011%\u0011IKPA\u0001\u0002\u0004\u0011\t\u000bC\u0004\u0003N\n\u0002\rA!\r\u0002\u0003M\fQ!\u00199qYf$BBa\t\u0003T\nU'q\u001bBm\u00057DqA!\f$\u0001\u0004\u0011\t\u0004C\u0004\u0003H\r\u0002\r!a\b\t\u000f\t-3\u00051\u0001\u00032!9!qJ\u0012A\u0002\u0005}\u0001b\u0002B*G\u0001\u0007\u0011qD\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011\tO!;\u0011\u000bY\u0014yBa9\u0011\u001bY\u0014)O!\r\u0002 \tE\u0012qDA\u0010\u0013\r\u00119o\u001e\u0002\u0007)V\u0004H.Z\u001b\t\u0013\t-H%!AA\u0002\t\r\u0012a\u0001=%a\u0005qa.Z<D_:tWm\u0019;j_:\u001cXC\u0001By!\u0019\u0011\u0019P!@\u0004\u00025\u0011!Q\u001f\u0006\u0005\u0005o\u0014I0\u0001\u0006d_:\u001cWO\u001d:f]RTAAa?\u0002\n\u0005!Q\u000f^5m\u0013\u0011\u0011yP!>\u0003%\u0005\u0013(/Y=CY>\u001c7.\u001b8h#V,W/\u001a\t\u0005\u0007\u0007\u0019i!\u0004\u0002\u0004\u0006)!1qAB\u0005\u0003!\u0019\u0007.\u00198oK2\u001c(\u0002BB\u0006\u0003\u0013\t1A\\5p\u0013\u0011\u0019ya!\u0002\u0003\u001bM{7m[3u\u0007\"\fgN\\3m\u0003=qWm^\"p]:,7\r^5p]N\u0004\u0013!E5oM2Lw\r\u001b;SKN\u0004xN\\:fgV\u00111q\u0003\t\t\u00073\u0019yB!\r\u0004$5\u001111\u0004\u0006\u0005\u0007;\u0011\u0019,A\u0004nkR\f'\r\\3\n\t\r\u000521\u0004\u0002\u0004\u001b\u0006\u0004\b\u0003BB\u0013\u0007Wq1A]B\u0014\u0013\r\u0019I#\\\u0001\u000f%\u0016\fX/Z:u\u0007\"\fgN\\3m\u0013\u0011\u0019ica\f\u0003\u0011I+7\u000f]8og\u0016T1a!\u000bn\u0003IIgN\u001a7jO\"$(+Z:q_:\u001cXm\u001d\u0011\u0002\u001bI,7\u000f]8og\u0016\fV/Z;f+\t\u00199\u0004\u0005\u0004\u0003t\u000ee21E\u0005\u0005\u0007w\u0011)PA\nMS:\\W\r\u001a\"m_\u000e\\\u0017N\\4EKF,X-\u0001\bsKN\u0004xN\\:f#V,W/\u001a\u0011\u0002\u00155,GO]5d)\u0006<7/\u0006\u0002\u0004DAA1QIB$\u0003\u0003\t\t!\u0004\u0002\u0003z&!1\u0011\u0005B}\u0003-iW\r\u001e:jGR\u000bwm\u001d\u0011\u0002;\u0015D\b/\u001b:fI\u000e{gN\\3di&|gn]&jY2,GmQ8v]R,\"aa\u0014\u0011\t\rE3qK\u0007\u0003\u0007'RAa!\u0016\u0002(\u0006)1\u000f^1ug&!1\u0011LB*\u00055\u0019U/\\;mCRLg/Z*v[\u0006qR\r\u001f9je\u0016$7i\u001c8oK\u000e$\u0018n\u001c8t\u0017&dG.\u001a3D_VtG\u000fI\u0001(Kb\u0004\u0018N]3e\u0007>tg.Z2uS>t7oS5mY\u0016$7i\\;oi6+GO]5d\u001d\u0006lW-\u0006\u0002\u0004bA!11MB3\u001b\t\tI%\u0003\u0003\u0004h\u0005%#AC'fiJL7MT1nK\u0006AS\r\u001f9je\u0016$7i\u001c8oK\u000e$\u0018n\u001c8t\u0017&dG.\u001a3D_VtG/T3ue&\u001cg*Y7fA\u0005A1/\u001a7fGR|'/\u0006\u0002\u0004pA!\u00111PB9\u0013\u0011\u0019\u0019(! \u0003\u0011M+G.Z2u_J\f\u0011b]3mK\u000e$xN\u001d\u0011\u0002\u001d\r\u0014X-\u0019;f'\u0016dWm\u0019;peR!1qNB>\u0011\u001d\u0019i(\u0014a\u0001\u0007\u007f\nab\u00195b]:,GNQ;jY\u0012,'\u000f\u0005\u0003\u0002|\r\u0005\u0015\u0002BBB\u0003{\u0012ab\u00115b]:,GNQ;jY\u0012,'/A\noKb$8i\u001c8oK\u000e$\u0018n\u001c8J]\u0012,\u00070A\foKb$8i\u001c8oK\u000e$\u0018n\u001c8J]\u0012,\u0007p\u0018\u0013fcR!11RBI!\r18QR\u0005\u0004\u0007\u001f;(\u0001B+oSRD\u0011B!+P\u0003\u0003\u0005\r!a\b\u0002)9,\u0007\u0010^\"p]:,7\r^5p]&sG-\u001a=!\u0003\r\u0011XO\u001c\u000b\u0003\u0007\u0017\u000b\u0001\u0003\u001d:pG\u0016\u001c8/\u0012=dKB$\u0018n\u001c8\u0015\r\r-5QTBQ\u0011\u001d\u0019yJ\u0015a\u0001\u0005c\tA\"\u001a:s_JlUm]:bO\u0016Dqaa)S\u0001\u0004\u0019)+A\u0005uQJ|w/\u00192mKB!1qUBY\u001d\u0011\u0019Ik!,\u000f\t\t]21V\u0005\u0002q&\u00191qV<\u0002\u000fA\f7m[1hK&!11WB[\u0005%!\u0006N]8xC\ndWMC\u0002\u00040^\fq\u0003\u001d:pG\u0016\u001c8o\u00115b]:,G.\u0012=dKB$\u0018n\u001c8\u0015\u0011\r-51XB`\u0007\u0003Dqa!0T\u0001\u0004\u0011\t$A\u0005dQ\u0006tg.\u001a7JI\"91qT*A\u0002\tE\u0002bBBR'\u0002\u00071QU\u0001\u0014aJ|7-Z:t\u001d\u0016<(+Z:q_:\u001cXm]\u0001\rg\u0016tGMU3ta>t7/\u001a\u000b\u0007\u0007\u0017\u001bIm!4\t\u000f\r-W\u000b1\u0001\u0004$\u0005A!/Z:q_:\u001cX\rC\u0004\u0004PV\u0003\ra!5\u0002\u0019I,7\u000f]8og\u0016\u001cVM\u001c3\u0011\t\u0005m41[\u0005\u0005\u0007+\fiH\u0001\u0003TK:$\u0017\u0001\u00029pY2\f!\u0003]1sg\u0016\u0014V-];fgRDU-\u00193feR!1Q\\Bu!\u0011\u0019yn!:\u000e\u0005\r\u0005(\u0002BBr\u0003\u0013\n\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0007O\u001c\tOA\u0007SKF,Xm\u001d;IK\u0006$WM\u001d\u0005\b\u0007W<\u0006\u0019ABw\u0003\u0019\u0011WO\u001a4feB!1q^By\u001b\t\u0019I!\u0003\u0003\u0004t\u000e%!A\u0003\"zi\u0016\u0014UO\u001a4fe\u0006A\u0002O]8dKN\u001c8i\\7qY\u0016$X\r\u001a*fG\u0016Lg/Z:\u0002+A\u0014xnY3tg\u000e{W\u000e\u001d7fi\u0016$7+\u001a8eg\u0006!R\u000f\u001d3bi\u0016\u0014V-];fgRlU\r\u001e:jGN$Baa#\u0004~\"911\u001a.A\u0002\r\r\u0012a\u00059s_\u000e,7o\u001d#jg\u000e|gN\\3di\u0016$\u0017AF2m_N,W\t_2fgN\u001cuN\u001c8fGRLwN\\:\u0002\u000b\rdwn]3\u0015\t\r-Eq\u0001\u0005\b\t\u0013i\u0006\u0019\u0001B\u0019\u00031\u0019wN\u001c8fGRLwN\\%e\u0003\u0019\t7mY3qiRA\u00111\u001bC\b\t'!9\u0002C\u0004\u0005\u0012y\u0003\ra!\u0001\u0002\u001bM|7m[3u\u0007\"\fgN\\3m\u0011\u001d!)B\u0018a\u0001\u0003'\f\u0001\"\\1z\u00052|7m\u001b\u0005\b\t3q\u0006\u0019\u0001C\u000e\u0003a\t7mY3qi>\u0014\u0018\n\u001a7f!\u0016\u00148-\u001a8u\u001b\u0016$XM\u001d\t\u0005\t;!i#\u0004\u0002\u0005 )!A\u0011\u0005C\u0012\u0003\u0011\u0019wN]3\u000b\t\u0005UBQ\u0005\u0006\u0005\tO!I#\u0001\u0004zC6lWM\u001d\u0006\u0003\tW\t1aY8n\u0013\u0011!y\u0003b\b\u0003\u000b5+G/\u001a:\u0002/\r|gNZ5hkJ,g*Z<D_:tWm\u0019;j_:\u001c\u0018\u0001C2m_N,\u0017\t\u001c7\u0015\t\tEBq\u0007\u0005\b\ts\t\u0007\u0019\u0001C\u001e\u0003\u0019\u0019xnY6fiB!AQ\bC\"\u001b\t!yD\u0003\u0003\u0005B\u0005%\u0011a\u00018fi&!AQ\tC \u0005\u0019\u0019vnY6fi\u0006yQM\\9vKV,'+Z:q_:\u001cX\r\u0006\u0003\u0004\f\u0012-\u0003bBBfE\u0002\u000711E\u0001\u0010I\u0016\fX/Z;f%\u0016\u001c\bo\u001c8tKR\u001111E\u0001\u0012e\u0016\u001c\bo\u001c8tKF+X-^3TSj,\u0017!F5oM2Lw\r\u001b;SKN\u0004xN\\:f\u0007>,h\u000e^\u0001\u0015_B,gn\u0014:DY>\u001c\u0018N\\4DQ\u0006tg.\u001a7\u0015\t\u0011eC\u0011\r\t\u0006m\n}A1\f\t\u0005\u0003w\"i&\u0003\u0003\u0005`\u0005u$\u0001D&bM.\f7\t[1o]\u0016d\u0007b\u0002C\u0005M\u0002\u0007!\u0011G\u0001\u0017Q\u0006tG\r\\3DQ\u0006tg.\u001a7NkR,WI^3oiR111\u0012C4\tSBq\u0001\"\u0003h\u0001\u0004\u0011\t\u0004C\u0004\u0005l\u001d\u0004\r\u0001\"\u001c\u0002\u000b\u00154XM\u001c;\u0011\t\u0011=D\u0011\u0012\b\u0005\tc\")I\u0004\u0003\u0005t\u0011\re\u0002\u0002C;\t\u0003sA\u0001b\u001e\u0005\u00009!A\u0011\u0010C?\u001d\u0011\u00119\u0004b\u001f\n\u0005\u0005U\u0013\u0002BA)\u0003'J1\u0001]A(\u0013\u0011\tY%!\u0014\n\u00079\fI%\u0003\u0003\u0005\b\u0006u\u0014\u0001D&bM.\f7\t[1o]\u0016d\u0017\u0002\u0002CF\t\u001b\u0013\u0001c\u00115b]:,G.T;uK\u00163XM\u001c;\u000b\t\u0011\u001d\u0015QP\u0001\u0011iJLXK\\7vi\u0016\u001c\u0005.\u00198oK2$Baa#\u0005\u0014\"9A\u0011\u00025A\u0002\tE\u0012aB2iC:tW\r\u001c\u000b\u0005\t3\"I\nC\u0004\u0005\n%\u0004\rA!\r\u0002\r]\f7.Z;q\u0003AIg.\u001b;jCR,7\u000b[;uI><h\u000e")
public class Processor
extends AbstractServerThread
implements KafkaMetricsGroup {
    private volatile Processor$ConnectionId$ ConnectionId$module;
    private final int id;
    private final Time time;
    private final int maxRequestSize;
    private final RequestChannel requestChannel;
    private final ConnectionQuotas connectionQuotas;
    private final long connectionsMaxIdleMs;
    private final int failedAuthenticationDelayMs;
    private final ListenerName listenerName;
    private final SecurityProtocol securityProtocol;
    private final KafkaConfig config;
    private final Metrics metrics;
    private final MemoryPool memoryPool;
    private final LogContext logContext;
    private final int connectionQueueSize;
    private final boolean isPrivilegedListener;
    private final ApiVersionManager apiVersionManager;
    private final ArrayBlockingQueue<SocketChannel> newConnections;
    private final scala.collection.mutable.Map<String, RequestChannel.Response> inflightResponses;
    private final LinkedBlockingDeque<RequestChannel.Response> responseQueue;
    private final java.util.Map<String, String> metricTags;
    private final CumulativeSum expiredConnectionsKilledCount;
    private final MetricName expiredConnectionsKilledCountMetricName;
    private final Selector selector;
    private int nextConnectionIndex;

    public static int ConnectionQueueSize() {
        return Processor$.MODULE$.ConnectionQueueSize();
    }

    public static String ListenerMetricTag() {
        return Processor$.MODULE$.ListenerMetricTag();
    }

    public static String NetworkProcessorMetricTag() {
        return Processor$.MODULE$.NetworkProcessorMetricTag();
    }

    public static String IdlePercentMetricName() {
        return Processor$.MODULE$.IdlePercentMetricName();
    }

    @Override
    public com.yammer.metrics.core.MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public com.yammer.metrics.core.MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Meter newMeter(com.yammer.metrics.core.MetricName metricName, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup.newMeter$(this, metricName, eventType, timeUnit);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    private Processor$ConnectionId$ ConnectionId() {
        if (this.ConnectionId$module == null) {
            this.ConnectionId$lzycompute$1();
        }
        return this.ConnectionId$module;
    }

    public int id() {
        return this.id;
    }

    private ArrayBlockingQueue<SocketChannel> newConnections() {
        return this.newConnections;
    }

    private scala.collection.mutable.Map<String, RequestChannel.Response> inflightResponses() {
        return this.inflightResponses;
    }

    private LinkedBlockingDeque<RequestChannel.Response> responseQueue() {
        return this.responseQueue;
    }

    public java.util.Map<String, String> metricTags() {
        return this.metricTags;
    }

    public CumulativeSum expiredConnectionsKilledCount() {
        return this.expiredConnectionsKilledCount;
    }

    private MetricName expiredConnectionsKilledCountMetricName() {
        return this.expiredConnectionsKilledCountMetricName;
    }

    public Selector selector() {
        return this.selector;
    }

    public Selector createSelector(ChannelBuilder channelBuilder) {
        if (channelBuilder instanceof Reconfigurable) {
            this.config.addReconfigurable((Reconfigurable)channelBuilder);
        }
        return new Selector(this.maxRequestSize, this.connectionsMaxIdleMs, this.failedAuthenticationDelayMs, this.metrics, this.time, "socket-server", this.metricTags(), false, true, channelBuilder, this.memoryPool, this.logContext);
    }

    private int nextConnectionIndex() {
        return this.nextConnectionIndex;
    }

    private void nextConnectionIndex_$eq(int x$1) {
        this.nextConnectionIndex = x$1;
    }

    @Override
    public void run() {
        this.startupComplete();
        try {
            while (this.isRunning()) {
                try {
                    this.configureNewConnections();
                    this.processNewResponses();
                    this.poll();
                    this.processCompletedReceives();
                    this.processCompletedSends();
                    this.processDisconnected();
                    this.closeExcessConnections();
                }
                catch (Throwable e) {
                    this.processException("Processor got uncaught exception.", e);
                }
            }
        }
        finally {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Closing selector - processor ").append(this.id()).toString());
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.closeAll(), this, Level.ERROR);
            this.shutdownComplete();
        }
    }

    public void processException(String errorMessage, Throwable throwable) {
        if (throwable instanceof ControlThrowable) {
            throw (Throwable)((ControlThrowable)throwable);
        }
        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMessage, (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable);
    }

    private void processChannelException(String channelId, String errorMessage, Throwable throwable) {
        if (this.openOrClosingChannel(channelId).isDefined()) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Closing socket for ").append(channelId).append(" because of error").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable);
            this.close(channelId);
        }
        this.processException(errorMessage, throwable);
    }

    private void processNewResponses() {
        RequestChannel.Response currentResponse;
        while ((currentResponse = this.dequeueResponse()) != null) {
            String channelId = currentResponse.request().context().connectionId;
            try {
                if (currentResponse instanceof RequestChannel.NoOpResponse) {
                    RequestChannel.NoOpResponse noOpResponse = (RequestChannel.NoOpResponse)currentResponse;
                    this.updateRequestMetrics(noOpResponse);
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Socket server received empty response to send, registering for read: ").append(noOpResponse).toString());
                    this.handleChannelMuteEvent(channelId, KafkaChannel.ChannelMuteEvent.RESPONSE_SENT);
                    this.tryUnmuteChannel(channelId);
                    continue;
                }
                if (currentResponse instanceof RequestChannel.SendResponse) {
                    RequestChannel.SendResponse sendResponse = (RequestChannel.SendResponse)currentResponse;
                    this.sendResponse(sendResponse, sendResponse.responseSend());
                    continue;
                }
                if (currentResponse instanceof RequestChannel.CloseConnectionResponse) {
                    RequestChannel.CloseConnectionResponse closeConnectionResponse = (RequestChannel.CloseConnectionResponse)currentResponse;
                    this.updateRequestMetrics(closeConnectionResponse);
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Closing socket connection actively according to the response code.");
                    this.close(channelId);
                    continue;
                }
                if (currentResponse instanceof RequestChannel.StartThrottlingResponse) {
                    this.handleChannelMuteEvent(channelId, KafkaChannel.ChannelMuteEvent.THROTTLE_STARTED);
                    continue;
                }
                if (currentResponse instanceof RequestChannel.EndThrottlingResponse) {
                    this.handleChannelMuteEvent(channelId, KafkaChannel.ChannelMuteEvent.THROTTLE_ENDED);
                    this.tryUnmuteChannel(channelId);
                    continue;
                }
                throw new IllegalArgumentException(new StringBuilder(23).append("Unknown response type: ").append(currentResponse.getClass()).toString());
            }
            catch (Throwable e) {
                this.processChannelException(channelId, new StringBuilder(40).append("Exception while processing response for ").append(channelId).toString(), e);
            }
        }
    }

    public void sendResponse(RequestChannel.Response response, Send responseSend) {
        String connectionId = response.request().context().connectionId;
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(85).append("Socket server received response to send to ").append(connectionId).append(", registering for write and sending data: ").append(response).toString());
        if (this.channel(connectionId).isEmpty()) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(93).append("Attempting to send response via channel for which there is no open connection, connection id ").append(connectionId).toString());
            response.request().updateRequestMetrics(0L, response);
        }
        if (this.openOrClosingChannel(connectionId).isDefined()) {
            this.selector().send(new NetworkSend(connectionId, responseSend));
            this.inflightResponses().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)connectionId), (Object)response));
        }
    }

    private void poll() {
        int pollTimeout = this.newConnections().isEmpty() ? 300 : 0;
        try {
            this.selector().poll((long)pollTimeout);
            return;
        }
        catch (Throwable throwable) {
            boolean bl = throwable instanceof IllegalStateException ? true : throwable instanceof IOException;
            if (bl) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Processor ").append(this.id()).append(" poll failed").toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> throwable);
                return;
            }
            throw throwable;
        }
    }

    public RequestHeader parseRequestHeader(ByteBuffer buffer) {
        RequestHeader header = RequestHeader.parse((ByteBuffer)buffer);
        if (this.apiVersionManager.isApiEnabled(header.apiKey())) {
            return header;
        }
        throw new InvalidRequestException(new StringBuilder(46).append("Received request api key ").append(header.apiKey()).append(" which is not enabled").toString());
    }

    private void processCompletedReceives() {
        this.selector().completedReceives().forEach(receive -> {
            block9: {
                try {
                    Option<KafkaChannel> option = this.openOrClosingChannel(receive.source());
                    if (option instanceof Some) {
                        KafkaChannel channel = (KafkaChannel)((Some)option).value();
                        RequestHeader header = this.parseRequestHeader(receive.payload());
                        ApiKeys apiKeys = header.apiKey();
                        ApiKeys apiKeys2 = ApiKeys.SASL_HANDSHAKE;
                        if (!(apiKeys != null ? !apiKeys.equals(apiKeys2) : apiKeys2 != null) && channel.maybeBeginServerReauthentication(receive, () -> Predef$.MODULE$.long2Long($this.time.nanoseconds()))) {
                            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Begin re-authentication: ").append(channel).toString());
                        } else {
                            long nowNanos = $this.time.nanoseconds();
                            if (channel.serverAuthenticationSessionExpired(nowNanos)) {
                                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Disconnecting expired channel: ").append(channel).append(" : ").append(header).toString());
                                this.close(channel.id());
                                this.expiredConnectionsKilledCount().record(null, 1.0, 0L);
                            } else {
                                ApiVersionsRequest apiVersionsRequest;
                                String connectionId = receive.source();
                                RequestContext context = new RequestContext(header, connectionId, channel.socketAddress(), channel.principal(), $this.listenerName, $this.securityProtocol, channel.channelMetadataRegistry().clientInformation(), $this.isPrivilegedListener, channel.principalSerde());
                                RequestChannel.Request req = new RequestChannel.Request(this.id(), context, nowNanos, $this.memoryPool, receive.payload(), $this.requestChannel.metrics(), (Option<RequestChannel.Request>)None$.MODULE$);
                                ApiKeys apiKeys3 = header.apiKey();
                                ApiKeys apiKeys4 = ApiKeys.API_VERSIONS;
                                if (!(apiKeys3 != null ? !apiKeys3.equals(apiKeys4) : apiKeys4 != null) && (apiVersionsRequest = (ApiVersionsRequest)req.body(ClassTag$.MODULE$.apply(ApiVersionsRequest.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()))).isValid()) {
                                    channel.channelMetadataRegistry().registerClientInformation(new ClientInformation(apiVersionsRequest.data().clientSoftwareName(), apiVersionsRequest.data().clientSoftwareVersion()));
                                }
                                $this.requestChannel.sendRequest(req);
                                this.selector().mute(connectionId);
                                this.handleChannelMuteEvent(connectionId, KafkaChannel.ChannelMuteEvent.REQUEST_RECEIVED);
                            }
                        }
                        break block9;
                    }
                    if (None$.MODULE$.equals(option)) {
                        throw new IllegalStateException(new StringBuilder(66).append("Channel ").append(receive.source()).append(" removed from selector before processing completed receive").toString());
                    }
                    throw new MatchError(option);
                }
                catch (Throwable e) {
                    this.processChannelException(receive.source(), new StringBuilder(40).append("Exception while processing request from ").append(receive.source()).toString(), e);
                }
            }
        });
        this.selector().clearCompletedReceives();
    }

    private void processCompletedSends() {
        this.selector().completedSends().forEach(send -> {
            try {
                RequestChannel.Response response = (RequestChannel.Response)this.inflightResponses().remove((Object)send.destinationId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new IllegalStateException(new StringBuilder(51).append("Send for ").append(send.destinationId()).append(" completed, but not in `inflightResponses`").toString());
                });
                this.updateRequestMetrics(response);
                response.onComplete().foreach((Function1 & Serializable & scala.Serializable)onComplete -> {
                    onComplete.apply(send);
                    return BoxedUnit.UNIT;
                });
                this.handleChannelMuteEvent(send.destinationId(), KafkaChannel.ChannelMuteEvent.RESPONSE_SENT);
                this.tryUnmuteChannel(send.destinationId());
                return;
            }
            catch (Throwable e) {
                this.processChannelException(send.destinationId(), new StringBuilder(45).append("Exception while processing completed send to ").append(send.destinationId()).toString(), e);
                return;
            }
        });
        this.selector().clearCompletedSends();
    }

    private void updateRequestMetrics(RequestChannel.Response response) {
        RequestChannel.Request request = response.request();
        long networkThreadTimeNanos = BoxesRunTime.unboxToLong((Object)this.openOrClosingChannel(request.context().connectionId).fold((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L, (Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToLong((long)x$16.getAndResetNetworkThreadTimeNanos())));
        request.updateRequestMetrics(networkThreadTimeNanos, response);
    }

    private void processDisconnected() {
        this.selector().disconnected().keySet().forEach(connectionId -> {
            try {
                String remoteHost = ((ConnectionId)this.ConnectionId().fromString((String)connectionId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new IllegalStateException(new StringBuilder(36).append("connectionId has unexpected format: ").append((String)connectionId).toString());
                })).remoteHost();
                this.inflightResponses().remove(connectionId).foreach((Function1 & Serializable & scala.Serializable)response -> {
                    this.updateRequestMetrics(response);
                    return BoxedUnit.UNIT;
                });
                $this.connectionQuotas.dec($this.listenerName, InetAddress.getByName(remoteHost));
                return;
            }
            catch (Throwable e) {
                this.processException(new StringBuilder(44).append("Exception while processing disconnection of ").append((String)connectionId).toString(), e);
                return;
            }
        });
    }

    private void closeExcessConnections() {
        KafkaChannel channel;
        if (this.connectionQuotas.maxConnectionsExceeded(this.listenerName) && (channel = this.selector().lowestPriorityChannel()) != null) {
            this.close(channel.id());
            return;
        }
    }

    private void close(String connectionId) {
        this.openOrClosingChannel(connectionId).foreach((Function1 & Serializable & scala.Serializable)channel -> {
            Processor.$anonfun$close$2(this, connectionId, channel);
            return BoxedUnit.UNIT;
        });
    }

    public boolean accept(SocketChannel socketChannel, boolean mayBlock, Meter acceptorIdlePercentMeter) {
        boolean accepted;
        boolean bl;
        if (this.newConnections().offer(socketChannel)) {
            bl = true;
        } else if (mayBlock) {
            long startNs = this.time.nanoseconds();
            this.newConnections().put(socketChannel);
            acceptorIdlePercentMeter.mark(this.time.nanoseconds() - startNs);
            bl = true;
        } else {
            bl = accepted = false;
        }
        if (accepted) {
            this.wakeup();
        }
        return accepted;
    }

    private void configureNewConnections() {
        int connectionsProcessed = 0;
        while (connectionsProcessed < this.connectionQueueSize && !this.newConnections().isEmpty()) {
            SocketChannel channel = this.newConnections().poll();
            try {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Processor ").append(this.id()).append(" listening to new connection from ").append(channel.socket().getRemoteSocketAddress()).toString());
                this.selector().register(this.connectionId(channel.socket()), channel);
                ++connectionsProcessed;
            }
            catch (Throwable e) {
                SocketAddress remoteAddress = channel.socket().getRemoteSocketAddress();
                this.close(this.listenerName, channel);
                this.processException(new StringBuilder(34).append("Processor ").append(this.id()).append(" closed connection from ").append(remoteAddress).toString(), e);
            }
        }
    }

    private void closeAll() {
        while (!this.newConnections().isEmpty()) {
            ((AbstractInterruptibleChannel)this.newConnections().poll()).close();
        }
        this.selector().channels().forEach(channel -> this.close(channel.id()));
        this.selector().close();
        this.removeMetric(Processor$.MODULE$.IdlePercentMetricName(), (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.NetworkProcessorMetricTag()), (Object)Integer.toString(this.id()))}))));
    }

    public String connectionId(Socket socket) {
        String localHost = socket.getLocalAddress().getHostAddress();
        int localPort = socket.getLocalPort();
        String remoteHost = socket.getInetAddress().getHostAddress();
        int remotePort = socket.getPort();
        String connId = new ConnectionId(this, localHost, localPort, remoteHost, remotePort, this.nextConnectionIndex()).toString();
        this.nextConnectionIndex_$eq(this.nextConnectionIndex() == Integer.MAX_VALUE ? 0 : this.nextConnectionIndex() + 1);
        return connId;
    }

    public void enqueueResponse(RequestChannel.Response response) {
        this.responseQueue().put(response);
        this.wakeup();
    }

    /*
     * WARNING - void declaration
     */
    private RequestChannel.Response dequeueResponse() {
        void var1_1;
        RequestChannel.Response response = this.responseQueue().poll();
        if (response != null) {
            response.request().responseDequeueTimeNanos_$eq(Time.SYSTEM.nanoseconds());
        }
        return var1_1;
    }

    public int responseQueueSize() {
        return this.responseQueue().size();
    }

    public int inflightResponseCount() {
        return this.inflightResponses().size();
    }

    public Option<KafkaChannel> openOrClosingChannel(String connectionId) {
        return Option$.MODULE$.apply((Object)this.selector().channel(connectionId)).orElse((Function0 & Serializable & scala.Serializable)() -> Option$.MODULE$.apply((Object)this.selector().closingChannel(connectionId)));
    }

    private void handleChannelMuteEvent(String connectionId, KafkaChannel.ChannelMuteEvent event) {
        this.openOrClosingChannel(connectionId).foreach((Function1 & Serializable & scala.Serializable)c -> {
            c.handleChannelMuteEvent(event);
            return BoxedUnit.UNIT;
        });
    }

    private void tryUnmuteChannel(String connectionId) {
        this.openOrClosingChannel(connectionId).foreach((Function1 & Serializable & scala.Serializable)c -> {
            Processor.$anonfun$tryUnmuteChannel$1(this, c);
            return BoxedUnit.UNIT;
        });
    }

    public Option<KafkaChannel> channel(String connectionId) {
        return Option$.MODULE$.apply((Object)this.selector().channel(connectionId));
    }

    @Override
    public void wakeup() {
        this.selector().wakeup();
    }

    @Override
    public void initiateShutdown() {
        super.initiateShutdown();
        this.removeMetric("IdlePercent", (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"networkProcessor"), (Object)Integer.toString(this.id()))}))));
        this.metrics.removeMetric(this.expiredConnectionsKilledCountMetricName());
    }

    private final void ConnectionId$lzycompute$1() {
        synchronized (this) {
            if (this.ConnectionId$module == null) {
                this.ConnectionId$module = new Processor$ConnectionId$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ double $anonfun$new$3(KafkaMetric m) {
        return Math.min(BoxesRunTime.unboxToDouble((Object)m.metricValue()), 1.0);
    }

    public final /* synthetic */ double kafka$network$Processor$$$anonfun$new$1() {
        return BoxesRunTime.unboxToDouble((Object)Option$.MODULE$.apply((Object)this.metrics.metric(this.metrics.metricName("io-wait-ratio", SocketServer$.MODULE$.MetricsGroup(), this.metricTags()))).fold((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, (Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToDouble((double)Processor.$anonfun$new$3(m))));
    }

    public static final /* synthetic */ void $anonfun$processCompletedSends$3(NetworkSend send$1, Function1 onComplete) {
        onComplete.apply((Object)send$1);
    }

    public static final /* synthetic */ void $anonfun$close$2(Processor $this, String connectionId$3, KafkaChannel channel) {
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Closing selector connection ").append(connectionId$3).toString());
        InetAddress address = channel.socketAddress();
        if (address != null) {
            $this.connectionQuotas.dec($this.listenerName, address);
        }
        $this.selector().close(connectionId$3);
        $this.inflightResponses().remove((Object)connectionId$3).foreach((Function1 & Serializable & scala.Serializable)response -> {
            $this.updateRequestMetrics(response);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$tryUnmuteChannel$1(Processor $this, KafkaChannel c) {
        $this.selector().unmute(c.id());
    }

    public Processor(int id, Time time, int maxRequestSize, RequestChannel requestChannel, ConnectionQuotas connectionQuotas, long connectionsMaxIdleMs, int failedAuthenticationDelayMs, ListenerName listenerName, SecurityProtocol securityProtocol, KafkaConfig config, Metrics metrics, CredentialProvider credentialProvider, MemoryPool memoryPool, LogContext logContext, int connectionQueueSize, boolean isPrivilegedListener, ApiVersionManager apiVersionManager) {
        this.id = id;
        this.time = time;
        this.maxRequestSize = maxRequestSize;
        this.requestChannel = requestChannel;
        this.connectionQuotas = connectionQuotas;
        this.connectionsMaxIdleMs = connectionsMaxIdleMs;
        this.failedAuthenticationDelayMs = failedAuthenticationDelayMs;
        this.listenerName = listenerName;
        this.securityProtocol = securityProtocol;
        this.config = config;
        this.metrics = metrics;
        this.memoryPool = memoryPool;
        this.logContext = logContext;
        this.connectionQueueSize = connectionQueueSize;
        this.isPrivilegedListener = isPrivilegedListener;
        this.apiVersionManager = apiVersionManager;
        super(connectionQuotas);
        KafkaMetricsGroup.$init$(this);
        this.newConnections = new ArrayBlockingQueue(connectionQueueSize);
        this.inflightResponses = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.responseQueue = new LinkedBlockingDeque();
        this.metricTags = (java.util.Map)CollectionConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)LinkedHashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.ListenerMetricTag()), (Object)listenerName.value()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.NetworkProcessorMetricTag()), (Object)Integer.toString(id))}))).asJava();
        this.newGauge(Processor$.MODULE$.IdlePercentMetricName(), new Gauge<Object>(this){
            private final /* synthetic */ Processor $outer;

            public final double value() {
                return this.$outer.kafka$network$Processor$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Map<String, String>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Processor$.MODULE$.NetworkProcessorMetricTag()), (Object)Integer.toString(id))}))));
        this.expiredConnectionsKilledCount = new CumulativeSum();
        this.expiredConnectionsKilledCountMetricName = metrics.metricName("expired-connections-killed-count", SocketServer$.MODULE$.MetricsGroup(), this.metricTags());
        metrics.addMetric(this.expiredConnectionsKilledCountMetricName(), (Measurable)this.expiredConnectionsKilledCount());
        this.selector = this.createSelector(ChannelBuilders.serverChannelBuilder((ListenerName)listenerName, (listenerName.equals(config.interBrokerListenerName()) ? 1 : 0) != 0, (SecurityProtocol)securityProtocol, (AbstractConfig)config, (CredentialCache)credentialProvider.credentialCache(), (DelegationTokenCache)credentialProvider.tokenCache(), (Time)time, (LogContext)logContext, () -> $this.apiVersionManager.apiVersionResponse(0)));
        this.nextConnectionIndex = 0;
    }

    public class ConnectionId
    implements Product,
    scala.Serializable {
        private final String localHost;
        private final int localPort;
        private final String remoteHost;
        private final int remotePort;
        private final int index;
        public final /* synthetic */ Processor $outer;

        public String localHost() {
            return this.localHost;
        }

        public int localPort() {
            return this.localPort;
        }

        public String remoteHost() {
            return this.remoteHost;
        }

        public int remotePort() {
            return this.remotePort;
        }

        public int index() {
            return this.index;
        }

        public String toString() {
            return new StringBuilder(4).append(this.localHost()).append(":").append(this.localPort()).append("-").append(this.remoteHost()).append(":").append(this.remotePort()).append("-").append(this.index()).toString();
        }

        public ConnectionId copy(String localHost, int localPort, String remoteHost, int remotePort, int index) {
            return new ConnectionId(this.kafka$network$Processor$ConnectionId$$$outer(), localHost, localPort, remoteHost, remotePort, index);
        }

        public String copy$default$1() {
            return this.localHost();
        }

        public int copy$default$2() {
            return this.localPort();
        }

        public String copy$default$3() {
            return this.remoteHost();
        }

        public int copy$default$4() {
            return this.remotePort();
        }

        public int copy$default$5() {
            return this.index();
        }

        public String productPrefix() {
            return "ConnectionId";
        }

        public int productArity() {
            return 5;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.localHost();
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this.localPort());
                }
                case 2: {
                    return this.remoteHost();
                }
                case 3: {
                    return BoxesRunTime.boxToInteger((int)this.remotePort());
                }
                case 4: {
                    return BoxesRunTime.boxToInteger((int)this.index());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ConnectionId;
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)Statics.anyHash((Object)this.localHost())), (int)this.localPort()), (int)Statics.anyHash((Object)this.remoteHost())), (int)this.remotePort()), (int)this.index()), (int)5);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof ConnectionId)) return false;
            if (((ConnectionId)x$1).kafka$network$Processor$ConnectionId$$$outer() != this.kafka$network$Processor$ConnectionId$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ConnectionId connectionId = (ConnectionId)x$1;
            String string = this.localHost();
            String string2 = connectionId.localHost();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.localPort() != connectionId.localPort()) return false;
            String string3 = this.remoteHost();
            String string4 = connectionId.remoteHost();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (this.remotePort() != connectionId.remotePort()) return false;
            if (this.index() != connectionId.index()) return false;
            if (!connectionId.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ Processor kafka$network$Processor$ConnectionId$$$outer() {
            return this.$outer;
        }

        public ConnectionId(Processor $outer, String localHost, int localPort, String remoteHost, int remotePort, int index) {
            this.localHost = localHost;
            this.localPort = localPort;
            this.remoteHost = remoteHost;
            this.remotePort = remotePort;
            this.index = index;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

