/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import kafka.log.UnifiedLog$;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.KafkaMetadataLog$;
import kafka.raft.KafkaNetworkChannel;
import kafka.raft.KafkaRaftManager$;
import kafka.raft.MetadataLogConfig$;
import kafka.raft.RaftManager;
import kafka.raft.TimingWheelExpirationService;
import kafka.server.KafkaConfig;
import kafka.server.MetaProperties;
import kafka.utils.KafkaScheduler;
import kafka.utils.KafkaScheduler$;
import kafka.utils.Logging;
import kafka.utils.ShutdownableThread;
import kafka.utils.timer.SystemTimer;
import kafka.utils.timer.SystemTimer$;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.ExpirationService;
import org.apache.kafka.raft.FileBasedStateStore;
import org.apache.kafka.raft.KafkaRaftClient;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.NetworkChannel;
import org.apache.kafka.raft.QuorumStateStore;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.raft.RaftRequest;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.server.common.serialization.RecordSerde;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\r\u001dq!B\u001d;\u0011\u0003yd!B!;\u0011\u0003\u0011\u0005\"B%\u0002\t\u0003Qe\u0001B&\u0002\u00011C\u0001bU\u0002\u0003\u0002\u0003\u0006I\u0001\u0016\u0005\tU\u000e\u0011\t\u0011)A\u0005W\")\u0011j\u0001C\u0001m\"1qp\u0001C!\u0003\u0003Aq!!\u0003\u0004\t\u0003\nY\u0001C\u0004\u0002\u0014\r!\t%!\u0006\t\u000f\u0005]\u0011\u0001\"\u0003\u0002\u001a\u0019)\u0011I\u000f\u0001\u00024!Q\u0011\u0011J\u0006\u0003\u0002\u0003\u0006I!a\u0013\t\u0015\u0005]3B!A!\u0002\u0013\tI\u0006\u0003\u0006\u0002`-\u0011\t\u0011)A\u0005\u0003CB!\"a\u001d\f\u0005\u0003\u0005\u000b\u0011BA;\u0011)\tyh\u0003B\u0001B\u0003%\u0011\u0011\u0011\u0005\u000b\u0003\u000f[!\u0011!Q\u0001\n\u0005%\u0005BCAJ\u0017\t\u0005\t\u0015!\u0003\u0002\u0016\"Q\u0011qT\u0006\u0003\u0002\u0003\u0006I!!)\t\u0015\u0005\u001d6B!b\u0001\n\u0003\tI\u000b\u0003\u0006\u0002n.\u0011\t\u0011)A\u0005\u0003WCa!S\u0006\u0005\u0002\u0005=\b\"\u0003B\u0003\u0017\t\u0007I\u0011\u0001B\u0004\u0011!\u0011)b\u0003Q\u0001\n\t%\u0001\"\u0003B\f\u0017\t\u0007I\u0011\u0002B\r\u0011!\u0011\tc\u0003Q\u0001\n\tm\u0001\u0002\u00036\f\u0005\u0004%IAa\t\t\u000f\t\u00152\u0002)A\u0005W\"I!qE\u0006C\u0002\u0013%!\u0011\u0006\u0005\t\u0005cY\u0001\u0015!\u0003\u0003,!I!1G\u0006C\u0002\u0013%!Q\u0007\u0005\t\u0005{Y\u0001\u0015!\u0003\u00038!I!qH\u0006C\u0002\u0013%!\u0011\t\u0005\t\u0005\u0007Z\u0001\u0015!\u0003\u0002\u001c!I!QI\u0006C\u0002\u0013\u0005#q\t\u0005\t\u0005\u001fZ\u0001\u0015!\u0003\u0003J!I!\u0011K\u0006C\u0002\u0013%!1\u000b\u0005\t\u00057Z\u0001\u0015!\u0003\u0003V!I!QL\u0006C\u0002\u0013%!q\f\u0005\t\u0005[Z\u0001\u0015!\u0003\u0003b!I!qN\u0006C\u0002\u0013%!\u0011\u000f\u0005\t\u0005sZ\u0001\u0015!\u0003\u0003t!A1k\u0003b\u0001\n\u0003\u0012Y\b\u0003\u0005\u0003\u0000-\u0001\u000b\u0011\u0002B?\u0011%\u0011\ti\u0003b\u0001\n\u0013\u0011\u0019\t\u0003\u0005\u0003\u0012.\u0001\u000b\u0011\u0002BC\u0011\u001d\u0011\u0019j\u0003C\u0001\u0003\u0003AqA!&\f\t\u0003\t\t\u0001C\u0004\u0003\u0018.!\tE!'\t\u000f\t56\u0002\"\u0011\u00030\"9!Q\\\u0006\u0005\n\t}\u0007b\u0002Bq\u0017\u0011%!1\u001d\u0005\b\u0005K\\A\u0011\u0002Bt\u0011\u001d\u0011Io\u0003C\u0005\u0005WDqAa=\f\t\u0013\u0011)\u0010C\u0004\u0003~.!\tEa@\u0002!-\u000bgm[1SC\u001a$X*\u00198bO\u0016\u0014(BA\u001e=\u0003\u0011\u0011\u0018M\u001a;\u000b\u0003u\nQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002A\u00035\t!H\u0001\tLC\u001a\\\u0017MU1gi6\u000bg.Y4feN\u0011\u0011a\u0011\t\u0003\t\u001ek\u0011!\u0012\u0006\u0002\r\u0006)1oY1mC&\u0011\u0001*\u0012\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005y$\u0001\u0004*bMRLu\u000e\u00165sK\u0006$7CA\u0002N!\tq\u0015+D\u0001P\u0015\t\u0001F(A\u0003vi&d7/\u0003\u0002S\u001f\n\u00112\u000b[;uI><h.\u00192mKRC'/Z1e\u0003\u0019\u0019G.[3oiB\u0012Q+\u0019\t\u0004-v{V\"A,\u000b\u0005mB&BA\u001fZ\u0015\tQ6,\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00029\u0006\u0019qN]4\n\u0005y;&aD&bM.\f'+\u00194u\u00072LWM\u001c;\u0011\u0005\u0001\fG\u0002\u0001\u0003\nE\u0012\t\t\u0011!A\u0003\u0002\r\u00141a\u0018\u00132#\t!w\r\u0005\u0002EK&\u0011a-\u0012\u0002\b\u001d>$\b.\u001b8h!\t!\u0005.\u0003\u0002j\u000b\n\u0019\u0011I\\=\u0002!QD'/Z1e\u001d\u0006lW\r\u0015:fM&D\bC\u00017t\u001d\ti\u0017\u000f\u0005\u0002o\u000b6\tqN\u0003\u0002q}\u00051AH]8pizJ!A]#\u0002\rA\u0013X\rZ3g\u0013\t!XO\u0001\u0004TiJLgn\u001a\u0006\u0003e\u0016#2a^=\u007f!\tA8!D\u0001\u0002\u0011\u0015\u0019f\u00011\u0001{a\tYX\u0010E\u0002W;r\u0004\"\u0001Y?\u0005\u0013\tL\u0018\u0011!A\u0001\u0006\u0003\u0019\u0007\"\u00026\u0007\u0001\u0004Y\u0017A\u00023p/>\u00148\u000e\u0006\u0002\u0002\u0004A\u0019A)!\u0002\n\u0007\u0005\u001dQI\u0001\u0003V]&$\u0018\u0001E5oSRL\u0017\r^3TQV$Hm\\<o)\t\ti\u0001E\u0002E\u0003\u001fI1!!\u0005F\u0005\u001d\u0011un\u001c7fC:\f\u0011\"[:Sk:t\u0017N\\4\u0016\u0005\u00055\u0011AE2sK\u0006$X\rT8h\t&\u0014Xm\u0019;pef$b!a\u0007\u0002,\u0005=\u0002\u0003BA\u000f\u0003Oi!!a\b\u000b\t\u0005\u0005\u00121E\u0001\u0003S>T!!!\n\u0002\t)\fg/Y\u0005\u0005\u0003S\tyB\u0001\u0003GS2,\u0007bBA\u0017\u0015\u0001\u0007\u00111D\u0001\u0007Y><G)\u001b:\t\r\u0005E\"\u00021\u0001l\u0003)awn\u001a#je:\u000bW.Z\u000b\u0005\u0003k\tyd\u0005\u0004\f\u0007\u0006]\u00121\t\t\u0006\u0001\u0006e\u0012QH\u0005\u0004\u0003wQ$a\u0003*bMRl\u0015M\\1hKJ\u00042\u0001YA \t\u0019\t\te\u0003b\u0001G\n\tA\u000bE\u0002O\u0003\u000bJ1!a\u0012P\u0005\u001daunZ4j]\u001e\fa\"\\3uCB\u0013x\u000e]3si&,7\u000f\u0005\u0003\u0002N\u0005MSBAA(\u0015\r\t\t\u0006P\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005U\u0013q\n\u0002\u000f\u001b\u0016$\u0018\r\u0015:pa\u0016\u0014H/[3t\u0003\u0019\u0019wN\u001c4jOB!\u0011QJA.\u0013\u0011\ti&a\u0014\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\fe\u0016\u001cwN\u001d3TKJ$W\r\u0005\u0004\u0002d\u0005=\u0014QH\u0007\u0003\u0003KRA!a\u001a\u0002j\u0005i1/\u001a:jC2L'0\u0019;j_:TA!a\u001b\u0002n\u000511m\\7n_:T1!!\u0015Y\u0013\u0011\t\t(!\u001a\u0003\u0017I+7m\u001c:e'\u0016\u0014H-Z\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o!\u0011\t9(a\u001f\u000e\u0005\u0005e$bAA61&!\u0011QPA=\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fq\u0001^8qS\u000eLE\r\u0005\u0003\u0002x\u0005\r\u0015\u0002BAC\u0003s\u0012A!V;jI\u0006!A/[7f!\u0011\tY)a$\u000e\u0005\u00055%b\u0001)\u0002z%!\u0011\u0011SAG\u0005\u0011!\u0016.\\3\u0002\u000f5,GO]5dgB!\u0011qSAN\u001b\t\tIJ\u0003\u0003\u0002\u0014\u0006e\u0014\u0002BAO\u00033\u0013q!T3ue&\u001c7/A\nuQJ,\u0017\r\u001a(b[\u0016\u0004&/\u001a4jq>\u0003H\u000f\u0005\u0003E\u0003G[\u0017bAAS\u000b\n1q\n\u001d;j_:\fAdY8oiJ|G\u000e\\3s#V|'/^7W_R,'o\u001d$viV\u0014X-\u0006\u0002\u0002,B1\u0011QVA\\\u0003wk!!a,\u000b\t\u0005E\u00161W\u0001\u000bG>t7-\u001e:sK:$(\u0002BA[\u0003G\tA!\u001e;jY&!\u0011\u0011XAX\u0005E\u0019u.\u001c9mKR\f'\r\\3GkR,(/\u001a\t\t\u0003{\u000by,a1\u0002P6\u0011\u00111W\u0005\u0005\u0003\u0003\f\u0019LA\u0002NCB\u0004B!!2\u0002L6\u0011\u0011q\u0019\u0006\u0005\u0003\u0013\f\u0019#\u0001\u0003mC:<\u0017\u0002BAg\u0003\u000f\u0014q!\u00138uK\u001e,'\u000f\u0005\u0003\u0002R\u0006\u001dh\u0002BAj\u0003GtA!!6\u0002b:!\u0011q[Ap\u001d\u0011\tI.!8\u000f\u00079\fY.C\u0001]\u0013\tQ6,\u0003\u0002>3&\u00111\bW\u0005\u0004\u0003K<\u0016A\u0003*bMR\u001cuN\u001c4jO&!\u0011\u0011^Av\u0005-\tE\r\u001a:fgN\u001c\u0006/Z2\u000b\u0007\u0005\u0015x+A\u000fd_:$(o\u001c7mKJ\fVo\u001c:v[Z{G/\u001a:t\rV$XO]3!)Q\t\t0a=\u0002v\u0006]\u0018\u0011`A~\u0003{\fyP!\u0001\u0003\u0004A!\u0001iCA\u001f\u0011\u001d\tIE\u0006a\u0001\u0003\u0017Bq!a\u0016\u0017\u0001\u0004\tI\u0006C\u0004\u0002`Y\u0001\r!!\u0019\t\u000f\u0005Md\u00031\u0001\u0002v!9\u0011q\u0010\fA\u0002\u0005\u0005\u0005bBAD-\u0001\u0007\u0011\u0011\u0012\u0005\b\u0003'3\u0002\u0019AAK\u0011\u001d\tyJ\u0006a\u0001\u0003CCq!a*\u0017\u0001\u0004\tY+A\u0006ba&4VM]:j_:\u001cXC\u0001B\u0005!\u0011\u0011YA!\u0005\u000e\u0005\t5!b\u0001B\b1\u000691\r\\5f]R\u001c\u0018\u0002\u0002B\n\u0005\u001b\u00111\"\u00119j-\u0016\u00148/[8og\u0006a\u0011\r]5WKJ\u001c\u0018n\u001c8tA\u0005Q!/\u00194u\u0007>tg-[4\u0016\u0005\tm\u0001c\u0001,\u0003\u001e%\u0019!qD,\u0003\u0015I\u000bg\r^\"p]\u001aLw-A\u0006sC\u001a$8i\u001c8gS\u001e\u0004S#A6\u0002#QD'/Z1e\u001d\u0006lW\r\u0015:fM&D\b%\u0001\u0006m_\u001e\u001cuN\u001c;fqR,\"Aa\u000b\u0011\t\u0005-%QF\u0005\u0005\u0005_\tiI\u0001\u0006M_\u001e\u001cuN\u001c;fqR\f1\u0002\\8h\u0007>tG/\u001a=uA\u0005I1o\u00195fIVdWM]\u000b\u0003\u0005o\u00012A\u0014B\u001d\u0013\r\u0011Yd\u0014\u0002\u000f\u0017\u000647.Y*dQ\u0016$W\u000f\\3s\u0003)\u00198\r[3ek2,'\u000fI\u0001\bI\u0006$\u0018\rR5s+\t\tY\"\u0001\u0005eCR\fG)\u001b:!\u00035\u0011X\r\u001d7jG\u0006$X\r\u001a'pOV\u0011!\u0011\n\t\u0004-\n-\u0013b\u0001B'/\ni!+\u001a9mS\u000e\fG/\u001a3M_\u001e\faB]3qY&\u001c\u0017\r^3e\u0019><\u0007%\u0001\u0006oKR\u001c\u0005.\u00198oK2,\"A!\u0016\u0011\u0007\u0001\u00139&C\u0002\u0003Zi\u00121cS1gW\u0006tU\r^<pe.\u001c\u0005.\u00198oK2\f1B\\3u\u0007\"\fgN\\3mA\u0005yQ\r\u001f9je\u0006$\u0018n\u001c8US6,'/\u0006\u0002\u0003bA!!1\rB5\u001b\t\u0011)GC\u0002\u0003h=\u000bQ\u0001^5nKJLAAa\u001b\u0003f\tY1+_:uK6$\u0016.\\3s\u0003A)\u0007\u0010]5sCRLwN\u001c+j[\u0016\u0014\b%A\tfqBL'/\u0019;j_:\u001cVM\u001d<jG\u0016,\"Aa\u001d\u0011\u0007\u0001\u0013)(C\u0002\u0003xi\u0012A\u0004V5nS:<w\u000b[3fY\u0016C\b/\u001b:bi&|gnU3sm&\u001cW-\u0001\nfqBL'/\u0019;j_:\u001cVM\u001d<jG\u0016\u0004SC\u0001B?!\u00111V,!\u0010\u0002\u000f\rd\u0017.\u001a8uA\u0005a!/\u00194u\u0013>$\u0006N]3bIV\u0011!Q\u0011\t\u0004\u0005\u000f\u001bab\u0001BE\u00019!!1\u0012BH\u001d\rq'QR\u0005\u0002{%\u00111\bP\u0001\u000ee\u00064G/S8UQJ,\u0017\r\u001a\u0011\u0002\u000fM$\u0018M\u001d;va\u0006A1\u000f[;uI><h.\u0001\u0005sK\u001eL7\u000f^3s)\u0011\t\u0019Aa'\t\u000f\tu\u0015\u00071\u0001\u0003 \u0006AA.[:uK:,'\u000f\u0005\u0004\u0003\"\n\u001d\u0016Q\b\b\u0004-\n\r\u0016b\u0001BS/\u0006Q!+\u00194u\u00072LWM\u001c;\n\t\t%&1\u0016\u0002\t\u0019&\u001cH/\u001a8fe*\u0019!QU,\u0002\u001b!\fg\u000e\u001a7f%\u0016\fX/Z:u)!\u0011\tLa0\u0003P\nM\u0007CBAW\u0003o\u0013\u0019\f\u0005\u0003\u00036\nmVB\u0001B\\\u0015\u0011\u0011I,!\u001f\u0002\u0011A\u0014x\u000e^8d_2LAA!0\u00038\nQ\u0011\t]5NKN\u001c\u0018mZ3\t\u000f\t\u0005'\u00071\u0001\u0003D\u00061\u0001.Z1eKJ\u0004BA!2\u0003L6\u0011!q\u0019\u0006\u0005\u0005\u0013\fI(\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\u0011iMa2\u0003\u001bI+\u0017/^3ti\"+\u0017\rZ3s\u0011\u001d\u0011\tN\ra\u0001\u0005g\u000bqA]3rk\u0016\u001cH\u000fC\u0004\u0003VJ\u0002\rAa6\u0002\u001b\r\u0014X-\u0019;fIRKW.Z't!\r!%\u0011\\\u0005\u0004\u00057,%\u0001\u0002'p]\u001e\fqBY;jY\u0012\u0014\u0016M\u001a;DY&,g\u000e\u001e\u000b\u0003\u0005{\n1CY;jY\u0012tU\r^<pe.\u001c\u0005.\u00198oK2$\"A!\u0016\u0002\u001b\r\u0014X-\u0019;f\t\u0006$\u0018\rR5s)\t\tY\"\u0001\tck&dG-T3uC\u0012\fG/\u0019'pOR\u0011!Q\u001e\t\u0004\u0001\n=\u0018b\u0001Byu\t\u00012*\u00194lC6+G/\u00193bi\u0006dunZ\u0001\u0013EVLG\u000e\u001a(fi^|'o[\"mS\u0016tG\u000f\u0006\u0002\u0003xB!!1\u0002B}\u0013\u0011\u0011YP!\u0004\u0003\u001b9+Go^8sW\u000ec\u0017.\u001a8u\u00039aW-\u00193fe\u0006sG-\u00129pG\",\"a!\u0001\u0011\u0007Y\u001b\u0019!C\u0002\u0004\u0006]\u0013a\u0002T3bI\u0016\u0014\u0018I\u001c3Fa>\u001c\u0007\u000e")
public class KafkaRaftManager<T>
implements RaftManager<T>,
Logging {
    private final MetaProperties metaProperties;
    private final KafkaConfig config;
    private final RecordSerde<T> recordSerde;
    private final TopicPartition topicPartition;
    private final Uuid topicId;
    private final Time time;
    private final Metrics metrics;
    private final CompletableFuture<java.util.Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture;
    private final ApiVersions apiVersions;
    private final RaftConfig raftConfig;
    private final String threadNamePrefix;
    private final LogContext logContext;
    private final KafkaScheduler scheduler;
    private final File dataDir;
    private final ReplicatedLog replicatedLog;
    private final KafkaNetworkChannel netChannel;
    private final SystemTimer expirationTimer;
    private final TimingWheelExpirationService expirationService;
    private final KafkaRaftClient<T> client;
    private final RaftIoThread raftIoThread;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public CompletableFuture<java.util.Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    public ApiVersions apiVersions() {
        return this.apiVersions;
    }

    private RaftConfig raftConfig() {
        return this.raftConfig;
    }

    private String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private KafkaScheduler scheduler() {
        return this.scheduler;
    }

    private File dataDir() {
        return this.dataDir;
    }

    @Override
    public ReplicatedLog replicatedLog() {
        return this.replicatedLog;
    }

    private KafkaNetworkChannel netChannel() {
        return this.netChannel;
    }

    private SystemTimer expirationTimer() {
        return this.expirationTimer;
    }

    private TimingWheelExpirationService expirationService() {
        return this.expirationService;
    }

    @Override
    public KafkaRaftClient<T> client() {
        return this.client;
    }

    private RaftIoThread raftIoThread() {
        return this.raftIoThread;
    }

    public void startup() {
        java.util.Map<Integer, RaftConfig.AddressSpec> voterAddresses = this.controllerQuorumVotersFuture().get();
        ((IterableLike)CollectionConverters$.MODULE$.asScalaSetConverter(voterAddresses.entrySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)voterAddressEntry -> {
            KafkaRaftManager.$anonfun$startup$1(this, voterAddressEntry);
            return BoxedUnit.UNIT;
        });
        this.netChannel().start();
        this.raftIoThread().start();
    }

    public void shutdown() {
        this.expirationService().shutdown();
        this.expirationTimer().shutdown();
        this.raftIoThread().shutdown();
        this.client().close();
        this.scheduler().shutdown();
        this.netChannel().close();
        this.replicatedLog().close();
    }

    @Override
    public void register(RaftClient.Listener<T> listener) {
        this.client().register(listener);
    }

    @Override
    public CompletableFuture<ApiMessage> handleRequest(RequestHeader header, ApiMessage request, long createdTimeMs) {
        RaftRequest.Inbound inboundRequest = new RaftRequest.Inbound(header.correlationId(), request, createdTimeMs);
        this.client().handle(inboundRequest);
        return inboundRequest.completion.thenApply(response -> response.data());
    }

    /*
     * WARNING - void declaration
     */
    private KafkaRaftClient<T> buildRaftClient() {
        void var3_3;
        FileBasedStateStore quorumStateStore = new FileBasedStateStore(new File(this.dataDir(), "quorum-state"));
        OptionalInt nodeId = OptionalInt.of(this.config.nodeId());
        KafkaRaftClient client = new KafkaRaftClient(this.recordSerde, (NetworkChannel)this.netChannel(), this.replicatedLog(), (QuorumStateStore)quorumStateStore, this.time, this.metrics, (ExpirationService)this.expirationService(), this.logContext(), this.metaProperties.clusterId(), nodeId, this.raftConfig());
        client.initialize();
        return var3_3;
    }

    private KafkaNetworkChannel buildNetworkChannel() {
        NetworkClient netClient = this.buildNetworkClient();
        return new KafkaNetworkChannel(this.time, (KafkaClient)netClient, Predef$.MODULE$.Integer2int(this.config.quorumRequestTimeoutMs()), this.threadNamePrefix());
    }

    private File createDataDir() {
        String logDirName = UnifiedLog$.MODULE$.logDirName(this.topicPartition);
        return KafkaRaftManager$.MODULE$.kafka$raft$KafkaRaftManager$$createLogDirectory(new File(this.config.metadataLogDir()), logDirName);
    }

    private KafkaMetadataLog buildMetadataLog() {
        return KafkaMetadataLog$.MODULE$.apply(this.topicPartition, this.topicId, this.dataDir(), this.time, this.scheduler(), MetadataLogConfig$.MODULE$.apply(this.config, 0x800000, 0x800000));
    }

    private NetworkClient buildNetworkClient() {
        ListenerName controllerListenerName = new ListenerName((String)this.config.controllerListenerNames().head());
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)((SecurityProtocol)this.config.effectiveListenerSecurityProtocolMap().getOrElse((Object)controllerListenerName, (Function0 & Serializable & scala.Serializable)() -> SecurityProtocol.forName((String)controllerListenerName.value()))), (JaasContext.Type)JaasContext.Type.SERVER, (AbstractConfig)this.config, (ListenerName)controllerListenerName, (String)this.config.saslMechanismControllerProtocol(), (Time)this.time, (boolean)this.config.saslInterBrokerHandshakeRequestEnable(), (LogContext)this.logContext());
        String metricGroupPrefix = "raft-channel";
        boolean collectPerConnectionMetrics = false;
        Selector selector = new Selector(-1, Predef$.MODULE$.Long2long(this.config.connectionsMaxIdleMs()), this.metrics, this.time, metricGroupPrefix, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().empty()).asJava(), collectPerConnectionMetrics, channelBuilder, this.logContext());
        String clientId = new StringBuilder(12).append("raft-client-").append(this.config.nodeId()).toString();
        int maxInflightRequestsPerConnection = 1;
        int reconnectBackoffMs = 50;
        int reconnectBackoffMsMs = 500;
        boolean discoverBrokerVersions = true;
        return new NetworkClient((Selectable)selector, (MetadataUpdater)new ManualMetadataUpdater(), clientId, maxInflightRequestsPerConnection, (long)reconnectBackoffMs, (long)reconnectBackoffMsMs, -1, Predef$.MODULE$.Integer2int(this.config.socketReceiveBufferBytes()), Predef$.MODULE$.Integer2int(this.config.quorumRequestTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMaxMs()), this.time, discoverBrokerVersions, this.apiVersions(), this.logContext());
    }

    @Override
    public LeaderAndEpoch leaderAndEpoch() {
        return this.client().leaderAndEpoch();
    }

    public static final /* synthetic */ void $anonfun$startup$1(KafkaRaftManager $this, Map.Entry voterAddressEntry) {
        RaftConfig.AddressSpec addressSpec = (RaftConfig.AddressSpec)voterAddressEntry.getValue();
        if (addressSpec instanceof RaftConfig.InetAddressSpec) {
            RaftConfig.InetAddressSpec inetAddressSpec = (RaftConfig.InetAddressSpec)addressSpec;
            $this.netChannel().updateEndpoint(Predef$.MODULE$.Integer2int((Integer)voterAddressEntry.getKey()), inetAddressSpec);
            return;
        }
        if (addressSpec instanceof RaftConfig.UnknownAddressSpec) {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(79).append("Skipping channel update for destination ID: ").append(voterAddressEntry.getKey()).append(" ").append("because of non-routable endpoint: ").append(RaftConfig.NON_ROUTABLE_ADDRESS.toString()).toString());
            return;
        }
        if (addressSpec != null) {
            $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("Unexpected address spec (type: ").append(addressSpec.getClass()).append(") for channel update for ").append("destination ID: ").append(voterAddressEntry.getKey()).toString());
            return;
        }
        throw new MatchError(null);
    }

    public KafkaRaftManager(MetaProperties metaProperties, KafkaConfig config, RecordSerde<T> recordSerde, TopicPartition topicPartition, Uuid topicId, Time time, Metrics metrics, Option<String> threadNamePrefixOpt, CompletableFuture<java.util.Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture) {
        this.metaProperties = metaProperties;
        this.config = config;
        this.recordSerde = recordSerde;
        this.topicPartition = topicPartition;
        this.topicId = topicId;
        this.time = time;
        this.metrics = metrics;
        this.controllerQuorumVotersFuture = controllerQuorumVotersFuture;
        Logging.$init$(this);
        this.apiVersions = new ApiVersions();
        this.raftConfig = new RaftConfig((AbstractConfig)config);
        this.threadNamePrefix = (String)threadNamePrefixOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> "kafka-raft");
        this.logContext = new LogContext(new StringBuilder(22).append("[RaftManager nodeId=").append(config.nodeId()).append("] ").toString());
        this.logIdent_$eq(this.logContext().logPrefix());
        this.scheduler = new KafkaScheduler(1, new StringBuilder(10).append(this.threadNamePrefix()).append("-scheduler").toString(), KafkaScheduler$.MODULE$.$lessinit$greater$default$3());
        this.scheduler().startup();
        this.dataDir = this.createDataDir();
        this.replicatedLog = this.buildMetadataLog();
        this.netChannel = this.buildNetworkChannel();
        this.expirationTimer = new SystemTimer("raft-expiration-executor", SystemTimer$.MODULE$.$lessinit$greater$default$2(), SystemTimer$.MODULE$.$lessinit$greater$default$3(), SystemTimer$.MODULE$.$lessinit$greater$default$4());
        this.expirationService = new TimingWheelExpirationService(this.expirationTimer());
        this.client = this.buildRaftClient();
        this.raftIoThread = new RaftIoThread(this.client(), this.threadNamePrefix());
    }

    public static class RaftIoThread
    extends ShutdownableThread {
        private final KafkaRaftClient<?> client;

        @Override
        public void doWork() {
            this.client.poll();
        }

        @Override
        public boolean initiateShutdown() {
            if (super.initiateShutdown()) {
                this.client.shutdown(5000).whenComplete((x$1, exception) -> {
                    if (exception != null) {
                        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Graceful shutdown of RaftClient failed", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> exception);
                        return;
                    }
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Completed graceful shutdown of RaftClient");
                });
                return true;
            }
            return false;
        }

        @Override
        public boolean isRunning() {
            return this.client.isRunning() && !this.isThreadFailed();
        }

        public RaftIoThread(KafkaRaftClient<?> client, String threadNamePrefix) {
            this.client = client;
            super(new StringBuilder(10).append(threadNamePrefix).append("-io-thread").toString(), false);
        }
    }
}

