/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.LinuxIoMetricsCollector;
import kafka.network.DataPlaneAcceptor$;
import kafka.network.SocketServer;
import kafka.raft.RaftManager;
import kafka.security.CredentialProvider;
import kafka.server.ControllerApis;
import kafka.server.ControllerConfigurationValidator;
import kafka.server.DynamicMetricReporterState;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRaftServer$BrokerRole$;
import kafka.server.KafkaRequestHandlerPool;
import kafka.server.MetaProperties;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.Server;
import kafka.server.Server$SHUTDOWN$;
import kafka.server.Server$SHUTTING_DOWN$;
import kafka.server.Server$STARTED$;
import kafka.server.Server$STARTING$;
import kafka.server.SimpleApiVersionManager;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.security.token.delegation.internals.DelegationTokenCache;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.ConfigurationValidator;
import org.apache.kafka.controller.Controller;
import org.apache.kafka.controller.ControllerMetrics;
import org.apache.kafka.controller.QuorumController;
import org.apache.kafka.controller.QuorumFeatures;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.metadata.authorizer.ClusterMetadataAuthorizer;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import org.apache.kafka.server.policy.CreateTopicPolicy;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r5e\u0001\u0002'N\u0001IC\u0001\"\u001a\u0001\u0003\u0006\u0004%\tA\u001a\u0005\tW\u0002\u0011\t\u0011)A\u0005O\"AA\u000e\u0001BC\u0002\u0013\u0005Q\u000e\u0003\u0005r\u0001\t\u0005\t\u0015!\u0003o\u0011!\u0011\bA!b\u0001\n\u0003\u0019\b\"CA\u0007\u0001\t\u0005\t\u0015!\u0003u\u0011)\ty\u0001\u0001BC\u0002\u0013\u0005\u0011\u0011\u0003\u0005\u000b\u0003?\u0001!\u0011!Q\u0001\n\u0005M\u0001\"\u00032\u0001\u0005\u000b\u0007I\u0011AA\u0011\u0011)\ti\u0003\u0001B\u0001B\u0003%\u00111\u0005\u0005\u000b\u0003_\u0001!Q1A\u0005\u0002\u0005E\u0002BCA \u0001\t\u0005\t\u0015!\u0003\u00024!Q\u0011\u0011\t\u0001\u0003\u0006\u0004%\t!a\u0011\t\u0015\u0005\u0005\u0004A!A!\u0002\u0013\t)\u0005\u0003\u0006\u0002d\u0001\u0011)\u0019!C\u0001\u0003KB!\"a,\u0001\u0005\u0003\u0005\u000b\u0011BA4\u0011)\t\t\f\u0001BC\u0002\u0013\u0005\u00111\u0017\u0005\u000b\u0003\u0003\u0004!\u0011!Q\u0001\n\u0005U\u0006BCAb\u0001\t\u0015\r\u0011\"\u0001\u0002F\"Q\u00111\u001b\u0001\u0003\u0002\u0003\u0006I!a2\t\u0015\u0005U\u0007A!b\u0001\n\u0003\t9\u000e\u0003\u0006\u0002f\u0002\u0011\t\u0011)A\u0005\u00033D!\"a:\u0001\u0005\u000b\u0007I\u0011AAu\u0011)\t9\u0010\u0001B\u0001B\u0003%\u00111\u001e\u0005\u000b\u0003s\u0004!Q1A\u0005\u0002\u0005%\bBCA~\u0001\t\u0005\t\u0015!\u0003\u0002l\"9\u0011Q \u0001\u0005\u0002\u0005}\b\"\u0003B\u000f\u0001\t\u0007I\u0011\u0001B\u0010\u0011!\u0011i\u0003\u0001Q\u0001\n\t\u0005\u0002\"\u0003B\u0018\u0001\t\u0007I\u0011\u0001B\u0019\u0011!\u0011I\u0004\u0001Q\u0001\n\tM\u0002\"\u0003B\u001e\u0001\u0001\u0007I\u0011\u0001B\u001f\u0011%\u0011)\u0006\u0001a\u0001\n\u0003\u00119\u0006\u0003\u0005\u0003d\u0001\u0001\u000b\u0015\u0002B \u0011%\u0011)\u0007\u0001a\u0001\n\u0003\u00119\u0007C\u0005\u0003p\u0001\u0001\r\u0011\"\u0001\u0003r!A!Q\u000f\u0001!B\u0013\u0011I\u0007C\u0005\u0003x\u0001\u0001\r\u0011\"\u0001\u0003z!I!q\u0011\u0001A\u0002\u0013\u0005!\u0011\u0012\u0005\t\u0005\u001b\u0003\u0001\u0015)\u0003\u0003|!I!q\u0013\u0001A\u0002\u0013\u0005!\u0011\u0014\u0005\n\u0005g\u0003\u0001\u0019!C\u0001\u0005kC\u0001B!/\u0001A\u0003&!1\u0014\u0005\n\u0005w\u0003\u0001\u0019!C\u0001\u0005{C\u0011B!3\u0001\u0001\u0004%\tAa3\t\u0011\t=\u0007\u0001)Q\u0005\u0005\u007fC\u0011B!5\u0001\u0001\u0004%\tAa5\t\u0013\t\u0005\b\u00011A\u0005\u0002\t\r\b\u0002\u0003Bt\u0001\u0001\u0006KA!6\t\u0013\t%\bA1A\u0005\u0002\t-\b\u0002\u0003Bx\u0001\u0001\u0006IA!<\t\u0013\tE\b\u00011A\u0005\u0002\tM\b\"CB\u0002\u0001\u0001\u0007I\u0011AB\u0003\u0011!\u0019I\u0001\u0001Q!\n\tU\b\"CB\u0006\u0001\u0001\u0007I\u0011AB\u0007\u0011%\u00199\u0002\u0001a\u0001\n\u0003\u0019I\u0002\u0003\u0005\u0004\u001e\u0001\u0001\u000b\u0015BB\b\u0011%\tI\u0004\u0001a\u0001\n\u0003\u0019y\u0002C\u0005\u0004(\u0001\u0001\r\u0011\"\u0001\u0004*!A1Q\u0006\u0001!B\u0013\u0019\t\u0003C\u0005\u00040\u0001\u0001\r\u0011\"\u0001\u00042!I1\u0011\t\u0001A\u0002\u0013\u000511\t\u0005\t\u0007\u000f\u0002\u0001\u0015)\u0003\u00044!I1\u0011\n\u0001A\u0002\u0013\u000511\n\u0005\n\u0007'\u0002\u0001\u0019!C\u0001\u0007+B\u0001b!\u0017\u0001A\u0003&1Q\n\u0005\n\u00077\u0002\u0001\u0019!C\u0001\u0007;B\u0011b!\u001a\u0001\u0001\u0004%\taa\u001a\t\u0011\r-\u0004\u0001)Q\u0005\u0007?Bqa!\u001c\u0001\t\u0013\u0019y\u0007C\u0004\u0004\u0000\u0001!Ia!!\t\u000f\r\r\u0005\u0001\"\u0001\u0004\u0006\"91q\u0011\u0001\u0005\u0002\r\u0005\u0005bBBE\u0001\u0011\u00051\u0011\u0011\u0005\b\u0007\u0017\u0003A\u0011ABA\u0005A\u0019uN\u001c;s_2dWM]*feZ,'O\u0003\u0002O\u001f\u000611/\u001a:wKJT\u0011\u0001U\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u00011+W0\u0011\u0005Q;V\"A+\u000b\u0003Y\u000bQa]2bY\u0006L!\u0001W+\u0003\r\u0005s\u0017PU3g!\tQV,D\u0001\\\u0015\tav*A\u0003vi&d7/\u0003\u0002_7\n9Aj\\4hS:<\u0007C\u00011d\u001b\u0005\t'B\u00012P\u0003\u001diW\r\u001e:jGNL!\u0001Z1\u0003#-\u000bgm[1NKR\u0014\u0018nY:He>,\b/\u0001\bnKR\f\u0007K]8qKJ$\u0018.Z:\u0016\u0003\u001d\u0004\"\u0001[5\u000e\u00035K!A['\u0003\u001d5+G/\u0019)s_B,'\u000f^5fg\u0006yQ.\u001a;b!J|\u0007/\u001a:uS\u0016\u001c\b%\u0001\u0004d_:4\u0017nZ\u000b\u0002]B\u0011\u0001n\\\u0005\u0003a6\u00131bS1gW\u0006\u001cuN\u001c4jO\u000691m\u001c8gS\u001e\u0004\u0013a\u0003:bMRl\u0015M\\1hKJ,\u0012\u0001\u001e\t\u0004kbTX\"\u0001<\u000b\u0005]|\u0015\u0001\u0002:bMRL!!\u001f<\u0003\u0017I\u000bg\r^'b]\u0006<WM\u001d\t\u0004w\u0006%Q\"\u0001?\u000b\u0005ut\u0018AB2p[6|gN\u0003\u0002O\u007f*\u0019\u0001+!\u0001\u000b\t\u0005\r\u0011QA\u0001\u0007CB\f7\r[3\u000b\u0005\u0005\u001d\u0011aA8sO&\u0019\u00111\u0002?\u0003)\u0005\u0003\u0018.T3tg\u0006<W-\u00118e-\u0016\u00148/[8o\u00031\u0011\u0018M\u001a;NC:\fw-\u001a:!\u0003\u0011!\u0018.\\3\u0016\u0005\u0005M\u0001\u0003BA\u000b\u00037i!!a\u0006\u000b\u0007q\u000bIB\u0003\u0002~\u007f&!\u0011QDA\f\u0005\u0011!\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0016\u0005\u0005\r\u0002\u0003BA\u0013\u0003Si!!a\n\u000b\u0007\t\fI\"\u0003\u0003\u0002,\u0005\u001d\"aB'fiJL7m]\u0001\t[\u0016$(/[2tA\u0005\t2m\u001c8ue>dG.\u001a:NKR\u0014\u0018nY:\u0016\u0005\u0005M\u0002\u0003BA\u001b\u0003wi!!a\u000e\u000b\u0007\u0005er0\u0001\u0006d_:$(o\u001c7mKJLA!!\u0010\u00028\t\t2i\u001c8ue>dG.\u001a:NKR\u0014\u0018nY:\u0002%\r|g\u000e\u001e:pY2,'/T3ue&\u001c7\u000fI\u0001\u0011i\"\u0014X-\u00193OC6,\u0007K]3gSb,\"!!\u0012\u0011\u000bQ\u000b9%a\u0013\n\u0007\u0005%SK\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u001b\nYF\u0004\u0003\u0002P\u0005]\u0003cAA)+6\u0011\u00111\u000b\u0006\u0004\u0003+\n\u0016A\u0002\u001fs_>$h(C\u0002\u0002ZU\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA/\u0003?\u0012aa\u0015;sS:<'bAA-+\u0006\tB\u000f\u001b:fC\u0012t\u0015-\\3Qe\u00164\u0017\u000e\u001f\u0011\u00029\r|g\u000e\u001e:pY2,'/U;peVlgk\u001c;feN4U\u000f^;sKV\u0011\u0011q\r\t\u0007\u0003S\n9(a\u001f\u000e\u0005\u0005-$\u0002BA7\u0003_\n!bY8oGV\u0014(/\u001a8u\u0015\u0011\t\t(a\u001d\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003k\nAA[1wC&!\u0011\u0011PA6\u0005E\u0019u.\u001c9mKR\f'\r\\3GkR,(/\u001a\t\t\u0003{\ny(a!\u0002\u00106\u0011\u0011qN\u0005\u0005\u0003\u0003\u000byGA\u0002NCB\u0004B!!\"\u0002\f6\u0011\u0011q\u0011\u0006\u0005\u0003\u0013\u000b\u0019(\u0001\u0003mC:<\u0017\u0002BAG\u0003\u000f\u0013q!\u00138uK\u001e,'\u000f\u0005\u0003\u0002\u0012\u0006%f\u0002BAJ\u0003GsA!!&\u0002\":!\u0011qSAP\u001d\u0011\tI*!(\u000f\t\u0005E\u00131T\u0005\u0003\u0003\u000fIA!a\u0001\u0002\u0006%\u0019\u0001+!\u0001\n\u0005]|\u0018\u0002BAS\u0003O\u000b!BU1gi\u000e{gNZ5h\u0015\t9x0\u0003\u0003\u0002,\u00065&aC!eIJ,7o]*qK\u000eTA!!*\u0002(\u0006i2m\u001c8ue>dG.\u001a:Rk>\u0014X/\u001c,pi\u0016\u00148OR;ukJ,\u0007%\u0001\u0007d_:4\u0017nZ*dQ\u0016l\u0017-\u0006\u0002\u00026B!\u0011qWA_\u001b\t\tILC\u0002\u0002<~\f\u0001\"\\3uC\u0012\fG/Y\u0005\u0005\u0003\u007f\u000bILA\tLC\u001a\\\u0017mQ8oM&<7k\u00195f[\u0006\fQbY8oM&<7k\u00195f[\u0006\u0004\u0013a\u0004:bMR\f\u0005/\u001b,feNLwN\\:\u0016\u0005\u0005\u001d\u0007\u0003BAe\u0003\u001fl!!a3\u000b\u0007\u00055w0A\u0004dY&,g\u000e^:\n\t\u0005E\u00171\u001a\u0002\f\u0003BLg+\u001a:tS>t7/\u0001\tsC\u001a$\u0018\t]5WKJ\u001c\u0018n\u001c8tA\u0005\t\"m\\8ugR\u0014\u0018\r]'fi\u0006$\u0017\r^1\u0016\u0005\u0005e\u0007\u0003BAn\u0003Cl!!!8\u000b\t\u0005}\u0017\u0011X\u0001\nE>|Go\u001d;sCBLA!a9\u0002^\n\t\"i\\8ugR\u0014\u0018\r]'fi\u0006$\u0017\r^1\u0002%\t|w\u000e^:ue\u0006\u0004X*\u001a;bI\u0006$\u0018\rI\u0001\u0015[\u0016$\u0018\rZ1uC\u001a\u000bW\u000f\u001c;IC:$G.\u001a:\u0016\u0005\u0005-\b\u0003BAw\u0003gl!!a<\u000b\u0007\u0005Eh0A\u0003gCVdG/\u0003\u0003\u0002v\u0006=(\u0001\u0004$bk2$\b*\u00198eY\u0016\u0014\u0018!F7fi\u0006$\u0017\r^1GCVdG\u000fS1oI2,'\u000fI\u0001\u0012M\u0006$\u0018\r\u001c$bk2$\b*\u00198eY\u0016\u0014\u0018A\u00054bi\u0006dg)Y;mi\"\u000bg\u000e\u001a7fe\u0002\na\u0001P5oSRtD\u0003\bB\u0001\u0005\u0007\u0011)Aa\u0002\u0003\n\t-!Q\u0002B\b\u0005#\u0011\u0019B!\u0006\u0003\u0018\te!1\u0004\t\u0003Q\u0002AQ!Z\u000eA\u0002\u001dDQ\u0001\\\u000eA\u00029DQA]\u000eA\u0002QDq!a\u0004\u001c\u0001\u0004\t\u0019\u0002\u0003\u0004c7\u0001\u0007\u00111\u0005\u0005\b\u0003_Y\u0002\u0019AA\u001a\u0011\u001d\t\te\u0007a\u0001\u0003\u000bBq!a\u0019\u001c\u0001\u0004\t9\u0007C\u0004\u00022n\u0001\r!!.\t\u000f\u0005\r7\u00041\u0001\u0002H\"9\u0011Q[\u000eA\u0002\u0005e\u0007bBAt7\u0001\u0007\u00111\u001e\u0005\b\u0003s\\\u0002\u0019AAv\u0003\u0011awnY6\u0016\u0005\t\u0005\u0002\u0003\u0002B\u0012\u0005Si!A!\n\u000b\t\t\u001d\u00121N\u0001\u0006Y>\u001c7n]\u0005\u0005\u0005W\u0011)CA\u0007SK\u0016tGO]1oi2{7m[\u0001\u0006Y>\u001c7\u000eI\u0001\u0012C^\f\u0017\u000e^*ikR$wn\u001e8D_:$WC\u0001B\u001a!\u0011\u0011\u0019C!\u000e\n\t\t]\"Q\u0005\u0002\n\u0007>tG-\u001b;j_:\f!#Y<bSR\u001c\u0006.\u001e;e_^t7i\u001c8eA\u000511\u000f^1ukN,\"Aa\u0010\u0011\t\t\u0005#q\n\b\u0005\u0005\u0007\u0012YE\u0004\u0003\u0003F\t%c\u0002BA)\u0005\u000fJ\u0011\u0001U\u0005\u0003\u001d>K1A!\u0014N\u0003\u0019\u0019VM\u001d<fe&!!\u0011\u000bB*\u00055\u0001&o\\2fgN\u001cF/\u0019;vg*\u0019!QJ'\u0002\u0015M$\u0018\r^;t?\u0012*\u0017\u000f\u0006\u0003\u0003Z\t}\u0003c\u0001+\u0003\\%\u0019!QL+\u0003\tUs\u0017\u000e\u001e\u0005\n\u0005C\n\u0013\u0011!a\u0001\u0005\u007f\t1\u0001\u001f\u00132\u0003\u001d\u0019H/\u0019;vg\u0002\nq\u0003\\5okbLu.T3ue&\u001c7oQ8mY\u0016\u001cGo\u001c:\u0016\u0005\t%\u0004c\u00011\u0003l%\u0019!QN1\u0003/1Kg.\u001e=J_6+GO]5dg\u000e{G\u000e\\3di>\u0014\u0018a\u00077j]VD\u0018j\\'fiJL7m]\"pY2,7\r^8s?\u0012*\u0017\u000f\u0006\u0003\u0003Z\tM\u0004\"\u0003B1I\u0005\u0005\t\u0019\u0001B5\u0003aa\u0017N\\;y\u0013>lU\r\u001e:jGN\u001cu\u000e\u001c7fGR|'\u000fI\u0001\u000bCV$\bn\u001c:ju\u0016\u0014XC\u0001B>!\u0015!\u0016q\tB?!\u0011\u0011yHa!\u000e\u0005\t\u0005%b\u0001B<}&!!Q\u0011BA\u0005)\tU\u000f\u001e5pe&TXM]\u0001\u000fCV$\bn\u001c:ju\u0016\u0014x\fJ3r)\u0011\u0011IFa#\t\u0013\t\u0005t%!AA\u0002\tm\u0014aC1vi\"|'/\u001b>fe\u0002B3\u0001\u000bBI!\r!&1S\u0005\u0004\u0005++&\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\u0015Q|7.\u001a8DC\u000eDW-\u0006\u0002\u0003\u001cB!!Q\u0014BX\u001b\t\u0011yJ\u0003\u0003\u0003\"\n\r\u0016!C5oi\u0016\u0014h.\u00197t\u0015\u0011\u0011)Ka*\u0002\u0015\u0011,G.Z4bi&|gN\u0003\u0003\u0003*\n-\u0016!\u0002;pW\u0016t'\u0002\u0002BW\u00033\t\u0001b]3dkJLG/_\u0005\u0005\u0005c\u0013yJ\u0001\u000bEK2,w-\u0019;j_:$vn[3o\u0007\u0006\u001c\u0007.Z\u0001\u000fi>\\WM\\\"bG\",w\fJ3r)\u0011\u0011IFa.\t\u0013\t\u0005$&!AA\u0002\tm\u0015a\u0003;pW\u0016t7)Y2iK\u0002\n!c\u0019:fI\u0016tG/[1m!J|g/\u001b3feV\u0011!q\u0018\t\u0005\u0005\u0003\u0014)-\u0004\u0002\u0003D*\u0019!QV(\n\t\t\u001d'1\u0019\u0002\u0013\u0007J,G-\u001a8uS\u0006d\u0007K]8wS\u0012,'/\u0001\fde\u0016$WM\u001c;jC2\u0004&o\u001c<jI\u0016\u0014x\fJ3r)\u0011\u0011IF!4\t\u0013\t\u0005T&!AA\u0002\t}\u0016aE2sK\u0012,g\u000e^5bYB\u0013xN^5eKJ\u0004\u0013\u0001D:pG.,GoU3sm\u0016\u0014XC\u0001Bk!\u0011\u00119N!8\u000e\u0005\te'b\u0001Bn\u001f\u00069a.\u001a;x_J\\\u0017\u0002\u0002Bp\u00053\u0014AbU8dW\u0016$8+\u001a:wKJ\f\u0001c]8dW\u0016$8+\u001a:wKJ|F%Z9\u0015\t\te#Q\u001d\u0005\n\u0005C\u0002\u0014\u0011!a\u0001\u0005+\fQb]8dW\u0016$8+\u001a:wKJ\u0004\u0013\u0001I:pG.,GoU3sm\u0016\u0014h)\u001b:ti\n{WO\u001c3Q_J$h)\u001e;ve\u0016,\"A!<\u0011\r\u0005%\u0014qOAB\u0003\u0005\u001axnY6fiN+'O^3s\r&\u00148\u000f\u001e\"pk:$\u0007k\u001c:u\rV$XO]3!\u0003E\u0019'/Z1uKR{\u0007/[2Q_2L7-_\u000b\u0003\u0005k\u0004R\u0001VA$\u0005o\u0004BA!?\u0003\u00006\u0011!1 \u0006\u0004\u0005{t\u0018A\u00029pY&\u001c\u00170\u0003\u0003\u0004\u0002\tm(!E\"sK\u0006$X\rV8qS\u000e\u0004v\u000e\\5ds\u0006)2M]3bi\u0016$v\u000e]5d!>d\u0017nY=`I\u0015\fH\u0003\u0002B-\u0007\u000fA\u0011B!\u00196\u0003\u0003\u0005\rA!>\u0002%\r\u0014X-\u0019;f)>\u0004\u0018n\u0019)pY&\u001c\u0017\u0010I\u0001\u0012C2$XM]\"p]\u001aLw\rU8mS\u000eLXCAB\b!\u0015!\u0016qIB\t!\u0011\u0011Ipa\u0005\n\t\rU!1 \u0002\u0012\u00032$XM]\"p]\u001aLw\rU8mS\u000eL\u0018!F1mi\u0016\u00148i\u001c8gS\u001e\u0004v\u000e\\5ds~#S-\u001d\u000b\u0005\u00053\u001aY\u0002C\u0005\u0003ba\n\t\u00111\u0001\u0004\u0010\u0005\u0011\u0012\r\u001c;fe\u000e{gNZ5h!>d\u0017nY=!+\t\u0019\t\u0003\u0005\u0003\u00026\r\r\u0012\u0002BB\u0013\u0003o\u0011!bQ8oiJ|G\u000e\\3s\u00039\u0019wN\u001c;s_2dWM]0%KF$BA!\u0017\u0004,!I!\u0011M\u001e\u0002\u0002\u0003\u00071\u0011E\u0001\fG>tGO]8mY\u0016\u0014\b%A\u0007rk>$\u0018-T1oC\u001e,'o]\u000b\u0003\u0007g\u0001Ba!\u000e\u0004<9!!1IB\u001c\u0013\r\u0019I$T\u0001\r#V|G/\u0019$bGR|'/_\u0005\u0005\u0007{\u0019yDA\u0007Rk>$\u0018-T1oC\u001e,'o\u001d\u0006\u0004\u0007si\u0015!E9v_R\fW*\u00198bO\u0016\u00148o\u0018\u0013fcR!!\u0011LB#\u0011%\u0011\tGPA\u0001\u0002\u0004\u0019\u0019$\u0001\brk>$\u0018-T1oC\u001e,'o\u001d\u0011\u0002\u001d\r|g\u000e\u001e:pY2,'/\u00119jgV\u00111Q\n\t\u0004Q\u000e=\u0013bAB)\u001b\nq1i\u001c8ue>dG.\u001a:Ba&\u001c\u0018AE2p]R\u0014x\u000e\u001c7fe\u0006\u0003\u0018n]0%KF$BA!\u0017\u0004X!I!\u0011M!\u0002\u0002\u0003\u00071QJ\u0001\u0010G>tGO]8mY\u0016\u0014\u0018\t]5tA\u0005I2m\u001c8ue>dG.\u001a:Ba&\u001c\b*\u00198eY\u0016\u0014\bk\\8m+\t\u0019y\u0006E\u0002i\u0007CJ1aa\u0019N\u0005]Y\u0015MZ6b%\u0016\fX/Z:u\u0011\u0006tG\r\\3s!>|G.A\u000fd_:$(o\u001c7mKJ\f\u0005/[:IC:$G.\u001a:Q_>dw\fJ3r)\u0011\u0011If!\u001b\t\u0013\t\u0005D)!AA\u0002\r}\u0013AG2p]R\u0014x\u000e\u001c7fe\u0006\u0003\u0018n\u001d%b]\u0012dWM\u001d)p_2\u0004\u0013!E7bs\n,7\t[1oO\u0016\u001cF/\u0019;vgR11\u0011OB<\u0007w\u00022\u0001VB:\u0013\r\u0019)(\u0016\u0002\b\u0005>|G.Z1o\u0011\u001d\u0019IH\u0012a\u0001\u0005\u007f\tAA\u001a:p[\"91Q\u0010$A\u0002\t}\u0012A\u0001;p\u0003I!wNU3n_R,7J]1giN+G/\u001e9\u0015\u0005\te\u0013!C2mkN$XM]%e+\t\tY%A\u0004ti\u0006\u0014H/\u001e9\u0002\u0011MDW\u000f\u001e3po:\fQ\"Y<bSR\u001c\u0006.\u001e;e_^t\u0007")
public class ControllerServer
implements KafkaMetricsGroup {
    private final MetaProperties metaProperties;
    private final KafkaConfig config;
    private final RaftManager<ApiMessageAndVersion> raftManager;
    private final Time time;
    private final Metrics metrics;
    private final ControllerMetrics controllerMetrics;
    private final Option<String> threadNamePrefix;
    private final CompletableFuture<java.util.Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture;
    private final KafkaConfigSchema configSchema;
    private final ApiVersions raftApiVersions;
    private final BootstrapMetadata bootstrapMetadata;
    private final FaultHandler metadataFaultHandler;
    private final FaultHandler fatalFaultHandler;
    private final ReentrantLock lock;
    private final Condition awaitShutdownCond;
    private Server.ProcessStatus status;
    private LinuxIoMetricsCollector linuxIoMetricsCollector;
    private volatile Option<Authorizer> authorizer;
    private DelegationTokenCache tokenCache;
    private CredentialProvider credentialProvider;
    private SocketServer socketServer;
    private final CompletableFuture<Integer> socketServerFirstBoundPortFuture;
    private Option<CreateTopicPolicy> createTopicPolicy;
    private Option<AlterConfigPolicy> alterConfigPolicy;
    private Controller controller;
    private QuotaFactory.QuotaManagers quotaManagers;
    private ControllerApis controllerApis;
    private KafkaRequestHandlerPool controllerApisHandlerPool;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Meter newMeter(MetricName metricName, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup.newMeter$(this, metricName, eventType, timeUnit);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public MetaProperties metaProperties() {
        return this.metaProperties;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public RaftManager<ApiMessageAndVersion> raftManager() {
        return this.raftManager;
    }

    public Time time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public ControllerMetrics controllerMetrics() {
        return this.controllerMetrics;
    }

    public Option<String> threadNamePrefix() {
        return this.threadNamePrefix;
    }

    public CompletableFuture<java.util.Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    public KafkaConfigSchema configSchema() {
        return this.configSchema;
    }

    public ApiVersions raftApiVersions() {
        return this.raftApiVersions;
    }

    public BootstrapMetadata bootstrapMetadata() {
        return this.bootstrapMetadata;
    }

    public FaultHandler metadataFaultHandler() {
        return this.metadataFaultHandler;
    }

    public FaultHandler fatalFaultHandler() {
        return this.fatalFaultHandler;
    }

    public ReentrantLock lock() {
        return this.lock;
    }

    public Condition awaitShutdownCond() {
        return this.awaitShutdownCond;
    }

    public Server.ProcessStatus status() {
        return this.status;
    }

    public void status_$eq(Server.ProcessStatus x$1) {
        this.status = x$1;
    }

    public LinuxIoMetricsCollector linuxIoMetricsCollector() {
        return this.linuxIoMetricsCollector;
    }

    public void linuxIoMetricsCollector_$eq(LinuxIoMetricsCollector x$1) {
        this.linuxIoMetricsCollector = x$1;
    }

    public Option<Authorizer> authorizer() {
        return this.authorizer;
    }

    public void authorizer_$eq(Option<Authorizer> x$1) {
        this.authorizer = x$1;
    }

    public DelegationTokenCache tokenCache() {
        return this.tokenCache;
    }

    public void tokenCache_$eq(DelegationTokenCache x$1) {
        this.tokenCache = x$1;
    }

    public CredentialProvider credentialProvider() {
        return this.credentialProvider;
    }

    public void credentialProvider_$eq(CredentialProvider x$1) {
        this.credentialProvider = x$1;
    }

    public SocketServer socketServer() {
        return this.socketServer;
    }

    public void socketServer_$eq(SocketServer x$1) {
        this.socketServer = x$1;
    }

    public CompletableFuture<Integer> socketServerFirstBoundPortFuture() {
        return this.socketServerFirstBoundPortFuture;
    }

    public Option<CreateTopicPolicy> createTopicPolicy() {
        return this.createTopicPolicy;
    }

    public void createTopicPolicy_$eq(Option<CreateTopicPolicy> x$1) {
        this.createTopicPolicy = x$1;
    }

    public Option<AlterConfigPolicy> alterConfigPolicy() {
        return this.alterConfigPolicy;
    }

    public void alterConfigPolicy_$eq(Option<AlterConfigPolicy> x$1) {
        this.alterConfigPolicy = x$1;
    }

    public Controller controller() {
        return this.controller;
    }

    public void controller_$eq(Controller x$1) {
        this.controller = x$1;
    }

    public QuotaFactory.QuotaManagers quotaManagers() {
        return this.quotaManagers;
    }

    public void quotaManagers_$eq(QuotaFactory.QuotaManagers x$1) {
        this.quotaManagers = x$1;
    }

    public ControllerApis controllerApis() {
        return this.controllerApis;
    }

    public void controllerApis_$eq(ControllerApis x$1) {
        this.controllerApis = x$1;
    }

    public KafkaRequestHandlerPool controllerApisHandlerPool() {
        return this.controllerApisHandlerPool;
    }

    public void controllerApisHandlerPool_$eq(KafkaRequestHandlerPool x$1) {
        this.controllerApisHandlerPool = x$1;
    }

    private boolean maybeChangeStatus(Server.ProcessStatus from, Server.ProcessStatus to) {
        block9: {
            boolean bl;
            block8: {
                this.lock().lock();
                try {
                    Server.ProcessStatus processStatus = this.status();
                    if (processStatus == null ? from != null : !processStatus.equals(from)) {
                        bl = false;
                        break block8;
                    }
                    this.status_$eq(to);
                    Server.ProcessStatus processStatus2 = to;
                    Server$SHUTDOWN$ server$SHUTDOWN$ = Server$SHUTDOWN$.MODULE$;
                    if (processStatus2 == null) {
                        if (server$SHUTDOWN$ != null) {
                            break block9;
                        }
                    } else if (!processStatus2.equals(server$SHUTDOWN$)) break block9;
                    this.awaitShutdownCond().signalAll();
                    break block9;
                }
                finally {
                    this.lock().unlock();
                }
            }
            return bl;
        }
        return true;
    }

    private void doRemoteKraftSetup() {
        new DynamicMetricReporterState(this.config().nodeId(), this.config(), this.metrics(), this.clusterId());
    }

    public String clusterId() {
        return this.metaProperties().clusterId();
    }

    public void startup() {
        if (!this.maybeChangeStatus(Server$SHUTDOWN$.MODULE$, Server$STARTING$.MODULE$)) {
            return;
        }
        try {
            Authorizer a;
            scala.collection.immutable.Map map;
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting controller");
            this.maybeChangeStatus(Server$STARTING$.MODULE$, Server$STARTED$.MODULE$);
            this.logIdent_$eq(new LogContext(new StringBuilder(23).append("[ControllerServer id=").append(this.config().nodeId()).append("] ").toString()).logPrefix());
            this.newGauge("ClusterId", new Gauge<String>(this){
                private final /* synthetic */ ControllerServer $outer;

                public final String value() {
                    return this.$outer.kafka$server$ControllerServer$$$anonfun$startup$2();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, this.newGauge$default$3());
            this.newGauge("yammer-metrics-count", new Gauge<Object>(this){
                private final /* synthetic */ ControllerServer $outer;

                public final int value() {
                    return ControllerServer.kafka$server$ControllerServer$$$anonfun$startup$4();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, this.newGauge$default$3());
            this.linuxIoMetricsCollector_$eq(new LinuxIoMetricsCollector("/proc", this.time(), this.logger().underlying()));
            if (this.linuxIoMetricsCollector().usable()) {
                this.newGauge("linux-disk-read-bytes", new Gauge<Object>(this){
                    private final /* synthetic */ ControllerServer $outer;

                    public final long value() {
                        return this.$outer.kafka$server$ControllerServer$$$anonfun$startup$6();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, this.newGauge$default$3());
                this.newGauge("linux-disk-write-bytes", new Gauge<Object>(this){
                    private final /* synthetic */ ControllerServer $outer;

                    public final long value() {
                        return this.$outer.kafka$server$ControllerServer$$$anonfun$startup$8();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, this.newGauge$default$3());
            }
            List javaListeners = (List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)this.config().controllerListeners().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toJava(), Seq$.MODULE$.canBuildFrom())).asJava();
            this.authorizer_$eq(this.config().createNewAuthorizer());
            this.authorizer().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.configure(this.config().originals());
                return BoxedUnit.UNIT;
            });
            Option<Authorizer> option = this.authorizer();
            if (option instanceof Some) {
                Authorizer authZ = (Authorizer)((Some)option).value();
                Broker.ServerInfo controllerAuthorizerInfo = new Broker.ServerInfo(new ClusterResource(this.clusterId()), this.config().nodeId(), javaListeners, (Endpoint)javaListeners.get(0), (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)this.config().earlyStartListeners().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.value(), Set$.MODULE$.canBuildFrom())).asJava());
                map = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(authZ.start((AuthorizerServerInfo)controllerAuthorizerInfo)).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    if (x0$1 == null) {
                        throw new MatchError(null);
                    }
                    Endpoint ep = (Endpoint)x0$1._1();
                    CompletionStage cs = (CompletionStage)x0$1._2();
                    Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ep), cs.toCompletableFuture());
                    return tuple2;
                }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            } else if (None$.MODULE$.equals(option)) {
                map = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(javaListeners).asScala()).map((Function1 & Serializable & scala.Serializable)ep -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ep), CompletableFuture.completedFuture(null)), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            } else {
                throw new MatchError(option);
            }
            SimpleApiVersionManager apiVersionManager = new SimpleApiVersionManager(ApiMessageType.ListenerType.CONTROLLER);
            this.tokenCache_$eq(new DelegationTokenCache(ScramMechanism.mechanismNames()));
            this.credentialProvider_$eq(new CredentialProvider(ScramMechanism.mechanismNames(), this.tokenCache()));
            this.socketServer_$eq(new SocketServer(this.config(), this.metrics(), this.time(), this.credentialProvider(), apiVersionManager));
            if (!this.config().controllerListeners().nonEmpty()) {
                throw new ConfigException("No controller.listener.names defined for controller");
            }
            this.socketServerFirstBoundPortFuture().complete(Predef$.MODULE$.int2Integer(this.socketServer().boundPort(((EndPoint)this.config().controllerListeners().head()).listenerName())));
            String threadNamePrefixAsString = (String)this.threadNamePrefix().getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
            this.createTopicPolicy_$eq((Option<CreateTopicPolicy>)Option$.MODULE$.apply(this.config().getConfiguredInstance(KafkaConfig$.MODULE$.CreateTopicPolicyClassNameProp(), CreateTopicPolicy.class)));
            this.alterConfigPolicy_$eq((Option<AlterConfigPolicy>)Option$.MODULE$.apply(this.config().getConfiguredInstance(KafkaConfig$.MODULE$.AlterConfigPolicyClassNameProp(), AlterConfigPolicy.class)));
            List controllerNodes = RaftConfig.voterConnectionsToNodes(this.controllerQuorumVotersFuture().get());
            QuorumFeatures quorumFeatures = QuorumFeatures.create((int)this.config().nodeId(), (ApiVersions)this.raftApiVersions(), (java.util.Map)QuorumFeatures.defaultFeatureMap(), (Collection)controllerNodes);
            OptionalLong leaderImbalanceCheckIntervalNs = Predef$.MODULE$.Boolean2boolean(this.config().autoLeaderRebalanceEnable()) ? OptionalLong.of(TimeUnit.NANOSECONDS.convert(this.config().leaderImbalanceCheckIntervalSeconds(), TimeUnit.SECONDS)) : OptionalLong.empty();
            OptionalLong maxIdleIntervalNs = (OptionalLong)this.config().metadataMaxIdleIntervalNs().fold((Function0 & Serializable & scala.Serializable)() -> OptionalLong.empty(), (Function1 & Serializable & scala.Serializable)x$1 -> ControllerServer.$anonfun$startup$17(BoxesRunTime.unboxToLong((Object)x$1)));
            QuorumController.Builder controllerBuilder = new QuorumController.Builder(this.config().nodeId(), this.metaProperties().clusterId()).setTime(this.time()).setThreadNamePrefix(threadNamePrefixAsString).setConfigSchema(this.configSchema()).setRaftClient(this.raftManager().client()).setQuorumFeatures(quorumFeatures).setDefaultReplicationFactor((short)this.config().defaultReplicationFactor()).setDefaultNumPartitions(this.config().numPartitions().intValue()).setSessionTimeoutNs(TimeUnit.NANOSECONDS.convert(this.config().brokerSessionTimeoutMs(), TimeUnit.MILLISECONDS)).setSnapshotMaxNewRecordBytes(Predef$.MODULE$.Long2long(this.config().metadataSnapshotMaxNewRecordBytes())).setLeaderImbalanceCheckIntervalNs(leaderImbalanceCheckIntervalNs).setMaxIdleIntervalNs(maxIdleIntervalNs).setMetrics(this.controllerMetrics()).setCreateTopicPolicy(OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(this.createTopicPolicy()))).setAlterConfigPolicy(OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(this.alterConfigPolicy()))).setConfigurationValidator((ConfigurationValidator)new ControllerConfigurationValidator()).setStaticConfig(this.config().originals()).setBootstrapMetadata(this.bootstrapMetadata()).setFatalFaultHandler(this.fatalFaultHandler());
            Option<Authorizer> option2 = this.authorizer();
            if (option2 instanceof Some && (a = (Authorizer)((Some)option2).value()) instanceof ClusterMetadataAuthorizer) {
                ClusterMetadataAuthorizer clusterMetadataAuthorizer = (ClusterMetadataAuthorizer)a;
                controllerBuilder.setAuthorizer(clusterMetadataAuthorizer);
            }
            this.controller_$eq((Controller)controllerBuilder.build());
            if (!this.config().processRoles().contains((Object)KafkaRaftServer$BrokerRole$.MODULE$)) {
                this.doRemoteKraftSetup();
            }
            this.quotaManagers_$eq(QuotaFactory$.MODULE$.instantiate(this.config(), this.metrics(), this.time(), (String)this.threadNamePrefix().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")));
            this.controllerApis_$eq(new ControllerApis(this.socketServer().dataPlaneRequestChannel(), this.authorizer(), this.quotaManagers(), this.time(), this.controller(), this.raftManager(), this.config(), this.metaProperties(), (Seq<Node>)((SeqLike)CollectionConverters$.MODULE$.asScalaBufferConverter(controllerNodes).asScala()).toSeq(), apiVersionManager));
            this.controllerApisHandlerPool_$eq(new KafkaRequestHandlerPool(this.config().nodeId(), this.socketServer().dataPlaneRequestChannel(), this.controllerApis(), this.time(), Predef$.MODULE$.Integer2int(this.config().numIoThreads()), new StringBuilder(28).append(DataPlaneAcceptor$.MODULE$.MetricPrefix()).append("RequestHandlerAvgIdlePercent").toString(), DataPlaneAcceptor$.MODULE$.ThreadPrefix()));
            this.socketServer().enableRequestProcessing((Map<Endpoint, CompletableFuture<Void>>)map);
            return;
        }
        catch (Throwable e) {
            this.maybeChangeStatus(Server$STARTING$.MODULE$, Server$STARTED$.MODULE$);
            this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Fatal error during controller startup. Prepare to shutdown", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            this.shutdown();
            throw e;
        }
    }

    public void shutdown() {
        if (!this.maybeChangeStatus(Server$STARTED$.MODULE$, Server$SHUTTING_DOWN$.MODULE$)) {
            return;
        }
        try {
            try {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "shutting down");
                if (this.socketServer() != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.socketServer().stopProcessingRequests(), this, CoreUtils$.MODULE$.swallow$default$3());
                }
                if (this.controller() != null) {
                    this.controller().beginShutdown();
                }
                if (this.socketServer() != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.socketServer().shutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
                }
                if (this.controllerApisHandlerPool() != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.controllerApisHandlerPool().shutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
                }
                if (this.controllerApis() != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.controllerApis().close(), this, CoreUtils$.MODULE$.swallow$default$3());
                }
                if (this.quotaManagers() != null) {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.quotaManagers().shutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
                }
                if (this.controller() != null) {
                    this.controller().close();
                }
                CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.authorizer().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                    x$4.close();
                    return BoxedUnit.UNIT;
                }), this, CoreUtils$.MODULE$.swallow$default$3());
                this.createTopicPolicy().foreach((Function1 & Serializable & scala.Serializable)policy -> {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> policy.close(), this, CoreUtils$.MODULE$.swallow$default$3());
                    return BoxedUnit.UNIT;
                });
                this.alterConfigPolicy().foreach((Function1 & Serializable & scala.Serializable)policy -> {
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> policy.close(), this, CoreUtils$.MODULE$.swallow$default$3());
                    return BoxedUnit.UNIT;
                });
                this.socketServerFirstBoundPortFuture().completeExceptionally(new RuntimeException("shutting down"));
            }
            catch (Throwable e) {
                this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Fatal error during controller shutdown.", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                throw e;
            }
        }
        finally {
            this.maybeChangeStatus(Server$SHUTTING_DOWN$.MODULE$, Server$SHUTDOWN$.MODULE$);
        }
    }

    public void awaitShutdown() {
        this.lock().lock();
        try {
            while (true) {
                Server.ProcessStatus processStatus = this.status();
                Server$SHUTDOWN$ server$SHUTDOWN$ = Server$SHUTDOWN$.MODULE$;
                if (processStatus == null ? server$SHUTDOWN$ != null : !processStatus.equals(server$SHUTDOWN$)) {
                    this.awaitShutdownCond().awaitUninterruptibly();
                    continue;
                }
                break;
            }
        }
        finally {
            this.lock().unlock();
        }
    }

    public final /* synthetic */ String kafka$server$ControllerServer$$$anonfun$startup$2() {
        return this.clusterId();
    }

    public static final /* synthetic */ int kafka$server$ControllerServer$$$anonfun$startup$4() {
        return KafkaYammerMetrics.defaultRegistry().allMetrics().size();
    }

    public final /* synthetic */ long kafka$server$ControllerServer$$$anonfun$startup$6() {
        return this.linuxIoMetricsCollector().readBytes();
    }

    public final /* synthetic */ long kafka$server$ControllerServer$$$anonfun$startup$8() {
        return this.linuxIoMetricsCollector().writeBytes();
    }

    public static final /* synthetic */ OptionalLong $anonfun$startup$17(long x$1) {
        return OptionalLong.of(x$1);
    }

    public ControllerServer(MetaProperties metaProperties, KafkaConfig config, RaftManager<ApiMessageAndVersion> raftManager, Time time, Metrics metrics, ControllerMetrics controllerMetrics, Option<String> threadNamePrefix, CompletableFuture<java.util.Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture, KafkaConfigSchema configSchema, ApiVersions raftApiVersions, BootstrapMetadata bootstrapMetadata, FaultHandler metadataFaultHandler, FaultHandler fatalFaultHandler) {
        this.metaProperties = metaProperties;
        this.config = config;
        this.raftManager = raftManager;
        this.time = time;
        this.metrics = metrics;
        this.controllerMetrics = controllerMetrics;
        this.threadNamePrefix = threadNamePrefix;
        this.controllerQuorumVotersFuture = controllerQuorumVotersFuture;
        this.configSchema = configSchema;
        this.raftApiVersions = raftApiVersions;
        this.bootstrapMetadata = bootstrapMetadata;
        this.metadataFaultHandler = metadataFaultHandler;
        this.fatalFaultHandler = fatalFaultHandler;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        config.dynamicConfig().initialize((Option<KafkaZkClient>)None$.MODULE$);
        this.lock = new ReentrantLock();
        this.awaitShutdownCond = this.lock().newCondition();
        this.status = Server$SHUTDOWN$.MODULE$;
        this.linuxIoMetricsCollector = null;
        this.authorizer = null;
        this.tokenCache = null;
        this.credentialProvider = null;
        this.socketServer = null;
        this.socketServerFirstBoundPortFuture = new CompletableFuture();
        this.createTopicPolicy = None$.MODULE$;
        this.alterConfigPolicy = None$.MODULE$;
        this.controller = null;
        this.quotaManagers = null;
        this.controllerApis = null;
        this.controllerApisHandlerPool = null;
    }
}

