/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Optional;
import kafka.common.InconsistentNodeIdException;
import kafka.log.LogConfig$;
import kafka.log.UnifiedLog$;
import kafka.server.BrokerMetadataCheckpoint$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetaProperties;
import kafka.server.MetaProperties$;
import kafka.server.RawMetaProperties;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.metadata.bootstrap.BootstrapDirectory;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenSeq;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;

public final class KafkaRaftServer$ {
    public static KafkaRaftServer$ MODULE$;
    private final String MetadataTopic;
    private final TopicPartition MetadataPartition;
    private final Uuid MetadataTopicId;
    private final KafkaConfigSchema configSchema;

    static {
        new KafkaRaftServer$();
    }

    public String MetadataTopic() {
        return this.MetadataTopic;
    }

    public TopicPartition MetadataPartition() {
        return this.MetadataPartition;
    }

    public Uuid MetadataTopicId() {
        return this.MetadataTopicId;
    }

    /*
     * WARNING - void declaration
     */
    public Tuple3<MetaProperties, BootstrapMetadata, Seq<String>> initializeLogDirs(KafkaConfig config) {
        void var5_5;
        void var4_4;
        Seq logDirs = config.logDirs().toSet().$plus((Object)config.metadataLogDir()).toSeq();
        Tuple2<RawMetaProperties, Seq<String>> tuple2 = BrokerMetadataCheckpoint$.MODULE$.getBrokerMetadataAndOfflineDirs((Seq<String>)logDirs, false);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RawMetaProperties rawMetaProperties = (RawMetaProperties)tuple2._1();
        Seq offlineDirs = (Seq)tuple2._2();
        void rawMetaProperties2 = var4_4;
        void offlineDirs2 = var5_5;
        if (offlineDirs2.contains((Object)config.metadataLogDir())) {
            throw new KafkaException(new StringBuilder(69).append("Cannot start server since `meta.properties` could not be ").append("loaded from ").append(config.metadataLogDir()).toString());
        }
        String metadataPartitionDirName = UnifiedLog$.MODULE$.logDirName(this.MetadataPartition());
        ((Seq)logDirs.diff((GenSeq)offlineDirs2.$colon$plus((Object)config.metadataLogDir(), Seq$.MODULE$.canBuildFrom()))).foreach((Function1 & Serializable & scala.Serializable)logDir -> {
            KafkaRaftServer$.$anonfun$initializeLogDirs$1(metadataPartitionDirName, config, logDir);
            return BoxedUnit.UNIT;
        });
        MetaProperties metaProperties = MetaProperties$.MODULE$.parse((RawMetaProperties)rawMetaProperties2);
        if (config.nodeId() != metaProperties.nodeId()) {
            throw new InconsistentNodeIdException(new StringBuilder(248).append("Configured node.id `").append(config.nodeId()).append("` doesn't match stored node.id `").append(metaProperties.nodeId()).append("' in ").append("meta.properties. If you moved your data, make sure your configured controller.id matches. ").append("If you intend to create a new broker, you should remove all data in your data directories (log.dirs).").toString());
        }
        BootstrapMetadata bootstrapMetadata = new BootstrapDirectory(config.metadataLogDir(), Optional.ofNullable(config.interBrokerProtocolVersionString())).read();
        return new Tuple3((Object)metaProperties, (Object)bootstrapMetadata, (Object)offlineDirs2.toSeq());
    }

    public KafkaConfigSchema configSchema() {
        return this.configSchema;
    }

    public static final /* synthetic */ void $anonfun$initializeLogDirs$1(String metadataPartitionDirName$1, KafkaConfig config$1, String logDir) {
        File metadataDir = new File(logDir, metadataPartitionDirName$1);
        if (metadataDir.exists()) {
            throw new KafkaException(new StringBuilder(96).append("Found unexpected metadata location in data directory `").append(metadataDir).append("` ").append("(the configured metadata directory is ").append(config$1.metadataLogDir()).append(").").toString());
        }
    }

    private KafkaRaftServer$() {
        MODULE$ = this;
        this.MetadataTopic = "__cluster_metadata";
        this.MetadataPartition = Topic.CLUSTER_METADATA_TOPIC_PARTITION;
        this.MetadataTopicId = Uuid.METADATA_TOPIC_ID;
        this.configSchema = new KafkaConfigSchema((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConfigResource.Type.BROKER), (Object)new ConfigDef(KafkaConfig$.MODULE$.configDef())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConfigResource.Type.TOPIC), (Object)LogConfig$.MODULE$.configDefCopy())}))).asJava(), LogConfig$.MODULE$.AllTopicConfigSynonyms());
    }
}

