/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import kafka.admin.AdminOperationException;
import kafka.admin.TopicCommand;
import kafka.admin.TopicCommand$;
import kafka.common.AdminCommandFailedException;
import kafka.utils.Exit$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClientTestUtils;
import org.apache.kafka.clients.admin.CreatePartitionsOptions;
import org.apache.kafka.clients.admin.CreatePartitionsResult;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DeleteTopicsOptions;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.PartitionReassignment;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.errors.ThrottlingQuotaExceededException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Exit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001Q4A\u0001F\u000b\u00015!)\u0011\u0005\u0001C\u0001E!1Q\u0005\u0001Q\u0001\n\u0019BaA\f\u0001!\u0002\u00131\u0003\"B\u0018\u0001\t\u0003\u0001\u0004\"B!\u0001\t\u0003\u0001\u0004\"B\"\u0001\t\u0003\u0001\u0004\"B#\u0001\t\u0003\u0001\u0004\"B$\u0001\t\u0003\u0001\u0004\"B%\u0001\t\u0003\u0001\u0004\"B&\u0001\t\u0003\u0001\u0004\"B'\u0001\t\u0003\u0001\u0004\"B(\u0001\t\u0003\u0001\u0004\"B)\u0001\t\u0003\u0001\u0004\"B*\u0001\t\u0003\u0001\u0004\"B+\u0001\t\u0003\u0001\u0004\"B,\u0001\t\u0003\u0001\u0004\"B-\u0001\t\u0003\u0001\u0004\"B.\u0001\t\u0003\u0001\u0004BB/\u0001A\u0013%aL\u0001\tU_BL7mQ8n[\u0006tG\rV3ti*\u0011acF\u0001\u0006C\u0012l\u0017N\u001c\u0006\u00021\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u001c!\tar$D\u0001\u001e\u0015\u0005q\u0012!B:dC2\f\u0017B\u0001\u0011\u001e\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a\t\t\u0003I\u0001i\u0011!F\u0001\u000bEJ|7.\u001a:MSN$\bCA\u0014-\u001b\u0005A#BA\u0015+\u0003\u0011a\u0017M\\4\u000b\u0003-\nAA[1wC&\u0011Q\u0006\u000b\u0002\u0007'R\u0014\u0018N\\4\u0002\u0013Q|\u0007/[2OC6,\u0017A\t;fgRL5OT8u+:$WM\u001d*fa2L7-\u0019;fI^CWM\\!eI&tw\rF\u00012!\ta\"'\u0003\u00024;\t!QK\\5uQ\t!Q\u0007\u0005\u00027\u007f5\tqG\u0003\u00029s\u0005\u0019\u0011\r]5\u000b\u0005iZ\u0014a\u00026va&$XM\u001d\u0006\u0003yu\nQA[;oSRT\u0011AP\u0001\u0004_J<\u0017B\u0001!8\u0005\u0011!Vm\u001d;\u0002MQ,7\u000f^!mi\u0016\u0014x+\u001b;i+:\u001c\b/Z2jM&,G\rU1si&$\u0018n\u001c8D_VtG\u000f\u000b\u0002\u0006k\u0005\tC/Z:u\u0007>tg-[4PaR<\u0016\u000e\u001e5C_>$8\u000f\u001e:baN+'O^3sg\"\u0012a!N\u0001Bi\u0016\u001cHo\u0011:fCR,w+\u001b;i!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8u/&$\bn\\;u%\u0016\u0004H.[2bi&|gNR1di>\u00148\u000b[8vY\u0012\u001cVoY2fK\u0012D#aB\u001b\u0002\u0003R,7\u000f^\"sK\u0006$XmV5uQJ+\u0007\u000f\\5dCRLwN\u001c$bGR|'oV5uQ>,H\u000fU1si&$\u0018n\u001c8D_VtGo\u00155pk2$7+^2dK\u0016$\u0007F\u0001\u00056\u0003%\"Xm\u001d;De\u0016\fG/Z,ji\"\f5o]5h]6,g\u000e^!oIB\u000b'\u000f^5uS>t7i\\;oi\"\u0012\u0011\"N\u0001-i\u0016\u001cHo\u0011:fCR,w+\u001b;i\u0003N\u001c\u0018n\u001a8nK:$\u0018I\u001c3SKBd\u0017nY1uS>tg)Y2u_JD#AC\u001b\u0002\u0001R,7\u000f^\"sK\u0006$XmV5uQ>,H\u000fU1si&$\u0018n\u001c8D_VtG/\u00118e%\u0016\u0004H.[2bi&|gNR1di>\u00148\u000b[8vY\u0012\u001cVoY2fK\u0012D#aC\u001b\u00023Q,7\u000f\u001e#fg\u000e\u0014\u0018NY3TQ>,H\u000eZ*vG\u000e,W\r\u001a\u0015\u0003\u0019U\n1\u0005^3tiB\u000b'o]3BgNLwM\\7f]R$U\u000f\u001d7jG\u0006$X-\u00128ue&,7\u000f\u000b\u0002\u000ek\u0005aC/Z:u!\u0006\u00148/Z!tg&<g.\\3oiB\u000b'\u000f^5uS>t7o\u00144ES\u001a4WM]3oiNK'0\u001a\u0015\u0003\u001dU\n1\u0003^3tiB\u000b'o]3BgNLwM\\7f]RD#aD\u001b\u0002wQ,7\u000f^\"sK\u0006$X\rV8qS\u000e$u.Z:O_R\u0014V\r\u001e:z)\"\u0014x\u000e\u001e;mS:<\u0017+^8uC\u0016C8-Z3eK\u0012,\u0005pY3qi&|g\u000e\u000b\u0002\u0011k\u0005YD/Z:u\t\u0016dW\r^3U_BL7\rR8fg:{GOU3uef$\u0006N]8ui2LgnZ)v_R\fW\t_2fK\u0012,G-\u0012=dKB$\u0018n\u001c8)\u0005E)\u0014\u0001\u0011;fgR\u001c%/Z1uKB\u000b'\u000f^5uS>t7\u000fR8fg:{GOU3uef$\u0006N]8ui2LgnZ)v_R\fW\t_2fK\u0012,G-\u0012=dKB$\u0018n\u001c8)\u0005I)\u0014aF1tg\u0016\u0014Ho\u00115fG.\f%oZ:Fq&$8i\u001c3f)\r\tt\f\u001a\u0005\u0006AN\u0001\r!Y\u0001\tKb\u0004Xm\u0019;fIB\u0011ADY\u0005\u0003Gv\u00111!\u00138u\u0011\u0015)7\u00031\u0001g\u0003\u001dy\u0007\u000f^5p]N\u0004\"aZ9\u000f\u0005!|gBA5o\u001d\tQW.D\u0001l\u0015\ta\u0017$\u0001\u0004=e>|GOP\u0005\u00021%\u0011acF\u0005\u0003aV\tA\u0002V8qS\u000e\u001cu.\\7b]\u0012L!A]:\u0003'Q{\u0007/[2D_6l\u0017M\u001c3PaRLwN\\:\u000b\u0005A,\u0002")
public class TopicCommandTest {
    private final String brokerList;
    private final String topicName;

    @Test
    public void testIsNotUnderReplicatedWhenAdding() {
        List replicaIds = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}));
        List replicas = (List)replicaIds.map((Function1 & Serializable & scala.Serializable)id -> TopicCommandTest.$anonfun$testIsNotUnderReplicatedWhenAdding$1(BoxesRunTime.unboxToInt((Object)id)), List$.MODULE$.canBuildFrom());
        Assertions.assertFalse((boolean)new TopicCommand.PartitionDescription("test-topic", new TopicPartitionInfo(0, new Node(1, "localhost", 9091), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)replicas).asJava(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new Node(1, "localhost", 9091), (List)Nil$.MODULE$)).asJava()), (Option)None$.MODULE$, false, (Option)new Some((Object)new PartitionReassignment((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)replicaIds.map((Function1 & Serializable & scala.Serializable)id -> Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)id)), List$.MODULE$.canBuildFrom())).asJava(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)Nil$.MODULE$)).asJava(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.empty()).asJava()))).isUnderReplicated());
    }

    @Test
    public void testAlterWithUnspecifiedPartitionCount() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList, "--alter", "--topic", this.topicName})));
    }

    @Test
    public void testConfigOptWithBootstrapServers() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList, "--alter", "--topic", this.topicName, "--partitions", "3", "--config", "cleanup.policy=compact"})));
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList, "--alter", "--topic", this.topicName, "--partitions", "3", "--delete-config", "cleanup.policy"})));
        TopicCommand.TopicCommandOptions opts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList, "--create", "--topic", this.topicName, "--partitions", "3", "--replication-factor", "3", "--config", "cleanup.policy=compact"}));
        opts.checkArgs();
        Assertions.assertTrue((boolean)opts.hasCreateOption());
        Assertions.assertEquals((Object)this.brokerList, (Object)opts.bootstrapServer().get());
        Assertions.assertEquals((Object)"cleanup.policy=compact", ((java.util.List)opts.topicConfig().get()).get(0));
    }

    @Test
    public void testCreateWithPartitionCountWithoutReplicationFactorShouldSucceed() {
        new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList, "--create", "--partitions", "2", "--topic", this.topicName})).checkArgs();
    }

    @Test
    public void testCreateWithReplicationFactorWithoutPartitionCountShouldSucceed() {
        new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList, "--create", "--replication-factor", "3", "--topic", this.topicName})).checkArgs();
    }

    @Test
    public void testCreateWithAssignmentAndPartitionCount() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList, "--create", "--replica-assignment", "3:0,5:1", "--partitions", "2", "--topic", this.topicName})));
    }

    @Test
    public void testCreateWithAssignmentAndReplicationFactor() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList, "--create", "--replica-assignment", "3:0,5:1", "--replication-factor", "2", "--topic", this.topicName})));
    }

    @Test
    public void testCreateWithoutPartitionCountAndReplicationFactorShouldSucceed() {
        new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList, "--create", "--topic", this.topicName})).checkArgs();
    }

    @Test
    public void testDescribeShouldSucceed() {
        new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList, "--describe", "--topic", this.topicName})).checkArgs();
    }

    @Test
    public void testParseAssignmentDuplicateEntries() {
        Assertions.assertThrows(AdminCommandFailedException.class, () -> TopicCommand$.MODULE$.parseReplicaAssignment("5:5"));
    }

    @Test
    public void testParseAssignmentPartitionsOfDifferentSize() {
        Assertions.assertThrows(AdminOperationException.class, () -> TopicCommand$.MODULE$.parseReplicaAssignment("5:4:3,2:1"));
    }

    @Test
    public void testParseAssignment() {
        Map actualAssignment = TopicCommand$.MODULE$.parseReplicaAssignment("5:4,3:2,1:0");
        Assertions.assertEquals((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0})))}))), (Object)actualAssignment);
    }

    @Test
    public void testCreateTopicDoesNotRetryThrottlingQuotaExceededException() {
        Admin adminClient = (Admin)Mockito.mock(Admin.class);
        TopicCommand.TopicService topicService = TopicCommand.TopicService$.MODULE$.apply(adminClient);
        CreateTopicsResult result = AdminClientTestUtils.createTopicsResult((String)this.topicName, (Throwable)Errors.THROTTLING_QUOTA_EXCEEDED.exception());
        Mockito.when((Object)adminClient.createTopics((Collection)ArgumentMatchers.any(), (CreateTopicsOptions)ArgumentMatchers.any())).thenReturn((Object)result);
        Assertions.assertThrows(ThrottlingQuotaExceededException.class, () -> topicService.createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", $this.topicName}))));
        NewTopic expectedNewTopic = new NewTopic(this.topicName, Optional.empty(), Optional.empty()).configs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().empty()).asJava());
        ((Admin)Mockito.verify((Object)adminClient, (VerificationMode)Mockito.times((int)1))).createTopics((Collection)ArgumentMatchers.eq((Object)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{expectedNewTopic}))).asJava()), (CreateTopicsOptions)ArgumentMatchers.argThat(x$1 -> !x$1.shouldRetryOnQuotaViolation()));
    }

    @Test
    public void testDeleteTopicDoesNotRetryThrottlingQuotaExceededException() {
        Admin adminClient = (Admin)Mockito.mock(Admin.class);
        TopicCommand.TopicService topicService = TopicCommand.TopicService$.MODULE$.apply(adminClient);
        ListTopicsResult listResult = AdminClientTestUtils.listTopicsResult((String)this.topicName);
        Mockito.when((Object)adminClient.listTopics((ListTopicsOptions)ArgumentMatchers.any())).thenReturn((Object)listResult);
        DeleteTopicsResult result = AdminClientTestUtils.deleteTopicsResult((String)this.topicName, (Throwable)Errors.THROTTLING_QUOTA_EXCEEDED.exception());
        Mockito.when((Object)adminClient.deleteTopics((Collection)ArgumentMatchers.any(), (DeleteTopicsOptions)ArgumentMatchers.any())).thenReturn((Object)result);
        Assertions.assertTrue((boolean)(((ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> topicService.deleteTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", $this.topicName}))))).getCause() instanceof ThrottlingQuotaExceededException));
        ((Admin)Mockito.verify((Object)adminClient)).deleteTopics((Collection)ArgumentMatchers.argThat(topics -> ((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(topics).asScala()).toBuffer().equals((Object)new .colon.colon((Object)$this.topicName, (List)Nil$.MODULE$))), (DeleteTopicsOptions)ArgumentMatchers.argThat(options -> !options.shouldRetryOnQuotaViolation()));
    }

    @Test
    public void testCreatePartitionsDoesNotRetryThrottlingQuotaExceededException() {
        Admin adminClient = (Admin)Mockito.mock(Admin.class);
        TopicCommand.TopicService topicService = TopicCommand.TopicService$.MODULE$.apply(adminClient);
        ListTopicsResult listResult = AdminClientTestUtils.listTopicsResult((String)this.topicName);
        Mockito.when((Object)adminClient.listTopics((ListTopicsOptions)ArgumentMatchers.any())).thenReturn((Object)listResult);
        TopicPartitionInfo topicPartitionInfo = new TopicPartitionInfo(0, new Node(0, "", 0), Collections.emptyList(), Collections.emptyList());
        DescribeTopicsResult describeResult = AdminClientTestUtils.describeTopicsResult((String)this.topicName, (TopicDescription)new TopicDescription(this.topicName, false, Collections.singletonList(topicPartitionInfo)));
        Mockito.when((Object)adminClient.describeTopics((Collection)ArgumentMatchers.any(Collection.class))).thenReturn((Object)describeResult);
        CreatePartitionsResult result = AdminClientTestUtils.createPartitionsResult((String)this.topicName, (Throwable)Errors.THROTTLING_QUOTA_EXCEEDED.exception());
        Mockito.when((Object)adminClient.createPartitions((java.util.Map)ArgumentMatchers.any(), (CreatePartitionsOptions)ArgumentMatchers.any())).thenReturn((Object)result);
        Assertions.assertTrue((boolean)(((ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> topicService.alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", $this.topicName, "--partitions", "3"}))))).getCause() instanceof ThrottlingQuotaExceededException));
        ((Admin)Mockito.verify((Object)adminClient, (VerificationMode)Mockito.times((int)1))).createPartitions((java.util.Map)ArgumentMatchers.argThat(x$2 -> ((NewPartitions)x$2.get($this.topicName)).totalCount() == 3), (CreatePartitionsOptions)ArgumentMatchers.argThat(x$3 -> !x$3.shouldRetryOnQuotaViolation()));
    }

    /*
     * WARNING - void declaration
     */
    private void assertCheckArgsExitCode(int expected, TopicCommand.TopicCommandOptions options) {
        void setExitProcedure_exitProcedure;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(exitCode, x$4) -> TopicCommandTest.$anonfun$assertCheckArgsExitCode$1(expected, BoxesRunTime.unboxToInt((Object)exitCode), x$4);
        if (Exit$.MODULE$ == null) {
            throw null;
        }
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        try {
            Assertions.assertThrows(RuntimeException.class, () -> options.checkArgs());
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
    }

    public static final /* synthetic */ Node $anonfun$testIsNotUnderReplicatedWhenAdding$1(int id) {
        return new Node(id, "localhost", 9090 + id);
    }

    public static final /* synthetic */ Nothing$ $anonfun$assertCheckArgsExitCode$1(int expected$1, int exitCode, Option x$4) {
        Assertions.assertEquals((int)expected$1, (int)exitCode);
        throw new RuntimeException();
    }

    public TopicCommandTest() {
        this.brokerList = "localhost:9092";
        this.topicName = "topicName";
    }
}

