/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.Properties;
import kafka.api.AbstractConsumerTest;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.utils.ShutdownableThread;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.clients.consumer.RetriableCommitFailedException;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0011Mg!B4i\u0003\u0003i\u0007\"\u0002;\u0001\t\u0003)\bb\u0002=\u0001\u0005\u0004%\t!\u001f\u0005\b\u0003\u0003\u0001\u0001\u0015!\u0003{\u0011\u001d\t\u0019\u0001\u0001C!\u0003\u000bA\u0011\"!\u0004\u0001\u0005\u0004%\t!a\u0004\t\u0011\u0005\u0005\u0002\u0001)A\u0005\u0003#A\u0011\"a\t\u0001\u0005\u0004%\t!!\u0002\t\u0011\u0005\u0015\u0002\u0001)A\u0005\u0003\u000fA\u0011\"a\n\u0001\u0005\u0004%\t!!\u000b\t\u0011\u0005\u0005\u0003\u0001)A\u0005\u0003WA\u0011\"a\u0011\u0001\u0005\u0004%\t!!\u0002\t\u0011\u0005\u0015\u0003\u0001)A\u0005\u0003\u000fA\u0011\"a\u0012\u0001\u0005\u0004%\t!!\u000b\t\u0011\u0005%\u0003\u0001)A\u0005\u0003WA\u0011\"a\u0013\u0001\u0005\u0004%\t!a\u0004\t\u0011\u00055\u0003\u0001)A\u0005\u0003#A\u0011\"a\u0014\u0001\u0005\u0004%\t!a\u0004\t\u0011\u0005E\u0003\u0001)A\u0005\u0003#A\u0011\"a\u0015\u0001\u0005\u0004%\t!a\u0004\t\u0011\u0005U\u0003\u0001)A\u0005\u0003#A\u0011\"a\u0016\u0001\u0005\u0004%\t!!\u0017\t\u0011\u0005\u0005\u0004\u0001)A\u0005\u00037Bq!a\u0019\u0001\t#\n)\u0007C\u0004\u0002~\u0001!\t%a \u0007\r\u0005}\u0005\u0001CAQ\u0011\u0019!\u0018\u0004\"\u0001\u0002:\"I\u0011qX\rA\u0002\u0013\u0005\u0011Q\u0001\u0005\n\u0003\u0003L\u0002\u0019!C\u0001\u0003\u0007D\u0001\"!3\u001aA\u0003&\u0011q\u0001\u0005\n\u0003\u0017L\u0002\u0019!C\u0001\u0003\u000bA\u0011\"!4\u001a\u0001\u0004%\t!a4\t\u0011\u0005M\u0017\u0004)Q\u0005\u0003\u000fAq!!6\u001a\t\u0003\t9\u000eC\u0004\u0002df!\t!!:\t\u000f\u0005%\b\u0001\"\u0005\u0002l\"9!q\u0003\u0001\u0005\u0012\te\u0001\"\u0003B&\u0001E\u0005I\u0011\u0003B'\u0011\u001d\u0011\u0019\u0007\u0001C\t\u0005KB\u0011B!%\u0001#\u0003%\tBa%\t\u0013\t]\u0005!%A\u0005\u0012\t5\u0003\"\u0003BM\u0001E\u0005I\u0011\u0003BN\u0011%\u0011y\nAI\u0001\n#\u0011\t\u000bC\u0005\u0003&\u0002\t\n\u0011\"\u0005\u0003\u0014\"9!q\u0015\u0001\u0005\u0012\t%\u0006\"\u0003Bt\u0001E\u0005I\u0011\u0003Bu\u0011\u001d\u0011y\u000f\u0001C\t\u0005cDqaa\u0002\u0001\t#\u0019I\u0001C\u0005\u00040\u0001\t\n\u0011\"\u0005\u00042!911\b\u0001\u0005\u0002\ru\u0002\"\u0003C\u0002\u0001E\u0005I\u0011\u0001C\u0003\u0011\u001d!I\u0001\u0001C\u0001\t\u0017A\u0011\u0002\"\u0007\u0001#\u0003%\t\u0001\"\u0002\t\u000f\u0011m\u0001\u0001\"\u0001\u0005\u001e!IA1\u0007\u0001\u0012\u0002\u0013\u0005AQ\u0007\u0005\n\ts\u0001\u0011\u0013!C\u0001\u0005\u001bB\u0011\u0002b\u000f\u0001#\u0003%\t\u0001\"\u0010\t\u000f\u0011\u0005\u0003\u0001\"\u0001\u0005D!IA1\n\u0001\u0012\u0002\u0013\u0005AQ\n\u0005\b\t#\u0002A\u0011\u0003C*\u0011\u001d!I\u0007\u0001C\t\tW2a\u0001\"!\u0001\u0011\u0011\r\u0005B\u0002;>\t\u0003!Y\tC\u0005\u0005\u0010v\u0002\r\u0011\"\u0001\u0002\u0006!IA\u0011S\u001fA\u0002\u0013\u0005A1\u0013\u0005\t\t/k\u0004\u0015)\u0003\u0002\b!IA\u0011T\u001fA\u0002\u0013\u0005\u0011Q\u0001\u0005\n\t7k\u0004\u0019!C\u0001\t;C\u0001\u0002\")>A\u0003&\u0011q\u0001\u0005\n\tGk\u0004\u0019!C\u0001\tKC\u0011\u0002b,>\u0001\u0004%\t\u0001\"-\t\u0011\u0011UV\b)Q\u0005\tOCq\u0001b.>\t\u0003\"IL\u0002\u0004\u0004P\u0001A1\u0011\u000b\u0005\u000b\u0003_K%\u0011!Q\u0001\n\t%\u0004BCB0\u0013\n\u0005\t\u0015!\u0003\u0004b!Q1qM%\u0003\u0002\u0003\u0006IAa=\t\u0015\r%\u0014J!A!\u0002\u0013\tI\u000b\u0003\u0004u\u0013\u0012\u000511\u000e\u0005\u0007i&#\ta!\u001e\t\rQLE\u0011AB>\u0011%\u0019\t)\u0013a\u0001\n\u0003\u0019\u0019\tC\u0005\u0004\u000e&\u0003\r\u0011\"\u0001\u0004\u0010\"A11S%!B\u0013\u0019)\tC\u0005\u0004\u001e&\u0003\r\u0011\"\u0001\u0002\u0006!I1qT%A\u0002\u0013\u00051\u0011\u0015\u0005\t\u0007KK\u0005\u0015)\u0003\u0002\b!I1\u0011V%C\u0002\u0013%11\u0016\u0005\t\u0007cK\u0005\u0015!\u0003\u0004.\"I11W%A\u0002\u0013%1Q\u0017\u0005\n\u0007{K\u0005\u0019!C\u0005\u0007\u007fC\u0001ba1JA\u0003&1q\u0017\u0005\n\u0007\u000fL\u0005\u0019!C\u0005\u0007\u0013D\u0011ba3J\u0001\u0004%Ia!4\t\u0011\rE\u0017\n)Q\u0005\u0007CB\u0011ba5J\u0005\u0004%\ta!6\t\u0011\r]\u0017\n)A\u0005\u0003SCqa!7J\t\u0003\u0019Y\u000eC\u0004\u0004^&#\taa8\t\u000f\r\u0015\u0018\n\"\u0001\u00046\"91q]%\u0005B\r%\bbBBv\u0013\u0012\u00053Q\u001e\u0005\b\t\u000f\u0004A\u0011\u0001Ce\u0005Q\t%m\u001d;sC\u000e$8i\u001c8tk6,'\u000fV3ti*\u0011\u0011N[\u0001\u0004CBL'\"A6\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\u001c\t\u0003_Jl\u0011\u0001\u001d\u0006\u0003c*\faa]3sm\u0016\u0014\u0018BA:q\u0005=\u0011\u0015m]3SKF,Xm\u001d;UKN$\u0018A\u0002\u001fj]&$h\bF\u0001w!\t9\b!D\u0001i\u0003\u001d)\u0007o]5m_:,\u0012A\u001f\t\u0003wzl\u0011\u0001 \u0006\u0002{\u0006)1oY1mC&\u0011q\u0010 \u0002\u0007\t>,(\r\\3\u0002\u0011\u0015\u00048/\u001b7p]\u0002\n1B\u0019:pW\u0016\u00148i\\;oiV\u0011\u0011q\u0001\t\u0004w\u0006%\u0011bAA\u0006y\n\u0019\u0011J\u001c;\u0002\u000bQ|\u0007/[2\u0016\u0005\u0005E\u0001\u0003BA\n\u0003;i!!!\u0006\u000b\t\u0005]\u0011\u0011D\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u001c\u0005!!.\u0019<b\u0013\u0011\ty\"!\u0006\u0003\rM#(/\u001b8h\u0003\u0019!x\u000e]5dA\u0005!\u0001/\u0019:u\u0003\u0015\u0001\u0018M\u001d;!\u0003\t!\b/\u0006\u0002\u0002,A!\u0011QFA\u001f\u001b\t\tyC\u0003\u0003\u00022\u0005M\u0012AB2p[6|gNC\u0002l\u0003kQA!a\u000e\u0002:\u00051\u0011\r]1dQ\u0016T!!a\u000f\u0002\u0007=\u0014x-\u0003\u0003\u0002@\u0005=\"A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0004iB\u0004\u0013!\u00029beR\u0014\u0014A\u00029beR\u0014\u0004%A\u0002uaJ\nA\u0001\u001e93A\u0005)qM]8va\u00061qM]8va\u0002\n\u0001\u0003\u001d:pIV\u001cWM]\"mS\u0016tG/\u00133\u0002#A\u0014x\u000eZ;dKJ\u001cE.[3oi&#\u0007%\u0001\td_:\u001cX/\\3s\u00072LWM\u001c;JI\u0006\t2m\u001c8tk6,'o\u00117jK:$\u0018\n\u001a\u0011\u00021\u001d\u0014x.\u001e9NCb\u001cVm]:j_:$\u0016.\\3pkRl5/\u0006\u0002\u0002\\A\u001910!\u0018\n\u0007\u0005}CP\u0001\u0003M_:<\u0017!G4s_V\u0004X*\u0019=TKN\u001c\u0018n\u001c8US6,w.\u001e;Ng\u0002\nqC\u0019:pW\u0016\u0014\bK]8qKJ$\u0018p\u0014<feJLG-Z:\u0015\t\u0005\u001d\u0014Q\u000e\t\u0004w\u0006%\u0014bAA6y\n!QK\\5u\u0011\u001d\tyg\u0006a\u0001\u0003c\n!\u0002\u001d:pa\u0016\u0014H/[3t!\u0011\t\u0019(!\u001f\u000e\u0005\u0005U$\u0002BA<\u00033\tA!\u001e;jY&!\u00111PA;\u0005)\u0001&o\u001c9feRLWm]\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0005\u0003O\n\t\tC\u0004\u0002\u0004b\u0001\r!!\"\u0002\u0011Q,7\u000f^%oM>\u0004B!a\"\u0002\u00146\u0011\u0011\u0011\u0012\u0006\u0004S\u0006-%\u0002BAG\u0003\u001f\u000bqA[;qSR,'O\u0003\u0003\u0002\u0012\u0006e\u0012!\u00026v]&$\u0018\u0002BAK\u0003\u0013\u0013\u0001\u0002V3ti&sgm\u001c\u0015\u00041\u0005e\u0005\u0003BAD\u00037KA!!(\u0002\n\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0003AQ+7\u000f^\"p]N,X.\u001a:SK\u0006\u001c8/[4o[\u0016tG\u000fT5ti\u0016tWM]\n\u00063\u0005\r\u0016\u0011\u0016\t\u0005\u0003'\t)+\u0003\u0003\u0002(\u0006U!AB(cU\u0016\u001cG\u000f\u0005\u0003\u0002,\u0006UVBAAW\u0015\u0011\ty+!-\u0002\u0011\r|gn];nKJTA!a-\u00024\u000591\r\\5f]R\u001c\u0018\u0002BA\\\u0003[\u0013\u0011dQ8ogVlWM\u001d*fE\u0006d\u0017M\\2f\u0019&\u001cH/\u001a8feR\u0011\u00111\u0018\t\u0004\u0003{KR\"\u0001\u0001\u0002\u001f\r\fG\u000e\\:U_\u0006\u001b8/[4oK\u0012\f1cY1mYN$v.Q:tS\u001etW\rZ0%KF$B!a\u001a\u0002F\"I\u0011q\u0019\u000f\u0002\u0002\u0003\u0007\u0011qA\u0001\u0004q\u0012\n\u0014\u0001E2bY2\u001cHk\\!tg&<g.\u001a3!\u00039\u0019\u0017\r\u001c7t)>\u0014VM^8lK\u0012\f!cY1mYN$vNU3w_.,Gm\u0018\u0013fcR!\u0011qMAi\u0011%\t9mHA\u0001\u0002\u0004\t9!A\bdC2d7\u000fV8SKZ|7.\u001a3!\u0003Qyg\u000eU1si&$\u0018n\u001c8t\u0003N\u001c\u0018n\u001a8fIR!\u0011qMAm\u0011\u001d\tY.\ta\u0001\u0003;\f!\u0002]1si&$\u0018n\u001c8t!\u0019\t\u0019(a8\u0002,%!\u0011\u0011]A;\u0005)\u0019u\u000e\u001c7fGRLwN\\\u0001\u0014_:\u0004\u0016M\u001d;ji&|gn\u001d*fm>\\W\r\u001a\u000b\u0005\u0003O\n9\u000fC\u0004\u0002\\\n\u0002\r!!8\u00023\r\u0014X-\u0019;f\u0007>t7/^7fe^KG\u000f[$s_V\u0004\u0018\n\u001a\u000b\u0005\u0003[\fy\u0010\u0005\u0005\u0002,\u0006=\u00181_Az\u0013\u0011\t\t0!,\u0003\u001b-\u000bgm[1D_:\u001cX/\\3s!\u0015Y\u0018Q_A}\u0013\r\t9\u0010 \u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004w\u0006m\u0018bAA\u007fy\n!!)\u001f;f\u0011\u001d\u0011\ta\ta\u0001\u0005\u0007\tqa\u001a:pkBLE\r\u0005\u0003\u0003\u0006\tMa\u0002\u0002B\u0004\u0005\u001f\u00012A!\u0003}\u001b\t\u0011YAC\u0002\u0003\u000e1\fa\u0001\u0010:p_Rt\u0014b\u0001B\ty\u00061\u0001K]3eK\u001aLA!a\b\u0003\u0016)\u0019!\u0011\u0003?\u0002\u0017M,g\u000e\u001a*fG>\u0014Hm\u001d\u000b\u000b\u00057\u0011ID!\u0011\u0003F\t\u001d\u0003C\u0002B\u000f\u0005O\u0011iC\u0004\u0003\u0003 \t\rb\u0002\u0002B\u0005\u0005CI\u0011!`\u0005\u0004\u0005Ka\u0018a\u00029bG.\fw-Z\u0005\u0005\u0005S\u0011YCA\u0002TKFT1A!\n}!!\u0011yC!\u000e\u0002t\u0006MXB\u0001B\u0019\u0015\u0011\u0011\u0019$!-\u0002\u0011A\u0014x\u000eZ;dKJLAAa\u000e\u00032\tq\u0001K]8ek\u000e,'OU3d_J$\u0007b\u0002B\u001aI\u0001\u0007!1\b\t\t\u0005_\u0011i$a=\u0002t&!!q\bB\u0019\u00055Y\u0015MZ6b!J|G-^2fe\"9!1\t\u0013A\u0002\u0005\u001d\u0011A\u00038v[J+7m\u001c:eg\"9\u0011q\u0005\u0013A\u0002\u0005-\u0002\"\u0003B%IA\u0005\t\u0019AA.\u0003E\u0019H/\u0019:uS:<G+[7fgR\fW\u000e]\u0001\u0016g\u0016tGMU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011yE\u000b\u0003\u0002\\\tE3F\u0001B*!\u0011\u0011)Fa\u0018\u000e\u0005\t]#\u0002\u0002B-\u00057\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tuC0\u0001\u0006b]:|G/\u0019;j_:LAA!\u0019\u0003X\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002/\r|gn];nK\u0006sGMV3sS\u001aL(+Z2pe\u0012\u001cHCEA4\u0005O\u0012yG!\u001d\u0003v\te$1\u0010BF\u0005\u001bCq!a,'\u0001\u0004\u0011I\u0007\u0005\u0005\u0002,\n-\u00141_Az\u0013\u0011\u0011i'!,\u0003\u0011\r{gn];nKJDqAa\u0011'\u0001\u0004\t9\u0001C\u0004\u0003t\u0019\u0002\r!a\u0002\u0002\u001dM$\u0018M\u001d;j]\u001e|eMZ:fi\"I!q\u000f\u0014\u0011\u0002\u0003\u0007\u0011qA\u0001\u0019gR\f'\u000f^5oO.+\u00170\u00118e-\u0006dW/Z%oI\u0016D\b\"\u0003B%MA\u0005\t\u0019AA.\u0011%\u0011iH\nI\u0001\u0002\u0004\u0011y(A\u0007uS6,7\u000f^1naRK\b/\u001a\t\u0005\u0005\u0003\u00139)\u0004\u0002\u0003\u0004*!!QQA\u0018\u0003\u0019\u0011XmY8sI&!!\u0011\u0012BB\u00055!\u0016.\\3ti\u0006l\u0007\u000fV=qK\"I\u0011q\u0005\u0014\u0011\u0002\u0003\u0007\u00111\u0006\u0005\n\u0005\u001f3\u0003\u0013!a\u0001\u0003\u000f\ta\"\\1y!>dGNU3d_J$7/A\u0011d_:\u001cX/\\3B]\u00124VM]5gsJ+7m\u001c:eg\u0012\"WMZ1vYR$C'\u0006\u0002\u0003\u0016*\"\u0011q\u0001B)\u0003\u0005\u001awN\\:v[\u0016\fe\u000e\u001a,fe&4\u0017PU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00136\u0003\u0005\u001awN\\:v[\u0016\fe\u000e\u001a,fe&4\u0017PU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00137+\t\u0011iJ\u000b\u0003\u0003\u0000\tE\u0013!I2p]N,X.Z!oIZ+'/\u001b4z%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012:TC\u0001BRU\u0011\tYC!\u0015\u0002C\r|gn];nK\u0006sGMV3sS\u001aL(+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000f\n\u001d\u0002\u001d\r|gn];nKJ+7m\u001c:egV1!1\u0016Bd\u00057$\u0002B!,\u0003`\n\r(Q\u001d\t\u0007\u0005_\u0013IL!0\u000e\u0005\tE&\u0002\u0002BZ\u0005k\u000bq!\\;uC\ndWMC\u0002\u00038r\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011YL!-\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\t\u0003W\u0013yLa1\u0003Z&!!\u0011YAW\u00059\u0019uN\\:v[\u0016\u0014(+Z2pe\u0012\u0004BA!2\u0003H2\u0001Aa\u0002BeY\t\u0007!1\u001a\u0002\u0002\u0017F!!Q\u001aBj!\rY(qZ\u0005\u0004\u0005#d(a\u0002(pi\"Lgn\u001a\t\u0004w\nU\u0017b\u0001Bly\n\u0019\u0011I\\=\u0011\t\t\u0015'1\u001c\u0003\b\u0005;d#\u0019\u0001Bf\u0005\u00051\u0006bBAXY\u0001\u0007!\u0011\u001d\t\t\u0003W\u0013YGa1\u0003Z\"9!1\t\u0017A\u0002\u0005\u001d\u0001\"\u0003BHYA\u0005\t\u0019AA\u0004\u0003a\u0019wN\\:v[\u0016\u0014VmY8sIN$C-\u001a4bk2$HeM\u000b\u0007\u0005'\u0013YO!<\u0005\u000f\t%WF1\u0001\u0003L\u00129!Q\\\u0017C\u0002\t-\u0017!G2sK\u0006$X\rV8qS\u000e\fe\u000eZ*f]\u0012\u0014VmY8sIN$\"Ba=\u0003z\nm(q`B\u0002!\u0019\u0011)A!>\u0002,%!!q\u001fB\u000b\u0005\r\u0019V\r\u001e\u0005\b\u0005gq\u0003\u0019\u0001B\u001e\u0011\u001d\u0011iP\fa\u0001\u0005\u0007\t\u0011\u0002^8qS\u000et\u0015-\\3\t\u000f\r\u0005a\u00061\u0001\u0002\b\u0005ia.^7QCJ$\u0018\u000e^5p]NDqa!\u0002/\u0001\u0004\t9!A\nsK\u000e|'\u000fZ:QKJ\u0004\u0016M\u001d;ji&|g.A\ftK:$\u0017I\u001c3Bo\u0006LG/Q:z]\u000e\u001cu.\\7jiV111BB\n\u0007/!b!a\u001a\u0004\u000e\re\u0001bBAX_\u0001\u00071q\u0002\t\t\u0003W\u0013Yg!\u0005\u0004\u0016A!!QYB\n\t\u001d\u0011Im\fb\u0001\u0005\u0017\u0004BA!2\u0004\u0018\u00119!Q\\\u0018C\u0002\t-\u0007\"CB\u000e_A\u0005\t\u0019AB\u000f\u0003)ygMZ:fiN|\u0005\u000f\u001e\t\u0006w\u000e}11E\u0005\u0004\u0007Ca(AB(qi&|g\u000e\u0005\u0005\u0003\u0006\r\u0015\u00121FB\u0015\u0013\u0011\u00199C!\u0006\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002,\u000e-\u0012\u0002BB\u0017\u0003[\u0013\u0011c\u00144gg\u0016$\u0018I\u001c3NKR\fG-\u0019;b\u0003\u0005\u001aXM\u001c3B]\u0012\fu/Y5u\u0003NLhnY\"p[6LG\u000f\n3fM\u0006,H\u000e\u001e\u00133+\u0019\u0019\u0019da\u000e\u0004:U\u00111Q\u0007\u0016\u0005\u0007;\u0011\t\u0006B\u0004\u0003JB\u0012\rAa3\u0005\u000f\tu\u0007G1\u0001\u0003L\u0006a\u0013\r\u001a3D_:\u001cX/\\3sgR{wI]8va\u0006sGmV1ji\u001a{'o\u0012:pkB\f5o]5h]6,g\u000e\u001e\u000b\u000f\u0007\u007f\u0019yoa=\u0004x\u000em8Q C\u0001!\u001dY8\u0011IB#\u0007\u0017J1aa\u0011}\u0005\u0019!V\u000f\u001d7feA1!qVB$\u0003[LAa!\u0013\u00032\n1!)\u001e4gKJ\u0004bAa,\u0004H\r5\u0003cAA_\u0013\nA2i\u001c8tk6,'/Q:tS\u001etW.\u001a8u!>dG.\u001a:\u0014\u0007%\u001b\u0019\u0006\u0005\u0003\u0004V\rmSBAB,\u0015\r\u0019IF[\u0001\u0006kRLGn]\u0005\u0005\u0007;\u001a9F\u0001\nTQV$Hm\\<oC\ndW\r\u00165sK\u0006$\u0017!\u0005;pa&\u001c7\u000fV8Tk\n\u001c8M]5cKB1!QDB2\u0005\u0007IAa!\u001a\u0003,\t!A*[:u\u0003I\u0001\u0018M\u001d;ji&|gn\u001d+p\u0003N\u001c\u0018n\u001a8\u0002+U\u001cXM\u001d*fE\u0006d\u0017M\\2f\u0019&\u001cH/\u001a8feRQ1QJB7\u0007_\u001a\tha\u001d\t\u000f\u0005=f\n1\u0001\u0003j!91q\f(A\u0002\r\u0005\u0004bBB4\u001d\u0002\u0007!1\u001f\u0005\b\u0007Sr\u0005\u0019AAU)\u0019\u0019iea\u001e\u0004z!9\u0011qV(A\u0002\t%\u0004bBB0\u001f\u0002\u00071\u0011\r\u000b\u0007\u0007\u001b\u001aiha \t\u000f\u0005=\u0006\u000b1\u0001\u0003j!91q\r)A\u0002\tM\u0018a\u0004;ie><h.\u0012=dKB$\u0018n\u001c8\u0016\u0005\r\u0015\u0005#B>\u0004 \r\u001d\u0005\u0003\u0002B\u000f\u0007\u0013KAaa#\u0003,\tIA\u000b\u001b:po\u0006\u0014G.Z\u0001\u0014i\"\u0014xn\u001e8Fq\u000e,\u0007\u000f^5p]~#S-\u001d\u000b\u0005\u0003O\u001a\t\nC\u0005\u0002HJ\u000b\t\u00111\u0001\u0004\u0006\u0006\u0001B\u000f\u001b:po:,\u0005pY3qi&|g\u000e\t\u0015\u0004'\u000e]\u0005cA>\u0004\u001a&\u001911\u0014?\u0003\u0011Y|G.\u0019;jY\u0016\f\u0001C]3dK&4X\rZ'fgN\fw-Z:\u0002)I,7-Z5wK\u0012lUm]:bO\u0016\u001cx\fJ3r)\u0011\t9ga)\t\u0013\u0005\u001dW+!AA\u0002\u0005\u001d\u0011!\u0005:fG\u0016Lg/\u001a3NKN\u001c\u0018mZ3tA!\u001aaka&\u0002'A\f'\u000f^5uS>t\u0017i]:jO:lWM\u001c;\u0016\u0005\r5\u0006C\u0002BX\u0007_\u000bY#\u0003\u0003\u0003x\nE\u0016\u0001\u00069beRLG/[8o\u0003N\u001c\u0018n\u001a8nK:$\b%A\ntk\n\u001c8M]5qi&|gn\u00115b]\u001e,G-\u0006\u0002\u00048B\u00191p!/\n\u0007\rmFPA\u0004C_>dW-\u00198\u0002/M,(m]2sSB$\u0018n\u001c8DQ\u0006tw-\u001a3`I\u0015\fH\u0003BA4\u0007\u0003D\u0011\"a2[\u0003\u0003\u0005\raa.\u0002)M,(m]2sSB$\u0018n\u001c8DQ\u0006tw-\u001a3!Q\rY6qS\u0001\u0013i>\u0004\u0018nY:Tk\n\u001c8M]5qi&|g.\u0006\u0002\u0004b\u00051Bo\u001c9jGN\u001cVOY:de&\u0004H/[8o?\u0012*\u0017\u000f\u0006\u0003\u0002h\r=\u0007\"CAd;\u0006\u0005\t\u0019AB1\u0003M!x\u000e]5dgN+(m]2sSB$\u0018n\u001c8!\u0003E\u0011XMY1mC:\u001cW\rT5ti\u0016tWM]\u000b\u0003\u0003S\u000b!C]3cC2\fgnY3MSN$XM\\3sA\u0005\u00112m\u001c8tk6,'/Q:tS\u001etW.\u001a8u)\t\u0011\u00190A\u0005tk\n\u001c8M]5cKR!\u0011qMBq\u0011\u001d\u0019\u0019O\u0019a\u0001\u0007C\nAC\\3x)>\u0004\u0018nY:U_N+(m]2sS\n,\u0017aG5t'V\u00147o\u0019:jE\u0016\u0014V-];fgR\u0004&o\\2fgN,G-\u0001\tj]&$\u0018.\u0019;f'\",H\u000fZ8x]R\u00111qW\u0001\u0007I><vN]6\u0015\u0005\u0005\u001d\u0004bBByc\u0001\u0007\u0011qA\u0001\u0014]VlwJZ\"p]N,X.\u001a:t)>\fE\r\u001a\u0005\b\u0007k\f\u0004\u0019AB#\u00035\u0019wN\\:v[\u0016\u0014xI]8va\"91\u0011`\u0019A\u0002\r-\u0013aD2p]N,X.\u001a:Q_2dWM]:\t\u000f\r}\u0013\u00071\u0001\u0004b!91q`\u0019A\u0002\tM\u0018!D:vEN\u001c'/\u001b9uS>t7\u000fC\u0005\u0002LE\u0002\n\u00111\u0001\u0003\u0004\u00051\u0014\r\u001a3D_:\u001cX/\\3sgR{wI]8va\u0006sGmV1ji\u001a{'o\u0012:pkB\f5o]5h]6,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%mU\u0011Aq\u0001\u0016\u0005\u0005\u0007\u0011\t&A\nbI\u0012\u001cuN\\:v[\u0016\u00148\u000fV8He>,\b\u000f\u0006\b\u0004@\u00115Aq\u0002C\t\t'!)\u0002b\u0006\t\u000f\rE8\u00071\u0001\u0002\b!91Q_\u001aA\u0002\r\u0015\u0003bBB}g\u0001\u000711\n\u0005\b\u0007?\u001a\u0004\u0019AB1\u0011\u001d\u0019yp\ra\u0001\u0005gD\u0011\"a\u00134!\u0003\u0005\rAa\u0001\u0002;\u0005$GmQ8ogVlWM]:U_\u001e\u0013x.\u001e9%I\u00164\u0017-\u001e7uIY\nqC^1mS\u0012\fG/Z$s_V\u0004\u0018i]:jO:lWM\u001c;\u0015\u0019\u0005\u001dDq\u0004C\u0011\tG!I\u0003\"\f\t\u000f\reX\u00071\u0001\u0004L!91q`\u001bA\u0002\tM\b\"\u0003C\u0013kA\u0005\t\u0019\u0001C\u0014\u0003\ri7o\u001a\t\u0006w\u000e}!1\u0001\u0005\n\tW)\u0004\u0013!a\u0001\u00037\n\u0001b^1jiRKW.\u001a\u0005\n\t_)\u0004\u0013!a\u0001\tc\t!#\u001a=qK\u000e$X\rZ!tg&<g.\\3oiB1!qVB$\u0005g\f\u0011E^1mS\u0012\fG/Z$s_V\u0004\u0018i]:jO:lWM\u001c;%I\u00164\u0017-\u001e7uIM*\"\u0001b\u000e+\t\u0011\u001d\"\u0011K\u0001\"m\u0006d\u0017\u000eZ1uK\u001e\u0013x.\u001e9BgNLwM\\7f]R$C-\u001a4bk2$H\u0005N\u0001\"m\u0006d\u0017\u000eZ1uK\u001e\u0013x.\u001e9BgNLwM\\7f]R$C-\u001a4bk2$H%N\u000b\u0003\t\u007fQC\u0001\"\r\u0003R\u0005\u00013/\u001e2tGJL'-Z\"p]N,X.\u001a:B]\u0012\u001cF/\u0019:u!>dG.\u001b8h)!\u0019i\u0005\"\u0012\u0005H\u0011%\u0003bBAXs\u0001\u0007!\u0011\u000e\u0005\b\u0007?J\u0004\u0019AB1\u0011%\u00199'\u000fI\u0001\u0002\u0004\u0011\u00190\u0001\u0016tk\n\u001c8M]5cK\u000e{gn];nKJ\fe\u000eZ*uCJ$\bk\u001c7mS:<G\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0011=#\u0006\u0002Bz\u0005#\na\"Y<bSR\u0014VMY1mC:\u001cW\r\u0006\u0004\u0002h\u0011UCq\r\u0005\b\u0003_[\u0004\u0019\u0001C,a\u0019!I\u0006\"\u0018\u0005dAA\u00111\u0016B6\t7\"\t\u0007\u0005\u0003\u0003F\u0012uC\u0001\u0004C0\t+\n\t\u0011!A\u0003\u0002\t-'aA0%cA!!Q\u0019C2\t1!)\u0007\"\u0016\u0002\u0002\u0003\u0005)\u0011\u0001Bf\u0005\ryFE\r\u0005\b\u0007'\\\u0004\u0019AA^\u0003E)gn];sK:{'+\u001a2bY\u0006t7-\u001a\u000b\u0007\u0003O\"i\u0007b \t\u000f\u0005=F\b1\u0001\u0005pA2A\u0011\u000fC;\tw\u0002\u0002\"a+\u0003l\u0011MD\u0011\u0010\t\u0005\u0005\u000b$)\b\u0002\u0007\u0005x\u00115\u0014\u0011!A\u0001\u0006\u0003\u0011YMA\u0002`IM\u0002BA!2\u0005|\u0011aAQ\u0010C7\u0003\u0003\u0005\tQ!\u0001\u0003L\n\u0019q\f\n\u001b\t\u000f\rMG\b1\u0001\u0002<\nY2i\\;oi\u000e{gn];nKJ\u001cu.\\7ji\u000e\u000bG\u000e\u001c2bG.\u001cR!PAR\t\u000b\u0003B!a+\u0005\b&!A\u0011RAW\u0005QyeMZ:fi\u000e{W.\\5u\u0007\u0006dGNY1dWR\u0011AQ\u0012\t\u0004\u0003{k\u0014\u0001D:vG\u000e,7o]\"pk:$\u0018\u0001E:vG\u000e,7o]\"pk:$x\fJ3r)\u0011\t9\u0007\"&\t\u0013\u0005\u001d\u0007)!AA\u0002\u0005\u001d\u0011!D:vG\u000e,7o]\"pk:$\b%A\u0005gC&d7i\\;oi\u0006ia-Y5m\u0007>,h\u000e^0%KF$B!a\u001a\u0005 \"I\u0011qY\"\u0002\u0002\u0003\u0007\u0011qA\u0001\u000bM\u0006LGnQ8v]R\u0004\u0013!\u00037bgR,%O]8s+\t!9\u000bE\u0003|\u0007?!I\u000b\u0005\u0003\u0003\u001e\u0011-\u0016\u0002\u0002CW\u0005W\u0011\u0011\"\u0012=dKB$\u0018n\u001c8\u0002\u001b1\f7\u000f^#se>\u0014x\fJ3r)\u0011\t9\u0007b-\t\u0013\u0005\u001dg)!AA\u0002\u0011\u001d\u0016A\u00037bgR,%O]8sA\u0005QqN\\\"p[BdW\r^3\u0015\r\u0005\u001dD1\u0018Cb\u0011\u001d!i\f\u0013a\u0001\t\u007f\u000bqa\u001c4gg\u0016$8\u000f\u0005\u0005\u0002t\u0011\u0005\u00171FB\u0015\u0013\u0011\u00199#!\u001e\t\u000f\u0011\u0015\u0007\n1\u0001\u0005*\u0006IQ\r_2faRLwN\\\u0001\u001bSN\u0004\u0016M\u001d;ji&|g.Q:tS\u001etW.\u001a8u-\u0006d\u0017\u000e\u001a\u000b\t\u0007o#Y\rb4\u0005R\"9AQ\u001a4A\u0002\u0011E\u0012aC1tg&<g.\\3oiNDq!a7g\u0001\u0004\u0011\u0019\u0010C\u0004\u00050\u0019\u0004\r\u0001\"\r")
public abstract class AbstractConsumerTest
extends BaseRequestTest {
    private final double epsilon;
    private final String topic;
    private final int part;
    private final TopicPartition tp = new TopicPartition(this.topic(), this.part());
    private final int part2;
    private final TopicPartition tp2 = new TopicPartition(this.topic(), this.part2());
    private final String group;
    private final String producerClientId;
    private final String consumerClientId;
    private final long groupMaxSessionTimeoutMs;

    public double epsilon() {
        return this.epsilon;
    }

    @Override
    public int brokerCount() {
        return 3;
    }

    public String topic() {
        return this.topic;
    }

    public int part() {
        return this.part;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public int part2() {
        return this.part2;
    }

    public TopicPartition tp2() {
        return this.tp2;
    }

    public String group() {
        return this.group;
    }

    public String producerClientId() {
        return this.producerClientId;
    }

    public String consumerClientId() {
        return this.consumerClientId;
    }

    public long groupMaxSessionTimeoutMs() {
        return this.groupMaxSessionTimeoutMs;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
        properties.setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "3");
        properties.setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        properties.setProperty(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "100");
        properties.setProperty(KafkaConfig$.MODULE$.GroupMaxSessionTimeoutMsProp(), Long.toString(this.groupMaxSessionTimeoutMs()));
        properties.setProperty(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "10");
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
    }

    public KafkaConsumer<byte[], byte[]> createConsumerWithGroupId(String groupId) {
        Properties groupOverrideConfig = new Properties();
        groupOverrideConfig.setProperty("group.id", groupId);
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        return this.createConsumer(x$2, x$3, groupOverrideConfig, x$4);
    }

    public Seq<ProducerRecord<byte[], byte[]>> sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, TopicPartition tp, long startingTimestamp) {
        IndexedSeq records = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable & scala.Serializable)i -> AbstractConsumerTest.$anonfun$sendRecords$1(startingTimestamp, tp, producer, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        producer.flush();
        return records;
    }

    public long sendRecords$default$4() {
        return System.currentTimeMillis();
    }

    public void consumeAndVerifyRecords(Consumer<byte[], byte[]> consumer, int numRecords, int startingOffset, int startingKeyAndValueIndex, long startingTimestamp, TimestampType timestampType, TopicPartition tp, int maxPollRecords) {
        ArrayBuffer<ConsumerRecord<byte[], byte[]>> records = this.consumeRecords(consumer, numRecords, maxPollRecords);
        long now = System.currentTimeMillis();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            ConsumerRecord record = (ConsumerRecord)records.apply(i);
            int offset = startingOffset + i;
            Assertions.assertEquals((Object)tp.topic(), (Object)record.topic());
            Assertions.assertEquals((int)tp.partition(), (int)record.partition());
            TimestampType timestampType = timestampType;
            TimestampType timestampType2 = TimestampType.CREATE_TIME;
            if (!(timestampType != null ? !timestampType.equals(timestampType2) : timestampType2 != null)) {
                Assertions.assertEquals((Object)timestampType, (Object)record.timestampType());
                Assertions.assertEquals((long)(startingTimestamp + (long)i), (long)record.timestamp());
            } else {
                Assertions.assertTrue((record.timestamp() >= startingTimestamp && record.timestamp() <= now ? 1 : 0) != 0, (String)new StringBuilder(60).append("Got unexpected timestamp ").append(record.timestamp()).append(". Timestamp should be between [").append(startingTimestamp).append(", ").append(now).append("}]").toString());
            }
            Assertions.assertEquals((long)offset, (long)record.offset());
            int keyAndValueIndex = startingKeyAndValueIndex + i;
            Assertions.assertEquals((Object)new StringBuilder(4).append("key ").append(keyAndValueIndex).toString(), (Object)new String((byte[])record.key()));
            Assertions.assertEquals((Object)new StringBuilder(6).append("value ").append(keyAndValueIndex).toString(), (Object)new String((byte[])record.value()));
            Assertions.assertEquals((int)new StringBuilder(4).append("key ").append(keyAndValueIndex).toString().length(), (int)record.serializedKeySize());
            Assertions.assertEquals((int)new StringBuilder(6).append("value ").append(keyAndValueIndex).toString().length(), (int)record.serializedValueSize());
        });
    }

    public int consumeAndVerifyRecords$default$4() {
        return 0;
    }

    public long consumeAndVerifyRecords$default$5() {
        return 0L;
    }

    public TimestampType consumeAndVerifyRecords$default$6() {
        return TimestampType.CREATE_TIME;
    }

    public TopicPartition consumeAndVerifyRecords$default$7() {
        return this.tp();
    }

    public int consumeAndVerifyRecords$default$8() {
        return Integer.MAX_VALUE;
    }

    public <K, V> ArrayBuffer<ConsumerRecord<K, V>> consumeRecords(Consumer<K, V> consumer, int numRecords, int maxPollRecords) {
        ArrayBuffer records = new ArrayBuffer();
        Function1 & Serializable & scala.Serializable x$2 = (Function1 & Serializable & scala.Serializable)polledRecords -> BoxesRunTime.boxToBoolean((boolean)AbstractConsumerTest.pollAction$1(polledRecords, maxPollRecords, records, numRecords));
        long x$3 = 60000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long pollRecordsUntilTrue_x$3 = 0L;
        long pollRecordsUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$pollRecordsUntilTrue$1(consumer, x$2)) {
            if (System.currentTimeMillis() > pollRecordsUntilTrue_waitUntilTrue_startTime + x$3) {
                Assertions.fail((String)AbstractConsumerTest.$anonfun$consumeRecords$2(numRecords, records));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(x$3), pollRecordsUntilTrue_x$3));
        }
        return records;
    }

    public <K, V> int consumeRecords$default$3() {
        return Integer.MAX_VALUE;
    }

    public scala.collection.immutable.Set<TopicPartition> createTopicAndSendRecords(KafkaProducer<byte[], byte[]> producer, String topicName, int numPartitions, int recordsPerPartition) {
        this.createTopic(topicName, numPartitions, this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        ObjectRef parts = ObjectRef.create((Object)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partition -> {
            TopicPartition tp = new TopicPartition(topicName, partition);
            this.sendRecords(producer, recordsPerPartition, tp, this.sendRecords$default$4());
            parts$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)parts$1.elem).$plus((Object)tp);
        });
        return (scala.collection.immutable.Set)parts.elem;
    }

    /*
     * WARNING - void declaration
     */
    public <K, V> void sendAndAwaitAsyncCommit(Consumer<K, V> consumer, Option<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>> offsetsOpt) {
        void pollUntilTrue_action;
        public class Kafka_api_AbstractConsumerTest$RetryCommitCallback$1
        implements OffsetCommitCallback {
            private boolean isComplete;
            private Option<Exception> error;
            private final /* synthetic */ AbstractConsumerTest $outer;
            private final Option offsetsOpt$1;
            private final Consumer consumer$1;

            public boolean isComplete() {
                return this.isComplete;
            }

            public void isComplete_$eq(boolean x$1) {
                this.isComplete = x$1;
            }

            public Option<Exception> error() {
                return this.error;
            }

            public void error_$eq(Option<Exception> x$1) {
                this.error = x$1;
            }

            public void onComplete(java.util.Map<TopicPartition, OffsetAndMetadata> offsets, Exception exception) {
                if (exception instanceof RetriableCommitFailedException) {
                    AbstractConsumerTest.kafka$api$AbstractConsumerTest$$sendAsyncCommit$1(this, this.offsetsOpt$1, this.consumer$1);
                    return;
                }
                this.isComplete_$eq(true);
                this.error_$eq((Option<Exception>)Option$.MODULE$.apply((Object)exception));
            }

            public Kafka_api_AbstractConsumerTest$RetryCommitCallback$1(AbstractConsumerTest $outer, Option offsetsOpt$1, Consumer consumer$1) {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offsetsOpt$1 = offsetsOpt$1;
                this.consumer$1 = consumer$1;
                this.isComplete = false;
                this.error = None$.MODULE$;
            }
        }
        Kafka_api_AbstractConsumerTest$RetryCommitCallback$1 commitCallback = new Kafka_api_AbstractConsumerTest$RetryCommitCallback$1(this, offsetsOpt, consumer);
        AbstractConsumerTest.kafka$api$AbstractConsumerTest$$sendAsyncCommit$1(commitCallback, offsetsOpt, consumer);
        long l = 10000L;
        JFunction0.mcZ.sp & Serializable & scala.Serializable intersect = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> commitCallback.isComplete();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long pollUntilTrue_x$3 = 0L;
        long pollUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$pollUntilTrue$1(consumer, (Function0)pollUntilTrue_action)) {
            void pollUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > pollUntilTrue_waitUntilTrue_startTime + pollUntilTrue_waitTimeMs) {
                Assertions.fail((String)AbstractConsumerTest.$anonfun$sendAndAwaitAsyncCommit$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)pollUntilTrue_waitTimeMs), pollUntilTrue_x$3));
        }
        Assertions.assertEquals((Object)None$.MODULE$, commitCallback.error());
    }

    public <K, V> Option<scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>> sendAndAwaitAsyncCommit$default$2() {
        return None$.MODULE$;
    }

    public Tuple2<Buffer<KafkaConsumer<byte[], byte[]>>, Buffer<ConsumerAssignmentPoller>> addConsumersToGroupAndWaitForGroupAssignment(int numOfConsumersToAdd, Buffer<KafkaConsumer<byte[], byte[]>> consumerGroup, Buffer<ConsumerAssignmentPoller> consumerPollers, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions, String group) {
        Assertions.assertTrue((consumerGroup.size() + numOfConsumersToAdd <= subscriptions.size() ? 1 : 0) != 0);
        this.addConsumersToGroup(numOfConsumersToAdd, consumerGroup, consumerPollers, topicsToSubscribe, subscriptions, group);
        this.validateGroupAssignment(consumerPollers, subscriptions, this.validateGroupAssignment$default$3(), this.validateGroupAssignment$default$4(), this.validateGroupAssignment$default$5());
        return new Tuple2(consumerGroup, consumerPollers);
    }

    public Tuple2<Buffer<KafkaConsumer<byte[], byte[]>>, Buffer<ConsumerAssignmentPoller>> addConsumersToGroup(int numOfConsumersToAdd, Buffer<KafkaConsumer<byte[], byte[]>> consumerGroup, Buffer<ConsumerAssignmentPoller> consumerPollers, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> subscriptions, String group) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numOfConsumersToAdd).foreach((Function1 & Serializable & scala.Serializable)_ -> AbstractConsumerTest.$anonfun$addConsumersToGroup$1(this, group, consumerGroup, consumerPollers, topicsToSubscribe, BoxesRunTime.unboxToInt((Object)_)));
        return new Tuple2(consumerGroup, consumerPollers);
    }

    public String addConsumersToGroupAndWaitForGroupAssignment$default$6() {
        return this.group();
    }

    public String addConsumersToGroup$default$6() {
        return this.group();
    }

    /*
     * WARNING - void declaration
     */
    public void validateGroupAssignment(Buffer<ConsumerAssignmentPoller> consumerPollers, scala.collection.immutable.Set<TopicPartition> subscriptions, Option<String> msg, long waitTime, Buffer<scala.collection.immutable.Set<TopicPartition>> expectedAssignment) {
        Buffer assignments = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AbstractConsumerTest.$anonfun$validateGroupAssignment$1(this, assignments, consumerPollers, subscriptions, expectedAssignment)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitTime) {
                Assertions.fail((String)AbstractConsumerTest.$anonfun$validateGroupAssignment$3(msg, subscriptions, assignments));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitTime), (long)waitUntilTrue_pause));
        }
    }

    public Option<String> validateGroupAssignment$default$3() {
        return None$.MODULE$;
    }

    public long validateGroupAssignment$default$4() {
        return 10000L;
    }

    public Buffer<scala.collection.immutable.Set<TopicPartition>> validateGroupAssignment$default$5() {
        return (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public ConsumerAssignmentPoller subscribeConsumerAndStartPolling(Consumer<byte[], byte[]> consumer, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> partitionsToAssign) {
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        ConsumerAssignmentPoller consumerPoller = topicsToSubscribe.nonEmpty() ? new ConsumerAssignmentPoller(this, consumer, topicsToSubscribe) : new ConsumerAssignmentPoller(this, consumer, partitionsToAssign);
        consumerPoller.start();
        return consumerPoller;
    }

    public scala.collection.immutable.Set<TopicPartition> subscribeConsumerAndStartPolling$default$3() {
        return Predef$.MODULE$.Set().empty();
    }

    /*
     * WARNING - void declaration
     */
    public void awaitRebalance(Consumer<?, ?> consumer, TestConsumerReassignmentListener rebalanceListener) {
        void pollUntilTrue_action;
        int numReassignments = rebalanceListener.callsToAssigned();
        long l = TestUtils$.MODULE$.pollUntilTrue$default$4();
        JFunction0.mcZ.sp & Serializable & scala.Serializable intersect = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> rebalanceListener.callsToAssigned() > numReassignments;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long pollUntilTrue_x$3 = 0L;
        long pollUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.$anonfun$pollUntilTrue$1(consumer, (Function0)pollUntilTrue_action)) {
            void pollUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > pollUntilTrue_waitUntilTrue_startTime + pollUntilTrue_waitTimeMs) {
                Assertions.fail((String)AbstractConsumerTest.$anonfun$awaitRebalance$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)pollUntilTrue_waitTimeMs), pollUntilTrue_x$3));
        }
    }

    public void ensureNoRebalance(Consumer<?, ?> consumer, TestConsumerReassignmentListener rebalanceListener) {
        int initialRevokeCalls = rebalanceListener.callsToRevoked();
        this.sendAndAwaitAsyncCommit(consumer, this.sendAndAwaitAsyncCommit$default$2());
        Assertions.assertEquals((int)initialRevokeCalls, (int)rebalanceListener.callsToRevoked());
    }

    public boolean isPartitionAssignmentValid(Buffer<scala.collection.immutable.Set<TopicPartition>> assignments, scala.collection.immutable.Set<TopicPartition> partitions, Buffer<scala.collection.immutable.Set<TopicPartition>> expectedAssignment) {
        Object object = new Object();
        try {
            if (!assignments.forall((Function1 & Serializable & scala.Serializable)assignment -> BoxesRunTime.boxToBoolean((boolean)assignment.nonEmpty()))) {
                return false;
            }
            if (BoxesRunTime.unboxToInt((Object)assignments.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable & scala.Serializable)(x$2, x$3) -> BoxesRunTime.boxToInteger((int)AbstractConsumerTest.$anonfun$isPartitionAssignmentValid$2(BoxesRunTime.unboxToInt((Object)x$2), x$3)))) != partitions.size()) {
                return false;
            }
            scala.collection.immutable.Set set = (scala.collection.immutable.Set)assignments.foldLeft((Object)Predef$.MODULE$.Set().empty(), (Function2 & Serializable & scala.Serializable)(x$4, x$5) -> (scala.collection.immutable.Set)x$4.$plus$plus((GenTraversableOnce)x$5));
            if (set == null || !set.equals(partitions)) {
                return false;
            }
            if (expectedAssignment.nonEmpty()) {
                assignments.foreach((Function1 & Serializable & scala.Serializable)assignment -> {
                    AbstractConsumerTest.$anonfun$isPartitionAssignmentValid$4(expectedAssignment, object, assignment);
                    return BoxedUnit.UNIT;
                });
            }
            return true;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    public static final /* synthetic */ ProducerRecord $anonfun$sendRecords$1(long startingTimestamp$1, TopicPartition tp$1, KafkaProducer producer$1, int i) {
        long timestamp = startingTimestamp$1 + (long)i;
        ProducerRecord record = new ProducerRecord(tp$1.topic(), Predef$.MODULE$.int2Integer(tp$1.partition()), Predef$.MODULE$.long2Long(timestamp), (Object)new StringBuilder(4).append("key ").append(i).toString().getBytes(), (Object)new StringBuilder(6).append("value ").append(i).toString().getBytes());
        producer$1.send(record);
        return record;
    }

    private static final boolean pollAction$1(ConsumerRecords polledRecords, int maxPollRecords$1, ArrayBuffer records$2, int numRecords$1) {
        Assertions.assertTrue((((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)polledRecords).asScala()).size() <= maxPollRecords$1 ? 1 : 0) != 0);
        records$2.$plus$plus$eq((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)polledRecords).asScala());
        return records$2.size() >= numRecords$1;
    }

    public static final /* synthetic */ String $anonfun$consumeRecords$2(int numRecords$1, ArrayBuffer records$2) {
        return new StringBuilder(71).append("Timed out before consuming expected ").append(numRecords$1).append(" records. ").append("The number consumed was ").append(records$2.size()).append(".").toString();
    }

    public static final void kafka$api$AbstractConsumerTest$$sendAsyncCommit$1(OffsetCommitCallback callback, Option offsetsOpt$1, Consumer consumer$1) {
        if (offsetsOpt$1 instanceof Some) {
            scala.collection.immutable.Map offsets = (scala.collection.immutable.Map)((Some)offsetsOpt$1).value();
            consumer$1.commitAsync((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)offsets).asJava(), callback);
            return;
        }
        if (None$.MODULE$.equals(offsetsOpt$1)) {
            consumer$1.commitAsync(callback);
            return;
        }
        throw new MatchError((Object)offsetsOpt$1);
    }

    public static final /* synthetic */ String $anonfun$sendAndAwaitAsyncCommit$2() {
        return "Failed to observe commit callback before timeout";
    }

    public static final /* synthetic */ Buffer $anonfun$addConsumersToGroup$1(AbstractConsumerTest $this, String group$1, Buffer consumerGroup$1, Buffer consumerPollers$1, List topicsToSubscribe$1, int _) {
        KafkaConsumer<byte[], byte[]> consumer = $this.createConsumerWithGroupId(group$1);
        consumerGroup$1.$plus$eq(consumer);
        return consumerPollers$1.$plus$eq((Object)$this.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)consumer, (List<String>)topicsToSubscribe$1, $this.subscribeConsumerAndStartPolling$default$3()));
    }

    public static final /* synthetic */ boolean $anonfun$validateGroupAssignment$1(AbstractConsumerTest $this, Buffer assignments$1, Buffer consumerPollers$2, scala.collection.immutable.Set subscriptions$1, Buffer expectedAssignment$1) {
        assignments$1.clear();
        consumerPollers$2.foreach((Function1 & Serializable & scala.Serializable)x$1 -> assignments$1.$plus$eq(x$1.consumerAssignment()));
        return $this.isPartitionAssignmentValid((Buffer<scala.collection.immutable.Set<TopicPartition>>)assignments$1, (scala.collection.immutable.Set<TopicPartition>)subscriptions$1, (Buffer<scala.collection.immutable.Set<TopicPartition>>)expectedAssignment$1);
    }

    public static final /* synthetic */ String $anonfun$validateGroupAssignment$3(Option msg$1, scala.collection.immutable.Set subscriptions$1, Buffer assignments$1) {
        return (String)msg$1.getOrElse((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Did not get valid assignment for partitions ").append(subscriptions$1).append(". Instead, got ").append(assignments$1).toString());
    }

    public static final /* synthetic */ String $anonfun$awaitRebalance$2() {
        return "Timed out before expected rebalance completed";
    }

    public static final /* synthetic */ int $anonfun$isPartitionAssignmentValid$2(int x$2, scala.collection.immutable.Set x$3) {
        return x$2 + x$3.size();
    }

    public static final /* synthetic */ void $anonfun$isPartitionAssignmentValid$4(Buffer expectedAssignment$2, Object nonLocalReturnKey1$1, scala.collection.immutable.Set assignment) {
        if (!expectedAssignment$2.contains((Object)assignment)) {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
        }
    }

    public AbstractConsumerTest() {
        this.epsilon = 0.1;
        this.topic = "topic";
        this.part = 0;
        this.part2 = 1;
        this.group = "my-test";
        this.producerClientId = "ConsumerTestProducer";
        this.consumerClientId = "ConsumerTestConsumer";
        this.groupMaxSessionTimeoutMs = 60000L;
        this.producerConfig().setProperty("acks", "all");
        this.producerConfig().setProperty("client.id", this.producerClientId());
        this.consumerConfig().setProperty("client.id", this.consumerClientId());
        this.consumerConfig().setProperty("group.id", this.group());
        this.consumerConfig().setProperty("auto.offset.reset", "earliest");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        this.consumerConfig().setProperty("metadata.max.age.ms", "100");
        this.consumerConfig().setProperty("max.poll.interval.ms", "6000");
    }

    public class ConsumerAssignmentPoller
    extends ShutdownableThread {
        private final Consumer<byte[], byte[]> consumer;
        private final scala.collection.immutable.Set<TopicPartition> partitionsToAssign;
        public final ConsumerRebalanceListener kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$userRebalanceListener;
        private volatile Option<Throwable> thrownException;
        private volatile int receivedMessages;
        private final Set<TopicPartition> kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment;
        private volatile boolean subscriptionChanged;
        private List<String> topicsSubscription;
        private final ConsumerRebalanceListener rebalanceListener;
        public final /* synthetic */ AbstractConsumerTest $outer;

        public Option<Throwable> thrownException() {
            return this.thrownException;
        }

        public void thrownException_$eq(Option<Throwable> x$1) {
            this.thrownException = x$1;
        }

        public int receivedMessages() {
            return this.receivedMessages;
        }

        public void receivedMessages_$eq(int x$1) {
            this.receivedMessages = x$1;
        }

        public Set<TopicPartition> kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment() {
            return this.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment;
        }

        private boolean subscriptionChanged() {
            return this.subscriptionChanged;
        }

        private void subscriptionChanged_$eq(boolean x$1) {
            this.subscriptionChanged = x$1;
        }

        private List<String> topicsSubscription() {
            return this.topicsSubscription;
        }

        private void topicsSubscription_$eq(List<String> x$1) {
            this.topicsSubscription = x$1;
        }

        public ConsumerRebalanceListener rebalanceListener() {
            return this.rebalanceListener;
        }

        public scala.collection.immutable.Set<TopicPartition> consumerAssignment() {
            return this.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment().toSet();
        }

        public void subscribe(List<String> newTopicsToSubscribe) {
            if (this.subscriptionChanged()) {
                throw new IllegalStateException("Do not call subscribe until the previous subscribe request is processed.");
            }
            if (this.partitionsToAssign.nonEmpty()) {
                throw new IllegalStateException("Cannot call subscribe when configured to use manual partition assignment");
            }
            this.topicsSubscription_$eq(newTopicsToSubscribe);
            this.subscriptionChanged_$eq(true);
        }

        public boolean isSubscribeRequestProcessed() {
            return !this.subscriptionChanged();
        }

        /*
         * WARNING - void declaration
         */
        public boolean initiateShutdown() {
            void var1_1;
            boolean res = super.initiateShutdown();
            this.consumer.wakeup();
            return (boolean)var1_1;
        }

        public void doWork() {
            if (this.subscriptionChanged()) {
                this.consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(this.topicsSubscription()).asJava(), this.rebalanceListener());
                this.subscriptionChanged_$eq(false);
            }
            try {
                this.receivedMessages_$eq(this.receivedMessages() + this.consumer.poll(Duration.ofMillis(50L)).count());
                return;
            }
            catch (WakeupException wakeupException) {
                return;
            }
            catch (Throwable e) {
                this.thrownException_$eq((Option<Throwable>)new Some((Object)e));
                throw e;
            }
        }

        public /* synthetic */ AbstractConsumerTest kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$$outer() {
            return this.$outer;
        }

        public ConsumerAssignmentPoller(AbstractConsumerTest $outer, Consumer<byte[], byte[]> consumer, List<String> topicsToSubscribe, scala.collection.immutable.Set<TopicPartition> partitionsToAssign, ConsumerRebalanceListener userRebalanceListener) {
            this.consumer = consumer;
            this.partitionsToAssign = partitionsToAssign;
            this.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$userRebalanceListener = userRebalanceListener;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super("daemon-consumer-assignment", false);
            this.thrownException = None$.MODULE$;
            this.receivedMessages = 0;
            this.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
            this.subscriptionChanged = false;
            this.topicsSubscription = topicsToSubscribe;
            this.rebalanceListener = new ConsumerRebalanceListener(this){
                private final /* synthetic */ ConsumerAssignmentPoller $outer;

                public void onPartitionsLost(Collection<TopicPartition> x$1) {
                    super.onPartitionsLost(x$1);
                }

                public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                    this.$outer.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment().$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(partitions.toArray((Object[])new TopicPartition[0]))));
                    if (this.$outer.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$userRebalanceListener != null) {
                        this.$outer.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$userRebalanceListener.onPartitionsAssigned(partitions);
                    }
                }

                public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                    this.$outer.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$partitionAssignment().$minus$minus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(partitions.toArray((Object[])new TopicPartition[0]))));
                    if (this.$outer.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$userRebalanceListener != null) {
                        this.$outer.kafka$api$AbstractConsumerTest$ConsumerAssignmentPoller$$userRebalanceListener.onPartitionsRevoked(partitions);
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
            if (partitionsToAssign.isEmpty()) {
                consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(topicsToSubscribe).asJava(), this.rebalanceListener());
                return;
            }
            consumer.assign((Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter(partitionsToAssign).asJava());
        }

        public ConsumerAssignmentPoller(AbstractConsumerTest $outer, Consumer<byte[], byte[]> consumer, List<String> topicsToSubscribe) {
            this($outer, consumer, topicsToSubscribe, (scala.collection.immutable.Set<TopicPartition>)Predef$.MODULE$.Set().empty(), null);
        }

        public ConsumerAssignmentPoller(AbstractConsumerTest $outer, Consumer<byte[], byte[]> consumer, scala.collection.immutable.Set<TopicPartition> partitionsToAssign) {
            this($outer, consumer, (List<String>)List$.MODULE$.empty(), partitionsToAssign, null);
        }
    }

    public class CountConsumerCommitCallback
    implements OffsetCommitCallback {
        private int successCount;
        private int failCount;
        private Option<Exception> lastError;

        public int successCount() {
            return this.successCount;
        }

        public void successCount_$eq(int x$1) {
            this.successCount = x$1;
        }

        public int failCount() {
            return this.failCount;
        }

        public void failCount_$eq(int x$1) {
            this.failCount = x$1;
        }

        public Option<Exception> lastError() {
            return this.lastError;
        }

        public void lastError_$eq(Option<Exception> x$1) {
            this.lastError = x$1;
        }

        public void onComplete(java.util.Map<TopicPartition, OffsetAndMetadata> offsets, Exception exception) {
            if (exception == null) {
                this.successCount_$eq(this.successCount() + 1);
                return;
            }
            this.failCount_$eq(this.failCount() + 1);
            this.lastError_$eq((Option<Exception>)new Some((Object)exception));
        }

        public /* synthetic */ AbstractConsumerTest kafka$api$AbstractConsumerTest$CountConsumerCommitCallback$$$outer() {
            return AbstractConsumerTest.this;
        }

        public CountConsumerCommitCallback() {
            if (AbstractConsumerTest.this == null) {
                throw null;
            }
            this.successCount = 0;
            this.failCount = 0;
            this.lastError = None$.MODULE$;
        }
    }

    public class TestConsumerReassignmentListener
    implements ConsumerRebalanceListener {
        private int callsToAssigned;
        private int callsToRevoked;

        public void onPartitionsLost(Collection<TopicPartition> x$1) {
            super.onPartitionsLost(x$1);
        }

        public int callsToAssigned() {
            return this.callsToAssigned;
        }

        public void callsToAssigned_$eq(int x$1) {
            this.callsToAssigned = x$1;
        }

        public int callsToRevoked() {
            return this.callsToRevoked;
        }

        public void callsToRevoked_$eq(int x$1) {
            this.callsToRevoked = x$1;
        }

        public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
            this.kafka$api$AbstractConsumerTest$TestConsumerReassignmentListener$$$outer().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "onPartitionsAssigned called.");
            this.callsToAssigned_$eq(this.callsToAssigned() + 1);
        }

        public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            this.kafka$api$AbstractConsumerTest$TestConsumerReassignmentListener$$$outer().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "onPartitionsRevoked called.");
            this.callsToRevoked_$eq(this.callsToRevoked() + 1);
        }

        public /* synthetic */ AbstractConsumerTest kafka$api$AbstractConsumerTest$TestConsumerReassignmentListener$$$outer() {
            return AbstractConsumerTest.this;
        }

        public TestConsumerReassignmentListener() {
            if (AbstractConsumerTest.this == null) {
                throw null;
            }
            this.callsToAssigned = 0;
            this.callsToRevoked = 0;
        }
    }
}

