/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker$;
import kafka.cluster.EndPoint;
import kafka.controller.ControllerContext;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001y4A\u0001G\r\u0001=!)Q\u0005\u0001C\u0001M!I\u0011\u0006\u0001a\u0001\u0002\u0004%\tA\u000b\u0005\n]\u0001\u0001\r\u00111A\u0005\u0002=B\u0011\"\u000e\u0001A\u0002\u0003\u0005\u000b\u0015B\u0016\t\u000fY\u0002!\u0019!C\u0001o!1q\t\u0001Q\u0001\naBq\u0001\u0013\u0001C\u0002\u0013\u0005\u0011\n\u0003\u0004V\u0001\u0001\u0006IA\u0013\u0005\b-\u0002\u0011\r\u0011\"\u0001J\u0011\u00199\u0006\u0001)A\u0005\u0015\"9\u0001\f\u0001b\u0001\n\u0003I\u0005BB-\u0001A\u0003%!\nC\u0003[\u0001\u0011\u00051\fC\u0003h\u0001\u0011\u00051\fC\u0003m\u0001\u0011\u00051\fC\u0003o\u0001\u0011\u00051\fC\u0003q\u0001\u0011\u00051\fC\u0003s\u0001\u0011\u00051\fC\u0003u\u0001\u0011\u00051\fC\u0003w\u0001\u0011\u00051\fC\u0003y\u0001\u0011\u00051\fC\u0003{\u0001\u0011\u00051\fC\u0003}\u0001\u0011\u00051LA\u000bD_:$(o\u001c7mKJ\u001cuN\u001c;fqR$Vm\u001d;\u000b\u0005iY\u0012AC2p]R\u0014x\u000e\u001c7fe*\tA$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001y\u0002C\u0001\u0011$\u001b\u0005\t#\"\u0001\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\n#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002OA\u0011\u0001\u0006A\u0007\u00023\u000591m\u001c8uKb$X#A\u0016\u0011\u0005!b\u0013BA\u0017\u001a\u0005E\u0019uN\u001c;s_2dWM]\"p]R,\u0007\u0010^\u0001\fG>tG/\u001a=u?\u0012*\u0017\u000f\u0006\u00021gA\u0011\u0001%M\u0005\u0003e\u0005\u0012A!\u00168ji\"9AgAA\u0001\u0002\u0004Y\u0013a\u0001=%c\u0005A1m\u001c8uKb$\b%A\u0004ce>\\WM]:\u0016\u0003a\u00022!O!E\u001d\tQtH\u0004\u0002<}5\tAH\u0003\u0002>;\u00051AH]8pizJ\u0011AI\u0005\u0003\u0001\u0006\nq\u0001]1dW\u0006<W-\u0003\u0002C\u0007\n\u00191+Z9\u000b\u0005\u0001\u000b\u0003C\u0001\u0011F\u0013\t1\u0015EA\u0002J]R\f\u0001B\u0019:pW\u0016\u00148\u000fI\u0001\u0004iB\fT#\u0001&\u0011\u0005-\u001bV\"\u0001'\u000b\u00055s\u0015AB2p[6|gN\u0003\u0002\u001d\u001f*\u0011\u0001+U\u0001\u0007CB\f7\r[3\u000b\u0003I\u000b1a\u001c:h\u0013\t!FJ\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\tQ\u0004\u0018\u0007I\u0001\u0004iB\u0014\u0014\u0001\u0002;qe\u0001\n1\u0001\u001e94\u0003\u0011!\bo\r\u0011\u0002\u000bM,G/\u00169\u0015\u0003AB#!D/\u0011\u0005y+W\"A0\u000b\u0005\u0001\f\u0017aA1qS*\u0011!mY\u0001\bUV\u0004\u0018\u000e^3s\u0015\t!\u0017+A\u0003kk:LG/\u0003\u0002g?\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0001R,7\u000f^+qI\u0006$X\rU1si&$\u0018n\u001c8Gk2d'+\u001a9mS\u000e\f\u0017i]:jO:lWM\u001c;Va\u0012\fG/Z:SKBd\u0017nY1BgNLwM\\7f]RD#AD5\u0011\u0005yS\u0017BA6`\u0005\u0011!Vm\u001d;\u0002\u0017R,7\u000f\u001e)beRLG/[8o%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$(+\u001a;ve:\u001cX)\u001c9usN+\u0017/\u00134U_BL7m\u0014:QCJ$\u0018\u000e^5p]\u0012{Wm\u001d(pi\u0016C\u0018n\u001d;)\u0005=I\u0017A\u0016;fgR\u0004\u0016M\u001d;ji&|gNR;mYJ+\u0007\u000f\\5dC\u0006\u001b8/[4o[\u0016tGOU3ukJt7/R7qif\f5o]5h]6,g\u000e^%g)>\u0004\u0018nY(s!\u0006\u0014H/\u001b;j_:$u.Z:O_R,\u00050[:uQ\t\u0001\u0012.\u0001%uKN$\b+\u0019:uSRLwN\u001c*fa2L7-Y!tg&<g.\\3oi\u001a{'\u000fV8qS\u000e\u0014V\r^;s]N,U\u000e\u001d;z\u001b\u0006\u0004\u0018J\u001a+pa&\u001cGi\\3t\u001d>$X\t_5ti\"\u0012\u0011#[\u0001Hi\u0016\u001cH\u000fU1si&$\u0018n\u001c8SKBd\u0017nY1BgNLwM\\7f]R4uN\u001d+pa&\u001c'+\u001a;ve:\u001cX\t\u001f9fGR,GMU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8ug\"\u0012!#[\u0001\u001fi\u0016\u001cH\u000fU1si&$\u0018n\u001c8SKBd\u0017nY1BgNLwM\\7f]RD#aE5\u00023Q,7\u000f\u001e*fCN\u001c\u0018n\u001a8U_&#W-\u001c9pi\u0016t7-\u001a\u0015\u0003)%\fa\u0002^3tiJ+\u0017m]:jO:$v\u000e\u000b\u0002\u0016S\u0006\u0019C/Z:u!J,g-\u001a:sK\u0012\u0014V\r\u001d7jG\u0006LUNY1mC:\u001cW-T3ue&\u001c\u0007F\u0001\fj\u0003q\"Xm\u001d;Qe\u00164WM\u001d:fIJ+\u0007\u000f\\5dC&k'-\u00197b]\u000e,W*\u001a;sS\u000e|enQ8oGV\u0014(/\u001a8u)>\u0004\u0018n\u0019#fY\u0016$\u0018n\u001c8)\u0005]I\u0007")
public class ControllerContextTest {
    private ControllerContext context;
    private final Seq<Object> brokers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
    private final TopicPartition tp1 = new TopicPartition("A", 0);
    private final TopicPartition tp2 = new TopicPartition("A", 1);
    private final TopicPartition tp3 = new TopicPartition("B", 0);

    public ControllerContext context() {
        return this.context;
    }

    public void context_$eq(ControllerContext x$1) {
        this.context = x$1;
    }

    public Seq<Object> brokers() {
        return this.brokers;
    }

    public TopicPartition tp1() {
        return this.tp1;
    }

    public TopicPartition tp2() {
        return this.tp2;
    }

    public TopicPartition tp3() {
        return this.tp3;
    }

    @BeforeEach
    public void setUp() {
        this.context_$eq(new ControllerContext());
        scala.collection.immutable.Map brokerEpochs = ((TraversableOnce)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))).map((Function1 & Serializable & scala.Serializable)brokerId -> ControllerContextTest.$anonfun$setUp$1(BoxesRunTime.unboxToInt((Object)brokerId)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.context().setLiveBrokers((Map)brokerEpochs);
        IntRef leaderIndex = IntRef.create((int)0);
        new .colon.colon((Object)this.tp1(), (List)new .colon.colon((Object)this.tp2(), (List)new .colon.colon((Object)this.tp3(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)partition -> {
            ControllerContextTest.$anonfun$setUp$2(this, leaderIndex, partition);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testUpdatePartitionFullReplicaAssignmentUpdatesReplicaAssignment() {
        Seq initialReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4}));
        this.context().updatePartitionFullReplicaAssignment(this.tp1(), ReplicaAssignment$.MODULE$.apply(initialReplicas));
        ReplicaAssignment fullAssignment = this.context().partitionFullReplicaAssignment(this.tp1());
        Assertions.assertEquals((Object)initialReplicas, (Object)fullAssignment.replicas());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)fullAssignment.addingReplicas());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)fullAssignment.removingReplicas());
        ReplicaAssignment expectedFullAssignment = ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        this.context().updatePartitionFullReplicaAssignment(this.tp1(), expectedFullAssignment);
        ReplicaAssignment updatedFullAssignment = this.context().partitionFullReplicaAssignment(this.tp1());
        Assertions.assertEquals((Object)expectedFullAssignment.replicas(), (Object)updatedFullAssignment.replicas());
        Assertions.assertEquals((Object)expectedFullAssignment.addingReplicas(), (Object)updatedFullAssignment.addingReplicas());
        Assertions.assertEquals((Object)expectedFullAssignment.removingReplicas(), (Object)updatedFullAssignment.removingReplicas());
    }

    @Test
    public void testPartitionReplicaAssignmentReturnsEmptySeqIfTopicOrPartitionDoesNotExist() {
        Seq noTopicReplicas = this.context().partitionReplicaAssignment(new TopicPartition("NONEXISTENT", 0));
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)noTopicReplicas);
        Seq noPartitionReplicas = this.context().partitionReplicaAssignment(new TopicPartition("A", 100));
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)noPartitionReplicas);
    }

    @Test
    public void testPartitionFullReplicaAssignmentReturnsEmptyAssignmentIfTopicOrPartitionDoesNotExist() {
        ReplicaAssignment expectedEmptyAssignment = ReplicaAssignment$.MODULE$.apply((Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$);
        ReplicaAssignment noTopicAssignment = this.context().partitionFullReplicaAssignment(new TopicPartition("NONEXISTENT", 0));
        Assertions.assertEquals((Object)expectedEmptyAssignment, (Object)noTopicAssignment);
        ReplicaAssignment noPartitionAssignment = this.context().partitionFullReplicaAssignment(new TopicPartition("A", 100));
        Assertions.assertEquals((Object)expectedEmptyAssignment, (Object)noPartitionAssignment);
    }

    @Test
    public void testPartitionReplicaAssignmentForTopicReturnsEmptyMapIfTopicDoesNotExist() {
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)this.context().partitionReplicaAssignmentForTopic("NONEXISTENT"));
    }

    @Test
    public void testPartitionReplicaAssignmentForTopicReturnsExpectedReplicaAssignments() {
        scala.collection.immutable.Map expectedAssignments = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp1()), (Object)this.context().partitionReplicaAssignment(this.tp1())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp2()), (Object)this.context().partitionReplicaAssignment(this.tp2()))}));
        Map receivedAssignments = this.context().partitionReplicaAssignmentForTopic("A");
        Assertions.assertEquals((Object)expectedAssignments, (Object)receivedAssignments);
    }

    @Test
    public void testPartitionReplicaAssignment() {
        ReplicaAssignment reassigningPartition = ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 5, 6})));
        Assertions.assertTrue((boolean)reassigningPartition.isBeingReassigned());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), (Object)reassigningPartition.targetReplicas());
        ReplicaAssignment reassigningPartition2 = ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)Nil$.MODULE$, (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 4})));
        Assertions.assertTrue((boolean)reassigningPartition2.isBeingReassigned());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), (Object)reassigningPartition2.targetReplicas());
        ReplicaAssignment reassigningPartition3 = ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4})), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})));
        Assertions.assertTrue((boolean)reassigningPartition3.isBeingReassigned());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 4})), (Object)reassigningPartition3.targetReplicas());
        ReplicaAssignment partition = ReplicaAssignment$.MODULE$.apply((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6})), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$);
        Assertions.assertFalse((boolean)partition.isBeingReassigned());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6})), (Object)partition.targetReplicas());
        ReplicaAssignment reassigningPartition4 = ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4}))).reassignTo((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 2, 5, 3})));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 2, 5, 3, 1})), (Object)reassigningPartition4.replicas());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 2, 5, 3})), (Object)reassigningPartition4.targetReplicas());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5})), (Object)reassigningPartition4.addingReplicas());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), (Object)reassigningPartition4.removingReplicas());
        Assertions.assertTrue((boolean)reassigningPartition4.isBeingReassigned());
        ReplicaAssignment reassigningPartition5 = ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))).reassignTo((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6})));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 1, 2, 3})), (Object)reassigningPartition5.replicas());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Object)reassigningPartition5.targetReplicas());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Object)reassigningPartition5.addingReplicas());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Object)reassigningPartition5.removingReplicas());
        Assertions.assertTrue((boolean)reassigningPartition5.isBeingReassigned());
        ReplicaAssignment nonReassigningPartition = ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))).reassignTo((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 2})));
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 2})), (Object)nonReassigningPartition.replicas());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 2})), (Object)nonReassigningPartition.targetReplicas());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)nonReassigningPartition.addingReplicas());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)nonReassigningPartition.removingReplicas());
        Assertions.assertFalse((boolean)nonReassigningPartition.isBeingReassigned());
    }

    @Test
    public void testReassignToIdempotence() {
        ReplicaAssignment assignment1 = ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        Assertions.assertEquals((Object)assignment1, (Object)assignment1.reassignTo(assignment1.targetReplicas()));
        ReplicaAssignment assignment2 = ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 1, 2, 3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        Assertions.assertEquals((Object)assignment2, (Object)assignment2.reassignTo(assignment2.targetReplicas()));
        ReplicaAssignment assignment3 = ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 2, 3, 1})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})));
        Assertions.assertEquals((Object)assignment3, (Object)assignment3.reassignTo(assignment3.targetReplicas()));
    }

    @Test
    public void testReassignTo() {
        ReplicaAssignment assignment = ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        ReplicaAssignment firstReassign = assignment.reassignTo((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6})));
        Assertions.assertEquals((Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 1, 2, 3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (Object)firstReassign);
        Assertions.assertEquals((Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8, 9, 1, 2, 3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8, 9})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (Object)firstReassign.reassignTo((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8, 9}))));
        Assertions.assertEquals((Object)ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8, 9, 1, 2, 3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8, 9})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), (Object)assignment.reassignTo((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{7, 8, 9}))));
        Assertions.assertEquals((Object)assignment, (Object)firstReassign.reassignTo((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))));
    }

    @Test
    public void testPreferredReplicaImbalanceMetric() {
        this.context().updatePartitionFullReplicaAssignment(this.tp1(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))));
        this.context().updatePartitionFullReplicaAssignment(this.tp2(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))));
        this.context().updatePartitionFullReplicaAssignment(this.tp3(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))));
        Assertions.assertEquals((int)0, (int)this.context().preferredReplicaImbalanceCount());
        this.context().putPartitionLeadershipInfo(this.tp1(), new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), 0));
        Assertions.assertEquals((int)0, (int)this.context().preferredReplicaImbalanceCount());
        this.context().putPartitionLeadershipInfo(this.tp2(), new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(2, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 1}))), 0));
        Assertions.assertEquals((int)1, (int)this.context().preferredReplicaImbalanceCount());
        this.context().putPartitionLeadershipInfo(this.tp3(), new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(3, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 2}))), 0));
        Assertions.assertEquals((int)2, (int)this.context().preferredReplicaImbalanceCount());
        this.context().updatePartitionFullReplicaAssignment(this.tp1(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 1}))));
        this.context().updatePartitionFullReplicaAssignment(this.tp2(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 1}))));
        Assertions.assertEquals((int)2, (int)this.context().preferredReplicaImbalanceCount());
        this.context().queueTopicDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.tp3().topic()})));
        Assertions.assertEquals((int)1, (int)this.context().preferredReplicaImbalanceCount());
        this.context().putPartitionLeadershipInfo(this.tp3(), new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 2}))), 0));
        Assertions.assertEquals((int)1, (int)this.context().preferredReplicaImbalanceCount());
        this.context().removeTopic(this.tp1().topic());
        this.context().removeTopic(this.tp2().topic());
        this.context().removeTopic(this.tp3().topic());
        Assertions.assertEquals((int)0, (int)this.context().preferredReplicaImbalanceCount());
    }

    @Test
    public void testPreferredReplicaImbalanceMetricOnConcurrentTopicDeletion() {
        String topicA = "A";
        String topicB = "B";
        TopicPartition tpA = new TopicPartition(topicA, 0);
        TopicPartition tpB = new TopicPartition(topicB, 0);
        this.context().updatePartitionFullReplicaAssignment(tpA, ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))));
        this.context().updatePartitionFullReplicaAssignment(tpB, ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))));
        Assertions.assertEquals((int)0, (int)this.context().preferredReplicaImbalanceCount());
        this.context().queueTopicDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topicA})));
        this.context().putPartitionLeadershipInfo(tpA, new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(LeaderAndIsr$.MODULE$.NoLeader(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), 0));
        Assertions.assertEquals((int)0, (int)this.context().preferredReplicaImbalanceCount());
        this.context().queueTopicDeletion((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topicA, topicB})));
        Assertions.assertEquals((int)0, (int)this.context().preferredReplicaImbalanceCount());
    }

    public static final /* synthetic */ Tuple2 $anonfun$setUp$1(int brokerId) {
        EndPoint endpoint = new EndPoint("localhost", 9900 + brokerId, new ListenerName("PLAINTEXT"), SecurityProtocol.PLAINTEXT);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Broker$.MODULE$.apply(brokerId, (Seq)new .colon.colon((Object)endpoint, (List)Nil$.MODULE$), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)1L));
    }

    public static final /* synthetic */ void $anonfun$setUp$2(ControllerContextTest $this, IntRef leaderIndex$1, TopicPartition partition) {
        IndexedSeq replicas = (IndexedSeq)$this.brokers().indices().map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)i -> BoxesRunTime.unboxToInt((Object)$this.brokers().apply((i + leaderIndex$1.elem) % $this.brokers().size())), IndexedSeq$.MODULE$.canBuildFrom());
        $this.context().updatePartitionFullReplicaAssignment(partition, ReplicaAssignment$.MODULE$.apply((Seq)replicas));
        ++leaderIndex$1.elem;
    }
}

