/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import java.util.concurrent.ConcurrentMap;
import kafka.log.AbortedTxn;
import kafka.log.AppendOrigin;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.ClientRecordDeletion$;
import kafka.log.LoadedLogOffsets;
import kafka.log.LocalLog;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogLoader;
import kafka.log.LogLoader$;
import kafka.log.LogLoaderTest;
import kafka.log.LogLoaderTest$;
import kafka.log.LogLoaderTest$ErrorTypes$;
import kafka.log.LogLoaderTest$SimulateError$2$;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.log.LogSegments;
import kafka.log.LogStartOffsetIncrementReason;
import kafka.log.LogTestUtils$;
import kafka.log.OffsetIndex;
import kafka.log.OffsetIndex$;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateManager;
import kafka.log.ProducerStateManager$;
import kafka.log.ProducerStateManagerConfig;
import kafka.log.SnapshotFile;
import kafka.log.SnapshotFile$;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import kafka.server.FetchDataInfo;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.RequestLocal;
import kafka.server.epoch.EpochEntry;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.server.metadata.ConfigRepository;
import kafka.server.metadata.MockConfigRepository;
import kafka.utils.CoreUtils$;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r\u001dd\u0001\u0002-Z\u0001yCQ!\u001a\u0001\u0005\u0002\u0019D\u0011\"\u001b\u0001A\u0002\u0003\u0007I\u0011\u00016\t\u0013E\u0004\u0001\u0019!a\u0001\n\u0003\u0011\b\"\u0003=\u0001\u0001\u0004\u0005\t\u0015)\u0003l\u0011\u001dI\bA1A\u0005\u0002iDaA \u0001!\u0002\u0013Y\b\u0002C@\u0001\u0005\u0004%\t!!\u0001\t\u0011\u0005%\u0001\u0001)A\u0005\u0003\u0007A\u0011\"a\u0003\u0001\u0005\u0004%\t!!\u0004\t\u0011\u0005U\u0001\u0001)A\u0005\u0003\u001fA\u0011\"a\u0006\u0001\u0005\u0004%\t!!\u0001\t\u0011\u0005e\u0001\u0001)A\u0005\u0003\u0007A\u0011\"a\u0007\u0001\u0005\u0004%\t!!\b\t\u0011\u0005=\u0002\u0001)A\u0005\u0003?A\u0011\"!\r\u0001\u0005\u0004%\t!!\b\t\u0011\u0005M\u0002\u0001)A\u0005\u0003?A\u0011\"!\u000e\u0001\u0005\u0004%\t!a\u000e\t\u0011\u0005\u0015\u0003\u0001)A\u0005\u0003sAq!a\u0012\u0001\t\u0003\tI\u0005C\u0004\u0002f\u0001!\t!!\u0013\b\u000f\u0005=\u0004\u0001#\u0001\u0002r\u00199\u0011Q\u000f\u0001\t\u0002\u0005]\u0004BB3\u0017\t\u0003\ty(\u0002\u0004\u0002\u0002Z\u0001\u00111\u0011\u0005\n\u0003\u00173\"\u0019!C\u0001\u0003\u001bC\u0001\"a$\u0017A\u0003%\u00111\u0011\u0005\n\u0003#3\"\u0019!C\u0001\u0003\u001bC\u0001\"a%\u0017A\u0003%\u00111\u0011\u0005\n\u0003+3\"\u0019!C\u0001\u0003\u001bC\u0001\"a&\u0017A\u0003%\u00111\u0011\u0005\n\u000333\"\u0019!C\u0001\u0003\u001bC\u0001\"a'\u0017A\u0003%\u00111\u0011\u0005\b\u0003;\u0003A\u0011AA%\u0011\u001d\t9\u000b\u0001C\u0001\u0003\u0013Bq!a+\u0001\t\u0003\tI\u0005C\u0004\u00020\u0002!I!!-\t\u0013\t%\u0001!%A\u0005\n\t-\u0001\"\u0003B\u0011\u0001E\u0005I\u0011\u0002B\u0012\u0011%\u00119\u0003AI\u0001\n\u0013\u0011\u0019\u0003C\u0005\u0003*\u0001\t\n\u0011\"\u0003\u0003,!I!q\u0006\u0001\u0012\u0002\u0013%!\u0011\u0007\u0005\n\u0005k\u0001\u0011\u0013!C\u0005\u0005oA\u0011Ba\u000f\u0001#\u0003%IAa\u000e\t\u0013\tu\u0002!%A\u0005\n\t]\u0002\"\u0003B \u0001E\u0005I\u0011\u0002B!\u0011\u001d\u0011)\u0005\u0001C\u0005\u0005\u000fBqA!\u0017\u0001\t\u0013\u0011Y\u0006C\u0004\u0003p\u0001!IA!\u001d\t\u0013\t5\u0006!%A\u0005\n\t=\u0006\"\u0003BZ\u0001E\u0005I\u0011\u0002B[\u0011%\u0011I\fAI\u0001\n\u0013\u0011\u0019\u0003C\u0005\u0003<\u0002\t\n\u0011\"\u0003\u0003>\"9!\u0011\u0019\u0001\u0005\n\t\r\u0007b\u0002Bp\u0001\u0011\u0005\u0011\u0011\n\u0005\b\u0005G\u0004A\u0011AA%\u0011\u001d\u00119\u000f\u0001C\u0001\u0003\u0013BqAa;\u0001\t\u0003\tI\u0005C\u0004\u0003p\u0002!\t!!\u0013\t\u000f\tM\b\u0001\"\u0001\u0002J!9!q\u001f\u0001\u0005\u0002\u0005%\u0003b\u0002B~\u0001\u0011\u0005\u0011\u0011\n\u0005\b\u0005\u007f\u0004A\u0011AA%\u0011\u001d\u0019\u0019\u0001\u0001C\u0001\u0003\u0013Bqaa\u0002\u0001\t\u0003\tI\u0005C\u0004\u0004\f\u0001!\t!!\u0013\t\u000f\r=\u0001\u0001\"\u0001\u0002J!911\u0003\u0001\u0005\u0002\u0005%\u0003bBB\f\u0001\u0011\u0005\u0011\u0011\n\u0005\b\u00077\u0001A\u0011AA%\u0011\u001d\u0019y\u0002\u0001C\u0001\u0003\u0013Bqaa\t\u0001\t\u0003\tI\u0005C\u0004\u0004(\u0001!\t!!\u0013\t\u000f\r-\u0002\u0001\"\u0001\u0002J!91q\u0006\u0001\u0005\u0002\u0005%\u0003bBB\u001a\u0001\u0011\u0005\u0011\u0011\n\u0005\b\u0007o\u0001A\u0011AA%\u0011\u001d\u0019Y\u0004\u0001C\u0001\u0003\u0013Bqaa\u0010\u0001\t\u0003\tI\u0005C\u0004\u0004D\u0001!\t!!\u0013\t\u000f\r\u001d\u0003\u0001\"\u0001\u0002J!911\n\u0001\u0005\u0002\u0005%\u0003bBB(\u0001\u0011\u0005\u0011\u0011\n\u0005\b\u0007'\u0002A\u0011AA%\u0011\u001d\u00199\u0006\u0001C\u0001\u0003\u0013Bqaa\u0017\u0001\t\u0003\tI\u0005C\u0004\u0004`\u0001!\t!!\u0013\t\u000f\r\r\u0004\u0001\"\u0001\u0002J\tiAj\\4M_\u0006$WM\u001d+fgRT!AW.\u0002\u00071|wMC\u0001]\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A0\u0011\u0005\u0001\u001cW\"A1\u000b\u0003\t\fQa]2bY\u0006L!\u0001Z1\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tq\r\u0005\u0002i\u00015\t\u0011,\u0001\u0004d_:4\u0017nZ\u000b\u0002WB\u0011An\\\u0007\u0002[*\u0011anW\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005Al'aC&bM.\f7i\u001c8gS\u001e\f!bY8oM&<w\fJ3r)\t\u0019h\u000f\u0005\u0002ai&\u0011Q/\u0019\u0002\u0005+:LG\u000fC\u0004x\u0007\u0005\u0005\t\u0019A6\u0002\u0007a$\u0013'A\u0004d_:4\u0017n\u001a\u0011\u0002!\t\u0014xn[3s)>\u0004\u0018nY*uCR\u001cX#A>\u0011\u00051d\u0018BA?n\u0005A\u0011%o\\6feR{\u0007/[2Ti\u0006$8/A\tce>\\WM\u001d+pa&\u001c7\u000b^1ug\u0002\nq#\\1y)J\fgn]1di&|g\u000eV5nK>,H/T:\u0016\u0005\u0005\r\u0001c\u00011\u0002\u0006%\u0019\u0011qA1\u0003\u0007%sG/\u0001\rnCb$&/\u00198tC\u000e$\u0018n\u001c8US6,w.\u001e;Ng\u0002\n!\u0004\u001d:pIV\u001cWM]*uCR,W*\u00198bO\u0016\u00148i\u001c8gS\u001e,\"!a\u0004\u0011\u0007!\f\t\"C\u0002\u0002\u0014e\u0013!\u0004\u0015:pIV\u001cWM]*uCR,W*\u00198bO\u0016\u00148i\u001c8gS\u001e\f1\u0004\u001d:pIV\u001cWM]*uCR,W*\u00198bO\u0016\u00148i\u001c8gS\u001e\u0004\u0013a\t9s_\u0012,8-\u001a:JI\u0016C\b/\u001b:bi&|gn\u00115fG.Le\u000e^3sm\u0006dWj]\u0001%aJ|G-^2fe&#W\t\u001f9je\u0006$\u0018n\u001c8DQ\u0016\u001c7.\u00138uKJ4\u0018\r\\'tA\u00051A/\u001c9ESJ,\"!a\b\u0011\t\u0005\u0005\u00121F\u0007\u0003\u0003GQA!!\n\u0002(\u0005\u0011\u0011n\u001c\u0006\u0003\u0003S\tAA[1wC&!\u0011QFA\u0012\u0005\u00111\u0015\u000e\\3\u0002\u000fQl\u0007\u000fR5sA\u00051An\\4ESJ\fq\u0001\\8h\t&\u0014\b%\u0001\u0005n_\u000e\\G+[7f+\t\tI\u0004\u0005\u0003\u0002<\u0005\u0005SBAA\u001f\u0015\r\tydW\u0001\u0006kRLGn]\u0005\u0005\u0003\u0007\niD\u0001\u0005N_\u000e\\G+[7f\u0003%iwnY6US6,\u0007%A\u0003tKR,\u0006\u000fF\u0001tQ\r\u0019\u0012Q\n\t\u0005\u0003\u001f\n\t'\u0004\u0002\u0002R)!\u00111KA+\u0003\r\t\u0007/\u001b\u0006\u0005\u0003/\nI&A\u0004kkBLG/\u001a:\u000b\t\u0005m\u0013QL\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u0003?\n1a\u001c:h\u0013\u0011\t\u0019'!\u0015\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<oQ\r!\u0012\u0011\u000e\t\u0005\u0003\u001f\nY'\u0003\u0003\u0002n\u0005E#!C!gi\u0016\u0014X)Y2i\u0003))%O]8s)f\u0004Xm\u001d\t\u0004\u0003g2R\"\u0001\u0001\u0003\u0015\u0015\u0013(o\u001c:UsB,7oE\u0002\u0017\u0003s\u00022\u0001YA>\u0013\r\ti(\u0019\u0002\f\u000b:,X.\u001a:bi&|g\u000e\u0006\u0002\u0002r\t1QI\u001d:peN\u0004B!!\"\u0002\b6\ta#\u0003\u0003\u0002\n\u0006m$!\u0002,bYV,\u0017aC%P\u000bb\u001cW\r\u001d;j_:,\"!a!\u0002\u0019%{U\t_2faRLwN\u001c\u0011\u0002!I+h\u000e^5nK\u0016C8-\u001a9uS>t\u0017!\u0005*v]RLW.Z#yG\u0016\u0004H/[8oA\u0005I3*\u00194lCN#xN]1hK\u0016C8-\u001a9uS>tw+\u001b;i\u0013>+\u0005pY3qi&|gnQ1vg\u0016\f!fS1gW\u0006\u001cFo\u001c:bO\u0016,\u0005pY3qi&|gnV5uQ&{U\t_2faRLwN\\\"bkN,\u0007%\u0001\u0017LC\u001a\\\u0017m\u0015;pe\u0006<W-\u0012=dKB$\u0018n\u001c8XSRDw.\u001e;J\u001f\u0016C8-\u001a9uS>t7)Y;tK\u0006i3*\u00194lCN#xN]1hK\u0016C8-\u001a9uS>tw+\u001b;i_V$\u0018jT#yG\u0016\u0004H/[8o\u0007\u0006,8/\u001a\u0011\u0002MQ,7\u000f\u001e'pOJ+7m\u001c<fefL5oQ1mY\u0016$W\u000b]8o\u0005J|7.\u001a:De\u0006\u001c\b\u000eK\u0002\"\u0003C\u0003B!a\u0014\u0002$&!\u0011QUA)\u0005\u0011!Vm\u001d;\u0002gQ,7\u000f\u001e)s_\u0012,8-\u001a:T]\u0006\u00048\u000f[8ugJ+7m\u001c<fef\fe\r^3s+:\u001cG.Z1o'\",H\u000fZ8x]Z\u000b\u0004f\u0001\u0012\u0002\"\u0006)E/Z:u!J|G-^2feNs\u0017\r]:i_R\u001c(+Z2pm\u0016\u0014\u00180\u00114uKJ,fn\u00197fC:\u001c\u0006.\u001e;e_^t7)\u001e:sK:$X*Z:tC\u001e,gi\u001c:nCRD3aIAQ\u0003%\u0019'/Z1uK2{w\r\u0006\r\u00024\u0006e\u0016QXAc\u0003\u000f\f\t.!6\u0002`\u0006]\u0018\u0011`A\u007f\u0003\u007f\u00042\u0001[A[\u0013\r\t9,\u0017\u0002\u000b+:Lg-[3e\u0019><\u0007bBA^I\u0001\u0007\u0011qD\u0001\u0004I&\u0014\bBB5%\u0001\u0004\ty\fE\u0002i\u0003\u0003L1!a1Z\u0005%aunZ\"p]\u001aLw\rC\u0004zIA\u0005\t\u0019A>\t\u0013\u0005%G\u0005%AA\u0002\u0005-\u0017A\u00047pON#\u0018M\u001d;PM\u001a\u001cX\r\u001e\t\u0004A\u00065\u0017bAAhC\n!Aj\u001c8h\u0011%\t\u0019\u000e\nI\u0001\u0002\u0004\tY-A\u0007sK\u000e|g/\u001a:z!>Lg\u000e\u001e\u0005\n\u0003/$\u0003\u0013!a\u0001\u00033\f\u0011b]2iK\u0012,H.\u001a:\u0011\t\u0005m\u00121\\\u0005\u0005\u0003;\fiDA\u0005TG\",G-\u001e7fe\"I\u0011\u0011\u001d\u0013\u0011\u0002\u0003\u0007\u00111]\u0001\u0005i&lW\r\u0005\u0003\u0002f\u0006MXBAAt\u0015\u0011\ty$!;\u000b\t\u0005-\u0018Q^\u0001\u0007G>lWn\u001c8\u000b\u0007q\u000byO\u0003\u0003\u0002r\u0006u\u0013AB1qC\u000eDW-\u0003\u0003\u0002v\u0006\u001d(\u0001\u0002+j[\u0016D\u0001b \u0013\u0011\u0002\u0003\u0007\u00111\u0001\u0005\n\u0003w$\u0003\u0013!a\u0001\u0003\u0007\t\u0011$\\1y!J|G-^2fe&#W\t\u001f9je\u0006$\u0018n\u001c8Ng\"I\u0011q\u0003\u0013\u0011\u0002\u0003\u0007\u00111\u0001\u0005\n\u0005\u0003!\u0003\u0013!a\u0001\u0005\u0007\t\u0011\u0003\\1tiNCW\u000f\u001e3po:\u001cE.Z1o!\r\u0001'QA\u0005\u0004\u0005\u000f\t'a\u0002\"p_2,\u0017M\\\u0001\u0014GJ,\u0017\r^3M_\u001e$C-\u001a4bk2$HeM\u000b\u0003\u0005\u001bQ3a\u001fB\bW\t\u0011\t\u0002\u0005\u0003\u0003\u0014\tuQB\u0001B\u000b\u0015\u0011\u00119B!\u0007\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u000eC\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t}!Q\u0003\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017aE2sK\u0006$X\rT8hI\u0011,g-Y;mi\u0012\"TC\u0001B\u0013U\u0011\tYMa\u0004\u0002'\r\u0014X-\u0019;f\u0019><G\u0005Z3gCVdG\u000fJ\u001b\u0002'\r\u0014X-\u0019;f\u0019><G\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\t5\"\u0006BAm\u0005\u001f\t1c\u0019:fCR,Gj\\4%I\u00164\u0017-\u001e7uI]*\"Aa\r+\t\u0005\r(qB\u0001\u0014GJ,\u0017\r^3M_\u001e$C-\u001a4bk2$H\u0005O\u000b\u0003\u0005sQC!a\u0001\u0003\u0010\u0005\u00192M]3bi\u0016dun\u001a\u0013eK\u001a\fW\u000f\u001c;%s\u0005!2M]3bi\u0016dun\u001a\u0013eK\u001a\fW\u000f\u001c;%cA\nAc\u0019:fCR,Gj\\4%I\u00164\u0017-\u001e7uIE\nTC\u0001B\"U\u0011\u0011\u0019Aa\u0004\u00027\r\u0014X-\u0019;f\u0019><w+\u001b;i\u001f\u001a47/\u001a;Pm\u0016\u0014h\r\\8x)\u0011\u0011IE!\u0016\u0011\u000f\u0001\u0014Y%a-\u0003P%\u0019!QJ1\u0003\rQ+\b\u000f\\33!\rA'\u0011K\u0005\u0004\u0005'J&A\u0003'pON+w-\\3oi\"9!q\u000b\u0018A\u0002\u0005}\u0016!\u00037pO\u000e{gNZ5h\u0003=\u0011XmY8wKJ\fe\u000eZ\"iK\u000e\\GCBAZ\u0005;\u0012y\u0006\u0003\u0004j_\u0001\u0007\u0011q\u0018\u0005\b\u0005Cz\u0003\u0019\u0001B2\u00031)\u0007\u0010]3di\u0016$7*Z=t!\u0019\u0011)Ga\u001b\u0002L6\u0011!q\r\u0006\u0004\u0005S\n\u0017AC2pY2,7\r^5p]&!!Q\u000eB4\u0005!IE/\u001a:bE2,\u0017aH:j]\u001edW\r^8o%\u0016\u001cwN\u001d3t/&$\b\u000eT3bI\u0016\u0014X\t]8dQR\u0001\"1\u000fB@\u0005\u001f\u0013\u0019Ja&\u0003\u001c\n\u0015&\u0011\u0016\t\u0005\u0005k\u0012Y(\u0004\u0002\u0003x)!!\u0011PAu\u0003\u0019\u0011XmY8sI&!!Q\u0010B<\u00055iU-\\8ssJ+7m\u001c:eg\"9!\u0011\u0011\u0019A\u0002\t\r\u0015!\u0002<bYV,\u0007#\u00021\u0003\u0006\n%\u0015b\u0001BDC\n)\u0011I\u001d:bsB\u0019\u0001Ma#\n\u0007\t5\u0015M\u0001\u0003CsR,\u0007\"\u0003BIaA\u0005\t\u0019\u0001BB\u0003\rYW-\u001f\u0005\b\u0005+\u0003\u0004\u0019AA\u0002\u0003-aW-\u00193fe\u0016\u0003xn\u00195\t\u000f\te\u0005\u00071\u0001\u0002L\u00061qN\u001a4tKRD\u0011B!(1!\u0003\u0005\rAa(\u0002\u000b\r|G-Z2\u0011\t\tU$\u0011U\u0005\u0005\u0005G\u00139HA\bD_6\u0004(/Z:tS>tG+\u001f9f\u0011%\u00119\u000b\rI\u0001\u0002\u0004\tY-A\u0005uS6,7\u000f^1na\"I!1\u0016\u0019\u0011\u0002\u0003\u0007!\u0011R\u0001\u000b[\u0006<\u0017n\u0019,bYV,\u0017!K:j]\u001edW\r^8o%\u0016\u001cwN\u001d3t/&$\b\u000eT3bI\u0016\u0014X\t]8dQ\u0012\"WMZ1vYR$#'\u0006\u0002\u00032*\"!1\u0011B\b\u0003%\u001a\u0018N\\4mKR|gNU3d_J$7oV5uQ2+\u0017\rZ3s\u000bB|7\r\u001b\u0013eK\u001a\fW\u000f\u001c;%kU\u0011!q\u0017\u0016\u0005\u0005?\u0013y!A\u0015tS:<G.\u001a;p]J+7m\u001c:eg^KG\u000f\u001b'fC\u0012,'/\u00129pG\"$C-\u001a4bk2$HEN\u0001*g&tw\r\\3u_:\u0014VmY8sIN<\u0016\u000e\u001e5MK\u0006$WM]#q_\u000eDG\u0005Z3gCVdG\u000fJ\u001c\u0016\u0005\t}&\u0006\u0002BE\u0005\u001f\t\u0011\u0007^3tiB\u0013x\u000eZ;dKJ\u001cf.\u00199tQ>$8OU3d_Z,'/_!gi\u0016\u0014XK\\2mK\u0006t7\u000b[;uI><h\u000eF\u0002t\u0005\u000bDqAa26\u0001\u0004\u0011I-\u0001\u000bnKN\u001c\u0018mZ3G_Jl\u0017\r\u001e,feNLwN\u001c\t\u0005\u0005\u0017\u0014IN\u0004\u0003\u0003N\nU\u0007c\u0001BhC6\u0011!\u0011\u001b\u0006\u0004\u0005'l\u0016A\u0002\u001fs_>$h(C\u0002\u0003X\u0006\fa\u0001\u0015:fI\u00164\u0017\u0002\u0002Bn\u0005;\u0014aa\u0015;sS:<'b\u0001BlC\u0006\u0019D/Z:u'.L\u0007\u000fT8bI&tw-\u00134F[B$\u0018\u0010\u0015:pIV\u001cWM]*uCR,')\u001a4pe\u0016$&/\u001e8dCRLwN\u001c\u0015\u0004m\u0005\u0005\u0016!\r;fgR\u0014VmY8wKJ\fe\r^3s\u001d>tWj\u001c8pi>t\u0017nY\"p_J$\u0017N\\1u_J,\u0005o\\2i/JLG/\u001a\u0015\u0004o\u0005\u0005\u0016!\u0010;fgR\u001c6.\u001b9UeVt7-\u0019;f\u0003:$'+\u001a7pC\u0012Lem\u00147e\u001b\u0016\u001c8/Y4f\r>\u0014X.\u0019;B]\u0012tun\u00117fC:\u001c\u0006.\u001e;e_^t\u0007f\u0001\u001d\u0002\"\u0006YD/Z:u'.L\u0007\u000f\u0016:v]\u000e\fG/Z!oIJ+Gn\\1e\u0013\u001a|E\u000eZ'fgN\fw-\u001a$pe6\fG/\u00118e\u00072,\u0017M\\*ikR$wn\u001e8)\u0007e\n\t+A\u001euKN$8k[5q)J,hnY1uK\u0006sGMU3m_\u0006$\u0017J\u001a(fo6+7o]1hK\u001a{'/\\1u\u0003:$7\t\\3b]NCW\u000f\u001e3po:D3AOAQ\u00035\"Xm\u001d;M_\u0006$\u0007K]8ek\u000e,'o]!gi\u0016\u0014H)\u001a7fi\u0016\u0014VmY8sINl\u0015\u000eZ*fO6,g\u000e\u001e\u0015\u0004w\u0005\u0005\u0016\u0001\u000e;fgRdu.\u00193j]\u001edunZ&fKB\u001cH*\u0019:hKN$8\u000b\u001e:bsB\u0013x\u000eZ;dKJ\u001cF/\u0019;f':\f\u0007o\u001d5pi\"\u001aA(!)\u0002YQ,7\u000f\u001e'pC\u0012\u0004&o\u001c3vG\u0016\u00148/\u00114uKJ$U\r\\3uKJ+7m\u001c:eg>s7+Z4nK:$\bfA\u001f\u0002\"\u0006qB/Z:u\u0019><'+Z2pm\u0016\u00148\u000fV8D_J\u0014Xm\u0019;PM\u001a\u001cX\r\u001e\u0015\u0004}\u0005\u0005\u0016\u0001\u0005;fgRLe\u000eZ3y%\u0016\u0014W/\u001b7eQ\ry\u0014\u0011U\u0001#i\u0016\u001cHOU3ck&dG\rV5nK&sG-\u001a=G_J|E\u000eZ'fgN\fw-Z:)\u0007\u0001\u000b\t+A\fuKN$8i\u001c:skB$\u0018J\u001c3fqJ+'-^5mI\"\u001a\u0011)!)\u0002AQ,7\u000f\u001e\"pOV\u001c\u0018J\u001c3fqN+w-\\3oiN\f%/\u001a*f[>4X\r\u001a\u0015\u0004\u0005\u0006\u0005\u0016A\u0006;fgR\u0014Vm\u001c9f]RCWM\u001c+sk:\u001c\u0017\r^3)\u0007\r\u000b\t+\u0001\u000fuKN$x\n]3o\t\u0016dW\r^3t\u001f\n\u001cx\u000e\\3uK\u001aKG.Z:)\u0007\u0011\u000b\t+\u0001\buKN$8i\u001c:skB$Hj\\4)\u0007\u0015\u000b\t+\u0001\u000fuKN$xJ^3s\u0007>l\u0007/Y2uK\u0012dun\u001a*fG>4XM]=)\u0007\u0019\u000b\t+\u0001\u001fuKN$H*Z1eKJ,\u0005o\\2i\u0007\u0006\u001c\u0007.Z\"mK\u0006\u0014X\rZ!gi\u0016\u00148\u000b^1uS\u000elUm]:bO\u00164uN]7bi\u0012{wO\\4sC\u0012,\u0007fA$\u0002\"\u00069C/Z:u\u001fZ,'oQ8na\u0006\u001cG/\u001a3M_\u001e\u0014VmY8wKJLX*\u001e7uSJ+7m\u001c:eQ\rA\u0015\u0011U\u0001*i\u0016\u001cHo\u0014<fe\u000e{W\u000e]1di\u0016$Gj\\4SK\u000e|g/\u001a:z\u001bVdG/\u001b*fG>\u0014HMV\u0019)\u0007%\u000b\t+A\u0014uKN$(+Z2pm\u0016\u0014\u0018p\u00144TK\u001elWM\u001c;XSRDwJ\u001a4tKR|e/\u001a:gY><\bf\u0001&\u0002\"\u00069C/Z:u%\u0016\u001cwN^3ss\u00063G/\u001a:De\u0006\u001c\b\u000eR;sS:<7\u000b\u001d7jiBC\u0017m]32Q\rY\u0015\u0011U\u0001(i\u0016\u001cHOU3d_Z,'/_!gi\u0016\u00148I]1tQ\u0012+(/\u001b8h'Bd\u0017\u000e\u001e)iCN,'\u0007K\u0002M\u0003C\u000bq\u0005^3tiJ+7m\u001c<fef\fe\r^3s\u0007J\f7\u000f\u001b#ve&twm\u00159mSR\u0004\u0006.Y:fg!\u001aQ*!)\u0002OQ,7\u000f\u001e*fG>4XM]=BMR,'o\u0011:bg\"$UO]5oON\u0003H.\u001b;QQ\u0006\u001cX\r\u000e\u0015\u0004\u001d\u0006\u0005\u0016a\n;fgR\u0014VmY8wKJL\u0018I\u001a;fe\u000e\u0013\u0018m\u001d5EkJLgnZ*qY&$\b\u000b[1tKVB3aTAQ\u0003U!Xm\u001d;DY\u0016\fgn\u00155vi\u0012|wO\u001c$jY\u0016D3\u0001UAQ\u0003u!Xm\u001d;M_\u001e\u0014VmY8wKJ\u001chi\u001c:MK\u0006$WM]#q_\u000eD\u0007fA)\u0002\"\u0006\u0001C/Z:u\rVdG\u000e\u0016:b]N\f7\r^5p]&sG-\u001a=SK\u000e|g/\u001a:zQ\r\u0011\u0016\u0011U\u0001\u001bi\u0016\u001cHOU3d_Z,'o\u00148ms2\u000b7\u000f^*fO6,g\u000e\u001e\u0015\u0004'\u0006\u0005\u0016!\n;fgR\u0014VmY8wKJd\u0015m\u001d;TK\u001elWM\u001c;XSRDgj\\*oCB\u001c\bn\u001c;tQ\r!\u0016\u0011U\u0001#i\u0016\u001cH\u000fT8h\u000b:$G*Z:t)\"\fgn\u0015;beR\fe\r^3s%\u0016|\u0007/\u001a8)\u0007U\u000b\t+A$uKN$8i\u001c:skB$X\r\u001a'pOJ+7m\u001c<fef$u.Z:O_R$U\r\\3uKB\u0013x\u000eZ;dKJ\u001cF/\u0019;f':\f\u0007o\u001d5piN\u0004vn\u001d;SK\u000e|g/\u001a:zQ\r1\u0016\u0011U\u0001\"i\u0016\u001cHOU3d_Z,'oV5uQ\u0016k\u0007\u000f^=BGRLg/Z*fO6,g\u000e\u001e\u0015\u0004/\u0006\u0005\u0006")
public class LogLoaderTest {
    private volatile LogLoaderTest$ErrorTypes$ ErrorTypes$module;
    private KafkaConfig config;
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private final int maxTransactionTimeoutMs;
    private final ProducerStateManagerConfig producerStateManagerConfig = new ProducerStateManagerConfig(Defaults$.MODULE$.ProducerIdExpirationMs());
    private final int producerIdExpirationCheckIntervalMs = Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs();
    private final File tmpDir = TestUtils$.MODULE$.tempDir();
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final MockTime mockTime = new MockTime();

    public LogLoaderTest$ErrorTypes$ ErrorTypes() {
        if (this.ErrorTypes$module == null) {
            this.ErrorTypes$lzycompute$1();
        }
        return this.ErrorTypes$module;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    public int maxTransactionTimeoutMs() {
        return this.maxTransactionTimeoutMs;
    }

    public ProducerStateManagerConfig producerStateManagerConfig() {
        return this.producerStateManagerConfig;
    }

    public int producerIdExpirationCheckIntervalMs() {
        return this.producerIdExpirationCheckIntervalMs;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    @BeforeEach
    public void setUp() {
        int x$1 = 0;
        String x$2 = "127.0.0.1:1";
        int x$3 = -1;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
    }

    @AfterEach
    public void tearDown() {
        this.brokerTopicStats().close();
        Utils.delete((File)this.tmpDir());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLogRecoveryIsCalledUponBrokerCrash() {
        void var20_20;
        void var19_19;
        void var16_16;
        LazyRef SimulateError$module = new LazyRef();
        File logDir = TestUtils$.MODULE$.tempDir();
        Properties logProps = new Properties();
        LogConfig logConfig = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        .colon.colon logDirs = new .colon.colon((Object)logDir, (List)Nil$.MODULE$);
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        ObjectRef log = ObjectRef.create(null);
        MockTime time = new MockTime();
        BooleanRef cleanShutdownInterceptedValue = BooleanRef.create((boolean)false);
        public class Kafka_log_LogLoaderTest$SimulateError$1
        implements Product,
        scala.Serializable {
            private boolean hasError;
            private Enumeration.Value errorType;
            private final /* synthetic */ LogLoaderTest $outer;

            public boolean hasError() {
                return this.hasError;
            }

            public void hasError_$eq(boolean x$1) {
                this.hasError = x$1;
            }

            public Enumeration.Value errorType() {
                return this.errorType;
            }

            public void errorType_$eq(Enumeration.Value x$1) {
                this.errorType = x$1;
            }

            public Kafka_log_LogLoaderTest$SimulateError$1 copy(boolean hasError, Enumeration.Value errorType) {
                return new Kafka_log_LogLoaderTest$SimulateError$1(this.$outer, hasError, errorType);
            }

            public boolean copy$default$1() {
                return this.hasError();
            }

            public Enumeration.Value copy$default$2() {
                return this.errorType();
            }

            public String productPrefix() {
                return "SimulateError";
            }

            public int productArity() {
                return 2;
            }

            public Object productElement(int x$1) {
                switch (x$1) {
                    case 0: {
                        return BoxesRunTime.boxToBoolean((boolean)this.hasError());
                    }
                    case 1: {
                        return this.errorType();
                    }
                }
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Kafka_log_LogLoaderTest$SimulateError$1;
            }

            public int hashCode() {
                return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)-889275714, (int)(this.hasError() ? 1231 : 1237)), (int)Statics.anyHash((Object)this.errorType())), (int)2);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                if (!(x$1 instanceof Kafka_log_LogLoaderTest$SimulateError$1)) return false;
                boolean bl = true;
                if (!bl) return false;
                Kafka_log_LogLoaderTest$SimulateError$1 var3_3 = (Kafka_log_LogLoaderTest$SimulateError$1)x$1;
                if (this.hasError() != var3_3.hasError()) return false;
                Enumeration.Value value = this.errorType();
                Enumeration.Value value2 = var3_3.errorType();
                if (value == null) {
                    if (value2 != null) {
                        return false;
                    }
                } else if (!value.equals(value2)) return false;
                if (!var3_3.canEqual(this)) return false;
                return true;
            }

            public Kafka_log_LogLoaderTest$SimulateError$1(LogLoaderTest $outer, boolean hasError, Enumeration.Value errorType) {
                this.hasError = hasError;
                this.errorType = errorType;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.$init$((Product)this);
            }
        }
        Kafka_log_LogLoaderTest$SimulateError$1 simulateError = this.SimulateError$3(SimulateError$module).apply(this.SimulateError$3(SimulateError$module).apply$default$1(), this.SimulateError$3(SimulateError$module).apply$default$2());
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(logDirs.size());
        int maxTransactionTimeoutMs = 300000;
        int producerIdExpirationCheckIntervalMs = Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        File cleanShutdownFile = new File(logDir, LogLoader$.MODULE$.CleanShutdownFile());
        Tuple2 tuple2 = this.initializeLogManagerForSimulatingErrorTest$1(LogLoaderTest.initializeLogManagerForSimulatingErrorTest$default$1$1((Seq)logDirs), logConfig, (Seq)logDirs, log, topicPartition, logDir, maxTransactionTimeoutMs, producerIdExpirationCheckIntervalMs, time, simulateError, cleanShutdownInterceptedValue);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        LogManager logManager = (LogManager)tuple2._1();
        Files.createFile(cleanShutdownFile.toPath(), new FileAttribute[0]);
        cleanShutdownInterceptedValue.elem = false;
        LogConfig defaultConfig = var16_16.currentDefaultConfig();
        var16_16.loadLogs(defaultConfig, var16_16.fetchTopicConfigOverrides(defaultConfig, (Set)Predef$.MODULE$.Set().empty()));
        Assertions.assertTrue((boolean)cleanShutdownInterceptedValue.elem, (String)"Unexpected value intercepted for clean shutdown flag");
        Assertions.assertFalse((boolean)cleanShutdownFile.exists(), (String)"Clean shutdown file must not exist after loadLogs has completed");
        cleanShutdownInterceptedValue.elem = true;
        defaultConfig = var16_16.currentDefaultConfig();
        var16_16.loadLogs(defaultConfig, var16_16.fetchTopicConfigOverrides(defaultConfig, (Set)Predef$.MODULE$.Set().empty()));
        Assertions.assertFalse((boolean)cleanShutdownInterceptedValue.elem, (String)"Unexpected value intercepted for clean shutdown flag");
        Assertions.assertFalse((boolean)cleanShutdownFile.exists(), (String)"Clean shutdown file must not exist after loadLogs has completed");
        Files.createFile(cleanShutdownFile.toPath(), new FileAttribute[0]);
        var16_16.shutdown();
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
        Tuple2 tuple22 = this.initializeLogManagerForSimulatingErrorTest$1(logDirFailureChannel, logConfig, (Seq)logDirs, log, topicPartition, logDir, maxTransactionTimeoutMs, producerIdExpirationCheckIntervalMs, time, simulateError, cleanShutdownInterceptedValue);
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        LogManager logManager2 = (LogManager)tuple22._1();
        Executable runLoadLogs = (Executable)tuple22._2();
        void logManager3 = var19_19;
        void runLoadLogs2 = var20_20;
        simulateError.hasError_$eq(true);
        simulateError.errorType_$eq(this.ErrorTypes().RuntimeException());
        Assertions.assertThrows(RuntimeException.class, (Executable)runLoadLogs2);
        Assertions.assertFalse((boolean)cleanShutdownFile.exists(), (String)"Clean shutdown file must not have existed");
        Assertions.assertFalse((boolean)logDirFailureChannel.hasOfflineLogDir(logDir.getAbsolutePath()), (String)"log dir should not turn offline when Runtime Exception thrown");
        simulateError.errorType_$eq(this.ErrorTypes().KafkaStorageExceptionWithIOExceptionCause());
        Assertions.assertDoesNotThrow((Executable)runLoadLogs2, (String)"KafkaStorageException with IOException cause should be caught and handled");
        simulateError.errorType_$eq(this.ErrorTypes().KafkaStorageExceptionWithoutIOExceptionCause());
        Assertions.assertThrows(KafkaStorageException.class, (Executable)runLoadLogs2, (String)"should throw exception when KafkaStorageException without IOException cause");
        Assertions.assertFalse((boolean)logDirFailureChannel.hasOfflineLogDir(logDir.getAbsolutePath()), (String)"log dir should not turn offline when KafkaStorageException without IOException cause thrown");
        simulateError.errorType_$eq(this.ErrorTypes().IOException());
        Assertions.assertDoesNotThrow((Executable)runLoadLogs2, (String)"IOException should be caught and handled");
        Assertions.assertTrue((boolean)logDirFailureChannel.hasOfflineLogDir(logDir.getAbsolutePath()), (String)"the log dir should turn offline after IOException thrown");
        simulateError.hasError_$eq(false);
        cleanShutdownInterceptedValue.elem = true;
        LogConfig defaultConfig2 = logManager3.currentDefaultConfig();
        logManager3.loadLogs(defaultConfig2, logManager3.fetchTopicConfigOverrides(defaultConfig2, (Set)Predef$.MODULE$.Set().empty()));
        Assertions.assertFalse((boolean)cleanShutdownInterceptedValue.elem, (String)"Unexpected value for clean shutdown flag");
        logManager3.shutdown();
        Predef$.MODULE$.locally((Object)BoxedUnit.UNIT);
    }

    @Test
    public void testProducerSnapshotsRecoveryAfterUncleanShutdownV1() {
        this.testProducerSnapshotsRecoveryAfterUncleanShutdown(MetadataVersion.minSupportedFor((RecordVersion)RecordVersion.V1).version());
    }

    @Test
    public void testProducerSnapshotsRecoveryAfterUncleanShutdownCurrentMessageFormat() {
        this.testProducerSnapshotsRecoveryAfterUncleanShutdown(MetadataVersion.latest().version());
    }

    private UnifiedLog createLog(File dir, LogConfig config, BrokerTopicStats brokerTopicStats, long logStartOffset, long recoveryPoint, Scheduler scheduler, Time time, int maxTransactionTimeoutMs, int maxProducerIdExpirationMs, int producerIdExpirationCheckIntervalMs, boolean lastShutdownClean) {
        return LogTestUtils$.MODULE$.createLog(dir, config, brokerTopicStats, scheduler, time, logStartOffset, recoveryPoint, maxTransactionTimeoutMs, new ProducerStateManagerConfig(maxProducerIdExpirationMs), producerIdExpirationCheckIntervalMs, lastShutdownClean, LogTestUtils$.MODULE$.createLog$default$12(), LogTestUtils$.MODULE$.createLog$default$13(), LogTestUtils$.MODULE$.createLog$default$14());
    }

    private BrokerTopicStats createLog$default$3() {
        return this.brokerTopicStats();
    }

    private long createLog$default$4() {
        return 0L;
    }

    private long createLog$default$5() {
        return 0L;
    }

    private Scheduler createLog$default$6() {
        return this.mockTime().scheduler();
    }

    private Time createLog$default$7() {
        return this.mockTime();
    }

    private int createLog$default$8() {
        return this.maxTransactionTimeoutMs();
    }

    private int createLog$default$9() {
        return this.producerStateManagerConfig().producerIdExpirationMs();
    }

    private int createLog$default$10() {
        return this.producerIdExpirationCheckIntervalMs();
    }

    private boolean createLog$default$11() {
        return true;
    }

    private Tuple2<UnifiedLog, LogSegment> createLogWithOffsetOverflow(LogConfig logConfig) {
        LogTestUtils$.MODULE$.initializeLogDirWithOverflowedSegment(this.logDir());
        File x$1 = this.logDir();
        long x$3 = Long.MAX_VALUE;
        BrokerTopicStats x$4 = this.createLog$default$3();
        long x$5 = this.createLog$default$4();
        Scheduler x$6 = this.createLog$default$6();
        Time x$7 = this.createLog$default$7();
        int x$8 = this.createLog$default$8();
        int x$9 = this.createLog$default$9();
        int x$10 = this.createLog$default$10();
        boolean x$11 = this.createLog$default$11();
        UnifiedLog log = this.createLog(x$1, logConfig, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11);
        LogSegment segmentWithOverflow = (LogSegment)LogTestUtils$.MODULE$.firstOverflowSegment(log).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new AssertionError((Object)"Failed to create log with a segment which has overflowed offsets");
        });
        return new Tuple2((Object)log, (Object)segmentWithOverflow);
    }

    private UnifiedLog recoverAndCheck(LogConfig config, Iterable<Object> expectedKeys) {
        return LogTestUtils$.MODULE$.recoverAndCheck(this.logDir(), config, expectedKeys, this.brokerTopicStats(), (Time)this.mockTime(), this.mockTime().scheduler());
    }

    private MemoryRecords singletonRecordsWithLeaderEpoch(byte[] value, byte[] key, int leaderEpoch, long offset, CompressionType codec, long timestamp, byte magicValue) {
        .colon.colon records = new .colon.colon((Object)new SimpleRecord(timestamp, key, value), (List)Nil$.MODULE$);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(DefaultRecordBatch.sizeInBytes((java.lang.Iterable)((java.lang.Iterable)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)records).asJava()))), (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)offset, (long)this.mockTime().milliseconds(), (int)leaderEpoch);
        records.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            builder.append(x$1);
            return BoxedUnit.UNIT;
        });
        return builder.build();
    }

    private byte[] singletonRecordsWithLeaderEpoch$default$2() {
        return null;
    }

    private CompressionType singletonRecordsWithLeaderEpoch$default$5() {
        return CompressionType.NONE;
    }

    private long singletonRecordsWithLeaderEpoch$default$6() {
        return -1L;
    }

    private byte singletonRecordsWithLeaderEpoch$default$7() {
        return 2;
    }

    /*
     * WARNING - void declaration
     */
    private void testProducerSnapshotsRecoveryAfterUncleanShutdown(String messageFormatVersion) {
        void var14_11;
        void var13_10;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), "640");
        logProps.put(LogConfig$.MODULE$.MessageFormatVersionProp(), messageFormatVersion);
        LogConfig logConfig = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        ObjectRef log = ObjectRef.create((Object)this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)((UnifiedLog)log.elem).oldestProducerSnapshotOffset());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1 & Serializable & scala.Serializable)i -> LogLoaderTest.$anonfun$testProducerSnapshotsRecoveryAfterUncleanShutdown$1(this, log, BoxesRunTime.unboxToInt((Object)i)));
        Assertions.assertTrue((((UnifiedLog)log.elem).logSegments().size() >= 5 ? 1 : 0) != 0);
        Vector segmentOffsets = (Vector)((UnifiedLog)log.elem).logSegments().toVector().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.baseOffset()), Vector$.MODULE$.canBuildFrom());
        long activeSegmentOffset = BoxesRunTime.unboxToLong((Object)segmentOffsets.last());
        long offsetForSegmentAfterRecoveryPoint = BoxesRunTime.unboxToLong((Object)segmentOffsets.apply(segmentOffsets.size() - 3));
        long offsetForRecoveryPointSegment = BoxesRunTime.unboxToLong((Object)segmentOffsets.apply(segmentOffsets.size() - 4));
        Tuple2 tuple2 = segmentOffsets.toSet().partition((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$4 -> x$4 < offsetForRecoveryPointSegment);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.immutable.Set segOffsetsBeforeRecovery = (scala.collection.immutable.Set)tuple2._1();
        scala.collection.immutable.Set segOffsetsAfterRecovery = (scala.collection.immutable.Set)tuple2._2();
        void segOffsetsBeforeRecovery2 = var13_10;
        void segOffsetsAfterRecovery2 = var14_11;
        long recoveryPoint = offsetForRecoveryPointSegment + 1L;
        Assertions.assertTrue((recoveryPoint < offsetForSegmentAfterRecoveryPoint ? 1 : 0) != 0);
        ((UnifiedLog)log.elem).close();
        scala.collection.mutable.Set segmentsWithReads = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.mutable.Set recoveredSegments = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.mutable.Set expectedSegmentsWithReads = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.mutable.Set expectedSnapshotOffsets = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        if (logConfig.messageFormatVersion().isLessThan(MetadataVersion.IBP_0_11_0_IV0)) {
            expectedSegmentsWithReads.$plus$eq((Object)BoxesRunTime.boxToLong((long)activeSegmentOffset));
            expectedSnapshotOffsets.$plus$plus$eq((TraversableOnce)((TraversableOnce)((UnifiedLog)log.elem).logSegments().map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.baseOffset()), Iterable$.MODULE$.canBuildFrom())).toVector().takeRight(2).$colon$plus((Object)BoxesRunTime.boxToLong((long)((UnifiedLog)log.elem).logEndOffset()), Vector$.MODULE$.canBuildFrom()));
        } else {
            expectedSegmentsWithReads.$plus$plus$eq((TraversableOnce)segOffsetsBeforeRecovery2.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{activeSegmentOffset}))));
            expectedSnapshotOffsets.$plus$plus$eq((TraversableOnce)((TraversableOnce)((UnifiedLog)log.elem).logSegments().map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.baseOffset()), Iterable$.MODULE$.canBuildFrom())).toVector().takeRight(4).$colon$plus((Object)BoxesRunTime.boxToLong((long)((UnifiedLog)log.elem).logEndOffset()), Vector$.MODULE$.canBuildFrom()));
        }
        ((UnifiedLog)log.elem).producerStateManager().deleteSnapshotsBefore(BoxesRunTime.unboxToLong((Object)segmentOffsets.apply(segmentOffsets.size() - 2)));
        log.elem = this.createLogWithInterceptedReads$1(offsetForRecoveryPointSegment, segmentsWithReads, recoveredSegments, logConfig);
        Assertions.assertEquals((Object)expectedSegmentsWithReads, (Object)segmentsWithReads.map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.baseOffset()), Set$.MODULE$.canBuildFrom()));
        Assertions.assertEquals((Object)segOffsetsAfterRecovery2, (Object)recoveredSegments.map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.baseOffset()), Set$.MODULE$.canBuildFrom()));
        Assertions.assertEquals((Object)expectedSnapshotOffsets, (Object)LogTestUtils$.MODULE$.listProducerSnapshotOffsets(this.logDir()).toSet());
        ((UnifiedLog)log.elem).close();
        segmentsWithReads.clear();
        recoveredSegments.clear();
        ((UnifiedLog)log.elem).producerStateManager().deleteSnapshotsBefore(offsetForRecoveryPointSegment);
        log.elem = this.createLogWithInterceptedReads$1(recoveryPoint, segmentsWithReads, recoveredSegments, logConfig);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{activeSegmentOffset})), (Object)segmentsWithReads.map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.baseOffset()), Set$.MODULE$.canBuildFrom()));
        Assertions.assertEquals((Object)segOffsetsAfterRecovery2, (Object)recoveredSegments.map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)x$11.baseOffset()), Set$.MODULE$.canBuildFrom()));
        Assertions.assertEquals((Object)expectedSnapshotOffsets, (Object)LogTestUtils$.MODULE$.listProducerSnapshotOffsets(this.logDir()).toSet());
        ((UnifiedLog)log.elem).close();
    }

    @Test
    public void testSkipLoadingIfEmptyProducerStateBeforeTruncation() {
        int maxTransactionTimeoutMs = 60000;
        ProducerStateManagerConfig producerStateManagerConfig = new ProducerStateManagerConfig(300000);
        ProducerStateManager stateManager = (ProducerStateManager)Mockito.mock(ProducerStateManager.class);
        Mockito.when((Object)stateManager.producerStateManagerConfig()).thenReturn((Object)producerStateManagerConfig);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)stateManager.maxTransactionTimeoutMs())).thenReturn((Object)BoxesRunTime.boxToInteger((int)maxTransactionTimeoutMs));
        Mockito.when((Object)stateManager.latestSnapshotOffset()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)stateManager.mapEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)stateManager.isEmpty())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)stateManager.firstUnstableOffset()).thenReturn((Object)None$.MODULE$);
        TopicPartition topicPartition = UnifiedLog$.MODULE$.parseTopicPartitionName(this.logDir());
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(1);
        LogConfig config = new LogConfig((java.util.Map)new Properties(), LogConfig$.MODULE$.apply$default$2());
        LogSegments segments = new LogSegments(topicPartition);
        Option leaderEpochCache = UnifiedLog$.MODULE$.maybeCreateLeaderEpochCache(this.logDir(), topicPartition, logDirFailureChannel, config.recordVersion(), "");
        LoadedLogOffsets offsets = new LogLoader(this.logDir(), topicPartition, config, (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime(), logDirFailureChannel, false, segments, 0L, 0L, leaderEpochCache, stateManager, LogLoader$.MODULE$.$lessinit$greater$default$13()).load();
        LocalLog localLog = new LocalLog(this.logDir(), config, segments, offsets.recoveryPoint(), offsets.nextOffsetMetadata(), (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime(), topicPartition, logDirFailureChannel);
        UnifiedLog log = new UnifiedLog(offsets.logStartOffset(), localLog, this.brokerTopicStats(), 30000, leaderEpochCache, stateManager, (Option)None$.MODULE$, true);
        ((ProducerStateManager)Mockito.verify((Object)stateManager)).updateMapEndOffset(0L);
        ((ProducerStateManager)Mockito.verify((Object)stateManager)).removeStraySnapshots((Seq)ArgumentMatchers.any());
        ((ProducerStateManager)Mockito.verify((Object)stateManager)).takeSnapshot();
        ((ProducerStateManager)Mockito.verify((Object)stateManager)).truncateAndReload(ArgumentMatchers.eq((long)0L), ArgumentMatchers.eq((long)0L), ArgumentMatchers.anyLong());
        Mockito.reset((Object[])new ProducerStateManager[]{stateManager});
        Mockito.when((Object)stateManager.firstUnstableOffset()).thenReturn((Object)None$.MODULE$);
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("a".getBytes()), (List)Nil$.MODULE$), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("b".getBytes()), (List)Nil$.MODULE$), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        ((ProducerStateManager)Mockito.verify((Object)stateManager)).updateMapEndOffset(1L);
        ((ProducerStateManager)Mockito.verify((Object)stateManager)).updateMapEndOffset(2L);
        Mockito.reset((Object[])new ProducerStateManager[]{stateManager});
        Mockito.when((Object)stateManager.firstUnstableOffset()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)stateManager.latestSnapshotOffset()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)stateManager.isEmpty())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)stateManager.mapEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)2L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)stateManager.mapEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        log.truncateTo(1L);
        ((ProducerStateManager)Mockito.verify((Object)stateManager)).truncateAndReload(ArgumentMatchers.eq((long)0L), ArgumentMatchers.eq((long)1L), ArgumentMatchers.anyLong());
        ((ProducerStateManager)Mockito.verify((Object)stateManager)).updateMapEndOffset(1L);
        ((ProducerStateManager)Mockito.verify((Object)stateManager, (VerificationMode)Mockito.times((int)2))).takeSnapshot();
    }

    @Test
    public void testRecoverAfterNonMonotonicCoordinatorEpochWrite() {
        long producerId = 1L;
        int coordinatorEpoch = 5;
        int x$1 = 0x500000;
        long x$2 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$6 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$7 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$8 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        long x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10);
        UnifiedLog log = this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11());
        short epoch = (short)0;
        long firstAppendTimestamp = this.mockTime().milliseconds();
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, producerId, epoch, ControlRecordType.ABORT, firstAppendTimestamp, coordinatorEpoch, LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$7());
        Assertions.assertEquals((long)firstAppendTimestamp, (long)((ProducerStateEntry)log.producerStateManager().lastEntry(producerId).get()).lastTimestamp());
        int maxProducerIdExpirationMs = Defaults$.MODULE$.ProducerIdExpirationMs();
        this.mockTime().sleep(maxProducerIdExpirationMs);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)log.producerStateManager().lastEntry(producerId));
        long secondAppendTimestamp = this.mockTime().milliseconds();
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, producerId, epoch, ControlRecordType.ABORT, secondAppendTimestamp, coordinatorEpoch - 1, LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$7());
        log.close();
        File x$11 = this.logDir();
        long x$13 = 0L;
        boolean x$14 = false;
        BrokerTopicStats x$15 = this.createLog$default$3();
        long x$16 = this.createLog$default$4();
        Scheduler x$17 = this.createLog$default$6();
        Time x$18 = this.createLog$default$7();
        int x$19 = this.createLog$default$8();
        int x$20 = this.createLog$default$9();
        int x$21 = this.createLog$default$10();
        log = this.createLog(x$11, logConfig, x$15, x$16, x$13, x$17, x$18, x$19, x$20, x$21, x$14);
        Assertions.assertEquals((long)secondAppendTimestamp, (long)((ProducerStateEntry)log.producerStateManager().lastEntry(producerId).get()).lastTimestamp());
        log.close();
    }

    @Test
    public void testSkipTruncateAndReloadIfOldMessageFormatAndNoCleanShutdown() {
        int maxTransactionTimeoutMs = 60000;
        ProducerStateManagerConfig producerStateManagerConfig = new ProducerStateManagerConfig(300000);
        ProducerStateManager stateManager = (ProducerStateManager)Mockito.mock(ProducerStateManager.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)stateManager.isEmpty())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)stateManager.firstUnstableOffset()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)stateManager.producerStateManagerConfig()).thenReturn((Object)producerStateManagerConfig);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)stateManager.maxTransactionTimeoutMs())).thenReturn((Object)BoxesRunTime.boxToInteger((int)maxTransactionTimeoutMs));
        TopicPartition topicPartition = UnifiedLog$.MODULE$.parseTopicPartitionName(this.logDir());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.10.2");
        LogConfig config = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        LogSegments segments = new LogSegments(topicPartition);
        Option leaderEpochCache = UnifiedLog$.MODULE$.maybeCreateLeaderEpochCache(this.logDir(), topicPartition, null, config.recordVersion(), "");
        LoadedLogOffsets offsets = new LogLoader(this.logDir(), topicPartition, config, (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime(), null, false, segments, 0L, 0L, leaderEpochCache, stateManager, LogLoader$.MODULE$.$lessinit$greater$default$13()).load();
        LocalLog localLog = new LocalLog(this.logDir(), config, segments, offsets.recoveryPoint(), offsets.nextOffsetMetadata(), (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime(), topicPartition, null);
        new UnifiedLog(offsets.logStartOffset(), localLog, this.brokerTopicStats(), 30000, leaderEpochCache, stateManager, (Option)None$.MODULE$, true);
        ((ProducerStateManager)Mockito.verify((Object)stateManager)).removeStraySnapshots((Seq)ArgumentMatchers.any());
        ((ProducerStateManager)Mockito.verify((Object)stateManager, (VerificationMode)Mockito.times((int)2))).updateMapEndOffset(0L);
        ((ProducerStateManager)Mockito.verify((Object)stateManager, (VerificationMode)Mockito.times((int)2))).takeSnapshot();
        ((ProducerStateManager)Mockito.verify((Object)stateManager)).isEmpty();
        ((ProducerStateManager)Mockito.verify((Object)stateManager)).firstUnstableOffset();
        ((ProducerStateManager)Mockito.verify((Object)stateManager, (VerificationMode)Mockito.times((int)2))).takeSnapshot();
        ((ProducerStateManager)Mockito.verify((Object)stateManager, (VerificationMode)Mockito.times((int)2))).updateMapEndOffset(0L);
    }

    @Test
    public void testSkipTruncateAndReloadIfOldMessageFormatAndCleanShutdown() {
        int maxTransactionTimeoutMs = 60000;
        ProducerStateManagerConfig producerStateManagerConfig = new ProducerStateManagerConfig(300000);
        ProducerStateManager stateManager = (ProducerStateManager)Mockito.mock(ProducerStateManager.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)stateManager.isEmpty())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)stateManager.firstUnstableOffset()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)stateManager.producerStateManagerConfig()).thenReturn((Object)producerStateManagerConfig);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)stateManager.maxTransactionTimeoutMs())).thenReturn((Object)BoxesRunTime.boxToInteger((int)maxTransactionTimeoutMs));
        TopicPartition topicPartition = UnifiedLog$.MODULE$.parseTopicPartitionName(this.logDir());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.10.2");
        LogConfig config = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        LogSegments segments = new LogSegments(topicPartition);
        Option leaderEpochCache = UnifiedLog$.MODULE$.maybeCreateLeaderEpochCache(this.logDir(), topicPartition, null, config.recordVersion(), "");
        LoadedLogOffsets offsets = new LogLoader(this.logDir(), topicPartition, config, (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime(), null, true, segments, 0L, 0L, leaderEpochCache, stateManager, LogLoader$.MODULE$.$lessinit$greater$default$13()).load();
        LocalLog localLog = new LocalLog(this.logDir(), config, segments, offsets.recoveryPoint(), offsets.nextOffsetMetadata(), (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime(), topicPartition, null);
        new UnifiedLog(offsets.logStartOffset(), localLog, this.brokerTopicStats(), 30000, leaderEpochCache, stateManager, (Option)None$.MODULE$, true);
        ((ProducerStateManager)Mockito.verify((Object)stateManager)).removeStraySnapshots((Seq)ArgumentMatchers.any());
        ((ProducerStateManager)Mockito.verify((Object)stateManager, (VerificationMode)Mockito.times((int)2))).updateMapEndOffset(0L);
        ((ProducerStateManager)Mockito.verify((Object)stateManager, (VerificationMode)Mockito.times((int)2))).takeSnapshot();
        ((ProducerStateManager)Mockito.verify((Object)stateManager)).isEmpty();
        ((ProducerStateManager)Mockito.verify((Object)stateManager)).firstUnstableOffset();
    }

    @Test
    public void testSkipTruncateAndReloadIfNewMessageFormatAndCleanShutdown() {
        int maxTransactionTimeoutMs = 60000;
        ProducerStateManagerConfig producerStateManagerConfig = new ProducerStateManagerConfig(300000);
        ProducerStateManager stateManager = (ProducerStateManager)Mockito.mock(ProducerStateManager.class);
        Mockito.when((Object)stateManager.latestSnapshotOffset()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)stateManager.isEmpty())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)stateManager.firstUnstableOffset()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)stateManager.producerStateManagerConfig()).thenReturn((Object)producerStateManagerConfig);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)stateManager.maxTransactionTimeoutMs())).thenReturn((Object)BoxesRunTime.boxToInteger((int)maxTransactionTimeoutMs));
        TopicPartition topicPartition = UnifiedLog$.MODULE$.parseTopicPartitionName(this.logDir());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.11.0");
        LogConfig config = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        LogSegments segments = new LogSegments(topicPartition);
        Option leaderEpochCache = UnifiedLog$.MODULE$.maybeCreateLeaderEpochCache(this.logDir(), topicPartition, null, config.recordVersion(), "");
        LoadedLogOffsets offsets = new LogLoader(this.logDir(), topicPartition, config, (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime(), null, true, segments, 0L, 0L, leaderEpochCache, stateManager, LogLoader$.MODULE$.$lessinit$greater$default$13()).load();
        LocalLog localLog = new LocalLog(this.logDir(), config, segments, offsets.recoveryPoint(), offsets.nextOffsetMetadata(), (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime(), topicPartition, null);
        new UnifiedLog(offsets.logStartOffset(), localLog, this.brokerTopicStats(), 30000, leaderEpochCache, stateManager, (Option)None$.MODULE$, true);
        ((ProducerStateManager)Mockito.verify((Object)stateManager)).removeStraySnapshots((Seq)ArgumentMatchers.any());
        ((ProducerStateManager)Mockito.verify((Object)stateManager, (VerificationMode)Mockito.times((int)2))).updateMapEndOffset(0L);
        ((ProducerStateManager)Mockito.verify((Object)stateManager, (VerificationMode)Mockito.times((int)2))).takeSnapshot();
        ((ProducerStateManager)Mockito.verify((Object)stateManager)).isEmpty();
        ((ProducerStateManager)Mockito.verify((Object)stateManager)).firstUnstableOffset();
    }

    @Test
    public void testLoadProducersAfterDeleteRecordsMidSegment() {
        int x$1 = 10240;
        long x$2 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$6 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$7 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$8 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        long x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10);
        UnifiedLog log = this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11());
        long pid1 = 1L;
        long pid2 = 2L;
        short epoch = (short)0;
        .colon.colon x$11 = new .colon.colon((Object)new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes()), (List)Nil$.MODULE$);
        int x$14 = 0;
        byte x$15 = TestUtils$.MODULE$.records$default$2();
        CompressionType x$16 = TestUtils$.MODULE$.records$default$3();
        long x$17 = TestUtils$.MODULE$.records$default$7();
        int x$18 = TestUtils$.MODULE$.records$default$8();
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$11, x$15, x$16, pid1, epoch, x$14, x$17, x$18), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        .colon.colon x$19 = new .colon.colon((Object)new SimpleRecord(this.mockTime().milliseconds(), "b".getBytes()), (List)Nil$.MODULE$);
        int x$22 = 0;
        byte x$23 = TestUtils$.MODULE$.records$default$2();
        CompressionType x$24 = TestUtils$.MODULE$.records$default$3();
        long x$25 = TestUtils$.MODULE$.records$default$7();
        int x$26 = TestUtils$.MODULE$.records$default$8();
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$19, x$23, x$24, pid2, epoch, x$22, x$25, x$26), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        Assertions.assertEquals((int)2, (int)log.activeProducersWithLastSequence().size());
        log.updateHighWatermark(log.logEndOffset());
        log.maybeIncrementLogStartOffset(1L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        Assertions.assertEquals((int)2, (int)log.activeProducersWithLastSequence().size());
        Option retainedLastSeqOpt = log.activeProducersWithLastSequence().get((Object)BoxesRunTime.boxToLong((long)pid2));
        Assertions.assertTrue((boolean)retainedLastSeqOpt.isDefined());
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)retainedLastSeqOpt.get()));
        log.close();
        File x$27 = this.logDir();
        long x$29 = 1L;
        boolean x$30 = false;
        BrokerTopicStats x$31 = this.createLog$default$3();
        long x$32 = this.createLog$default$5();
        Scheduler x$33 = this.createLog$default$6();
        Time x$34 = this.createLog$default$7();
        int x$35 = this.createLog$default$8();
        int x$36 = this.createLog$default$9();
        int x$37 = this.createLog$default$10();
        UnifiedLog reloadedLog = this.createLog(x$27, logConfig, x$31, x$29, x$32, x$33, x$34, x$35, x$36, x$37, x$30);
        Assertions.assertEquals((int)2, (int)reloadedLog.activeProducersWithLastSequence().size());
        Option reloadedLastSeqOpt = log.activeProducersWithLastSequence().get((Object)BoxesRunTime.boxToLong((long)pid2));
        Assertions.assertEquals((Object)retainedLastSeqOpt, (Object)reloadedLastSeqOpt);
    }

    @Test
    public void testLoadingLogKeepsLargestStrayProducerStateSnapshot() {
        int x$1 = 10240;
        long x$2 = 0L;
        long x$3 = 60000L;
        long x$4 = 0L;
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$7 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$8 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$10 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$5, x$1, x$3, x$2, x$6, x$7, x$8, x$9, x$10, x$4);
        UnifiedLog log = this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11());
        long pid1 = 1L;
        short epoch = (short)0;
        .colon.colon x$11 = new .colon.colon((Object)new SimpleRecord("a".getBytes()), (List)Nil$.MODULE$);
        int x$142 = 0;
        byte x$15 = TestUtils$.MODULE$.records$default$2();
        CompressionType x$16 = TestUtils$.MODULE$.records$default$3();
        long x$17 = TestUtils$.MODULE$.records$default$7();
        int x$18 = TestUtils$.MODULE$.records$default$8();
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$11, x$15, x$16, pid1, epoch, x$142, x$17, x$18), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        .colon.colon x$19 = new .colon.colon((Object)new SimpleRecord("b".getBytes()), (List)Nil$.MODULE$);
        int x$22 = 1;
        byte x$23 = TestUtils$.MODULE$.records$default$2();
        CompressionType x$24 = TestUtils$.MODULE$.records$default$3();
        long x$25 = TestUtils$.MODULE$.records$default$7();
        int x$26 = TestUtils$.MODULE$.records$default$8();
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$19, x$23, x$24, pid1, epoch, x$22, x$25, x$26), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        .colon.colon x$27 = new .colon.colon((Object)new SimpleRecord("c".getBytes()), (List)Nil$.MODULE$);
        int x$30 = 2;
        byte x$31 = TestUtils$.MODULE$.records$default$2();
        CompressionType x$32 = TestUtils$.MODULE$.records$default$3();
        long x$33 = TestUtils$.MODULE$.records$default$7();
        int x$34 = TestUtils$.MODULE$.records$default$8();
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$27, x$31, x$32, pid1, epoch, x$30, x$33, x$34), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        .colon.colon x$35 = new .colon.colon((Object)new SimpleRecord("d".getBytes()), (List)Nil$.MODULE$);
        int x$38 = 3;
        byte x$39 = TestUtils$.MODULE$.records$default$2();
        CompressionType x$40 = TestUtils$.MODULE$.records$default$3();
        long x$41 = TestUtils$.MODULE$.records$default$7();
        int x$42 = TestUtils$.MODULE$.records$default$8();
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$35, x$39, x$40, pid1, epoch, x$38, x$41, x$42), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.close();
        Assertions.assertEquals((int)log.logSegments().size(), (int)3);
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 4})), (Object)((SeqLike)ProducerStateManager$.MODULE$.listSnapshotFiles(this.logDir()).map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.offset()), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Long$.MODULE$));
        Files.createFile(UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), 3L).toPath(), new FileAttribute[0]);
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), (Object)((SeqLike)ProducerStateManager$.MODULE$.listSnapshotFiles(this.logDir()).map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)x$13.offset()), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Long$.MODULE$));
        File x$43 = this.logDir();
        boolean x$45 = false;
        BrokerTopicStats x$46 = this.createLog$default$3();
        long x$47 = this.createLog$default$4();
        long x$48 = this.createLog$default$5();
        Scheduler x$49 = this.createLog$default$6();
        Time x$50 = this.createLog$default$7();
        int x$51 = this.createLog$default$8();
        int x$52 = this.createLog$default$9();
        int x$53 = this.createLog$default$10();
        this.createLog(x$43, logConfig, x$46, x$47, x$48, x$49, x$50, x$51, x$52, x$53, x$45);
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 4})), (Object)((SeqLike)ProducerStateManager$.MODULE$.listSnapshotFiles(this.logDir()).map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToLong((long)x$14.offset()), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Long$.MODULE$));
    }

    @Test
    public void testLoadProducersAfterDeleteRecordsOnSegment() {
        int x$1 = 10240;
        long x$2 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$6 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$7 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$8 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        long x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10);
        UnifiedLog log = this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11());
        long pid1 = 1L;
        long pid2 = 2L;
        short epoch = (short)0;
        .colon.colon x$11 = new .colon.colon((Object)new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes()), (List)Nil$.MODULE$);
        int x$14 = 0;
        byte x$15 = TestUtils$.MODULE$.records$default$2();
        CompressionType x$16 = TestUtils$.MODULE$.records$default$3();
        long x$17 = TestUtils$.MODULE$.records$default$7();
        int x$18 = TestUtils$.MODULE$.records$default$8();
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$11, x$15, x$16, pid1, epoch, x$14, x$17, x$18), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.roll(log.roll$default$1());
        .colon.colon x$19 = new .colon.colon((Object)new SimpleRecord(this.mockTime().milliseconds(), "b".getBytes()), (List)Nil$.MODULE$);
        int x$22 = 0;
        byte x$23 = TestUtils$.MODULE$.records$default$2();
        CompressionType x$24 = TestUtils$.MODULE$.records$default$3();
        long x$25 = TestUtils$.MODULE$.records$default$7();
        int x$26 = TestUtils$.MODULE$.records$default$8();
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)x$19, x$23, x$24, pid2, epoch, x$22, x$25, x$26), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        Assertions.assertEquals((int)2, (int)log.logSegments().size());
        Assertions.assertEquals((int)2, (int)log.activeProducersWithLastSequence().size());
        log.updateHighWatermark(log.logEndOffset());
        log.maybeIncrementLogStartOffset(1L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        log.deleteOldSegments();
        Assertions.assertEquals((int)1, (int)log.logSegments().size());
        Assertions.assertEquals((int)2, (int)log.activeProducersWithLastSequence().size());
        Option retainedLastSeqOpt = log.activeProducersWithLastSequence().get((Object)BoxesRunTime.boxToLong((long)pid2));
        Assertions.assertTrue((boolean)retainedLastSeqOpt.isDefined());
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)retainedLastSeqOpt.get()));
        log.close();
        File x$27 = this.logDir();
        long x$29 = 1L;
        boolean x$30 = false;
        BrokerTopicStats x$31 = this.createLog$default$3();
        long x$32 = this.createLog$default$5();
        Scheduler x$33 = this.createLog$default$6();
        Time x$34 = this.createLog$default$7();
        int x$35 = this.createLog$default$8();
        int x$36 = this.createLog$default$9();
        int x$37 = this.createLog$default$10();
        UnifiedLog reloadedLog = this.createLog(x$27, logConfig, x$31, x$29, x$32, x$33, x$34, x$35, x$36, x$37, x$30);
        Assertions.assertEquals((int)1, (int)reloadedLog.activeProducersWithLastSequence().size());
        Option reloadedEntryOpt = log.activeProducersWithLastSequence().get((Object)BoxesRunTime.boxToLong((long)pid2));
        Assertions.assertEquals((Object)retainedLastSeqOpt, (Object)reloadedEntryOpt);
    }

    @Test
    public void testLogRecoversToCorrectOffset() {
        int numMessages = 100;
        int messageSize = 100;
        int segmentSize = 7 * messageSize;
        int indexInterval = 3 * messageSize;
        int x$3 = 4096;
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$7 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$8 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        long x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$4, segmentSize, x$5, x$6, x$7, x$8, x$9, indexInterval, x$3, x$10);
        ObjectRef log = ObjectRef.create((Object)this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach((Function1 & Serializable & scala.Serializable)i -> LogLoaderTest.$anonfun$testLogRecoversToCorrectOffset$1(this, log, messageSize, BoxesRunTime.unboxToInt((Object)i)));
        Assertions.assertEquals((long)numMessages, (long)((UnifiedLog)log.elem).logEndOffset(), (String)new StringOps(Predef$.MODULE$.augmentString("After appending %d messages to an empty log, the log end offset should be %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numMessages), BoxesRunTime.boxToInteger((int)numMessages)})));
        long lastIndexOffset = ((UnifiedLog)log.elem).activeSegment().offsetIndex().lastOffset();
        int numIndexEntries = ((UnifiedLog)log.elem).activeSegment().offsetIndex().entries();
        long lastOffset = ((UnifiedLog)log.elem).logEndOffset();
        long lastTimeIndexOffset = ((UnifiedLog)log.elem).logEndOffset() - 1L;
        long lastTimeIndexTimestamp = ((UnifiedLog)log.elem).activeSegment().largestTimestamp();
        int numTimeIndexEntries = ((UnifiedLog)log.elem).activeSegment().timeIndex().entries() + (((UnifiedLog)log.elem).activeSegment().timeIndex().lastEntry().offset() == ((UnifiedLog)log.elem).logEndOffset() - 1L ? 0 : 1);
        ((UnifiedLog)log.elem).close();
        File x$21 = this.logDir();
        boolean x$24 = false;
        BrokerTopicStats x$25 = this.createLog$default$3();
        long x$26 = this.createLog$default$4();
        Scheduler x$27 = this.createLog$default$6();
        Time x$28 = this.createLog$default$7();
        int x$29 = this.createLog$default$8();
        int x$30 = this.createLog$default$9();
        int x$31 = this.createLog$default$10();
        log.elem = this.createLog(x$21, logConfig, x$25, x$26, lastOffset, x$27, x$28, x$29, x$30, x$31, x$24);
        LogLoaderTest.verifyRecoveredLog$1((UnifiedLog)log.elem, lastOffset, numMessages, lastIndexOffset, numIndexEntries, lastTimeIndexTimestamp, lastTimeIndexOffset, numTimeIndexEntries);
        ((UnifiedLog)log.elem).close();
        int recoveryPoint = 10;
        File x$32 = this.logDir();
        long x$34 = recoveryPoint;
        boolean x$35 = false;
        BrokerTopicStats x$36 = this.createLog$default$3();
        long x$37 = this.createLog$default$4();
        Scheduler x$38 = this.createLog$default$6();
        Time x$39 = this.createLog$default$7();
        int x$40 = this.createLog$default$8();
        int x$41 = this.createLog$default$9();
        int x$42 = this.createLog$default$10();
        log.elem = this.createLog(x$32, logConfig, x$36, x$37, x$34, x$38, x$39, x$40, x$41, x$42, x$35);
        LogLoaderTest.verifyRecoveredLog$1((UnifiedLog)log.elem, recoveryPoint, numMessages, lastIndexOffset, numIndexEntries, lastTimeIndexTimestamp, lastTimeIndexOffset, numTimeIndexEntries);
        ((UnifiedLog)log.elem).flush(false);
        LogLoaderTest.verifyRecoveredLog$1((UnifiedLog)log.elem, lastOffset, numMessages, lastIndexOffset, numIndexEntries, lastTimeIndexTimestamp, lastTimeIndexOffset, numTimeIndexEntries);
        ((UnifiedLog)log.elem).close();
    }

    @Test
    public void testIndexRebuild() {
        int numMessages = 200;
        int x$1 = 200;
        int x$2 = 1;
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$7 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$8 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        long x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$3, x$1, x$4, x$5, x$6, x$7, x$8, x$2, x$9, x$10);
        ObjectRef log = ObjectRef.create((Object)this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach((Function1 & Serializable & scala.Serializable)i -> LogLoaderTest.$anonfun$testIndexRebuild$1(this, log, BoxesRunTime.unboxToInt((Object)i)));
        Iterable indexFiles = (Iterable)((UnifiedLog)log.elem).logSegments().map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.lazyOffsetIndex().file(), Iterable$.MODULE$.canBuildFrom());
        Iterable timeIndexFiles = (Iterable)((UnifiedLog)log.elem).logSegments().map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.lazyTimeIndex().file(), Iterable$.MODULE$.canBuildFrom());
        ((UnifiedLog)log.elem).close();
        indexFiles.foreach((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)x$17.delete()));
        timeIndexFiles.foreach((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)x$18.delete()));
        File x$21 = this.logDir();
        boolean x$23 = false;
        BrokerTopicStats x$24 = this.createLog$default$3();
        long x$25 = this.createLog$default$4();
        long x$26 = this.createLog$default$5();
        Scheduler x$27 = this.createLog$default$6();
        Time x$28 = this.createLog$default$7();
        int x$29 = this.createLog$default$8();
        int x$30 = this.createLog$default$9();
        int x$31 = this.createLog$default$10();
        log.elem = this.createLog(x$21, logConfig, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$23);
        Assertions.assertEquals((long)numMessages, (long)((UnifiedLog)log.elem).logEndOffset(), (String)new StringOps(Predef$.MODULE$.augmentString("Should have %d messages when log is reopened")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numMessages)})));
        Assertions.assertTrue((((LogSegment)((UnifiedLog)log.elem).logSegments().head()).offsetIndex().entries() > 0 ? 1 : 0) != 0, (String)"The index should have been rebuilt");
        Assertions.assertTrue((((LogSegment)((UnifiedLog)log.elem).logSegments().head()).timeIndex().entries() > 0 ? 1 : 0) != 0, (String)"The time index should have been rebuilt");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            Assertions.assertEquals((long)i, (long)((RecordBatch)LogTestUtils$.MODULE$.readLog((UnifiedLog)log$4.elem, i, 100, LogTestUtils$.MODULE$.readLog$default$4(), LogTestUtils$.MODULE$.readLog$default$5()).records().batches().iterator().next()).lastOffset());
            if (i == 0) {
                Assertions.assertEquals((long)((LogSegment)((UnifiedLog)log$4.elem).logSegments().head()).baseOffset(), (long)((FileRecords.TimestampAndOffset)((UnifiedLog)log$4.elem).fetchOffsetByTimestamp((long)($this.mockTime().milliseconds() + (long)(i * 10))).get()).offset);
                return;
            }
            Assertions.assertEquals((long)i, (long)((FileRecords.TimestampAndOffset)((UnifiedLog)log$4.elem).fetchOffsetByTimestamp((long)($this.mockTime().milliseconds() + (long)(i * 10))).get()).offset);
        });
        ((UnifiedLog)log.elem).close();
    }

    @Test
    public void testRebuildTimeIndexForOldMessages() {
        int numMessages = 200;
        int segmentSize = 200;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Integer.toString(segmentSize));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), "1");
        logProps.put(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.9.0");
        LogConfig logConfig = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        ObjectRef log = ObjectRef.create((Object)this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach((Function1 & Serializable & scala.Serializable)i -> LogLoaderTest.$anonfun$testRebuildTimeIndexForOldMessages$1(this, log, BoxesRunTime.unboxToInt((Object)i)));
        Iterable timeIndexFiles = (Iterable)((UnifiedLog)log.elem).logSegments().map((Function1 & Serializable & scala.Serializable)x$19 -> x$19.lazyTimeIndex().file(), Iterable$.MODULE$.canBuildFrom());
        ((UnifiedLog)log.elem).close();
        timeIndexFiles.foreach((Function1 & Serializable & scala.Serializable)file -> {
            LogLoaderTest.$anonfun$testRebuildTimeIndexForOldMessages$3(file);
            return BoxedUnit.UNIT;
        });
        File x$11 = this.logDir();
        long x$13 = numMessages + 1;
        boolean x$14 = false;
        BrokerTopicStats x$15 = this.createLog$default$3();
        long x$16 = this.createLog$default$4();
        Scheduler x$17 = this.createLog$default$6();
        Time x$18 = this.createLog$default$7();
        int x$192 = this.createLog$default$8();
        int x$20 = this.createLog$default$9();
        int x$21 = this.createLog$default$10();
        log.elem = this.createLog(x$11, logConfig, x$15, x$16, x$13, x$17, x$18, x$192, x$20, x$21, x$14);
        ((IterableLike)((UnifiedLog)log.elem).logSegments().init()).foreach((Function1 & Serializable & scala.Serializable)segment -> {
            LogLoaderTest.$anonfun$testRebuildTimeIndexForOldMessages$4(segment);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCorruptIndexRebuild() {
        int numMessages = 200;
        int x$1 = 200;
        int x$2 = 1;
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$7 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$8 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        long x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$3, x$1, x$4, x$5, x$6, x$7, x$8, x$2, x$9, x$10);
        ObjectRef log = ObjectRef.create((Object)this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach((Function1 & Serializable & scala.Serializable)i -> LogLoaderTest.$anonfun$testCorruptIndexRebuild$1(this, log, BoxesRunTime.unboxToInt((Object)i)));
        Iterable indexFiles = (Iterable)((UnifiedLog)log.elem).logSegments().map((Function1 & Serializable & scala.Serializable)x$20 -> x$20.lazyOffsetIndex().file(), Iterable$.MODULE$.canBuildFrom());
        Iterable timeIndexFiles = (Iterable)((UnifiedLog)log.elem).logSegments().map((Function1 & Serializable & scala.Serializable)x$21 -> x$21.lazyTimeIndex().file(), Iterable$.MODULE$.canBuildFrom());
        ((UnifiedLog)log.elem).close();
        indexFiles.foreach((Function1 & Serializable & scala.Serializable)file -> {
            LogLoaderTest.$anonfun$testCorruptIndexRebuild$4(file);
            return BoxedUnit.UNIT;
        });
        timeIndexFiles.foreach((Function1 & Serializable & scala.Serializable)file -> {
            LogLoaderTest.$anonfun$testCorruptIndexRebuild$5(file);
            return BoxedUnit.UNIT;
        });
        File x$212 = this.logDir();
        boolean x$23 = false;
        BrokerTopicStats x$24 = this.createLog$default$3();
        long x$25 = this.createLog$default$4();
        long x$26 = this.createLog$default$5();
        Scheduler x$27 = this.createLog$default$6();
        Time x$28 = this.createLog$default$7();
        int x$29 = this.createLog$default$8();
        int x$30 = this.createLog$default$9();
        int x$31 = this.createLog$default$10();
        log.elem = this.createLog(x$212, logConfig, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$23);
        Assertions.assertEquals((long)numMessages, (long)((UnifiedLog)log.elem).logEndOffset(), (String)new StringOps(Predef$.MODULE$.augmentString("Should have %d messages when log is reopened")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numMessages)})));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            Assertions.assertEquals((long)i, (long)((RecordBatch)LogTestUtils$.MODULE$.readLog((UnifiedLog)log$6.elem, i, 100, LogTestUtils$.MODULE$.readLog$default$4(), LogTestUtils$.MODULE$.readLog$default$5()).records().batches().iterator().next()).lastOffset());
            if (i == 0) {
                Assertions.assertEquals((long)((LogSegment)((UnifiedLog)log$6.elem).logSegments().head()).baseOffset(), (long)((FileRecords.TimestampAndOffset)((UnifiedLog)log$6.elem).fetchOffsetByTimestamp((long)($this.mockTime().milliseconds() + (long)(i * 10))).get()).offset);
                return;
            }
            Assertions.assertEquals((long)i, (long)((FileRecords.TimestampAndOffset)((UnifiedLog)log$6.elem).fetchOffsetByTimestamp((long)($this.mockTime().milliseconds() + (long)(i * 10))).get()).offset);
        });
        ((UnifiedLog)log.elem).close();
    }

    @Test
    public void testBogusIndexSegmentsAreRemoved() {
        File bogusIndex1 = UnifiedLog$.MODULE$.offsetIndexFile(this.logDir(), 0L, UnifiedLog$.MODULE$.offsetIndexFile$default$3());
        File bogusTimeIndex1 = UnifiedLog$.MODULE$.timeIndexFile(this.logDir(), 0L, UnifiedLog$.MODULE$.timeIndexFile$default$3());
        File bogusIndex2 = UnifiedLog$.MODULE$.offsetIndexFile(this.logDir(), 5L, UnifiedLog$.MODULE$.offsetIndexFile$default$3());
        File bogusTimeIndex2 = UnifiedLog$.MODULE$.timeIndexFile(this.logDir(), 5L, UnifiedLog$.MODULE$.timeIndexFile$default$3());
        Files.createFile(bogusIndex2.toPath(), new FileAttribute[0]);
        Files.createFile(bogusTimeIndex2.toPath(), new FileAttribute[0]);
        int x$1 = this.createRecords$1().sizeInBytes() * 5;
        int x$2 = 1000;
        int x$3 = 1;
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$7 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$8 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        long x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$4, x$1, x$5, x$6, x$7, x$8, x$9, x$3, x$2, x$10);
        UnifiedLog log = this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11());
        ((LogSegment)log.logSegments().toSeq().head()).offsetIndex();
        ((LogSegment)log.logSegments().toSeq().head()).timeIndex();
        Assertions.assertTrue((bogusIndex1.length() > 0L ? 1 : 0) != 0, (String)"The first index file should have been replaced with a larger file");
        Assertions.assertTrue((bogusTimeIndex1.length() > 0L ? 1 : 0) != 0, (String)"The first time index file should have been replaced with a larger file");
        Assertions.assertFalse((boolean)bogusIndex2.exists(), (String)"The second index file should have been deleted.");
        Assertions.assertFalse((boolean)bogusTimeIndex2.exists(), (String)"The second time index file should have been deleted.");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable & scala.Serializable)_ -> log.appendAsLeader(this.createRecords$1(), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        log.delete();
    }

    @Test
    public void testReopenThenTruncate() {
        int x$1 = this.createRecords$2().sizeInBytes() * 5;
        int x$2 = 1000;
        int x$3 = 10000;
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$7 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$8 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        long x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$4, x$1, x$5, x$6, x$7, x$8, x$9, x$3, x$2, x$10);
        ObjectRef log = ObjectRef.create((Object)this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1 & Serializable & scala.Serializable)_ -> LogLoaderTest.$anonfun$testReopenThenTruncate$1(this, log, BoxesRunTime.unboxToInt((Object)_)));
        ((UnifiedLog)log.elem).close();
        File x$16 = this.logDir();
        boolean x$18 = false;
        BrokerTopicStats x$19 = this.createLog$default$3();
        long x$20 = this.createLog$default$4();
        long x$21 = this.createLog$default$5();
        Scheduler x$22 = this.createLog$default$6();
        Time x$23 = this.createLog$default$7();
        int x$24 = this.createLog$default$8();
        int x$25 = this.createLog$default$9();
        int x$26 = this.createLog$default$10();
        log.elem = this.createLog(x$16, logConfig, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$18);
        ((UnifiedLog)log.elem).truncateTo(3L);
        Assertions.assertEquals((int)1, (int)((UnifiedLog)log.elem).numberOfSegments(), (String)"All but one segment should be deleted.");
        Assertions.assertEquals((long)3L, (long)((UnifiedLog)log.elem).logEndOffset(), (String)"Log end offset should be 3.");
    }

    @Test
    public void testOpenDeletesObsoleteFiles() {
        int x$1 = this.createRecords$3().sizeInBytes() * 5;
        int x$2 = 1000;
        long x$3 = 999L;
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$7 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$8 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        long x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$4, x$1, x$3, x$5, x$6, x$7, x$8, x$9, x$2, x$10);
        ObjectRef log = ObjectRef.create((Object)this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1 & Serializable & scala.Serializable)_ -> LogLoaderTest.$anonfun$testOpenDeletesObsoleteFiles$1(this, log, BoxesRunTime.unboxToInt((Object)_)));
        ((UnifiedLog)log.elem).updateHighWatermark(((UnifiedLog)log.elem).logEndOffset());
        ((UnifiedLog)log.elem).deleteOldSegments();
        ((UnifiedLog)log.elem).close();
        File x$16 = this.logDir();
        boolean x$18 = false;
        BrokerTopicStats x$19 = this.createLog$default$3();
        long x$20 = this.createLog$default$4();
        long x$21 = this.createLog$default$5();
        Scheduler x$22 = this.createLog$default$6();
        Time x$23 = this.createLog$default$7();
        int x$24 = this.createLog$default$8();
        int x$25 = this.createLog$default$9();
        int x$26 = this.createLog$default$10();
        log.elem = this.createLog(x$16, logConfig, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$18);
        Assertions.assertEquals((int)1, (int)((UnifiedLog)log.elem).numberOfSegments(), (String)"The deleted segments should be gone.");
    }

    @Test
    public void testCorruptLog() {
        int x$1 = 1000;
        int x$2 = 1;
        int x$3 = 65536;
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$7 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$8 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        long x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$4, x$1, x$5, x$6, x$7, x$8, x$3, x$2, x$9, x$10);
        long recoveryPoint = 50L;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_2 -> {
            this.logDir().mkdirs();
            ObjectRef log = ObjectRef.create((Object)this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11()));
            int numMessages = 50 + TestUtils$.MODULE$.random().nextInt(50);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach((Function1 & Serializable & scala.Serializable)_ -> LogLoaderTest.$anonfun$testCorruptLog$2(this, log, BoxesRunTime.unboxToInt((Object)_)));
            List records = ((TraversableOnce)((UnifiedLog)log.elem).logSegments().flatMap((Function1 & Serializable & scala.Serializable)x$22 -> ((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(x$22.log().records()).asScala()).toList(), Iterable$.MODULE$.canBuildFrom())).toList();
            ((UnifiedLog)log.elem).close();
            TestUtils$.MODULE$.appendNonsenseToFile(((UnifiedLog)log.elem).activeSegment().lazyOffsetIndex().file(), TestUtils$.MODULE$.random().nextInt(1024) + 1);
            TestUtils$.MODULE$.appendNonsenseToFile(((UnifiedLog)log.elem).activeSegment().log().file(), TestUtils$.MODULE$.random().nextInt(1024) + 1);
            File x$16 = this.logDir();
            BrokerTopicStats x$18 = this.brokerTopicStats();
            long x$19 = 0L;
            boolean x$21 = false;
            Scheduler x$222 = this.createLog$default$6();
            Time x$232 = this.createLog$default$7();
            int x$24 = this.createLog$default$8();
            int x$25 = this.createLog$default$9();
            int x$26 = this.createLog$default$10();
            log.elem = this.createLog(x$16, logConfig, x$18, x$19, recoveryPoint, x$222, x$232, x$24, x$25, x$26, x$21);
            Assertions.assertEquals((long)numMessages, (long)((UnifiedLog)log.elem).logEndOffset());
            List recovered = ((TraversableOnce)((UnifiedLog)log.elem).logSegments().flatMap((Function1 & Serializable & scala.Serializable)x$23 -> ((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(x$23.log().records()).asScala()).toList(), Iterable$.MODULE$.canBuildFrom())).toList();
            Assertions.assertEquals((int)records.size(), (int)recovered.size());
            records.indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                Record expected = (Record)records.apply(i);
                Record actual = (Record)recovered.apply(i);
                Assertions.assertEquals((Object)expected.key(), (Object)actual.key(), (String)"Keys not equal");
                Assertions.assertEquals((Object)expected.value(), (Object)actual.value(), (String)"Values not equal");
                Assertions.assertEquals((long)expected.timestamp(), (long)actual.timestamp(), (String)"Timestamps not equal");
            });
            Utils.delete((File)this.logDir());
        });
    }

    @Test
    public void testOverCompactedLogRecovery() {
        int x$1 = 1000;
        int x$2 = 1;
        int x$3 = 65536;
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$7 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$8 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        long x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$4, x$1, x$5, x$6, x$7, x$8, x$3, x$2, x$9, x$10);
        UnifiedLog log = this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11());
        MemoryRecords set1 = MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("v1".getBytes(), "k1".getBytes())});
        MemoryRecords set2 = MemoryRecords.withRecords((long)((long)Integer.MAX_VALUE + 2L), (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("v3".getBytes(), "k3".getBytes())});
        MemoryRecords set3 = MemoryRecords.withRecords((long)((long)Integer.MAX_VALUE + 3L), (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("v4".getBytes(), "k4".getBytes())});
        MemoryRecords set4 = MemoryRecords.withRecords((long)((long)Integer.MAX_VALUE + 4L), (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("v5".getBytes(), "k5".getBytes())});
        log.appendAsFollower(set1);
        Assertions.assertEquals((long)0L, (long)log.activeSegment().baseOffset());
        log.appendAsFollower(set2);
        Assertions.assertEquals((long)((long)Integer.MAX_VALUE + 2L), (long)log.activeSegment().baseOffset());
        Assertions.assertTrue((boolean)UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), (long)Integer.MAX_VALUE + 2L).exists());
        log.appendAsFollower(set3);
        Assertions.assertEquals((long)((long)Integer.MAX_VALUE + 2L), (long)log.activeSegment().baseOffset());
        log.appendAsFollower(set4);
        Assertions.assertEquals((long)((long)Integer.MAX_VALUE + 2L), (long)log.activeSegment().baseOffset());
        log.close();
        File[] indexFiles = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())).filter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoaderTest.$anonfun$testOverCompactedLogRecovery$1(file)));
        Assertions.assertEquals((int)2, (int)indexFiles.length);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])indexFiles)).foreach((Function1 & Serializable & scala.Serializable)file -> {
            LogLoaderTest.$anonfun$testOverCompactedLogRecovery$2(file);
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)this.logDir());
    }

    @Test
    public void testLeaderEpochCacheClearedAfterStaticMessageFormatDowngrade() {
        int x$1 = 1000;
        int x$2 = 1;
        int x$3 = 65536;
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$7 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$8 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        long x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$4, x$1, x$5, x$6, x$7, x$8, x$3, x$2, x$9, x$10);
        UnifiedLog log = this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11());
        log.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("foo".getBytes()), (List)Nil$.MODULE$), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8()), 5, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)), (Object)log.latestEpoch());
        log.close();
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), "1000");
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), "1");
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), "65536");
        logProps.put(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.10.2");
        LogConfig downgradedLogConfig = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        File x$11 = this.logDir();
        boolean x$13 = false;
        BrokerTopicStats x$14 = this.createLog$default$3();
        long x$15 = this.createLog$default$4();
        long x$16 = this.createLog$default$5();
        Scheduler x$17 = this.createLog$default$6();
        Time x$18 = this.createLog$default$7();
        int x$19 = this.createLog$default$8();
        int x$20 = this.createLog$default$9();
        int x$21 = this.createLog$default$10();
        UnifiedLog reopened = this.createLog(x$11, downgradedLogConfig, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$13);
        LogTestUtils$.MODULE$.assertLeaderEpochCacheEmpty(reopened);
        reopened.appendAsLeader(TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("bar".getBytes()), (List)Nil$.MODULE$), RecordVersion.V1.value, TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8()), 5, reopened.appendAsLeader$default$3(), reopened.appendAsLeader$default$4(), reopened.appendAsLeader$default$5());
        LogTestUtils$.MODULE$.assertLeaderEpochCacheEmpty(reopened);
    }

    @Test
    public void testOverCompactedLogRecoveryMultiRecord() {
        int x$1 = 1000;
        int x$2 = 1;
        int x$3 = 65536;
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$7 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$8 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        long x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$4, x$1, x$5, x$6, x$7, x$8, x$3, x$2, x$9, x$10);
        UnifiedLog log = this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11());
        MemoryRecords set1 = MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("v1".getBytes(), "k1".getBytes())});
        MemoryRecords set2 = MemoryRecords.withRecords((long)((long)Integer.MAX_VALUE + 2L), (CompressionType)CompressionType.GZIP, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("v3".getBytes(), "k3".getBytes()), new SimpleRecord("v4".getBytes(), "k4".getBytes())});
        MemoryRecords set3 = MemoryRecords.withRecords((long)((long)Integer.MAX_VALUE + 4L), (CompressionType)CompressionType.GZIP, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("v5".getBytes(), "k5".getBytes()), new SimpleRecord("v6".getBytes(), "k6".getBytes())});
        MemoryRecords set4 = MemoryRecords.withRecords((long)((long)Integer.MAX_VALUE + 6L), (CompressionType)CompressionType.GZIP, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("v7".getBytes(), "k7".getBytes()), new SimpleRecord("v8".getBytes(), "k8".getBytes())});
        log.appendAsFollower(set1);
        Assertions.assertEquals((long)0L, (long)log.activeSegment().baseOffset());
        log.appendAsFollower(set2);
        Assertions.assertEquals((long)((long)Integer.MAX_VALUE + 2L), (long)log.activeSegment().baseOffset());
        Assertions.assertTrue((boolean)UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), (long)Integer.MAX_VALUE + 2L).exists());
        log.appendAsFollower(set3);
        Assertions.assertEquals((long)((long)Integer.MAX_VALUE + 2L), (long)log.activeSegment().baseOffset());
        log.appendAsFollower(set4);
        Assertions.assertEquals((long)((long)Integer.MAX_VALUE + 2L), (long)log.activeSegment().baseOffset());
        log.close();
        File[] indexFiles = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())).filter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoaderTest.$anonfun$testOverCompactedLogRecoveryMultiRecord$1(file)));
        Assertions.assertEquals((int)2, (int)indexFiles.length);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])indexFiles)).foreach((Function1 & Serializable & scala.Serializable)file -> {
            LogLoaderTest.$anonfun$testOverCompactedLogRecoveryMultiRecord$2(file);
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)this.logDir());
    }

    @Test
    public void testOverCompactedLogRecoveryMultiRecordV1() {
        int x$1 = 1000;
        int x$2 = 1;
        int x$3 = 65536;
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$7 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$8 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        long x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$4, x$1, x$5, x$6, x$7, x$8, x$3, x$2, x$9, x$10);
        UnifiedLog log = this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11());
        MemoryRecords set1 = MemoryRecords.withRecords((byte)1, (long)0L, (CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("v1".getBytes(), "k1".getBytes())});
        MemoryRecords set2 = MemoryRecords.withRecords((byte)1, (long)((long)Integer.MAX_VALUE + 2L), (CompressionType)CompressionType.GZIP, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("v3".getBytes(), "k3".getBytes()), new SimpleRecord("v4".getBytes(), "k4".getBytes())});
        MemoryRecords set3 = MemoryRecords.withRecords((byte)1, (long)((long)Integer.MAX_VALUE + 4L), (CompressionType)CompressionType.GZIP, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("v5".getBytes(), "k5".getBytes()), new SimpleRecord("v6".getBytes(), "k6".getBytes())});
        MemoryRecords set4 = MemoryRecords.withRecords((byte)1, (long)((long)Integer.MAX_VALUE + 6L), (CompressionType)CompressionType.GZIP, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("v7".getBytes(), "k7".getBytes()), new SimpleRecord("v8".getBytes(), "k8".getBytes())});
        log.appendAsFollower(set1);
        Assertions.assertEquals((long)0L, (long)log.activeSegment().baseOffset());
        log.appendAsFollower(set2);
        Assertions.assertEquals((long)3L, (long)log.activeSegment().baseOffset());
        Assertions.assertTrue((boolean)UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), 3L).exists());
        log.appendAsFollower(set3);
        Assertions.assertEquals((long)((long)Integer.MAX_VALUE + 4L), (long)log.activeSegment().baseOffset());
        Assertions.assertTrue((boolean)UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), (long)Integer.MAX_VALUE + 4L).exists());
        log.appendAsFollower(set4);
        Assertions.assertEquals((long)((long)Integer.MAX_VALUE + 4L), (long)log.activeSegment().baseOffset());
        log.close();
        File[] indexFiles = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())).filter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoaderTest.$anonfun$testOverCompactedLogRecoveryMultiRecordV1$1(file)));
        Assertions.assertEquals((int)3, (int)indexFiles.length);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])indexFiles)).foreach((Function1 & Serializable & scala.Serializable)file -> {
            LogLoaderTest.$anonfun$testOverCompactedLogRecoveryMultiRecordV1$2(file);
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)this.logDir());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecoveryOfSegmentWithOffsetOverflow() {
        void var18_13;
        int x$10;
        int x$9;
        String x$8;
        long x$7;
        long x$6;
        long x$5;
        int x$4;
        int x$1 = 1;
        long x$2 = 1000L;
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$3, x$4 = LogTestUtils$.MODULE$.createLogConfig$default$2(), x$5 = LogTestUtils$.MODULE$.createLogConfig$default$3(), x$6 = LogTestUtils$.MODULE$.createLogConfig$default$4(), x$7 = LogTestUtils$.MODULE$.createLogConfig$default$5(), x$8 = LogTestUtils$.MODULE$.createLogConfig$default$6(), x$9 = LogTestUtils$.MODULE$.createLogConfig$default$7(), x$1, x$10 = LogTestUtils$.MODULE$.createLogConfig$default$9(), x$2);
        Tuple2<UnifiedLog, LogSegment> tuple2 = this.createLogWithOffsetOverflow(logConfig);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        UnifiedLog log = (UnifiedLog)tuple2._1();
        Iterable<Object> expectedKeys = LogTestUtils$.MODULE$.keysInLog((UnifiedLog)var18_13);
        UnifiedLog recoveredLog = this.recoverAndCheck(logConfig, expectedKeys);
        Assertions.assertEquals(expectedKeys, LogTestUtils$.MODULE$.keysInLog(recoveredLog));
        recoveredLog.logSegments().foreach(arg_0 -> LogLoaderTest.$anonfun$testRecoveryOfSegmentWithOffsetOverflow$1((UnifiedLog)var18_13, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecoveryAfterCrashDuringSplitPhase1() {
        void var19_14;
        void var18_13;
        int x$10;
        int x$9;
        String x$8;
        long x$7;
        long x$6;
        long x$5;
        int x$4;
        int x$1 = 1;
        long x$2 = 1000L;
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$3, x$4 = LogTestUtils$.MODULE$.createLogConfig$default$2(), x$5 = LogTestUtils$.MODULE$.createLogConfig$default$3(), x$6 = LogTestUtils$.MODULE$.createLogConfig$default$4(), x$7 = LogTestUtils$.MODULE$.createLogConfig$default$5(), x$8 = LogTestUtils$.MODULE$.createLogConfig$default$6(), x$9 = LogTestUtils$.MODULE$.createLogConfig$default$7(), x$1, x$10 = LogTestUtils$.MODULE$.createLogConfig$default$9(), x$2);
        Tuple2<UnifiedLog, LogSegment> tuple2 = this.createLogWithOffsetOverflow(logConfig);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        UnifiedLog log = (UnifiedLog)tuple2._1();
        LogSegment segmentWithOverflow = (LogSegment)tuple2._2();
        void log2 = var18_13;
        void segmentWithOverflow2 = var19_14;
        Iterable<Object> expectedKeys = LogTestUtils$.MODULE$.keysInLog((UnifiedLog)log2);
        int numSegmentsInitial = log2.logSegments().size();
        log2.splitOverflowedSegment((LogSegment)segmentWithOverflow2).reverse().foreach((Function1 & Serializable & scala.Serializable)segment -> BoxesRunTime.boxToInteger((int)LogLoaderTest.$anonfun$testRecoveryAfterCrashDuringSplitPhase1$1(segment)));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())).withFilter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoaderTest.$anonfun$testRecoveryAfterCrashDuringSplitPhase1$2(file))).foreach((Function1 & Serializable & scala.Serializable)file -> {
            LogLoaderTest.$anonfun$testRecoveryAfterCrashDuringSplitPhase1$3(file);
            return BoxedUnit.UNIT;
        });
        UnifiedLog recoveredLog = this.recoverAndCheck(logConfig, expectedKeys);
        Assertions.assertEquals(expectedKeys, LogTestUtils$.MODULE$.keysInLog(recoveredLog));
        Assertions.assertEquals((int)(numSegmentsInitial + 1), (int)recoveredLog.logSegments().size());
        recoveredLog.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecoveryAfterCrashDuringSplitPhase2() {
        void var19_14;
        void var18_13;
        int x$10;
        int x$9;
        String x$8;
        long x$7;
        long x$6;
        long x$5;
        int x$4;
        int x$1 = 1;
        long x$2 = 1000L;
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$3, x$4 = LogTestUtils$.MODULE$.createLogConfig$default$2(), x$5 = LogTestUtils$.MODULE$.createLogConfig$default$3(), x$6 = LogTestUtils$.MODULE$.createLogConfig$default$4(), x$7 = LogTestUtils$.MODULE$.createLogConfig$default$5(), x$8 = LogTestUtils$.MODULE$.createLogConfig$default$6(), x$9 = LogTestUtils$.MODULE$.createLogConfig$default$7(), x$1, x$10 = LogTestUtils$.MODULE$.createLogConfig$default$9(), x$2);
        Tuple2<UnifiedLog, LogSegment> tuple2 = this.createLogWithOffsetOverflow(logConfig);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        UnifiedLog log = (UnifiedLog)tuple2._1();
        LogSegment segmentWithOverflow = (LogSegment)tuple2._2();
        void log2 = var18_13;
        void segmentWithOverflow2 = var19_14;
        Iterable<Object> expectedKeys = LogTestUtils$.MODULE$.keysInLog((UnifiedLog)log2);
        int numSegmentsInitial = log2.logSegments().size();
        List newSegments = log2.splitOverflowedSegment((LogSegment)segmentWithOverflow2);
        newSegments.reverse().foreach((Function1 & Serializable & scala.Serializable)segment -> BoxesRunTime.boxToInteger((int)LogLoaderTest.$anonfun$testRecoveryAfterCrashDuringSplitPhase2$1(newSegments, segment)));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())).withFilter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoaderTest.$anonfun$testRecoveryAfterCrashDuringSplitPhase2$2(file))).foreach((Function1 & Serializable & scala.Serializable)file -> {
            LogLoaderTest.$anonfun$testRecoveryAfterCrashDuringSplitPhase2$3(file);
            return BoxedUnit.UNIT;
        });
        UnifiedLog recoveredLog = this.recoverAndCheck(logConfig, expectedKeys);
        Assertions.assertEquals(expectedKeys, LogTestUtils$.MODULE$.keysInLog(recoveredLog));
        Assertions.assertEquals((int)(numSegmentsInitial + 1), (int)recoveredLog.logSegments().size());
        recoveredLog.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecoveryAfterCrashDuringSplitPhase3() {
        void var19_14;
        void var18_13;
        int x$10;
        int x$9;
        String x$8;
        long x$7;
        long x$6;
        long x$5;
        int x$4;
        int x$1 = 1;
        long x$2 = 1000L;
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$3, x$4 = LogTestUtils$.MODULE$.createLogConfig$default$2(), x$5 = LogTestUtils$.MODULE$.createLogConfig$default$3(), x$6 = LogTestUtils$.MODULE$.createLogConfig$default$4(), x$7 = LogTestUtils$.MODULE$.createLogConfig$default$5(), x$8 = LogTestUtils$.MODULE$.createLogConfig$default$6(), x$9 = LogTestUtils$.MODULE$.createLogConfig$default$7(), x$1, x$10 = LogTestUtils$.MODULE$.createLogConfig$default$9(), x$2);
        Tuple2<UnifiedLog, LogSegment> tuple2 = this.createLogWithOffsetOverflow(logConfig);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        UnifiedLog log = (UnifiedLog)tuple2._1();
        LogSegment segmentWithOverflow = (LogSegment)tuple2._2();
        void log2 = var18_13;
        void segmentWithOverflow2 = var19_14;
        Iterable<Object> expectedKeys = LogTestUtils$.MODULE$.keysInLog((UnifiedLog)log2);
        int numSegmentsInitial = log2.logSegments().size();
        log2.splitOverflowedSegment((LogSegment)segmentWithOverflow2).reverse().foreach((Function1 & Serializable & scala.Serializable)segment -> {
            segment.changeFileSuffixes("", UnifiedLog$.MODULE$.SwapFileSuffix());
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())).withFilter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoaderTest.$anonfun$testRecoveryAfterCrashDuringSplitPhase3$2(file))).foreach((Function1 & Serializable & scala.Serializable)file -> {
            LogLoaderTest.$anonfun$testRecoveryAfterCrashDuringSplitPhase3$3(file);
            return BoxedUnit.UNIT;
        });
        segmentWithOverflow2.truncateTo(0L);
        UnifiedLog recoveredLog = this.recoverAndCheck(logConfig, expectedKeys);
        Assertions.assertEquals(expectedKeys, LogTestUtils$.MODULE$.keysInLog(recoveredLog));
        Assertions.assertEquals((int)(numSegmentsInitial + 1), (int)recoveredLog.logSegments().size());
        log2.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecoveryAfterCrashDuringSplitPhase4() {
        void var19_14;
        void var18_13;
        int x$10;
        int x$9;
        String x$8;
        long x$7;
        long x$6;
        long x$5;
        int x$4;
        int x$1 = 1;
        long x$2 = 1000L;
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$3, x$4 = LogTestUtils$.MODULE$.createLogConfig$default$2(), x$5 = LogTestUtils$.MODULE$.createLogConfig$default$3(), x$6 = LogTestUtils$.MODULE$.createLogConfig$default$4(), x$7 = LogTestUtils$.MODULE$.createLogConfig$default$5(), x$8 = LogTestUtils$.MODULE$.createLogConfig$default$6(), x$9 = LogTestUtils$.MODULE$.createLogConfig$default$7(), x$1, x$10 = LogTestUtils$.MODULE$.createLogConfig$default$9(), x$2);
        Tuple2<UnifiedLog, LogSegment> tuple2 = this.createLogWithOffsetOverflow(logConfig);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        UnifiedLog log = (UnifiedLog)tuple2._1();
        LogSegment segmentWithOverflow = (LogSegment)tuple2._2();
        void log2 = var18_13;
        void segmentWithOverflow2 = var19_14;
        Iterable<Object> expectedKeys = LogTestUtils$.MODULE$.keysInLog((UnifiedLog)log2);
        int numSegmentsInitial = log2.logSegments().size();
        log2.splitOverflowedSegment((LogSegment)segmentWithOverflow2).reverse().foreach((Function1 & Serializable & scala.Serializable)x$28 -> {
            x$28.changeFileSuffixes("", UnifiedLog$.MODULE$.SwapFileSuffix());
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())).withFilter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoaderTest.$anonfun$testRecoveryAfterCrashDuringSplitPhase4$2(file))).foreach((Function1 & Serializable & scala.Serializable)file -> {
            LogLoaderTest.$anonfun$testRecoveryAfterCrashDuringSplitPhase4$3(file);
            return BoxedUnit.UNIT;
        });
        segmentWithOverflow2.truncateTo(0L);
        UnifiedLog recoveredLog = this.recoverAndCheck(logConfig, expectedKeys);
        Assertions.assertEquals(expectedKeys, LogTestUtils$.MODULE$.keysInLog(recoveredLog));
        Assertions.assertEquals((int)(numSegmentsInitial + 1), (int)recoveredLog.logSegments().size());
        recoveredLog.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecoveryAfterCrashDuringSplitPhase5() {
        void var19_14;
        void var18_13;
        int x$10;
        int x$9;
        String x$8;
        long x$7;
        long x$6;
        long x$5;
        int x$4;
        int x$1 = 1;
        long x$2 = 1000L;
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$3, x$4 = LogTestUtils$.MODULE$.createLogConfig$default$2(), x$5 = LogTestUtils$.MODULE$.createLogConfig$default$3(), x$6 = LogTestUtils$.MODULE$.createLogConfig$default$4(), x$7 = LogTestUtils$.MODULE$.createLogConfig$default$5(), x$8 = LogTestUtils$.MODULE$.createLogConfig$default$6(), x$9 = LogTestUtils$.MODULE$.createLogConfig$default$7(), x$1, x$10 = LogTestUtils$.MODULE$.createLogConfig$default$9(), x$2);
        Tuple2<UnifiedLog, LogSegment> tuple2 = this.createLogWithOffsetOverflow(logConfig);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        UnifiedLog log = (UnifiedLog)tuple2._1();
        LogSegment segmentWithOverflow = (LogSegment)tuple2._2();
        void log2 = var18_13;
        void segmentWithOverflow2 = var19_14;
        Iterable<Object> expectedKeys = LogTestUtils$.MODULE$.keysInLog((UnifiedLog)log2);
        int numSegmentsInitial = log2.logSegments().size();
        ((LogSegment)log2.splitOverflowedSegment((LogSegment)segmentWithOverflow2).last()).changeFileSuffixes("", UnifiedLog$.MODULE$.SwapFileSuffix());
        segmentWithOverflow2.truncateTo(0L);
        UnifiedLog recoveredLog = this.recoverAndCheck(logConfig, expectedKeys);
        Assertions.assertEquals(expectedKeys, LogTestUtils$.MODULE$.keysInLog(recoveredLog));
        Assertions.assertEquals((int)(numSegmentsInitial + 1), (int)recoveredLog.logSegments().size());
        recoveredLog.close();
    }

    @Test
    public void testCleanShutdownFile() {
        int x$1 = 1000;
        int x$2 = 1;
        int x$3 = 65536;
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$7 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$8 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        long x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$4, x$1, x$5, x$6, x$7, x$8, x$3, x$2, x$9, x$10);
        ObjectRef log = ObjectRef.create((Object)this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1 & Serializable & scala.Serializable)_ -> LogLoaderTest.$anonfun$testCleanShutdownFile$1(this, log, BoxesRunTime.unboxToInt((Object)_)));
        ((UnifiedLog)log.elem).close();
        long recoveryPoint = ((UnifiedLog)log.elem).logEndOffset();
        log.elem = this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11());
        Assertions.assertEquals((long)recoveryPoint, (long)((UnifiedLog)log.elem).logEndOffset());
    }

    @Test
    public void testLogRecoversForLeaderEpoch() {
        UnifiedLog log = this.createLog(this.logDir(), LogConfig$.MODULE$.apply(), this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11());
        LeaderEpochFileCache leaderEpochCache = (LeaderEpochFileCache)log.leaderEpochCache().get();
        byte[] x$1 = "random".getBytes();
        int x$2 = 1;
        long x$3 = 0L;
        byte[] x$4 = this.singletonRecordsWithLeaderEpoch$default$2();
        CompressionType x$5 = this.singletonRecordsWithLeaderEpoch$default$5();
        long x$6 = this.singletonRecordsWithLeaderEpoch$default$6();
        byte x$7 = this.singletonRecordsWithLeaderEpoch$default$7();
        MemoryRecords firstBatch = this.singletonRecordsWithLeaderEpoch(x$1, x$4, x$2, x$3, x$5, x$6, x$7);
        log.appendAsFollower(firstBatch);
        byte[] x$8 = "random".getBytes();
        int x$9 = 2;
        long x$10 = 1L;
        byte[] x$11 = this.singletonRecordsWithLeaderEpoch$default$2();
        CompressionType x$12 = this.singletonRecordsWithLeaderEpoch$default$5();
        long x$13 = this.singletonRecordsWithLeaderEpoch$default$6();
        byte x$14 = this.singletonRecordsWithLeaderEpoch$default$7();
        MemoryRecords secondBatch = this.singletonRecordsWithLeaderEpoch(x$8, x$11, x$9, x$10, x$12, x$13, x$14);
        log.appendAsFollower(secondBatch);
        byte[] x$15 = "random".getBytes();
        int x$16 = 2;
        long x$17 = 2L;
        byte[] x$18 = this.singletonRecordsWithLeaderEpoch$default$2();
        CompressionType x$19 = this.singletonRecordsWithLeaderEpoch$default$5();
        long x$20 = this.singletonRecordsWithLeaderEpoch$default$6();
        byte x$21 = this.singletonRecordsWithLeaderEpoch$default$7();
        MemoryRecords thirdBatch = this.singletonRecordsWithLeaderEpoch(x$15, x$18, x$16, x$17, x$19, x$20, x$21);
        log.appendAsFollower(thirdBatch);
        byte[] x$22 = "random".getBytes();
        int x$23 = 3;
        long x$24 = 3L;
        byte[] x$25 = this.singletonRecordsWithLeaderEpoch$default$2();
        CompressionType x$26 = this.singletonRecordsWithLeaderEpoch$default$5();
        long x$27 = this.singletonRecordsWithLeaderEpoch$default$6();
        byte x$28 = this.singletonRecordsWithLeaderEpoch$default$7();
        MemoryRecords fourthBatch = this.singletonRecordsWithLeaderEpoch(x$22, x$25, x$23, x$24, x$26, x$27, x$28);
        log.appendAsFollower(fourthBatch);
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(1, 0L), new EpochEntry(2, 1L), new EpochEntry(3, 3L)})), (Object)leaderEpochCache.epochEntries());
        leaderEpochCache.truncateFromEnd(2L);
        Assertions.assertNotEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(1, 0L), new EpochEntry(2, 1L), new EpochEntry(3, 3L)})), (Object)leaderEpochCache.epochEntries());
        log.close();
        File x$29 = this.logDir();
        LogConfig x$30 = LogConfig$.MODULE$.apply();
        boolean x$31 = false;
        BrokerTopicStats x$32 = this.createLog$default$3();
        long x$33 = this.createLog$default$4();
        long x$34 = this.createLog$default$5();
        Scheduler x$35 = this.createLog$default$6();
        Time x$36 = this.createLog$default$7();
        int x$37 = this.createLog$default$8();
        int x$38 = this.createLog$default$9();
        int x$39 = this.createLog$default$10();
        UnifiedLog recoveredLog = this.createLog(x$29, x$30, x$32, x$33, x$34, x$35, x$36, x$37, x$38, x$39, x$31);
        LeaderEpochFileCache recoveredLeaderEpochCache = (LeaderEpochFileCache)recoveredLog.leaderEpochCache().get();
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(1, 0L), new EpochEntry(2, 1L), new EpochEntry(3, 3L)})), (Object)recoveredLeaderEpochCache.epochEntries());
        recoveredLog.close();
    }

    @Test
    public void testFullTransactionIndexRecovery() {
        int x$1 = 640;
        long x$2 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$6 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$7 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$8 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        long x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10);
        UnifiedLog log = this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11());
        short epoch = (short)0;
        long pid1 = 1L;
        long pid2 = 2L;
        long pid3 = 3L;
        long pid4 = 4L;
        Function1<Object, BoxedUnit> appendPid1 = LogTestUtils$.MODULE$.appendTransactionalAsLeader(log, pid1, epoch, (Time)this.mockTime());
        Function1<Object, BoxedUnit> appendPid2 = LogTestUtils$.MODULE$.appendTransactionalAsLeader(log, pid2, epoch, (Time)this.mockTime());
        Function1<Object, BoxedUnit> appendPid3 = LogTestUtils$.MODULE$.appendTransactionalAsLeader(log, pid3, epoch, (Time)this.mockTime());
        Function1<Object, BoxedUnit> appendPid4 = LogTestUtils$.MODULE$.appendTransactionalAsLeader(log, pid4, epoch, (Time)this.mockTime());
        appendPid1.apply$mcVI$sp(5);
        LogTestUtils$.MODULE$.appendNonTransactionalAsLeader(log, 3);
        appendPid2.apply$mcVI$sp(2);
        appendPid1.apply$mcVI$sp(4);
        appendPid3.apply$mcVI$sp(3);
        LogTestUtils$.MODULE$.appendNonTransactionalAsLeader(log, 2);
        appendPid1.apply$mcVI$sp(10);
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, pid1, epoch, ControlRecordType.ABORT, this.mockTime().milliseconds(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$6(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$7());
        appendPid2.apply$mcVI$sp(6);
        appendPid4.apply$mcVI$sp(3);
        LogTestUtils$.MODULE$.appendNonTransactionalAsLeader(log, 10);
        appendPid3.apply$mcVI$sp(9);
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, pid3, epoch, ControlRecordType.COMMIT, this.mockTime().milliseconds(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$6(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$7());
        appendPid4.apply$mcVI$sp(8);
        appendPid2.apply$mcVI$sp(7);
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, pid2, epoch, ControlRecordType.ABORT, this.mockTime().milliseconds(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$6(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$7());
        LogTestUtils$.MODULE$.appendNonTransactionalAsLeader(log, 10);
        appendPid4.apply$mcVI$sp(4);
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, pid4, epoch, ControlRecordType.COMMIT, this.mockTime().milliseconds(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$6(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$7());
        log.logSegments().foreach((Function1 & Serializable & scala.Serializable)segment -> BoxesRunTime.boxToBoolean((boolean)LogLoaderTest.$anonfun$testFullTransactionIndexRecovery$1(segment)));
        log.close();
        int x$11 = 5120;
        long x$12 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$13 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$14 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$15 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$16 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$17 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$18 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$19 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        long x$20 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        LogConfig reloadedLogConfig = LogTestUtils$.MODULE$.createLogConfig(x$12, x$11, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        File x$21 = this.logDir();
        boolean x$23 = false;
        BrokerTopicStats x$24 = this.createLog$default$3();
        long x$25 = this.createLog$default$4();
        long x$26 = this.createLog$default$5();
        Scheduler x$27 = this.createLog$default$6();
        Time x$28 = this.createLog$default$7();
        int x$29 = this.createLog$default$8();
        int x$30 = this.createLog$default$9();
        int x$31 = this.createLog$default$10();
        UnifiedLog reloadedLog = this.createLog(x$21, reloadedLogConfig, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$23);
        Iterable<AbortedTxn> abortedTransactions = LogTestUtils$.MODULE$.allAbortedTransactions(reloadedLog);
        Assertions.assertEquals((Object)new .colon.colon((Object)new AbortedTxn(pid1, 0L, 29L, 8L), (List)new .colon.colon((Object)new AbortedTxn(pid2, 8L, 74L, 36L), (List)Nil$.MODULE$)), abortedTransactions);
    }

    @Test
    public void testRecoverOnlyLastSegment() {
        int x$1 = 640;
        long x$2 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$6 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$7 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$8 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        long x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10);
        UnifiedLog log = this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11());
        short epoch = (short)0;
        long pid1 = 1L;
        long pid2 = 2L;
        long pid3 = 3L;
        long pid4 = 4L;
        Function1<Object, BoxedUnit> appendPid1 = LogTestUtils$.MODULE$.appendTransactionalAsLeader(log, pid1, epoch, (Time)this.mockTime());
        Function1<Object, BoxedUnit> appendPid2 = LogTestUtils$.MODULE$.appendTransactionalAsLeader(log, pid2, epoch, (Time)this.mockTime());
        Function1<Object, BoxedUnit> appendPid3 = LogTestUtils$.MODULE$.appendTransactionalAsLeader(log, pid3, epoch, (Time)this.mockTime());
        Function1<Object, BoxedUnit> appendPid4 = LogTestUtils$.MODULE$.appendTransactionalAsLeader(log, pid4, epoch, (Time)this.mockTime());
        appendPid1.apply$mcVI$sp(5);
        LogTestUtils$.MODULE$.appendNonTransactionalAsLeader(log, 3);
        appendPid2.apply$mcVI$sp(2);
        appendPid1.apply$mcVI$sp(4);
        appendPid3.apply$mcVI$sp(3);
        LogTestUtils$.MODULE$.appendNonTransactionalAsLeader(log, 2);
        appendPid1.apply$mcVI$sp(10);
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, pid1, epoch, ControlRecordType.ABORT, this.mockTime().milliseconds(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$6(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$7());
        appendPid2.apply$mcVI$sp(6);
        appendPid4.apply$mcVI$sp(3);
        LogTestUtils$.MODULE$.appendNonTransactionalAsLeader(log, 10);
        appendPid3.apply$mcVI$sp(9);
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, pid3, epoch, ControlRecordType.COMMIT, this.mockTime().milliseconds(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$6(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$7());
        appendPid4.apply$mcVI$sp(8);
        appendPid2.apply$mcVI$sp(7);
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, pid2, epoch, ControlRecordType.ABORT, this.mockTime().milliseconds(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$6(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$7());
        LogTestUtils$.MODULE$.appendNonTransactionalAsLeader(log, 10);
        appendPid4.apply$mcVI$sp(4);
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, pid4, epoch, ControlRecordType.COMMIT, this.mockTime().milliseconds(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$6(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$7());
        LogSegment lastSegment = (LogSegment)log.logSegments().last();
        long recoveryPoint = lastSegment.baseOffset();
        lastSegment.offsetIndex().deleteIfExists();
        lastSegment.txnIndex().deleteIfExists();
        log.close();
        int x$11 = 5120;
        long x$12 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$13 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$14 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$15 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$16 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$17 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$18 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$19 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        long x$20 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        LogConfig reloadedLogConfig = LogTestUtils$.MODULE$.createLogConfig(x$12, x$11, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        File x$21 = this.logDir();
        boolean x$24 = false;
        BrokerTopicStats x$25 = this.createLog$default$3();
        long x$26 = this.createLog$default$4();
        Scheduler x$27 = this.createLog$default$6();
        Time x$28 = this.createLog$default$7();
        int x$29 = this.createLog$default$8();
        int x$30 = this.createLog$default$9();
        int x$31 = this.createLog$default$10();
        UnifiedLog reloadedLog = this.createLog(x$21, reloadedLogConfig, x$25, x$26, recoveryPoint, x$27, x$28, x$29, x$30, x$31, x$24);
        Iterable<AbortedTxn> abortedTransactions = LogTestUtils$.MODULE$.allAbortedTransactions(reloadedLog);
        Assertions.assertEquals((Object)new .colon.colon((Object)new AbortedTxn(pid1, 0L, 29L, 8L), (List)new .colon.colon((Object)new AbortedTxn(pid2, 8L, 74L, 36L), (List)Nil$.MODULE$)), abortedTransactions);
    }

    @Test
    public void testRecoverLastSegmentWithNoSnapshots() {
        int x$1 = 640;
        long x$2 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$3 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$6 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$7 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$8 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        long x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10);
        UnifiedLog log = this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11());
        short epoch = (short)0;
        long pid1 = 1L;
        long pid2 = 2L;
        long pid3 = 3L;
        long pid4 = 4L;
        Function1<Object, BoxedUnit> appendPid1 = LogTestUtils$.MODULE$.appendTransactionalAsLeader(log, pid1, epoch, (Time)this.mockTime());
        Function1<Object, BoxedUnit> appendPid2 = LogTestUtils$.MODULE$.appendTransactionalAsLeader(log, pid2, epoch, (Time)this.mockTime());
        Function1<Object, BoxedUnit> appendPid3 = LogTestUtils$.MODULE$.appendTransactionalAsLeader(log, pid3, epoch, (Time)this.mockTime());
        Function1<Object, BoxedUnit> appendPid4 = LogTestUtils$.MODULE$.appendTransactionalAsLeader(log, pid4, epoch, (Time)this.mockTime());
        appendPid1.apply$mcVI$sp(5);
        LogTestUtils$.MODULE$.appendNonTransactionalAsLeader(log, 3);
        appendPid2.apply$mcVI$sp(2);
        appendPid1.apply$mcVI$sp(4);
        appendPid3.apply$mcVI$sp(3);
        LogTestUtils$.MODULE$.appendNonTransactionalAsLeader(log, 2);
        appendPid1.apply$mcVI$sp(10);
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, pid1, epoch, ControlRecordType.ABORT, this.mockTime().milliseconds(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$6(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$7());
        appendPid2.apply$mcVI$sp(6);
        appendPid4.apply$mcVI$sp(3);
        LogTestUtils$.MODULE$.appendNonTransactionalAsLeader(log, 10);
        appendPid3.apply$mcVI$sp(9);
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, pid3, epoch, ControlRecordType.COMMIT, this.mockTime().milliseconds(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$6(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$7());
        appendPid4.apply$mcVI$sp(8);
        appendPid2.apply$mcVI$sp(7);
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, pid2, epoch, ControlRecordType.ABORT, this.mockTime().milliseconds(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$6(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$7());
        LogTestUtils$.MODULE$.appendNonTransactionalAsLeader(log, 10);
        appendPid4.apply$mcVI$sp(4);
        LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader(log, pid4, epoch, ControlRecordType.COMMIT, this.mockTime().milliseconds(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$6(), LogTestUtils$.MODULE$.appendEndTxnMarkerAsLeader$default$7());
        LogTestUtils$.MODULE$.deleteProducerSnapshotFiles(this.logDir());
        LogSegment lastSegment = (LogSegment)log.logSegments().last();
        long recoveryPoint = lastSegment.baseOffset();
        lastSegment.offsetIndex().deleteIfExists();
        lastSegment.txnIndex().deleteIfExists();
        log.close();
        int x$11 = 5120;
        long x$12 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$13 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$14 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$15 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$16 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$17 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        int x$18 = LogTestUtils$.MODULE$.createLogConfig$default$8();
        int x$19 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        long x$20 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        LogConfig reloadedLogConfig = LogTestUtils$.MODULE$.createLogConfig(x$12, x$11, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        File x$21 = this.logDir();
        boolean x$24 = false;
        BrokerTopicStats x$25 = this.createLog$default$3();
        long x$26 = this.createLog$default$4();
        Scheduler x$27 = this.createLog$default$6();
        Time x$28 = this.createLog$default$7();
        int x$29 = this.createLog$default$8();
        int x$30 = this.createLog$default$9();
        int x$31 = this.createLog$default$10();
        UnifiedLog reloadedLog = this.createLog(x$21, reloadedLogConfig, x$25, x$26, recoveryPoint, x$27, x$28, x$29, x$30, x$31, x$24);
        Iterable<AbortedTxn> abortedTransactions = LogTestUtils$.MODULE$.allAbortedTransactions(reloadedLog);
        Assertions.assertEquals((Object)new .colon.colon((Object)new AbortedTxn(pid1, 0L, 29L, 8L), (List)new .colon.colon((Object)new AbortedTxn(pid2, 8L, 74L, 36L), (List)Nil$.MODULE$)), abortedTransactions);
    }

    @Test
    public void testLogEndLessThanStartAfterReopen() {
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(LogTestUtils$.MODULE$.createLogConfig$default$1(), LogTestUtils$.MODULE$.createLogConfig$default$2(), LogTestUtils$.MODULE$.createLogConfig$default$3(), LogTestUtils$.MODULE$.createLogConfig$default$4(), LogTestUtils$.MODULE$.createLogConfig$default$5(), LogTestUtils$.MODULE$.createLogConfig$default$6(), LogTestUtils$.MODULE$.createLogConfig$default$7(), LogTestUtils$.MODULE$.createLogConfig$default$8(), LogTestUtils$.MODULE$.createLogConfig$default$9(), LogTestUtils$.MODULE$.createLogConfig$default$10());
        ObjectRef log = ObjectRef.create((Object)this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).foreach((Function1 & Serializable & scala.Serializable)i -> LogLoaderTest.$anonfun$testLogEndLessThanStartAfterReopen$1(this, log, BoxesRunTime.unboxToInt((Object)i)));
        Assertions.assertEquals((int)6, (int)((UnifiedLog)log.elem).logSegments().size());
        int startOffset = 4;
        ((UnifiedLog)log.elem).updateHighWatermark(((UnifiedLog)log.elem).logEndOffset());
        ((UnifiedLog)log.elem).maybeIncrementLogStartOffset((long)startOffset, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        Assertions.assertTrue((((UnifiedLog)log.elem).logEndOffset() > ((UnifiedLog)log.elem).logStartOffset() ? 1 : 0) != 0);
        LogSegment segmentToForceTruncation = (LogSegment)((TraversableLike)((UnifiedLog)log.elem).logSegments().take(2)).last();
        BufferedWriter bw = new BufferedWriter(new FileWriter(segmentToForceTruncation.log().file()));
        bw.write("corruptRecord");
        bw.close();
        ((UnifiedLog)log.elem).close();
        File x$7 = this.logDir();
        long x$9 = startOffset;
        boolean x$10 = false;
        BrokerTopicStats x$11 = this.createLog$default$3();
        long x$12 = this.createLog$default$5();
        Scheduler x$13 = this.createLog$default$6();
        Time x$14 = this.createLog$default$7();
        int x$15 = this.createLog$default$8();
        int x$16 = this.createLog$default$9();
        int x$17 = this.createLog$default$10();
        log.elem = this.createLog(x$7, logConfig, x$11, x$9, x$12, x$13, x$14, x$15, x$16, x$17, x$10);
        this.mockTime().sleep(Predef$.MODULE$.Long2long(logConfig.fileDeleteDelayMs()));
        Assertions.assertEquals((int)1, (int)((UnifiedLog)log.elem).numberOfSegments());
        Assertions.assertEquals((long)startOffset, (long)((UnifiedLog)log.elem).logStartOffset());
        Assertions.assertEquals((long)startOffset, (long)((UnifiedLog)log.elem).logEndOffset());
        LogSegment onlySegment = (LogSegment)((UnifiedLog)log.elem).logSegments().head();
        Assertions.assertEquals((long)startOffset, (long)onlySegment.baseOffset());
        Assertions.assertTrue((boolean)onlySegment.log().file().exists());
        Assertions.assertTrue((boolean)onlySegment.lazyOffsetIndex().file().exists());
        Assertions.assertTrue((boolean)onlySegment.lazyTimeIndex().file().exists());
    }

    @Test
    public void testCorruptedLogRecoveryDoesNotDeleteProducerStateSnapshotsPostRecovery() {
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(LogTestUtils$.MODULE$.createLogConfig$default$1(), LogTestUtils$.MODULE$.createLogConfig$default$2(), LogTestUtils$.MODULE$.createLogConfig$default$3(), LogTestUtils$.MODULE$.createLogConfig$default$4(), LogTestUtils$.MODULE$.createLogConfig$default$5(), LogTestUtils$.MODULE$.createLogConfig$default$6(), LogTestUtils$.MODULE$.createLogConfig$default$7(), LogTestUtils$.MODULE$.createLogConfig$default$8(), LogTestUtils$.MODULE$.createLogConfig$default$9(), LogTestUtils$.MODULE$.createLogConfig$default$10());
        ObjectRef log = ObjectRef.create((Object)this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 9).foreach((Function1 & Serializable & scala.Serializable)i -> LogLoaderTest.$anonfun$testCorruptedLogRecoveryDoesNotDeleteProducerStateSnapshotsPostRecovery$1(this, log, BoxesRunTime.unboxToInt((Object)i)));
        Assertions.assertEquals((int)10, (int)((UnifiedLog)log.elem).logSegments().size());
        Assertions.assertEquals((long)0L, (long)((UnifiedLog)log.elem).logStartOffset());
        Assertions.assertEquals((long)9L, (long)((UnifiedLog)log.elem).activeSegment().baseOffset());
        Assertions.assertEquals((long)9L, (long)((UnifiedLog)log.elem).logEndOffset());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)offset -> {
            Option snapshotFileBeforeDeletion = ((UnifiedLog)log$14.elem).producerStateManager().snapshotFileForOffset((long)offset);
            Assertions.assertTrue((boolean)snapshotFileBeforeDeletion.isDefined());
            Assertions.assertTrue((boolean)((SnapshotFile)snapshotFileBeforeDeletion.get()).file().exists());
        });
        int newLogStartOffset = 4;
        ((UnifiedLog)log.elem).updateHighWatermark(((UnifiedLog)log.elem).logEndOffset());
        ((UnifiedLog)log.elem).maybeIncrementLogStartOffset((long)newLogStartOffset, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        Assertions.assertEquals((long)4L, (long)((UnifiedLog)log.elem).logStartOffset());
        Assertions.assertEquals((long)9L, (long)((UnifiedLog)log.elem).logEndOffset());
        LogSegment segmentToForceTruncation = (LogSegment)((TraversableLike)((UnifiedLog)log.elem).logSegments().take(2)).last();
        Assertions.assertEquals((long)1L, (long)segmentToForceTruncation.baseOffset());
        BufferedWriter bw = new BufferedWriter(new FileWriter(segmentToForceTruncation.log().file()));
        bw.write("corruptRecord");
        bw.close();
        ((UnifiedLog)log.elem).close();
        File x$7 = this.logDir();
        long x$9 = newLogStartOffset;
        boolean x$10 = false;
        BrokerTopicStats x$11 = this.createLog$default$3();
        long x$12 = this.createLog$default$5();
        Scheduler x$13 = this.createLog$default$6();
        Time x$14 = this.createLog$default$7();
        int x$15 = this.createLog$default$8();
        int x$16 = this.createLog$default$9();
        int x$17 = this.createLog$default$10();
        log.elem = this.createLog(x$7, logConfig, x$11, x$9, x$12, x$13, x$14, x$15, x$16, x$17, x$10);
        Assertions.assertEquals((int)1, (int)((UnifiedLog)log.elem).logSegments().size());
        Assertions.assertEquals((long)4L, (long)((UnifiedLog)log.elem).logStartOffset());
        Assertions.assertEquals((long)4L, (long)((UnifiedLog)log.elem).activeSegment().baseOffset());
        Assertions.assertEquals((long)4L, (long)((UnifiedLog)log.elem).logEndOffset());
        IndexedSeq offsetsWithSnapshotFiles = (IndexedSeq)((TraversableLike)((TraversableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 5).map((Function1 & Serializable & scala.Serializable)offset -> SnapshotFile$.MODULE$.apply(UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), (long)BoxesRunTime.unboxToInt((Object)offset))), IndexedSeq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)snapshotFile -> BoxesRunTime.boxToBoolean((boolean)LogLoaderTest.$anonfun$testCorruptedLogRecoveryDoesNotDeleteProducerStateSnapshotsPostRecovery$4(snapshotFile)))).map((Function1 & Serializable & scala.Serializable)x$30 -> BoxesRunTime.boxToLong((long)x$30.offset()), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq inMemorySnapshotFiles = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 5).flatMap((Function1 & Serializable & scala.Serializable)offset -> Option$.MODULE$.option2Iterable(((UnifiedLog)log.elem).producerStateManager().snapshotFileForOffset((long)BoxesRunTime.unboxToInt((Object)offset))), IndexedSeq$.MODULE$.canBuildFrom());
        Assertions.assertTrue((boolean)offsetsWithSnapshotFiles.isEmpty(), (String)new StringBuilder(76).append("Found offsets with producer state snapshot files: ").append(offsetsWithSnapshotFiles).append(" while none were expected.").toString());
        Assertions.assertTrue((boolean)inMemorySnapshotFiles.isEmpty(), (String)new StringBuilder(73).append("Found in-memory producer state snapshot files: ").append(inMemorySnapshotFiles).append(" while none were expected.").toString());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).foreach((Function1 & Serializable & scala.Serializable)i -> LogLoaderTest.$anonfun$testCorruptedLogRecoveryDoesNotDeleteProducerStateSnapshotsPostRecovery$7(this, log, BoxesRunTime.unboxToInt((Object)i)));
        Assertions.assertEquals((long)9L, (long)((UnifiedLog)log.elem).activeSegment().baseOffset());
        Assertions.assertEquals((long)9L, (long)((UnifiedLog)log.elem).logEndOffset());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(5), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)offset -> {
            Option snapshotFileBeforeDeletion = ((UnifiedLog)log$14.elem).producerStateManager().snapshotFileForOffset((long)offset);
            Assertions.assertTrue((boolean)snapshotFileBeforeDeletion.isDefined());
            Assertions.assertTrue((boolean)((SnapshotFile)snapshotFileBeforeDeletion.get()).file().exists());
        });
        this.mockTime().sleep(Predef$.MODULE$.Long2long(logConfig.fileDeleteDelayMs()));
        Assertions.assertEquals((long)newLogStartOffset, (long)((UnifiedLog)log.elem).logStartOffset());
        Assertions.assertEquals((long)9L, (long)((UnifiedLog)log.elem).logEndOffset());
        ListBuffer offsetsWithMissingSnapshotFiles = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(5), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)offset -> {
            Option snapshotFile = ((UnifiedLog)log$14.elem).producerStateManager().snapshotFileForOffset((long)offset);
            if (snapshotFile.isEmpty() || !((SnapshotFile)snapshotFile.get()).file().exists()) {
                offsetsWithMissingSnapshotFiles.append((Seq)Predef$.MODULE$.wrapLongArray(new long[]{offset}));
            }
        });
        Assertions.assertTrue((boolean)offsetsWithMissingSnapshotFiles.isEmpty(), (String)new StringBuilder(58).append("Found offsets with missing producer state snapshot files: ").append(offsetsWithMissingSnapshotFiles).toString());
        Assertions.assertFalse((boolean)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().list())).exists((Function1 & Serializable & scala.Serializable)x$31 -> BoxesRunTime.boxToBoolean((boolean)x$31.endsWith(UnifiedLog$.MODULE$.DeletedFileSuffix()))), (String)"Expected no files to be present with the deleted file suffix");
    }

    @Test
    public void testRecoverWithEmptyActiveSegment() {
        int numMessages = 100;
        int messageSize = 100;
        int segmentSize = 7 * messageSize;
        int indexInterval = 3 * messageSize;
        int x$3 = 4096;
        long x$4 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$7 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$8 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$9 = LogTestUtils$.MODULE$.createLogConfig$default$7();
        long x$10 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$4, segmentSize, x$5, x$6, x$7, x$8, x$9, indexInterval, x$3, x$10);
        ObjectRef log = ObjectRef.create((Object)this.createLog(this.logDir(), logConfig, this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9(), this.createLog$default$10(), this.createLog$default$11()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach((Function1 & Serializable & scala.Serializable)i -> LogLoaderTest.$anonfun$testRecoverWithEmptyActiveSegment$1(this, log, messageSize, BoxesRunTime.unboxToInt((Object)i)));
        Assertions.assertEquals((long)numMessages, (long)((UnifiedLog)log.elem).logEndOffset(), (String)new StringOps(Predef$.MODULE$.augmentString("After appending %d messages to an empty log, the log end offset should be %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numMessages), BoxesRunTime.boxToInteger((int)numMessages)})));
        UnifiedLog qual$2 = (UnifiedLog)log.elem;
        Option x$21 = qual$2.roll$default$1();
        qual$2.roll(x$21);
        ((UnifiedLog)log.elem).flush(false);
        Assertions.assertThrows(NoSuchFileException.class, () -> ((UnifiedLog)log$15.elem).activeSegment().sanityCheck(true));
        long lastOffset = ((UnifiedLog)log.elem).logEndOffset();
        ((UnifiedLog)log.elem).closeHandlers();
        File x$22 = this.logDir();
        boolean x$25 = false;
        BrokerTopicStats x$26 = this.createLog$default$3();
        long x$27 = this.createLog$default$4();
        Scheduler x$28 = this.createLog$default$6();
        Time x$29 = this.createLog$default$7();
        int x$30 = this.createLog$default$8();
        int x$31 = this.createLog$default$9();
        int x$32 = this.createLog$default$10();
        log.elem = this.createLog(x$22, logConfig, x$26, x$27, lastOffset, x$28, x$29, x$30, x$31, x$32, x$25);
        Assertions.assertEquals((long)lastOffset, (long)((UnifiedLog)log.elem).recoveryPoint(), (String)"Unexpected recovery point");
        Assertions.assertEquals((long)numMessages, (long)((UnifiedLog)log.elem).logEndOffset(), (String)new StringBuilder(55).append("Should have ").append(numMessages).append(" messages when log is reopened w/o recovery").toString());
        Assertions.assertEquals((int)0, (int)((UnifiedLog)log.elem).activeSegment().timeIndex().entries(), (String)"Should have same number of time index entries as before.");
        ((UnifiedLog)log.elem).activeSegment().sanityCheck(true);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach((Function1 & Serializable & scala.Serializable)i -> LogLoaderTest.$anonfun$testRecoverWithEmptyActiveSegment$3(this, log, messageSize, BoxesRunTime.unboxToInt((Object)i)));
        UnifiedLog qual$4 = (UnifiedLog)log.elem;
        Option x$43 = qual$4.roll$default$1();
        qual$4.roll(x$43);
        Assertions.assertThrows(NoSuchFileException.class, () -> ((UnifiedLog)log$15.elem).activeSegment().sanityCheck(true));
        ((UnifiedLog)log.elem).flush(true);
        ((UnifiedLog)log.elem).activeSegment().sanityCheck(true);
        lastOffset = ((UnifiedLog)log.elem).logEndOffset();
        File x$44 = this.logDir();
        boolean x$47 = false;
        BrokerTopicStats x$48 = this.createLog$default$3();
        long x$49 = this.createLog$default$4();
        Scheduler x$50 = this.createLog$default$6();
        Time x$51 = this.createLog$default$7();
        int x$52 = this.createLog$default$8();
        int x$53 = this.createLog$default$9();
        int x$54 = this.createLog$default$10();
        log.elem = this.createLog(x$44, logConfig, x$48, x$49, lastOffset, x$50, x$51, x$52, x$53, x$54, x$47);
        Assertions.assertEquals((long)lastOffset, (long)((UnifiedLog)log.elem).recoveryPoint(), (String)"Unexpected recovery point");
        Assertions.assertEquals((long)(2 * numMessages), (long)((UnifiedLog)log.elem).logEndOffset(), (String)new StringBuilder(55).append("Should have ").append(numMessages).append(" messages when log is reopened w/o recovery").toString());
        Assertions.assertEquals((int)0, (int)((UnifiedLog)log.elem).activeSegment().timeIndex().entries(), (String)"Should have same number of time index entries as before.");
        ((UnifiedLog)log.elem).activeSegment().sanityCheck(true);
        ((UnifiedLog)log.elem).close();
    }

    private final void ErrorTypes$lzycompute$1() {
        synchronized (this) {
            if (this.ErrorTypes$module == null) {
                this.ErrorTypes$module = new LogLoaderTest$ErrorTypes$(this);
            }
            return;
        }
    }

    private final /* synthetic */ LogLoaderTest$SimulateError$2$ SimulateError$lzycompute$1(LazyRef SimulateError$module$1) {
        synchronized (SimulateError$module$1) {
            LogLoaderTest$SimulateError$2$ logLoaderTest$SimulateError$2$ = SimulateError$module$1.initialized() ? (LogLoaderTest$SimulateError$2$)((Object)SimulateError$module$1.value()) : (LogLoaderTest$SimulateError$2$)((Object)SimulateError$module$1.initialize((Object)new LogLoaderTest$SimulateError$2$(this)));
            return logLoaderTest$SimulateError$2$;
        }
    }

    private final LogLoaderTest$SimulateError$2$ SimulateError$3(LazyRef SimulateError$module$1) {
        if (SimulateError$module$1.initialized()) {
            return (LogLoaderTest$SimulateError$2$)((Object)SimulateError$module$1.value());
        }
        return this.SimulateError$lzycompute$1(SimulateError$module$1);
    }

    private final LogManager interceptedLogManager$1(LogConfig logConfig, Seq logDirs, LogDirFailureChannel logDirFailureChannel, int maxTransactionTimeoutMs$1, int producerIdExpirationCheckIntervalMs$1, MockTime time$1, SimulateError.1 simulateError$1, BooleanRef cleanShutdownInterceptedValue$1) {
        return new LogManager(this, logDirs, logConfig, maxTransactionTimeoutMs$1, producerIdExpirationCheckIntervalMs$1, time$1, logDirFailureChannel, simulateError$1, cleanShutdownInterceptedValue$1){
            private final /* synthetic */ LogLoaderTest $outer;
            private final Kafka_log_LogLoaderTest$SimulateError$1 simulateError$1;
            private final BooleanRef cleanShutdownInterceptedValue$1;
            private final MockTime time$1;
            private final LogConfig logConfig$1;

            public UnifiedLog loadLog(File logDir, boolean hadCleanShutdown, Map<TopicPartition, Object> recoveryPoints, Map<TopicPartition, Object> logStartOffsets, LogConfig defaultConfig, Map<String, LogConfig> topicConfigs, ConcurrentMap<String, Object> numRemainingSegments) {
                if (this.simulateError$1.hasError()) {
                    Enumeration.Value value = this.simulateError$1.errorType();
                    Enumeration.Value value2 = this.$outer.ErrorTypes().KafkaStorageExceptionWithIOExceptionCause();
                    if (!(value2 != null ? !value2.equals(value) : value != null)) {
                        throw new KafkaStorageException((Throwable)new IOException("Simulated Kafka storage error with IOException cause"));
                    }
                    Enumeration.Value value3 = this.$outer.ErrorTypes().KafkaStorageExceptionWithoutIOExceptionCause();
                    if (!(value3 != null ? !value3.equals(value) : value != null)) {
                        throw new KafkaStorageException("Simulated Kafka storage error without IOException cause");
                    }
                    Enumeration.Value value4 = this.$outer.ErrorTypes().IOException();
                    if (!(value4 != null ? !value4.equals(value) : value != null)) {
                        throw new IOException("Simulated IO error");
                    }
                    throw new RuntimeException("Simulated Runtime error");
                }
                this.cleanShutdownInterceptedValue$1.elem = hadCleanShutdown;
                TopicPartition topicPartition = UnifiedLog$.MODULE$.parseTopicPartitionName(logDir);
                LogConfig config = (LogConfig)topicConfigs.getOrElse((Object)topicPartition.topic(), (Function0 & Serializable & scala.Serializable)() -> defaultConfig);
                long logRecoveryPoint = BoxesRunTime.unboxToLong((Object)recoveryPoints.getOrElse((Object)topicPartition, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
                long logStartOffset = BoxesRunTime.unboxToLong((Object)logStartOffsets.getOrElse((Object)topicPartition, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
                LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(1);
                LogSegments segments = new LogSegments(topicPartition);
                Option leaderEpochCache = UnifiedLog$.MODULE$.maybeCreateLeaderEpochCache(logDir, topicPartition, logDirFailureChannel, config.recordVersion(), "");
                ProducerStateManager producerStateManager = new ProducerStateManager(topicPartition, logDir, this.maxTransactionTimeoutMs(), this.producerStateManagerConfig(), (Time)this.time$1);
                LoadedLogOffsets offsets = new LogLoader(logDir, topicPartition, config, (Scheduler)this.time$1.scheduler(), (Time)this.time$1, logDirFailureChannel, hadCleanShutdown, segments, logStartOffset, logRecoveryPoint, leaderEpochCache, producerStateManager, LogLoader$.MODULE$.$lessinit$greater$default$13()).load();
                LocalLog localLog = new LocalLog(logDir, this.logConfig$1, segments, offsets.recoveryPoint(), offsets.nextOffsetMetadata(), (Scheduler)this.$outer.mockTime().scheduler(), (Time)this.$outer.mockTime(), topicPartition, logDirFailureChannel);
                return new UnifiedLog(offsets.logStartOffset(), localLog, this.$outer.brokerTopicStats(), this.producerIdExpirationCheckIntervalMs(), leaderEpochCache, producerStateManager, (Option)None$.MODULE$, true);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.simulateError$1 = simulateError$1;
                this.cleanShutdownInterceptedValue$1 = cleanShutdownInterceptedValue$1;
                this.time$1 = time$1;
                this.logConfig$1 = logConfig$1;
                boolean x$1 = false;
                int x$2 = CleanerConfig$.MODULE$.apply$default$1();
                long x$3 = CleanerConfig$.MODULE$.apply$default$2();
                double x$4 = CleanerConfig$.MODULE$.apply$default$3();
                int x$5 = CleanerConfig$.MODULE$.apply$default$4();
                int x$6 = CleanerConfig$.MODULE$.apply$default$5();
                double x$7 = CleanerConfig$.MODULE$.apply$default$6();
                long x$8 = CleanerConfig$.MODULE$.apply$default$7();
                String x$9 = CleanerConfig$.MODULE$.apply$default$9();
                super((Seq)logDirs$1.map((Function1)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final File apply(File x$1) {
                        return x$1.getAbsoluteFile();
                    }
                }, Seq$.MODULE$.canBuildFrom()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class))), (ConfigRepository)new MockConfigRepository(), logConfig$1, new CleanerConfig(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$1, x$9), 4, 1000L, 10000L, 10000L, 1000L, maxTransactionTimeoutMs$1, $outer.producerStateManagerConfig(), producerIdExpirationCheckIntervalMs$1, $outer.config().interBrokerProtocolVersion(), (Scheduler)time$1.scheduler(), new BrokerTopicStats(), logDirFailureChannel$1, (Time)time$1, $outer.config().usesTopicId());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$loadLog$1(kafka.log.LogConfig ), $anonfun$loadLog$2(), $anonfun$loadLog$3()}, serializedLambda);
            }
        };
    }

    private final Tuple2 initializeLogManagerForSimulatingErrorTest$1(LogDirFailureChannel logDirFailureChannel, LogConfig logConfig$2, Seq logDirs$2, ObjectRef log$1, TopicPartition topicPartition$1, File logDir$1, int maxTransactionTimeoutMs$1, int producerIdExpirationCheckIntervalMs$1, MockTime time$1, SimulateError.1 simulateError$1, BooleanRef cleanShutdownInterceptedValue$1) {
        LogManager logManager = this.interceptedLogManager$1(logConfig$2, logDirs$2, logDirFailureChannel, maxTransactionTimeoutMs$1, producerIdExpirationCheckIntervalMs$1, time$1, simulateError$1, cleanShutdownInterceptedValue$1);
        boolean x$2 = true;
        None$ x$3 = None$.MODULE$;
        boolean x$4 = logManager.getOrCreateLog$default$3();
        log$1.elem = logManager.getOrCreateLog(topicPartition$1, x$2, x$4, (Option)x$3);
        Assertions.assertFalse((boolean)logDirFailureChannel.hasOfflineLogDir(logDir$1.getAbsolutePath()), (String)"log dir should not be offline before load logs");
        Executable runLoadLogs = () -> {
            LogConfig defaultConfig = logManager.currentDefaultConfig();
            logManager.loadLogs(defaultConfig, logManager.fetchTopicConfigOverrides(defaultConfig, (Set)Predef$.MODULE$.Set().empty()));
        };
        return new Tuple2((Object)logManager, (Object)runLoadLogs);
    }

    private static final LogDirFailureChannel initializeLogManagerForSimulatingErrorTest$default$1$1(Seq logDirs$2) {
        return new LogDirFailureChannel(logDirs$2.size());
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testProducerSnapshotsRecoveryAfterUncleanShutdown$1(LogLoaderTest $this, ObjectRef log$2, int i) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), Integer.toString(i).getBytes());
        UnifiedLog qual$1 = (UnifiedLog)log$2.elem;
        MemoryRecords x$1 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
        int x$2 = 0;
        AppendOrigin x$3 = qual$1.appendAsLeader$default$3();
        MetadataVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        return qual$1.appendAsLeader(x$1, x$2, x$3, x$4, x$5);
    }

    private final UnifiedLog createLogWithInterceptedReads$1(long recoveryPoint, scala.collection.mutable.Set segmentsWithReads$1, scala.collection.mutable.Set recoveredSegments$1, LogConfig logConfig$3) {
        int maxTransactionTimeoutMs = 300000;
        int producerIdExpirationCheckIntervalMs = Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        TopicPartition topicPartition = UnifiedLog$.MODULE$.parseTopicPartitionName(this.logDir());
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        LogSegments interceptedLogSegments = new LogSegments(this, topicPartition, segmentsWithReads$1, recoveredSegments$1){
            private final /* synthetic */ LogLoaderTest $outer;
            public final scala.collection.mutable.Set segmentsWithReads$1;
            public final scala.collection.mutable.Set recoveredSegments$1;

            public LogSegment add(LogSegment segment) {
                LogSegment wrapper = new LogSegment(this, segment){
                    private final /* synthetic */ $anon$2 $outer;

                    public FetchDataInfo read(long startOffset, int maxSize, long maxPosition, boolean minOneMessage) {
                        this.$outer.segmentsWithReads$1.$plus$eq((Object)((Object)this));
                        return super.read(startOffset, maxSize, maxPosition, minOneMessage);
                    }

                    public int recover(ProducerStateManager producerStateManager, Option<LeaderEpochFileCache> leaderEpochCache) {
                        this.$outer.recoveredSegments$1.$plus$eq((Object)((Object)this));
                        return super.recover(producerStateManager, leaderEpochCache);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        super(segment$1.log(), segment$1.lazyOffsetIndex(), segment$1.lazyTimeIndex(), segment$1.txnIndex(), segment$1.baseOffset(), segment$1.indexIntervalBytes(), segment$1.rollJitterMs(), (Time)$outer.kafka$log$LogLoaderTest$$anon$$$outer().mockTime());
                    }
                };
                return super.add(wrapper);
            }

            public /* synthetic */ LogLoaderTest kafka$log$LogLoaderTest$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.segmentsWithReads$1 = segmentsWithReads$1;
                this.recoveredSegments$1 = recoveredSegments$1;
                super(topicPartition$2);
            }
        };
        Option leaderEpochCache = UnifiedLog$.MODULE$.maybeCreateLeaderEpochCache(this.logDir(), topicPartition, logDirFailureChannel, logConfig$3.recordVersion(), "");
        ProducerStateManager producerStateManager = new ProducerStateManager(topicPartition, this.logDir(), maxTransactionTimeoutMs, this.producerStateManagerConfig(), (Time)this.mockTime());
        LoadedLogOffsets offsets = new LogLoader(this.logDir(), topicPartition, logConfig$3, (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime(), logDirFailureChannel, false, interceptedLogSegments, 0L, recoveryPoint, leaderEpochCache, producerStateManager, LogLoader$.MODULE$.$lessinit$greater$default$13()).load();
        LocalLog localLog = new LocalLog(this.logDir(), logConfig$3, interceptedLogSegments, offsets.recoveryPoint(), offsets.nextOffsetMetadata(), (Scheduler)this.mockTime().scheduler(), (Time)this.mockTime(), topicPartition, logDirFailureChannel);
        return new UnifiedLog(offsets.logStartOffset(), localLog, this.brokerTopicStats(), producerIdExpirationCheckIntervalMs, leaderEpochCache, producerStateManager, (Option)None$.MODULE$, true);
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testLogRecoversToCorrectOffset$1(LogLoaderTest $this, ObjectRef log$3, int messageSize$1, int i) {
        UnifiedLog qual$1 = (UnifiedLog)log$3.elem;
        byte[] x$11 = TestUtils$.MODULE$.randomBytes(messageSize$1);
        long x$12 = $this.mockTime().milliseconds() + (long)(i * 10);
        byte[] x$13 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$14 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$15 = TestUtils$.MODULE$.singletonRecords$default$5();
        MemoryRecords x$16 = TestUtils$.MODULE$.singletonRecords(x$11, x$13, x$14, x$12, x$15);
        int x$17 = 0;
        AppendOrigin x$18 = qual$1.appendAsLeader$default$3();
        MetadataVersion x$19 = qual$1.appendAsLeader$default$4();
        RequestLocal x$20 = qual$1.appendAsLeader$default$5();
        return qual$1.appendAsLeader(x$16, x$17, x$18, x$19, x$20);
    }

    private static final void verifyRecoveredLog$1(UnifiedLog log, long expectedRecoveryPoint, int numMessages$1, long lastIndexOffset$1, int numIndexEntries$1, long lastTimeIndexTimestamp$1, long lastTimeIndexOffset$1, int numTimeIndexEntries$1) {
        Assertions.assertEquals((long)expectedRecoveryPoint, (long)log.recoveryPoint(), (String)"Unexpected recovery point");
        Assertions.assertEquals((long)numMessages$1, (long)log.logEndOffset(), (String)new StringBuilder(55).append("Should have ").append(numMessages$1).append(" messages when log is reopened w/o recovery").toString());
        Assertions.assertEquals((long)lastIndexOffset$1, (long)log.activeSegment().offsetIndex().lastOffset(), (String)"Should have same last index offset as before.");
        Assertions.assertEquals((int)numIndexEntries$1, (int)log.activeSegment().offsetIndex().entries(), (String)"Should have same number of index entries as before.");
        Assertions.assertEquals((long)lastTimeIndexTimestamp$1, (long)log.activeSegment().timeIndex().lastEntry().timestamp(), (String)"Should have same last time index timestamp");
        Assertions.assertEquals((long)lastTimeIndexOffset$1, (long)log.activeSegment().timeIndex().lastEntry().offset(), (String)"Should have same last time index offset");
        Assertions.assertEquals((int)numTimeIndexEntries$1, (int)log.activeSegment().timeIndex().entries(), (String)"Should have same number of time index entries as before.");
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testIndexRebuild$1(LogLoaderTest $this, ObjectRef log$4, int i) {
        UnifiedLog qual$1 = (UnifiedLog)log$4.elem;
        byte[] x$11 = TestUtils$.MODULE$.randomBytes(10);
        long x$12 = $this.mockTime().milliseconds() + (long)(i * 10);
        byte[] x$13 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$14 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$15 = TestUtils$.MODULE$.singletonRecords$default$5();
        MemoryRecords x$16 = TestUtils$.MODULE$.singletonRecords(x$11, x$13, x$14, x$12, x$15);
        int x$17 = 0;
        AppendOrigin x$18 = qual$1.appendAsLeader$default$3();
        MetadataVersion x$19 = qual$1.appendAsLeader$default$4();
        RequestLocal x$20 = qual$1.appendAsLeader$default$5();
        return qual$1.appendAsLeader(x$16, x$17, x$18, x$19, x$20);
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testRebuildTimeIndexForOldMessages$1(LogLoaderTest $this, ObjectRef log$5, int i) {
        UnifiedLog qual$1 = (UnifiedLog)log$5.elem;
        byte[] x$1 = TestUtils$.MODULE$.randomBytes(10);
        long x$2 = $this.mockTime().milliseconds() + (long)(i * 10);
        byte x$3 = 1;
        byte[] x$4 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$5 = TestUtils$.MODULE$.singletonRecords$default$3();
        MemoryRecords x$6 = TestUtils$.MODULE$.singletonRecords(x$1, x$4, x$5, x$2, x$3);
        int x$7 = 0;
        AppendOrigin x$8 = qual$1.appendAsLeader$default$3();
        MetadataVersion x$9 = qual$1.appendAsLeader$default$4();
        RequestLocal x$10 = qual$1.appendAsLeader$default$5();
        return qual$1.appendAsLeader(x$6, x$7, x$8, x$9, x$10);
    }

    public static final /* synthetic */ void $anonfun$testRebuildTimeIndexForOldMessages$3(File file) {
        Files.delete(file.toPath());
    }

    public static final /* synthetic */ void $anonfun$testRebuildTimeIndexForOldMessages$4(LogSegment segment) {
        Assertions.assertEquals((int)0, (int)segment.timeIndex().entries(), (String)"The time index should be empty");
        Assertions.assertEquals((long)0L, (long)segment.lazyTimeIndex().file().length(), (String)"The time index file size should be 0");
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testCorruptIndexRebuild$1(LogLoaderTest $this, ObjectRef log$6, int i) {
        UnifiedLog qual$1 = (UnifiedLog)log$6.elem;
        byte[] x$11 = TestUtils$.MODULE$.randomBytes(10);
        long x$12 = $this.mockTime().milliseconds() + (long)(i * 10);
        byte[] x$13 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$14 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$15 = TestUtils$.MODULE$.singletonRecords$default$5();
        MemoryRecords x$16 = TestUtils$.MODULE$.singletonRecords(x$11, x$13, x$14, x$12, x$15);
        int x$17 = 0;
        AppendOrigin x$18 = qual$1.appendAsLeader$default$3();
        MetadataVersion x$19 = qual$1.appendAsLeader$default$4();
        RequestLocal x$20 = qual$1.appendAsLeader$default$5();
        return qual$1.appendAsLeader(x$16, x$17, x$18, x$19, x$20);
    }

    public static final /* synthetic */ void $anonfun$testCorruptIndexRebuild$4(File file) {
        BufferedWriter bw = new BufferedWriter(new FileWriter(file));
        bw.write("  ");
        bw.close();
    }

    public static final /* synthetic */ void $anonfun$testCorruptIndexRebuild$5(File file) {
        BufferedWriter bw = new BufferedWriter(new FileWriter(file));
        bw.write("  ");
        bw.close();
    }

    private final MemoryRecords createRecords$1() {
        byte[] x$1 = "test".getBytes();
        long x$2 = this.mockTime().milliseconds();
        byte[] x$3 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$4 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        return TestUtils$.MODULE$.singletonRecords(x$1, x$3, x$4, x$2, x$5);
    }

    private final MemoryRecords createRecords$2() {
        byte[] x$1 = "test".getBytes();
        long x$2 = this.mockTime().milliseconds();
        byte[] x$3 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$4 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        return TestUtils$.MODULE$.singletonRecords(x$1, x$3, x$4, x$2, x$5);
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testReopenThenTruncate$1(LogLoaderTest $this, ObjectRef log$8, int _) {
        UnifiedLog qual$1 = (UnifiedLog)log$8.elem;
        MemoryRecords x$11 = $this.createRecords$2();
        int x$12 = 0;
        AppendOrigin x$13 = qual$1.appendAsLeader$default$3();
        MetadataVersion x$14 = qual$1.appendAsLeader$default$4();
        RequestLocal x$15 = qual$1.appendAsLeader$default$5();
        return qual$1.appendAsLeader(x$11, x$12, x$13, x$14, x$15);
    }

    private final MemoryRecords createRecords$3() {
        byte[] x$1 = "test".getBytes();
        long x$2 = this.mockTime().milliseconds() - 1000L;
        byte[] x$3 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$4 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        return TestUtils$.MODULE$.singletonRecords(x$1, x$3, x$4, x$2, x$5);
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testOpenDeletesObsoleteFiles$1(LogLoaderTest $this, ObjectRef log$9, int _) {
        UnifiedLog qual$1 = (UnifiedLog)log$9.elem;
        MemoryRecords x$11 = $this.createRecords$3();
        int x$12 = 0;
        AppendOrigin x$13 = qual$1.appendAsLeader$default$3();
        MetadataVersion x$14 = qual$1.appendAsLeader$default$4();
        RequestLocal x$15 = qual$1.appendAsLeader$default$5();
        return qual$1.appendAsLeader(x$11, x$12, x$13, x$14, x$15);
    }

    private final MemoryRecords createRecords$4() {
        byte[] x$1 = "test".getBytes();
        long x$2 = this.mockTime().milliseconds();
        byte[] x$3 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$4 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        return TestUtils$.MODULE$.singletonRecords(x$1, x$3, x$4, x$2, x$5);
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testCorruptLog$2(LogLoaderTest $this, ObjectRef log$10, int _) {
        UnifiedLog qual$1 = (UnifiedLog)log$10.elem;
        MemoryRecords x$11 = $this.createRecords$4();
        int x$12 = 0;
        AppendOrigin x$13 = qual$1.appendAsLeader$default$3();
        MetadataVersion x$14 = qual$1.appendAsLeader$default$4();
        RequestLocal x$15 = qual$1.appendAsLeader$default$5();
        return qual$1.appendAsLeader(x$11, x$12, x$13, x$14, x$15);
    }

    public static final /* synthetic */ boolean $anonfun$testOverCompactedLogRecovery$1(File file) {
        return file.getName().contains(".index");
    }

    public static final /* synthetic */ void $anonfun$testOverCompactedLogRecovery$2(File file) {
        OffsetIndex offsetIndex = new OffsetIndex(file, new StringOps(Predef$.MODULE$.augmentString(file.getName().replace(".index", ""))).toLong(), OffsetIndex$.MODULE$.$lessinit$greater$default$3(), OffsetIndex$.MODULE$.$lessinit$greater$default$4());
        Assertions.assertTrue((offsetIndex.lastOffset() >= 0L ? 1 : 0) != 0);
        offsetIndex.close();
    }

    public static final /* synthetic */ boolean $anonfun$testOverCompactedLogRecoveryMultiRecord$1(File file) {
        return file.getName().contains(".index");
    }

    public static final /* synthetic */ void $anonfun$testOverCompactedLogRecoveryMultiRecord$2(File file) {
        OffsetIndex offsetIndex = new OffsetIndex(file, new StringOps(Predef$.MODULE$.augmentString(file.getName().replace(".index", ""))).toLong(), OffsetIndex$.MODULE$.$lessinit$greater$default$3(), OffsetIndex$.MODULE$.$lessinit$greater$default$4());
        Assertions.assertTrue((offsetIndex.lastOffset() >= 0L ? 1 : 0) != 0);
        offsetIndex.close();
    }

    public static final /* synthetic */ boolean $anonfun$testOverCompactedLogRecoveryMultiRecordV1$1(File file) {
        return file.getName().contains(".index");
    }

    public static final /* synthetic */ void $anonfun$testOverCompactedLogRecoveryMultiRecordV1$2(File file) {
        OffsetIndex offsetIndex = new OffsetIndex(file, new StringOps(Predef$.MODULE$.augmentString(file.getName().replace(".index", ""))).toLong(), OffsetIndex$.MODULE$.$lessinit$greater$default$3(), OffsetIndex$.MODULE$.$lessinit$greater$default$4());
        Assertions.assertTrue((offsetIndex.lastOffset() >= 0L ? 1 : 0) != 0);
        offsetIndex.close();
    }

    public static final /* synthetic */ IllegalArgumentException $anonfun$testRecoveryOfSegmentWithOffsetOverflow$1(UnifiedLog log$11, LogSegment segment) {
        return (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> log$11.splitOverflowedSegment(segment));
    }

    public static final /* synthetic */ int $anonfun$testRecoveryAfterCrashDuringSplitPhase1$1(LogSegment segment) {
        segment.changeFileSuffixes("", UnifiedLog$.MODULE$.CleanedFileSuffix());
        return segment.truncateTo(0L);
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAfterCrashDuringSplitPhase1$2(File file) {
        return file.getName().endsWith(UnifiedLog$.MODULE$.DeletedFileSuffix());
    }

    public static final /* synthetic */ void $anonfun$testRecoveryAfterCrashDuringSplitPhase1$3(File file) {
        Utils.atomicMoveWithFallback((Path)file.toPath(), (Path)Paths.get(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), UnifiedLog$.MODULE$.DeletedFileSuffix(), ""), new String[0]));
    }

    public static final /* synthetic */ int $anonfun$testRecoveryAfterCrashDuringSplitPhase2$1(List newSegments$1, LogSegment segment) {
        LogSegment logSegment = segment;
        Object object = newSegments$1.last();
        if (logSegment == null ? object != null : !logSegment.equals(object)) {
            segment.changeFileSuffixes("", UnifiedLog$.MODULE$.CleanedFileSuffix());
        } else {
            segment.changeFileSuffixes("", UnifiedLog$.MODULE$.SwapFileSuffix());
        }
        return segment.truncateTo(0L);
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAfterCrashDuringSplitPhase2$2(File file) {
        return file.getName().endsWith(UnifiedLog$.MODULE$.DeletedFileSuffix());
    }

    public static final /* synthetic */ void $anonfun$testRecoveryAfterCrashDuringSplitPhase2$3(File file) {
        Utils.atomicMoveWithFallback((Path)file.toPath(), (Path)Paths.get(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), UnifiedLog$.MODULE$.DeletedFileSuffix(), ""), new String[0]));
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAfterCrashDuringSplitPhase3$2(File file) {
        return file.getName().endsWith(UnifiedLog$.MODULE$.DeletedFileSuffix());
    }

    public static final /* synthetic */ void $anonfun$testRecoveryAfterCrashDuringSplitPhase3$3(File file) {
        Utils.atomicMoveWithFallback((Path)file.toPath(), (Path)Paths.get(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), UnifiedLog$.MODULE$.DeletedFileSuffix(), ""), new String[0]));
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAfterCrashDuringSplitPhase4$2(File file) {
        return file.getName().endsWith(UnifiedLog$.MODULE$.DeletedFileSuffix());
    }

    public static final /* synthetic */ void $anonfun$testRecoveryAfterCrashDuringSplitPhase4$3(File file) {
        Utils.delete((File)file);
    }

    private final MemoryRecords createRecords$5() {
        byte[] x$1 = "test".getBytes();
        long x$2 = this.mockTime().milliseconds();
        byte[] x$3 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$4 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        return TestUtils$.MODULE$.singletonRecords(x$1, x$3, x$4, x$2, x$5);
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testCleanShutdownFile$1(LogLoaderTest $this, ObjectRef log$12, int _) {
        UnifiedLog qual$1 = (UnifiedLog)log$12.elem;
        MemoryRecords x$11 = $this.createRecords$5();
        int x$12 = 0;
        AppendOrigin x$13 = qual$1.appendAsLeader$default$3();
        MetadataVersion x$14 = qual$1.appendAsLeader$default$4();
        RequestLocal x$15 = qual$1.appendAsLeader$default$5();
        return qual$1.appendAsLeader(x$11, x$12, x$13, x$14, x$15);
    }

    public static final /* synthetic */ boolean $anonfun$testFullTransactionIndexRecovery$1(LogSegment segment) {
        segment.offsetIndex().deleteIfExists();
        return segment.txnIndex().deleteIfExists();
    }

    public static final /* synthetic */ LogSegment $anonfun$testLogEndLessThanStartAfterReopen$1(LogLoaderTest $this, ObjectRef log$13, int i) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), Integer.toString(i).getBytes());
        UnifiedLog qual$1 = (UnifiedLog)log$13.elem;
        MemoryRecords x$1 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
        int x$2 = 0;
        AppendOrigin x$3 = qual$1.appendAsLeader$default$3();
        MetadataVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$1, x$2, x$3, x$4, x$5);
        UnifiedLog qual$2 = (UnifiedLog)log$13.elem;
        Option x$6 = qual$2.roll$default$1();
        return qual$2.roll(x$6);
    }

    public static final /* synthetic */ LogSegment $anonfun$testCorruptedLogRecoveryDoesNotDeleteProducerStateSnapshotsPostRecovery$1(LogLoaderTest $this, ObjectRef log$14, int i) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), Integer.toString(i).getBytes());
        UnifiedLog qual$1 = (UnifiedLog)log$14.elem;
        MemoryRecords x$1 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
        int x$2 = 0;
        AppendOrigin x$3 = qual$1.appendAsLeader$default$3();
        MetadataVersion x$4 = qual$1.appendAsLeader$default$4();
        RequestLocal x$5 = qual$1.appendAsLeader$default$5();
        qual$1.appendAsLeader(x$1, x$2, x$3, x$4, x$5);
        UnifiedLog qual$2 = (UnifiedLog)log$14.elem;
        Option x$6 = qual$2.roll$default$1();
        return qual$2.roll(x$6);
    }

    public static final /* synthetic */ boolean $anonfun$testCorruptedLogRecoveryDoesNotDeleteProducerStateSnapshotsPostRecovery$4(SnapshotFile snapshotFile) {
        return snapshotFile.file().exists();
    }

    public static final /* synthetic */ LogSegment $anonfun$testCorruptedLogRecoveryDoesNotDeleteProducerStateSnapshotsPostRecovery$7(LogLoaderTest $this, ObjectRef log$14, int i) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), Integer.toString(i).getBytes());
        UnifiedLog qual$3 = (UnifiedLog)log$14.elem;
        MemoryRecords x$18 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
        int x$19 = 0;
        AppendOrigin x$20 = qual$3.appendAsLeader$default$3();
        MetadataVersion x$21 = qual$3.appendAsLeader$default$4();
        RequestLocal x$22 = qual$3.appendAsLeader$default$5();
        qual$3.appendAsLeader(x$18, x$19, x$20, x$21, x$22);
        UnifiedLog qual$4 = (UnifiedLog)log$14.elem;
        Option x$23 = qual$4.roll$default$1();
        return qual$4.roll(x$23);
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testRecoverWithEmptyActiveSegment$1(LogLoaderTest $this, ObjectRef log$15, int messageSize$2, int i) {
        UnifiedLog qual$1 = (UnifiedLog)log$15.elem;
        byte[] x$11 = TestUtils$.MODULE$.randomBytes(messageSize$2);
        long x$12 = $this.mockTime().milliseconds() + (long)(i * 10);
        byte[] x$13 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$14 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$15 = TestUtils$.MODULE$.singletonRecords$default$5();
        MemoryRecords x$16 = TestUtils$.MODULE$.singletonRecords(x$11, x$13, x$14, x$12, x$15);
        int x$17 = 0;
        AppendOrigin x$18 = qual$1.appendAsLeader$default$3();
        MetadataVersion x$19 = qual$1.appendAsLeader$default$4();
        RequestLocal x$20 = qual$1.appendAsLeader$default$5();
        return qual$1.appendAsLeader(x$16, x$17, x$18, x$19, x$20);
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testRecoverWithEmptyActiveSegment$3(LogLoaderTest $this, ObjectRef log$15, int messageSize$2, int i) {
        UnifiedLog qual$3 = (UnifiedLog)log$15.elem;
        byte[] x$33 = TestUtils$.MODULE$.randomBytes(messageSize$2);
        long x$34 = $this.mockTime().milliseconds() + (long)(i * 10);
        byte[] x$35 = TestUtils$.MODULE$.singletonRecords$default$2();
        CompressionType x$36 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$37 = TestUtils$.MODULE$.singletonRecords$default$5();
        MemoryRecords x$38 = TestUtils$.MODULE$.singletonRecords(x$33, x$35, x$36, x$34, x$37);
        int x$39 = 0;
        AppendOrigin x$40 = qual$3.appendAsLeader$default$3();
        MetadataVersion x$41 = qual$3.appendAsLeader$default$4();
        RequestLocal x$42 = qual$3.appendAsLeader$default$5();
        return qual$3.appendAsLeader(x$38, x$39, x$40, x$41, x$42);
    }

    public LogLoaderTest() {
        this.maxTransactionTimeoutMs = 300000;
    }
}

