/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import kafka.network.SocketServer;
import kafka.security.authorizer.AclEntry$;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.NotNothing$;
import org.apache.kafka.common.message.DescribeClusterRequestData;
import org.apache.kafka.common.message.DescribeClusterResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DescribeClusterRequest;
import org.apache.kafka.common.requests.DescribeClusterResponse;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001U4A!\u0003\u0006\u0001\u001f!)A\u0003\u0001C\u0001+!)q\u0003\u0001C!1!)\u0011\u0006\u0001C!U!)Q\b\u0001C\u0001}!)1\t\u0001C\u0001}!)Q\t\u0001C\u0001\r\")A\n\u0001C\u0005\u001b\"9\u0011\u000eAI\u0001\n\u0013Q'A\u0007#fg\u000e\u0014\u0018NY3DYV\u001cH/\u001a:SKF,Xm\u001d;UKN$(BA\u0006\r\u0003\u0019\u0019XM\u001d<fe*\tQ\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0001\u0002CA\t\u0013\u001b\u0005Q\u0011BA\n\u000b\u0005=\u0011\u0015m]3SKF,Xm\u001d;UKN$\u0018A\u0002\u001fj]&$h\bF\u0001\u0017!\t\t\u0002!A\fce>\\WM\u001d)s_B,'\u000f^=Pm\u0016\u0014(/\u001b3fgR\u0011\u0011d\b\t\u00035ui\u0011a\u0007\u0006\u00029\u0005)1oY1mC&\u0011ad\u0007\u0002\u0005+:LG\u000fC\u0003!\u0005\u0001\u0007\u0011%\u0001\u0006qe>\u0004XM\u001d;jKN\u0004\"AI\u0014\u000e\u0003\rR!\u0001J\u0013\u0002\tU$\u0018\u000e\u001c\u0006\u0002M\u0005!!.\u0019<b\u0013\tA3E\u0001\u0006Qe>\u0004XM\u001d;jKN\fQa]3u+B$\"!G\u0016\t\u000b1\u001a\u0001\u0019A\u0017\u0002\u0011Q,7\u000f^%oM>\u0004\"AL\u001c\u000e\u0003=R!\u0001M\u0019\u0002\u0007\u0005\u0004\u0018N\u0003\u00023g\u00059!.\u001e9ji\u0016\u0014(B\u0001\u001b6\u0003\u0015QWO\\5u\u0015\u00051\u0014aA8sO&\u0011\u0001h\f\u0002\t)\u0016\u001cH/\u00138g_\"\u00121A\u000f\t\u0003]mJ!\u0001P\u0018\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001 uKN$H)Z:de&\u0014Wm\u00117vgR,'OU3rk\u0016\u001cH/\u00138dYV$\u0017N\\4DYV\u001cH/\u001a:BkRDwN]5{K\u0012|\u0005/\u001a:bi&|gn\u001d\u000b\u00023!\u0012A\u0001\u0011\t\u0003]\u0005K!AQ\u0018\u0003\tQ+7\u000f^\u0001?i\u0016\u001cH\u000fR3tGJL'-Z\"mkN$XM\u001d*fcV,7\u000f^#yG2,H-\u001b8h\u00072,8\u000f^3s\u0003V$\bn\u001c:ju\u0016$w\n]3sCRLwN\\:)\u0005\u0015\u0001\u0015A\u0007;fgR$Um]2sS\n,7\t\\;ti\u0016\u0014(+Z9vKN$HCA\rH\u0011\u0015Ae\u00011\u0001J\u0003\tJgn\u00197vI\u0016\u001cE.^:uKJ\fU\u000f\u001e5pe&TX\rZ(qKJ\fG/[8ogB\u0011!DS\u0005\u0003\u0017n\u0011qAQ8pY\u0016\fg.\u0001\u000etK:$H)Z:de&\u0014Wm\u00117vgR,'OU3rk\u0016\u001cH\u000fF\u0002O3z\u0003\"aT,\u000e\u0003AS!!\u0015*\u0002\u0011I,\u0017/^3tiNT!a\u0015+\u0002\r\r|W.\\8o\u0015\tiQK\u0003\u0002Wk\u00051\u0011\r]1dQ\u0016L!\u0001\u0017)\u0003/\u0011+7o\u0019:jE\u0016\u001cE.^:uKJ\u0014Vm\u001d9p]N,\u0007\"\u0002.\b\u0001\u0004Y\u0016a\u0002:fcV,7\u000f\u001e\t\u0003\u001frK!!\u0018)\u0003-\u0011+7o\u0019:jE\u0016\u001cE.^:uKJ\u0014V-];fgRDqaX\u0004\u0011\u0002\u0003\u0007\u0001-A\u0006eKN$\u0018N\\1uS>t\u0007c\u0001\u000ebG&\u0011!m\u0007\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\u0011<W\"A3\u000b\u0005\u0019d\u0011a\u00028fi^|'o[\u0005\u0003Q\u0016\u0014AbU8dW\u0016$8+\u001a:wKJ\fAe]3oi\u0012+7o\u0019:jE\u0016\u001cE.^:uKJ\u0014V-];fgR$C-\u001a4bk2$HEM\u000b\u0002W*\u0012\u0001\r\\\u0016\u0002[B\u0011an]\u0007\u0002_*\u0011\u0001/]\u0001\nk:\u001c\u0007.Z2lK\u0012T!A]\u000e\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002u_\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class DescribeClusterRequestTest
extends BaseRequestTest {
    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        properties.setProperty(KafkaConfig$.MODULE$.DefaultReplicationFactorProp(), "2");
        properties.setProperty(KafkaConfig$.MODULE$.RackProp(), new StringBuilder(5).append("rack/").append(properties.getProperty(KafkaConfig$.MODULE$.BrokerIdProp())).toString());
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.doSetup(testInfo, false);
    }

    @Test
    public void testDescribeClusterRequestIncludingClusterAuthorizedOperations() {
        this.testDescribeClusterRequest(true);
    }

    @Test
    public void testDescribeClusterRequestExcludingClusterAuthorizedOperations() {
        this.testDescribeClusterRequest(false);
    }

    public void testDescribeClusterRequest(boolean includeClusterAuthorizedOperations) {
        scala.collection.immutable.Set expectedBrokers = ((TraversableOnce)this.servers().map((Function1 & Serializable & scala.Serializable)server -> new DescribeClusterResponseData.DescribeClusterBroker().setBrokerId(server.config().brokerId()).setHost("localhost").setPort(server.socketServer().boundPort(this.listenerName())).setRack((String)server.config().rack().orNull(Predef$.MODULE$.$conforms())), Buffer$.MODULE$.canBuildFrom())).toSet();
        int expectedControllerId = ((KafkaServer)((TraversableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DescribeClusterRequestTest.$anonfun$testDescribeClusterRequest$2(x$1)))).last()).config().brokerId();
        String expectedClusterId = ((KafkaServer)this.servers().last()).clusterId();
        int expectedClusterAuthorizedOperations = includeClusterAuthorizedOperations ? Utils.to32BitField((java.util.Set)((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)AclEntry$.MODULE$.supportedOperations(ResourceType.CLUSTER).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToByte((byte)x$2.code()), Set$.MODULE$.canBuildFrom())).asJava())) : Integer.MIN_VALUE;
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper((int)ApiKeys.DESCRIBE_CLUSTER.oldestVersion()), (int)ApiKeys.DESCRIBE_CLUSTER.latestVersion()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)version -> {
            DescribeClusterRequest describeClusterRequest = new DescribeClusterRequest.Builder(new DescribeClusterRequestData().setIncludeClusterAuthorizedOperations(includeClusterAuthorizedOperations)).build((short)version);
            DescribeClusterResponse describeClusterResponse = this.sentDescribeClusterRequest(describeClusterRequest, this.sentDescribeClusterRequest$default$2());
            Assertions.assertEquals((int)expectedControllerId, (int)describeClusterResponse.data().controllerId());
            Assertions.assertEquals((Object)expectedClusterId, (Object)describeClusterResponse.data().clusterId());
            Assertions.assertEquals((int)expectedClusterAuthorizedOperations, (int)describeClusterResponse.data().clusterAuthorizedOperations());
            Assertions.assertEquals((Object)expectedBrokers, (Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)describeClusterResponse.data().brokers()).asScala()).toSet());
        });
    }

    private DescribeClusterResponse sentDescribeClusterRequest(DescribeClusterRequest request, Option<SocketServer> destination) {
        return (DescribeClusterResponse)this.connectAndReceive((AbstractRequest)request, (SocketServer)destination.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.anySocketServer()), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DescribeClusterResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    private Option<SocketServer> sentDescribeClusterRequest$default$2() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeClusterRequest$2(KafkaServer x$1) {
        return x$1.kafkaController().isActive();
    }
}

