/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import kafka.tools.ConsumerPerformance;
import kafka.tools.ConsumerPerformance$;
import kafka.utils.Exit$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.utils.Exit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Console$;
import scala.Function0;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001i3A!\u0004\b\u0001'!)!\u0004\u0001C\u00017!9a\u0004\u0001b\u0001\n\u0013y\u0002B\u0002\u0015\u0001A\u0003%\u0001\u0005C\u0003*\u0001\u0011\u0005!\u0006C\u0003<\u0001\u0011\u0005!\u0006C\u0003>\u0001\u0011\u0005!\u0006C\u0003@\u0001\u0011\u0005!\u0006C\u0003B\u0001\u0011\u0005!\u0006C\u0003D\u0001\u0011\u0005!\u0006C\u0003F\u0001\u0011\u0005!\u0006C\u0003H\u0001\u0011\u0005!\u0006C\u0003J\u0001\u0011%!JA\fD_:\u001cX/\\3s!\u0016\u0014hm\u001c:nC:\u001cW\rV3ti*\u0011q\u0002E\u0001\u0006i>|Gn\u001d\u0006\u0002#\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0015!\t)\u0002$D\u0001\u0017\u0015\u00059\u0012!B:dC2\f\u0017BA\r\u0017\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001\b\t\u0003;\u0001i\u0011AD\u0001\u000bI\u0006$XMR8s[\u0006$X#\u0001\u0011\u0011\u0005\u00052S\"\u0001\u0012\u000b\u0005\r\"\u0013\u0001\u0002;fqRT\u0011!J\u0001\u0005U\u00064\u0018-\u0003\u0002(E\t\u00012+[7qY\u0016$\u0015\r^3G_Jl\u0017\r^\u0001\fI\u0006$XMR8s[\u0006$\b%A\u000euKN$H)\u001a;bS2,G\rS3bI\u0016\u0014X*\u0019;dQ\n{G-\u001f\u000b\u0002WA\u0011Q\u0003L\u0005\u0003[Y\u0011A!\u00168ji\"\u0012Aa\f\t\u0003aej\u0011!\r\u0006\u0003eM\n1!\u00199j\u0015\t!T'A\u0004kkBLG/\u001a:\u000b\u0005Y:\u0014!\u00026v]&$(\"\u0001\u001d\u0002\u0007=\u0014x-\u0003\u0002;c\t!A+Z:u\u0003y!Xm\u001d;O_:$U\r^1jY\u0016$\u0007*Z1eKJl\u0015\r^2i\u0005>$\u0017\u0010\u000b\u0002\u0006_\u0005!B/Z:u\u0007>tg-[4Ce>\\WM\u001d'jgRD#AB\u0018\u00023Q,7\u000f^\"p]\u001aLwMQ8piN#(/\u00199TKJ4XM\u001d\u0015\u0003\u000f=\na\u0003^3ti\n\u0013xn[3s\u0019&\u001cHo\u0014<feJLG-\u001a\u0015\u0003\u0011=\n\u0001\u0005^3ti\u000e{gNZ5h/&$\b.\u00168sK\u000e|wM\\5{K\u0012|\u0005\u000f^5p]\"\u0012\u0011bL\u0001\u0015i\u0016\u001cHo\u00117jK:$\u0018\nZ(wKJ\u0014\u0018\u000eZ3)\u0005)y\u0013a\u0005;fgR$UMZ1vYR\u001cE.[3oi&#\u0007FA\u00060\u0003Y!Xm\u001d;IK\u0006$WM]'bi\u000eD7i\u001c8uK:$H\u0003B\u0016L!VCQ\u0001\u0014\u0007A\u00025\u000b\u0001\u0002Z3uC&dW\r\u001a\t\u0003+9K!a\u0014\f\u0003\u000f\t{w\u000e\\3b]\")\u0011\u000b\u0004a\u0001%\u00069R\r\u001f9fGR,GmT;uaV$H*\u001b8f\u0007>,h\u000e\u001e\t\u0003+MK!\u0001\u0016\f\u0003\u0007%sG\u000fC\u0003W\u0019\u0001\u0007q+A\u0002gk:\u00042!\u0006-,\u0013\tIfCA\u0005Gk:\u001cG/[8oa\u0001")
public class ConsumerPerformanceTest {
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");

    private SimpleDateFormat dateFormat() {
        return this.dateFormat;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDetailedHeaderMatchBody() {
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ConsumerPerformance$.MODULE$.printConsumerProgress(1, 0x100000L, 0L, 1L, 0L, 0L, 1L, this.dateFormat(), 1L);
        int testHeaderMatchContent_expectedOutputLineCount = 2;
        boolean testHeaderMatchContent_detailed = true;
        try (ByteArrayOutputStream testHeaderMatchContent_outContent = new ByteArrayOutputStream();){
            void testHeaderMatchContent_fun;
            Console$.MODULE$.withOut((OutputStream)testHeaderMatchContent_outContent, (Function0)((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ConsumerPerformanceTest.$anonfun$testHeaderMatchContent$1(testHeaderMatchContent_detailed, (Function0)testHeaderMatchContent_fun, testHeaderMatchContent_outContent, testHeaderMatchContent_expectedOutputLineCount)));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testNonDetailedHeaderMatchBody() {
        JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Predef$.MODULE$.println((Object)new StringBuilder(36).append(this.dateFormat().format(BoxesRunTime.boxToLong((long)System.currentTimeMillis()))).append(", ").append(this.dateFormat().format(BoxesRunTime.boxToLong((long)System.currentTimeMillis()))).append(", 1.0, 1.0, 1, 1.0, 1, 1, 1.1, 1.1").toString());
        int testHeaderMatchContent_expectedOutputLineCount = 2;
        boolean testHeaderMatchContent_detailed = false;
        try (ByteArrayOutputStream testHeaderMatchContent_outContent = new ByteArrayOutputStream();){
            void testHeaderMatchContent_fun;
            Console$.MODULE$.withOut((OutputStream)testHeaderMatchContent_outContent, (Function0)((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ConsumerPerformanceTest.$anonfun$testHeaderMatchContent$1(testHeaderMatchContent_detailed, (Function0)testHeaderMatchContent_fun, testHeaderMatchContent_outContent, testHeaderMatchContent_expectedOutputLineCount)));
        }
    }

    @Test
    public void testConfigBrokerList() {
        String[] args = (String[])((Object[])new String[]{"--broker-list", "localhost:9092", "--topic", "test", "--messages", "10"});
        ConsumerPerformance.ConsumerPerfConfig config = new ConsumerPerformance.ConsumerPerfConfig(args);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.brokerHostsAndPorts());
        Assertions.assertEquals((Object)"test", (Object)config.topic());
        Assertions.assertEquals((long)10L, (long)config.numMessages());
    }

    @Test
    public void testConfigBootStrapServer() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--messages", "10", "--print-metrics"});
        ConsumerPerformance.ConsumerPerfConfig config = new ConsumerPerformance.ConsumerPerfConfig(args);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.brokerHostsAndPorts());
        Assertions.assertEquals((Object)"test", (Object)config.topic());
        Assertions.assertEquals((long)10L, (long)config.numMessages());
    }

    @Test
    public void testBrokerListOverride() {
        String[] args = (String[])((Object[])new String[]{"--broker-list", "localhost:9094", "--bootstrap-server", "localhost:9092", "--topic", "test", "--messages", "10"});
        ConsumerPerformance.ConsumerPerfConfig config = new ConsumerPerformance.ConsumerPerfConfig(args);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.brokerHostsAndPorts());
        Assertions.assertEquals((Object)"test", (Object)config.topic());
        Assertions.assertEquals((long)10L, (long)config.numMessages());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConfigWithUnrecognizedOption() {
        void setExitProcedure_exitProcedure;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(x$1, message) -> ConsumerPerformanceTest.$anonfun$testConfigWithUnrecognizedOption$1(BoxesRunTime.unboxToInt((Object)x$1), message);
        if (Exit$.MODULE$ == null) {
            throw null;
        }
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        String[] args = (String[])((Object[])new String[]{"--broker-list", "localhost:9092", "--topic", "test", "--messages", "10", "--new-consumer"});
        try {
            Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsumerPerformance.ConsumerPerfConfig(args));
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
    }

    @Test
    public void testClientIdOverride() {
        File consumerConfigFile = TestUtils$.MODULE$.tempFile("test_consumer_config", ".conf");
        new PrintWriter(null, consumerConfigFile){
            {
                this.write("client.id=consumer-1");
                this.close();
            }
        };
        String[] args = (String[])((Object[])new String[]{"--broker-list", "localhost:9092", "--topic", "test", "--messages", "10", "--consumer.config", consumerConfigFile.getPath()});
        ConsumerPerformance.ConsumerPerfConfig config = new ConsumerPerformance.ConsumerPerfConfig(args);
        Assertions.assertEquals((Object)"consumer-1", (Object)config.props().getProperty("client.id"));
    }

    @Test
    public void testDefaultClientId() {
        String[] args = (String[])((Object[])new String[]{"--broker-list", "localhost:9092", "--topic", "test", "--messages", "10"});
        ConsumerPerformance.ConsumerPerfConfig config = new ConsumerPerformance.ConsumerPerfConfig(args);
        Assertions.assertEquals((Object)"perf-consumer-client", (Object)config.props().getProperty("client.id"));
    }

    private void testHeaderMatchContent(boolean detailed, int expectedOutputLineCount, Function0<BoxedUnit> fun) {
        try (ByteArrayOutputStream outContent = new ByteArrayOutputStream();){
            Console$.MODULE$.withOut((OutputStream)outContent, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                ConsumerPerformance$.MODULE$.printHeader(detailed);
                fun.apply$mcV$sp();
                String[] contents = outContent.toString().split("\n");
                Assertions.assertEquals((int)expectedOutputLineCount, (int)contents.length);
                String header = contents[0];
                String body = contents[1];
                Assertions.assertEquals((int)header.split(",\\s").length, (int)body.split(",\\s").length);
            });
        }
    }

    public static final /* synthetic */ Nothing$ $anonfun$testConfigWithUnrecognizedOption$1(int x$1, Option message) {
        throw new IllegalArgumentException((String)message.orNull(Predef$.MODULE$.$conforms()));
    }
}

