/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Optional;
import kafka.cluster.Partition;
import kafka.log.LogOffsetSnapshot;
import kafka.server.DelayedFetchMetrics$;
import kafka.server.DelayedOperation;
import kafka.server.DelayedOperation$;
import kafka.server.FetchHighWatermark$;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.FetchParams;
import kafka.server.FetchPartitionData;
import kafka.server.FetchPartitionStatus;
import kafka.server.FetchTxnCommitted$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.errors.FencedLeaderEpochException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.FetchRequest;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0001\u00194Aa\u0003\u0007\u0001#!Aa\u0003\u0001B\u0001B\u0003%q\u0003\u0003\u0005\u001b\u0001\t\u0005\t\u0015!\u0003\u001c\u0011!)\u0004A!A!\u0002\u00131\u0004\u0002C\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\t\u0011u\u0002!\u0011!Q\u0001\nyBQ!\u0013\u0001\u0005\u0002)CQ!\u0015\u0001\u0005BICQA\u0018\u0001\u0005B}CQa\u0019\u0001\u0005B\u0011DQ!\u001a\u0001\u0005B\u0011\u0014A\u0002R3mCf,GMR3uG\"T!!\u0004\b\u0002\rM,'O^3s\u0015\u0005y\u0011!B6bM.\f7\u0001A\n\u0003\u0001I\u0001\"a\u0005\u000b\u000e\u00031I!!\u0006\u0007\u0003!\u0011+G.Y=fI>\u0003XM]1uS>t\u0017A\u00029be\u0006l7\u000f\u0005\u0002\u00141%\u0011\u0011\u0004\u0004\u0002\f\r\u0016$8\r\u001b)be\u0006l7/\u0001\u000bgKR\u001c\u0007\u000eU1si&$\u0018n\u001c8Ti\u0006$Xo\u001d\t\u00049\u0005\u001aS\"A\u000f\u000b\u0005yy\u0012AC2pY2,7\r^5p]*\t\u0001%A\u0003tG\u0006d\u0017-\u0003\u0002#;\t\u00191+Z9\u0011\t\u0011*sEM\u0007\u0002?%\u0011ae\b\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005!\u0002T\"A\u0015\u000b\u0005)Z\u0013AB2p[6|gN\u0003\u0002\u0010Y)\u0011QFL\u0001\u0007CB\f7\r[3\u000b\u0003=\n1a\u001c:h\u0013\t\t\u0014F\u0001\tU_BL7-\u00133QCJ$\u0018\u000e^5p]B\u00111cM\u0005\u0003i1\u0011ACR3uG\"\u0004\u0016M\u001d;ji&|gn\u0015;biV\u001c\u0018A\u0004:fa2L7-Y'b]\u0006<WM\u001d\t\u0003']J!\u0001\u000f\u0007\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\u0006)\u0011/^8uCB\u00111cO\u0005\u0003y1\u0011ABU3qY&\u001c\u0017-U;pi\u0006\f\u0001C]3ta>t7/Z\"bY2\u0014\u0017mY6\u0011\t\u0011z\u0014IR\u0005\u0003\u0001~\u0011\u0011BR;oGRLwN\\\u0019\u0011\u0007q\t#\t\u0005\u0003%K\u001d\u001a\u0005CA\nE\u0013\t)EB\u0001\nGKR\u001c\u0007\u000eU1si&$\u0018n\u001c8ECR\f\u0007C\u0001\u0013H\u0013\tAuD\u0001\u0003V]&$\u0018A\u0002\u001fj]&$h\b\u0006\u0004L\u00196su\n\u0015\t\u0003'\u0001AQA\u0006\u0004A\u0002]AQA\u0007\u0004A\u0002mAQ!\u000e\u0004A\u0002YBQ!\u000f\u0004A\u0002iBQ!\u0010\u0004A\u0002y\n\u0001\u0002^8TiJLgn\u001a\u000b\u0002'B\u0011Ak\u0017\b\u0003+f\u0003\"AV\u0010\u000e\u0003]S!\u0001\u0017\t\u0002\rq\u0012xn\u001c;?\u0013\tQv$\u0001\u0004Qe\u0016$WMZ\u0005\u00039v\u0013aa\u0015;sS:<'B\u0001. \u0003-!(/_\"p[BdW\r^3\u0015\u0003\u0001\u0004\"\u0001J1\n\u0005\t|\"a\u0002\"p_2,\u0017M\\\u0001\r_:,\u0005\u0010]5sCRLwN\u001c\u000b\u0002\r\u0006QqN\\\"p[BdW\r^3")
public class DelayedFetch
extends DelayedOperation {
    private final FetchParams params;
    private final Seq<Tuple2<TopicIdPartition, FetchPartitionStatus>> fetchPartitionStatus;
    private final ReplicaManager replicaManager;
    private final ReplicaQuota quota;
    private final Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit> responseCallback;

    public String toString() {
        return new StringBuilder(37).append("DelayedFetch(params=").append(this.params).append(", numPartitions=").append(this.fetchPartitionStatus.size()).append(")").toString();
    }

    @Override
    public boolean tryComplete() {
        boolean bl;
        Object object = new Object();
        try {
            IntRef accumulatedSize = IntRef.create((int)0);
            this.fetchPartitionStatus.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DelayedFetch.$anonfun$tryComplete$1(this, object, accumulatedSize, x0$1);
                return BoxedUnit.UNIT;
            });
            if (accumulatedSize.elem < this.params.minBytes()) {
                return false;
            }
            bl = this.forceComplete();
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    @Override
    public void onExpiration() {
        if (this.params.isFromFollower()) {
            DelayedFetchMetrics$.MODULE$.followerExpiredRequestMeter().mark();
            return;
        }
        DelayedFetchMetrics$.MODULE$.consumerExpiredRequestMeter().mark();
    }

    @Override
    public void onComplete() {
        Seq fetchInfos = (Seq)this.fetchPartitionStatus.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicIdPartition tp = (TopicIdPartition)x0$1._1();
            FetchPartitionStatus status = (FetchPartitionStatus)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)status.fetchInfo());
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom());
        Seq fetchPartitionData = (Seq)this.replicaManager.readFromLocalLog(this.params, (Seq<Tuple2<TopicIdPartition, FetchRequest.PartitionData>>)fetchInfos, this.quota, true).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            TopicIdPartition tp = (TopicIdPartition)x0$2._1();
            LogReadResult result = (LogReadResult)x0$2._2();
            boolean isReassignmentFetch = $this.params.isFromFollower() && $this.replicaManager.isAddingReplica(tp.topicPartition(), $this.params.replicaId());
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)result.toFetchPartitionData(isReassignmentFetch));
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom());
        this.responseCallback.apply((Object)fetchPartitionData);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$tryComplete$1(DelayedFetch $this, Object nonLocalReturnKey1$1, IntRef accumulatedSize$1, Tuple2 x0$1) {
        if (x0$1 == null) throw new MatchError(null);
        TopicIdPartition topicIdPartition = (TopicIdPartition)x0$1._1();
        FetchPartitionStatus fetchStatus = (FetchPartitionStatus)x0$1._2();
        LogOffsetMetadata fetchOffset = fetchStatus.startOffsetMetadata();
        Optional fetchLeaderEpoch = fetchStatus.fetchInfo().currentLeaderEpoch;
        try {
            LogOffsetMetadata logOffsetMetadata;
            LogOffsetMetadata logOffsetMetadata2 = fetchOffset;
            LogOffsetMetadata logOffsetMetadata3 = LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata();
            if (!(logOffsetMetadata2 == null ? logOffsetMetadata3 != null : !((Object)logOffsetMetadata2).equals(logOffsetMetadata3))) return;
            Partition partition = $this.replicaManager.getPartitionOrException(topicIdPartition.topicPartition());
            LogOffsetSnapshot offsetSnapshot = partition.fetchOffsetSnapshot(fetchLeaderEpoch, $this.params.fetchOnlyLeader());
            FetchIsolation fetchIsolation = $this.params.isolation();
            if (FetchLogEnd$.MODULE$.equals(fetchIsolation)) {
                logOffsetMetadata = offsetSnapshot.logEndOffset();
            } else if (FetchHighWatermark$.MODULE$.equals(fetchIsolation)) {
                logOffsetMetadata = offsetSnapshot.highWatermark();
            } else {
                if (!FetchTxnCommitted$.MODULE$.equals(fetchIsolation)) throw new MatchError((Object)fetchIsolation);
                logOffsetMetadata = offsetSnapshot.lastStableOffset();
            }
            if (logOffsetMetadata.messageOffset() != fetchOffset.messageOffset()) {
                if (logOffsetMetadata.onOlderSegment(fetchOffset)) {
                    $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Satisfying fetch ").append($this).append(" since it is fetching later segments of partition ").append(topicIdPartition).append(".").toString());
                    throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, $this.forceComplete());
                }
                if (fetchOffset.onOlderSegment(logOffsetMetadata)) {
                    $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Satisfying fetch ").append($this).append(" immediately since it is fetching older segments.").toString());
                    if (!$this.params.isFromFollower() || !$this.replicaManager.shouldLeaderThrottle($this.quota, partition, $this.params.replicaId())) {
                        throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, $this.forceComplete());
                    }
                } else if (fetchOffset.messageOffset() < logOffsetMetadata.messageOffset()) {
                    int bytesAvailable = package$.MODULE$.min(logOffsetMetadata.positionDiff(fetchOffset), fetchStatus.fetchInfo().maxBytes);
                    if (!$this.params.isFromFollower() || !$this.replicaManager.shouldLeaderThrottle($this.quota, partition, $this.params.replicaId())) {
                        accumulatedSize$1.elem += bytesAvailable;
                    }
                }
            }
            fetchStatus.fetchInfo().lastFetchedEpoch.ifPresent(fetchEpoch -> {
                OffsetForLeaderEpochResponseData.EpochEndOffset epochEndOffset = partition.lastOffsetForLeaderEpoch(fetchLeaderEpoch, Predef$.MODULE$.Integer2int(fetchEpoch), false);
                if (epochEndOffset.errorCode() != Errors.NONE.code() || epochEndOffset.endOffset() == -1L || epochEndOffset.leaderEpoch() == -1) {
                    $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(78).append("Could not obtain last offset for leader epoch for partition ").append(topicIdPartition).append(", epochEndOffset=").append(epochEndOffset).append(".").toString());
                    throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, $this.forceComplete());
                }
                if (epochEndOffset.leaderEpoch() < Predef$.MODULE$.Integer2int(fetchEpoch) || epochEndOffset.endOffset() < fetchStatus$1.fetchInfo().fetchOffset) {
                    $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(124).append("Satisfying fetch ").append($this).append(" since it has diverging epoch requiring truncation for partition ").append(topicIdPartition).append(" epochEndOffset=").append(epochEndOffset).append(" fetchEpoch=").append(fetchEpoch).append(" fetchOffset=").append(fetchStatus$1.fetchInfo().fetchOffset).append(".").toString());
                    throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, $this.forceComplete());
                }
            });
            return;
        }
        catch (NotLeaderOrFollowerException notLeaderOrFollowerException) {
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Broker is no longer the leader or follower of ").append(topicIdPartition).append(", satisfy ").append($this).append(" immediately").toString());
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, $this.forceComplete());
        }
        catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Broker no longer knows of partition ").append(topicIdPartition).append(", satisfy ").append($this).append(" immediately").toString());
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, $this.forceComplete());
        }
        catch (KafkaStorageException kafkaStorageException) {
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Partition ").append(topicIdPartition).append(" is in an offline log directory, satisfy ").append($this).append(" immediately").toString());
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, $this.forceComplete());
        }
        catch (FencedLeaderEpochException fencedLeaderEpochException) {
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(119).append("Broker is the leader of partition ").append(topicIdPartition).append(", but the requested epoch ").append(fetchLeaderEpoch).append(" is fenced by the latest leader epoch, satisfy ").append($this).append(" immediately").toString());
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, $this.forceComplete());
        }
    }

    public DelayedFetch(FetchParams params, Seq<Tuple2<TopicIdPartition, FetchPartitionStatus>> fetchPartitionStatus, ReplicaManager replicaManager, ReplicaQuota quota, Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit> responseCallback) {
        this.params = params;
        this.fetchPartitionStatus = fetchPartitionStatus;
        this.replicaManager = replicaManager;
        this.quota = quota;
        this.responseCallback = responseCallback;
        super(params.maxWaitMs(), DelayedOperation$.MODULE$.$lessinit$greater$default$2());
    }
}

