/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.Logger;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.Properties;
import kafka.server.BrokerMetadataCheckpoint;
import kafka.server.KafkaConfig;
import kafka.server.MetaProperties;
import kafka.server.RawMetaProperties;
import kafka.tools.TerseFailure;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.bootstrap.BootstrapDirectory;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.server.common.MetadataVersion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.TreeSet;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class StorageTool$
implements Logging {
    public static StorageTool$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new StorageTool$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void main(String[] args) {
        try {
            Namespace namespace = this.parseArguments(args);
            String command = namespace.getString("command");
            Option config = Option$.MODULE$.apply((Object)namespace.getString("config")).flatMap((Function1 & Serializable & scala.Serializable)p -> new Some((Object)new KafkaConfig(Utils.loadProps((String)p))));
            if ("info".equals(command)) {
                Seq<String> directories = this.configToLogDirectories((KafkaConfig)config.get());
                boolean selfManagedMode = this.configToSelfManagedMode((KafkaConfig)config.get());
                throw Exit$.MODULE$.exit(this.infoCommand(System.out, selfManagedMode, directories), Exit$.MODULE$.exit$default$2());
            }
            if ("format".equals(command)) {
                Seq<String> directories = this.configToLogDirectories((KafkaConfig)config.get());
                String clusterId = namespace.getString("cluster_id");
                MetadataVersion metadataVersion = this.getMetadataVersion(namespace, (Option<String>)Option$.MODULE$.apply((Object)((KafkaConfig)config.get()).interBrokerProtocolVersionString()));
                if (!metadataVersion.isKRaftSupported()) {
                    throw new TerseFailure("Must specify a valid KRaft metadata version of at least 3.0.");
                }
                MetaProperties metaProperties = this.buildMetadataProperties(clusterId, (KafkaConfig)config.get());
                Boolean ignoreFormatted = namespace.getBoolean("ignore_formatted");
                if (!this.configToSelfManagedMode((KafkaConfig)config.get())) {
                    throw new TerseFailure("The kafka configuration file appears to be for a legacy cluster. Formatting is only supported for clusters in KRaft mode.");
                }
                throw Exit$.MODULE$.exit(this.formatCommand(System.out, directories, metaProperties, metadataVersion, Predef$.MODULE$.Boolean2boolean(ignoreFormatted)), Exit$.MODULE$.exit$default$2());
            }
            if ("random-uuid".equals(command)) {
                System.out.println(Uuid.randomUuid());
                throw Exit$.MODULE$.exit(0, Exit$.MODULE$.exit$default$2());
            }
            throw new RuntimeException(new StringBuilder(16).append("Unknown command ").append(command).toString());
        }
        catch (TerseFailure e) {
            System.err.println(e.getMessage());
            System.exit(1);
            return;
        }
    }

    public Namespace parseArguments(String[] args) {
        ArgumentParser parser2 = ArgumentParsers.newArgumentParser((String)"kafka-storage").defaultHelp(true).description("The Kafka storage tool.");
        Subparsers subparsers = parser2.addSubparsers().dest("command");
        Subparser infoParser = subparsers.addParser("info").help("Get information about the Kafka log directories on this node.");
        Subparser formatParser = subparsers.addParser("format").help("Format the Kafka log directories on this node.");
        subparsers.addParser("random-uuid").help("Print a random UUID.");
        new .colon.colon((Object)infoParser, (List)new .colon.colon((Object)formatParser, (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)parser -> parser.addArgument(new String[]{"--config", "-c"}).action((ArgumentAction)Arguments.store()).required(true).help("The Kafka configuration file to use."));
        formatParser.addArgument(new String[]{"--cluster-id", "-t"}).action((ArgumentAction)Arguments.store()).required(true).help("The cluster ID to use.");
        formatParser.addArgument(new String[]{"--ignore-formatted", "-g"}).action((ArgumentAction)Arguments.storeTrue());
        formatParser.addArgument(new String[]{"--release-version", "-r"}).action((ArgumentAction)Arguments.store()).help(new StringBuilder(100).append("A KRaft release version to use for the initial metadata version. The minimum is 3.0, the default is ").append(MetadataVersion.latest().version()).toString());
        return parser2.parseArgsOrFail(args);
    }

    public Seq<String> configToLogDirectories(KafkaConfig config) {
        TreeSet directories = new TreeSet((Ordering)Ordering.String$.MODULE$);
        directories.$plus$plus$eq(config.logDirs());
        Option$.MODULE$.apply((Object)config.metadataLogDir()).foreach((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)directories.add((Object)elem)));
        return directories.toSeq();
    }

    public boolean configToSelfManagedMode(KafkaConfig config) {
        return config.processRoles().nonEmpty();
    }

    public MetadataVersion getMetadataVersion(Namespace namespace, Option<String> defaultVersionString) {
        MetadataVersion metadataVersion;
        if (defaultVersionString instanceof Some) {
            metadataVersion = MetadataVersion.fromVersionString((String)((String)((Some)defaultVersionString).value()));
        } else if (None$.MODULE$.equals(defaultVersionString)) {
            metadataVersion = MetadataVersion.latest();
        } else {
            throw new MatchError(defaultVersionString);
        }
        return (MetadataVersion)Option$.MODULE$.apply((Object)namespace.getString("release_version")).map((Function1 & Serializable & scala.Serializable)ver -> MetadataVersion.fromVersionString((String)ver)).getOrElse((Function0 & Serializable & scala.Serializable)() -> metadataVersion);
    }

    public int infoCommand(PrintStream stream, boolean selfManagedMode, Seq<String> directories) {
        ArrayBuffer problems = new ArrayBuffer();
        ArrayBuffer foundDirectories = new ArrayBuffer();
        ObjectRef prevMetadata = ObjectRef.create((Object)None$.MODULE$);
        ((IterableLike)directories.sorted((Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)directory -> {
            Some curMetadata;
            Path directoryPath = Paths.get(directory, new String[0]);
            if (!Files.isDirectory(directoryPath, new LinkOption[0])) {
                if (!Files.exists(directoryPath, new LinkOption[0])) {
                    return problems.$plus$eq((Object)new StringBuilder(15).append(directoryPath).append(" does not exist").toString());
                }
                return problems.$plus$eq((Object)new StringBuilder(19).append(directoryPath).append(" is not a directory").toString());
            }
            foundDirectories.$plus$eq((Object)((Object)directoryPath).toString());
            Path metaPath = directoryPath.resolve("meta.properties");
            if (!Files.exists(metaPath, new LinkOption[0])) {
                return problems.$plus$eq((Object)new StringBuilder(18).append(directoryPath).append(" is not formatted.").toString());
            }
            Properties properties = Utils.loadProps((String)((Object)metaPath).toString());
            RawMetaProperties rawMetaProperties = new RawMetaProperties(properties);
            int n = rawMetaProperties.version();
            switch (n) {
                case 0: 
                case 1: {
                    Some some = new Some((Object)rawMetaProperties);
                    break;
                }
                default: {
                    problems.$plus$eq((Object)new StringBuilder(26).append("Unsupported version for ").append(metaPath).append(": ").append(n).toString());
                    Some some = curMetadata = None$.MODULE$;
                }
            }
            if (((Option)prevMetadata$1.elem).isEmpty()) {
                prevMetadata$1.elem = curMetadata;
                return BoxedUnit.UNIT;
            }
            if (!((RawMetaProperties)((Option)prevMetadata$1.elem).get()).equals(curMetadata.get())) {
                return problems.$plus$eq((Object)new StringBuilder(51).append("Metadata for ").append(metaPath).append(" was ").append(curMetadata.get()).append(", ").append("but other directories featured ").append(((Option)prevMetadata$1.elem).get()).toString());
            }
            return BoxedUnit.UNIT;
        });
        ((Option)prevMetadata.elem).foreach((Function1 & Serializable & scala.Serializable)prev -> {
            if (selfManagedMode) {
                if (prev.version() == 0) {
                    return problems.$plus$eq((Object)"The kafka configuration file appears to be for a cluster in KRaft mode, but the directories are formatted for legacy mode.");
                }
                return BoxedUnit.UNIT;
            }
            if (prev.version() == 1) {
                return problems.$plus$eq((Object)"The kafka configuration file appears to be for a legacy cluster, but the directories are formatted for a cluster in KRaft mode.");
            }
            return BoxedUnit.UNIT;
        });
        if (directories.isEmpty()) {
            stream.println("No directories specified.");
            return 0;
        }
        if (foundDirectories.nonEmpty()) {
            if (foundDirectories.size() == 1) {
                stream.println("Found log directory:");
            } else {
                stream.println("Found log directories:");
            }
            foundDirectories.foreach((Function1 & Serializable & scala.Serializable)d -> {
                stream.println(new StringOps(Predef$.MODULE$.augmentString("  %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{d})));
                return BoxedUnit.UNIT;
            });
            stream.println("");
        }
        ((Option)prevMetadata.elem).foreach((Function1 & Serializable & scala.Serializable)prev -> {
            StorageTool$.$anonfun$infoCommand$4(stream, prev);
            return BoxedUnit.UNIT;
        });
        if (problems.nonEmpty()) {
            if (problems.size() == 1) {
                stream.println("Found problem:");
            } else {
                stream.println("Found problems:");
            }
            problems.foreach((Function1 & Serializable & scala.Serializable)d -> {
                stream.println(new StringOps(Predef$.MODULE$.augmentString("  %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{d})));
                return BoxedUnit.UNIT;
            });
            stream.println("");
            return 1;
        }
        return 0;
    }

    public MetaProperties buildMetadataProperties(String clusterIdStr, KafkaConfig config) {
        Uuid uuid;
        try {
            uuid = Uuid.fromString((String)clusterIdStr);
        }
        catch (Throwable e) {
            throw new TerseFailure(new StringBuilder(55).append("Cluster ID string ").append(clusterIdStr).append(" ").append("does not appear to be a valid UUID: ").append(e.getMessage()).toString());
        }
        Uuid effectiveClusterId = uuid;
        if (config.nodeId() < 0) {
            throw new TerseFailure(new StringBuilder(58).append("The node.id must be set to a non-negative integer. We saw ").append(config.nodeId()).toString());
        }
        return new MetaProperties(effectiveClusterId.toString(), config.nodeId());
    }

    public int formatCommand(PrintStream stream, Seq<String> directories, MetaProperties metaProperties, MetadataVersion metadataVersion, boolean ignoreFormatted) {
        if (directories.isEmpty()) {
            throw new TerseFailure("No log directories found in the configuration.");
        }
        Seq unformattedDirectories = (Seq)directories.filter((Function1 & Serializable & scala.Serializable)directory -> BoxesRunTime.boxToBoolean((boolean)StorageTool$.$anonfun$formatCommand$1(ignoreFormatted, directory)));
        if (unformattedDirectories.isEmpty()) {
            stream.println("All of the log directories are already formatted.");
        }
        unformattedDirectories.foreach((Function1 & Serializable & scala.Serializable)directory -> {
            StorageTool$.$anonfun$formatCommand$2(metaProperties, metadataVersion, stream, directory);
            return BoxedUnit.UNIT;
        });
        return 0;
    }

    public static final /* synthetic */ void $anonfun$infoCommand$4(PrintStream stream$1, RawMetaProperties prev) {
        stream$1.println(new StringBuilder(16).append("Found metadata: ").append(prev).toString());
        stream$1.println("");
    }

    public static final /* synthetic */ boolean $anonfun$formatCommand$1(boolean ignoreFormatted$1, String directory) {
        if (!Files.isDirectory(Paths.get(directory, new String[0]), new LinkOption[0]) || !Files.exists(Paths.get(directory, "meta.properties"), new LinkOption[0])) {
            return true;
        }
        if (!ignoreFormatted$1) {
            throw new TerseFailure(new StringBuilder(107).append("Log directory ").append(directory).append(" is already formatted. ").append("Use --ignore-formatted to ignore this directory and format the others.").toString());
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$formatCommand$2(MetaProperties metaProperties$1, MetadataVersion metadataVersion$1, PrintStream stream$2, String directory) {
        try {
            Files.createDirectories(Paths.get(directory, new String[0]), new FileAttribute[0]);
        }
        catch (Throwable e) {
            throw new TerseFailure(new StringBuilder(37).append("Unable to create storage ").append("directory ").append(directory).append(": ").append(e.getMessage()).toString());
        }
        Path metaPropertiesPath = Paths.get(directory, "meta.properties");
        new BrokerMetadataCheckpoint(metaPropertiesPath.toFile()).write(metaProperties$1.toProperties());
        BootstrapMetadata bootstrapMetadata = BootstrapMetadata.fromVersion((MetadataVersion)metadataVersion$1, (String)"format command");
        new BootstrapDirectory(directory, Optional.empty()).writeBinaryFile(bootstrapMetadata);
        stream$2.println(new StringBuilder(35).append("Formatting ").append(directory).append(" with metadata.version ").append(metadataVersion$1).append(".").toString());
    }

    private StorageTool$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

