/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Properties;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.utils.CommandDefaultOptions;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import kafka.utils.VersionInfo$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class CommandLineUtils$
implements Logging {
    public static CommandLineUtils$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new CommandLineUtils$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public boolean isPrintHelpNeeded(CommandDefaultOptions commandOpts) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])commandOpts.args())).isEmpty() || commandOpts.options().has(commandOpts.helpOpt());
    }

    public boolean isPrintVersionNeeded(CommandDefaultOptions commandOpts) {
        return commandOpts.options().has(commandOpts.versionOpt());
    }

    public void printHelpAndExitIfNeeded(CommandDefaultOptions commandOpts, String message) {
        if (this.isPrintHelpNeeded(commandOpts)) {
            throw this.printUsageAndDie(commandOpts.parser(), message);
        }
        if (this.isPrintVersionNeeded(commandOpts)) {
            throw this.printVersionAndDie();
        }
    }

    public void checkRequiredArgs(OptionParser parser, OptionSet options, Seq<OptionSpec<?>> required) {
        required.foreach((Function1 & Serializable & scala.Serializable)arg -> {
            CommandLineUtils$.$anonfun$checkRequiredArgs$1(options, parser, arg);
            return BoxedUnit.UNIT;
        });
    }

    public void checkInvalidArgs(OptionParser parser, OptionSet options, OptionSpec<?> usedOption, Set<OptionSpec<?>> invalidOptions) {
        if (options.has(usedOption)) {
            invalidOptions.foreach((Function1 & Serializable & scala.Serializable)arg -> {
                CommandLineUtils$.$anonfun$checkInvalidArgs$1(options, parser, usedOption, arg);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void checkInvalidArgsSet(OptionParser parser, OptionSet options, Set<OptionSpec<?>> usedOptions, Set<OptionSpec<?>> invalidOptions, Option<String> trailingAdditionalMessage) {
        if (usedOptions.count((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)options.has(x$1))) == usedOptions.size()) {
            invalidOptions.foreach((Function1 & Serializable & scala.Serializable)arg -> {
                CommandLineUtils$.$anonfun$checkInvalidArgsSet$2(options, parser, usedOptions, trailingAdditionalMessage, arg);
                return BoxedUnit.UNIT;
            });
        }
    }

    public Option<String> checkInvalidArgsSet$default$5() {
        return None$.MODULE$;
    }

    public Nothing$ printUsageAndDie(OptionParser parser, String message) {
        System.err.println(message);
        parser.printHelpOn((OutputStream)System.err);
        return Exit$.MODULE$.exit(1, (Option<String>)new Some((Object)message));
    }

    public Nothing$ printVersionAndDie() {
        System.out.println(VersionInfo$.MODULE$.getVersionString());
        return Exit$.MODULE$.exit(0, Exit$.MODULE$.exit$default$2());
    }

    public Properties parseKeyValueArgs(Iterable<String> args, boolean acceptMissingValue) {
        Iterable splits = (Iterable)((TraversableLike)args.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.split("=", 2), Iterable$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)CommandLineUtils$.$anonfun$parseKeyValueArgs$2(x$2)));
        Properties props = new Properties();
        splits.foreach((Function1 & Serializable & scala.Serializable)a -> {
            if (((String[])a).length == 1 || ((String[])a).length == 2 && a[1].isEmpty()) {
                if (acceptMissingValue) {
                    return props.put(a[0], "");
                }
                throw new IllegalArgumentException(new StringBuilder(22).append("Missing value for key ").append(a[0]).toString());
            }
            return props.put(a[0], a[1]);
        });
        return props;
    }

    public boolean parseKeyValueArgs$default$2() {
        return true;
    }

    public <V> void maybeMergeOptions(Properties props, String key, OptionSet options, OptionSpec<V> spec) {
        if (options.has(spec) || !props.containsKey(key)) {
            Object value = options.valueOf(spec);
            if (value == null) {
                props.remove(key);
                return;
            }
            props.put(key, value.toString());
        }
    }

    public static final /* synthetic */ void $anonfun$checkRequiredArgs$1(OptionSet options$1, OptionParser parser$1, OptionSpec arg) {
        if (!options$1.has(arg)) {
            throw MODULE$.printUsageAndDie(parser$1, new StringBuilder(28).append("Missing required argument \"").append(arg).append("\"").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$checkInvalidArgs$1(OptionSet options$2, OptionParser parser$2, OptionSpec usedOption$1, OptionSpec arg) {
        if (options$2.has(arg)) {
            throw MODULE$.printUsageAndDie(parser$2, new StringBuilder(38).append("Option \"").append(usedOption$1).append("\" can't be used with option \"").append(arg).append("\"").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$checkInvalidArgsSet$2(OptionSet options$3, OptionParser parser$3, Set usedOptions$1, Option trailingAdditionalMessage$1, OptionSpec arg) {
        if (options$3.has(arg)) {
            throw MODULE$.printUsageAndDie(parser$3, new StringBuilder(50).append("Option combination \"").append(usedOptions$1.mkString(",")).append("\" can't be used with option \"").append(arg).append("\"").append(trailingAdditionalMessage$1.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$parseKeyValueArgs$2(String[] x$2) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$2)).isEmpty();
    }

    private CommandLineUtils$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

