/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.server.RequestLocal$;
import kafka.server.metadata.BrokerMetadataPublisher$;
import kafka.server.metadata.DynamicClientQuotaPublisher;
import kafka.server.metadata.DynamicConfigPublisher;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.server.metadata.ScramPublisher;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.coordinator.group.GroupCoordinator;
import org.apache.kafka.image.FeaturesDelta;
import org.apache.kafka.image.LocalReplicaChanges;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicDelta;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsDelta;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.authorizer.ClusterMetadataAuthorizer;
import org.apache.kafka.metadata.authorizer.StandardAcl;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.fault.FaultHandler;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\t]t!B\u0013'\u0011\u0003ic!B\u0018'\u0011\u0003\u0001\u0004\"B\u001f\u0002\t\u0003q\u0004\"B \u0002\t\u0003\u0001\u0005\"\u00024\u0002\t\u00039g!B\u0018'\u0001\u0005U\u0001BCA\u001a\u000b\t\u0005\t\u0015!\u0003\u00026!Q\u0011QH\u0003\u0003\u0002\u0003\u0006I!a\u0010\t\u0015\u0005\u0015SA!A!\u0002\u0013\t9\u0005\u0003\u0006\u0002N\u0015\u0011\t\u0011)A\u0005\u0003\u001fB!\"!\u0016\u0006\u0005\u0003\u0005\u000b\u0011BA,\u0011)\t9'\u0002B\u0001B\u0003%\u0011\u0011\u000e\u0005\u000b\u0003o*!\u00111A\u0005\u0002\u0005e\u0004BCAA\u000b\t\u0005\r\u0011\"\u0001\u0002\u0004\"Q\u0011qR\u0003\u0003\u0002\u0003\u0006K!a\u001f\t\u0015\u0005EUA!A!\u0002\u0013\t\u0019\n\u0003\u0006\u0002\u001a\u0016\u0011\t\u0011)A\u0005\u00037C!\"!)\u0006\u0005\u000b\u0007I\u0011BAR\u0011)\t),\u0002B\u0001B\u0003%\u0011Q\u0015\u0005\u000b\u0003o+!\u0011!Q\u0001\n\u0005e\u0006BCAc\u000b\t\u0005\t\u0015!\u0003\u0002:\"1Q(\u0002C\u0001\u0003\u000fD\u0001\u0002_\u0003C\u0002\u0013\u0005\u00111\u001d\u0005\b\u0003K,\u0001\u0015!\u0003z\u0011%\t9/\u0002a\u0001\n\u0003\tI\u000fC\u0005\u0002r\u0016\u0001\r\u0011\"\u0001\u0002t\"A\u0011q_\u0003!B\u0013\tY\u000fC\u0005\u0002z\u0016\u0011\r\u0011\"\u0001\u0002|\"A!1C\u0003!\u0002\u0013\ti\u0010C\u0004\u0003\u0016\u0015!\tEa\u0006\t\u000f\teQ\u0001\"\u0011\u0003\u001c!9!\u0011G\u0003\u0005\n\tM\u0002b\u0002B\"\u000b\u0011\u0005!Q\t\u0005\b\u0005#*A\u0011\u0001B*\u0011\u001d\u0011Y'\u0002C\u0005\u0005[BqAa\u001c\u0006\t\u0013\u0011\t\bC\u0004\u0003v\u0015!\tE!\u001c\u0002/\t\u0013xn[3s\u001b\u0016$\u0018\rZ1uCB+(\r\\5tQ\u0016\u0014(BA\u0014)\u0003!iW\r^1eCR\f'BA\u0015+\u0003\u0019\u0019XM\u001d<fe*\t1&A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u00059\nQ\"\u0001\u0014\u0003/\t\u0013xn[3s\u001b\u0016$\u0018\rZ1uCB+(\r\\5tQ\u0016\u00148cA\u00012oA\u0011!'N\u0007\u0002g)\tA'A\u0003tG\u0006d\u0017-\u0003\u00027g\t1\u0011I\\=SK\u001a\u0004\"\u0001O\u001e\u000e\u0003eR!A\u000f\u0016\u0002\u000bU$\u0018\u000e\\:\n\u0005qJ$a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00035\nQbZ3u)>\u0004\u0018n\u0019#fYR\fG\u0003B!P9\u0006\u00042A\r\"E\u0013\t\u00195G\u0001\u0004PaRLwN\u001c\t\u0003\u000b6k\u0011A\u0012\u0006\u0003\u000f\"\u000bQ![7bO\u0016T!aK%\u000b\u0005)[\u0015AB1qC\u000eDWMC\u0001M\u0003\ry'oZ\u0005\u0003\u001d\u001a\u0013!\u0002V8qS\u000e$U\r\u001c;b\u0011\u0015\u00016\u00011\u0001R\u0003%!x\u000e]5d\u001d\u0006lW\r\u0005\u0002S3:\u00111k\u0016\t\u0003)Nj\u0011!\u0016\u0006\u0003-2\na\u0001\u0010:p_Rt\u0014B\u0001-4\u0003\u0019\u0001&/\u001a3fM&\u0011!l\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005a\u001b\u0004\"B/\u0004\u0001\u0004q\u0016\u0001\u00038fo&k\u0017mZ3\u0011\u0005\u0015{\u0016B\u00011G\u00055iU\r^1eCR\f\u0017*\\1hK\")!m\u0001a\u0001G\u0006)A-\u001a7uCB\u0011Q\tZ\u0005\u0003K\u001a\u0013Q\"T3uC\u0012\fG/\u0019#fYR\f\u0017a\u00054j]\u0012\u001cFO]1z!\u0006\u0014H/\u001b;j_:\u001cH#\u00025xy\u0006\r\u0001cA5oc:\u0011!\u000e\u001c\b\u0003).L\u0011\u0001N\u0005\u0003[N\nq\u0001]1dW\u0006<W-\u0003\u0002pa\nA\u0011\n^3sC\ndWM\u0003\u0002ngA\u0011!/^\u0007\u0002g*\u0011A\u000fS\u0001\u0007G>lWn\u001c8\n\u0005Y\u001c(A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u0006q\u0012\u0001\r!_\u0001\tEJ|7.\u001a:JIB\u0011!G_\u0005\u0003wN\u00121!\u00138u\u0011\u0015iH\u00011\u0001\u007f\u00039qWm\u001e+pa&\u001c7/S7bO\u0016\u0004\"!R@\n\u0007\u0005\u0005aIA\u0006U_BL7m]%nC\u001e,\u0007bBA\u0003\t\u0001\u0007\u0011qA\u0001\u0005Y><7\u000f\u0005\u0003j]\u0006%\u0001\u0003BA\u0006\u0003#i!!!\u0004\u000b\u0007\u0005=!&A\u0002m_\u001eLA!a\u0005\u0002\u000e\tQQK\\5gS\u0016$Gj\\4\u0014\r\u0015\t9\"a\n8!\u0011\tI\"a\t\u000e\u0005\u0005m!\u0002BA\u000f\u0003?\tA\u0001\\1oO*\u0011\u0011\u0011E\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002&\u0005m!AB(cU\u0016\u001cG\u000f\u0005\u0003\u0002*\u0005=RBAA\u0016\u0015\r\tiCR\u0001\naV\u0014G.[:iKJLA!!\r\u0002,\t\tR*\u001a;bI\u0006$\u0018\rU;cY&\u001c\b.\u001a:\u0002\r\r|gNZ5h!\u0011\t9$!\u000f\u000e\u0003!J1!a\u000f)\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u001b5,G/\u00193bi\u0006\u001c\u0015m\u00195f!\rq\u0013\u0011I\u0005\u0004\u0003\u00072#AE&SC\u001a$X*\u001a;bI\u0006$\u0018mQ1dQ\u0016\f!\u0002\\8h\u001b\u0006t\u0017mZ3s!\u0011\tY!!\u0013\n\t\u0005-\u0013Q\u0002\u0002\u000b\u0019><W*\u00198bO\u0016\u0014\u0018A\u0004:fa2L7-Y'b]\u0006<WM\u001d\t\u0005\u0003o\t\t&C\u0002\u0002T!\u0012aBU3qY&\u001c\u0017-T1oC\u001e,'/\u0001\the>,\boQ8pe\u0012Lg.\u0019;peB!\u0011\u0011LA2\u001b\t\tYF\u0003\u0003\u0002^\u0005}\u0013!B4s_V\u0004(bAA1\u0011\u0006Y1m\\8sI&t\u0017\r^8s\u0013\u0011\t)'a\u0017\u0003!\u001d\u0013x.\u001e9D_>\u0014H-\u001b8bi>\u0014\u0018A\u0004;y]\u000e{wN\u001d3j]\u0006$xN\u001d\t\u0005\u0003W\n\u0019(\u0004\u0002\u0002n)!\u0011qNA9\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\u000b\u0007\u0005\u0005$&\u0003\u0003\u0002v\u00055$A\u0006+sC:\u001c\u0018m\u0019;j_:\u001cun\u001c:eS:\fGo\u001c:\u0002-\u0011Lh.Y7jG\u000e{gNZ5h!V\u0014G.[:iKJ,\"!a\u001f\u0011\u00079\ni(C\u0002\u0002\u0000\u0019\u0012a\u0003R=oC6L7mQ8oM&<\u0007+\u001e2mSNDWM]\u0001\u001bIft\u0017-\\5d\u0007>tg-[4Qk\nd\u0017n\u001d5fe~#S-\u001d\u000b\u0005\u0003\u000b\u000bY\tE\u00023\u0003\u000fK1!!#4\u0005\u0011)f.\u001b;\t\u0013\u00055U\"!AA\u0002\u0005m\u0014a\u0001=%c\u00059B-\u001f8b[&\u001c7i\u001c8gS\u001e\u0004VO\u00197jg\",'\u000fI\u0001\u001cIft\u0017-\\5d\u00072LWM\u001c;Rk>$\u0018\rU;cY&\u001c\b.\u001a:\u0011\u00079\n)*C\u0002\u0002\u0018\u001a\u00121\u0004R=oC6L7m\u00117jK:$\u0018+^8uCB+(\r\\5tQ\u0016\u0014\u0018AD:de\u0006l\u0007+\u001e2mSNDWM\u001d\t\u0004]\u0005u\u0015bAAPM\tq1k\u0019:b[B+(\r\\5tQ\u0016\u0014\u0018aC0bkRDwN]5{KJ,\"!!*\u0011\tI\u0012\u0015q\u0015\t\u0005\u0003S\u000b\t,\u0004\u0002\u0002,*!\u0011QVAX\u0003)\tW\u000f\u001e5pe&TXM\u001d\u0006\u0003S!KA!a-\u0002,\nQ\u0011)\u001e;i_JL'0\u001a:\u0002\u0019}\u000bW\u000f\u001e5pe&TXM\u001d\u0011\u0002#\u0019\fG/\u00197GCVdG\u000fS1oI2,'\u000f\u0005\u0003\u0002<\u0006\u0005WBAA_\u0015\u0011\ty,a,\u0002\u000b\u0019\fW\u000f\u001c;\n\t\u0005\r\u0017Q\u0018\u0002\r\r\u0006,H\u000e\u001e%b]\u0012dWM]\u0001\u001f[\u0016$\u0018\rZ1uCB+(\r\\5tQ&twMR1vYRD\u0015M\u001c3mKJ$\"$!3\u0002L\u00065\u0017qZAi\u0003'\f).a6\u0002Z\u0006m\u0017Q\\Ap\u0003C\u0004\"AL\u0003\t\u000f\u0005MR\u00031\u0001\u00026!9\u0011QH\u000bA\u0002\u0005}\u0002bBA#+\u0001\u0007\u0011q\t\u0005\b\u0003\u001b*\u0002\u0019AA(\u0011\u001d\t)&\u0006a\u0001\u0003/Bq!a\u001a\u0016\u0001\u0004\tI\u0007C\u0004\u0002xU\u0001\r!a\u001f\t\u000f\u0005EU\u00031\u0001\u0002\u0014\"9\u0011\u0011T\u000bA\u0002\u0005m\u0005bBAQ+\u0001\u0007\u0011Q\u0015\u0005\b\u0003o+\u0002\u0019AA]\u0011\u001d\t)-\u0006a\u0001\u0003s+\u0012!_\u0001\nEJ|7.\u001a:JI\u0002\nQb\u00184jeN$\b+\u001e2mSNDWCAAv!\r\u0011\u0014Q^\u0005\u0004\u0003_\u001c$a\u0002\"p_2,\u0017M\\\u0001\u0012?\u001aL'o\u001d;Qk\nd\u0017n\u001d5`I\u0015\fH\u0003BAC\u0003kD\u0011\"!$\u001a\u0003\u0003\u0005\r!a;\u0002\u001d}3\u0017N]:u!V\u0014G.[:iA\u0005\u0011b-\u001b:tiB+(\r\\5tQ\u001a+H/\u001e:f+\t\ti\u0010\u0005\u0004\u0002\u0000\n%!QB\u0007\u0003\u0005\u0003QAAa\u0001\u0003\u0006\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\t\u001d\u0011qD\u0001\u0005kRLG.\u0003\u0003\u0003\f\t\u0005!!E\"p[BdW\r^1cY\u00164U\u000f^;sKB!\u0011\u0011\u0004B\b\u0013\u0011\u0011\t\"a\u0007\u0003\tY{\u0017\u000eZ\u0001\u0014M&\u00148\u000f\u001e)vE2L7\u000f\u001b$viV\u0014X\rI\u0001\u0005]\u0006lW\rF\u0001R\u0003Ayg.T3uC\u0012\fG/Y+qI\u0006$X\r\u0006\u0005\u0002\u0006\nu!q\u0004B\u0011\u0011\u0015\u0011g\u00041\u0001d\u0011\u0015if\u00041\u0001_\u0011\u001d\u0011\u0019C\ba\u0001\u0005K\t\u0001\"\\1oS\u001a,7\u000f\u001e\t\u0005\u0005O\u0011i#\u0004\u0002\u0003*)\u0019!1\u0006$\u0002\r1|\u0017\rZ3s\u0013\u0011\u0011yC!\u000b\u0003\u001d1{\u0017\rZ3s\u001b\u0006t\u0017NZ3ti\u0006iAo\\(qi&|g.\u00197J]R$BA!\u000e\u0003>A!!q\u0007B\u001d\u001b\t\u0011)!\u0003\u0003\u0003<\t\u0015!aC(qi&|g.\u00197J]RDqAa\u0010 \u0001\u0004\u0011\t%\u0001\u0004paRLwN\u001c\t\u0004e\tK\u0018!\n:fY>\fG-\u00169eCR,GMR5mKN<\u0016\u000e\u001e5pkR\u001cuN\u001c4jO\u000eC\u0017M\\4f)\u0011\t)Ia\u0012\t\u000f\t%\u0003\u00051\u0001\u0003L\u0005)\u0001O]8qgB!!q\u0007B'\u0013\u0011\u0011yE!\u0002\u0003\u0015A\u0013x\u000e]3si&,7/A\tva\u0012\fG/Z\"p_J$\u0017N\\1u_J$B\"!\"\u0003V\t]#\u0011\fB.\u0005KBQaR\u0011A\u0002yCQAY\u0011A\u0002\rDQ\u0001U\u0011A\u0002ECqA!\u0018\"\u0001\u0004\u0011y&\u0001\u0005fY\u0016\u001cG/[8o!\u001d\u0011$\u0011M=z\u0003\u000bK1Aa\u00194\u0005%1UO\\2uS>t'\u0007C\u0004\u0003h\u0005\u0002\rA!\u001b\u0002\u0017I,7/[4oCRLwN\u001c\t\te\t\u0005\u0014P!\u0011\u0002\u0006\u0006\u0011\u0012N\\5uS\u0006d\u0017N_3NC:\fw-\u001a:t)\t\t))\u0001\u0011gS:L7\u000f[%oSRL\u0017\r\\5{S:<'+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014H\u0003BAC\u0005gBQ!X\u0012A\u0002y\u000bQa\u00197pg\u0016\u0004")
public class BrokerMetadataPublisher
implements MetadataPublisher,
Logging {
    private final KafkaConfig config;
    private final KRaftMetadataCache metadataCache;
    private final LogManager logManager;
    private final ReplicaManager replicaManager;
    private final GroupCoordinator groupCoordinator;
    private final TransactionCoordinator txnCoordinator;
    private DynamicConfigPublisher dynamicConfigPublisher;
    private final DynamicClientQuotaPublisher dynamicClientQuotaPublisher;
    private final ScramPublisher scramPublisher;
    private final Option<Authorizer> _authorizer;
    private final FaultHandler fatalFaultHandler;
    private final FaultHandler metadataPublishingFaultHandler;
    private final int brokerId;
    private boolean _firstPublish;
    private final CompletableFuture<Void> firstPublishFuture;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Iterable<TopicPartition> findStrayPartitions(int n, TopicsImage topicsImage, Iterable<UnifiedLog> iterable) {
        return BrokerMetadataPublisher$.MODULE$.findStrayPartitions(n, topicsImage, iterable);
    }

    public static Option<TopicDelta> getTopicDelta(String string, MetadataImage metadataImage, MetadataDelta metadataDelta) {
        return BrokerMetadataPublisher$.MODULE$.getTopicDelta(string, metadataImage, metadataDelta);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public void onControllerChange(LeaderAndEpoch x$1) {
        super.onControllerChange(x$1);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public DynamicConfigPublisher dynamicConfigPublisher() {
        return this.dynamicConfigPublisher;
    }

    public void dynamicConfigPublisher_$eq(DynamicConfigPublisher x$1) {
        this.dynamicConfigPublisher = x$1;
    }

    private Option<Authorizer> _authorizer() {
        return this._authorizer;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public boolean _firstPublish() {
        return this._firstPublish;
    }

    public void _firstPublish_$eq(boolean x$1) {
        this._firstPublish = x$1;
    }

    public CompletableFuture<Void> firstPublishFuture() {
        return this.firstPublishFuture;
    }

    public String name() {
        return "BrokerMetadataPublisher";
    }

    public void onMetadataUpdate(MetadataDelta delta, MetadataImage newImage, LoaderManifest manifest) {
        OffsetAndEpoch highestOffsetAndEpoch = newImage.highestOffsetAndEpoch();
        String deltaName = this._firstPublish() ? new StringBuilder(28).append("initial MetadataDelta up to ").append(highestOffsetAndEpoch.offset()).toString() : new StringBuilder(20).append("MetadataDelta up to ").append(highestOffsetAndEpoch.offset()).toString();
        try {
            try {
                if (this.isTraceEnabled()) {
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Publishing delta ").append(delta).append(" with highest offset ").append(highestOffsetAndEpoch).toString());
                }
                this.metadataCache.setImage(newImage);
                String metadataVersionLogMsg = new StringBuilder(17).append("metadata.version ").append(newImage.features().metadataVersion()).toString();
                if (this._firstPublish()) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Publishing initial metadata at offset ").append(highestOffsetAndEpoch).append(" with ").append(metadataVersionLogMsg).append(".").toString());
                    this.initializeManagers();
                } else if (this.isDebugEnabled()) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Publishing metadata at offset ").append(highestOffsetAndEpoch).append(" with ").append(metadataVersionLogMsg).append(".").toString());
                }
                Option$.MODULE$.apply((Object)delta.featuresDelta()).foreach((Function1 & Serializable & scala.Serializable)featuresDelta -> {
                    BrokerMetadataPublisher.$anonfun$onMetadataUpdate$4(this, highestOffsetAndEpoch, featuresDelta);
                    return BoxedUnit.UNIT;
                });
                Option$.MODULE$.apply((Object)delta.topicsDelta()).foreach((Function1 & Serializable & scala.Serializable)topicsDelta -> {
                    RuntimeException runtimeException;
                    try {
                        $this.replicaManager.applyDelta((TopicsDelta)topicsDelta, newImage);
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(31).append("Error applying topics ").append("delta in ").append(deltaName).toString(), t);
                    }
                    try {
                        this.updateCoordinator(newImage, delta, "__consumer_offsets", (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(x$1, x$2) -> $this.groupCoordinator.onElection(x$1, x$2), (Function2<Object, Option<Object>, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(partitionIndex, leaderEpochOpt) -> {
                            this.groupCoordinator.onResignation(BoxesRunTime.unboxToInt((Object)partitionIndex), this.toOptionalInt((Option<Object>)leaderEpochOpt));
                            return BoxedUnit.UNIT;
                        });
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(55).append("Error updating group ").append("coordinator with local changes in ").append(deltaName).toString(), t);
                    }
                    try {
                        this.updateCoordinator(newImage, delta, "__transaction_state", (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(txnTopicPartitionId, coordinatorEpoch) -> $this.txnCoordinator.onElection(txnTopicPartitionId, coordinatorEpoch), (Function2<Object, Option<Object>, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(txnTopicPartitionId, coordinatorEpoch) -> {
                            this.txnCoordinator.onResignation(BoxesRunTime.unboxToInt((Object)txnTopicPartitionId), (Option<Object>)coordinatorEpoch);
                            return BoxedUnit.UNIT;
                        });
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(53).append("Error updating txn ").append("coordinator with local changes in ").append(deltaName).toString(), t);
                    }
                    try {
                        ArrayBuffer deletedTopicPartitions = new ArrayBuffer();
                        topicsDelta.deletedTopicIds().forEach(id2 -> {
                            TopicImage topicImage = topicsDelta.image().getTopic(id2);
                            topicImage.partitions().keySet().forEach(id -> deletedTopicPartitions.$plus$eq((Object)new TopicPartition(topicImage.name(), Predef$.MODULE$.Integer2int(id))));
                        });
                        if (!deletedTopicPartitions.nonEmpty()) {
                            return BoxedUnit.UNIT;
                        }
                        $this.groupCoordinator.onPartitionsDeleted((List)CollectionConverters$.MODULE$.bufferAsJavaListConverter((Buffer)deletedTopicPartitions).asJava(), RequestLocal$.MODULE$.NoCaching().bufferSupplier());
                        runtimeException = BoxedUnit.UNIT;
                    }
                    catch (Throwable t) {
                        runtimeException = $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(60).append("Error updating group ").append("coordinator with deleted partitions in ").append(deltaName).toString(), t);
                    }
                    return runtimeException;
                });
                this.dynamicConfigPublisher().onMetadataUpdate(delta, newImage);
                this.dynamicClientQuotaPublisher.onMetadataUpdate(delta, newImage);
                this.scramPublisher.onMetadataUpdate(delta, newImage);
                Option$.MODULE$.apply((Object)delta.aclsDelta()).foreach((Function1 & Serializable & scala.Serializable)aclsDelta -> {
                    BoxedUnit boxedUnit;
                    Authorizer authorizer;
                    Option<Authorizer> option = this._authorizer();
                    if (option instanceof Some && (authorizer = (Authorizer)((Some)option).value()) instanceof ClusterMetadataAuthorizer) {
                        Object object;
                        ClusterMetadataAuthorizer clusterMetadataAuthorizer = (ClusterMetadataAuthorizer)authorizer;
                        if (aclsDelta.isSnapshotDelta()) {
                            try {
                                clusterMetadataAuthorizer.loadSnapshot(newImage.acls().acls());
                                object = BoxedUnit.UNIT;
                            }
                            catch (Throwable t) {
                                object = $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(37).append("Error loading ").append("authorizer snapshot in ").append(deltaName).toString(), t);
                            }
                        } else {
                            try {
                                aclsDelta.changes().entrySet().forEach(e -> {
                                    if (((Optional)e.getValue()).isPresent()) {
                                        clusterMetadataAuthorizer.addAcl((Uuid)e.getKey(), (StandardAcl)((Optional)e.getValue()).get());
                                        return;
                                    }
                                    clusterMetadataAuthorizer.removeAcl((Uuid)e.getKey());
                                });
                                object = BoxedUnit.UNIT;
                            }
                            catch (Throwable t) {
                                object = $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(36).append("Error loading ").append("authorizer changes in ").append(deltaName).toString(), t);
                            }
                        }
                        boxedUnit = object;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return boxedUnit;
                });
                try {
                    this.groupCoordinator.onNewMetadataImage(newImage, delta);
                }
                catch (Throwable t) {
                    this.metadataPublishingFaultHandler.handleFault(new StringBuilder(55).append("Error updating group ").append("coordinator with local changes in ").append(deltaName).toString(), t);
                }
                if (this._firstPublish()) {
                    this.finishInitializingReplicaManager(newImage);
                }
            }
            catch (Throwable t) {
                this.metadataPublishingFaultHandler.handleFault(new StringBuilder(57).append("Uncaught exception while ").append("publishing broker metadata from ").append(deltaName).toString(), t);
            }
        }
        finally {
            this._firstPublish_$eq(false);
            this.firstPublishFuture().complete(null);
        }
    }

    private OptionalInt toOptionalInt(Option<Object> option) {
        OptionalInt optionalInt;
        if (option instanceof Some) {
            optionalInt = OptionalInt.of(BoxesRunTime.unboxToInt((Object)((Some)option).value()));
        } else if (None$.MODULE$.equals(option)) {
            optionalInt = OptionalInt.empty();
        } else {
            throw new MatchError(option);
        }
        return optionalInt;
    }

    public void reloadUpdatedFilesWithoutConfigChange(Properties props) {
        this.config.dynamicConfig().reloadUpdatedFilesWithoutConfigChange(props);
    }

    public void updateCoordinator(MetadataImage image, MetadataDelta delta, String topicName, Function2<Object, Object, BoxedUnit> election, Function2<Object, Option<Object>, BoxedUnit> resignation) {
        Option$.MODULE$.apply((Object)delta.topicsDelta()).foreach((Function1 & Serializable & scala.Serializable)topicsDelta -> {
            if (topicsDelta.topicWasDeleted(topicName)) {
                topicsDelta.image().getTopic(topicName).partitions().entrySet().forEach(entry -> {
                    if (((PartitionRegistration)entry.getValue()).leader == this.brokerId()) {
                        resignation.apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int((Integer)entry.getKey())), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)((PartitionRegistration)entry.getValue()).leaderEpoch)));
                    }
                });
            }
            return BoxedUnit.UNIT;
        });
        BrokerMetadataPublisher$.MODULE$.getTopicDelta(topicName, image, delta).foreach((Function1 & Serializable & scala.Serializable)topicDelta -> {
            LocalReplicaChanges $anonfun$updateCoordinator$3_changes = topicDelta.localChanges(this.brokerId());
            $anonfun$updateCoordinator$3_changes.deletes().forEach(topicPartition -> resignation.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()), (Object)None$.MODULE$));
            $anonfun$updateCoordinator$3_changes.leaders().forEach((topicPartition, partitionInfo) -> election.apply$mcVII$sp(topicPartition.partition(), partitionInfo.partition().leaderEpoch));
            $anonfun$updateCoordinator$3_changes.followers().forEach((topicPartition, partitionInfo) -> resignation.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)partitionInfo.partition().leaderEpoch))));
            return BoxedUnit.UNIT;
        });
    }

    private void initializeManagers() {
        try {
            this.logManager.startup(this.metadataCache.getAllTopics());
            Option$.MODULE$.apply((Object)this.logManager.cleaner()).foreach((Function1 & Serializable & scala.Serializable)reconfigurable -> {
                BrokerMetadataPublisher.$anonfun$initializeManagers$1(this, reconfigurable);
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting LogManager", t);
        }
        try {
            this.replicaManager.startup();
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting ReplicaManager", t);
        }
        try {
            this.groupCoordinator.startup(() -> BoxesRunTime.unboxToInt((Object)$this.metadataCache.numPartitions("__consumer_offsets").getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Predef$.MODULE$.Integer2int($this.config.offsetsTopicPartitions()))));
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting GroupCoordinator", t);
        }
        try {
            this.txnCoordinator.startup((Function0<Object>)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)$this.metadataCache.numPartitions("__transaction_state").getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Predef$.MODULE$.Integer2int($this.config.transactionTopicPartitions()))), this.txnCoordinator.startup$default$2());
            return;
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting TransactionCoordinator", t);
            return;
        }
    }

    private void finishInitializingReplicaManager(MetadataImage newImage) {
        try {
            Iterable<TopicPartition> strayPartitions = BrokerMetadataPublisher$.MODULE$.findStrayPartitions(this.brokerId(), newImage.topics(), this.logManager.allLogs());
            if (strayPartitions.nonEmpty()) {
                this.replicaManager.deleteStrayReplicas(strayPartitions);
            }
        }
        catch (Throwable t) {
            this.metadataPublishingFaultHandler.handleFault("Error deleting stray partitions during startup", t);
        }
        try {
            this.replicaManager.startHighWatermarkCheckPointThread();
            return;
        }
        catch (Throwable t) {
            this.metadataPublishingFaultHandler.handleFault("Error starting high watermark checkpoint thread during startup", t);
            return;
        }
    }

    public void close() {
        this.firstPublishFuture().completeExceptionally(new TimeoutException());
    }

    public static final /* synthetic */ void $anonfun$onMetadataUpdate$4(BrokerMetadataPublisher $this, OffsetAndEpoch highestOffsetAndEpoch$1, FeaturesDelta featuresDelta) {
        featuresDelta.metadataVersionChange().ifPresent(metadataVersion -> $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Updating metadata.version to ").append(metadataVersion.featureLevel()).append(" at offset ").append(highestOffsetAndEpoch$1).append(".").toString()));
    }

    public static final /* synthetic */ void $anonfun$updateCoordinator$1(BrokerMetadataPublisher $this, String topicName$1, Function2 resignation$1, TopicsDelta topicsDelta) {
        if (topicsDelta.topicWasDeleted(topicName$1)) {
            topicsDelta.image().getTopic(topicName$1).partitions().entrySet().forEach(entry -> {
                if (((PartitionRegistration)entry.getValue()).leader == this.brokerId()) {
                    resignation.apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int((Integer)entry.getKey())), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)((PartitionRegistration)entry.getValue()).leaderEpoch)));
                }
            });
        }
    }

    public static final /* synthetic */ void $anonfun$updateCoordinator$3(BrokerMetadataPublisher $this, Function2 resignation$1, Function2 election$1, TopicDelta topicDelta) {
        LocalReplicaChanges changes = topicDelta.localChanges($this.brokerId());
        changes.deletes().forEach(topicPartition -> resignation.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()), (Object)None$.MODULE$));
        changes.leaders().forEach((topicPartition, partitionInfo) -> election.apply$mcVII$sp(topicPartition.partition(), partitionInfo.partition().leaderEpoch));
        changes.followers().forEach((topicPartition, partitionInfo) -> resignation.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)partitionInfo.partition().leaderEpoch))));
    }

    public static final /* synthetic */ void $anonfun$initializeManagers$1(BrokerMetadataPublisher $this, BrokerReconfigurable reconfigurable) {
        $this.config.dynamicConfig().addBrokerReconfigurable(reconfigurable);
    }

    public BrokerMetadataPublisher(KafkaConfig config, KRaftMetadataCache metadataCache, LogManager logManager, ReplicaManager replicaManager, GroupCoordinator groupCoordinator, TransactionCoordinator txnCoordinator, DynamicConfigPublisher dynamicConfigPublisher, DynamicClientQuotaPublisher dynamicClientQuotaPublisher, ScramPublisher scramPublisher, Option<Authorizer> _authorizer, FaultHandler fatalFaultHandler, FaultHandler metadataPublishingFaultHandler) {
        this.config = config;
        this.metadataCache = metadataCache;
        this.logManager = logManager;
        this.replicaManager = replicaManager;
        this.groupCoordinator = groupCoordinator;
        this.txnCoordinator = txnCoordinator;
        this.dynamicConfigPublisher = dynamicConfigPublisher;
        this.dynamicClientQuotaPublisher = dynamicClientQuotaPublisher;
        this.scramPublisher = scramPublisher;
        this._authorizer = _authorizer;
        this.fatalFaultHandler = fatalFaultHandler;
        this.metadataPublishingFaultHandler = metadataPublishingFaultHandler;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(30).append("[BrokerMetadataPublisher id=").append(config.nodeId()).append("] ").toString());
        this.brokerId = config.nodeId();
        this._firstPublish = true;
        this.firstPublishFuture = new CompletableFuture();
    }
}

