/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.server.BrokerReconfigurable;
import kafka.server.DynamicThreadPool$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import scala.Predef$;
import scala.collection.Set;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00013AAB\u0004\u0001\u0019!A\u0001\u0002\u0001B\u0001B\u0003%q\u0003C\u0003\u001b\u0001\u0011\u00051\u0004C\u0003\u001f\u0001\u0011\u0005s\u0004C\u00032\u0001\u0011\u0005#\u0007C\u0003<\u0001\u0011\u0005CHA\fCe>\\WM\u001d#z]\u0006l\u0017n\u0019+ie\u0016\fG\rU8pY*\u0011\u0001\"C\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003)\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u001bM\u0001\"AD\t\u000e\u0003=Q\u0011\u0001E\u0001\u0006g\u000e\fG.Y\u0005\u0003%=\u0011a!\u00118z%\u00164\u0007C\u0001\u000b\u0016\u001b\u00059\u0011B\u0001\f\b\u0005Q\u0011%o\\6feJ+7m\u001c8gS\u001e,(/\u00192mKB\u0011A\u0003G\u0005\u00033\u001d\u00111bS1gW\u0006\u0014%o\\6fe\u00061A(\u001b8jiz\"\"\u0001H\u000f\u0011\u0005Q\u0001\u0001\"\u0002\u0005\u0003\u0001\u00049\u0012!\u0006:fG>tg-[4ve\u0006\u0014G.Z\"p]\u001aLwm]\u000b\u0002AA\u0019\u0011\u0005\n\u0014\u000e\u0003\tR!aI\b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002&E\t\u00191+\u001a;\u0011\u0005\u001drcB\u0001\u0015-!\tIs\"D\u0001+\u0015\tY3\"\u0001\u0004=e>|GOP\u0005\u0003[=\ta\u0001\u0015:fI\u00164\u0017BA\u00181\u0005\u0019\u0019FO]5oO*\u0011QfD\u0001\u0018m\u0006d\u0017\u000eZ1uKJ+7m\u001c8gS\u001e,(/\u0019;j_:$\"a\r\u001c\u0011\u00059!\u0014BA\u001b\u0010\u0005\u0011)f.\u001b;\t\u000b]\"\u0001\u0019\u0001\u001d\u0002\u00139,woQ8oM&<\u0007C\u0001\u000b:\u0013\tQtAA\u0006LC\u001a\\\u0017mQ8oM&<\u0017a\u0003:fG>tg-[4ve\u0016$2aM\u001f@\u0011\u0015qT\u00011\u00019\u0003%yG\u000eZ\"p]\u001aLw\rC\u00038\u000b\u0001\u0007\u0001\b")
public class BrokerDynamicThreadPool
implements BrokerReconfigurable {
    private final KafkaBroker server;

    @Override
    public Set<String> reconfigurableConfigs() {
        return DynamicThreadPool$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        DynamicThreadPool$.MODULE$.validateReconfiguration(this.server.config(), newConfig);
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        Integer n = newConfig.numIoThreads();
        Integer n2 = oldConfig.numIoThreads();
        if (n == null ? n2 != null : !((Object)n).equals(n2)) {
            this.server.dataPlaneRequestHandlerPool().resizeThreadPool(Predef$.MODULE$.Integer2int(newConfig.numIoThreads()));
        }
        Integer n3 = newConfig.numReplicaFetchers();
        Integer n4 = oldConfig.numReplicaFetchers();
        if (n3 == null ? n4 != null : !((Object)n3).equals(n4)) {
            this.server.replicaManager().resizeFetcherThreadPool(Predef$.MODULE$.Integer2int(newConfig.numReplicaFetchers()));
        }
        Integer n5 = newConfig.numRecoveryThreadsPerDataDir();
        Integer n6 = oldConfig.numRecoveryThreadsPerDataDir();
        if (n5 == null ? n6 != null : !((Object)n5).equals(n6)) {
            this.server.logManager().resizeRecoveryThreadPool(Predef$.MODULE$.Integer2int(newConfig.numRecoveryThreadsPerDataDir()));
        }
        Integer n7 = newConfig.backgroundThreads();
        Integer n8 = oldConfig.backgroundThreads();
        if (n7 == null ? n8 != null : !((Object)n7).equals(n8)) {
            this.server.kafkaScheduler().resizeThreadPool(Predef$.MODULE$.Integer2int(newConfig.backgroundThreads()));
        }
    }

    public BrokerDynamicThreadPool(KafkaBroker server) {
        this.server = server;
    }
}

