/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.coordinator.transaction.BaseKey;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionPartitionAndLeaderEpoch;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionState$;
import kafka.coordinator.transaction.TransactionStateManager$;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.coordinator.transaction.TransactionalIdCoordinatorEpochAndMetadata;
import kafka.coordinator.transaction.TransactionalIdCoordinatorEpochAndTransitMetadata;
import kafka.coordinator.transaction.TxnKey;
import kafka.coordinator.transaction.TxnMetadataCacheEntry;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.coordinator.transaction.UnknownKey;
import kafka.log.UnifiedLog;
import kafka.server.ActionQueue;
import kafka.server.ReplicaManager;
import kafka.server.RequestLocal;
import kafka.server.RequestLocal$;
import kafka.utils.CoreUtils$;
import kafka.utils.Implicits$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.ListTransactionsResponseData;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordConversionStats;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.record.BrokerCompressionType;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.LogConfig;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\r\u0015u!B!C\u0011\u0003Ie!B&C\u0011\u0003a\u0005\"B*\u0002\t\u0003!\u0006bB+\u0002\u0005\u0004%\tA\u0016\u0005\u00075\u0006\u0001\u000b\u0011B,\t\u000fm\u000b!\u0019!C\u0001-\"1A,\u0001Q\u0001\n]Cq!X\u0001C\u0002\u0013\u0005a\u000b\u0003\u0004_\u0003\u0001\u0006Ia\u0016\u0005\b?\u0006\u0011\r\u0011\"\u0001W\u0011\u0019\u0001\u0017\u0001)A\u0005/\"9\u0011-\u0001b\u0001\n\u0003\u0011\u0007B\u00028\u0002A\u0003%1\rC\u0004p\u0003\t\u0007I\u0011\u00012\t\rA\f\u0001\u0015!\u0003d\r\u0011Y%\tA9\t\u0011a|!\u0011!Q\u0001\n]C\u0001\"_\b\u0003\u0002\u0003\u0006IA\u001f\u0005\u000b\u0003\u001fy!\u0011!Q\u0001\n\u0005E\u0001BCA\u000e\u001f\t\u0005\t\u0015!\u0003\u0002\u001e!Q\u00111E\b\u0003\u0002\u0003\u0006I!!\n\t\u0015\u0005MrB!A!\u0002\u0013\t)\u0004\u0003\u0004T\u001f\u0011\u0005\u0011qH\u0003\u0007\u0003\u001fz\u0001!!\u0015\t\u0013\u0005UtB1A\u0005\n\u0005]\u0004\u0002CAH\u001f\u0001\u0006I!!\u001f\t\u0013\u0005EuB1A\u0005\n\u0005M\u0005\u0002CAQ\u001f\u0001\u0006I!!&\t\u0015\u0005\rvB1A\u0005\u0002\t\u000b)\u000b\u0003\u0005\u0002>>\u0001\u000b\u0011BAT\u0011)\tyl\u0004b\u0001\n\u0003\u0011\u0015\u0011\u0019\u0005\t\u0003\u001f|\u0001\u0015!\u0003\u0002D\"Y\u0011\u0011[\bA\u0002\u0003\u0007I\u0011BAj\u0011-\tYn\u0004a\u0001\u0002\u0004%I!!8\t\u0017\u0005\rx\u00021A\u0001B\u0003&\u0011Q\u001b\u0005\u000b\u0003K|\u0001\u0019!a\u0001\n\u00131\u0006bCAt\u001f\u0001\u0007\t\u0019!C\u0005\u0003SD!\"!<\u0010\u0001\u0004\u0005\t\u0015)\u0003X\u0011%\t9p\u0004b\u0001\n\u0013\tI\u0010\u0003\u0005\u0003\u0002=\u0001\u000b\u0011BA~\u0011!\u0011\u0019a\u0004C\u0001\u0005\n\u0015\u0001b\u0002B\b\u001f\u0011\u0005!\u0011\u0003\u0005\b\u0005WyA\u0011\u0002B\u0017\u0011\u001d\u0011yd\u0004C\u0005\u0005\u0003BqAa\u0016\u0010\t\u0013\u0011I\u0006\u0003\u0005\u0003,=!\tA\u0011B8\u0011\u001d\u0011\th\u0004C\u0005\u0005gBqA!$\u0010\t\u0003\u0011y\u0007C\u0004\u0003\u0010>!\tA!%\t\u000f\tUv\u0002\"\u0001\u00038\"9!QX\b\u0005\u0002\t}\u0006b\u0002Bn\u001f\u0011%!Q\u001c\u0005\b\u0005O|A\u0011\u0001Bu\u0011\u001d\u0011yo\u0004C\u0001\u0005cDqAa?\u0010\t\u0003\u0011i\u0010C\u0004\u0004\u0002=!Iaa\u0001\t\u0011\rEq\u0002\"\u0001C\u0007'Aqaa\b\u0010\t\u0003\u0019\t\u0003C\u0004\u00040=!\ta!\r\t\u000f\r=r\u0002\"\u0001\u00046!911H\b\u0005\n\t=\u0004bBB\u001f\u001f\u0011\u00051q\b\u0005\n\u0007Gz\u0011\u0013!C\u0001\u0007KBqaa\u001f\u0010\t\u0003\u0019i\bC\u0004\u0004\u0004>!\tAa\u001c\u0002/Q\u0013\u0018M\\:bGRLwN\\*uCR,W*\u00198bO\u0016\u0014(BA\"E\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\u000b\u0005\u00153\u0015aC2p_J$\u0017N\\1u_JT\u0011aR\u0001\u0006W\u000647.Y\u0002\u0001!\tQ\u0015!D\u0001C\u0005]!&/\u00198tC\u000e$\u0018n\u001c8Ti\u0006$X-T1oC\u001e,'o\u0005\u0002\u0002\u001bB\u0011a*U\u0007\u0002\u001f*\t\u0001+A\u0003tG\u0006d\u0017-\u0003\u0002S\u001f\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A%\u0002?\u0011+g-Y;miR\u0013\u0018M\\:bGRLwN\\:NCb$\u0016.\\3pkRl5/F\u0001X!\tq\u0005,\u0003\u0002Z\u001f\n\u0019\u0011J\u001c;\u0002A\u0011+g-Y;miR\u0013\u0018M\\:bGRLwN\\:NCb$\u0016.\\3pkRl5\u000fI\u0001#\t\u00164\u0017-\u001e7u)J\fgn]1di&|g.\u00197JI\u0016C\b/\u001b:bi&|g.T:\u0002G\u0011+g-Y;miR\u0013\u0018M\\:bGRLwN\\1m\u0013\u0012,\u0005\u0010]5sCRLwN\\'tA\u0005QC)\u001a4bk2$\u0018IY8siRKW.\u001a3PkR$&/\u00198tC\u000e$\u0018n\u001c8t\u0013:$XM\u001d<bY6\u001b\u0018a\u000b#fM\u0006,H\u000e^!c_J$H+[7fI>+H\u000f\u0016:b]N\f7\r^5p]NLe\u000e^3sm\u0006dWj\u001d\u0011\u0002]\u0011+g-Y;miJ+Wn\u001c<f\u000bb\u0004\u0018N]3e)J\fgn]1di&|g.\u00197JINLe\u000e^3sm\u0006dWj]\u00010\t\u00164\u0017-\u001e7u%\u0016lwN^3FqBL'/\u001a3Ue\u0006t7/Y2uS>t\u0017\r\\%eg&sG/\u001a:wC2l5\u000fI\u0001\r\u001b\u0016$(/[2t\u000fJ|W\u000f]\u000b\u0002GB\u0011Am\u001b\b\u0003K&\u0004\"AZ(\u000e\u0003\u001dT!\u0001\u001b%\u0002\rq\u0012xn\u001c;?\u0013\tQw*\u0001\u0004Qe\u0016$WMZ\u0005\u0003Y6\u0014aa\u0015;sS:<'B\u00016P\u00035iU\r\u001e:jGN<%o\\;qA\u0005qAj\\1e)&lWmU3og>\u0014\u0018a\u0004'pC\u0012$\u0016.\\3TK:\u001cxN\u001d\u0011\u0014\u0007=i%\u000f\u0005\u0002tm6\tAO\u0003\u0002v\r\u0006)Q\u000f^5mg&\u0011q\u000f\u001e\u0002\b\u0019><w-\u001b8h\u0003!\u0011'o\\6fe&#\u0017!C:dQ\u0016$W\u000f\\3s!\rY\u00181B\u0007\u0002y*\u0011QP`\u0001\u0005kRLGNC\u0002\u0000\u0003\u0003\taa]3sm\u0016\u0014(bA$\u0002\u0004)!\u0011QAA\u0004\u0003\u0019\t\u0007/Y2iK*\u0011\u0011\u0011B\u0001\u0004_J<\u0017bAA\u0007y\nI1k\u00195fIVdWM]\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s!\u0011\t\u0019\"a\u0006\u000e\u0005\u0005U!BA@G\u0013\u0011\tI\"!\u0006\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\u000611m\u001c8gS\u001e\u00042ASA\u0010\u0013\r\t\tC\u0011\u0002\u0012)J\fgn]1di&|gnQ8oM&<\u0017\u0001\u0002;j[\u0016\u0004B!a\n\u000205\u0011\u0011\u0011\u0006\u0006\u0004k\u0006-\"\u0002BA\u0017\u0003\u0003\taaY8n[>t\u0017\u0002BA\u0019\u0003S\u0011A\u0001V5nK\u00069Q.\u001a;sS\u000e\u001c\b\u0003BA\u001c\u0003wi!!!\u000f\u000b\t\u0005M\u00121F\u0005\u0005\u0003{\tIDA\u0004NKR\u0014\u0018nY:\u0015\u001d\u0005\u0005\u00131IA#\u0003\u000f\nI%a\u0013\u0002NA\u0011!j\u0004\u0005\u0006qZ\u0001\ra\u0016\u0005\u0006sZ\u0001\rA\u001f\u0005\b\u0003\u001f1\u0002\u0019AA\t\u0011\u001d\tYB\u0006a\u0001\u0003;Aq!a\t\u0017\u0001\u0004\t)\u0003C\u0004\u00024Y\u0001\r!!\u000e\u0003-M+g\u000e\u001a+y]6\u000b'o[3sg\u000e\u000bG\u000e\u001c2bG.\u0004BBTA*/\u0006]\u00131MA5\u0003_J1!!\u0016P\u0005%1UO\\2uS>tG\u0007\u0005\u0003\u0002Z\u0005}SBAA.\u0015\u0011\ti&a\u000b\u0002\u0011I,\u0017/^3tiNLA!!\u0019\u0002\\\t\tBK]1og\u0006\u001cG/[8o%\u0016\u001cX\u000f\u001c;\u0011\u0007)\u000b)'C\u0002\u0002h\t\u00131\u0003\u0016:b]N\f7\r^5p]6+G/\u00193bi\u0006\u00042ASA6\u0013\r\tiG\u0011\u0002\u0013)btGK]1og&$X*\u001a;bI\u0006$\u0018\rE\u0002O\u0003cJ1!a\u001dP\u0005\u0011)f.\u001b;\u0002\u0019MDW\u000f\u001e;j]\u001e$un\u001e8\u0016\u0005\u0005e\u0004\u0003BA>\u0003\u0017k!!! \u000b\t\u0005}\u0014\u0011Q\u0001\u0007CR|W.[2\u000b\t\u0005\r\u0015QQ\u0001\u000bG>t7-\u001e:sK:$(bA?\u0002\b*\u0011\u0011\u0011R\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u000e\u0006u$!D!u_6L7MQ8pY\u0016\fg.A\u0007tQV$H/\u001b8h\t><h\u000eI\u0001\ngR\fG/\u001a'pG.,\"!!&\u0011\t\u0005]\u0015QT\u0007\u0003\u00033SA!a'\u0002\u0002\u0006)An\\2lg&!\u0011qTAM\u0005Y\u0011V-\u001a8ue\u0006tGOU3bI^\u0013\u0018\u000e^3M_\u000e\\\u0017AC:uCR,Gj\\2lA\u0005\tBn\\1eS:<\u0007+\u0019:uSRLwN\\:\u0016\u0005\u0005\u001d\u0006CBAU\u0003g\u000b9,\u0004\u0002\u0002,*!\u0011QVAX\u0003\u001diW\u000f^1cY\u0016T1!!-P\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003k\u000bYKA\u0002TKR\u00042ASA]\u0013\r\tYL\u0011\u0002#)J\fgn]1di&|g\u000eU1si&$\u0018n\u001c8B]\u0012dU-\u00193fe\u0016\u0003xn\u00195\u0002%1|\u0017\rZ5oOB\u000b'\u000f^5uS>t7\u000fI\u0001\u0019iJ\fgn]1di&|g.T3uC\u0012\fG/Y\"bG\",WCAAb!\u001d\tI+!2X\u0003\u0013LA!a2\u0002,\n\u0019Q*\u00199\u0011\u0007)\u000bY-C\u0002\u0002N\n\u0013Q\u0003\u0016=o\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3F]R\u0014\u00180A\rue\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018mQ1dQ\u0016\u0004\u0013A\n:fiJLWM^3Ue\u0006t7/Y2uS>tGk\u001c9jGB\u000b'\u000f^5uS>t7i\\;oiV\u0011\u0011Q\u001b\t\u0005\u001d\u0006]w+C\u0002\u0002Z>\u0013\u0011BR;oGRLwN\u001c\u0019\u0002UI,GO]5fm\u0016$&/\u00198tC\u000e$\u0018n\u001c8U_BL7\rU1si&$\u0018n\u001c8D_VtGo\u0018\u0013fcR!\u0011qNAp\u0011%\t\t/IA\u0001\u0002\u0004\t).A\u0002yIE\nqE]3ue&,g/\u001a+sC:\u001c\u0018m\u0019;j_:$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8uA\u0005qBO]1og\u0006\u001cG/[8o)>\u0004\u0018n\u0019)beRLG/[8o\u0007>,h\u000e^\u0001#iJ\fgn]1di&|g\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|gnQ8v]R|F%Z9\u0015\t\u0005=\u00141\u001e\u0005\t\u0003C$\u0013\u0011!a\u0001/\u0006yBO]1og\u0006\u001cG/[8o)>\u0004\u0018n\u0019)beRLG/[8o\u0007>,h\u000e\u001e\u0011)\u0007\u0015\n\t\u0010E\u0002O\u0003gL1!!>P\u0005!1x\u000e\\1uS2,\u0017a\u00059beRLG/[8o\u0019>\fGmU3og>\u0014XCAA~!\u0011\t9$!@\n\t\u0005}\u0018\u0011\b\u0002\u0007'\u0016t7o\u001c:\u0002)A\f'\u000f^5uS>tGj\\1e'\u0016t7o\u001c:!\u0003M\tG\r\u001a'pC\u0012Lgn\u001a)beRLG/[8o)\u0019\tyGa\u0002\u0003\f!1!\u0011\u0002\u0015A\u0002]\u000b1\u0002]1si&$\u0018n\u001c8JI\"1!Q\u0002\u0015A\u0002]\u000b\u0001cY8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195\u0002)QLW.\u001a3PkR$&/\u00198tC\u000e$\u0018n\u001c8t)\t\u0011\u0019\u0002\u0005\u0004\u0003\u0016\t}!Q\u0005\b\u0005\u0005/\u0011YBD\u0002g\u00053I\u0011\u0001U\u0005\u0004\u0005;y\u0015a\u00029bG.\fw-Z\u0005\u0005\u0005C\u0011\u0019C\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\u0011ib\u0014\t\u0004\u0015\n\u001d\u0012b\u0001B\u0015\u0005\n\tCK]1og\u0006\u001cG/[8oC2LE-\u00118e!J|G-^2fe&#W\t]8dQ\u0006i\"/Z7pm\u0016,\u0005\u0010]5sK\u0012$&/\u00198tC\u000e$\u0018n\u001c8bY&#7\u000f\u0006\u0004\u0002p\t=\"1\b\u0005\b\u0005cQ\u0003\u0019\u0001B\u001a\u0003Q!(/\u00198tC\u000e$\u0018n\u001c8QCJ$\u0018\u000e^5p]B!!Q\u0007B\u001c\u001b\t\tY#\u0003\u0003\u0003:\u0005-\"A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\b\u0005{Q\u0003\u0019AAe\u0003U!\bP\\'fi\u0006$\u0017\r^1DC\u000eDW-\u00128uef\fAb\u001d5pk2$W\t\u001f9je\u0016$bAa\u0011\u0003J\t5\u0003c\u0001(\u0003F%\u0019!qI(\u0003\u000f\t{w\u000e\\3b]\"9!1J\u0016A\u0002\u0005\r\u0014a\u0003;y]6+G/\u00193bi\u0006DqAa\u0014,\u0001\u0004\u0011\t&A\u0007dkJ\u0014XM\u001c;US6,Wj\u001d\t\u0004\u001d\nM\u0013b\u0001B+\u001f\n!Aj\u001c8h\u0003Ui\u0017-\u001f2f\u0003B\u0004XM\u001c3FqBL'/\u0019;j_:$\u0002Ba\u0011\u0003\\\tu#Q\u000e\u0005\b\u0005\u0017b\u0003\u0019AA2\u0011\u001d\u0011y\u0006\fa\u0001\u0005C\naB]3d_J$7OQ;jY\u0012,'\u000f\u0005\u0003\u0003d\t%TB\u0001B3\u0015\u0011\u00119'a\u000b\u0002\rI,7m\u001c:e\u0013\u0011\u0011YG!\u001a\u0003)5+Wn\u001c:z%\u0016\u001cwN\u001d3t\u0005VLG\u000eZ3s\u0011\u001d\u0011y\u0005\fa\u0001\u0005#\"\"!a\u001c\u0002S]\u0014\u0018\u000e^3U_6\u00147\u000f^8oKN4uN]#ya&\u0014X\r\u001a+sC:\u001c\u0018m\u0019;j_:\fG.\u00133t)!\tyG!\u001e\u0003x\t\r\u0005b\u0002B\u0019]\u0001\u0007!1\u0007\u0005\b\u0005sr\u0003\u0019\u0001B>\u0003M)\u0007\u0010]5sK\u00124uN\u001d)beRLG/[8o!\u0019\u0011)Ba\b\u0003~A\u0019!Ja \n\u0007\t\u0005%I\u0001\u0016Ue\u0006t7/Y2uS>t\u0017\r\\%e\u0007>|'\u000fZ5oCR|'/\u00129pG\"\fe\u000eZ'fi\u0006$\u0017\r^1\t\u000f\t\u0015e\u00061\u0001\u0003\b\u0006\u0001Bo\\7cgR|g.\u001a*fG>\u0014Hm\u001d\t\u0005\u0005G\u0012I)\u0003\u0003\u0003\f\n\u0015$!D'f[>\u0014\u0018PU3d_J$7/A\u0010f]\u0006\u0014G.\u001a+sC:\u001c\u0018m\u0019;j_:\fG.\u00133FqBL'/\u0019;j_:\f1cZ3u)J\fgn]1di&|gn\u0015;bi\u0016$BAa%\u00032BA!Q\u0003BK\u00053\u0013)+\u0003\u0003\u0003\u0018\n\r\"AB#ji\",'\u000f\u0005\u0003\u0003\u001c\n\u0005VB\u0001BO\u0015\u0011\u0011y*a\u000b\u0002\u0011A\u0014x\u000e^8d_2LAAa)\u0003\u001e\n1QI\u001d:peN\u0004RA\u0014BT\u0005WK1A!+P\u0005\u0019y\u0005\u000f^5p]B\u0019!J!,\n\u0007\t=&I\u0001\u0010D_>\u0014H-\u001b8bi>\u0014X\t]8dQ\u0006sG\r\u0016=o\u001b\u0016$\u0018\rZ1uC\"1!1\u0017\u0019A\u0002\r\fq\u0002\u001e:b]N\f7\r^5p]\u0006d\u0017\nZ\u0001\u001faV$HK]1og\u0006\u001cG/[8o'R\fG/Z%g\u001d>$X\t_5tiN$BA!/\u0003<BA!Q\u0003BK\u00053\u0013Y\u000bC\u0004\u0003LE\u0002\r!a\u0019\u0002+1L7\u000f\u001e+sC:\u001c\u0018m\u0019;j_:\u001cF/\u0019;fgR1!\u0011\u0019Bg\u0005+\u0004BAa1\u0003J6\u0011!Q\u0019\u0006\u0005\u0005\u000f\fY#A\u0004nKN\u001c\u0018mZ3\n\t\t-'Q\u0019\u0002\u001d\u0019&\u001cH\u000f\u0016:b]N\f7\r^5p]N\u0014Vm\u001d9p]N,G)\u0019;b\u0011\u001d\u0011yM\ra\u0001\u0005#\f\u0011CZ5mi\u0016\u0014\bK]8ek\u000e,'/\u00133t!\u0015!'1\u001bB)\u0013\r\t),\u001c\u0005\b\u0005/\u0014\u0004\u0019\u0001Bm\u0003A1\u0017\u000e\u001c;feN#\u0018\r^3OC6,7\u000f\u0005\u0003e\u0005'\u001c\u0017AH4fi\u0006sG-T1zE\u0016\fE\r\u001a+sC:\u001c\u0018m\u0019;j_:\u001cF/\u0019;f)\u0019\u0011\u0019Ja8\u0003b\"1!1W\u001aA\u0002\rDqAa94\u0001\u0004\u0011)/A\u000bde\u0016\fG/\u001a3Uq:lU\r^1eCR\fw\n\u001d;\u0011\u000b9\u00139+a\u0019\u00029Y\fG.\u001b3bi\u0016$&/\u00198tC\u000e$\u0018n\u001c8US6,w.\u001e;NgR!!1\tBv\u0011\u0019\u0011i\u000f\u000ea\u0001/\u0006aA\u000f\u001f8US6,w.\u001e;Ng\u00069BO]1og\u0006\u001cG/[8o)>\u0004\u0018nY\"p]\u001aLwm]\u000b\u0003\u0005g\u0004BA!>\u0003x6\u0011\u0011QQ\u0005\u0005\u0005s\f)I\u0001\u0006Qe>\u0004XM\u001d;jKN\fA\u0002]1si&$\u0018n\u001c8G_J$2a\u0016B\u0000\u0011\u0019\u0011\u0019L\u000ea\u0001G\u00069Bn\\1e)J\fgn]1di&|g.T3uC\u0012\fG/\u0019\u000b\u0007\u0007\u000b\u0019Yaa\u0004\u0011\rM\u001c9aYA2\u0013\r\u0019I\u0001\u001e\u0002\u0005!>|G\u000eC\u0004\u0004\u000e]\u0002\rAa\r\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]\"1!QB\u001cA\u0002]\u000bA$\u00193e\u0019>\fG-\u001a3Ue\u0006t7/Y2uS>t7\u000fV8DC\u000eDW\r\u0006\u0005\u0002p\rU1\u0011DB\u000e\u0011\u0019\u00199\u0002\u000fa\u0001/\u0006\tB\u000f\u001f8U_BL7\rU1si&$\u0018n\u001c8\t\r\t5\u0001\b1\u0001X\u0011\u001d\u0019i\u0002\u000fa\u0001\u0007\u000b\t!\u0003\\8bI\u0016$GK]1og\u0006\u001cG/[8og\u0006!Cn\\1e)J\fgn]1di&|gn\u001d$peRCh\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0005\u0002p\r\r2QEB\u0014\u0011\u0019\u0011I!\u000fa\u0001/\"1!QB\u001dA\u0002]Cqa!\u000b:\u0001\u0004\u0019Y#\u0001\btK:$G\u000b\u001f8NCJ\\WM]:\u0011\u0007\r5r#D\u0001\u0010\u0003\u0019\u0012X-\\8wKR\u0013\u0018M\\:bGRLwN\\:G_J$\u0006P\u001c+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u000b\u0005\u0003_\u001a\u0019\u0004\u0003\u0004\u0003\ni\u0002\ra\u0016\u000b\u0007\u0003_\u001a9d!\u000f\t\r\t%1\b1\u0001X\u0011\u0019\u0011ia\u000fa\u0001/\u0006qc/\u00197jI\u0006$X\r\u0016:b]N\f7\r^5p]R{\u0007/[2QCJ$\u0018\u000e^5p]\u000e{WO\u001c;JgN#\u0018M\u00197f\u0003Y\t\u0007\u000f]3oIR\u0013\u0018M\\:bGRLwN\u001c+p\u0019><GCDA8\u0007\u0003\u001a\u0019e!\u0012\u0004J\rM3\u0011\f\u0005\u0007\u0005gk\u0004\u0019A2\t\r\t5Q\b1\u0001X\u0011\u001d\u00199%\u0010a\u0001\u0003S\n1B\\3x\u001b\u0016$\u0018\rZ1uC\"911J\u001fA\u0002\r5\u0013\u0001\u0005:fgB|gn]3DC2d'-Y2l!\u001dq5q\nBM\u0003_J1a!\u0015P\u0005%1UO\\2uS>t\u0017\u0007C\u0005\u0004Vu\u0002\n\u00111\u0001\u0004X\u0005a!/\u001a;ss>sWI\u001d:peB9aja\u0014\u0003\u001a\n\r\u0003bBB.{\u0001\u00071QL\u0001\re\u0016\fX/Z:u\u0019>\u001c\u0017\r\u001c\t\u0005\u0003'\u0019y&\u0003\u0003\u0004b\u0005U!\u0001\u0004*fcV,7\u000f\u001e'pG\u0006d\u0017\u0001I1qa\u0016tG\r\u0016:b]N\f7\r^5p]R{Gj\\4%I\u00164\u0017-\u001e7uIU*\"aa\u001a+\t\r]3\u0011N\u0016\u0003\u0007W\u0002Ba!\u001c\u0004x5\u00111q\u000e\u0006\u0005\u0007c\u001a\u0019(A\u0005v]\u000eDWmY6fI*\u00191QO(\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004z\r=$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u000691\u000f^1siV\u0004HCBA8\u0007\u007f\u001a\t\tC\u0004\u0002R~\u0002\r!!6\t\u000f\t5u\b1\u0001\u0003D\u0005A1\u000f[;uI><h\u000e")
public class TransactionStateManager
implements Logging {
    private final Scheduler scheduler;
    private final ReplicaManager replicaManager;
    private final TransactionConfig config;
    private final Time time;
    private final AtomicBoolean shuttingDown;
    private final ReentrantReadWriteLock stateLock;
    private final Set<TransactionPartitionAndLeaderEpoch> loadingPartitions;
    private final scala.collection.mutable.Map<Object, TxnMetadataCacheEntry> transactionMetadataCache;
    private Function0<Object> retrieveTransactionTopicPartitionCount;
    private volatile int transactionTopicPartitionCount;
    private final Sensor partitionLoadSensor;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static String LoadTimeSensor() {
        return TransactionStateManager$.MODULE$.LoadTimeSensor();
    }

    public static String MetricsGroup() {
        return TransactionStateManager$.MODULE$.MetricsGroup();
    }

    public static int DefaultRemoveExpiredTransactionalIdsIntervalMs() {
        return TransactionStateManager$.MODULE$.DefaultRemoveExpiredTransactionalIdsIntervalMs();
    }

    public static int DefaultAbortTimedOutTransactionsIntervalMs() {
        return TransactionStateManager$.MODULE$.DefaultAbortTimedOutTransactionsIntervalMs();
    }

    public static int DefaultTransactionalIdExpirationMs() {
        return TransactionStateManager$.MODULE$.DefaultTransactionalIdExpirationMs();
    }

    public static int DefaultTransactionsMaxTimeoutMs() {
        return TransactionStateManager$.MODULE$.DefaultTransactionsMaxTimeoutMs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private AtomicBoolean shuttingDown() {
        return this.shuttingDown;
    }

    private ReentrantReadWriteLock stateLock() {
        return this.stateLock;
    }

    public Set<TransactionPartitionAndLeaderEpoch> loadingPartitions() {
        return this.loadingPartitions;
    }

    public scala.collection.mutable.Map<Object, TxnMetadataCacheEntry> transactionMetadataCache() {
        return this.transactionMetadataCache;
    }

    private Function0<Object> retrieveTransactionTopicPartitionCount() {
        return this.retrieveTransactionTopicPartitionCount;
    }

    private void retrieveTransactionTopicPartitionCount_$eq(Function0<Object> x$1) {
        this.retrieveTransactionTopicPartitionCount = x$1;
    }

    private int transactionTopicPartitionCount() {
        return this.transactionTopicPartitionCount;
    }

    private void transactionTopicPartitionCount_$eq(int x$1) {
        this.transactionTopicPartitionCount = x$1;
    }

    private Sensor partitionLoadSensor() {
        return this.partitionLoadSensor;
    }

    /*
     * WARNING - void declaration
     */
    public void addLoadingPartition(int partitionId, int coordinatorEpoch) {
        void inWriteLock_lock;
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$addLoadingPartition$1(this, partitionAndLeaderEpoch);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public Iterable<TransactionalIdAndProducerIdEpoch> timedOutTransactions() {
        Iterable iterable;
        void inReadLock_lock;
        long now = this.time.milliseconds();
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            iterable = TransactionStateManager.$anonfun$timedOutTransactions$1(this, now);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return iterable;
    }

    /*
     * WARNING - void declaration
     */
    private void removeExpiredTransactionalIds(TopicPartition transactionPartition, TxnMetadataCacheEntry txnMetadataCacheEntry) {
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$removeExpiredTransactionalIds$1(this, transactionPartition, txnMetadataCacheEntry);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    private boolean shouldExpire(TransactionMetadata txnMetadata, long currentTimeMs) {
        return txnMetadata.state().isExpirationAllowed() && txnMetadata.txnLastUpdateTimestamp() <= currentTimeMs - (long)this.config.transactionalIdExpirationMs();
    }

    private boolean maybeAppendExpiration(TransactionMetadata txnMetadata, MemoryRecordsBuilder recordsBuilder, long currentTimeMs) {
        byte[] keyBytes = TransactionLog$.MODULE$.keyToBytes(txnMetadata.transactionalId());
        if (recordsBuilder.hasRoomFor(currentTimeMs, keyBytes, null, Record.EMPTY_HEADERS)) {
            recordsBuilder.append(currentTimeMs, keyBytes, null, Record.EMPTY_HEADERS);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void removeExpiredTransactionalIds() {
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$removeExpiredTransactionalIds$4(this);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeTombstonesForExpiredTransactionalIds(TopicPartition transactionPartition, Iterable<TransactionalIdCoordinatorEpochAndMetadata> expiredForPartition, MemoryRecords tombstoneRecords) {
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$writeTombstonesForExpiredTransactionalIds$7(this, transactionPartition, tombstoneRecords, expiredForPartition);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    public void enableTransactionalIdExpiration() {
        this.scheduler.schedule("transactionalId-expiration", () -> this.removeExpiredTransactionalIds(), (long)this.config.removeExpiredTransactionalIdsIntervalMs(), (long)this.config.removeExpiredTransactionalIdsIntervalMs());
    }

    public Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> getTransactionState(String transactionalId) {
        return this.getAndMaybeAddTransactionState(transactionalId, (Option<TransactionMetadata>)None$.MODULE$);
    }

    public Either<Errors, CoordinatorEpochAndTxnMetadata> putTransactionStateIfNotExists(TransactionMetadata txnMetadata) {
        return this.getAndMaybeAddTransactionState(txnMetadata.transactionalId(), (Option<TransactionMetadata>)new Some((Object)txnMetadata)).map((Function1 & Serializable & scala.Serializable)x$1 -> (CoordinatorEpochAndTxnMetadata)x$1.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(61).append("Unexpected empty transaction metadata returned while putting ").append(txnMetadata).toString());
        }));
    }

    /*
     * WARNING - void declaration
     */
    public ListTransactionsResponseData listTransactionStates(scala.collection.immutable.Set<Object> filterProducerIds, scala.collection.immutable.Set<String> filterStateNames) {
        ListTransactionsResponseData listTransactionsResponseData;
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            listTransactionsResponseData = TransactionStateManager.$anonfun$listTransactionStates$1(this, filterStateNames, filterProducerIds);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return listTransactionsResponseData;
    }

    /*
     * WARNING - void declaration
     */
    private Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> getAndMaybeAddTransactionState(String transactionalId, Option<TransactionMetadata> createdTxnMetadataOpt) {
        Either either;
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            either = TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$1(this, transactionalId, createdTxnMetadataOpt);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
        return either;
    }

    public boolean validateTransactionTimeoutMs(int txnTimeoutMs) {
        return txnTimeoutMs <= this.config.transactionMaxTimeoutMs() && txnTimeoutMs > 0;
    }

    public Properties transactionTopicConfigs() {
        Properties props = new Properties();
        props.put("unclean.leader.election.enable", "false");
        props.put("compression.type", BrokerCompressionType.UNCOMPRESSED.name);
        props.put("cleanup.policy", "compact");
        props.put("min.insync.replicas", Integer.toString(this.config.transactionLogMinInsyncReplicas()));
        props.put("segment.bytes", Integer.toString(this.config.transactionLogSegmentBytes()));
        return props;
    }

    public int partitionFor(String transactionalId) {
        return Utils.abs((int)transactionalId.hashCode()) % this.transactionTopicPartitionCount();
    }

    /*
     * WARNING - void declaration
     */
    private Pool<String, TransactionMetadata> loadTransactionMetadata(TopicPartition topicPartition, int coordinatorEpoch) {
        Pool<String, TransactionMetadata> loadedTransactions = new Pool<String, TransactionMetadata>((Option<Function1<String, TransactionMetadata>>)Pool$.MODULE$.$lessinit$greater$default$1());
        Option<UnifiedLog> option = this.replicaManager.getLog(topicPartition);
        if (None$.MODULE$.equals(option)) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Attempted to load transaction metadata from ").append(topicPartition).append(", but found no log").toString());
        } else if (option instanceof Some) {
            UnifiedLog log = (UnifiedLog)((Some)option).value();
            ByteBuffer buffer = ByteBuffer.allocate(0);
            LongRef currOffset = LongRef.create((long)log.logStartOffset());
            boolean readAtLeastOneRecord = true;
            try {
                while (currOffset.elem < this.logEndOffset$1(topicPartition) && readAtLeastOneRecord && !this.shuttingDown().get()) {
                    MemoryRecords memoryRecords;
                    boolean bl;
                    void inReadLock_lock;
                    ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
                    if (CoreUtils$.MODULE$ == null) {
                        throw null;
                    }
                    Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
                    inReadLock_inLock_lock.lock();
                    try {
                        bl = TransactionStateManager.$anonfun$loadTransactionMetadata$3(this, topicPartition, coordinatorEpoch);
                    }
                    finally {
                        inReadLock_inLock_lock.unlock();
                    }
                    if (!bl) break;
                    FetchDataInfo fetchDataInfo = log.read(currOffset.elem, this.config.transactionLogLoadBufferSize(), FetchIsolation.LOG_END, true);
                    readAtLeastOneRecord = fetchDataInfo.records.sizeInBytes() > 0;
                    Records records = fetchDataInfo.records;
                    if (records instanceof MemoryRecords) {
                        memoryRecords = (MemoryRecords)records;
                    } else if (records instanceof FileRecords) {
                        FileRecords fileRecords = (FileRecords)records;
                        int sizeInBytes = fileRecords.sizeInBytes();
                        int bytesNeeded = Math.max(this.config.transactionLogLoadBufferSize(), sizeInBytes);
                        if (buffer.capacity() < bytesNeeded) {
                            if (this.config.transactionLogLoadBufferSize() < bytesNeeded) {
                                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(125).append("Loaded transaction metadata from ").append(topicPartition).append(" with buffer larger (").append(bytesNeeded).append(" bytes) than ").append("configured transaction.state.log.load.buffer.size (").append($this.config.transactionLogLoadBufferSize()).append(" bytes)").toString());
                            }
                            buffer = ByteBuffer.allocate(bytesNeeded);
                        } else {
                            buffer.clear();
                        }
                        buffer.clear();
                        fileRecords.readInto(buffer, 0);
                        memoryRecords = MemoryRecords.readableRecords((ByteBuffer)buffer);
                    } else {
                        throw new MatchError((Object)records);
                    }
                    memoryRecords.batches().forEach(batch -> ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
                        TransactionStateManager.$anonfun$loadTransactionMetadata$7(this, loadedTransactions, currOffset, batch, topicPartition, record);
                        return BoxedUnit.UNIT;
                    }));
                }
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Error loading transactions from transaction log ").append(topicPartition).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            }
        } else {
            throw new MatchError(option);
        }
        return loadedTransactions;
    }

    public void addLoadedTransactionsToCache(int txnTopicPartition, int coordinatorEpoch, Pool<String, TransactionMetadata> loadedTransactions) {
        TxnMetadataCacheEntry txnMetadataCacheEntry = new TxnMetadataCacheEntry(coordinatorEpoch, loadedTransactions);
        this.transactionMetadataCache().put((Object)BoxesRunTime.boxToInteger((int)txnTopicPartition), (Object)txnMetadataCacheEntry).foreach((Function1 & Serializable & scala.Serializable)previousTxnMetadataCacheEntry -> {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("Unloaded transaction metadata ").append(previousTxnMetadataCacheEntry).append(" from ").append(txnTopicPartition$1).append(" as part of ").append("loading metadata at epoch ").append(coordinatorEpoch$2).toString());
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public void loadTransactionsForTxnTopicPartition(int partitionId, int coordinatorEpoch, Function4<Object, TransactionResult, TransactionMetadata, TxnTransitMetadata, BoxedUnit> sendTxnMarkers) {
        void inWriteLock_lock;
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$loadTransactionsForTxnTopicPartition$1(this, partitionAndLeaderEpoch);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        long scheduleStartMs = this.time.milliseconds();
        this.scheduler.scheduleOnce(new StringBuilder(24).append("load-txns-for-partition-").append(topicPartition).toString(), () -> {
            void loadTransactions$1_inWriteLock_lock;
            long loadTransactions$1_schedulerTimeMs = $this.time.milliseconds() - scheduleStartMs;
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Loading transaction metadata from ").append(topicPartition).append(" at epoch ").append(coordinatorEpoch).toString());
            this.validateTransactionTopicPartitionCountIsStable();
            Pool<String, TransactionMetadata> loadTransactions$1_loadedTransactions = this.loadTransactionMetadata(topicPartition, coordinatorEpoch);
            long loadTransactions$1_endTimeMs = $this.time.milliseconds();
            long loadTransactions$1_totalLoadingTimeMs = loadTransactions$1_endTimeMs - scheduleStartMs;
            this.partitionLoadSensor().record((double)loadTransactions$1_totalLoadingTimeMs, loadTransactions$1_endTimeMs, false);
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(113).append("Finished loading ").append(loadTransactions$1_loadedTransactions.size()).append(" transaction metadata from ").append(topicPartition).append(" in ").append(loadTransactions$1_totalLoadingTimeMs).append(" milliseconds, of which ").append(loadTransactions$1_schedulerTimeMs).append(" milliseconds was spent in the scheduler.").toString());
            ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
            if (CoreUtils$.MODULE$ == null) {
                throw null;
            }
            Lock loadTransactions$1_inWriteLock_inLock_lock = loadTransactions$1_inWriteLock_lock.writeLock();
            loadTransactions$1_inWriteLock_inLock_lock.lock();
            try {
                TransactionStateManager.$anonfun$loadTransactionsForTxnTopicPartition$4(this, partitionAndLeaderEpoch, topicPartition, coordinatorEpoch, loadTransactions$1_loadedTransactions, sendTxnMarkers);
            }
            finally {
                loadTransactions$1_inWriteLock_inLock_lock.unlock();
            }
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Completed loading transaction metadata from ").append(topicPartition).append(" for coordinator epoch ").append(coordinatorEpoch).toString());
        });
    }

    /*
     * WARNING - void declaration
     */
    public void removeTransactionsForTxnTopicPartition(int partitionId) {
        void inWriteLock_lock;
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$removeTransactionsForTxnTopicPartition$1(this, partitionId, topicPartition);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeTransactionsForTxnTopicPartition(int partitionId, int coordinatorEpoch) {
        void inWriteLock_lock;
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch = new TransactionPartitionAndLeaderEpoch(partitionId, coordinatorEpoch);
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$removeTransactionsForTxnTopicPartition$5(this, partitionAndLeaderEpoch, partitionId, topicPartition);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
    }

    private void validateTransactionTopicPartitionCountIsStable() {
        int curTransactionTopicPartitionCount;
        int previouslyDeterminedPartitionCount = this.transactionTopicPartitionCount();
        if (previouslyDeterminedPartitionCount != (curTransactionTopicPartitionCount = this.retrieveTransactionTopicPartitionCount().apply$mcI$sp())) {
            throw new KafkaException(new StringBuilder(60).append("Transaction topic number of partitions has changed from ").append(previouslyDeterminedPartitionCount).append(" to ").append(curTransactionTopicPartitionCount).toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void appendTransactionToLog(String transactionalId, int coordinatorEpoch, TxnTransitMetadata newMetadata, Function1<Errors, BoxedUnit> responseCallback, Function1<Errors, Object> retryOnError, RequestLocal requestLocal) {
        void inReadLock_lock;
        byte[] keyBytes = TransactionLog$.MODULE$.keyToBytes(transactionalId);
        byte[] valueBytes = TransactionLog$.MODULE$.valueToBytes(newMetadata);
        long timestamp = this.time.milliseconds();
        MemoryRecords records = MemoryRecords.withRecords((CompressionType)TransactionLog$.MODULE$.EnforcedCompressionType(), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(timestamp, keyBytes, valueBytes)});
        TopicPartition topicPartition = new TopicPartition("__transaction_state", this.partitionFor(transactionalId));
        scala.collection.immutable.Map recordsPerPartition = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)records)}));
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$appendTransactionToLog$13(this, transactionalId, responseCallback, coordinatorEpoch, newMetadata, recordsPerPartition, requestLocal, topicPartition, retryOnError);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    public Function1<Errors, Object> appendTransactionToLog$default$5() {
        return (Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$appendTransactionToLog$default$5$1(x$6));
    }

    public void startup(Function0<Object> retrieveTransactionTopicPartitionCount, boolean enableTransactionalIdExpiration) {
        this.retrieveTransactionTopicPartitionCount = retrieveTransactionTopicPartitionCount;
        this.transactionTopicPartitionCount_$eq(retrieveTransactionTopicPartitionCount.apply$mcI$sp());
        if (enableTransactionalIdExpiration) {
            this.enableTransactionalIdExpiration();
            return;
        }
    }

    public void shutdown() {
        this.shuttingDown().set(true);
        this.loadingPartitions().clear();
        this.transactionMetadataCache().clear();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutdown complete");
    }

    public static final /* synthetic */ boolean $anonfun$addLoadingPartition$1(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$1) {
        return $this.loadingPartitions().add((Object)partitionAndLeaderEpoch$1);
    }

    public static final /* synthetic */ boolean $anonfun$timedOutTransactions$3(long now$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            TransactionMetadata txnMetadata = (TransactionMetadata)x0$2._2();
            if (txnMetadata.pendingTransitionInProgress()) {
                return false;
            }
            TransactionState transactionState = txnMetadata.state();
            if (Ongoing$.MODULE$.equals(transactionState)) {
                return txnMetadata.txnStartTimestamp() + (long)txnMetadata.txnTimeoutMs() < now$1;
            }
            return false;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ Iterable $anonfun$timedOutTransactions$1(TransactionStateManager $this, long now$1) {
        return (Iterable)$this.transactionMetadataCache().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                return (Iterable)((TraversableLike)((TxnMetadataCacheEntry)x0$1._2()).metadataPerTransactionalId().filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$timedOutTransactions$3(now$1, x0$2)))).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                    if (x0$3 != null) {
                        String txnId = (String)x0$3._1();
                        TransactionMetadata txnMetadata = (TransactionMetadata)x0$3._2();
                        return new TransactionalIdAndProducerIdEpoch(txnId, txnMetadata.producerId(), txnMetadata.producerEpoch());
                    }
                    throw new MatchError(null);
                }, Iterable$.MODULE$.canBuildFrom());
            }
            throw new MatchError(null);
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom());
    }

    private final void flushRecordsBuilder$1(TopicPartition transactionPartition$1, ListBuffer expired$1, ObjectRef recordsBuilder$1) {
        this.writeTombstonesForExpiredTransactionalIds(transactionPartition$1, (Iterable<TransactionalIdCoordinatorEpochAndMetadata>)expired$1.toSeq(), ((MemoryRecordsBuilder)recordsBuilder$1.elem).build());
        expired$1.clear();
        recordsBuilder$1.elem = null;
    }

    public static final /* synthetic */ void $anonfun$removeExpiredTransactionalIds$1(TransactionStateManager $this, TopicPartition transactionPartition$1, TxnMetadataCacheEntry txnMetadataCacheEntry$1) {
        Option<LogConfig> option = $this.replicaManager.getLogConfig(transactionPartition$1);
        if (option instanceof Some) {
            LogConfig logConfig = (LogConfig)((Some)option).value();
            long currentTimeMs = $this.time.milliseconds();
            int maxBatchSize = logConfig.maxMessageSize();
            ListBuffer expired = (ListBuffer)ListBuffer$.MODULE$.empty();
            ObjectRef recordsBuilder = ObjectRef.create(null);
            BufferedIterator stateEntries = txnMetadataCacheEntry$1.metadataPerTransactionalId().values().iterator().buffered();
            while (stateEntries.hasNext()) {
                TransactionMetadata txnMetadata = (TransactionMetadata)stateEntries.head();
                String transactionalId = txnMetadata.transactionalId();
                BooleanRef fullBatch = BooleanRef.create((boolean)false);
                txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                    if (txnMetadata.pendingState().isEmpty() && $this.shouldExpire(txnMetadata, currentTimeMs)) {
                        if ((MemoryRecordsBuilder)recordsBuilder$1.elem == null) {
                            recordsBuilder$1.elem = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(scala.math.package$.MODULE$.min(16384, maxBatchSize)), (CompressionType)TransactionLog$.MODULE$.EnforcedCompressionType(), (TimestampType)TimestampType.CREATE_TIME, (long)0L, (int)maxBatchSize);
                        }
                        if ($this.maybeAppendExpiration(txnMetadata, (MemoryRecordsBuilder)recordsBuilder$1.elem, currentTimeMs)) {
                            TxnTransitMetadata transitMetadata = txnMetadata.prepareDead();
                            return expired.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndMetadata(transactionalId, txnMetadataCacheEntry$1.coordinatorEpoch(), transitMetadata));
                        }
                        fullBatch$1.elem = true;
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                });
                if (fullBatch.elem) {
                    $this.flushRecordsBuilder$1(transactionPartition$1, expired, recordsBuilder);
                    continue;
                }
                stateEntries.next();
            }
            if (expired.nonEmpty()) {
                $this.flushRecordsBuilder$1(transactionPartition$1, expired, recordsBuilder);
                return;
            }
            return;
        }
        if (None$.MODULE$.equals(option)) {
            $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(156).append("Transaction expiration for partition ").append(transactionPartition$1).append(" failed because the log ").append("config was not available, which likely means the partition is not online or is no longer local.").toString());
            return;
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ void $anonfun$removeExpiredTransactionalIds$5(TransactionStateManager $this, int partitionId, TxnMetadataCacheEntry partitionCacheEntry) {
        TopicPartition transactionPartition = new TopicPartition("__transaction_state", partitionId);
        $this.removeExpiredTransactionalIds(transactionPartition, partitionCacheEntry);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$removeExpiredTransactionalIds$4(TransactionStateManager $this) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(partitionId, partitionCacheEntry) -> {
            TransactionStateManager.$anonfun$removeExpiredTransactionalIds$5($this, BoxesRunTime.unboxToInt((Object)partitionId), partitionCacheEntry);
            return BoxedUnit.UNIT;
        };
        Map<Object, TxnMetadataCacheEntry> map = Implicits$.MODULE$.MapExtensionMethods($this.transactionMetadataCache());
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
    }

    public static final /* synthetic */ void $anonfun$writeTombstonesForExpiredTransactionalIds$2(TransactionStateManager $this, TopicPartition topicPartition$1, Iterable expiredForPartition$1, ProduceResponse.PartitionResponse response$1) {
        $this.transactionMetadataCache().get((Object)BoxesRunTime.boxToInteger((int)topicPartition$1.partition())).foreach((Function1 & Serializable & scala.Serializable)txnMetadataCacheEntry -> {
            expiredForPartition$1.foreach((Function1 & Serializable & scala.Serializable)idCoordinatorEpochAndMetadata -> {
                String transactionalId = idCoordinatorEpochAndMetadata.transactionalId();
                TransactionMetadata txnMetadata = txnMetadataCacheEntry.metadataPerTransactionalId().get(transactionalId);
                return txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                    if (txnMetadataCacheEntry.coordinatorEpoch() == idCoordinatorEpochAndMetadata.coordinatorEpoch() && txnMetadata.pendingState().contains((Object)Dead$.MODULE$) && txnMetadata.producerEpoch() == idCoordinatorEpochAndMetadata.transitMetadata().producerEpoch()) {
                        Errors errors = response$1.error;
                        Errors errors2 = Errors.NONE;
                        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                            return txnMetadataCacheEntry.metadataPerTransactionalId().remove(transactionalId);
                        }
                    }
                    $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(192).append("Failed to remove expired transactionalId: ").append(transactionalId).append(" from cache. Tombstone append error code: ").append(response$1.error).append(",").append(" pendingState: ").append(txnMetadata.pendingState()).append(", producerEpoch: ").append(txnMetadata.producerEpoch()).append(",").append(" expected producerEpoch: ").append(idCoordinatorEpochAndMetadata.transitMetadata().producerEpoch()).append(",").append(" coordinatorEpoch: ").append(txnMetadataCacheEntry.coordinatorEpoch()).append(", expected coordinatorEpoch: ").append(idCoordinatorEpochAndMetadata.coordinatorEpoch()).toString());
                    txnMetadata.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
                    return BoxedUnit.UNIT;
                });
            });
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$writeTombstonesForExpiredTransactionalIds$1(TransactionStateManager $this, Iterable expiredForPartition$1, TopicPartition topicPartition, ProduceResponse.PartitionResponse response) {
        void inReadLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = $this.stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inReadLock_inLock_lock = inReadLock_lock.readLock();
        inReadLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$writeTombstonesForExpiredTransactionalIds$2($this, topicPartition, expiredForPartition$1, response);
        }
        finally {
            inReadLock_inLock_lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void removeFromCacheCallback$1(Map responses, Iterable expiredForPartition$1) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(topicPartition, response) -> {
            TransactionStateManager.$anonfun$writeTombstonesForExpiredTransactionalIds$1(this, expiredForPartition$1, topicPartition, response);
            return BoxedUnit.UNIT;
        };
        Map map = Implicits$.MODULE$.MapExtensionMethods(responses);
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
    }

    public static final /* synthetic */ void $anonfun$writeTombstonesForExpiredTransactionalIds$7(TransactionStateManager $this, TopicPartition transactionPartition$2, MemoryRecords tombstoneRecords$1, Iterable expiredForPartition$1) {
        long x$1 = $this.config.requestTimeoutMs();
        short x$2 = TransactionLog$.MODULE$.EnforcedRequiredAcks();
        boolean x$3 = true;
        AppendOrigin x$4 = AppendOrigin.COORDINATOR;
        scala.collection.immutable.Map x$5 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)transactionPartition$2), (Object)tombstoneRecords$1)}));
        Function1 & Serializable & scala.Serializable x$6 = (Function1 & Serializable & scala.Serializable)responses -> {
            $this.removeFromCacheCallback$1(responses, expiredForPartition$1);
            return BoxedUnit.UNIT;
        };
        RequestLocal x$7 = RequestLocal$.MODULE$.NoCaching();
        Option<Lock> x$8 = $this.replicaManager.appendRecords$default$7();
        Function1<Map<TopicPartition, RecordConversionStats>, BoxedUnit> x$9 = $this.replicaManager.appendRecords$default$8();
        String x$10 = $this.replicaManager.appendRecords$default$10();
        Option<Object> x$11 = $this.replicaManager.appendRecords$default$11();
        ActionQueue x$12 = $this.replicaManager.appendRecords$default$12();
        $this.replicaManager.appendRecords(x$1, x$2, x$3, x$4, (Map<TopicPartition, MemoryRecords>)x$5, (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)x$6, x$8, x$9, x$7, x$10, x$11, x$12);
    }

    private static final boolean shouldInclude$1(TransactionMetadata txnMetadata, scala.collection.immutable.Set filterProducerIds$1, scala.collection.immutable.Set filterStateNames$1, Set filterStates$1) {
        TransactionState transactionState = txnMetadata.state();
        Dead$ dead$ = Dead$.MODULE$;
        if (!(transactionState != null ? !transactionState.equals(dead$) : dead$ != null)) {
            return false;
        }
        if (filterProducerIds$1.nonEmpty() && !filterProducerIds$1.contains((Object)BoxesRunTime.boxToLong((long)txnMetadata.producerId()))) {
            return false;
        }
        return !filterStateNames$1.nonEmpty() || filterStates$1.contains((Object)txnMetadata.state());
    }

    public static final /* synthetic */ void $anonfun$listTransactionStates$3(ArrayList states$1, scala.collection.immutable.Set filterProducerIds$1, scala.collection.immutable.Set filterStateNames$1, Set filterStates$1, int x$2, TxnMetadataCacheEntry cache) {
        cache.metadataPerTransactionalId().values().foreach((Function1 & Serializable & scala.Serializable)txnMetadata -> txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
            if (TransactionStateManager.shouldInclude$1(txnMetadata, filterProducerIds$1, filterStateNames$1, filterStates$1)) {
                return BoxesRunTime.boxToBoolean((boolean)states$1.add(new ListTransactionsResponseData.TransactionState().setTransactionalId(txnMetadata.transactionalId()).setProducerId(txnMetadata.producerId()).setTransactionState(txnMetadata.state().name())));
            }
            return BoxedUnit.UNIT;
        }));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ListTransactionsResponseData $anonfun$listTransactionStates$1(TransactionStateManager $this, scala.collection.immutable.Set filterStateNames$1, scala.collection.immutable.Set filterProducerIds$1) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        ListTransactionsResponseData response = new ListTransactionsResponseData();
        if ($this.loadingPartitions().nonEmpty()) {
            return response.setErrorCode(Errors.COORDINATOR_LOAD_IN_PROGRESS.code());
        }
        Set filterStates = Set$.MODULE$.empty();
        filterStateNames$1.foreach((Function1 & Serializable & scala.Serializable)stateName -> {
            Option<TransactionState> option = TransactionState$.MODULE$.fromName((String)stateName);
            if (option instanceof Some) {
                TransactionState state = (TransactionState)((Some)option).value();
                return filterStates.$plus$eq((Object)state);
            }
            if (None$.MODULE$.equals(option)) {
                return BoxesRunTime.boxToBoolean((boolean)response.unknownStateFilters().add(stateName));
            }
            throw new MatchError(option);
        });
        ArrayList states = new ArrayList();
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(x$2, cache) -> {
            TransactionStateManager.$anonfun$listTransactionStates$3(states, filterProducerIds$1, filterStateNames$1, filterStates, BoxesRunTime.unboxToInt((Object)x$2), cache);
            return BoxedUnit.UNIT;
        };
        Map<Object, TxnMetadataCacheEntry> map = Implicits$.MODULE$.MapExtensionMethods($this.transactionMetadataCache());
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        return response.setErrorCode(Errors.NONE.code()).setTransactionStates(states);
    }

    public static final /* synthetic */ boolean $anonfun$getAndMaybeAddTransactionState$2(int partitionId$1, TransactionPartitionAndLeaderEpoch x$3) {
        return x$3.txnPartitionId() == partitionId$1;
    }

    public static final /* synthetic */ Either $anonfun$getAndMaybeAddTransactionState$1(TransactionStateManager $this, String transactionalId$3, Option createdTxnMetadataOpt$1) {
        int partitionId = $this.partitionFor(transactionalId$3);
        if ($this.loadingPartitions().exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$getAndMaybeAddTransactionState$2(partitionId, x$3)))) {
            return scala.package$.MODULE$.Left().apply((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS);
        }
        Option option = $this.transactionMetadataCache().get((Object)BoxesRunTime.boxToInteger((int)partitionId));
        if (option instanceof Some) {
            TxnMetadataCacheEntry cacheEntry = (TxnMetadataCacheEntry)((Some)option).value();
            Option txnMetadata = Option$.MODULE$.apply((Object)cacheEntry.metadataPerTransactionalId().get(transactionalId$3)).orElse((Function0 & Serializable & scala.Serializable)() -> createdTxnMetadataOpt$1.map((Function1 & Serializable & scala.Serializable)createdTxnMetadata -> (TransactionMetadata)Option$.MODULE$.apply((Object)cacheEntry.metadataPerTransactionalId().putIfNotExists(transactionalId$3, (TransactionMetadata)createdTxnMetadata)).getOrElse((Function0 & Serializable & scala.Serializable)() -> createdTxnMetadata)));
            return scala.package$.MODULE$.Right().apply((Object)txnMetadata.map((Function1 & Serializable & scala.Serializable)x$4 -> new CoordinatorEpochAndTxnMetadata(cacheEntry.coordinatorEpoch(), (TransactionMetadata)x$4)));
        }
        if (None$.MODULE$.equals(option)) {
            return scala.package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR);
        }
        throw new MatchError((Object)option);
    }

    private final long logEndOffset$1(TopicPartition topicPartition$2) {
        return BoxesRunTime.unboxToLong((Object)this.replicaManager.getLogEndOffset(topicPartition$2).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L));
    }

    public static final /* synthetic */ boolean $anonfun$loadTransactionMetadata$4(TopicPartition topicPartition$2, int coordinatorEpoch$1, TransactionPartitionAndLeaderEpoch idAndEpoch) {
        return idAndEpoch.txnPartitionId() == topicPartition$2.partition() && idAndEpoch.coordinatorEpoch() == coordinatorEpoch$1;
    }

    public static final /* synthetic */ boolean $anonfun$loadTransactionMetadata$3(TransactionStateManager $this, TopicPartition topicPartition$2, int coordinatorEpoch$1) {
        return $this.loadingPartitions().exists((Function1 & Serializable & scala.Serializable)idAndEpoch -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$loadTransactionMetadata$4(topicPartition$2, coordinatorEpoch$1, idAndEpoch)));
    }

    public static final /* synthetic */ void $anonfun$loadTransactionMetadata$7(TransactionStateManager $this, Pool loadedTransactions$1, LongRef currOffset$1, MutableRecordBatch batch$1, TopicPartition topicPartition$2, Record record) {
        Predef$.MODULE$.require(record.hasKey(), (Function0 & Serializable & scala.Serializable)() -> "Transaction state log's key should not be null");
        BaseKey baseKey = TransactionLog$.MODULE$.readTxnRecordKey(record.key());
        if (baseKey instanceof TxnKey) {
            String transactionalId = ((TxnKey)baseKey).transactionalId();
            Option<TransactionMetadata> option = TransactionLog$.MODULE$.readTxnRecordValue(transactionalId, record.value());
            if (None$.MODULE$.equals(option)) {
                TransactionMetadata cfr_ignored_0 = (TransactionMetadata)loadedTransactions$1.remove(transactionalId);
            } else if (option instanceof Some) {
                TransactionMetadata txnMetadata = (TransactionMetadata)((Some)option).value();
                loadedTransactions$1.put(transactionalId, txnMetadata);
            } else {
                throw new MatchError(option);
            }
            currOffset$1.elem = batch$1.nextOffset();
            return;
        }
        if (baseKey instanceof UnknownKey) {
            UnknownKey unknownKey = (UnknownKey)baseKey;
            $this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(134).append("Unknown message key with version ").append(unknownKey.version()).append(" while loading transaction state from ").append(topicPartition$2).append(". Ignoring it. ").append("It could be a left over from an aborted upgrade.").toString());
            return;
        }
        throw new MatchError((Object)baseKey);
    }

    public static final /* synthetic */ boolean $anonfun$loadTransactionsForTxnTopicPartition$1(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$2) {
        return $this.loadingPartitions().add((Object)partitionAndLeaderEpoch$2);
    }

    public static final /* synthetic */ void $anonfun$loadTransactionsForTxnTopicPartition$7(Function4 sendTxnMarkers$1, TransactionalIdCoordinatorEpochAndTransitMetadata txnTransitMetadata) {
        sendTxnMarkers$1.apply((Object)BoxesRunTime.boxToInteger((int)txnTransitMetadata.coordinatorEpoch()), (Object)txnTransitMetadata.result(), (Object)txnTransitMetadata.txnMetadata(), (Object)txnTransitMetadata.transitMetadata());
    }

    public static final /* synthetic */ void $anonfun$loadTransactionsForTxnTopicPartition$4(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$2, TopicPartition topicPartition$3, int coordinatorEpoch$3, Pool loadedTransactions$2, Function4 sendTxnMarkers$1) {
        if ($this.loadingPartitions().contains((Object)partitionAndLeaderEpoch$2)) {
            $this.addLoadedTransactionsToCache(topicPartition$3.partition(), coordinatorEpoch$3, loadedTransactions$2);
            ListBuffer transactionsPendingForCompletion = new ListBuffer();
            loadedTransactions$2.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 != null) {
                    String transactionalId = (String)x0$1._1();
                    TransactionMetadata txnMetadata = (TransactionMetadata)x0$1._2();
                    return txnMetadata.inLock((Function0 & Serializable & scala.Serializable)() -> {
                        TransactionState transactionState = txnMetadata.state();
                        if (PrepareAbort$.MODULE$.equals(transactionState)) {
                            return transactionsPendingForCompletion.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$3, TransactionResult.ABORT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds())));
                        }
                        if (PrepareCommit$.MODULE$.equals(transactionState)) {
                            return transactionsPendingForCompletion.$plus$eq((Object)new TransactionalIdCoordinatorEpochAndTransitMetadata(transactionalId, coordinatorEpoch$3, TransactionResult.COMMIT, txnMetadata, txnMetadata.prepareComplete($this.time.milliseconds())));
                        }
                        return BoxedUnit.UNIT;
                    });
                }
                throw new MatchError(null);
            });
            $this.loadingPartitions().remove((Object)partitionAndLeaderEpoch$2);
            transactionsPendingForCompletion.foreach((Function1 & Serializable & scala.Serializable)txnTransitMetadata -> {
                sendTxnMarkers$1.apply((Object)BoxesRunTime.boxToInteger((int)txnTransitMetadata.coordinatorEpoch()), (Object)txnTransitMetadata.result(), (Object)txnTransitMetadata.txnMetadata(), (Object)txnTransitMetadata.transitMetadata());
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void loadTransactions$1(Long startTimeMs, TopicPartition topicPartition$3, int coordinatorEpoch$3, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$2, Function4 sendTxnMarkers$1) {
        void inWriteLock_lock;
        long schedulerTimeMs = this.time.milliseconds() - Predef$.MODULE$.Long2long(startTimeMs);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Loading transaction metadata from ").append(topicPartition).append(" at epoch ").append(coordinatorEpoch).toString());
        this.validateTransactionTopicPartitionCountIsStable();
        Pool<String, TransactionMetadata> loadedTransactions = this.loadTransactionMetadata(topicPartition$3, coordinatorEpoch$3);
        long endTimeMs = this.time.milliseconds();
        long totalLoadingTimeMs = endTimeMs - Predef$.MODULE$.Long2long(startTimeMs);
        this.partitionLoadSensor().record((double)totalLoadingTimeMs, endTimeMs, false);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(113).append("Finished loading ").append(loadTransactions$1_loadedTransactions.size()).append(" transaction metadata from ").append(topicPartition).append(" in ").append(loadTransactions$1_totalLoadingTimeMs).append(" milliseconds, of which ").append(loadTransactions$1_schedulerTimeMs).append(" milliseconds was spent in the scheduler.").toString());
        ReentrantReadWriteLock reentrantReadWriteLock = this.stateLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            TransactionStateManager.$anonfun$loadTransactionsForTxnTopicPartition$4(this, partitionAndLeaderEpoch$2, topicPartition$3, coordinatorEpoch$3, loadedTransactions, sendTxnMarkers$1);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Completed loading transaction metadata from ").append(topicPartition).append(" for coordinator epoch ").append(coordinatorEpoch).toString());
    }

    public static final /* synthetic */ boolean $anonfun$removeTransactionsForTxnTopicPartition$2(int partitionId$2, TransactionPartitionAndLeaderEpoch x$5) {
        return x$5.txnPartitionId() == partitionId$2;
    }

    public static final /* synthetic */ void $anonfun$removeTransactionsForTxnTopicPartition$1(TransactionStateManager $this, int partitionId$2, TopicPartition topicPartition$4) {
        $this.loadingPartitions().$minus$minus$eq((TraversableOnce)$this.loadingPartitions().filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManager.$anonfun$removeTransactionsForTxnTopicPartition$2(partitionId$2, x$5))));
        $this.transactionMetadataCache().remove((Object)BoxesRunTime.boxToInteger((int)partitionId$2)).foreach((Function1 & Serializable & scala.Serializable)txnMetadataCacheEntry -> {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(70).append("Unloaded transaction metadata ").append(txnMetadataCacheEntry).append(" for ").append(topicPartition$4).append(" following ").append("local partition deletion").toString());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$removeTransactionsForTxnTopicPartition$5(TransactionStateManager $this, TransactionPartitionAndLeaderEpoch partitionAndLeaderEpoch$3, int partitionId$3, TopicPartition topicPartition$5) {
        $this.loadingPartitions().remove((Object)partitionAndLeaderEpoch$3);
        Option option = $this.transactionMetadataCache().remove((Object)BoxesRunTime.boxToInteger((int)partitionId$3));
        if (option instanceof Some) {
            TxnMetadataCacheEntry txnMetadataCacheEntry = (TxnMetadataCacheEntry)((Some)option).value();
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("Unloaded transaction metadata ").append(txnMetadataCacheEntry).append(" for ").append(topicPartition$5).append(" on become-follower transition").toString());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("No cached transaction metadata found for ").append(topicPartition$5).append(" during become-follower transition").toString());
            return;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$1(String transactionalId$5, TxnTransitMetadata newMetadata$1, ProduceResponse.PartitionResponse status$1) {
        return new StringBuilder(41).append("Appending ").append(transactionalId$5).append("'s new metadata ").append(newMetadata$1).append(" failed due to ").append(status$1.error.exceptionName()).toString();
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$2(String transactionalId$5, Errors err$1) {
        return new StringBuilder(140).append("Accessing the cached transaction metadata for ").append(transactionalId$5).append(" returns ").append(err$1).append(" error; ").append("aborting transition to the new metadata and setting the error in the callback").toString();
    }

    public static final /* synthetic */ void $anonfun$appendTransactionToLog$3(TransactionStateManager $this, CoordinatorEpochAndTxnMetadata epochAndMetadata$1, int coordinatorEpoch$4, String transactionalId$5, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1, TransactionMetadata metadata$1) {
        if (epochAndMetadata$1.coordinatorEpoch() != coordinatorEpoch$4) {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(231).append("The cached coordinator epoch for ").append(transactionalId$5).append(" has changed to ").append(epochAndMetadata$1.coordinatorEpoch()).append(" after appended its new metadata ").append(newMetadata$1).append(" ").append("to the transaction log (txn topic partition ").append($this.partitionFor(transactionalId$5)).append(") while it was ").append(coordinatorEpoch$4).append(" before appending; ").append("aborting transition to the new metadata and returning ").append(Errors.NOT_COORDINATOR).append(" in the callback").toString());
            responseError$1.elem = Errors.NOT_COORDINATOR;
            return;
        }
        metadata$1.completeTransitionTo(newMetadata$1);
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("Updating ").append(transactionalId$5).append("'s transaction state to ").append(newMetadata$1).append(" with coordinator epoch ").append(coordinatorEpoch$4).append(" for ").append(transactionalId$5).append(" succeeded").toString());
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$6(TransactionStateManager $this, String transactionalId$5, TxnTransitMetadata newMetadata$1, int coordinatorEpoch$4) {
        return new StringBuilder(254).append("The cached coordinator metadata does not exist in the cache anymore for ").append(transactionalId$5).append(" after appended its new metadata ").append(newMetadata$1).append(" ").append("to the transaction log (txn topic partition ").append($this.partitionFor(transactionalId$5)).append(") while it was ").append(coordinatorEpoch$4).append(" before appending; ").append("aborting transition to the new metadata and returning ").append(Errors.NOT_COORDINATOR).append(" in the callback").toString();
    }

    public static final /* synthetic */ void $anonfun$appendTransactionToLog$7(TransactionStateManager $this, CoordinatorEpochAndTxnMetadata epochAndTxnMetadata$1, int coordinatorEpoch$4, Function1 retryOnError$1, ObjectRef responseError$1, TransactionMetadata metadata$2, TxnTransitMetadata newMetadata$1) {
        if (epochAndTxnMetadata$1.coordinatorEpoch() == coordinatorEpoch$4) {
            if (BoxesRunTime.unboxToBoolean((Object)retryOnError$1.apply((Object)((Errors)responseError$1.elem)))) {
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(169).append("TransactionalId ").append(metadata$2.transactionalId()).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").append("not resetting pending state ").append(metadata$2.pendingState()).append(" but just returning the error in the callback to let the caller retry").toString());
                return;
            }
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(159).append("TransactionalId ").append(metadata$2.transactionalId()).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").append("resetting pending state from ").append(metadata$2.pendingState()).append(", aborting state transition and returning ").append((Errors)responseError$1.elem).append(" in the callback").toString());
            metadata$2.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
            return;
        }
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(187).append("TransactionalId ").append(metadata$2.transactionalId()).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").append("aborting state transition and returning the error in the callback since the coordinator epoch has changed from ").append(epochAndTxnMetadata$1.coordinatorEpoch()).append(" to ").append(coordinatorEpoch$4).toString());
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$11(String transactionalId$5, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1) {
        return new StringBuilder(190).append("TransactionalId ").append(transactionalId$5).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").append("aborting state transition and returning the error in the callback since metadata is not available in the cache anymore").toString();
    }

    public static final /* synthetic */ String $anonfun$appendTransactionToLog$12(String transactionalId$5, TxnTransitMetadata newMetadata$1, ObjectRef responseError$1, Errors error$1) {
        return new StringBuilder(173).append("TransactionalId ").append(transactionalId$5).append(" append transaction log for ").append(newMetadata$1).append(" transition failed due to ").append((Errors)responseError$1.elem).append(", ").append("aborting state transition and returning the error in the callback since retrieving metadata returned ").append(error$1).toString();
    }

    /*
     * Unable to fully structure code
     */
    private final void updateCacheCallback$1(Map responseStatus, TopicPartition topicPartition$6, String transactionalId$5, TxnTransitMetadata newMetadata$1, int coordinatorEpoch$4, Function1 retryOnError$1, Function1 responseCallback$1) {
        block11: {
            block9: {
                block13: {
                    block12: {
                        block10: {
                            if (responseStatus.size() != 1 || !responseStatus.contains((Object)topicPartition$6)) {
                                throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Append status %s should only have one partition %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{responseStatus, topicPartition$6})));
                            }
                            status = (ProduceResponse.PartitionResponse)responseStatus.apply((Object)topicPartition$6);
                            v0 = status.error;
                            var10_9 = Errors.NONE;
                            if (!(v0 != null ? v0.equals(var10_9) == false : var10_9 != null)) {
                                v1 = Errors.NONE;
                            } else {
                                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$1(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata org.apache.kafka.common.requests.ProduceResponse$PartitionResponse ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ProduceResponse.PartitionResponse)status));
                                var11_10 = status.error;
                                v1 = (Errors.UNKNOWN_TOPIC_OR_PARTITION.equals(var11_10) != false ? true : (Errors.NOT_ENOUGH_REPLICAS.equals(var11_10) != false ? true : (Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND.equals(var11_10) != false ? true : Errors.REQUEST_TIMED_OUT.equals(var11_10) != false))) != false ? Errors.COORDINATOR_NOT_AVAILABLE : ((Errors.NOT_LEADER_OR_FOLLOWER.equals(var11_10) != false ? true : Errors.KAFKA_STORAGE_ERROR.equals(var11_10) != false) != false ? Errors.NOT_COORDINATOR : ((Errors.MESSAGE_TOO_LARGE.equals(var11_10) != false ? true : Errors.RECORD_LIST_TOO_LARGE.equals(var11_10) != false) != false ? Errors.UNKNOWN_SERVER_ERROR : var11_10));
                            }
                            responseError = ObjectRef.create((Object)v1);
                            v2 = (Errors)responseError.elem;
                            var12_12 = Errors.NONE;
                            if (v2 != null ? v2.equals(var12_12) == false : var12_12 != null) break block9;
                            var13_13 = false;
                            var14_14 = null;
                            var15_15 = this.getTransactionState(transactionalId$5);
                            if (!(var15_15 instanceof Left)) break block10;
                            err = (Errors)((Left)var15_15).value();
                            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$2(java.lang.String org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$5, (Errors)err));
                            responseError.elem = err;
                            break block11;
                        }
                        if (!(var15_15 instanceof Right)) break block12;
                        var13_13 = true;
                        var14_14 = (Right)var15_15;
                        var17_17 = (Option)var14_14.value();
                        if (!(var17_17 instanceof Some)) break block12;
                        epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var17_17).value();
                        metadata = epochAndMetadata.transactionMetadata();
                        (BoxedUnit)metadata.inLock((JFunction0.mcV.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$3(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata ), ()V)((TransactionStateManager)this, (CoordinatorEpochAndTxnMetadata)epochAndMetadata, (int)coordinatorEpoch$4, (String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError, (TransactionMetadata)metadata));
                        break block11;
                    }
                    if (!var13_13 || !None$.MODULE$.equals(var20_20 = (Option)var14_14.value())) break block13;
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$6(kafka.coordinator.transaction.TransactionStateManager java.lang.String kafka.coordinator.transaction.TxnTransitMetadata int ), ()Ljava/lang/String;)((TransactionStateManager)this, (String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (int)coordinatorEpoch$4));
                    responseError.elem = Errors.NOT_COORDINATOR;
                    break block11;
                }
                throw new MatchError(var15_15);
            }
            var21_21 = false;
            var22_22 = null;
            var23_23 = this.getTransactionState(transactionalId$5);
            if (!(var23_23 instanceof Right)) ** GOTO lbl-1000
            var21_21 = true;
            var22_22 = (Right)var23_23;
            var24_24 = (Option)var22_22.value();
            if (var24_24 instanceof Some) {
                epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var24_24).value();
                metadata = epochAndTxnMetadata.transactionMetadata();
                (BoxedUnit)metadata.inLock((JFunction0.mcV.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$7(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int scala.Function1 scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata kafka.coordinator.transaction.TxnTransitMetadata ), ()V)((TransactionStateManager)this, (CoordinatorEpochAndTxnMetadata)epochAndTxnMetadata, (int)coordinatorEpoch$4, (Function1)retryOnError$1, (ObjectRef)responseError, (TransactionMetadata)metadata, (TxnTransitMetadata)newMetadata$1));
            } else if (var21_21 && None$.MODULE$.equals(var27_27 = (Option)var22_22.value())) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$11(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError));
            } else if (var23_23 instanceof Left) {
                error = (Errors)((Left)var23_23).value();
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$12(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)responseError, (Errors)error));
            } else {
                throw new MatchError(var23_23);
            }
        }
        responseCallback$1.apply((Object)((Errors)responseError.elem));
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$appendTransactionToLog$15(TransactionStateManager $this, TopicPartition topicPartition$6, String transactionalId$5, TxnTransitMetadata newMetadata$1, int coordinatorEpoch$4, Function1 retryOnError$1, Function1 responseCallback$1, Map responseStatus) {
        block11: {
            block9: {
                block13: {
                    block12: {
                        block10: {
                            if (responseStatus.size() != 1 || !responseStatus.contains((Object)topicPartition$6)) {
                                throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Append status %s should only have one partition %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{responseStatus, topicPartition$6})));
                            }
                            updateCacheCallback$1_status = (ProduceResponse.PartitionResponse)responseStatus.apply((Object)topicPartition$6);
                            v0 = updateCacheCallback$1_status.error;
                            var10_9 = Errors.NONE;
                            if (!(v0 != null ? v0.equals(var10_9) == false : var10_9 != null)) {
                                v1 = Errors.NONE;
                            } else {
                                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$1(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata org.apache.kafka.common.requests.ProduceResponse$PartitionResponse ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ProduceResponse.PartitionResponse)updateCacheCallback$1_status));
                                var11_10 = updateCacheCallback$1_status.error;
                                v1 = (Errors.UNKNOWN_TOPIC_OR_PARTITION.equals(var11_10) != false ? true : (Errors.NOT_ENOUGH_REPLICAS.equals(var11_10) != false ? true : (Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND.equals(var11_10) != false ? true : Errors.REQUEST_TIMED_OUT.equals(var11_10) != false))) != false ? Errors.COORDINATOR_NOT_AVAILABLE : ((Errors.NOT_LEADER_OR_FOLLOWER.equals(var11_10) != false ? true : Errors.KAFKA_STORAGE_ERROR.equals(var11_10) != false) != false ? Errors.NOT_COORDINATOR : ((Errors.MESSAGE_TOO_LARGE.equals(var11_10) != false ? true : Errors.RECORD_LIST_TOO_LARGE.equals(var11_10) != false) != false ? Errors.UNKNOWN_SERVER_ERROR : var11_10));
                            }
                            updateCacheCallback$1_responseError = ObjectRef.create((Object)v1);
                            v2 = (Errors)updateCacheCallback$1_responseError.elem;
                            var12_12 = Errors.NONE;
                            if (v2 != null ? v2.equals(var12_12) == false : var12_12 != null) break block9;
                            var13_13 = false;
                            var14_14 = null;
                            var15_15 = $this.getTransactionState(transactionalId$5);
                            if (!(var15_15 instanceof Left)) break block10;
                            updateCacheCallback$1_err = (Errors)((Left)var15_15).value();
                            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$2(java.lang.String org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$5, (Errors)updateCacheCallback$1_err));
                            updateCacheCallback$1_responseError.elem = updateCacheCallback$1_err;
                            break block11;
                        }
                        if (!(var15_15 instanceof Right)) break block12;
                        var13_13 = true;
                        var14_14 = (Right)var15_15;
                        var17_17 = (Option)var14_14.value();
                        if (!(var17_17 instanceof Some)) break block12;
                        updateCacheCallback$1_epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var17_17).value();
                        updateCacheCallback$1_metadata = updateCacheCallback$1_epochAndMetadata.transactionMetadata();
                        (BoxedUnit)updateCacheCallback$1_metadata.inLock((JFunction0.mcV.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$3(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata ), ()V)((TransactionStateManager)$this, (CoordinatorEpochAndTxnMetadata)updateCacheCallback$1_epochAndMetadata, (int)coordinatorEpoch$4, (String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)updateCacheCallback$1_responseError, (TransactionMetadata)updateCacheCallback$1_metadata));
                        break block11;
                    }
                    if (!var13_13 || !None$.MODULE$.equals(var20_20 = (Option)var14_14.value())) break block13;
                    $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$6(kafka.coordinator.transaction.TransactionStateManager java.lang.String kafka.coordinator.transaction.TxnTransitMetadata int ), ()Ljava/lang/String;)((TransactionStateManager)$this, (String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (int)coordinatorEpoch$4));
                    updateCacheCallback$1_responseError.elem = Errors.NOT_COORDINATOR;
                    break block11;
                }
                throw new MatchError(var15_15);
            }
            var21_21 = false;
            var22_22 = null;
            var23_23 = $this.getTransactionState(transactionalId$5);
            if (!(var23_23 instanceof Right)) ** GOTO lbl-1000
            var21_21 = true;
            var22_22 = (Right)var23_23;
            var24_24 = (Option)var22_22.value();
            if (var24_24 instanceof Some) {
                updateCacheCallback$1_epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var24_24).value();
                updateCacheCallback$1_metadata = updateCacheCallback$1_epochAndTxnMetadata.transactionMetadata();
                (BoxedUnit)updateCacheCallback$1_metadata.inLock((JFunction0.mcV.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$7(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int scala.Function1 scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata kafka.coordinator.transaction.TxnTransitMetadata ), ()V)((TransactionStateManager)$this, (CoordinatorEpochAndTxnMetadata)updateCacheCallback$1_epochAndTxnMetadata, (int)coordinatorEpoch$4, (Function1)retryOnError$1, (ObjectRef)updateCacheCallback$1_responseError, (TransactionMetadata)updateCacheCallback$1_metadata, (TxnTransitMetadata)newMetadata$1));
            } else if (var21_21 && None$.MODULE$.equals(var27_27 = (Option)var22_22.value())) {
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$11(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)updateCacheCallback$1_responseError));
            } else if (var23_23 instanceof Left) {
                updateCacheCallback$1_error = (Errors)((Left)var23_23).value();
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$12(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)updateCacheCallback$1_responseError, (Errors)updateCacheCallback$1_error));
            } else {
                throw new MatchError(var23_23);
            }
        }
        responseCallback$1.apply((Object)((Errors)updateCacheCallback$1_responseError.elem));
    }

    public static final /* synthetic */ void $anonfun$appendTransactionToLog$13(TransactionStateManager $this, String transactionalId$5, Function1 responseCallback$1, int coordinatorEpoch$4, TxnTransitMetadata newMetadata$1, scala.collection.immutable.Map recordsPerPartition$1, RequestLocal requestLocal$1, TopicPartition topicPartition$6, Function1 retryOnError$1) {
        Option option;
        boolean bl = false;
        Right right = null;
        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = $this.getTransactionState(transactionalId$5);
        if (either instanceof Left) {
            Errors err = (Errors)((Left)either).value();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback$1.apply((Object)err);
            return;
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (None$.MODULE$.equals(option2)) {
                BoxedUnit cfr_ignored_1 = (BoxedUnit)responseCallback$1.apply((Object)Errors.NOT_COORDINATOR);
                return;
            }
        }
        if (bl && (option = (Option)right.value()) instanceof Some) {
            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)option).value();
            if (BoxesRunTime.unboxToBoolean(epochAndMetadata.transactionMetadata().inLock((JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                if (epochAndMetadata.coordinatorEpoch() != coordinatorEpoch$4) {
                    responseCallback$1.apply((Object)Errors.NOT_COORDINATOR);
                    return false;
                }
                return true;
            }))) {
                long x$1 = newMetadata$1.txnTimeoutMs();
                short x$2 = TransactionLog$.MODULE$.EnforcedRequiredAcks();
                boolean x$3 = true;
                AppendOrigin x$4 = AppendOrigin.COORDINATOR;
                Function1 & Serializable & scala.Serializable x$6 = arg_0 -> TransactionStateManager.$anonfun$appendTransactionToLog$15$adapted($this, topicPartition$6, transactionalId$5, newMetadata$1, coordinatorEpoch$4, retryOnError$1, responseCallback$1, arg_0);
                Option<Lock> x$8 = $this.replicaManager.appendRecords$default$7();
                Function1<Map<TopicPartition, RecordConversionStats>, BoxedUnit> x$9 = $this.replicaManager.appendRecords$default$8();
                String x$10 = $this.replicaManager.appendRecords$default$10();
                Option<Object> x$11 = $this.replicaManager.appendRecords$default$11();
                ActionQueue x$12 = $this.replicaManager.appendRecords$default$12();
                $this.replicaManager.appendRecords(x$1, x$2, x$3, x$4, (Map<TopicPartition, MemoryRecords>)recordsPerPartition$1, (Function1<Map<TopicPartition, ProduceResponse.PartitionResponse>, BoxedUnit>)x$6, x$8, x$9, requestLocal$1, x$10, x$11, x$12);
                $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(96).append("Appending new metadata ").append(newMetadata$1).append(" for transaction id ").append(transactionalId$5).append(" with coordinator epoch ").append(coordinatorEpoch$4).append(" to the local transaction log").toString());
                return;
            }
            return;
        }
        throw new MatchError(either);
    }

    public static final /* synthetic */ boolean $anonfun$appendTransactionToLog$default$5$1(Errors x$6) {
        return false;
    }

    public TransactionStateManager(int brokerId, Scheduler scheduler, ReplicaManager replicaManager, TransactionConfig config, Time time, Metrics metrics) {
        this.scheduler = scheduler;
        this.replicaManager = replicaManager;
        this.config = config;
        this.time = time;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(30).append("[Transaction State Manager ").append(brokerId).append("]: ").toString());
        this.shuttingDown = new AtomicBoolean(false);
        this.stateLock = new ReentrantReadWriteLock();
        this.loadingPartitions = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.transactionMetadataCache = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.partitionLoadSensor = metrics.sensor(TransactionStateManager$.MODULE$.LoadTimeSensor());
        this.partitionLoadSensor().add(metrics.metricName("partition-load-time-max", TransactionStateManager$.MODULE$.MetricsGroup(), "The max time it took to load the partitions in the last 30sec"), (MeasurableStat)new Max());
        this.partitionLoadSensor().add(metrics.metricName("partition-load-time-avg", TransactionStateManager$.MODULE$.MetricsGroup(), "The avg time it took to load the partitions in the last 30sec"), (MeasurableStat)new Avg());
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Object $anonfun$appendTransactionToLog$15$adapted(TransactionStateManager $this, TopicPartition topicPartition$6, String transactionalId$5, TxnTransitMetadata newMetadata$1, int coordinatorEpoch$4, Function1 retryOnError$1, Function1 responseCallback$1, Map responseStatus) {
        block11: {
            block9: {
                block13: {
                    block12: {
                        block10: {
                            if (responseStatus.size() != 1 || !responseStatus.contains((Object)topicPartition$6)) {
                                throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Append status %s should only have one partition %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{responseStatus, topicPartition$6})));
                            }
                            $anonfun$appendTransactionToLog$15_updateCacheCallback$1_status = (ProduceResponse.PartitionResponse)responseStatus.apply((Object)topicPartition$6);
                            v0 = $anonfun$appendTransactionToLog$15_updateCacheCallback$1_status.error;
                            var10_9 = Errors.NONE;
                            if (!(v0 != null ? v0.equals(var10_9) == false : var10_9 != null)) {
                                v1 = Errors.NONE;
                            } else {
                                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$1(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata org.apache.kafka.common.requests.ProduceResponse$PartitionResponse ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ProduceResponse.PartitionResponse)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_status));
                                var11_10 = $anonfun$appendTransactionToLog$15_updateCacheCallback$1_status.error;
                                v1 = (Errors.UNKNOWN_TOPIC_OR_PARTITION.equals(var11_10) != false ? true : (Errors.NOT_ENOUGH_REPLICAS.equals(var11_10) != false ? true : (Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND.equals(var11_10) != false ? true : Errors.REQUEST_TIMED_OUT.equals(var11_10) != false))) != false ? Errors.COORDINATOR_NOT_AVAILABLE : ((Errors.NOT_LEADER_OR_FOLLOWER.equals(var11_10) != false ? true : Errors.KAFKA_STORAGE_ERROR.equals(var11_10) != false) != false ? Errors.NOT_COORDINATOR : ((Errors.MESSAGE_TOO_LARGE.equals(var11_10) != false ? true : Errors.RECORD_LIST_TOO_LARGE.equals(var11_10) != false) != false ? Errors.UNKNOWN_SERVER_ERROR : var11_10));
                            }
                            $anonfun$appendTransactionToLog$15_updateCacheCallback$1_responseError = ObjectRef.create((Object)v1);
                            v2 = (Errors)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_responseError.elem;
                            var12_12 = Errors.NONE;
                            if (v2 != null ? v2.equals(var12_12) == false : var12_12 != null) break block9;
                            var13_13 = false;
                            var14_14 = null;
                            var15_15 = $this.getTransactionState(transactionalId$5);
                            if (!(var15_15 instanceof Left)) break block10;
                            $anonfun$appendTransactionToLog$15_updateCacheCallback$1_err = (Errors)((Left)var15_15).value();
                            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$2(java.lang.String org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$5, (Errors)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_err));
                            $anonfun$appendTransactionToLog$15_updateCacheCallback$1_responseError.elem = $anonfun$appendTransactionToLog$15_updateCacheCallback$1_err;
                            break block11;
                        }
                        if (!(var15_15 instanceof Right)) break block12;
                        var13_13 = true;
                        var14_14 = (Right)var15_15;
                        var17_17 = (Option)var14_14.value();
                        if (!(var17_17 instanceof Some)) break block12;
                        $anonfun$appendTransactionToLog$15_updateCacheCallback$1_epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var17_17).value();
                        $anonfun$appendTransactionToLog$15_updateCacheCallback$1_metadata = $anonfun$appendTransactionToLog$15_updateCacheCallback$1_epochAndMetadata.transactionMetadata();
                        (BoxedUnit)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_metadata.inLock((JFunction0.mcV.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$3(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata ), ()V)((TransactionStateManager)$this, (CoordinatorEpochAndTxnMetadata)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_epochAndMetadata, (int)coordinatorEpoch$4, (String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_responseError, (TransactionMetadata)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_metadata));
                        break block11;
                    }
                    if (!var13_13 || !None$.MODULE$.equals(var20_20 = (Option)var14_14.value())) break block13;
                    $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$6(kafka.coordinator.transaction.TransactionStateManager java.lang.String kafka.coordinator.transaction.TxnTransitMetadata int ), ()Ljava/lang/String;)((TransactionStateManager)$this, (String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (int)coordinatorEpoch$4));
                    $anonfun$appendTransactionToLog$15_updateCacheCallback$1_responseError.elem = Errors.NOT_COORDINATOR;
                    break block11;
                }
                throw new MatchError(var15_15);
            }
            var21_21 = false;
            var22_22 = null;
            var23_23 = $this.getTransactionState(transactionalId$5);
            if (!(var23_23 instanceof Right)) ** GOTO lbl-1000
            var21_21 = true;
            var22_22 = (Right)var23_23;
            var24_24 = (Option)var22_22.value();
            if (var24_24 instanceof Some) {
                $anonfun$appendTransactionToLog$15_updateCacheCallback$1_epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)var24_24).value();
                $anonfun$appendTransactionToLog$15_updateCacheCallback$1_metadata = $anonfun$appendTransactionToLog$15_updateCacheCallback$1_epochAndTxnMetadata.transactionMetadata();
                (BoxedUnit)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_metadata.inLock((JFunction0.mcV.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$appendTransactionToLog$7(kafka.coordinator.transaction.TransactionStateManager kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata int scala.Function1 scala.runtime.ObjectRef kafka.coordinator.transaction.TransactionMetadata kafka.coordinator.transaction.TxnTransitMetadata ), ()V)((TransactionStateManager)$this, (CoordinatorEpochAndTxnMetadata)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_epochAndTxnMetadata, (int)coordinatorEpoch$4, (Function1)retryOnError$1, (ObjectRef)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_responseError, (TransactionMetadata)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_metadata, (TxnTransitMetadata)newMetadata$1));
            } else if (var21_21 && None$.MODULE$.equals(var27_27 = (Option)var22_22.value())) {
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$11(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_responseError));
            } else if (var23_23 instanceof Left) {
                $anonfun$appendTransactionToLog$15_updateCacheCallback$1_error = (Errors)((Left)var23_23).value();
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$appendTransactionToLog$12(java.lang.String kafka.coordinator.transaction.TxnTransitMetadata scala.runtime.ObjectRef org.apache.kafka.common.protocol.Errors ), ()Ljava/lang/String;)((String)transactionalId$5, (TxnTransitMetadata)newMetadata$1, (ObjectRef)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_responseError, (Errors)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_error));
            } else {
                throw new MatchError(var23_23);
            }
        }
        responseCallback$1.apply((Object)((Errors)$anonfun$appendTransactionToLog$15_updateCacheCallback$1_responseError.elem));
        return BoxedUnit.UNIT;
    }
}

