/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.util.concurrent.ConcurrentMap;
import kafka.common.LogSegmentOffsetOverflowException;
import kafka.log.LogLoader$;
import kafka.log.LogSegment;
import kafka.log.LogSegment$;
import kafka.log.LogSegments;
import kafka.log.SplitSegmentResult;
import kafka.log.UnifiedLog$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidOffsetException;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.snapshot.Snapshots;
import org.apache.kafka.storage.internals.epoch.LeaderEpochFileCache;
import org.apache.kafka.storage.internals.log.CorruptIndexException;
import org.apache.kafka.storage.internals.log.LoadedLogOffsets;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.ProducerStateManager;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t%q!B\u0010!\u0011\u0003)c!B\u0014!\u0011\u0003A\u0003\"B\u001b\u0002\t\u00031\u0004bB\u001c\u0002\u0005\u0004%\t\u0001\u000f\u0005\u0007\u0003\u0006\u0001\u000b\u0011B\u001d\t\u000f\t\u000b\u0011\u0013!C\u0001\u0007\"91-AI\u0001\n\u0003!g\u0001B\u0014!\u0001%D\u0001B[\u0004\u0003\u0002\u0003\u0006Ia\u001b\u0005\tc\u001e\u0011\t\u0011)A\u0005e\"AQp\u0002B\u0001B\u0003%a\u0010\u0003\u0006\u0002\u0010\u001d\u0011\t\u0011)A\u0005\u0003#A!\"a\b\b\u0005\u0003\u0005\u000b\u0011BA\u0011\u0011)\tYc\u0002B\u0001B\u0003%\u0011Q\u0006\u0005\n\u0003g9!\u0011!Q\u0001\n\u0019D!\"!\u000e\b\u0005\u0003\u0005\u000b\u0011BA\u001c\u0011)\tid\u0002B\u0001B\u0003%\u0011q\b\u0005\u000b\u0003\u000b:!\u0011!Q\u0001\n\u0005}\u0002BCA$\u000f\t\u0005\t\u0015!\u0003\u0002J!Q\u00111L\u0004\u0003\u0002\u0003\u0006I!!\u0018\t\u0013\u0005\rtA!A!\u0002\u0013)\u0005\"CA3\u000f\t\u0005\t\u0015!\u0003g\u0011\u0019)t\u0001\"\u0001\u0002h!9\u0011qQ\u0004\u0005\u0002\u0005%\u0005bBAI\u000f\u0011%\u00111\u0013\u0005\b\u0003C;A\u0011BAR\u0011\u001d\t9m\u0002C\u0005\u0003\u0013Dq!!5\b\t\u0013\t\u0019\u000e\u0003\u0005\u0002`\u001e!\t\u0001IAq\u0011\u001d\tIo\u0002C\u0005\u0003WDqAa\u0001\b\t\u0013\u0011)!A\u0005M_\u001edu.\u00193fe*\u0011\u0011EI\u0001\u0004Y><'\"A\u0012\u0002\u000b-\fgm[1\u0004\u0001A\u0011a%A\u0007\u0002A\tIAj\\4M_\u0006$WM]\n\u0004\u0003%z\u0003C\u0001\u0016.\u001b\u0005Y#\"\u0001\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u00059Z#AB!osJ+g\r\u0005\u00021g5\t\u0011G\u0003\u00023E\u0005)Q\u000f^5mg&\u0011A'\r\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\tQ%A\tDY\u0016\fgn\u00155vi\u0012|wO\u001c$jY\u0016,\u0012!\u000f\t\u0003u}j\u0011a\u000f\u0006\u0003yu\nA\u0001\\1oO*\ta(\u0001\u0003kCZ\f\u0017B\u0001!<\u0005\u0019\u0019FO]5oO\u0006\u00112\t\\3b]NCW\u000f\u001e3po:4\u0015\u000e\\3!\u0003q!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%cM*\u0012\u0001\u0012\u0016\u0003\u000bj\u0003BAR&N/6\tqI\u0003\u0002I\u0013\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005)k\u0014\u0001B;uS2L!\u0001T$\u0003\u001b\r{gnY;se\u0016tG/T1q!\tqUK\u0004\u0002P'B\u0011\u0001kK\u0007\u0002#*\u0011!\u000bJ\u0001\u0007yI|w\u000e\u001e \n\u0005Q[\u0013A\u0002)sK\u0012,g-\u0003\u0002A-*\u0011Ak\u000b\t\u0003UaK!!W\u0016\u0003\u0007%sGoK\u0001\\!\ta\u0016-D\u0001^\u0015\tqv,A\u0005v]\u000eDWmY6fI*\u0011\u0001mK\u0001\u000bC:tw\u000e^1uS>t\u0017B\u00012^\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001dI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u00195+\u0005)'F\u00014[!\tQs-\u0003\u0002iW\t9!i\\8mK\u0006t7cA\u0004*_\u0005\u0019A-\u001b:\u0011\u00051|W\"A7\u000b\u00059l\u0014AA5p\u0013\t\u0001XN\u0001\u0003GS2,\u0017A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0003gnl\u0011\u0001\u001e\u0006\u0003kZ\faaY8n[>t'BA\u0012x\u0015\tA\u00180\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002u\u0006\u0019qN]4\n\u0005q$(A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0007G>tg-[4\u0011\u0007}\fY!\u0004\u0002\u0002\u0002)\u0019\u0011%a\u0001\u000b\t\u0005\u0015\u0011qA\u0001\nS:$XM\u001d8bYNT1!!\u0003w\u0003\u001d\u0019Ho\u001c:bO\u0016LA!!\u0004\u0002\u0002\tIAj\\4D_:4\u0017nZ\u0001\ng\u000eDW\rZ;mKJ\u0004B!a\u0005\u0002\u001c5\u0011\u0011Q\u0003\u0006\u0004\u0015\u0006]!bAA\rm\u000611/\u001a:wKJLA!!\b\u0002\u0016\tI1k\u00195fIVdWM]\u0001\u0005i&lW\r\u0005\u0003\u0002$\u0005\u001dRBAA\u0013\u0015\t\u0011D/\u0003\u0003\u0002*\u0005\u0015\"\u0001\u0002+j[\u0016\fA\u0003\\8h\t&\u0014h)Y5mkJ,7\t[1o]\u0016d\u0007cA@\u00020%!\u0011\u0011GA\u0001\u0005Qaun\u001a#je\u001a\u000b\u0017\u000e\\;sK\u000eC\u0017M\u001c8fY\u0006\u0001\u0002.\u00193DY\u0016\fgn\u00155vi\u0012|wO\\\u0001\tg\u0016<W.\u001a8ugB\u0019a%!\u000f\n\u0007\u0005m\u0002EA\u0006M_\u001e\u001cVmZ7f]R\u001c\u0018\u0001\u00077pON#\u0018M\u001d;PM\u001a\u001cX\r^\"iK\u000e\\\u0007o\\5oiB\u0019!&!\u0011\n\u0007\u0005\r3F\u0001\u0003M_:<\u0017a\u0006:fG>4XM]=Q_&tGo\u00115fG.\u0004x.\u001b8u\u0003AaW-\u00193fe\u0016\u0003xn\u00195DC\u000eDW\rE\u0003+\u0003\u0017\ny%C\u0002\u0002N-\u0012aa\u00149uS>t\u0007\u0003BA)\u0003/j!!a\u0015\u000b\t\u0005U\u00131A\u0001\u0006KB|7\r[\u0005\u0005\u00033\n\u0019F\u0001\u000bMK\u0006$WM]#q_\u000eDg)\u001b7f\u0007\u0006\u001c\u0007.Z\u0001\u0015aJ|G-^2feN#\u0018\r^3NC:\fw-\u001a:\u0011\u0007}\fy&\u0003\u0003\u0002b\u0005\u0005!\u0001\u0006)s_\u0012,8-\u001a:Ti\u0006$X-T1oC\u001e,'/\u0001\u000bok6\u0014V-\\1j]&twmU3h[\u0016tGo]\u0001\u0013SN\u0014V-\\8uK2{w-\u00128bE2,G\r\u0006\u0010\u0002j\u0005-\u0014QNA8\u0003c\n\u0019(!\u001e\u0002x\u0005e\u00141PA?\u0003\u007f\n\t)a!\u0002\u0006B\u0011ae\u0002\u0005\u0006UZ\u0001\ra\u001b\u0005\u0006cZ\u0001\rA\u001d\u0005\u0006{Z\u0001\rA \u0005\b\u0003\u001f1\u0002\u0019AA\t\u0011\u001d\tyB\u0006a\u0001\u0003CAq!a\u000b\u0017\u0001\u0004\ti\u0003\u0003\u0004\u00024Y\u0001\rA\u001a\u0005\b\u0003k1\u0002\u0019AA\u001c\u0011\u001d\tiD\u0006a\u0001\u0003\u007fAq!!\u0012\u0017\u0001\u0004\ty\u0004C\u0004\u0002HY\u0001\r!!\u0013\t\u000f\u0005mc\u00031\u0001\u0002^!A\u00111\r\f\u0011\u0002\u0003\u0007Q\t\u0003\u0005\u0002fY\u0001\n\u00111\u0001g\u0003\u0011aw.\u00193\u0015\u0005\u0005-\u0005cA@\u0002\u000e&!\u0011qRA\u0001\u0005Aau.\u00193fI2{wm\u00144gg\u0016$8/\u0001\u0012sK6|g/\u001a+f[B4\u0015\u000e\\3t\u0003:$7i\u001c7mK\u000e$8k^1q\r&dWm\u001d\u000b\u0003\u0003+\u0003R!a&\u0002\u001e.l!!!'\u000b\u0007\u0005m5&\u0001\u0006d_2dWm\u0019;j_:LA!a(\u0002\u001a\n\u00191+\u001a;\u0002+I,GO]=P]>3gm]3u\u001fZ,'O\u001a7poV!\u0011QUAV)\u0011\t9+!0\u0011\t\u0005%\u00161\u0016\u0007\u0001\t\u001d\ti+\u0007b\u0001\u0003_\u0013\u0011\u0001V\t\u0005\u0003c\u000b9\fE\u0002+\u0003gK1!!.,\u0005\u001dqu\u000e\u001e5j]\u001e\u00042AKA]\u0013\r\tYl\u000b\u0002\u0004\u0003:L\bbBA`3\u0001\u0007\u0011\u0011Y\u0001\u0003M:\u0004RAKAb\u0003OK1!!2,\u0005%1UO\\2uS>t\u0007'\u0001\tm_\u0006$7+Z4nK:$h)\u001b7fgR\u0011\u00111\u001a\t\u0004U\u00055\u0017bAAhW\t!QK\\5u\u00039\u0011XmY8wKJ\u001cVmZ7f]R$2aVAk\u0011\u001d\t9n\u0007a\u0001\u00033\fqa]3h[\u0016tG\u000fE\u0002'\u00037L1!!8!\u0005)aunZ*fO6,g\u000e^\u0001\u000be\u0016\u001cwN^3s\u0019><GCAAr!\u001dQ\u0013Q]A \u0003\u007fI1!a:,\u0005\u0019!V\u000f\u001d7fe\u0005a\"/Z7pm\u0016\fe\u000e\u001a#fY\u0016$XmU3h[\u0016tGo]!ts:\u001cG\u0003BAf\u0003[Dq!a<\u001e\u0001\u0004\t\t0\u0001\ttK\u001elWM\u001c;t)>$U\r\\3uKB1\u00111_A\u007f\u00033tA!!>\u0002z:\u0019\u0001+a>\n\u00031J1!a?,\u0003\u001d\u0001\u0018mY6bO\u0016LA!a@\u0003\u0002\tA\u0011\n^3sC\ndWMC\u0002\u0002|.\nA\u0004Z3mKR,\u0007K]8ek\u000e,'o\u00158baNDw\u000e^:Bgft7\r\u0006\u0003\u0002L\n\u001d\u0001bBA\u001b=\u0001\u0007\u0011\u0011\u001f")
public class LogLoader
implements Logging {
    private final File dir;
    private final TopicPartition topicPartition;
    private final LogConfig config;
    private final Scheduler scheduler;
    private final Time time;
    private final LogDirFailureChannel logDirFailureChannel;
    private final boolean hadCleanShutdown;
    private final LogSegments segments;
    private final long logStartOffsetCheckpoint;
    private final long recoveryPointCheckpoint;
    private final Option<LeaderEpochFileCache> leaderEpochCache;
    private final ProducerStateManager producerStateManager;
    private final ConcurrentMap<String, Object> numRemainingSegments;
    private final boolean isRemoteLogEnabled;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$14() {
        return LogLoader$.MODULE$.$lessinit$greater$default$14();
    }

    public static ConcurrentMap<String, Object> $lessinit$greater$default$13() {
        return LogLoader$.MODULE$.$lessinit$greater$default$13();
    }

    public static String CleanShutdownFile() {
        return LogLoader$.MODULE$.CleanShutdownFile();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public LoadedLogOffsets load() {
        long l;
        long l2;
        Set<File> swapFiles = this.removeTempFilesAndCollectSwapFiles();
        LongRef minSwapFileOffset = LongRef.create((long)Long.MAX_VALUE);
        LongRef maxSwapFileOffset = LongRef.create((long)Long.MIN_VALUE);
        ((IterableLike)swapFiles.filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)UnifiedLog$.MODULE$.isLogFile(new File(Utils.replaceSuffix((String)f.getPath(), (String)UnifiedLog$.MODULE$.SwapFileSuffix(), (String)"")))))).foreach((Function1 & Serializable & scala.Serializable)f -> {
            LogLoader.$anonfun$load$2(this, minSwapFileOffset, maxSwapFileOffset, f);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.dir.listFiles())).withFilter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)file.isFile())).foreach((Function1 & Serializable & scala.Serializable)file -> {
            Object object;
            block6: {
                try {
                    if (!file.getName().endsWith(UnifiedLog$.MODULE$.SwapFileSuffix())) {
                        long offset = UnifiedLog$.MODULE$.offsetFromFile((File)file);
                        if (offset >= minSwapFileOffset$1.elem && offset < maxSwapFileOffset$1.elem) {
                            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append("Deleting segment files ").append(file.getName()).append(" that is compacted but has not been deleted yet.").toString());
                            object = BoxesRunTime.boxToBoolean((boolean)file.delete());
                        } else {
                            object = BoxedUnit.UNIT;
                        }
                        break block6;
                    }
                    return BoxedUnit.UNIT;
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    return BoxedUnit.UNIT;
                }
                catch (NumberFormatException numberFormatException) {
                    object = BoxedUnit.UNIT;
                }
            }
            return object;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.dir.listFiles())).withFilter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)file.isFile())).foreach((Function1 & Serializable & scala.Serializable)file -> {
            if (file.getName().endsWith(UnifiedLog$.MODULE$.SwapFileSuffix())) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Recovering file ").append(file.getName()).append(" by renaming from ").append(UnifiedLog$.MODULE$.SwapFileSuffix()).append(" files.").toString());
                return BoxesRunTime.boxToBoolean((boolean)file.renameTo(new File(Utils.replaceSuffix((String)file.getPath(), (String)UnifiedLog$.MODULE$.SwapFileSuffix(), (String)""))));
            }
            return BoxedUnit.UNIT;
        });
        while (true) {
            try {
                LogLoader.$anonfun$load$10(this);
            }
            catch (LogSegmentOffsetOverflowException retryOnOffsetOverflow_e) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Caught segment overflow error: ").append(retryOnOffsetOverflow_e.getMessage()).append(". Split segment and retry.").toString());
                SplitSegmentResult retryOnOffsetOverflow_result = UnifiedLog$.MODULE$.splitOverflowedSegment(retryOnOffsetOverflow_e.segment(), this.segments, this.dir, this.topicPartition, this.config, this.scheduler, this.logDirFailureChannel, this.logIdent());
                this.deleteProducerSnapshotsAsync(retryOnOffsetOverflow_result.deletedSegments());
                continue;
            }
            break;
        }
        if (!this.dir.getAbsolutePath().endsWith(UnifiedLog$.MODULE$.DeleteDirSuffix())) {
            void var7_10;
            void var5_9;
            Tuple2 tuple2;
            while (true) {
                try {
                    tuple2 = this.recoverLog();
                }
                catch (LogSegmentOffsetOverflowException retryOnOffsetOverflow_e) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Caught segment overflow error: ").append(retryOnOffsetOverflow_e.getMessage()).append(". Split segment and retry.").toString());
                    SplitSegmentResult retryOnOffsetOverflow_result = UnifiedLog$.MODULE$.splitOverflowedSegment(retryOnOffsetOverflow_e.segment(), this.segments, this.dir, this.topicPartition, this.config, this.scheduler, this.logDirFailureChannel, this.logIdent());
                    this.deleteProducerSnapshotsAsync(retryOnOffsetOverflow_result.deletedSegments());
                    continue;
                }
                break;
            }
            Tuple2 tuple22 = tuple2;
            if (tuple22 == null) {
                throw new MatchError(null);
            }
            long newRecoveryPoint = tuple22._1$mcJ$sp();
            long nextOffset = tuple22._2$mcJ$sp();
            ((LogSegment)this.segments.lastSegment().get()).resizeIndexes(this.config.maxIndexSize);
            l2 = var5_9;
            l = var7_10;
        } else {
            if (this.segments.isEmpty()) {
                File x$9 = this.dir;
                long x$10 = 0L;
                LogConfig x$11 = this.config;
                Time x$12 = this.time;
                int x$13 = this.config.initFileSize();
                boolean x$14 = LogSegment$.MODULE$.open$default$5();
                boolean x$15 = LogSegment$.MODULE$.open$default$7();
                String x$16 = LogSegment$.MODULE$.open$default$8();
                this.segments.add(LogSegment$.MODULE$.open(x$9, x$10, x$11, x$12, x$14, x$13, x$15, x$16));
            }
            l2 = 0L;
            l = 0L;
        }
        long l3 = l;
        long l4 = l2;
        this.leaderEpochCache.foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.truncateFromEnd(l3);
            return BoxedUnit.UNIT;
        });
        long newLogStartOffset = this.isRemoteLogEnabled ? this.logStartOffsetCheckpoint : package$.MODULE$.max(this.logStartOffsetCheckpoint, ((LogSegment)this.segments.firstSegment().get()).baseOffset());
        this.leaderEpochCache.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.truncateFromStart(this.logStartOffsetCheckpoint);
            return BoxedUnit.UNIT;
        });
        if (!this.producerStateManager.isEmpty()) {
            throw new IllegalStateException("Producer state must be empty during log initialization");
        }
        this.producerStateManager.removeStraySnapshots(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)this.segments.baseOffsets().map((Function1 & Serializable & scala.Serializable)x -> LogLoader.$anonfun$load$14(BoxesRunTime.unboxToLong((Object)x)), Iterable$.MODULE$.canBuildFrom())).asJavaCollection());
        UnifiedLog$.MODULE$.rebuildProducerState(this.producerStateManager, this.segments, newLogStartOffset, l3, this.config.recordVersion(), this.time, this.hadCleanShutdown, this.logIdent());
        LogSegment activeSegment = (LogSegment)this.segments.lastSegment().get();
        return new LoadedLogOffsets(newLogStartOffset, l4, new LogOffsetMetadata(l3, activeSegment.baseOffset(), activeSegment.size()));
    }

    /*
     * WARNING - void declaration
     */
    private Set<File> removeTempFilesAndCollectSwapFiles() {
        void var6_6;
        void var5_5;
        scala.collection.mutable.Set swapFiles = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.mutable.Set cleanedFiles = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        LongRef minCleanedFileOffset = LongRef.create((long)Long.MAX_VALUE);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.dir.listFiles())).withFilter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)file.isFile())).foreach((Function1 & Serializable & scala.Serializable)file -> {
            if (!file.canRead()) {
                throw new IOException(new StringBuilder(20).append("Could not read file ").append(file).toString());
            }
            String filename = file.getName();
            if (filename.endsWith(".deleted") && !filename.endsWith(Snapshots.DELETE_SUFFIX)) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Deleting stray temporary file ").append(file.getAbsolutePath()).toString());
                return BoxesRunTime.boxToBoolean((boolean)Files.deleteIfExists(file.toPath()));
            }
            if (filename.endsWith(UnifiedLog$.MODULE$.CleanedFileSuffix())) {
                minCleanedFileOffset$1.elem = Math.min(UnifiedLog$.MODULE$.offsetFromFile((File)file), minCleanedFileOffset$1.elem);
                return cleanedFiles.$plus$eq(file);
            }
            if (filename.endsWith(UnifiedLog$.MODULE$.SwapFileSuffix())) {
                return swapFiles.$plus$eq(file);
            }
            return BoxedUnit.UNIT;
        });
        Tuple2 tuple2 = swapFiles.partition((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoader.$anonfun$removeTempFilesAndCollectSwapFiles$4(minCleanedFileOffset, file)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.mutable.Set invalidSwapFiles = (scala.collection.mutable.Set)tuple2._1();
        scala.collection.mutable.Set validSwapFiles = (scala.collection.mutable.Set)tuple2._2();
        void invalidSwapFiles2 = var5_5;
        void validSwapFiles2 = var6_6;
        invalidSwapFiles2.foreach((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoader.$anonfun$removeTempFilesAndCollectSwapFiles$5(this, minCleanedFileOffset, file)));
        cleanedFiles.foreach((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoader.$anonfun$removeTempFilesAndCollectSwapFiles$7(this, file)));
        return validSwapFiles2;
    }

    private <T> T retryOnOffsetOverflow(Function0<T> fn) {
        while (true) {
            try {
                return (T)fn.apply();
            }
            catch (LogSegmentOffsetOverflowException e) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Caught segment overflow error: ").append(retryOnOffsetOverflow_e.getMessage()).append(". Split segment and retry.").toString());
                SplitSegmentResult result = UnifiedLog$.MODULE$.splitOverflowedSegment(e.segment(), this.segments, this.dir, this.topicPartition, this.config, this.scheduler, this.logDirFailureChannel, this.logIdent());
                this.deleteProducerSnapshotsAsync(result.deletedSegments());
                continue;
            }
            break;
        }
    }

    private void loadSegmentFiles() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.dir.listFiles())).sortBy((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getName(), (Ordering)Ordering.String$.MODULE$))).withFilter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)file.isFile())).foreach((Function1 & Serializable & scala.Serializable)file -> {
            if (UnifiedLog$.MODULE$.isIndexFile((File)file)) {
                long offset = UnifiedLog$.MODULE$.offsetFromFile((File)file);
                if (!UnifiedLog$.MODULE$.logFile($this.dir, offset, UnifiedLog$.MODULE$.logFile$default$3()).exists()) {
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Found an orphaned index file ").append(file.getAbsolutePath()).append(", with no corresponding log file.").toString());
                    return BoxesRunTime.boxToBoolean((boolean)Files.deleteIfExists(file.toPath()));
                }
                return BoxedUnit.UNIT;
            }
            if (UnifiedLog$.MODULE$.isLogFile((File)file)) {
                long baseOffset = UnifiedLog$.MODULE$.offsetFromFile((File)file);
                boolean timeIndexFileNewlyCreated = !UnifiedLog$.MODULE$.timeIndexFile($this.dir, baseOffset, UnifiedLog$.MODULE$.timeIndexFile$default$3()).exists();
                LogSegment segment = LogSegment$.MODULE$.open($this.dir, baseOffset, $this.config, $this.time, true, LogSegment$.MODULE$.open$default$6(), LogSegment$.MODULE$.open$default$7(), LogSegment$.MODULE$.open$default$8());
                try {
                    segment.sanityCheck(timeIndexFileNewlyCreated);
                }
                catch (NoSuchFileException noSuchFileException) {
                    if ($this.hadCleanShutdown || segment.baseOffset() < $this.recoveryPointCheckpoint) {
                        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(109).append("Could not find offset index file corresponding to log file").append(" ").append(segment.log().file().getAbsolutePath()).append(", recovering segment and rebuilding index files...").toString());
                    }
                    this.recoverSegment(segment);
                }
                catch (CorruptIndexException e) {
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(114).append("Found a corrupted index file corresponding to log file").append(" ").append(segment.log().file().getAbsolutePath()).append(" due to ").append(e.getMessage()).append("}, recovering segment and").append(" rebuilding index files...").toString());
                    this.recoverSegment(segment);
                }
                return $this.segments.add(segment);
            }
            return BoxedUnit.UNIT;
        });
    }

    private int recoverSegment(LogSegment segment) {
        ProducerStateManager producerStateManager = new ProducerStateManager(this.topicPartition, this.dir, this.producerStateManager.maxTransactionTimeoutMs(), this.producerStateManager.producerStateManagerConfig(), this.time);
        UnifiedLog$.MODULE$.rebuildProducerState(producerStateManager, this.segments, this.logStartOffsetCheckpoint, segment.baseOffset(), this.config.recordVersion(), this.time, false, this.logIdent());
        int bytesTruncated = segment.recover(producerStateManager, this.leaderEpochCache);
        producerStateManager.takeSnapshot();
        return bytesTruncated;
    }

    public Tuple2<Object, Object> recoverLog() {
        boolean bl;
        if (!this.hadCleanShutdown) {
            Iterable<LogSegment> unflushed = this.segments.values(this.recoveryPointCheckpoint, Long.MAX_VALUE);
            int numUnflushed = unflushed.size();
            Iterator unflushedIter = unflushed.iterator();
            boolean truncated = false;
            IntRef numFlushed = IntRef.create((int)0);
            String threadName = Thread.currentThread().getName();
            this.numRemainingSegments.put(threadName, BoxesRunTime.boxToInteger((int)numUnflushed));
            while (unflushedIter.hasNext() && !truncated) {
                int n;
                LogSegment segment = (LogSegment)unflushedIter.next();
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Recovering unflushed segment ").append(segment.baseOffset()).append(". ").append(numFlushed$1.elem).append("/").append(numUnflushed).append(" recovered for ").append($this.topicPartition).append(".").toString());
                try {
                    n = this.recoverSegment(segment);
                }
                catch (InvalidOffsetException invalidOffsetException) {
                    long startOffset = segment.baseOffset();
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(114).append("Found invalid offset during recovery. Deleting the").append(" corrupt segment and creating an empty one with starting offset ").append(startOffset).toString());
                    n = segment.truncateTo(startOffset);
                }
                if (n > 0) {
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Corruption found in segment ").append(segment.baseOffset()).append(",").append(" truncating to offset ").append(segment.readNextOffset()).toString());
                    this.removeAndDeleteSegmentsAsync((Iterable<LogSegment>)unflushedIter.toList());
                    truncated = true;
                    this.numRemainingSegments.put(threadName, BoxesRunTime.boxToInteger((int)0));
                    continue;
                }
                ++numFlushed.elem;
                this.numRemainingSegments.put(threadName, BoxesRunTime.boxToInteger((int)(numUnflushed - numFlushed.elem)));
            }
        }
        Option logEndOffsetOption = this.deleteSegmentsIfLogStartGreaterThanLogEnd$1();
        if (this.segments.isEmpty()) {
            File x$1 = this.dir;
            long x$2 = this.logStartOffsetCheckpoint;
            LogConfig x$3 = this.config;
            Time x$4 = this.time;
            int x$5 = this.config.initFileSize();
            boolean x$6 = this.config.preallocate;
            boolean x$7 = LogSegment$.MODULE$.open$default$5();
            String x$8 = LogSegment$.MODULE$.open$default$8();
            this.segments.add(LogSegment$.MODULE$.open(x$1, x$2, x$3, x$4, x$7, x$5, x$6, x$8));
        }
        if ((bl = this.hadCleanShutdown) && logEndOffsetOption instanceof Some) {
            long logEndOffset = BoxesRunTime.unboxToLong((Object)((Some)logEndOffsetOption).value());
            return new Tuple2.mcJJ.sp(logEndOffset, logEndOffset);
        }
        long logEndOffset = BoxesRunTime.unboxToLong((Object)logEndOffsetOption.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> ((LogSegment)$this.segments.lastSegment().get()).readNextOffset()));
        return new Tuple2.mcJJ.sp(Math.min(this.recoveryPointCheckpoint, logEndOffset), logEndOffset);
    }

    private void removeAndDeleteSegmentsAsync(Iterable<LogSegment> segmentsToDelete) {
        if (segmentsToDelete.nonEmpty()) {
            List toDelete = segmentsToDelete.toList();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Deleting segments as part of log recovery: ").append(toDelete.mkString(",")).toString());
            toDelete.foreach((Function1 & Serializable & scala.Serializable)segment -> {
                this.segments.remove(segment.baseOffset());
                return BoxedUnit.UNIT;
            });
            UnifiedLog$.MODULE$.deleteSegmentFiles((scala.collection.immutable.Iterable<LogSegment>)toDelete, true, this.dir, this.topicPartition, this.config, this.scheduler, this.logDirFailureChannel, this.logIdent());
            this.deleteProducerSnapshotsAsync(segmentsToDelete);
            return;
        }
    }

    private void deleteProducerSnapshotsAsync(Iterable<LogSegment> segments) {
        UnifiedLog$.MODULE$.deleteProducerSnapshots(segments, this.producerStateManager, true, this.scheduler, this.config, this.logDirFailureChannel, this.dir.getParent(), this.topicPartition);
    }

    public static final /* synthetic */ void $anonfun$load$2(LogLoader $this, LongRef minSwapFileOffset$1, LongRef maxSwapFileOffset$1, File f) {
        long baseOffset = UnifiedLog$.MODULE$.offsetFromFile(f);
        File x$1 = f.getParentFile();
        LogConfig x$3 = $this.config;
        Time x$4 = $this.time;
        String x$5 = UnifiedLog$.MODULE$.SwapFileSuffix();
        boolean x$6 = LogSegment$.MODULE$.open$default$5();
        int x$7 = LogSegment$.MODULE$.open$default$6();
        boolean x$8 = LogSegment$.MODULE$.open$default$7();
        LogSegment segment = LogSegment$.MODULE$.open(x$1, baseOffset, x$3, x$4, x$6, x$7, x$8, x$5);
        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(94).append("Found log file ").append(f.getPath()).append(" from interrupted swap operation, which is recoverable from ").append(UnifiedLog$.MODULE$.SwapFileSuffix()).append(" files by renaming.").toString());
        minSwapFileOffset$1.elem = Math.min(segment.baseOffset(), minSwapFileOffset$1.elem);
        maxSwapFileOffset$1.elem = Math.max(segment.readNextOffset(), maxSwapFileOffset$1.elem);
    }

    public static final /* synthetic */ void $anonfun$load$10(LogLoader $this) {
        $this.segments.close();
        $this.segments.clear();
        $this.loadSegmentFiles();
    }

    public static final /* synthetic */ Long $anonfun$load$14(long x) {
        return BoxesRunTime.boxToLong((long)x);
    }

    public static final /* synthetic */ boolean $anonfun$removeTempFilesAndCollectSwapFiles$4(LongRef minCleanedFileOffset$1, File file) {
        return UnifiedLog$.MODULE$.offsetFromFile(file) >= minCleanedFileOffset$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$removeTempFilesAndCollectSwapFiles$5(LogLoader $this, LongRef minCleanedFileOffset$1, File file) {
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Deleting invalid swap file ").append(file.getAbsoluteFile()).append(" minCleanedFileOffset: ").append(minCleanedFileOffset$1.elem).toString());
        return Files.deleteIfExists(file.toPath());
    }

    public static final /* synthetic */ boolean $anonfun$removeTempFilesAndCollectSwapFiles$7(LogLoader $this, File file) {
        $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Deleting stray .clean file ").append(file.getAbsolutePath()).toString());
        return Files.deleteIfExists(file.toPath());
    }

    private final Option deleteSegmentsIfLogStartGreaterThanLogEnd$1() {
        if (this.segments.nonEmpty()) {
            long logEndOffset = ((LogSegment)this.segments.lastSegment().get()).readNextOffset();
            if (logEndOffset >= this.logStartOffsetCheckpoint) {
                return new Some((Object)BoxesRunTime.boxToLong((long)logEndOffset));
            }
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(148).append("Deleting all segments because logEndOffset (").append(logEndOffset).append(") ").append("is smaller than logStartOffset ").append($this.logStartOffsetCheckpoint).append(". ").append("This could happen if segment files were deleted from the file system.").toString());
            this.removeAndDeleteSegmentsAsync(this.segments.values());
            this.leaderEpochCache.foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                x$7.clearAndFlush();
                return BoxedUnit.UNIT;
            });
            this.producerStateManager.truncateFullyAndStartAt(this.logStartOffsetCheckpoint);
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    public LogLoader(File dir, TopicPartition topicPartition, LogConfig config, Scheduler scheduler, Time time, LogDirFailureChannel logDirFailureChannel, boolean hadCleanShutdown, LogSegments segments, long logStartOffsetCheckpoint, long recoveryPointCheckpoint, Option<LeaderEpochFileCache> leaderEpochCache, ProducerStateManager producerStateManager, ConcurrentMap<String, Object> numRemainingSegments, boolean isRemoteLogEnabled) {
        this.dir = dir;
        this.topicPartition = topicPartition;
        this.config = config;
        this.scheduler = scheduler;
        this.time = time;
        this.logDirFailureChannel = logDirFailureChannel;
        this.hadCleanShutdown = hadCleanShutdown;
        this.segments = segments;
        this.logStartOffsetCheckpoint = logStartOffsetCheckpoint;
        this.recoveryPointCheckpoint = recoveryPointCheckpoint;
        this.leaderEpochCache = leaderEpochCache;
        this.producerStateManager = producerStateManager;
        this.numRemainingSegments = numRemainingSegments;
        this.isRemoteLogEnabled = isRemoteLogEnabled;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(29).append("[LogLoader partition=").append(topicPartition).append(", dir=").append(dir.getParent()).append("] ").toString());
    }
}

