/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.network.RequestChannel;
import kafka.network.RequestChannel$ShutdownRequest$;
import kafka.network.RequestChannel$WakeupRequest$;
import kafka.server.ApiRequestHandler;
import kafka.server.KafkaRequestHandler$;
import kafka.server.RequestLocal;
import kafka.server.RequestLocal$;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\rw!B\u0013'\u0011\u0003Yc!B\u0017'\u0011\u0003q\u0003\"B\u001b\u0002\t\u00031\u0004bB\u001c\u0002\u0005\u0004%I\u0001\u000f\u0005\u0007\u000f\u0006\u0001\u000b\u0011B\u001d\t\u000f!\u000b!\u0019!C\u0005\u0013\"1!+\u0001Q\u0001\n)CqaU\u0001A\u0002\u0013%A\u000bC\u0004Y\u0003\u0001\u0007I\u0011B-\t\r}\u000b\u0001\u0015)\u0003V\u0011\u0015!\u0017\u0001\"\u0001f\u0011\u0015A\u0017\u0001\"\u0001j\u0011\u0015Q\u0017\u0001\"\u0001l\r\u0011ic\u0005A?\t\u0015\u0005UQB!A!\u0002\u0013\t9\u0002\u0003\u0006\u0002\u001e5\u0011\t\u0011)A\u0005\u0003/A!\"a\b\u000e\u0005\u000b\u0007I\u0011AA\u0011\u0011)\tY$\u0004B\u0001B\u0003%\u00111\u0005\u0005\u000b\u0003{i!Q1A\u0005\u0002\u0005}\u0002BCA+\u001b\t\u0005\t\u0015!\u0003\u0002B!Q\u0011qK\u0007\u0003\u0006\u0004%\t!!\u0017\t\u0013\u0005mSB!A!\u0002\u0013\t\u0005BCA/\u001b\t\u0005\t\u0015!\u0003\u0002`!Q\u0011QM\u0007\u0003\u0002\u0003\u0006I!a\u001a\t\rUjA\u0011AA@\u0011%\t\t*\u0004b\u0001\n\u0013\t\u0019\n\u0003\u0005\u0002\u001e6\u0001\u000b\u0011BAK\u0011%\ty*\u0004b\u0001\n\u0013\t\t\u000b\u0003\u0005\u0002*6\u0001\u000b\u0011BAR\u0011!\tY+\u0004a\u0001\n\u0013!\u0006\"CAW\u001b\u0001\u0007I\u0011BAX\u0011\u001d\t\u0019,\u0004Q!\nUCq!a.\u000e\t\u0003\tI\fC\u0004\u0002<6!I!!/\t\u000f\u0005uV\u0002\"\u0001\u0002:\"9\u0011qX\u0007\u0005\u0002\u0005e\u0006bBAa\u001b\u0011\u0005\u0011\u0011X\u0001\u0014\u0017\u000647.\u0019*fcV,7\u000f\u001e%b]\u0012dWM\u001d\u0006\u0003O!\naa]3sm\u0016\u0014(\"A\u0015\u0002\u000b-\fgm[1\u0004\u0001A\u0011A&A\u0007\u0002M\t\u00192*\u00194lCJ+\u0017/^3ti\"\u000bg\u000e\u001a7feN\u0011\u0011a\f\t\u0003aMj\u0011!\r\u0006\u0002e\u0005)1oY1mC&\u0011A'\r\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005Y\u0013\u0001\u0006;ie\u0016\fGMU3rk\u0016\u001cHo\u00115b]:,G.F\u0001:!\rQt(Q\u0007\u0002w)\u0011A(P\u0001\u0005Y\u0006twMC\u0001?\u0003\u0011Q\u0017M^1\n\u0005\u0001[$a\u0003+ie\u0016\fG\rT8dC2\u0004\"AQ#\u000e\u0003\rS!\u0001\u0012\u0015\u0002\u000f9,Go^8sW&\u0011ai\u0011\u0002\u000f%\u0016\fX/Z:u\u0007\"\fgN\\3m\u0003U!\bN]3bIJ+\u0017/^3ti\u000eC\u0017M\u001c8fY\u0002\nA\u0003\u001e5sK\u0006$7)\u001e:sK:$(+Z9vKN$X#\u0001&\u0011\u0007iz4\n\u0005\u0002M\u001f:\u0011!)T\u0005\u0003\u001d\u000e\u000baBU3rk\u0016\u001cHo\u00115b]:,G.\u0003\u0002Q#\n9!+Z9vKN$(B\u0001(D\u0003U!\bN]3bI\u000e+(O]3oiJ+\u0017/^3ti\u0002\n\u0011CY=qCN\u001cH\u000b\u001b:fC\u0012\u001c\u0005.Z2l+\u0005)\u0006C\u0001\u0019W\u0013\t9\u0016GA\u0004C_>dW-\u00198\u0002+\tL\b/Y:t)\"\u0014X-\u00193DQ\u0016\u001c7n\u0018\u0013fcR\u0011!,\u0018\t\u0003amK!\u0001X\u0019\u0003\tUs\u0017\u000e\u001e\u0005\b=\"\t\t\u00111\u0001V\u0003\rAH%M\u0001\u0013Ef\u0004\u0018m]:UQJ,\u0017\rZ\"iK\u000e\\\u0007\u0005\u000b\u0002\nCB\u0011\u0001GY\u0005\u0003GF\u0012\u0001B^8mCRLG.Z\u0001\u0015g\u0016$()\u001f9bgN$\u0006N]3bI\u000eCWmY6\u0015\u0005i3\u0007\"B4\u000b\u0001\u0004)\u0016a\u00032za\u0006\u001c8o\u00115fG.\facY;se\u0016tGOU3rk\u0016\u001cHo\u00148UQJ,\u0017\r\u001a\u000b\u0002\u0017\u0006!qO]1q+\ta'\u000f\u0006\u0002nwB!\u0001G\u001c9[\u0013\ty\u0017GA\u0005Gk:\u001cG/[8ocA\u0011\u0011O\u001d\u0007\u0001\t\u0015\u0019HB1\u0001u\u0005\u0005!\u0016CA;y!\t\u0001d/\u0003\u0002xc\t9aj\u001c;iS:<\u0007C\u0001\u0019z\u0013\tQ\u0018GA\u0002B]fDQ\u0001 \u0007A\u00025\f1AZ;o'\u0019ia0a\u0001\u0002\nA\u0011!h`\u0005\u0004\u0003\u0003Y$AB(cU\u0016\u001cG\u000fE\u0002;\u0003\u000bI1!a\u0002<\u0005!\u0011VO\u001c8bE2,\u0007\u0003BA\u0006\u0003#i!!!\u0004\u000b\u0007\u0005=\u0001&A\u0003vi&d7/\u0003\u0003\u0002\u0014\u00055!a\u0002'pO\u001eLgnZ\u0001\u0003S\u0012\u00042\u0001MA\r\u0013\r\tY\"\r\u0002\u0004\u0013:$\u0018\u0001\u00032s_.,'/\u00133\u0002%\u0005<wM]3hCR,\u0017\n\u001a7f\u001b\u0016$XM]\u000b\u0003\u0003G\u0001B!!\n\u000285\u0011\u0011q\u0005\u0006\u0005\u0003S\tY#\u0001\u0003d_J,'\u0002BA\u0017\u0003_\tq!\\3ue&\u001c7O\u0003\u0003\u00022\u0005M\u0012AB=b[6,'O\u0003\u0002\u00026\u0005\u00191m\\7\n\t\u0005e\u0012q\u0005\u0002\u0006\u001b\u0016$XM]\u0001\u0014C\u001e<'/Z4bi\u0016LE\r\\3NKR,'\u000fI\u0001\u0014i>$\u0018\r\u001c%b]\u0012dWM\u001d+ie\u0016\fGm]\u000b\u0003\u0003\u0003\u0002B!a\u0011\u0002R5\u0011\u0011Q\t\u0006\u0005\u0003\u000f\nI%\u0001\u0004bi>l\u0017n\u0019\u0006\u0005\u0003\u0017\ni%\u0001\u0006d_:\u001cWO\u001d:f]RT1!a\u0014>\u0003\u0011)H/\u001b7\n\t\u0005M\u0013Q\t\u0002\u000e\u0003R|W.[2J]R,w-\u001a:\u0002)Q|G/\u00197IC:$G.\u001a:UQJ,\u0017\rZ:!\u00039\u0011X-];fgR\u001c\u0005.\u00198oK2,\u0012!Q\u0001\u0010e\u0016\fX/Z:u\u0007\"\fgN\\3mA\u0005!\u0011\r]5t!\ra\u0013\u0011M\u0005\u0004\u0003G2#!E!qSJ+\u0017/^3ti\"\u000bg\u000e\u001a7fe\u0006!A/[7f!\u0011\tI'a\u001f\u000e\u0005\u0005-$\u0002BA\b\u0003[RA!a\u001c\u0002r\u000511m\\7n_:T1!KA:\u0015\u0011\t)(a\u001e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\tI(A\u0002pe\u001eLA!! \u0002l\t!A+[7f)A\t\t)a!\u0002\u0006\u0006\u001d\u0015\u0011RAF\u0003\u001b\u000by\t\u0005\u0002-\u001b!9\u0011Q\u0003\rA\u0002\u0005]\u0001bBA\u000f1\u0001\u0007\u0011q\u0003\u0005\b\u0003?A\u0002\u0019AA\u0012\u0011\u001d\ti\u0004\u0007a\u0001\u0003\u0003Ba!a\u0016\u0019\u0001\u0004\t\u0005bBA/1\u0001\u0007\u0011q\f\u0005\b\u0003KB\u0002\u0019AA4\u0003A\u0019\b.\u001e;e_^t7i\\7qY\u0016$X-\u0006\u0002\u0002\u0016B!\u0011qSAM\u001b\t\tI%\u0003\u0003\u0002\u001c\u0006%#AD\"pk:$Hi\\<o\u0019\u0006$8\r[\u0001\u0012g\",H\u000fZ8x]\u000e{W\u000e\u001d7fi\u0016\u0004\u0013\u0001\u0004:fcV,7\u000f\u001e'pG\u0006dWCAAR!\ra\u0013QU\u0005\u0004\u0003O3#\u0001\u0004*fcV,7\u000f\u001e'pG\u0006d\u0017!\u0004:fcV,7\u000f\u001e'pG\u0006d\u0007%A\u0004ti>\u0004\b/\u001a3\u0002\u0017M$x\u000e\u001d9fI~#S-\u001d\u000b\u00045\u0006E\u0006b\u00020\u001f\u0003\u0003\u0005\r!V\u0001\tgR|\u0007\u000f]3eA!\u0012q$Y\u0001\u0004eVtG#\u0001.\u0002!\r|W\u000e\u001d7fi\u0016\u001c\u0006.\u001e;e_^t\u0017\u0001B:u_B\f\u0001#\u001b8ji&\fG/Z*ikR$wn\u001e8\u0002\u001b\u0005<\u0018-\u001b;TQV$Hm\\<o\u0001")
public class KafkaRequestHandler
implements Runnable,
Logging {
    private final int id;
    private final int brokerId;
    private final Meter aggregateIdleMeter;
    private final AtomicInteger totalHandlerThreads;
    private final RequestChannel requestChannel;
    private final ApiRequestHandler apis;
    private final Time time;
    private final CountDownLatch shutdownComplete;
    private final RequestLocal requestLocal;
    private volatile boolean stopped;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static <T> Function1<T, BoxedUnit> wrap(Function1<T, BoxedUnit> function1) {
        return KafkaRequestHandler$.MODULE$.wrap(function1);
    }

    public static RequestChannel.Request currentRequestOnThread() {
        return KafkaRequestHandler$.MODULE$.currentRequestOnThread();
    }

    public static void setBypassThreadCheck(boolean bl) {
        KafkaRequestHandler$.MODULE$.setBypassThreadCheck(bl);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Meter aggregateIdleMeter() {
        return this.aggregateIdleMeter;
    }

    public AtomicInteger totalHandlerThreads() {
        return this.totalHandlerThreads;
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    private CountDownLatch shutdownComplete() {
        return this.shutdownComplete;
    }

    private RequestLocal requestLocal() {
        return this.requestLocal;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    @Override
    public void run() {
        KafkaRequestHandler$.MODULE$.kafka$server$KafkaRequestHandler$$threadRequestChannel().set(this.requestChannel());
        while (!this.stopped()) {
            long startSelectTime = this.time.nanoseconds();
            RequestChannel.BaseRequest req = this.requestChannel().receiveRequest(300L);
            long endTime = this.time.nanoseconds();
            long idleTime = endTime - startSelectTime;
            this.aggregateIdleMeter().mark(idleTime / (long)this.totalHandlerThreads().get());
            if (RequestChannel$ShutdownRequest$.MODULE$.equals(req)) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Kafka request handler ").append($this.id).append(" on broker ").append($this.brokerId).append(" received shut down command").toString());
                this.completeShutdown();
                return;
            }
            if (req instanceof RequestChannel.CallbackRequest) {
                RequestChannel.CallbackRequest callbackRequest = (RequestChannel.CallbackRequest)req;
                RequestChannel.Request originalRequest = callbackRequest.originalRequest();
                try {
                    try {
                        if (originalRequest.callbackRequestDequeueTimeNanos().isDefined()) {
                            long prevCallbacksTimeNanos = BoxesRunTime.unboxToLong((Object)originalRequest.callbackRequestCompleteTimeNanos().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)) - BoxesRunTime.unboxToLong((Object)originalRequest.callbackRequestDequeueTimeNanos().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
                            originalRequest.callbackRequestCompleteTimeNanos_$eq((Option<Object>)None$.MODULE$);
                            originalRequest.callbackRequestDequeueTimeNanos_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)(this.time.nanoseconds() - prevCallbacksTimeNanos))));
                        } else {
                            originalRequest.callbackRequestDequeueTimeNanos_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.time.nanoseconds())));
                        }
                        KafkaRequestHandler$.MODULE$.kafka$server$KafkaRequestHandler$$threadCurrentRequest().set(originalRequest);
                        callbackRequest.fun().apply$mcV$sp();
                        continue;
                    }
                    catch (FatalExitError e) {
                        this.completeShutdown();
                        throw Exit$.MODULE$.exit(e.statusCode(), Exit$.MODULE$.exit$default$2());
                    }
                    catch (Throwable e) {
                        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception when handling request", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                        continue;
                    }
                }
                finally {
                    this.apis.tryCompleteActions();
                    if (originalRequest.callbackRequestCompleteTimeNanos().isEmpty()) {
                        originalRequest.callbackRequestCompleteTimeNanos_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.time.nanoseconds())));
                    }
                    KafkaRequestHandler$.MODULE$.kafka$server$KafkaRequestHandler$$threadCurrentRequest().remove();
                    continue;
                }
            }
            if (req instanceof RequestChannel.Request) {
                RequestChannel.Request request = (RequestChannel.Request)req;
                try {
                    try {
                        request.requestDequeueTimeNanos_$eq(endTime);
                        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Kafka request handler ").append($this.id).append(" on broker ").append($this.brokerId).append(" handling request ").append(request).toString());
                        KafkaRequestHandler$.MODULE$.kafka$server$KafkaRequestHandler$$threadCurrentRequest().set(request);
                        this.apis.handle(request, this.requestLocal());
                        continue;
                    }
                    catch (FatalExitError e) {
                        this.completeShutdown();
                        throw Exit$.MODULE$.exit(e.statusCode(), Exit$.MODULE$.exit$default$2());
                    }
                    catch (Throwable e) {
                        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception when handling request", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                        continue;
                    }
                }
                finally {
                    KafkaRequestHandler$.MODULE$.kafka$server$KafkaRequestHandler$$threadCurrentRequest().remove();
                    request.releaseBuffer();
                    continue;
                }
            }
            if (RequestChannel$WakeupRequest$.MODULE$.equals(req)) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Received a wakeup request outside of typical usage.");
                continue;
            }
            if (req == null) continue;
            throw new MatchError((Object)req);
        }
        this.completeShutdown();
    }

    private void completeShutdown() {
        this.requestLocal().close();
        this.shutdownComplete().countDown();
    }

    public void stop() {
        this.stopped_$eq(true);
    }

    public void initiateShutdown() {
        this.requestChannel().sendShutdownRequest();
    }

    public void awaitShutdown() {
        this.shutdownComplete().await();
    }

    public KafkaRequestHandler(int id, int brokerId, Meter aggregateIdleMeter, AtomicInteger totalHandlerThreads, RequestChannel requestChannel, ApiRequestHandler apis, Time time) {
        this.id = id;
        this.brokerId = brokerId;
        this.aggregateIdleMeter = aggregateIdleMeter;
        this.totalHandlerThreads = totalHandlerThreads;
        this.requestChannel = requestChannel;
        this.apis = apis;
        this.time = time;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(37).append("[Kafka Request Handler ").append(id).append(" on Broker ").append(brokerId).append("], ").toString());
        this.shutdownComplete = new CountDownLatch(1);
        this.requestLocal = RequestLocal$.MODULE$.withThreadConfinedCaching();
        this.stopped = false;
    }
}

