/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Optional;
import kafka.log.UnifiedLog;
import kafka.raft.KafkaMetadataLog$;
import kafka.raft.MetadataLogConfig;
import kafka.raft.SegmentPosition;
import kafka.server.RequestLocal;
import kafka.server.RequestLocal$;
import kafka.utils.Logging;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.Isolation;
import org.apache.kafka.raft.LogFetchInfo;
import org.apache.kafka.raft.LogOffsetMetadata;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.raft.OffsetMetadata;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.raft.ValidOffsetAndEpoch;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.snapshot.FileRawSnapshotReader;
import org.apache.kafka.snapshot.FileRawSnapshotWriter;
import org.apache.kafka.snapshot.RawSnapshotReader;
import org.apache.kafka.snapshot.RawSnapshotWriter;
import org.apache.kafka.snapshot.Snapshots;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.FetchIsolation;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.MapLike;
import scala.collection.mutable.TreeMap;
import scala.collection.mutable.TreeMap$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.math.Numeric;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\rg\u0001B\u00193\u0005]B\u0001\u0002\u0015\u0001\u0003\u0006\u0004%\t!\u0015\u0005\t/\u0002\u0011\t\u0011)A\u0005%\"A\u0001\f\u0001B\u0001B\u0003%\u0011\f\u0003\u0005a\u0001\t\u0005\t\u0015!\u0003b\u0011!I\u0007A!A!\u0002\u0013Q\u0007BCA\u0002\u0001\t\u0005\t\u0015!\u0003\u0002\u0006!Q\u0011Q\u0002\u0001\u0003\u0002\u0003\u0006I!a\u0004\t\u000f\u0005]\u0001\u0001\"\u0003\u0002\u001a!9\u0011\u0011\u0006\u0001\u0005B\u0005-\u0002bBA$\u0001\u0011\u0005\u0013\u0011\n\u0005\b\u0003W\u0002A\u0011IA7\u0011\u001d\t\t\b\u0001C\u0005\u0003gBq!!#\u0001\t\u0003\nY\tC\u0004\u0002\u000e\u0002!\t%a$\t\u000f\u0005M\u0005\u0001\"\u0011\u0002\u0016\"9\u0011Q\u0007\u0001\u0005B\u0005u\u0005bBAP\u0001\u0011\u0005\u0013\u0011\u0015\u0005\b\u0003[\u0003A\u0011IAX\u0011\u001d\t9\f\u0001C!\u0003sCq!!0\u0001\t\u0003\ny\fC\u0004\u0002F\u0002!\t%!&\t\u000f\u0005\u001d\u0007\u0001\"\u0011\u0002J\"9\u00111\u0001\u0001\u0005B\u0005=\u0007bBAi\u0001\u0011\u0005\u00131\u001b\u0005\b\u00037\u0004A\u0011IAo\u0011\u001d\t\u0019\u0010\u0001C!\u0003kDq!!?\u0001\t\u0003\nY\u0010C\u0004\u0003\b\u0001!\tE!\u0003\t\u000f\t-\u0001\u0001\"\u0011\u0003\u000e!9!\u0011\u0003\u0001\u0005B\t5\u0001b\u0002B\n\u0001\u0011\u0005#Q\u0003\u0005\b\u00053\u0001A\u0011\tB\u000e\u0011\u001d\u0011y\u0002\u0001C\u0005\u0005CAqA!\u0011\u0001\t\u0013\u0011\u0019\u0005C\u0004\u0003J\u0001!\t%a,\t\u000f\t-\u0003\u0001\"\u0003\u0003N!9!\u0011\f\u0001\u0005\n\u0005=\u0006b\u0002B.\u0001\u0011%\u0011q\u0016\u0005\b\u0005;\u0002A\u0011\u0002B0\u0011\u001d\u0011)\u0007\u0001C\u0005\u0005OBqA!\u001c\u0001\t\u0003\u0012y\u0007\u0003\u0005\u0003r\u0001!\tAMAF\u000f\u001d\u0011\u0019H\rE\u0001\u0005k2a!\r\u001a\t\u0002\t]\u0004bBA\fY\u0011\u0005!q\u0010\u0005\b\u0005\u0003cC\u0011\u0001BB\u0011\u001d\u0011y\n\fC\u0005\u0005CCqA!*-\t\u0013\u00119K\u0001\tLC\u001a\\\u0017-T3uC\u0012\fG/\u0019'pO*\u00111\u0007N\u0001\u0005e\u00064GOC\u00016\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001\u0001\u001dA\u0015B\u0011\u0011HP\u0007\u0002u)\u00111\bP\u0001\u0005Y\u0006twMC\u0001>\u0003\u0011Q\u0017M^1\n\u0005}R$AB(cU\u0016\u001cG\u000f\u0005\u0002B\u00116\t!I\u0003\u00024\u0007*\u0011Q\u0007\u0012\u0006\u0003\u000b\u001a\u000ba!\u00199bG\",'\"A$\u0002\u0007=\u0014x-\u0003\u0002J\u0005\ni!+\u001a9mS\u000e\fG/\u001a3M_\u001e\u0004\"a\u0013(\u000e\u00031S!!\u0014\u001b\u0002\u000bU$\u0018\u000e\\:\n\u0005=c%a\u0002'pO\u001eLgnZ\u0001\u0004Y><W#\u0001*\u0011\u0005M+V\"\u0001+\u000b\u0005A#\u0014B\u0001,U\u0005))f.\u001b4jK\u0012dunZ\u0001\u0005Y><\u0007%\u0001\u0003uS6,\u0007C\u0001._\u001b\u0005Y&BA']\u0015\ti6)\u0001\u0004d_6lwN\\\u0005\u0003?n\u0013A\u0001V5nK\u0006I1o\u00195fIVdWM\u001d\t\u0003E\u001el\u0011a\u0019\u0006\u0003I\u0016\fA!\u001e;jY*\u0011amQ\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005!\u001c'!C*dQ\u0016$W\u000f\\3s\u0003%\u0019h.\u00199tQ>$8\u000f\u0005\u0003leR<X\"\u00017\u000b\u00055t\u0017aB7vi\u0006\u0014G.\u001a\u0006\u0003_B\f!bY8mY\u0016\u001cG/[8o\u0015\u0005\t\u0018!B:dC2\f\u0017BA:m\u0005\u001d!&/Z3NCB\u0004\"!Q;\n\u0005Y\u0014%AD(gMN,G/\u00118e\u000bB|7\r\u001b\t\u0004qf\\X\"\u00019\n\u0005i\u0004(AB(qi&|g\u000e\u0005\u0002}\u007f6\tQP\u0003\u0002\u007f\u0007\u0006A1O\\1qg\"|G/C\u0002\u0002\u0002u\u0014QCR5mKJ\u000bwo\u00158baNDw\u000e\u001e*fC\u0012,'/\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0011\t\u0005\u001d\u0011\u0011B\u0007\u00029&\u0019\u00111\u0002/\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u000611m\u001c8gS\u001e\u0004B!!\u0005\u0002\u00145\t!'C\u0002\u0002\u0016I\u0012\u0011#T3uC\u0012\fG/\u0019'pO\u000e{gNZ5h\u0003\u0019a\u0014N\\5u}Qq\u00111DA\u000f\u0003?\t\t#a\t\u0002&\u0005\u001d\u0002cAA\t\u0001!)\u0001\u000b\u0003a\u0001%\")\u0001\f\u0003a\u00013\")\u0001\r\u0003a\u0001C\")\u0011\u000e\u0003a\u0001U\"9\u00111\u0001\u0005A\u0002\u0005\u0015\u0001bBA\u0007\u0011\u0001\u0007\u0011qB\u0001\u0005e\u0016\fG\r\u0006\u0004\u0002.\u0005M\u0012Q\b\t\u0004\u0003\u0006=\u0012bAA\u0019\u0005\naAj\\4GKR\u001c\u0007.\u00138g_\"9\u0011QG\u0005A\u0002\u0005]\u0012aC:uCJ$xJ\u001a4tKR\u00042\u0001_A\u001d\u0013\r\tY\u0004\u001d\u0002\u0005\u0019>tw\rC\u0004\u0002@%\u0001\r!!\u0011\u0002\u001bI,\u0017\rZ%t_2\fG/[8o!\r\t\u00151I\u0005\u0004\u0003\u000b\u0012%!C%t_2\fG/[8o\u00039\t\u0007\u000f]3oI\u0006\u001bH*Z1eKJ$b!a\u0013\u0002R\u0005\u0005\u0004cA!\u0002N%\u0019\u0011q\n\"\u0003\u001b1{w-\u00119qK:$\u0017J\u001c4p\u0011\u001d\t\u0019F\u0003a\u0001\u0003+\nqA]3d_J$7\u000f\u0005\u0003\u0002X\u0005uSBAA-\u0015\r\tY\u0006X\u0001\u0007e\u0016\u001cwN\u001d3\n\t\u0005}\u0013\u0011\f\u0002\b%\u0016\u001cwN\u001d3t\u0011\u001d\t\u0019G\u0003a\u0001\u0003K\nQ!\u001a9pG\"\u00042\u0001_A4\u0013\r\tI\u0007\u001d\u0002\u0004\u0013:$\u0018\u0001E1qa\u0016tG-Q:G_2dwn^3s)\u0011\tY%a\u001c\t\u000f\u0005M3\u00021\u0001\u0002V\u0005i\u0002.\u00198eY\u0016\fe\u000eZ\"p]Z,'\u000f\u001e'pO\u0006\u0003\b/\u001a8e\u0013:4w\u000e\u0006\u0003\u0002L\u0005U\u0004bBA<\u0019\u0001\u0007\u0011\u0011P\u0001\u000bCB\u0004XM\u001c3J]\u001a|\u0007\u0003BA>\u0003\u000fk!!! \u000b\u0007A\u000byH\u0003\u0003\u0002\u0002\u0006\r\u0015!C5oi\u0016\u0014h.\u00197t\u0015\r\t)iQ\u0001\bgR|'/Y4f\u0013\u0011\ty%! \u0002!1\f7\u000f\u001e$fi\u000eDW\rZ#q_\u000eDGCAA3\u0003E)g\u000eZ(gMN,GOR8s\u000bB|7\r\u001b\u000b\u0004i\u0006E\u0005bBA2\u001d\u0001\u0007\u0011QM\u0001\nK:$wJ\u001a4tKR$\"!a&\u0011\u0007\u0005\u000bI*C\u0002\u0002\u001c\n\u0013\u0011\u0003T8h\u001f\u001a47/\u001a;NKR\fG-\u0019;b)\t\t9$\u0001\u0006ueVt7-\u0019;f)>$B!a)\u0002*B\u0019\u00010!*\n\u0007\u0005\u001d\u0006O\u0001\u0003V]&$\bbBAV#\u0001\u0007\u0011qG\u0001\u0007_\u001a47/\u001a;\u00021Q\u0014XO\\2bi\u0016$v\u000eT1uKN$8K\\1qg\"|G\u000f\u0006\u0002\u00022B\u0019\u00010a-\n\u0007\u0005U\u0006OA\u0004C_>dW-\u00198\u0002+%t\u0017\u000e^5bY&TX\rT3bI\u0016\u0014X\t]8dQR!\u00111UA^\u0011\u001d\t\u0019g\u0005a\u0001\u0003K\n1#\u001e9eCR,\u0007*[4i/\u0006$XM]7be.$B!a)\u0002B\"9\u00111\u0019\u000bA\u0002\u0005]\u0015AD8gMN,G/T3uC\u0012\fG/Y\u0001\u000eQ&<\u0007nV1uKJl\u0017M]6\u0002\u000b\u0019dWo\u001d5\u0015\t\u0005\r\u00161\u001a\u0005\b\u0003\u001b4\u0002\u0019AAY\u0003]1wN]2f\r2,8\u000f[!di&4XmU3h[\u0016tG\u000f\u0006\u0002\u0002\u0006\u00059Ao\u001c9jG&#GCAAk!\u0011\t9!a6\n\u0007\u0005eGL\u0001\u0003Vk&$\u0017!E2sK\u0006$XMT3x':\f\u0007o\u001d5piR!\u0011q\\Ax!\u0019\t\t/!:\u0002j6\u0011\u00111\u001d\u0006\u0003IrJA!a:\u0002d\nAq\n\u001d;j_:\fG\u000eE\u0002}\u0003WL1!!<~\u0005E\u0011\u0016m^*oCB\u001c\bn\u001c;Xe&$XM\u001d\u0005\u0007\u0003cL\u0002\u0019\u0001;\u0002\u0015Mt\u0017\r]:i_RLE-A\u0007ti>\u0014Xm\u00158baNDw\u000e\u001e\u000b\u0005\u0003?\f9\u0010\u0003\u0004\u0002rj\u0001\r\u0001^\u0001\re\u0016\fGm\u00158baNDw\u000e\u001e\u000b\u0005\u0003{\u0014)\u0001\u0005\u0004\u0002b\u0006\u0015\u0018q \t\u0004y\n\u0005\u0011b\u0001B\u0002{\n\t\"+Y<T]\u0006\u00048\u000f[8u%\u0016\fG-\u001a:\t\r\u0005E8\u00041\u0001u\u00039a\u0017\r^3tiNs\u0017\r]:i_R$\"!!@\u0002!1\fG/Z:u':\f\u0007o\u001d5pi&#GC\u0001B\b!\u0015\t\t/!:u\u0003I)\u0017M\u001d7jKN$8K\\1qg\"|G/\u00133\u0002!=t7K\\1qg\"|GO\u0012:pu\u0016tG\u0003BAR\u0005/Aa!!= \u0001\u0004!\u0018\u0001\u00063fY\u0016$XMQ3g_J,7K\\1qg\"|G\u000f\u0006\u0003\u00022\nu\u0001BBAyA\u0001\u0007A/A\tm_\u0006$7K\\1qg\"|GoU5{KN$\"Aa\t\u0011\r\t\u0015\"Q\u0007B\u001e\u001d\u0011\u00119C!\r\u000f\t\t%\"qF\u0007\u0003\u0005WQ1A!\f7\u0003\u0019a$o\\8u}%\t\u0011/C\u0002\u00034A\fq\u0001]1dW\u0006<W-\u0003\u0003\u00038\te\"aA*fc*\u0019!1\u00079\u0011\ra\u0014i\u0004^A\u001c\u0013\r\u0011y\u0004\u001d\u0002\u0007)V\u0004H.\u001a\u001a\u0002+I,\u0017\rZ*oCB\u001c\bn\u001c;US6,7\u000f^1naR!!Q\tB$!\u0011A\u00180a\u000e\t\r\u0005E(\u00051\u0001u\u0003)i\u0017-\u001f2f\u00072,\u0017M\\\u0001\u000fG2,\u0017M\\*oCB\u001c\bn\u001c;t)\u0011\t\tLa\u0014\t\u000f\tEC\u00051\u0001\u0003T\u0005I\u0001O]3eS\u000e\fG/\u001a\t\u0007q\nUC/!-\n\u0007\t]\u0003OA\u0005Gk:\u001cG/[8oc\u0005I2\r\\3b]Ns\u0017\r]:i_R\u001c(+\u001a;f]RLwN\\'t\u0003m\u0019G.Z1o':\f\u0007o\u001d5piN\u0014V\r^3oi&|gnU5{K\u0006)bm\u001c:hKR\u001cf.\u00199tQ>$8OQ3g_J,Gc\u00016\u0003b!1!1M\u0014A\u0002Q\f!\u0003\\8h'R\f'\u000f^*oCB\u001c\bn\u001c;JI\u0006y!/Z7pm\u0016\u001cf.\u00199tQ>$8\u000f\u0006\u0003\u0002$\n%\u0004B\u0002B6Q\u0001\u0007!.\u0001\tfqBL'/\u001a3T]\u0006\u00048\u000f[8ug\u0006)1\r\\8tKR\u0011\u00111U\u0001\u000eg:\f\u0007o\u001d5pi\u000e{WO\u001c;\u0002!-\u000bgm[1NKR\fG-\u0019;b\u0019><\u0007cAA\tYM!AF!\u001fK!\rA(1P\u0005\u0004\u0005{\u0002(AB!osJ+g\r\u0006\u0002\u0003v\u0005)\u0011\r\u001d9msRq\u00111\u0004BC\u0005\u000f\u0013II!'\u0003\u001c\nu\u0005bBA\u0002]\u0001\u0007\u0011Q\u0001\u0005\b\u0003#t\u0003\u0019AAk\u0011\u001d\u0011YI\fa\u0001\u0005\u001b\u000bq\u0001Z1uC\u0012K'\u000f\u0005\u0003\u0003\u0010\nUUB\u0001BI\u0015\r\u0011\u0019\nP\u0001\u0003S>LAAa&\u0003\u0012\n!a)\u001b7f\u0011\u0015Af\u00061\u0001Z\u0011\u0015\u0001g\u00061\u0001b\u0011\u001d\tiA\fa\u0001\u0003\u001f\t\u0001C]3d_Z,'o\u00158baNDw\u000e^:\u0015\u0007)\u0014\u0019\u000bC\u0003Q_\u0001\u0007!+A\neK2,G/Z*oCB\u001c\bn\u001c;GS2,7\u000f\u0006\u0005\u0002$\n%&Q\u0018B`\u0011\u001d\u0011Y\u000b\ra\u0001\u0005[\u000ba\u0001\\8h\t&\u0014\b\u0003\u0002BX\u0005sk!A!-\u000b\t\tM&QW\u0001\u0005M&dWMC\u0002\u00038r\n1A\\5p\u0013\u0011\u0011YL!-\u0003\tA\u000bG\u000f\u001b\u0005\u0007\u0005W\u0002\u0004\u0019\u00016\t\r\t\u0005\u0007\u00071\u0001K\u0003\u001dawnZ4j]\u001e\u0004")
public final class KafkaMetadataLog
implements ReplicatedLog,
Logging {
    private final UnifiedLog log;
    private final Time time;
    private final Scheduler scheduler;
    private final TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> snapshots;
    private final TopicPartition topicPartition;
    private final MetadataLogConfig config;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static KafkaMetadataLog apply(TopicPartition topicPartition, Uuid uuid, File file, Time time, Scheduler scheduler, MetadataLogConfig metadataLogConfig) {
        return KafkaMetadataLog$.MODULE$.apply(topicPartition, uuid, file, time, scheduler, metadataLogConfig);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public ValidOffsetAndEpoch validateOffsetAndEpoch(long x$1, int x$2) {
        return super.validateOffsetAndEpoch(x$1, x$2);
    }

    public long truncateToEndOffset(OffsetAndEpoch x$1) {
        return super.truncateToEndOffset(x$1);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public UnifiedLog log() {
        return this.log;
    }

    public LogFetchInfo read(long startOffset, Isolation readIsolation) {
        FetchIsolation fetchIsolation;
        if (Isolation.COMMITTED.equals(readIsolation)) {
            fetchIsolation = FetchIsolation.HIGH_WATERMARK;
        } else if (Isolation.UNCOMMITTED.equals(readIsolation)) {
            fetchIsolation = FetchIsolation.LOG_END;
        } else {
            throw new IllegalArgumentException(new StringBuilder(25).append("Unhandled read isolation ").append(readIsolation).toString());
        }
        FetchIsolation isolation = fetchIsolation;
        FetchDataInfo fetchInfo = this.log().read(startOffset, this.config.maxFetchSizeInBytes(), isolation, true);
        return new LogFetchInfo(fetchInfo.records, new LogOffsetMetadata(fetchInfo.fetchOffsetMetadata.messageOffset, Optional.of(new SegmentPosition(fetchInfo.fetchOffsetMetadata.segmentBaseOffset, fetchInfo.fetchOffsetMetadata.relativePositionInSegment))));
    }

    public org.apache.kafka.raft.LogAppendInfo appendAsLeader(Records records, int epoch) {
        if (records.sizeInBytes() == 0) {
            throw new IllegalArgumentException("Attempt to append an empty record set");
        }
        MemoryRecords x$1 = (MemoryRecords)records;
        AppendOrigin x$3 = AppendOrigin.RAFT_LEADER;
        RequestLocal x$4 = RequestLocal$.MODULE$.NoCaching();
        MetadataVersion x$5 = this.log().appendAsLeader$default$4();
        Object x$6 = this.log().appendAsLeader$default$6();
        return this.handleAndConvertLogAppendInfo(this.log().appendAsLeader(x$1, epoch, x$3, x$5, x$4, x$6));
    }

    public org.apache.kafka.raft.LogAppendInfo appendAsFollower(Records records) {
        if (records.sizeInBytes() == 0) {
            throw new IllegalArgumentException("Attempt to append an empty record set");
        }
        return this.handleAndConvertLogAppendInfo(this.log().appendAsFollower((MemoryRecords)records));
    }

    private org.apache.kafka.raft.LogAppendInfo handleAndConvertLogAppendInfo(LogAppendInfo appendInfo) {
        if (appendInfo.firstOffset().isPresent()) {
            return new org.apache.kafka.raft.LogAppendInfo(((org.apache.kafka.storage.internals.log.LogOffsetMetadata)appendInfo.firstOffset().get()).messageOffset, appendInfo.lastOffset());
        }
        throw new KafkaException(new StringBuilder(28).append("Append failed unexpectedly: ").append(appendInfo.errorMessage()).toString());
    }

    public int lastFetchedEpoch() {
        return BoxesRunTime.unboxToInt((Object)this.log().latestEpoch().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)this.latestSnapshotId().map(snapshotId -> BoxesRunTime.boxToInteger((int)KafkaMetadataLog.$anonfun$lastFetchedEpoch$2(this, snapshotId))).orElse(BoxesRunTime.boxToInteger((int)0)))));
    }

    public OffsetAndEpoch endOffsetForEpoch(int epoch) {
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.earliestSnapshotId()));
        Option<org.apache.kafka.server.common.OffsetAndEpoch> option2 = this.log().endOffsetForEpoch(epoch);
        Tuple2 tuple2 = new Tuple2(option2, (Object)option);
        if (option2 instanceof Some) {
            org.apache.kafka.server.common.OffsetAndEpoch offsetAndEpoch = (org.apache.kafka.server.common.OffsetAndEpoch)((Some)option2).value();
            if (option instanceof Some) {
                OffsetAndEpoch snapshotId = (OffsetAndEpoch)((Some)option).value();
                if (offsetAndEpoch.offset() == snapshotId.offset() && offsetAndEpoch.leaderEpoch() == epoch) {
                    return new OffsetAndEpoch(snapshotId.offset(), snapshotId.epoch());
                }
            }
        }
        if (option2 instanceof Some) {
            org.apache.kafka.server.common.OffsetAndEpoch offsetAndEpoch = (org.apache.kafka.server.common.OffsetAndEpoch)((Some)option2).value();
            return new OffsetAndEpoch(offsetAndEpoch.offset(), offsetAndEpoch.leaderEpoch());
        }
        if (None$.MODULE$.equals(option2)) {
            return new OffsetAndEpoch(this.endOffset().offset, this.lastFetchedEpoch());
        }
        throw new MatchError((Object)tuple2);
    }

    public LogOffsetMetadata endOffset() {
        org.apache.kafka.storage.internals.log.LogOffsetMetadata endOffsetMetadata = this.log().logEndOffsetMetadata();
        return new LogOffsetMetadata(endOffsetMetadata.messageOffset, Optional.of(new SegmentPosition(endOffsetMetadata.segmentBaseOffset, endOffsetMetadata.relativePositionInSegment)));
    }

    public long startOffset() {
        return this.log().logStartOffset();
    }

    public void truncateTo(long offset) {
        if (offset < this.highWatermark().offset) {
            throw new IllegalArgumentException(new StringBuilder(74).append("Attempt to truncate to offset ").append(offset).append(", which is below ").append("the current high watermark ").append(this.highWatermark().offset).toString());
        }
        this.log().truncateTo(offset);
    }

    /*
     * WARNING - void declaration
     */
    public boolean truncateToLatestSnapshot() {
        void var5_8;
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap;
        boolean bl;
        OffsetAndEpoch snapshotId;
        int latestEpoch = BoxesRunTime.unboxToInt((Object)this.log().latestEpoch().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.latestSnapshotId()));
        if (option instanceof Some && ((snapshotId = (OffsetAndEpoch)((Some)option).value()).epoch() > latestEpoch || snapshotId.epoch() == latestEpoch && snapshotId.offset() > this.endOffset().offset)) {
            this.log().truncateFullyAndStartAt(snapshotId.offset(), this.log().truncateFullyAndStartAt$default$2());
            TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap2 = this.snapshots;
            synchronized (treeMap2) {
                TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap3 = this.forgetSnapshotsBefore(snapshotId);
                boolean bl2 = true;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl10 : MonitorExitStatement: MONITOREXIT : var4_4
                bl = bl2;
                treeMap = treeMap3;
            }
        } else {
            bl = false;
            treeMap = TreeMap$.MODULE$.empty(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
        }
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap4 = treeMap;
        boolean truncated = bl;
        this.removeSnapshots(treeMap4);
        return (boolean)var5_8;
    }

    public void initializeLeaderEpoch(int epoch) {
        this.log().maybeAssignEpochStartOffset(epoch, this.log().logEndOffset());
    }

    public void updateHighWatermark(LogOffsetMetadata offsetMetadata) {
        long logHighWatermark;
        long l;
        OffsetMetadata segmentPosition;
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(offsetMetadata.metadata));
        if (option instanceof Some && (segmentPosition = (OffsetMetadata)((Some)option).value()) instanceof SegmentPosition) {
            SegmentPosition segmentPosition2 = (SegmentPosition)segmentPosition;
            l = this.log().updateHighWatermark(new org.apache.kafka.storage.internals.log.LogOffsetMetadata(offsetMetadata.offset, segmentPosition2.baseOffset(), segmentPosition2.relativePosition()));
        } else {
            l = logHighWatermark = this.log().updateHighWatermark(offsetMetadata.offset);
        }
        if (logHighWatermark != offsetMetadata.offset) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(this.msgWithLogIdent(KafkaMetadataLog.$anonfun$updateHighWatermark$1(logHighWatermark, offsetMetadata)));
                return;
            }
            return;
        }
    }

    public LogOffsetMetadata highWatermark() {
        org.apache.kafka.storage.internals.log.LogOffsetMetadata hwm = this.log().fetchOffsetSnapshot().highWatermark;
        Optional segmentPosition = hwm.messageOffsetOnly() ? Optional.of(new SegmentPosition(hwm.segmentBaseOffset, hwm.relativePositionInSegment)) : Optional.empty();
        return new LogOffsetMetadata(hwm.messageOffset, segmentPosition);
    }

    public void flush(boolean forceFlushActiveSegment) {
        this.log().flush(forceFlushActiveSegment);
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public Uuid topicId() {
        return (Uuid)this.log().topicId().get();
    }

    public Optional<RawSnapshotWriter> createNewSnapshot(OffsetAndEpoch snapshotId) {
        if (snapshotId.offset() < this.startOffset()) {
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(this.msgWithLogIdent(KafkaMetadataLog.$anonfun$createNewSnapshot$1(this, snapshotId)));
            }
            return Optional.empty();
        }
        long highWatermarkOffset = this.highWatermark().offset;
        if (snapshotId.offset() > highWatermarkOffset) {
            throw new IllegalArgumentException(new StringBuilder(73).append("Cannot create a snapshot with an id (").append(snapshotId).append(") greater than the high-watermark (").append(highWatermarkOffset).append(")").toString());
        }
        ValidOffsetAndEpoch validOffsetAndEpoch = this.validateOffsetAndEpoch(snapshotId.offset(), snapshotId.epoch());
        ValidOffsetAndEpoch.Kind kind = validOffsetAndEpoch.kind();
        ValidOffsetAndEpoch.Kind kind2 = ValidOffsetAndEpoch.Kind.VALID;
        if (kind == null ? kind2 != null : !kind.equals(kind2)) {
            throw new IllegalArgumentException(new StringBuilder(50).append("Snapshot id (").append(snapshotId).append(") is not valid according to the log: ").append(validOffsetAndEpoch).toString());
        }
        return this.storeSnapshot(snapshotId);
    }

    public Optional<RawSnapshotWriter> storeSnapshot(OffsetAndEpoch snapshotId) {
        boolean bl;
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            bl = this.snapshots.contains((Object)snapshotId);
        }
        if (bl) {
            return Optional.empty();
        }
        return Optional.of(FileRawSnapshotWriter.create((Path)this.log().dir().toPath(), (OffsetAndEpoch)snapshotId, Optional.of(this)));
    }

    /*
     * Unable to fully structure code
     */
    public Optional<RawSnapshotReader> readSnapshot(OffsetAndEpoch snapshotId) {
        var2_2 = this.snapshots;
        synchronized (var2_2) {
            block8: {
                block7: {
                    var5_3 = false;
                    var6_4 = null;
                    var7_5 = this.snapshots.get((Object)snapshotId);
                    if (!None$.MODULE$.equals(var7_5)) break block7;
                    v0 = None$.MODULE$;
                    break block8;
                }
                if (!(var7_5 instanceof Some)) ** GOTO lbl-1000
                var5_3 = true;
                var6_4 = (Some)var7_5;
                var8_6 = (Option)var6_4.value();
                if (None$.MODULE$.equals(var8_6)) {
                    v0 = this.liftedTree1$1(snapshotId);
                } else if (var5_3) {
                    v0 = (Option)var6_4.value();
                } else {
                    throw new MatchError((Object)var7_5);
                }
            }
            reader = v0;
            var3_8 = OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8((Option)reader));
            return var3_8;
        }
    }

    public Optional<RawSnapshotReader> latestSnapshot() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            Optional<RawSnapshotReader> optional = this.latestSnapshotId().flatMap(snapshotId -> this.readSnapshot((OffsetAndEpoch)snapshotId));
            return optional;
        }
    }

    public Optional<OffsetAndEpoch> latestSnapshotId() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            Optional optional = OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(this.snapshots.lastOption().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 != null) {
                    return (OffsetAndEpoch)x0$1._1();
                }
                throw new MatchError(null);
            })));
            return optional;
        }
    }

    public Optional<OffsetAndEpoch> earliestSnapshotId() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            Optional optional = OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(this.snapshots.headOption().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 != null) {
                    return (OffsetAndEpoch)x0$1._1();
                }
                throw new MatchError(null);
            })));
            return optional;
        }
    }

    public void onSnapshotFrozen(OffsetAndEpoch snapshotId) {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            this.snapshots.put((Object)snapshotId, (Object)None$.MODULE$);
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean deleteBeforeSnapshot(OffsetAndEpoch snapshotId) {
        var2_2 = this.snapshots;
        synchronized (var2_2) {
            var3_3 = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.latestSnapshotId()));
            if (!(var3_3 instanceof Some)) ** GOTO lbl-1000
            latestSnapshotId = (OffsetAndEpoch)((Some)var3_3).value();
            if (this.snapshots.contains((Object)snapshotId) && this.startOffset() < snapshotId.offset() && snapshotId.offset() <= latestSnapshotId.offset() && this.log().maybeIncrementLogStartOffset(snapshotId.offset(), LogStartOffsetIncrementReason.SnapshotGenerated)) {
                this.log().deleteOldSegments();
                v0 = true;
                v1 = this.forgetSnapshotsBefore(snapshotId);
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
                v1 = TreeMap$.MODULE$.empty(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
            }
            var6_5 = v1;
            var5_6 = v0;
        }
        this.removeSnapshots(var6_5);
        return var5_6;
    }

    private Seq<Tuple2<OffsetAndEpoch, Object>> loadSnapshotSizes() {
        return (Seq)this.snapshots.keys().toSeq().flatMap((Function1 & Serializable & scala.Serializable)snapshotId -> Option$.MODULE$.option2Iterable(OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.readSnapshot((OffsetAndEpoch)snapshotId))).map((Function1 & Serializable & scala.Serializable)reader -> new Tuple2(snapshotId, (Object)BoxesRunTime.boxToLong((long)reader.sizeInBytes())))), Seq$.MODULE$.canBuildFrom());
    }

    private Option<Object> readSnapshotTimestamp(OffsetAndEpoch snapshotId) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.readSnapshot(snapshotId))).map((Function1 & Serializable & scala.Serializable)reader -> BoxesRunTime.boxToLong((long)KafkaMetadataLog.$anonfun$readSnapshotTimestamp$1(reader)));
    }

    public boolean maybeClean() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            boolean didClean = false;
            boolean bl = (didClean |= this.cleanSnapshotsRetentionSize()) | this.cleanSnapshotsRetentionMs();
            return bl;
        }
    }

    private boolean cleanSnapshots(Function1<OffsetAndEpoch, Object> predicate) {
        Object object = new Object();
        try {
            if (this.snapshots.size() < 2) {
                return false;
            }
            BooleanRef didClean = BooleanRef.create((boolean)false);
            this.snapshots.keys().toSeq().sliding(2).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Some some = Seq$.MODULE$.unapplySeq(x0$1);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                    OffsetAndEpoch snapshot = (OffsetAndEpoch)((SeqLike)some.get()).apply(0);
                    OffsetAndEpoch nextSnapshot = (OffsetAndEpoch)((SeqLike)some.get()).apply(1);
                    if (snapshot != null && nextSnapshot != null) {
                        if (BoxesRunTime.unboxToBoolean((Object)predicate.apply((Object)snapshot)) && this.deleteBeforeSnapshot(nextSnapshot)) {
                            didClean$1.elem = true;
                            return BoxedUnit.UNIT;
                        }
                        throw new NonLocalReturnControl.mcZ.sp(object, didClean$1.elem);
                    }
                }
                return BoxesRunTime.boxToBoolean((boolean)false);
            });
            return didClean.elem;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    private boolean cleanSnapshotsRetentionMs() {
        boolean bl;
        if (this.config.retentionMillis() < 0L) {
            return false;
        }
        Function1 & Serializable & scala.Serializable cleanSnapshots_predicate = (Function1 & Serializable & scala.Serializable)snapshotId -> BoxesRunTime.boxToBoolean((boolean)this.shouldClean$1(snapshotId));
        Object object = new Object();
        try {
            if (this.snapshots.size() >= 2) {
                BooleanRef cleanSnapshots_didClean = BooleanRef.create((boolean)false);
                this.snapshots.keys().toSeq().sliding(2).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Some some = Seq$.MODULE$.unapplySeq(x0$1);
                    if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                        OffsetAndEpoch snapshot = (OffsetAndEpoch)((SeqLike)some.get()).apply(0);
                        OffsetAndEpoch nextSnapshot = (OffsetAndEpoch)((SeqLike)some.get()).apply(1);
                        if (snapshot != null && nextSnapshot != null) {
                            if (BoxesRunTime.unboxToBoolean((Object)predicate.apply((Object)snapshot)) && this.deleteBeforeSnapshot(nextSnapshot)) {
                                didClean$1.elem = true;
                                return BoxedUnit.UNIT;
                            }
                            throw new NonLocalReturnControl.mcZ.sp(object, didClean$1.elem);
                        }
                    }
                    return BoxesRunTime.boxToBoolean((boolean)false);
                });
                return cleanSnapshots_didClean.elem;
            }
            bl = false;
        }
        catch (NonLocalReturnControl cleanSnapshots_ex) {
            if (cleanSnapshots_ex.key() == object) {
                return cleanSnapshots_ex.value$mcZ$sp();
            }
            throw cleanSnapshots_ex;
        }
        return bl;
    }

    private boolean cleanSnapshotsRetentionSize() {
        boolean bl;
        if (this.config.retentionMaxBytes() < 0L) {
            return false;
        }
        Map snapshotSizes = this.loadSnapshotSizes().toMap(Predef$.MODULE$.$conforms());
        LongRef snapshotTotalSize = LongRef.create((long)BoxesRunTime.unboxToLong((Object)snapshotSizes.values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
        Function1 & Serializable & scala.Serializable cleanSnapshots_predicate = (Function1 & Serializable & scala.Serializable)snapshotId -> BoxesRunTime.boxToBoolean((boolean)this.shouldClean$2(snapshotId, snapshotSizes, snapshotTotalSize));
        Object object = new Object();
        try {
            if (this.snapshots.size() >= 2) {
                BooleanRef cleanSnapshots_didClean = BooleanRef.create((boolean)false);
                this.snapshots.keys().toSeq().sliding(2).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Some some = Seq$.MODULE$.unapplySeq(x0$1);
                    if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                        OffsetAndEpoch snapshot = (OffsetAndEpoch)((SeqLike)some.get()).apply(0);
                        OffsetAndEpoch nextSnapshot = (OffsetAndEpoch)((SeqLike)some.get()).apply(1);
                        if (snapshot != null && nextSnapshot != null) {
                            if (BoxesRunTime.unboxToBoolean((Object)predicate.apply((Object)snapshot)) && this.deleteBeforeSnapshot(nextSnapshot)) {
                                didClean$1.elem = true;
                                return BoxedUnit.UNIT;
                            }
                            throw new NonLocalReturnControl.mcZ.sp(object, didClean$1.elem);
                        }
                    }
                    return BoxesRunTime.boxToBoolean((boolean)false);
                });
                return cleanSnapshots_didClean.elem;
            }
            bl = false;
        }
        catch (NonLocalReturnControl cleanSnapshots_ex) {
            if (cleanSnapshots_ex.key() == object) {
                return cleanSnapshots_ex.value$mcZ$sp();
            }
            throw cleanSnapshots_ex;
        }
        return bl;
    }

    private TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> forgetSnapshotsBefore(OffsetAndEpoch logStartSnapshotId) {
        TreeMap expiredSnapshots = (TreeMap)((MapLike)this.snapshots.until((Object)logStartSnapshotId)).clone();
        this.snapshots.$minus$minus$eq((TraversableOnce)expiredSnapshots.keys());
        return expiredSnapshots;
    }

    private void removeSnapshots(TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> expiredSnapshots) {
        expiredSnapshots.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                OffsetAndEpoch snapshotId = (OffsetAndEpoch)x0$1._1();
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(this.msgWithLogIdent(KafkaMetadataLog.$anonfun$removeSnapshots$2(snapshotId)));
                }
                return Snapshots.markForDelete((Path)this.log().dir().toPath(), (OffsetAndEpoch)snapshotId);
            }
            throw new MatchError(null);
        });
        if (expiredSnapshots.nonEmpty()) {
            this.scheduler.scheduleOnce("delete-snapshot-files", () -> KafkaMetadataLog$.MODULE$.kafka$raft$KafkaMetadataLog$$deleteSnapshotFiles(this.log().dir().toPath(), expiredSnapshots, this), this.config.fileDeleteDelayMs());
            return;
        }
    }

    public void close() {
        this.log().close();
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            ((IterableLike)this.snapshots.values().flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                x$3.close();
                return BoxedUnit.UNIT;
            });
            this.snapshots.clear();
            return;
        }
    }

    public int snapshotCount() {
        TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> treeMap = this.snapshots;
        synchronized (treeMap) {
            int n = this.snapshots.size();
            return n;
        }
    }

    public static final /* synthetic */ int $anonfun$lastFetchedEpoch$2(KafkaMetadataLog $this, OffsetAndEpoch snapshotId) {
        long logEndOffset = $this.endOffset().offset;
        if (snapshotId.offset() == $this.startOffset() && snapshotId.offset() == logEndOffset) {
            return snapshotId.epoch();
        }
        throw new KafkaException(new StringBuilder(159).append("Log doesn't have a last fetch epoch and there is a snapshot (").append(snapshotId).append("). ").append("Expected the snapshot's end offset to match the log's end offset (").append(logEndOffset).append(") ").append("and the log start offset (").append($this.startOffset()).append(")").toString());
    }

    public static final /* synthetic */ String $anonfun$updateHighWatermark$1(long logHighWatermark$1, LogOffsetMetadata offsetMetadata$1) {
        return new StringBuilder(79).append("Log's high watermark (").append(logHighWatermark$1).append(") is different from the local replica's high watermark (").append(offsetMetadata$1).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$createNewSnapshot$1(KafkaMetadataLog $this, OffsetAndEpoch snapshotId$1) {
        return new StringBuilder(72).append("Cannot create a snapshot with an id (").append(snapshotId$1).append(") less than the log start offset (").append($this.startOffset()).append(")").toString();
    }

    public static final /* synthetic */ String $anonfun$readSnapshot$1(OffsetAndEpoch snapshotId$2, Path path$1) {
        return new StringBuilder(47).append("Couldn't read ").append(snapshotId$2).append("; expected to find snapshot file ").append(path$1).toString();
    }

    /*
     * WARNING - void declaration
     */
    private final /* synthetic */ Option liftedTree1$1(OffsetAndEpoch snapshotId$2) {
        try {
            void var2_2;
            Some snapshotReader = new Some((Object)FileRawSnapshotReader.open((Path)this.log().dir().toPath(), (OffsetAndEpoch)snapshotId$2));
            this.snapshots.put((Object)snapshotId$2, (Object)snapshotReader);
            return var2_2;
        }
        catch (NoSuchFileException noSuchFileException) {
            Path path = Snapshots.snapshotPath((Path)this.log().dir().toPath(), (OffsetAndEpoch)snapshotId$2);
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(this.msgWithLogIdent(KafkaMetadataLog.$anonfun$readSnapshot$1(snapshotId$2, path)));
            }
            this.snapshots.remove((Object)snapshotId$2);
            return None$.MODULE$;
        }
    }

    public static final /* synthetic */ long $anonfun$readSnapshotTimestamp$1(RawSnapshotReader reader) {
        return Snapshots.lastContainedLogTimestamp((RawSnapshotReader)reader);
    }

    private final boolean shouldClean$1(OffsetAndEpoch snapshotId) {
        long now = this.time.milliseconds();
        return this.readSnapshotTimestamp(snapshotId).exists((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)timestamp -> now - timestamp > $this.config.retentionMillis());
    }

    private final boolean shouldClean$2(OffsetAndEpoch snapshotId, Map snapshotSizes$1, LongRef snapshotTotalSize$1) {
        return snapshotSizes$1.get((Object)snapshotId).exists((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)snapshotSize -> {
            if (this.log().size() + snapshotTotalSize$1.elem > $this.config.retentionMaxBytes()) {
                snapshotTotalSize$1.elem -= snapshotSize;
                return true;
            }
            return false;
        });
    }

    public static final /* synthetic */ String $anonfun$removeSnapshots$2(OffsetAndEpoch snapshotId$4) {
        return new StringBuilder(30).append("Marking snapshot ").append(snapshotId$4).append(" for deletion").toString();
    }

    public KafkaMetadataLog(UnifiedLog log, Time time, Scheduler scheduler, TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> snapshots, TopicPartition topicPartition, MetadataLogConfig config) {
        this.log = log;
        this.time = time;
        this.scheduler = scheduler;
        this.snapshots = snapshots;
        this.topicPartition = topicPartition;
        this.config = config;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(34).append("[MetadataLog partition=").append(topicPartition).append(", nodeId=").append(config.nodeId()).append("] ").toString());
    }
}

