/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kafka.server.FinalizedFeatureChangeListener$FeatureZNodeChangeHandler$;
import kafka.server.FinalizedFeatureChangeListener$ZkStateChangeHandler$;
import kafka.server.metadata.FeatureCacheUpdateException;
import kafka.server.metadata.ZkMetadataCache;
import kafka.utils.Logging;
import kafka.zk.FeatureZNode;
import kafka.zk.FeatureZNode$;
import kafka.zk.FeatureZNodeStatus;
import kafka.zk.FeatureZNodeStatus$Disabled$;
import kafka.zk.FeatureZNodeStatus$Enabled$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZkVersion$;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.server.util.ShutdownableThread;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005%e\u0001B\u0015+\u0001=B\u0001\u0002\u0010\u0001\u0003\u0006\u0004%I!\u0010\u0005\t\t\u0002\u0011\t\u0011)A\u0005}!AQ\t\u0001BC\u0002\u0013%a\t\u0003\u0005N\u0001\t\u0005\t\u0015!\u0003H\u0011\u0015q\u0005\u0001\"\u0001P\r\u0011!\u0006\u0001B+\t\u0011Y3!\u0011!Q\u0001\n]C\u0001B\u0019\u0004\u0003\u0002\u0003\u0006Ia\u0019\u0005\u0006\u001d\u001a!\t\u0001\u001d\u0005\u0006\u001d\u001a!\t!\u001e\u0005\u0006o\u001a!\t\u0001\u001f\u0005\u0006y\u001a!\t! \u0004\u0007\u0003\u000f\u0001A!!\u0003\t\u0013\u0005\u0005RB!A!\u0002\u00139\u0006B\u0002(\u000e\t\u0003\t\u0019\u0003\u0003\u0004\u0002*5!\t\u0005_\u0004\b\u0003W\u0001\u0001\u0012AA\u0017\r\u001d\ty\u0003\u0001E\u0001\u0003cAaA\u0014\n\u0005\u0002\u0005}\u0002\"CA!%\t\u0007I\u0011IA\"\u0011\u001d\t)E\u0005Q\u0001\n]Ca!a\u0012\u0013\t\u0003B\bBBA%%\u0011\u0005\u0003\u0010\u0003\u0004\u0002LI!\t\u0005_\u0004\b\u0003\u001b\u0002\u0001\u0012AA(\r\u001d\t\t\u0006\u0001E\u0001\u0003'BaA\u0014\u000e\u0005\u0002\u0005m\u0003\"CA!5\t\u0007I\u0011AA\"\u0011\u001d\t)E\u0007Q\u0001\n]C\u0011\"!\t\u001b\u0005\u0004%\t%a\u0011\t\u000f\u0005u#\u0004)A\u0005/\"1\u0011q\f\u000e\u0005BaD\u0011\"!\u0019\u0001\u0005\u0004%I!a\u0019\t\u0011\u0005-\u0004\u0001)A\u0005\u0003KB\u0011\"!\u001c\u0001\u0005\u0004%I!a\u001c\t\u0011\u0005E\u0004\u0001)A\u0005\u0003KAq!a\u001d\u0001\t\u0003\t)\b\u0003\u0004\u0002|\u0001!\t\u0001\u001f\u0005\b\u0003{\u0002A\u0011AA@\u0011\u001d\t9\t\u0001C\u0001\u0003\u007f\u0012aDR5oC2L'0\u001a3GK\u0006$XO]3DQ\u0006tw-\u001a'jgR,g.\u001a:\u000b\u0005-b\u0013AB:feZ,'OC\u0001.\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u00197!\t\tD'D\u00013\u0015\u0005\u0019\u0014!B:dC2\f\u0017BA\u001b3\u0005\u0019\te.\u001f*fMB\u0011qGO\u0007\u0002q)\u0011\u0011\bL\u0001\u0006kRLGn]\u0005\u0003wa\u0012q\u0001T8hO&tw-A\u000bgS:\fG.\u001b>fI\u001a+\u0017\r^;sK\u000e\u000b7\r[3\u0016\u0003y\u0002\"a\u0010\"\u000e\u0003\u0001S!!\u0011\u0016\u0002\u00115,G/\u00193bi\u0006L!a\u0011!\u0003\u001fi[W*\u001a;bI\u0006$\u0018mQ1dQ\u0016\faCZ5oC2L'0\u001a3GK\u0006$XO]3DC\u000eDW\rI\u0001\tu.\u001cE.[3oiV\tq\t\u0005\u0002I\u00176\t\u0011J\u0003\u0002KY\u0005\u0011!p[\u0005\u0003\u0019&\u0013QbS1gW\u0006T6n\u00117jK:$\u0018!\u0003>l\u00072LWM\u001c;!\u0003\u0019a\u0014N\\5u}Q\u0019\u0001KU*\u0011\u0005E\u0003Q\"\u0001\u0016\t\u000bq*\u0001\u0019\u0001 \t\u000b\u0015+\u0001\u0019A$\u0003'\u0019+\u0017\r^;sK\u000e\u000b7\r[3Va\u0012\fG/\u001a:\u0014\u0005\u0019\u0001\u0014!\u00054fCR,(/\u001a.l\u001d>$W\rU1uQB\u0011\u0001l\u0018\b\u00033v\u0003\"A\u0017\u001a\u000e\u0003mS!\u0001\u0018\u0018\u0002\rq\u0012xn\u001c;?\u0013\tq&'\u0001\u0004Qe\u0016$WMZ\u0005\u0003A\u0006\u0014aa\u0015;sS:<'B\u000103\u0003=i\u0017-\u001f2f\u001d>$\u0018NZ=P]\u000e,\u0007cA\u0019eM&\u0011QM\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\u001dtW\"\u00015\u000b\u0005%T\u0017AC2p]\u000e,(O]3oi*\u00111\u000e\\\u0001\u0005kRLGNC\u0001n\u0003\u0011Q\u0017M^1\n\u0005=D'AD\"pk:$Hi\\<o\u0019\u0006$8\r\u001b\u000b\u0004cN$\bC\u0001:\u0007\u001b\u0005\u0001\u0001\"\u0002,\n\u0001\u00049\u0006\"\u00022\n\u0001\u0004\u0019GCA9w\u0011\u00151&\u00021\u0001X\u0003M)\b\u000fZ1uK2\u000bG/Z:u\u001fJ$\u0006N]8x)\u0005I\bCA\u0019{\u0013\tY(G\u0001\u0003V]&$\u0018AE1xC&$X\u000b\u001d3bi\u0016|%\u000f\u00165s_^$\"!\u001f@\t\r}d\u0001\u0019AA\u0001\u0003)9\u0018-\u001b;US6,Wj\u001d\t\u0004c\u0005\r\u0011bAA\u0003e\t!Aj\u001c8h\u0005\u0005\u001a\u0005.\u00198hK:{G/\u001b4jG\u0006$\u0018n\u001c8Qe>\u001cWm]:peRC'/Z1e'\u0011i\u00111\u0002\u001c\u0011\t\u00055\u0011QD\u0007\u0003\u0003\u001fQ1a[A\t\u0015\rY\u00131\u0003\u0006\u0004[\u0005U!\u0002BA\f\u00033\ta!\u00199bG\",'BAA\u000e\u0003\ry'oZ\u0005\u0005\u0003?\tyA\u0001\nTQV$Hm\\<oC\ndW\r\u00165sK\u0006$\u0017\u0001\u00028b[\u0016$B!!\n\u0002(A\u0011!/\u0004\u0005\u0007\u0003Cy\u0001\u0019A,\u0002\r\u0011|wk\u001c:l\u0003e1U-\u0019;ve\u0016Tfj\u001c3f\u0007\"\fgnZ3IC:$G.\u001a:\u0011\u0005I\u0014\"!\u0007$fCR,(/\u001a.O_\u0012,7\t[1oO\u0016D\u0015M\u001c3mKJ\u001cBA\u0005\u0019\u00024A!\u0011QGA\u001e\u001b\t\t9DC\u0002\u0002:1\n\u0011B_8pW\u0016,\u0007/\u001a:\n\t\u0005u\u0012q\u0007\u0002\u00135:{G-Z\"iC:<W\rS1oI2,'\u000f\u0006\u0002\u0002.\u0005!\u0001/\u0019;i+\u00059\u0016!\u00029bi\"\u0004\u0013A\u00045b]\u0012dWm\u0011:fCRLwN\\\u0001\u0011Q\u0006tG\r\\3ECR\f7\t[1oO\u0016\fa\u0002[1oI2,G)\u001a7fi&|g.\u0001\u000b[WN#\u0018\r^3DQ\u0006tw-\u001a%b]\u0012dWM\u001d\t\u0003ej\u0011ACW6Ti\u0006$Xm\u00115b]\u001e,\u0007*\u00198eY\u0016\u00148\u0003\u0002\u000e1\u0003+\u0002B!!\u000e\u0002X%!\u0011\u0011LA\u001c\u0005I\u0019F/\u0019;f\u0007\"\fgnZ3IC:$G.\u001a:\u0015\u0005\u0005=\u0013!\u00028b[\u0016\u0004\u0013\u0001G1gi\u0016\u0014\u0018J\\5uS\u0006d\u0017N_5oON+7o]5p]\u0006)\u0011/^3vKV\u0011\u0011Q\r\t\u0005O\u0006\u001d\u0014/C\u0002\u0002j!\u00141\u0003T5oW\u0016$'\t\\8dW&tw-U;fk\u0016\fa!];fk\u0016\u0004\u0013A\u0002;ie\u0016\fG-\u0006\u0002\u0002&\u00059A\u000f\u001b:fC\u0012\u0004\u0013aC5oSR|%\u000f\u00165s_^$2!_A<\u0011\u001d\tI(\na\u0001\u0003\u0003\t\u0001d^1ji>s7-\u001a$pe\u000e\u000b7\r[3Va\u0012\fG/Z't\u0003\u0015\u0019Gn\\:f\u0003MI7\u000fT5ti\u0016tWM]%oSRL\u0017\r^3e+\t\t\t\tE\u00022\u0003\u0007K1!!\"3\u0005\u001d\u0011un\u001c7fC:\fa\"[:MSN$XM\\3s\t\u0016\fG\r")
public class FinalizedFeatureChangeListener
implements Logging {
    private volatile FinalizedFeatureChangeListener$FeatureZNodeChangeHandler$ FeatureZNodeChangeHandler$module;
    private volatile FinalizedFeatureChangeListener$ZkStateChangeHandler$ ZkStateChangeHandler$module;
    private final ZkMetadataCache kafka$server$FinalizedFeatureChangeListener$$finalizedFeatureCache;
    private final KafkaZkClient kafka$server$FinalizedFeatureChangeListener$$zkClient;
    private final LinkedBlockingQueue<FeatureCacheUpdater> kafka$server$FinalizedFeatureChangeListener$$queue;
    private final ChangeNotificationProcessorThread thread;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public FinalizedFeatureChangeListener$FeatureZNodeChangeHandler$ FeatureZNodeChangeHandler() {
        if (this.FeatureZNodeChangeHandler$module == null) {
            this.FeatureZNodeChangeHandler$lzycompute$1();
        }
        return this.FeatureZNodeChangeHandler$module;
    }

    public FinalizedFeatureChangeListener$ZkStateChangeHandler$ ZkStateChangeHandler() {
        if (this.ZkStateChangeHandler$module == null) {
            this.ZkStateChangeHandler$lzycompute$1();
        }
        return this.ZkStateChangeHandler$module;
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ZkMetadataCache kafka$server$FinalizedFeatureChangeListener$$finalizedFeatureCache() {
        return this.kafka$server$FinalizedFeatureChangeListener$$finalizedFeatureCache;
    }

    public KafkaZkClient kafka$server$FinalizedFeatureChangeListener$$zkClient() {
        return this.kafka$server$FinalizedFeatureChangeListener$$zkClient;
    }

    public LinkedBlockingQueue<FeatureCacheUpdater> kafka$server$FinalizedFeatureChangeListener$$queue() {
        return this.kafka$server$FinalizedFeatureChangeListener$$queue;
    }

    private ChangeNotificationProcessorThread thread() {
        return this.thread;
    }

    public void initOrThrow(long waitOnceForCacheUpdateMs) {
        if (waitOnceForCacheUpdateMs <= 0L) {
            throw new IllegalArgumentException(new StringBuilder(53).append("Expected waitOnceForCacheUpdateMs > 0, but provided: ").append(waitOnceForCacheUpdateMs).toString());
        }
        this.thread().start();
        this.kafka$server$FinalizedFeatureChangeListener$$zkClient().registerStateChangeHandler(this.ZkStateChangeHandler());
        this.kafka$server$FinalizedFeatureChangeListener$$zkClient().registerZNodeChangeHandlerAndCheckExistence(this.FeatureZNodeChangeHandler());
        FeatureCacheUpdater ensureCacheUpdateOnce = new FeatureCacheUpdater(this, this.FeatureZNodeChangeHandler().path(), (Option<CountDownLatch>)new Some((Object)new CountDownLatch(1)));
        this.kafka$server$FinalizedFeatureChangeListener$$queue().add(ensureCacheUpdateOnce);
        try {
            ensureCacheUpdateOnce.awaitUpdateOrThrow(waitOnceForCacheUpdateMs);
            return;
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    public void close() {
        this.kafka$server$FinalizedFeatureChangeListener$$zkClient().unregisterStateChangeHandler(this.ZkStateChangeHandler().name());
        this.kafka$server$FinalizedFeatureChangeListener$$zkClient().unregisterZNodeChangeHandler(this.FeatureZNodeChangeHandler().path());
        this.kafka$server$FinalizedFeatureChangeListener$$queue().clear();
        this.thread().shutdown();
    }

    public boolean isListenerInitiated() {
        return this.thread().isRunning() && this.thread().isAlive();
    }

    public boolean isListenerDead() {
        return !this.thread().isRunning() && !this.thread().isAlive();
    }

    private final void FeatureZNodeChangeHandler$lzycompute$1() {
        synchronized (this) {
            if (this.FeatureZNodeChangeHandler$module == null) {
                this.FeatureZNodeChangeHandler$module = new FinalizedFeatureChangeListener$FeatureZNodeChangeHandler$(this);
            }
            return;
        }
    }

    private final void ZkStateChangeHandler$lzycompute$1() {
        synchronized (this) {
            if (this.ZkStateChangeHandler$module == null) {
                this.ZkStateChangeHandler$module = new FinalizedFeatureChangeListener$ZkStateChangeHandler$(this);
            }
            return;
        }
    }

    public FinalizedFeatureChangeListener(ZkMetadataCache finalizedFeatureCache, KafkaZkClient zkClient) {
        this.kafka$server$FinalizedFeatureChangeListener$$finalizedFeatureCache = finalizedFeatureCache;
        this.kafka$server$FinalizedFeatureChangeListener$$zkClient = zkClient;
        Logging.$init$(this);
        this.kafka$server$FinalizedFeatureChangeListener$$queue = new LinkedBlockingQueue();
        this.thread = new ChangeNotificationProcessorThread("feature-zk-node-event-process-thread");
    }

    private class ChangeNotificationProcessorThread
    extends ShutdownableThread
    implements Logging {
        private Logger logger;
        private String logIdent;
        private volatile boolean bitmap$0;

        @Override
        public String loggerName() {
            return Logging.loggerName$(this);
        }

        @Override
        public String msgWithLogIdent(String msg) {
            return Logging.msgWithLogIdent$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg) {
            Logging.trace$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging.trace$(this, msg, e);
        }

        @Override
        public boolean isDebugEnabled() {
            return Logging.isDebugEnabled$(this);
        }

        @Override
        public boolean isTraceEnabled() {
            return Logging.isTraceEnabled$(this);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging.debug$(this, msg);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging.debug$(this, msg, e);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging.info$(this, msg);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging.info$(this, msg, e);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging.warn$(this, msg);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging.warn$(this, msg, e);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging.error$(this, msg);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging.error$(this, msg, e);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging.fatal$(this, msg);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging.fatal$(this, msg, e);
        }

        private Logger logger$lzycompute() {
            synchronized (this) {
                if (!this.bitmap$0) {
                    this.logger = Logging.logger$(this);
                    this.bitmap$0 = true;
                }
            }
            return this.logger;
        }

        @Override
        public Logger logger() {
            if (!this.bitmap$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        public void doWork() {
            try {
                this.kafka$server$FinalizedFeatureChangeListener$ChangeNotificationProcessorThread$$$outer().kafka$server$FinalizedFeatureChangeListener$$queue().take().updateLatestOrThrow();
                return;
            }
            catch (InterruptedException interruptedException) {
                throw interruptedException;
            }
            catch (FeatureCacheUpdateException cacheUpdateException) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to process feature ZK node change event. The broker will eventually exit.", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> cacheUpdateException);
                throw new FatalExitError(1);
            }
            catch (Exception e) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Unexpected exception in feature ZK node change event processing; will continue processing.", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                return;
            }
        }

        public /* synthetic */ FinalizedFeatureChangeListener kafka$server$FinalizedFeatureChangeListener$ChangeNotificationProcessorThread$$$outer() {
            return FinalizedFeatureChangeListener.this;
        }

        public ChangeNotificationProcessorThread(String name) {
            if (FinalizedFeatureChangeListener.this == null) {
                throw null;
            }
            super(name);
            Logging.$init$(this);
            this.logIdent_$eq(this.logPrefix);
        }
    }

    private class FeatureCacheUpdater {
        private final String featureZkNodePath;
        private final Option<CountDownLatch> maybeNotifyOnce;
        public final /* synthetic */ FinalizedFeatureChangeListener $outer;

        /*
         * WARNING - void declaration
         */
        public void updateLatestOrThrow() {
            this.maybeNotifyOnce.foreach((Function1 & Serializable & scala.Serializable)notifier -> {
                FeatureCacheUpdater.$anonfun$updateLatestOrThrow$1(notifier);
                return BoxedUnit.UNIT;
            });
            this.kafka$server$FinalizedFeatureChangeListener$FeatureCacheUpdater$$$outer().debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Reading feature ZK node at path: ").append($this.featureZkNodePath).toString());
            Tuple2<Option<byte[]>, Object> tuple2 = this.kafka$server$FinalizedFeatureChangeListener$FeatureCacheUpdater$$$outer().kafka$server$FinalizedFeatureChangeListener$$zkClient().getDataAndVersion(this.featureZkNodePath);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Option mayBeFeatureZNodeBytes = (Option)tuple2._1();
            int n = tuple2._2$mcI$sp();
            if (n == ZkVersion$.MODULE$.UnknownVersion()) {
                this.kafka$server$FinalizedFeatureChangeListener$FeatureCacheUpdater$$$outer().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Feature ZK node at path: ").append($this.featureZkNodePath).append(" does not exist").toString());
                this.kafka$server$FinalizedFeatureChangeListener$FeatureCacheUpdater$$$outer().kafka$server$FinalizedFeatureChangeListener$$finalizedFeatureCache().clearFeatures();
            } else {
                Option maybeFeatureZNode = Option$.MODULE$.empty();
                try {
                    void var2_2;
                    maybeFeatureZNode = new Some((Object)FeatureZNode$.MODULE$.decode((byte[])var2_2.get()));
                }
                catch (IllegalArgumentException e) {
                    this.kafka$server$FinalizedFeatureChangeListener$FeatureCacheUpdater$$$outer().error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Unable to deserialize feature ZK node at path: ").append($this.featureZkNodePath).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    this.kafka$server$FinalizedFeatureChangeListener$FeatureCacheUpdater$$$outer().kafka$server$FinalizedFeatureChangeListener$$finalizedFeatureCache().clearFeatures();
                }
                maybeFeatureZNode.foreach((Function1 & Serializable & scala.Serializable)featureZNode -> {
                    FeatureCacheUpdater.$anonfun$updateLatestOrThrow$6(this, n, featureZNode);
                    return BoxedUnit.UNIT;
                });
            }
            this.maybeNotifyOnce.foreach((Function1 & Serializable & scala.Serializable)notifier -> {
                notifier.countDown();
                return BoxedUnit.UNIT;
            });
        }

        public void awaitUpdateOrThrow(long waitTimeMs) {
            this.maybeNotifyOnce.foreach((Function1 & Serializable & scala.Serializable)notifier -> {
                FeatureCacheUpdater.$anonfun$awaitUpdateOrThrow$1(waitTimeMs, notifier);
                return BoxedUnit.UNIT;
            });
        }

        public /* synthetic */ FinalizedFeatureChangeListener kafka$server$FinalizedFeatureChangeListener$FeatureCacheUpdater$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$updateLatestOrThrow$1(CountDownLatch notifier) {
            if (notifier.getCount() != 1L) {
                throw new IllegalStateException("Can not notify after updateLatestOrThrow was called more than once successfully.");
            }
        }

        public static final /* synthetic */ void $anonfun$updateLatestOrThrow$6(FeatureCacheUpdater $this, int version$1, FeatureZNode featureZNode) {
            FeatureZNodeStatus featureZNodeStatus = featureZNode.status();
            if (FeatureZNodeStatus$Disabled$.MODULE$.equals(featureZNodeStatus)) {
                $this.kafka$server$FinalizedFeatureChangeListener$FeatureCacheUpdater$$$outer().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Feature ZK node at path: ").append($this.featureZkNodePath).append(" is in disabled status.").toString());
                $this.kafka$server$FinalizedFeatureChangeListener$FeatureCacheUpdater$$$outer().kafka$server$FinalizedFeatureChangeListener$$finalizedFeatureCache().clearFeatures();
                return;
            }
            if (FeatureZNodeStatus$Enabled$.MODULE$.equals(featureZNodeStatus)) {
                $this.kafka$server$FinalizedFeatureChangeListener$FeatureCacheUpdater$$$outer().kafka$server$FinalizedFeatureChangeListener$$finalizedFeatureCache().updateFeaturesOrThrow((Map<String, Object>)featureZNode.features().toMap(Predef$.MODULE$.$conforms()), version$1);
                return;
            }
            throw new IllegalStateException(new StringBuilder(39).append("Unexpected FeatureZNodeStatus found in ").append(featureZNode).toString());
        }

        public static final /* synthetic */ void $anonfun$awaitUpdateOrThrow$1(long waitTimeMs$1, CountDownLatch notifier) {
            if (!notifier.await(waitTimeMs$1, TimeUnit.MILLISECONDS)) {
                throw new TimeoutException(new StringBuilder(62).append("Timed out after waiting for ").append(waitTimeMs$1).append("ms for FeatureCache to be updated.").toString());
            }
        }

        public FeatureCacheUpdater(FinalizedFeatureChangeListener $outer, String featureZkNodePath, Option<CountDownLatch> maybeNotifyOnce) {
            this.featureZkNodePath = featureZkNodePath;
            this.maybeNotifyOnce = maybeNotifyOnce;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }

        public FeatureCacheUpdater(FinalizedFeatureChangeListener $outer, String featureZkNodePath) {
            this($outer, featureZkNodePath, (Option<CountDownLatch>)Option$.MODULE$.empty());
        }
    }
}

