/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import kafka.log.UnifiedLog$;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.KafkaMetadataLog$;
import kafka.raft.KafkaRaftManager$;
import kafka.raft.MetadataLogConfig$;
import kafka.raft.RaftManager;
import kafka.raft.TimingWheelExpirationService;
import kafka.server.KafkaConfig;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataRecoveryStrategy;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.Endpoints;
import org.apache.kafka.raft.ExpirationService;
import org.apache.kafka.raft.FileQuorumStateStore;
import org.apache.kafka.raft.KafkaNetworkChannel;
import org.apache.kafka.raft.KafkaRaftClient;
import org.apache.kafka.raft.KafkaRaftClientDriver;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.NetworkChannel;
import org.apache.kafka.raft.QuorumConfig;
import org.apache.kafka.raft.QuorumStateStore;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.server.ProcessRole;
import org.apache.kafka.server.common.Features;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.util.FileLock;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.server.util.timer.SystemTimer;
import org.apache.kafka.server.util.timer.Timer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r}r!\u0002\u001f>\u0011\u0003\u0011e!\u0002#>\u0011\u0003)\u0005\"\u0002'\u0002\t\u0003i\u0005\"\u0002(\u0002\t\u0013y\u0005\"B4\u0002\t\u0013A\u0007\"\u0002=\u0002\t\u0013I\bbBA\u0005\u0003\u0011\u0005\u00111\u0002\u0004\u0006\tv\u0002\u0011Q\u0003\u0005\n\u0003\u0003:!\u0011!Q\u0001\nqC\u0001B`\u0004\u0003\u0002\u0003\u0006Ia \u0005\u000b\u0003\u0007:!\u0011!Q\u0001\n\u0005\u0015\u0003BCA)\u000f\t\u0005\t\u0015!\u0003\u0002T!Q\u0011\u0011M\u0004\u0003\u0002\u0003\u0006I!a\u0019\t\u0015\u0005%tA!A!\u0002\u0013\t)\u0005\u0003\u0006\u0002l\u001d\u0011\t\u0011)A\u0005\u0003[B!\"a\u001e\b\u0005\u0003\u0005\u000b\u0011BA=\u0011)\t\u0019i\u0002B\u0001B\u0003%\u0011Q\u0011\u0005\u000b\u0003\u0017;!Q1A\u0005\u0002\u00055\u0005BCA_\u000f\t\u0005\t\u0015!\u0003\u0002\u0010\"Q\u0011qX\u0004\u0003\u0002\u0003\u0006I!!1\t\u0015\u0005\u001dwA!A!\u0002\u0013\tI\r\u0003\u0006\u0002T\u001e\u0011\t\u0011)A\u0005\u0003+Da\u0001T\u0004\u0005\u0002\u0005\u0005\b\"CA\u0000\u000f\t\u0007I\u0011\u0001B\u0001\u0011!\u0011ya\u0002Q\u0001\n\t\r\u0001\"\u0003B\t\u000f\t\u0007I\u0011\u0002B\n\u0011!\u0011Yb\u0002Q\u0001\n\tU\u0001\"\u0003B\u000f\u000f\t\u0007I\u0011\u0002B\u0010\u0011\u001d\u0011\tc\u0002Q\u0001\nqC\u0011Ba\t\b\u0005\u0004%IA!\n\t\u0011\t5r\u0001)A\u0005\u0005OA\u0011Ba\f\b\u0005\u0004%IA!\r\t\u0011\ter\u0001)A\u0005\u0005gA\u0001b^\u0004C\u0002\u0013%!1\b\u0005\b\u0005{9\u0001\u0015!\u0003Q\u0011%\u0011yd\u0002b\u0001\n\u0013\u0011\t\u0005\u0003\u0005\u0003F\u001d\u0001\u000b\u0011\u0002B\"\u0011%\u00119e\u0002b\u0001\n\u0003\u0012I\u0005\u0003\u0005\u0003R\u001d\u0001\u000b\u0011\u0002B&\u0011%\u0011\u0019f\u0002b\u0001\n\u0013\u0011)\u0006\u0003\u0005\u0003^\u001d\u0001\u000b\u0011\u0002B,\u0011%\u0011yf\u0002b\u0001\n\u0013\u0011\t\u0007\u0003\u0005\u0003p\u001d\u0001\u000b\u0011\u0002B2\u0011%\u0011\th\u0002b\u0001\n\u0013\u0011\u0019\b\u0003\u0005\u0003|\u001d\u0001\u000b\u0011\u0002B;\u0011%\u0011ih\u0002b\u0001\n\u0003\u0012y\b\u0003\u0005\u0003\b\u001e\u0001\u000b\u0011\u0002BA\u0011%\u0011Ii\u0002b\u0001\n\u0013\u0011Y\t\u0003\u0005\u0003\u0014\u001e\u0001\u000b\u0011\u0002BG\u0011\u001d\u0011)j\u0002C\u0001\u0005/CqA!'\b\t\u0003\u00119\nC\u0004\u0003\u001c\u001e!\tE!(\t\u000f\tEv\u0001\"\u0011\u00034\"9!1^\u0004\u0005\n\t5\bb\u0002Bx\u000f\u0011%!\u0011\u001f\u0005\b\u0005g<A\u0011\u0002B{\u0011\u001d\u00119p\u0002C\u0005\u0005sDqa!\u0001\b\t\u0013\u0019\u0019\u0001C\u0004\u0004\u001e\u001d!\tea\b\t\u000f\r\u001dr\u0001\"\u0011\u0004*\u0005\u00012*\u00194lCJ\u000bg\r^'b]\u0006<WM\u001d\u0006\u0003}}\nAA]1gi*\t\u0001)A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005\r\u000bQ\"A\u001f\u0003!-\u000bgm[1SC\u001a$X*\u00198bO\u0016\u00148CA\u0001G!\t9%*D\u0001I\u0015\u0005I\u0015!B:dC2\f\u0017BA&I\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012AQ\u0001\u0013GJ,\u0017\r^3M_\u001e$\u0015N]3di>\u0014\u0018\u0010F\u0002Q1j\u0003\"!\u0015,\u000e\u0003IS!a\u0015+\u0002\u0005%|'\"A+\u0002\t)\fg/Y\u0005\u0003/J\u0013AAR5mK\")\u0011l\u0001a\u0001!\u00061An\\4ESJDQaW\u0002A\u0002q\u000b!\u0002\\8h\t&\u0014h*Y7f!\tiFM\u0004\u0002_EB\u0011q\fS\u0007\u0002A*\u0011\u0011-Q\u0001\u0007yI|w\u000e\u001e \n\u0005\rD\u0015A\u0002)sK\u0012,g-\u0003\u0002fM\n11\u000b\u001e:j]\u001eT!a\u0019%\u0002\u00171|7m\u001b#bi\u0006$\u0015N\u001d\u000b\u0003SZ\u0004\"A\u001b;\u000e\u0003-T!\u0001\\7\u0002\tU$\u0018\u000e\u001c\u0006\u0003]>\faa]3sm\u0016\u0014(B\u0001!q\u0015\t\t(/\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002g\u0006\u0019qN]4\n\u0005U\\'\u0001\u0003$jY\u0016dunY6\t\u000b]$\u0001\u0019\u0001)\u0002\u000f\u0011\fG/\u0019#je\u0006\u0011\u0002.Y:ES\u001a4WM]3oi2{w\rR5s)\tQX\u0010\u0005\u0002Hw&\u0011A\u0010\u0013\u0002\b\u0005>|G.Z1o\u0011\u0015qX\u00011\u0001\u0000\u0003\u0019\u0019wN\u001c4jOB!\u0011\u0011AA\u0003\u001b\t\t\u0019A\u0003\u0002o\u007f%!\u0011qAA\u0002\u0005-Y\u0015MZ6b\u0007>tg-[4\u000235\f\u0017PY3EK2,G/Z'fi\u0006$\u0017\r^1M_\u001e$\u0015N\u001d\u000b\u0005\u0003\u001b\t\u0019\u0002E\u0002H\u0003\u001fI1!!\u0005I\u0005\u0011)f.\u001b;\t\u000by4\u0001\u0019A@\u0016\t\u0005]\u00111E\n\u0007\u000f\u0019\u000bI\"!\u000e\u0011\u000b\r\u000bY\"a\b\n\u0007\u0005uQHA\u0006SC\u001a$X*\u00198bO\u0016\u0014\b\u0003BA\u0011\u0003Ga\u0001\u0001B\u0004\u0002&\u001d\u0011\r!a\n\u0003\u0003Q\u000bB!!\u000b\u00020A\u0019q)a\u000b\n\u0007\u00055\u0002JA\u0004O_RD\u0017N\\4\u0011\u0007\u001d\u000b\t$C\u0002\u00024!\u00131!\u00118z!\u0011\t9$!\u0010\u000e\u0005\u0005e\"bAA\u001e\u007f\u0005)Q\u000f^5mg&!\u0011qHA\u001d\u0005\u001daunZ4j]\u001e\f\u0011b\u00197vgR,'/\u00133\u0002%5,G/\u00193bi\u0006dun\u001a#jeV+\u0018\u000e\u001a\t\u0005\u0003\u000f\ni%\u0004\u0002\u0002J)\u0019\u00111J8\u0002\r\r|W.\\8o\u0013\u0011\ty%!\u0013\u0003\tU+\u0018\u000eZ\u0001\fe\u0016\u001cwN\u001d3TKJ$W\r\u0005\u0004\u0002V\u0005u\u0013qD\u0007\u0003\u0003/RA!!\u0017\u0002\\\u0005i1/\u001a:jC2L'0\u0019;j_:T1!a\u0013n\u0013\u0011\ty&a\u0016\u0003\u0017I+7m\u001c:e'\u0016\u0014H-Z\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o!\u0011\t9%!\u001a\n\t\u0005\u001d\u0014\u0011\n\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003\u001d!x\u000e]5d\u0013\u0012\fA\u0001^5nKB!\u0011qNA:\u001b\t\t\tH\u0003\u0003\u0002<\u0005%\u0013\u0002BA;\u0003c\u0012A\u0001V5nK\u00069Q.\u001a;sS\u000e\u001c\b\u0003BA>\u0003\u007fj!!! \u000b\t\u0005]\u0014\u0011J\u0005\u0005\u0003\u0003\u000biHA\u0004NKR\u0014\u0018nY:\u0002'QD'/Z1e\u001d\u0006lW\r\u0015:fM&Dx\n\u001d;\u0011\t\u001d\u000b9\tX\u0005\u0004\u0003\u0013C%AB(qi&|g.\u0001\u000fd_:$(o\u001c7mKJ\fVo\u001c:v[Z{G/\u001a:t\rV$XO]3\u0016\u0005\u0005=\u0005CBAI\u00033\u000bi*\u0004\u0002\u0002\u0014*!\u0011QSAL\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003YRKA!a'\u0002\u0014\n\t2i\\7qY\u0016$\u0018M\u00197f\rV$XO]3\u0011\u0011\u0005}\u0015\u0011UAS\u0003ck!!a&\n\t\u0005\r\u0016q\u0013\u0002\u0004\u001b\u0006\u0004\b\u0003BAT\u0003[k!!!+\u000b\u0007\u0005-F+\u0001\u0003mC:<\u0017\u0002BAX\u0003S\u0013q!\u00138uK\u001e,'\u000f\u0005\u0003\u00024\u0006eVBAA[\u0015\r\t9\fV\u0001\u0004]\u0016$\u0018\u0002BA^\u0003k\u0013\u0011#\u00138fiN{7m[3u\u0003\u0012$'/Z:t\u0003u\u0019wN\u001c;s_2dWM])v_J,XNV8uKJ\u001ch)\u001e;ve\u0016\u0004\u0013\u0001\u00052p_R\u001cHO]1q'\u0016\u0014h/\u001a:t!\u0019\ty*a1\u00022&!\u0011QYAL\u0005)\u0019u\u000e\u001c7fGRLwN\\\u0001\u000fY>\u001c\u0017\r\u001c'jgR,g.\u001a:t!\u0011\tY-a4\u000e\u0005\u00055'B\u0001 p\u0013\u0011\t\t.!4\u0003\u0013\u0015sG\r]8j]R\u001c\u0018!\u00054bi\u0006dg)Y;mi\"\u000bg\u000e\u001a7feB!\u0011q[Ao\u001b\t\tINC\u0002\u0002\\6\fQAZ1vYRLA!a8\u0002Z\naa)Y;mi\"\u000bg\u000e\u001a7feRa\u00121]As\u0003O\fI/a;\u0002n\u0006=\u0018\u0011_Az\u0003k\f90!?\u0002|\u0006u\b\u0003B\"\b\u0003?Aa!!\u0011\u0017\u0001\u0004a\u0006\"\u0002@\u0017\u0001\u0004y\bbBA\"-\u0001\u0007\u0011Q\t\u0005\b\u0003#2\u0002\u0019AA*\u0011\u001d\t\tG\u0006a\u0001\u0003GBq!!\u001b\u0017\u0001\u0004\t)\u0005C\u0004\u0002lY\u0001\r!!\u001c\t\u000f\u0005]d\u00031\u0001\u0002z!9\u00111\u0011\fA\u0002\u0005\u0015\u0005bBAF-\u0001\u0007\u0011q\u0012\u0005\b\u0003\u007f3\u0002\u0019AAa\u0011\u001d\t9M\u0006a\u0001\u0003\u0013Dq!a5\u0017\u0001\u0004\t).A\u0006ba&4VM]:j_:\u001cXC\u0001B\u0002!\u0011\u0011)Aa\u0003\u000e\u0005\t\u001d!b\u0001B\u0005_\u000691\r\\5f]R\u001c\u0018\u0002\u0002B\u0007\u0005\u000f\u00111\"\u00119j-\u0016\u00148/[8og\u0006a\u0011\r]5WKJ\u001c\u0018n\u001c8tA\u0005Q!/\u00194u\u0007>tg-[4\u0016\u0005\tU\u0001\u0003BAf\u0005/IAA!\u0007\u0002N\na\u0011+^8sk6\u001cuN\u001c4jO\u0006Y!/\u00194u\u0007>tg-[4!\u0003A!\bN]3bI:\u000bW.\u001a)sK\u001aL\u00070F\u0001]\u0003E!\bN]3bI:\u000bW.\u001a)sK\u001aL\u0007\u0010I\u0001\u000bY><7i\u001c8uKb$XC\u0001B\u0014!\u0011\tyG!\u000b\n\t\t-\u0012\u0011\u000f\u0002\u000b\u0019><7i\u001c8uKb$\u0018a\u00037pO\u000e{g\u000e^3yi\u0002\n\u0011b]2iK\u0012,H.\u001a:\u0016\u0005\tM\u0002c\u00016\u00036%\u0019!qG6\u0003\u001d-\u000bgm[1TG\",G-\u001e7fe\u0006Q1o\u00195fIVdWM\u001d\u0011\u0016\u0003A\u000b\u0001\u0002Z1uC\u0012K'\u000fI\u0001\fI\u0006$\u0018\rR5s\u0019>\u001c7.\u0006\u0002\u0003DA!q)a\"j\u00031!\u0017\r^1ESJdunY6!\u00035\u0011X\r\u001d7jG\u0006$X\r\u001a'pOV\u0011!1\n\t\u0005\u0003\u0017\u0014i%\u0003\u0003\u0003P\u00055'!\u0004*fa2L7-\u0019;fI2{w-\u0001\bsKBd\u0017nY1uK\u0012dun\u001a\u0011\u0002\u00159,Go\u00115b]:,G.\u0006\u0002\u0003XA!\u00111\u001aB-\u0013\u0011\u0011Y&!4\u0003'-\u000bgm[1OKR<xN]6DQ\u0006tg.\u001a7\u0002\u00179,Go\u00115b]:,G\u000eI\u0001\u0010Kb\u0004\u0018N]1uS>tG+[7feV\u0011!1\r\t\u0005\u0005K\u0012Y'\u0004\u0002\u0003h)\u0019!\u0011N6\u0002\u000bQLW.\u001a:\n\t\t5$q\r\u0002\f'f\u001cH/Z7US6,'/\u0001\tfqBL'/\u0019;j_:$\u0016.\\3sA\u0005\tR\r\u001f9je\u0006$\u0018n\u001c8TKJ4\u0018nY3\u0016\u0005\tU\u0004cA\"\u0003x%\u0019!\u0011P\u001f\u00039QKW.\u001b8h/\",W\r\\#ya&\u0014\u0018\r^5p]N+'O^5dK\u0006\u0011R\r\u001f9je\u0006$\u0018n\u001c8TKJ4\u0018nY3!\u0003\u0019\u0019G.[3oiV\u0011!\u0011\u0011\t\u0007\u0003\u0017\u0014\u0019)a\b\n\t\t\u0015\u0015Q\u001a\u0002\u0010\u0017\u000647.\u0019*bMR\u001cE.[3oi\u000691\r\\5f]R\u0004\u0013\u0001D2mS\u0016tG\u000f\u0012:jm\u0016\u0014XC\u0001BG!\u0019\tYMa$\u0002 %!!\u0011SAg\u0005UY\u0015MZ6b%\u00064Go\u00117jK:$HI]5wKJ\fQb\u00197jK:$HI]5wKJ\u0004\u0013aB:uCJ$X\u000f\u001d\u000b\u0003\u0003\u001b\t\u0001b\u001d5vi\u0012|wO\\\u0001\te\u0016<\u0017n\u001d;feR!\u0011Q\u0002BP\u0011\u001d\u0011\tk\ra\u0001\u0005G\u000b\u0001\u0002\\5ti\u0016tWM\u001d\t\u0007\u0005K\u0013Y+a\b\u000f\t\u0005-'qU\u0005\u0005\u0005S\u000bi-\u0001\u0006SC\u001a$8\t\\5f]RLAA!,\u00030\nAA*[:uK:,'O\u0003\u0003\u0003*\u00065\u0017!\u00045b]\u0012dWMU3rk\u0016\u001cH\u000f\u0006\u0006\u00036\n\r'1\u001bBo\u0005C\u0004b!!%\u0002\u001a\n]\u0006\u0003\u0002B]\u0005\u007fk!Aa/\u000b\t\tu\u0016\u0011J\u0001\taJ|Go\\2pY&!!\u0011\u0019B^\u0005)\t\u0005/['fgN\fw-\u001a\u0005\b\u0005\u000b$\u0004\u0019\u0001Bd\u0003\u001d\u0019wN\u001c;fqR\u0004BA!3\u0003P6\u0011!1\u001a\u0006\u0005\u0005\u001b\fI%\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\u0011\tNa3\u0003\u001dI+\u0017/^3ti\u000e{g\u000e^3yi\"9!Q\u001b\u001bA\u0002\t]\u0017A\u00025fC\u0012,'\u000f\u0005\u0003\u0003J\ne\u0017\u0002\u0002Bn\u0005\u0017\u0014QBU3rk\u0016\u001cH\u000fS3bI\u0016\u0014\bb\u0002Bpi\u0001\u0007!qW\u0001\be\u0016\fX/Z:u\u0011\u001d\u0011\u0019\u000f\u000ea\u0001\u0005K\fQb\u0019:fCR,G\rV5nK6\u001b\bcA$\u0003h&\u0019!\u0011\u001e%\u0003\t1{gnZ\u0001\u0010EVLG\u000e\u001a*bMR\u001cE.[3oiR\u0011!\u0011Q\u0001\u0014EVLG\u000e\u001a(fi^|'o[\"iC:tW\r\u001c\u000b\u0003\u0005/\nQb\u0019:fCR,G)\u0019;b\t&\u0014H#\u0001)\u0002!\t,\u0018\u000e\u001c3NKR\fG-\u0019;b\u0019><GC\u0001B~!\r\u0019%Q`\u0005\u0004\u0005\u007fl$\u0001E&bM.\fW*\u001a;bI\u0006$\u0018\rT8h\u0003I\u0011W/\u001b7e\u001d\u0016$xo\u001c:l\u00072LWM\u001c;\u0015\u0005\r\u0015\u0001cB$\u0004\b\r-1qC\u0005\u0004\u0007\u0013A%A\u0002+va2,'\u0007\u0005\u0003\u0004\u000e\rMQBAB\b\u0015\u0011\u0019\t\"!\u0013\u0002\u000f9,Go^8sW&!1QCB\b\u00051a\u0015n\u001d;f]\u0016\u0014h*Y7f!\u0011\u0011)a!\u0007\n\t\rm!q\u0001\u0002\u000e\u001d\u0016$xo\u001c:l\u00072LWM\u001c;\u0002\u001d1,\u0017\rZ3s\u0003:$W\t]8dQV\u00111\u0011\u0005\t\u0005\u0003\u0017\u001c\u0019#\u0003\u0003\u0004&\u00055'A\u0004'fC\u0012,'/\u00118e\u000bB|7\r[\u0001\nm>$XM\u001d(pI\u0016$baa\u000b\u00044\ru\u0002#B$\u0002\b\u000e5\u0002\u0003BA$\u0007_IAa!\r\u0002J\t!aj\u001c3f\u0011\u001d\u0019)d\u000fa\u0001\u0007o\t!!\u001b3\u0011\u0007\u001d\u001bI$C\u0002\u0004<!\u00131!\u00138u\u0011\u001d\u0011\tk\u000fa\u0001\u0007\u0017\u0001")
public class KafkaRaftManager<T>
implements RaftManager<T>,
Logging {
    private final String clusterId;
    private final KafkaConfig config;
    private final Uuid metadataLogDirUuid;
    private final RecordSerde<T> recordSerde;
    private final TopicPartition topicPartition;
    private final Uuid topicId;
    private final Time time;
    private final Metrics metrics;
    private final CompletableFuture<java.util.Map<Integer, InetSocketAddress>> controllerQuorumVotersFuture;
    private final Collection<InetSocketAddress> bootstrapServers;
    private final Endpoints localListeners;
    private final ApiVersions apiVersions;
    private final QuorumConfig raftConfig;
    private final String threadNamePrefix;
    private final LogContext logContext;
    private final KafkaScheduler scheduler;
    private final File dataDir;
    private final Option<FileLock> dataDirLock;
    private final ReplicatedLog replicatedLog;
    private final KafkaNetworkChannel netChannel;
    private final SystemTimer expirationTimer;
    private final TimingWheelExpirationService expirationService;
    private final KafkaRaftClient<T> client;
    private final KafkaRaftClientDriver<T> clientDriver;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static void maybeDeleteMetadataLogDir(KafkaConfig kafkaConfig) {
        KafkaRaftManager$.MODULE$.maybeDeleteMetadataLogDir(kafkaConfig);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public CompletableFuture<java.util.Map<Integer, InetSocketAddress>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    public ApiVersions apiVersions() {
        return this.apiVersions;
    }

    private QuorumConfig raftConfig() {
        return this.raftConfig;
    }

    private String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private KafkaScheduler scheduler() {
        return this.scheduler;
    }

    private File dataDir() {
        return this.dataDir;
    }

    private Option<FileLock> dataDirLock() {
        return this.dataDirLock;
    }

    @Override
    public ReplicatedLog replicatedLog() {
        return this.replicatedLog;
    }

    private KafkaNetworkChannel netChannel() {
        return this.netChannel;
    }

    private SystemTimer expirationTimer() {
        return this.expirationTimer;
    }

    private TimingWheelExpirationService expirationService() {
        return this.expirationService;
    }

    @Override
    public KafkaRaftClient<T> client() {
        return this.client;
    }

    private KafkaRaftClientDriver<T> clientDriver() {
        return this.clientDriver;
    }

    public void startup() {
        this.client().initialize(this.controllerQuorumVotersFuture().get(), (QuorumStateStore)new FileQuorumStateStore(new File(this.dataDir(), "quorum-state")), this.metrics);
        this.netChannel().start();
        this.clientDriver().start();
    }

    public void shutdown() {
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.expirationService().shutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.expirationTimer().close(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.clientDriver().shutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.scheduler().shutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.netChannel().close(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.replicatedLog().close(), this, CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.dataDirLock().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.destroy();
            return BoxedUnit.UNIT;
        }), this, CoreUtils$.MODULE$.swallow$default$3());
    }

    @Override
    public void register(RaftClient.Listener<T> listener) {
        this.client().register(listener);
    }

    @Override
    public CompletableFuture<ApiMessage> handleRequest(RequestContext context, RequestHeader header, ApiMessage request, long createdTimeMs) {
        return this.clientDriver().handleRequest(context, header, request, createdTimeMs);
    }

    private KafkaRaftClient<T> buildRaftClient() {
        return new KafkaRaftClient(OptionalInt.of(this.config.nodeId()), this.metadataLogDirUuid, this.recordSerde, (NetworkChannel)this.netChannel(), this.replicatedLog(), this.time, (ExpirationService)this.expirationService(), this.logContext(), this.config.processRoles().contains((Object)ProcessRole.ControllerRole), this.clusterId, this.bootstrapServers, this.localListeners, Features.KRAFT_VERSION.supportedVersionRange(), this.raftConfig());
    }

    /*
     * WARNING - void declaration
     */
    private KafkaNetworkChannel buildNetworkChannel() {
        void var3_3;
        void var2_2;
        Tuple2<ListenerName, NetworkClient> tuple2 = this.buildNetworkClient();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        ListenerName listenerName = (ListenerName)tuple2._1();
        NetworkClient netClient = (NetworkClient)tuple2._2();
        void listenerName2 = var2_2;
        void netClient2 = var3_3;
        return new KafkaNetworkChannel(this.time, (ListenerName)listenerName2, (KafkaClient)netClient2, Predef$.MODULE$.Integer2int(this.config.quorumRequestTimeoutMs()), this.threadNamePrefix());
    }

    private File createDataDir() {
        String logDirName = UnifiedLog$.MODULE$.logDirName(this.topicPartition);
        return KafkaRaftManager$.MODULE$.kafka$raft$KafkaRaftManager$$createLogDirectory(new File(this.config.metadataLogDir()), logDirName);
    }

    private KafkaMetadataLog buildMetadataLog() {
        return KafkaMetadataLog$.MODULE$.apply(this.topicPartition, this.topicId, this.dataDir(), this.time, (Scheduler)this.scheduler(), MetadataLogConfig$.MODULE$.apply(this.config, 0x800000, 0x800000));
    }

    private Tuple2<ListenerName, NetworkClient> buildNetworkClient() {
        ListenerName controllerListenerName = new ListenerName((String)this.config.controllerListenerNames().head());
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)((SecurityProtocol)this.config.effectiveListenerSecurityProtocolMap().getOrElse((Object)controllerListenerName, (Function0 & Serializable & scala.Serializable)() -> SecurityProtocol.forName((String)controllerListenerName.value()))), (JaasContext.Type)JaasContext.Type.SERVER, (AbstractConfig)this.config, (ListenerName)controllerListenerName, (String)this.config.saslMechanismControllerProtocol(), (Time)this.time, (boolean)this.config.saslInterBrokerHandshakeRequestEnable(), (LogContext)this.logContext());
        String metricGroupPrefix = "raft-channel";
        boolean collectPerConnectionMetrics = false;
        Selector selector = new Selector(-1, Predef$.MODULE$.Long2long(this.config.connectionsMaxIdleMs()), this.metrics, this.time, metricGroupPrefix, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().empty()).asJava(), collectPerConnectionMetrics, channelBuilder, this.logContext());
        String clientId = new StringBuilder(12).append("raft-client-").append(this.config.nodeId()).toString();
        int maxInflightRequestsPerConnection = 1;
        int reconnectBackoffMs = 50;
        int reconnectBackoffMsMs = 500;
        boolean discoverBrokerVersions = true;
        NetworkClient networkClient = new NetworkClient((Selectable)selector, (MetadataUpdater)new ManualMetadataUpdater(), clientId, maxInflightRequestsPerConnection, (long)reconnectBackoffMs, (long)reconnectBackoffMsMs, -1, Predef$.MODULE$.Integer2int(this.config.socketReceiveBufferBytes()), Predef$.MODULE$.Integer2int(this.config.quorumRequestTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMaxMs()), this.time, discoverBrokerVersions, this.apiVersions(), this.logContext(), MetadataRecoveryStrategy.NONE);
        return new Tuple2((Object)controllerListenerName, (Object)networkClient);
    }

    @Override
    public LeaderAndEpoch leaderAndEpoch() {
        return this.client().leaderAndEpoch();
    }

    @Override
    public Option<Node> voterNode(int id, ListenerName listener) {
        return OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(this.client().voterNode(id, listener)));
    }

    public KafkaRaftManager(String clusterId, KafkaConfig config, Uuid metadataLogDirUuid, RecordSerde<T> recordSerde, TopicPartition topicPartition, Uuid topicId, Time time, Metrics metrics, Option<String> threadNamePrefixOpt, CompletableFuture<java.util.Map<Integer, InetSocketAddress>> controllerQuorumVotersFuture, Collection<InetSocketAddress> bootstrapServers, Endpoints localListeners, FaultHandler fatalFaultHandler) {
        this.clusterId = clusterId;
        this.config = config;
        this.metadataLogDirUuid = metadataLogDirUuid;
        this.recordSerde = recordSerde;
        this.topicPartition = topicPartition;
        this.topicId = topicId;
        this.time = time;
        this.metrics = metrics;
        this.controllerQuorumVotersFuture = controllerQuorumVotersFuture;
        this.bootstrapServers = bootstrapServers;
        this.localListeners = localListeners;
        Logging.$init$(this);
        this.apiVersions = new ApiVersions();
        this.raftConfig = new QuorumConfig((AbstractConfig)config);
        this.threadNamePrefix = (String)threadNamePrefixOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> "kafka-raft");
        this.logContext = new LogContext(new StringBuilder(18).append("[RaftManager id=").append(config.nodeId()).append("] ").toString());
        this.logIdent_$eq(this.logContext().logPrefix());
        this.scheduler = new KafkaScheduler(1, true, new StringBuilder(10).append(this.threadNamePrefix()).append("-scheduler").toString());
        this.scheduler().startup();
        this.dataDir = this.createDataDir();
        boolean differentMetadataLogDir = KafkaRaftManager$.MODULE$.kafka$raft$KafkaRaftManager$$hasDifferentLogDir(config);
        Set<ProcessRole> set = config.processRoles();
        GenTraversable genTraversable = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ProcessRole[]{ProcessRole.ControllerRole}));
        boolean isOnlyController = !(set != null ? !set.equals((Object)genTraversable) : genTraversable != null);
        this.dataDirLock = differentMetadataLogDir || isOnlyController ? new Some((Object)KafkaRaftManager$.MODULE$.kafka$raft$KafkaRaftManager$$lockDataDir(new File(config.metadataLogDir()))) : None$.MODULE$;
        this.replicatedLog = this.buildMetadataLog();
        this.netChannel = this.buildNetworkChannel();
        this.expirationTimer = new SystemTimer("raft-expiration-executor");
        this.expirationService = new TimingWheelExpirationService((Timer)this.expirationTimer());
        this.client = this.buildRaftClient();
        this.clientDriver = new KafkaRaftClientDriver(this.client(), this.threadNamePrefix(), fatalFaultHandler, this.logContext());
    }
}

