/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.List;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.log.LogManager;
import kafka.log.LogManager$;
import kafka.log.UnifiedLog;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.server.RequestLocal$;
import kafka.server.metadata.AclPublisher;
import kafka.server.metadata.BrokerMetadataPublisher$;
import kafka.server.metadata.DelegationTokenPublisher;
import kafka.server.metadata.DynamicClientQuotaPublisher;
import kafka.server.metadata.DynamicConfigPublisher;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.server.metadata.ScramPublisher;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.coordinator.group.GroupCoordinator;
import org.apache.kafka.image.LocalReplicaChanges;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicDelta;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsDelta;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.server.fault.FaultHandler;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\ter!\u0002\u0013&\u0011\u0003ac!\u0002\u0018&\u0011\u0003y\u0003\"\u0002\u001f\u0002\t\u0003i\u0004\"\u0002 \u0002\t\u0003yd\u0001\u0002\u0018&\u0001\u0015D\u0001\u0002\u001e\u0003\u0003\u0002\u0003\u0006I!\u001e\u0005\ts\u0012\u0011\t\u0011)A\u0005u\"AQ\u0010\u0002B\u0001B\u0003%a\u0010\u0003\u0006\u0002\n\u0011\u0011\t\u0011)A\u0005\u0003\u0017A!\"!\u0005\u0005\u0005\u0003\u0005\u000b\u0011BA\n\u0011)\t\u0019\u0003\u0002B\u0001B\u0003%\u0011Q\u0005\u0005\u000b\u0003g!!\u00111A\u0005\u0002\u0005U\u0002BCA\u001f\t\t\u0005\r\u0011\"\u0001\u0002@!Q\u00111\n\u0003\u0003\u0002\u0003\u0006K!a\u000e\t\u0015\u00055CA!A!\u0002\u0013\ty\u0005\u0003\u0006\u0002V\u0011\u0011\t\u0011)A\u0005\u0003/B!\"!\u0018\u0005\u0005\u0003\u0005\u000b\u0011BA0\u0011)\t)\u0007\u0002B\u0001B\u0003%\u0011q\r\u0005\u000b\u0003[\"!\u0011!Q\u0001\n\u0005=\u0004BCA?\t\t\u0005\t\u0015!\u0003\u0002p!1A\b\u0002C\u0001\u0003\u007fB\u0011\"!(\u0005\u0005\u0004%\t!a(\t\u0011\u0005\u001dF\u0001)A\u0005\u0003CC\u0011\"!+\u0005\u0001\u0004%\t!a+\t\u0013\u0005MF\u00011A\u0005\u0002\u0005U\u0006\u0002CA]\t\u0001\u0006K!!,\t\u0013\u0005mFA1A\u0005\u0002\u0005u\u0006\u0002CAk\t\u0001\u0006I!a0\t\u000f\u0005]G\u0001\"\u0011\u0002Z\"9\u00111\u001c\u0003\u0005B\u0005u\u0007bBAz\t\u0011%\u0011Q\u001f\u0005\b\u0005\u000b!A\u0011\u0001B\u0004\u0011\u001d\u0011\u0019\u0002\u0002C\u0001\u0005+AqA!\f\u0005\t\u0013\u0011y\u0003C\u0004\u00034\u0011!IA!\u000e\t\u000f\t]B\u0001\"\u0011\u00036\u00059\"I]8lKJlU\r^1eCR\f\u0007+\u001e2mSNDWM\u001d\u0006\u0003M\u001d\n\u0001\"\\3uC\u0012\fG/\u0019\u0006\u0003Q%\naa]3sm\u0016\u0014(\"\u0001\u0016\u0002\u000b-\fgm[1\u0004\u0001A\u0011Q&A\u0007\u0002K\t9\"I]8lKJlU\r^1eCR\f\u0007+\u001e2mSNDWM]\n\u0004\u0003A2\u0004CA\u00195\u001b\u0005\u0011$\"A\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0012$AB!osJ+g\r\u0005\u00028u5\t\u0001H\u0003\u0002:S\u0005)Q\u000f^5mg&\u00111\b\u000f\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\tA&A\u0007hKR$v\u000e]5d\t\u0016dG/\u0019\u000b\u0005\u0001:[\u0006\rE\u00022\u0003\u000eK!A\u0011\u001a\u0003\r=\u0003H/[8o!\t!E*D\u0001F\u0015\t1u)A\u0003j[\u0006<WM\u0003\u0002+\u0011*\u0011\u0011JS\u0001\u0007CB\f7\r[3\u000b\u0003-\u000b1a\u001c:h\u0013\tiUI\u0001\u0006U_BL7\rR3mi\u0006DQaT\u0002A\u0002A\u000b\u0011\u0002^8qS\u000et\u0015-\\3\u0011\u0005ECfB\u0001*W!\t\u0019&'D\u0001U\u0015\t)6&\u0001\u0004=e>|GOP\u0005\u0003/J\na\u0001\u0015:fI\u00164\u0017BA-[\u0005\u0019\u0019FO]5oO*\u0011qK\r\u0005\u00069\u000e\u0001\r!X\u0001\t]\u0016<\u0018*\\1hKB\u0011AIX\u0005\u0003?\u0016\u0013Q\"T3uC\u0012\fG/Y%nC\u001e,\u0007\"B1\u0004\u0001\u0004\u0011\u0017!\u00023fYR\f\u0007C\u0001#d\u0013\t!WIA\u0007NKR\fG-\u0019;b\t\u0016dG/Y\n\u0005\t\u0019tg\u0007\u0005\u0002hY6\t\u0001N\u0003\u0002jU\u0006!A.\u00198h\u0015\u0005Y\u0017\u0001\u00026bm\u0006L!!\u001c5\u0003\r=\u0013'.Z2u!\ty'/D\u0001q\u0015\t\tX)A\u0005qk\nd\u0017n\u001d5fe&\u00111\u000f\u001d\u0002\u0012\u001b\u0016$\u0018\rZ1uCB+(\r\\5tQ\u0016\u0014\u0018AB2p]\u001aLw\r\u0005\u0002wo6\tq%\u0003\u0002yO\tY1*\u00194lC\u000e{gNZ5h\u00035iW\r^1eCR\f7)Y2iKB\u0011Qf_\u0005\u0003y\u0016\u0012!c\u0013*bMRlU\r^1eCR\f7)Y2iK\u0006QAn\\4NC:\fw-\u001a:\u0011\u0007}\f)!\u0004\u0002\u0002\u0002)\u0019\u00111A\u0015\u0002\u00071|w-\u0003\u0003\u0002\b\u0005\u0005!A\u0003'pO6\u000bg.Y4fe\u0006q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\bc\u0001<\u0002\u000e%\u0019\u0011qB\u0014\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\u0006\u0001rM]8va\u000e{wN\u001d3j]\u0006$xN\u001d\t\u0005\u0003+\ty\"\u0004\u0002\u0002\u0018)!\u0011\u0011DA\u000e\u0003\u00159'o\\;q\u0015\r\tibR\u0001\fG>|'\u000fZ5oCR|'/\u0003\u0003\u0002\"\u0005]!\u0001E$s_V\u00048i\\8sI&t\u0017\r^8s\u00039!\bP\\\"p_J$\u0017N\\1u_J\u0004B!a\n\u000205\u0011\u0011\u0011\u0006\u0006\u0005\u0003W\ti#A\u0006ue\u0006t7/Y2uS>t'bAA\u000fS%!\u0011\u0011GA\u0015\u0005Y!&/\u00198tC\u000e$\u0018n\u001c8D_>\u0014H-\u001b8bi>\u0014\u0018A\u00063z]\u0006l\u0017nY\"p]\u001aLw\rU;cY&\u001c\b.\u001a:\u0016\u0005\u0005]\u0002cA\u0017\u0002:%\u0019\u00111H\u0013\u0003-\u0011Kh.Y7jG\u000e{gNZ5h!V\u0014G.[:iKJ\f!\u0004Z=oC6L7mQ8oM&<\u0007+\u001e2mSNDWM]0%KF$B!!\u0011\u0002HA\u0019\u0011'a\u0011\n\u0007\u0005\u0015#G\u0001\u0003V]&$\b\"CA%\u0019\u0005\u0005\t\u0019AA\u001c\u0003\rAH%M\u0001\u0018Ift\u0017-\\5d\u0007>tg-[4Qk\nd\u0017n\u001d5fe\u0002\n1\u0004Z=oC6L7m\u00117jK:$\u0018+^8uCB+(\r\\5tQ\u0016\u0014\bcA\u0017\u0002R%\u0019\u00111K\u0013\u00037\u0011Kh.Y7jG\u000ec\u0017.\u001a8u#V|G/\u0019)vE2L7\u000f[3s\u00039\u00198M]1n!V\u0014G.[:iKJ\u00042!LA-\u0013\r\tY&\n\u0002\u000f'\u000e\u0014\u0018-\u001c)vE2L7\u000f[3s\u0003a!W\r\\3hCRLwN\u001c+pW\u0016t\u0007+\u001e2mSNDWM\u001d\t\u0004[\u0005\u0005\u0014bAA2K\tAB)\u001a7fO\u0006$\u0018n\u001c8U_.,g\u000eU;cY&\u001c\b.\u001a:\u0002\u0019\u0005\u001cG\u000eU;cY&\u001c\b.\u001a:\u0011\u00075\nI'C\u0002\u0002l\u0015\u0012A\"Q2m!V\u0014G.[:iKJ\f\u0011CZ1uC24\u0015-\u001e7u\u0011\u0006tG\r\\3s!\u0011\t\t(!\u001f\u000e\u0005\u0005M$\u0002BA;\u0003o\nQAZ1vYRT!\u0001K$\n\t\u0005m\u00141\u000f\u0002\r\r\u0006,H\u000e\u001e%b]\u0012dWM]\u0001\u001f[\u0016$\u0018\rZ1uCB+(\r\\5tQ&twMR1vYRD\u0015M\u001c3mKJ$B$!!\u0002\u0004\u0006\u0015\u0015qQAE\u0003\u0017\u000bi)a$\u0002\u0012\u0006M\u0015QSAL\u00033\u000bY\n\u0005\u0002.\t!)A\u000f\u0006a\u0001k\")\u0011\u0010\u0006a\u0001u\")Q\u0010\u0006a\u0001}\"9\u0011\u0011\u0002\u000bA\u0002\u0005-\u0001bBA\t)\u0001\u0007\u00111\u0003\u0005\b\u0003G!\u0002\u0019AA\u0013\u0011\u001d\t\u0019\u0004\u0006a\u0001\u0003oAq!!\u0014\u0015\u0001\u0004\ty\u0005C\u0004\u0002VQ\u0001\r!a\u0016\t\u000f\u0005uC\u00031\u0001\u0002`!9\u0011Q\r\u000bA\u0002\u0005\u001d\u0004bBA7)\u0001\u0007\u0011q\u000e\u0005\b\u0003{\"\u0002\u0019AA8\u0003!\u0011'o\\6fe&#WCAAQ!\r\t\u00141U\u0005\u0004\u0003K\u0013$aA%oi\u0006I!M]8lKJLE\rI\u0001\u000e?\u001aL'o\u001d;Qk\nd\u0017n\u001d5\u0016\u0005\u00055\u0006cA\u0019\u00020&\u0019\u0011\u0011\u0017\u001a\u0003\u000f\t{w\u000e\\3b]\u0006\trLZ5sgR\u0004VO\u00197jg\"|F%Z9\u0015\t\u0005\u0005\u0013q\u0017\u0005\n\u0003\u0013B\u0012\u0011!a\u0001\u0003[\u000bab\u00184jeN$\b+\u001e2mSND\u0007%\u0001\ngSJ\u001cH\u000fU;cY&\u001c\bNR;ukJ,WCAA`!\u0019\t\t-a3\u0002P6\u0011\u00111\u0019\u0006\u0005\u0003\u000b\f9-\u0001\u0006d_:\u001cWO\u001d:f]RT1!!3k\u0003\u0011)H/\u001b7\n\t\u00055\u00171\u0019\u0002\u0012\u0007>l\u0007\u000f\\3uC\ndWMR;ukJ,\u0007cA4\u0002R&\u0019\u00111\u001b5\u0003\tY{\u0017\u000eZ\u0001\u0014M&\u00148\u000f\u001e)vE2L7\u000f\u001b$viV\u0014X\rI\u0001\u0005]\u0006lW\rF\u0001Q\u0003Ayg.T3uC\u0012\fG/Y+qI\u0006$X\r\u0006\u0005\u0002B\u0005}\u0017\u0011]Ar\u0011\u0015\tW\u00041\u0001c\u0011\u0015aV\u00041\u0001^\u0011\u001d\t)/\ba\u0001\u0003O\f\u0001\"\\1oS\u001a,7\u000f\u001e\t\u0005\u0003S\fy/\u0004\u0002\u0002l*\u0019\u0011Q^#\u0002\r1|\u0017\rZ3s\u0013\u0011\t\t0a;\u0003\u001d1{\u0017\rZ3s\u001b\u0006t\u0017NZ3ti\u0006iAo\\(qi&|g.\u00197J]R$B!a>\u0002\u0000B!\u0011\u0011`A~\u001b\t\t9-\u0003\u0003\u0002~\u0006\u001d'aC(qi&|g.\u00197J]RDqA!\u0001\u001f\u0001\u0004\u0011\u0019!\u0001\u0004paRLwN\u001c\t\u0005c\u0005\u000b\t+A\u0013sK2|\u0017\rZ+qI\u0006$X\r\u001a$jY\u0016\u001cx+\u001b;i_V$8i\u001c8gS\u001e\u001c\u0005.\u00198hKR!\u0011\u0011\tB\u0005\u0011\u001d\u0011Ya\ba\u0001\u0005\u001b\tQ\u0001\u001d:paN\u0004B!!?\u0003\u0010%!!\u0011CAd\u0005)\u0001&o\u001c9feRLWm]\u0001\u0012kB$\u0017\r^3D_>\u0014H-\u001b8bi>\u0014H\u0003DA!\u0005/\u0011IBa\u0007\u0003\u001e\t\u001d\u0002\"\u0002$!\u0001\u0004i\u0006\"B1!\u0001\u0004\u0011\u0007\"B(!\u0001\u0004\u0001\u0006b\u0002B\u0010A\u0001\u0007!\u0011E\u0001\tK2,7\r^5p]BI\u0011Ga\t\u0002\"\u0006\u0005\u0016\u0011I\u0005\u0004\u0005K\u0011$!\u0003$v]\u000e$\u0018n\u001c83\u0011\u001d\u0011I\u0003\ta\u0001\u0005W\t1B]3tS\u001et\u0017\r^5p]BI\u0011Ga\t\u0002\"\n\r\u0011\u0011I\u0001\u0013S:LG/[1mSj,W*\u00198bO\u0016\u00148\u000f\u0006\u0003\u0002B\tE\u0002\"\u0002/\"\u0001\u0004i\u0016\u0001\t4j]&\u001c\b.\u00138ji&\fG.\u001b>j]\u001e\u0014V\r\u001d7jG\u0006l\u0015M\\1hKJ$\"!!\u0011\u0002\u000b\rdwn]3")
public class BrokerMetadataPublisher
implements MetadataPublisher,
Logging {
    private final KafkaConfig config;
    private final KRaftMetadataCache metadataCache;
    private final LogManager logManager;
    private final ReplicaManager replicaManager;
    private final GroupCoordinator groupCoordinator;
    private final TransactionCoordinator txnCoordinator;
    private DynamicConfigPublisher dynamicConfigPublisher;
    private final DynamicClientQuotaPublisher dynamicClientQuotaPublisher;
    private final ScramPublisher scramPublisher;
    private final DelegationTokenPublisher delegationTokenPublisher;
    private final AclPublisher aclPublisher;
    private final FaultHandler fatalFaultHandler;
    private final FaultHandler metadataPublishingFaultHandler;
    private final int brokerId;
    private boolean _firstPublish;
    private final CompletableFuture<Void> firstPublishFuture;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Option<TopicDelta> getTopicDelta(String string, MetadataImage metadataImage, MetadataDelta metadataDelta) {
        return BrokerMetadataPublisher$.MODULE$.getTopicDelta(string, metadataImage, metadataDelta);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public void onControllerChange(LeaderAndEpoch x$1) {
        super.onControllerChange(x$1);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public DynamicConfigPublisher dynamicConfigPublisher() {
        return this.dynamicConfigPublisher;
    }

    public void dynamicConfigPublisher_$eq(DynamicConfigPublisher x$1) {
        this.dynamicConfigPublisher = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public boolean _firstPublish() {
        return this._firstPublish;
    }

    public void _firstPublish_$eq(boolean x$1) {
        this._firstPublish = x$1;
    }

    public CompletableFuture<Void> firstPublishFuture() {
        return this.firstPublishFuture;
    }

    public String name() {
        return "BrokerMetadataPublisher";
    }

    public void onMetadataUpdate(MetadataDelta delta, MetadataImage newImage, LoaderManifest manifest) {
        OffsetAndEpoch highestOffsetAndEpoch = newImage.highestOffsetAndEpoch();
        String deltaName = this._firstPublish() ? new StringBuilder(28).append("initial MetadataDelta up to ").append(highestOffsetAndEpoch.offset()).toString() : new StringBuilder(20).append("MetadataDelta up to ").append(highestOffsetAndEpoch.offset()).toString();
        try {
            try {
                if (this.isTraceEnabled()) {
                    this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Publishing delta ").append(delta).append(" with highest offset ").append(highestOffsetAndEpoch).toString());
                }
                this.metadataCache.setImage(newImage);
                String metadataVersionLogMsg = new StringBuilder(17).append("metadata.version ").append(newImage.features().metadataVersion()).toString();
                if (this._firstPublish()) {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Publishing initial metadata at offset ").append(highestOffsetAndEpoch).append(" with ").append(metadataVersionLogMsg).append(".").toString());
                    this.initializeManagers(newImage);
                } else if (this.isDebugEnabled()) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Publishing metadata at offset ").append(highestOffsetAndEpoch).append(" with ").append(metadataVersionLogMsg).append(".").toString());
                }
                Option$.MODULE$.apply((Object)delta.topicsDelta()).foreach((Function1 & Serializable & scala.Serializable)topicsDelta -> {
                    RuntimeException runtimeException;
                    try {
                        $this.replicaManager.applyDelta((TopicsDelta)topicsDelta, newImage);
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(31).append("Error applying topics ").append("delta in ").append(deltaName).toString(), t);
                    }
                    try {
                        this.updateCoordinator(newImage, delta, "__consumer_offsets", (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(x$1, x$2) -> $this.groupCoordinator.onElection(x$1, x$2), (Function2<Object, Option<Object>, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(partitionIndex, leaderEpochOpt) -> {
                            this.groupCoordinator.onResignation(BoxesRunTime.unboxToInt((Object)partitionIndex), this.toOptionalInt((Option<Object>)leaderEpochOpt));
                            return BoxedUnit.UNIT;
                        });
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(55).append("Error updating group ").append("coordinator with local changes in ").append(deltaName).toString(), t);
                    }
                    try {
                        this.updateCoordinator(newImage, delta, "__transaction_state", (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(txnTopicPartitionId, coordinatorEpoch) -> $this.txnCoordinator.onElection(txnTopicPartitionId, coordinatorEpoch), (Function2<Object, Option<Object>, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(txnTopicPartitionId, coordinatorEpoch) -> {
                            this.txnCoordinator.onResignation(BoxesRunTime.unboxToInt((Object)txnTopicPartitionId), (Option<Object>)coordinatorEpoch);
                            return BoxedUnit.UNIT;
                        });
                    }
                    catch (Throwable t) {
                        $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(53).append("Error updating txn ").append("coordinator with local changes in ").append(deltaName).toString(), t);
                    }
                    try {
                        ArrayBuffer deletedTopicPartitions = new ArrayBuffer();
                        topicsDelta.deletedTopicIds().forEach(id2 -> {
                            TopicImage topicImage = topicsDelta.image().getTopic(id2);
                            topicImage.partitions().keySet().forEach(id -> deletedTopicPartitions.$plus$eq((Object)new TopicPartition(topicImage.name(), Predef$.MODULE$.Integer2int(id))));
                        });
                        if (!deletedTopicPartitions.nonEmpty()) {
                            return BoxedUnit.UNIT;
                        }
                        $this.groupCoordinator.onPartitionsDeleted((List)CollectionConverters$.MODULE$.bufferAsJavaListConverter((Buffer)deletedTopicPartitions).asJava(), RequestLocal$.MODULE$.NoCaching().bufferSupplier());
                        runtimeException = BoxedUnit.UNIT;
                    }
                    catch (Throwable t) {
                        runtimeException = $this.metadataPublishingFaultHandler.handleFault(new StringBuilder(60).append("Error updating group ").append("coordinator with deleted partitions in ").append(deltaName).toString(), t);
                    }
                    return runtimeException;
                });
                this.dynamicConfigPublisher().onMetadataUpdate(delta, newImage);
                this.dynamicClientQuotaPublisher.onMetadataUpdate(delta, newImage);
                this.scramPublisher.onMetadataUpdate(delta, newImage);
                this.delegationTokenPublisher.onMetadataUpdate(delta, newImage);
                this.aclPublisher.onMetadataUpdate(delta, newImage, manifest);
                try {
                    this.groupCoordinator.onNewMetadataImage(newImage, delta);
                }
                catch (Throwable t) {
                    this.metadataPublishingFaultHandler.handleFault(new StringBuilder(55).append("Error updating group ").append("coordinator with local changes in ").append(deltaName).toString(), t);
                }
                if (this._firstPublish()) {
                    this.finishInitializingReplicaManager();
                }
            }
            catch (Throwable t) {
                this.metadataPublishingFaultHandler.handleFault(new StringBuilder(57).append("Uncaught exception while ").append("publishing broker metadata from ").append(deltaName).toString(), t);
            }
        }
        finally {
            this._firstPublish_$eq(false);
            this.firstPublishFuture().complete(null);
        }
    }

    private OptionalInt toOptionalInt(Option<Object> option) {
        if (option instanceof Some) {
            return OptionalInt.of(BoxesRunTime.unboxToInt((Object)((Some)option).value()));
        }
        if (None$.MODULE$.equals(option)) {
            return OptionalInt.empty();
        }
        throw new MatchError(option);
    }

    public void reloadUpdatedFilesWithoutConfigChange(Properties props) {
        this.config.dynamicConfig().reloadUpdatedFilesWithoutConfigChange(props);
    }

    public void updateCoordinator(MetadataImage image, MetadataDelta delta, String topicName, Function2<Object, Object, BoxedUnit> election, Function2<Object, Option<Object>, BoxedUnit> resignation) {
        Option$.MODULE$.apply((Object)delta.topicsDelta()).foreach((Function1 & Serializable & scala.Serializable)topicsDelta -> {
            if (topicsDelta.topicWasDeleted(topicName)) {
                topicsDelta.image().getTopic(topicName).partitions().entrySet().forEach(entry -> {
                    if (((PartitionRegistration)entry.getValue()).leader == this.brokerId()) {
                        resignation.apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int((Integer)entry.getKey())), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)((PartitionRegistration)entry.getValue()).leaderEpoch)));
                        return;
                    }
                });
            }
            return BoxedUnit.UNIT;
        });
        BrokerMetadataPublisher$.MODULE$.getTopicDelta(topicName, image, delta).foreach((Function1 & Serializable & scala.Serializable)topicDelta -> {
            LocalReplicaChanges $anonfun$updateCoordinator$3_changes = topicDelta.localChanges(this.brokerId());
            $anonfun$updateCoordinator$3_changes.deletes().forEach(topicPartition -> resignation.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()), (Object)None$.MODULE$));
            $anonfun$updateCoordinator$3_changes.electedLeaders().forEach((topicPartition, partitionInfo) -> election.apply$mcVII$sp(topicPartition.partition(), partitionInfo.partition().leaderEpoch));
            $anonfun$updateCoordinator$3_changes.followers().forEach((topicPartition, partitionInfo) -> resignation.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)partitionInfo.partition().leaderEpoch))));
            return BoxedUnit.UNIT;
        });
    }

    private void initializeManagers(MetadataImage newImage) {
        try {
            this.logManager.startup(this.metadataCache.getAllTopics(), (Function1<UnifiedLog, Object>)(Function1 & Serializable & scala.Serializable)log -> BoxesRunTime.boxToBoolean((boolean)LogManager$.MODULE$.isStrayKraftReplica(this.brokerId(), newImage.topics(), log)));
            this.logManager.recoverAbandonedFutureLogs(this.brokerId(), newImage.topics());
            Option$.MODULE$.apply((Object)this.logManager.cleaner()).foreach((Function1 & Serializable & scala.Serializable)reconfigurable -> {
                BrokerMetadataPublisher.$anonfun$initializeManagers$2(this, reconfigurable);
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting LogManager", t);
        }
        try {
            this.replicaManager.startup();
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting ReplicaManager", t);
        }
        try {
            this.groupCoordinator.startup(() -> BoxesRunTime.unboxToInt((Object)$this.metadataCache.numPartitions("__consumer_offsets").getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> $this.config.groupCoordinatorConfig().offsetsTopicPartitions())));
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting GroupCoordinator", t);
        }
        try {
            this.txnCoordinator.startup((Function0<Object>)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)$this.metadataCache.numPartitions("__transaction_state").getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Predef$.MODULE$.Integer2int($this.config.transactionTopicPartitions()))), this.txnCoordinator.startup$default$2());
            return;
        }
        catch (Throwable t) {
            this.fatalFaultHandler.handleFault("Error starting TransactionCoordinator", t);
            return;
        }
    }

    private void finishInitializingReplicaManager() {
        try {
            this.replicaManager.startHighWatermarkCheckPointThread();
            return;
        }
        catch (Throwable t) {
            this.metadataPublishingFaultHandler.handleFault("Error starting high watermark checkpoint thread during startup", t);
            return;
        }
    }

    public void close() {
        this.firstPublishFuture().completeExceptionally((Throwable)new TimeoutException());
    }

    public static final /* synthetic */ void $anonfun$updateCoordinator$1(BrokerMetadataPublisher $this, String topicName$1, Function2 resignation$1, TopicsDelta topicsDelta) {
        if (topicsDelta.topicWasDeleted(topicName$1)) {
            topicsDelta.image().getTopic(topicName$1).partitions().entrySet().forEach(entry -> {
                if (((PartitionRegistration)entry.getValue()).leader == this.brokerId()) {
                    resignation.apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int((Integer)entry.getKey())), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)((PartitionRegistration)entry.getValue()).leaderEpoch)));
                    return;
                }
            });
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$updateCoordinator$3(BrokerMetadataPublisher $this, Function2 resignation$1, Function2 election$1, TopicDelta topicDelta) {
        LocalReplicaChanges changes = topicDelta.localChanges($this.brokerId());
        changes.deletes().forEach(topicPartition -> resignation.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()), (Object)None$.MODULE$));
        changes.electedLeaders().forEach((topicPartition, partitionInfo) -> election.apply$mcVII$sp(topicPartition.partition(), partitionInfo.partition().leaderEpoch));
        changes.followers().forEach((topicPartition, partitionInfo) -> resignation.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)partitionInfo.partition().leaderEpoch))));
    }

    public static final /* synthetic */ void $anonfun$initializeManagers$2(BrokerMetadataPublisher $this, BrokerReconfigurable reconfigurable) {
        $this.config.dynamicConfig().addBrokerReconfigurable(reconfigurable);
    }

    public BrokerMetadataPublisher(KafkaConfig config, KRaftMetadataCache metadataCache, LogManager logManager, ReplicaManager replicaManager, GroupCoordinator groupCoordinator, TransactionCoordinator txnCoordinator, DynamicConfigPublisher dynamicConfigPublisher, DynamicClientQuotaPublisher dynamicClientQuotaPublisher, ScramPublisher scramPublisher, DelegationTokenPublisher delegationTokenPublisher, AclPublisher aclPublisher, FaultHandler fatalFaultHandler, FaultHandler metadataPublishingFaultHandler) {
        this.config = config;
        this.metadataCache = metadataCache;
        this.logManager = logManager;
        this.replicaManager = replicaManager;
        this.groupCoordinator = groupCoordinator;
        this.txnCoordinator = txnCoordinator;
        this.dynamicConfigPublisher = dynamicConfigPublisher;
        this.dynamicClientQuotaPublisher = dynamicClientQuotaPublisher;
        this.scramPublisher = scramPublisher;
        this.delegationTokenPublisher = delegationTokenPublisher;
        this.aclPublisher = aclPublisher;
        this.fatalFaultHandler = fatalFaultHandler;
        this.metadataPublishingFaultHandler = metadataPublishingFaultHandler;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(30).append("[BrokerMetadataPublisher id=").append(config.nodeId()).append("] ").toString());
        this.brokerId = config.nodeId();
        this._firstPublish = true;
        this.firstPublishFuture = new CompletableFuture();
    }
}

