/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import kafka.log.AbstractIndex;
import kafka.log.CorruptIndexException;
import kafka.log.IndexSearchType$;
import kafka.log.TimeIndex$;
import kafka.log.TimestampOffset;
import kafka.utils.CoreUtils$;
import org.apache.kafka.common.errors.InvalidOffsetException;
import scala.Function0;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Me\u0001B\u0012%\u0001%B\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\n{\u0001\u0011\t\u0011)A\u0005]yB\u0011b\u0010\u0001\u0003\u0002\u0003\u0006I\u0001Q\"\t\u0013\u0011\u0003!\u0011!Q\u0001\n\u0015C\u0005\"B%\u0001\t\u0003Q\u0005b\u0002)\u0001\u0001\u0004%I!\u0015\u0005\b+\u0002\u0001\r\u0011\"\u0003W\u0011\u0019a\u0006\u0001)Q\u0005%\")\u0011\r\u0001C!E\")1\r\u0001C!I\")Q\r\u0001C\u0005M\")\u0011\u000f\u0001C\u0005e\")Q\u000f\u0001C\u0001#\")a\u000f\u0001C\u0005#\")q\u000f\u0001C\u0001q\")!\u0010\u0001C!w\")a\u0010\u0001C\u0001\u007f\"I\u00111\u0002\u0001\u0012\u0002\u0013\u0005\u0011Q\u0002\u0005\b\u0003G\u0001A\u0011AA\u0013\u0011\u001d\tY\u0003\u0001C!\u0003[Aq!a\f\u0001\t\u0003\n\t\u0004C\u0004\u00026\u0001!\t%a\u000e\t\u000f\u0005u\u0002\u0001\"\u0003\u0002@!9\u0011Q\t\u0001\u0005B\u00055\u0002\u0002DA$\u0001A\u0005\u0019\u0011!A\u0005\n\t\u001c\u0005\"DA%\u0001A\u0005\u0019\u0011!A\u0005\n\u0005-c\b\u0003\b\u0002N\u0001\u0001\n1!A\u0001\n\u0013\ty%a\u0015\b\u000f\u0005UC\u0005#\u0001\u0002X\u001911\u0005\nE\u0001\u00033Ba!S\u000f\u0005\u0002\u00055\u0004\"CA8;\t\u0007I\u0011IA9\u0011!\tI)\bQ\u0001\n\u0005M\u0004\"CAF;E\u0005I\u0011AAG\u0011%\t\t*HI\u0001\n\u0003\tiAA\u0005US6,\u0017J\u001c3fq*\u0011QEJ\u0001\u0004Y><'\"A\u0014\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\u000b\t\u0005W1rc&D\u0001%\u0013\tiCEA\u0007BEN$(/Y2u\u0013:$W\r\u001f\t\u0003_Ij\u0011\u0001\r\u0006\u0002c\u0005)1oY1mC&\u00111\u0007\r\u0002\u0005\u0019>tw-A\u0003`M&dW\r\u0005\u00027w5\tqG\u0003\u00029s\u0005\u0011\u0011n\u001c\u0006\u0002u\u0005!!.\u0019<b\u0013\tatG\u0001\u0003GS2,\u0017A\u00032bg\u0016|eMZ:fi&\u0011Q\bL\u0001\r[\u0006D\u0018J\u001c3fqNK'0\u001a\t\u0003_\u0005K!A\u0011\u0019\u0003\u0007%sG/\u0003\u0002@Y\u0005AqO]5uC\ndW\r\u0005\u00020\r&\u0011q\t\r\u0002\b\u0005>|G.Z1o\u0013\t!E&\u0001\u0004=S:LGO\u0010\u000b\u0006\u00172kej\u0014\t\u0003W\u0001AQ\u0001N\u0003A\u0002UBQ!P\u0003A\u00029BqaP\u0003\u0011\u0002\u0003\u0007\u0001\tC\u0004E\u000bA\u0005\t\u0019A#\u0002\u0015}c\u0017m\u001d;F]R\u0014\u00180F\u0001S!\tY3+\u0003\u0002UI\tyA+[7fgR\fW\u000e](gMN,G/\u0001\b`Y\u0006\u001cH/\u00128uef|F%Z9\u0015\u0005]S\u0006CA\u0018Y\u0013\tI\u0006G\u0001\u0003V]&$\bbB.\b\u0003\u0003\u0005\rAU\u0001\u0004q\u0012\n\u0014aC0mCN$XI\u001c;ss\u0002B#\u0001\u00030\u0011\u0005=z\u0016B\u000111\u0005!1x\u000e\\1uS2,\u0017!C3oiJL8+\u001b>f+\u0005\u0001\u0015AB5t\rVdG.F\u0001F\u0003%!\u0018.\\3ti\u0006l\u0007\u000fF\u0002/O>DQ\u0001[\u0006A\u0002%\faAY;gM\u0016\u0014\bC\u00016n\u001b\u0005Y'B\u00017:\u0003\rq\u0017n\\\u0005\u0003].\u0014!BQ=uK\n+hMZ3s\u0011\u0015\u00018\u00021\u0001A\u0003\u0005q\u0017A\u0004:fY\u0006$\u0018N^3PM\u001a\u001cX\r\u001e\u000b\u0004\u0001N$\b\"\u00025\r\u0001\u0004I\u0007\"\u00029\r\u0001\u0004\u0001\u0015!\u00037bgR,e\u000e\u001e:z\u0003Ya\u0017m\u001d;F]R\u0014\u0018P\u0012:p[&sG-\u001a=GS2,\u0017!B3oiJLHC\u0001*z\u0011\u0015\u0001x\u00021\u0001A\u0003)\u0001\u0018M]:f\u000b:$(/\u001f\u000b\u0004%rl\b\"\u00025\u0011\u0001\u0004I\u0007\"\u00029\u0011\u0001\u0004\u0001\u0015aC7bs\n,\u0017\t\u001d9f]\u0012$raVA\u0001\u0003\u0007\t9\u0001C\u0003f#\u0001\u0007a\u0006\u0003\u0004\u0002\u0006E\u0001\rAL\u0001\u0007_\u001a47/\u001a;\t\u0011\u0005%\u0011\u0003%AA\u0002\u0015\u000bQb]6ja\u001a+H\u000e\\\"iK\u000e\\\u0017!F7bs\n,\u0017\t\u001d9f]\u0012$C-\u001a4bk2$HeM\u000b\u0003\u0003\u001fQ3!RA\tW\t\t\u0019\u0002\u0005\u0003\u0002\u0016\u0005}QBAA\f\u0015\u0011\tI\"a\u0007\u0002\u0013Ut7\r[3dW\u0016$'bAA\u000fa\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0005\u0012q\u0003\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017A\u00027p_.,\b\u000fF\u0002S\u0003OAa!!\u000b\u0014\u0001\u0004q\u0013a\u0004;be\u001e,G\u000fV5nKN$\u0018-\u001c9\u0002\u0011Q\u0014XO\\2bi\u0016$\u0012aV\u0001\u000biJ,hnY1uKR{GcA,\u00024!1\u0011QA\u000bA\u00029\naA]3tSj,GcA#\u0002:!1\u00111\b\fA\u0002\u0001\u000bqA\\3x'&TX-A\tueVt7-\u0019;f)>,e\u000e\u001e:jKN$2aVA!\u0011\u0019\t\u0019e\u0006a\u0001\u0001\u00069QM\u001c;sS\u0016\u001c\u0018aC:b]&$\u0018p\u00115fG.\f!c];qKJ$S.\u0019=J]\u0012,\u0007pU5{K\u0006\u00012/\u001e9fe\u0012\u0012\u0017m]3PM\u001a\u001cX\r^\u000b\u0002]\u0005a1/\u001e9fe\u0012\u0012Xm]5{KR\u0019Q)!\u0015\t\r\u0005m2\u00041\u0001A\u0013\r\t)\u0004L\u0001\n)&lW-\u00138eKb\u0004\"aK\u000f\u0014\u000bu\tY&!\u0019\u0011\u0007=\ni&C\u0002\u0002`A\u0012a!\u00118z%\u00164\u0007\u0003BA2\u0003Sj!!!\u001a\u000b\u0007\u0005\u001dd%A\u0003vi&d7/\u0003\u0003\u0002l\u0005\u0015$a\u0002'pO\u001eLgn\u001a\u000b\u0003\u0003/\n!\u0002\\8hO\u0016\u0014h*Y7f+\t\t\u0019\b\u0005\u0003\u0002v\u0005\re\u0002BA<\u0003\u007f\u00022!!\u001f1\u001b\t\tYHC\u0002\u0002~!\na\u0001\u0010:p_Rt\u0014bAAAa\u00051\u0001K]3eK\u001aLA!!\"\u0002\b\n11\u000b\u001e:j]\u001eT1!!!1\u0003-awnZ4fe:\u000bW.\u001a\u0011\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\tyIK\u0002A\u0003#\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"\u0004")
public class TimeIndex
extends AbstractIndex<Object, Object> {
    private volatile TimestampOffset _lastEntry = this.lastEntryFromIndexFile();

    public static boolean $lessinit$greater$default$4() {
        return TimeIndex$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return TimeIndex$.MODULE$.$lessinit$greater$default$3();
    }

    public static String loggerName() {
        return TimeIndex$.MODULE$.loggerName();
    }

    public static void fatal(Function0<String> function0, Function0<Throwable> function02) {
        TimeIndex$.MODULE$.fatal(function0, function02);
    }

    public static void fatal(Function0<String> function0) {
        TimeIndex$.MODULE$.fatal(function0);
    }

    public static void error(Function0<String> function0, Function0<Throwable> function02) {
        TimeIndex$.MODULE$.error(function0, function02);
    }

    public static void error(Function0<String> function0) {
        TimeIndex$.MODULE$.error(function0);
    }

    public static void warn(Function0<String> function0, Function0<Throwable> function02) {
        TimeIndex$.MODULE$.warn(function0, function02);
    }

    public static void warn(Function0<String> function0) {
        TimeIndex$.MODULE$.warn(function0);
    }

    public static void info(Function0<String> function0, Function0<Throwable> function02) {
        TimeIndex$.MODULE$.info(function0, function02);
    }

    public static void info(Function0<String> function0) {
        TimeIndex$.MODULE$.info(function0);
    }

    public static void debug(Function0<String> function0, Function0<Throwable> function02) {
        TimeIndex$.MODULE$.debug(function0, function02);
    }

    public static void debug(Function0<String> function0) {
        TimeIndex$.MODULE$.debug(function0);
    }

    public static boolean isTraceEnabled() {
        return TimeIndex$.MODULE$.isTraceEnabled();
    }

    public static boolean isDebugEnabled() {
        return TimeIndex$.MODULE$.isDebugEnabled();
    }

    public static void trace(Function0<String> function0, Function0<Throwable> function02) {
        TimeIndex$.MODULE$.trace(function0, function02);
    }

    public static void trace(Function0<String> function0) {
        TimeIndex$.MODULE$.trace(function0);
    }

    private /* synthetic */ int super$maxIndexSize() {
        return super.maxIndexSize();
    }

    private /* synthetic */ long super$baseOffset() {
        return super.baseOffset();
    }

    private /* synthetic */ boolean super$resize(int newSize) {
        return super.resize(newSize);
    }

    private TimestampOffset _lastEntry() {
        return this._lastEntry;
    }

    private void _lastEntry_$eq(TimestampOffset x$1) {
        this._lastEntry = x$1;
    }

    @Override
    public int entrySize() {
        return 12;
    }

    @Override
    public boolean isFull() {
        return this.entries() >= this.maxEntries() - 1;
    }

    private long timestamp(ByteBuffer buffer, int n) {
        return buffer.getLong(n * this.entrySize());
    }

    private int relativeOffset(ByteBuffer buffer, int n) {
        return buffer.getInt(n * this.entrySize() + 8);
    }

    public TimestampOffset lastEntry() {
        return this._lastEntry();
    }

    private TimestampOffset lastEntryFromIndexFile() {
        return (TimestampOffset)CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            TimestampOffset timestampOffset;
            int n = this._entries();
            switch (n) {
                case 0: {
                    timestampOffset = new TimestampOffset(-1L, this.super$baseOffset());
                    break;
                }
                default: {
                    timestampOffset = this.parseEntry(this.mmap(), n - 1);
                    break;
                }
            }
            return timestampOffset;
        });
    }

    public TimestampOffset entry(int n) {
        return (TimestampOffset)this.maybeLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            if (n >= this._entries()) {
                throw new IllegalArgumentException(new StringBuilder(48).append("Attempt to fetch the ").append(n).append("th entry from  time index ").append(this.file().getAbsolutePath()).append(" ").append(new StringBuilder(16).append("which has size ").append(this._entries()).append(".").toString()).toString());
            }
            return this.parseEntry(this.mmap(), n);
        });
    }

    @Override
    public TimestampOffset parseEntry(ByteBuffer buffer, int n) {
        return new TimestampOffset(this.timestamp(buffer, n), super.baseOffset() + (long)this.relativeOffset(buffer, n));
    }

    public void maybeAppend(long timestamp, long offset, boolean skipFullCheck) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block3: {
                if (!skipFullCheck) {
                    Predef$.MODULE$.require(!this.isFull(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Attempt to append to a full time index (size = ").append(this._entries()).append(").").toString());
                }
                if (this._entries() != 0 && offset < this.lastEntry().offset()) {
                    throw new InvalidOffsetException(new StringBuilder(54).append("Attempt to append an offset (").append(offset).append(") to slot ").append(this._entries()).append(" no larger than").append(new StringBuilder(33).append(" the last offset appended (").append(this.lastEntry().offset()).append(") to ").append(this.file().getAbsolutePath()).append(".").toString()).toString());
                }
                if (this._entries() != 0 && timestamp < this.lastEntry().timestamp()) {
                    throw new IllegalStateException(new StringBuilder(51).append("Attempt to append a timestamp (").append(timestamp).append(") to slot ").append(this._entries()).append(" no larger").append(new StringBuilder(41).append(" than the last timestamp appended (").append(this.lastEntry().timestamp()).append(") to ").append(this.file().getAbsolutePath()).append(".").toString()).toString());
                }
                if (timestamp <= this.lastEntry().timestamp()) break block3;
                TimeIndex$.MODULE$.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Adding index entry ").append(timestamp).append(" => ").append(offset).append(" to ").append(this.file().getAbsolutePath()).append(".").toString());
                this.mmap().putLong(timestamp);
                this.mmap().putInt(this.relativeOffset(offset));
                this._entries_$eq(this._entries() + 1);
                this._lastEntry_$eq(new TimestampOffset(timestamp, offset));
                Predef$.MODULE$.require(this._entries() * this.entrySize() == this.mmap().position(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append(this._entries()).append(" entries but file position in index is ").append(this.mmap().position()).append(".").toString());
            }
        });
    }

    public boolean maybeAppend$default$3() {
        return false;
    }

    public TimestampOffset lookup(long targetTimestamp) {
        return (TimestampOffset)this.maybeLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            ByteBuffer idx = this.mmap().duplicate();
            int slot = this.largestLowerBoundSlotFor(idx, targetTimestamp, IndexSearchType$.MODULE$.KEY());
            return slot == -1 ? new TimestampOffset(-1L, this.super$baseOffset()) : this.parseEntry(idx, slot);
        });
    }

    @Override
    public void truncate() {
        this.truncateToEntries(0);
    }

    @Override
    public void truncateTo(long offset) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            ByteBuffer idx = this.mmap().duplicate();
            int slot = this.largestLowerBoundSlotFor(idx, offset, IndexSearchType$.MODULE$.VALUE());
            int newEntries = slot < 0 ? 0 : ((long)this.relativeOffset(idx, slot) == offset - this.super$baseOffset() ? slot : slot + 1);
            this.truncateToEntries(newEntries);
        });
    }

    @Override
    public boolean resize(int newSize) {
        return BoxesRunTime.unboxToBoolean(CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            boolean bl;
            if (this.super$resize(newSize)) {
                this._lastEntry_$eq(this.lastEntryFromIndexFile());
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }));
    }

    private void truncateToEntries(int entries) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this._entries_$eq(entries);
            this.mmap().position(this._entries() * this.entrySize());
            this._lastEntry_$eq(this.lastEntryFromIndexFile());
            TimeIndex$.MODULE$.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Truncated index ").append(this.file().getAbsolutePath()).append(" to ").append(entries).append(" entries; position is now ").append(this.mmap().position()).append(" and last entry is now ").append(this._lastEntry()).toString());
        });
    }

    @Override
    public void sanityCheck() {
        long lastTimestamp = this.lastEntry().timestamp();
        long lastOffset = this.lastEntry().offset();
        if (this._entries() != 0 && lastTimestamp < this.timestamp(this.mmap(), 0)) {
            throw new CorruptIndexException(new StringBuilder(49).append("Corrupt time index found, time index file (").append(this.file().getAbsolutePath()).append(") has ").append(new StringBuilder(80).append("non-zero size but the last timestamp is ").append(lastTimestamp).append(" which is less than the first timestamp ").toString()).append(String.valueOf(BoxesRunTime.boxToLong((long)this.timestamp(this.mmap(), 0)))).toString());
        }
        if (this._entries() != 0 && lastOffset < super.baseOffset()) {
            throw new CorruptIndexException(new StringBuilder(49).append("Corrupt time index found, time index file (").append(this.file().getAbsolutePath()).append(") has ").append(new StringBuilder(74).append("non-zero size but the last offset is ").append(lastOffset).append(" which is less than the first offset ").append(super.baseOffset()).toString()).toString());
        }
        if (this.length() % (long)this.entrySize() != 0L) {
            throw new CorruptIndexException(new StringBuilder(42).append("Time index file ").append(this.file().getAbsolutePath()).append(" is corrupt, found ").append(this.length()).append(" bytes ").append(new StringBuilder(45).append("which is neither positive nor a multiple of ").append(this.entrySize()).append(".").toString()).toString());
        }
    }

    public TimeIndex(File _file, long baseOffset, int maxIndexSize, boolean writable) {
        super(_file, baseOffset, maxIndexSize, writable);
        TimeIndex$.MODULE$.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Loaded index file ").append(this.file().getAbsolutePath()).append(" with maxEntries = ").append(this.maxEntries()).append(", maxIndexSize = ").append(this.super$maxIndexSize()).append(",").append(new StringBuilder(44).append(" entries = ").append(this._entries()).append(", lastOffset = ").append(this._lastEntry()).append(", file position = ").append(this.mmap().position()).toString()).toString());
    }
}

