/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.api.IntegrationTestHarness;
import kafka.security.authorizer.AclEntry$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.clients.admin.DescribeTopicsOptions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.mutable.Buffer$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\u00055e!B\n\u0015\u0003\u0003I\u0002\"\u0002\u0013\u0001\t\u0003)\u0003\"B\u0014\u0001\t\u0003A\u0003\"B\u0018\u0001\t\u0003B\u0003\"\u0003\u0019\u0001\u0001\u0004\u0005\r\u0011\"\u00012\u0011%y\u0004\u00011AA\u0002\u0013\u0005\u0001\tC\u0005G\u0001\u0001\u0007\t\u0011)Q\u0005e!)q\t\u0001C\u0001\u0011\")a\u000b\u0001C!/\")A\f\u0001C!/\")\u0011\r\u0001C\u0001/\")a\r\u0001C\u0001/\")\u0001\u000e\u0001C\u0001S\")Q\u0010\u0001C!}\"9\u0011q\u0004\u0001\u0005\u0002\u0005\u0005\u0002bBA\u001e\u0001\u0011\u0005\u0011Q\b\u0005\b\u0003\u0017\u0002A\u0011AA'\u0011%\ty\u0007AI\u0001\n\u0003\t\t\bC\u0005\u0002\b\u0002\t\n\u0011\"\u0001\u0002\n\nA\")Y:f\u0003\u0012l\u0017N\\%oi\u0016<'/\u0019;j_:$Vm\u001d;\u000b\u0005U1\u0012aA1qS*\tq#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001Qb\u0004\u0005\u0002\u001c95\tA#\u0003\u0002\u001e)\t1\u0012J\u001c;fOJ\fG/[8o)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u0002 E5\t\u0001E\u0003\u0002\"-\u0005)Q\u000f^5mg&\u00111\u0005\t\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\ta\u0005\u0005\u0002\u001c\u0001\u0005Y!M]8lKJ\u001cu.\u001e8u+\u0005I\u0003C\u0001\u0016.\u001b\u0005Y#\"\u0001\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u00059Z#aA%oi\u0006YAn\\4ESJ\u001cu.\u001e8u\u0003\u0019\u0019G.[3oiV\t!\u0007\u0005\u00024{5\tAG\u0003\u00026m\u0005)\u0011\rZ7j]*\u0011q\u0007O\u0001\bG2LWM\u001c;t\u0015\t9\u0012H\u0003\u0002;w\u00051\u0011\r]1dQ\u0016T\u0011\u0001P\u0001\u0004_J<\u0017B\u0001 5\u0005\u0015\tE-\\5o\u0003)\u0019G.[3oi~#S-\u001d\u000b\u0003\u0003\u0012\u0003\"A\u000b\"\n\u0005\r[#\u0001B+oSRDq!R\u0003\u0002\u0002\u0003\u0007!'A\u0002yIE\nqa\u00197jK:$\b%A\u0007hY>\u0014\u0017\r\u001c+j[\u0016|W\u000f^\u000b\u0002\u0013B\u0011!jT\u0007\u0002\u0017*\u0011A*T\u0001\u0006eVdWm\u001d\u0006\u0003\u001dn\nQA[;oSRL!\u0001U&\u0003\u000fQKW.Z8vi\"\u0012qA\u0015\t\u0003'Rk\u0011!T\u0005\u0003+6\u0013AAU;mK\u0006)1/\u001a;VaR\t\u0011\t\u000b\u0002\t3B\u00111KW\u0005\u000376\u0013aAQ3g_J,\u0017\u0001\u0003;fCJ$un\u001e8)\u0005%q\u0006CA*`\u0013\t\u0001WJA\u0003BMR,'/\u0001\fuKN$8I]3bi\u0016$U\r\\3uKR{\u0007/[2tQ\tQ1\r\u0005\u0002TI&\u0011Q-\u0014\u0002\u0005)\u0016\u001cH/\u0001\ruKN$\u0018)\u001e;i_JL'0\u001a3Pa\u0016\u0014\u0018\r^5p]ND#aC2\u00029\r|gNZ5hkJ,Gm\u00117vgR,'\u000fU3s[&\u001c8/[8ogR\t!\u000eE\u0002leVt!\u0001\u001c9\u0011\u00055\\S\"\u00018\u000b\u0005=D\u0012A\u0002\u001fs_>$h(\u0003\u0002rW\u00051\u0001K]3eK\u001aL!a\u001d;\u0003\u0007M+GO\u0003\u0002rWA\u0011ao_\u0007\u0002o*\u0011\u00010_\u0001\u0004C\u000ed'B\u0001>9\u0003\u0019\u0019w.\\7p]&\u0011Ap\u001e\u0002\r\u0003\u000edw\n]3sCRLwN\\\u0001\u000e[>$\u0017NZ=D_:4\u0017nZ:\u0015\u0005\u0005{\bbBA\u0001\u001b\u0001\u0007\u00111A\u0001\bG>tg-[4t!\u0019\t)!a\u0003\u0002\u00105\u0011\u0011q\u0001\u0006\u0004\u0003\u0013Y\u0013AC2pY2,7\r^5p]&!\u0011QBA\u0004\u0005\r\u0019V-\u001d\t\u0005\u0003#\tY\"\u0004\u0002\u0002\u0014)!\u0011QCA\f\u0003\u0011)H/\u001b7\u000b\u0005\u0005e\u0011\u0001\u00026bm\u0006LA!!\b\u0002\u0014\tQ\u0001K]8qKJ$\u0018.Z:\u0002\u0019\r\u0014X-\u0019;f\u0007>tg-[4\u0015\u0005\u0005\r\u0002\u0003CA\t\u0003K\tI#a\f\n\t\u0005\u001d\u00121\u0003\u0002\u0004\u001b\u0006\u0004\bcA6\u0002,%\u0019\u0011Q\u0006;\u0003\rM#(/\u001b8h!\u0011\t\t$a\u000e\u000e\u0005\u0005M\"\u0002BA\u001b\u0003/\tA\u0001\\1oO&!\u0011\u0011HA\u001a\u0005\u0019y%M[3di\u0006iq/Y5u\r>\u0014Hk\u001c9jGN$r!QA \u0003\u0003\n9\u0005C\u00031\u001f\u0001\u0007!\u0007C\u0004\u0002D=\u0001\r!!\u0012\u0002\u001f\u0015D\b/Z2uK\u0012\u0004&/Z:f]R\u0004b!!\u0002\u0002\f\u0005%\u0002bBA%\u001f\u0001\u0007\u0011QI\u0001\u0010Kb\u0004Xm\u0019;fI6K7o]5oO\u0006\u0001r-\u001a;U_BL7-T3uC\u0012\fG/\u0019\u000b\u000b\u0003\u001f\n)&a\u0016\u0002\\\u0005\u0015\u0004cA\u001a\u0002R%\u0019\u00111\u000b\u001b\u0003!Q{\u0007/[2EKN\u001c'/\u001b9uS>t\u0007\"\u0002\u0019\u0011\u0001\u0004\u0011\u0004bBA-!\u0001\u0007\u0011\u0011F\u0001\u0006i>\u0004\u0018n\u0019\u0005\n\u0003;\u0002\u0002\u0013!a\u0001\u0003?\nq\u0002Z3tGJL'-Z(qi&|gn\u001d\t\u0004g\u0005\u0005\u0014bAA2i\t)B)Z:de&\u0014W\rV8qS\u000e\u001cx\n\u001d;j_:\u001c\b\"CA4!A\u0005\t\u0019AA5\u0003a)\u0007\u0010]3di\u0016$g*^7QCJ$\u0018\u000e^5p]N|\u0005\u000f\u001e\t\u0005U\u0005-\u0014&C\u0002\u0002n-\u0012aa\u00149uS>t\u0017AG4fiR{\u0007/[2NKR\fG-\u0019;bI\u0011,g-Y;mi\u0012\u001aTCAA:U\u0011\ty&!\u001e,\u0005\u0005]\u0004\u0003BA=\u0003\u0007k!!a\u001f\u000b\t\u0005u\u0014qP\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!!,\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u000b\u000bYHA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f!dZ3u)>\u0004\u0018nY'fi\u0006$\u0017\r^1%I\u00164\u0017-\u001e7uIQ*\"!a#+\t\u0005%\u0014Q\u000f")
public abstract class BaseAdminIntegrationTest
extends IntegrationTestHarness {
    private Admin client;

    @Override
    public int brokerCount() {
        return 3;
    }

    @Override
    public int logDirCount() {
        return 2;
    }

    public Admin client() {
        return this.client;
    }

    public void client_$eq(Admin x$1) {
        this.client = x$1;
    }

    @Rule
    public Timeout globalTimeout() {
        return Timeout.millis((long)120000L);
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated$default$2());
    }

    @Override
    @After
    public void tearDown() {
        if (this.client() != null) {
            Utils.closeQuietly((AutoCloseable)this.client(), (String)"AdminClient");
        }
        super.tearDown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateDeleteTopics() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        Seq topics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2", "mytopic3"}));
        NewTopic[] newTopicArray = new NewTopic[3];
        Tuple2[] tuple2Array = new Tuple2[2];
        Object object = JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))).asJava();
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.int2Integer(0));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        Object object3 = JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(0)}))).asJava();
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)Predef$.MODULE$.int2Integer(1));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        newTopicArray[0] = new NewTopic("mytopic", (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava());
        newTopicArray[1] = new NewTopic("mytopic2", 3, (short)3);
        newTopicArray[2] = new NewTopic("mytopic3", OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(Option$.MODULE$.empty())), OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(Option$.MODULE$.empty())));
        Seq newTopics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])newTopicArray));
        CreateTopicsResult validateResult = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava(), new CreateTopicsOptions().validateOnly(true));
        validateResult.all().get();
        this.waitForTopics(this.client(), (Seq<String>)Nil$.MODULE$, (Seq<String>)topics);
        this.validateMetadataAndConfigs$1(validateResult);
        CreateTopicsResult createResult = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava());
        createResult.all().get();
        this.waitForTopics(this.client(), (Seq<String>)topics, (Seq<String>)Nil$.MODULE$);
        this.validateMetadataAndConfigs$1(createResult);
        CreateTopicsResult failedCreateResult = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava());
        java.util.Map results = failedCreateResult.values();
        Assert.assertTrue((boolean)results.containsKey("mytopic"));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)results.get("mytopic"), TopicExistsException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        Assert.assertTrue((boolean)results.containsKey("mytopic2"));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)results.get("mytopic2"), TopicExistsException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        Assert.assertTrue((boolean)results.containsKey("mytopic3"));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)results.get("mytopic3"), TopicExistsException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(failedCreateResult.numPartitions("mytopic3"), TopicExistsException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(failedCreateResult.replicationFactor("mytopic3"), TopicExistsException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(failedCreateResult.config("mytopic3"), TopicExistsException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
        java.util.Map topicToDescription = (java.util.Map)this.client().describeTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topics).asJava()).all().get();
        Assert.assertEquals((Object)topics.toSet(), (Object)JavaConverters$.MODULE$.asScalaSetConverter(topicToDescription.keySet()).asScala());
        TopicDescription topic0 = (TopicDescription)topicToDescription.get("mytopic");
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)topic0.isInternal()));
        Assert.assertEquals((Object)"mytopic", (Object)topic0.name());
        Assert.assertEquals((long)2L, (long)topic0.partitions().size());
        TopicPartitionInfo topic0Partition0 = (TopicPartitionInfo)topic0.partitions().get(0);
        Assert.assertEquals((long)1L, (long)topic0Partition0.leader().id());
        Assert.assertEquals((long)0L, (long)topic0Partition0.partition());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topic0Partition0.isr()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id()), Buffer$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topic0Partition0.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()), Buffer$.MODULE$.canBuildFrom()));
        TopicPartitionInfo topic0Partition1 = (TopicPartitionInfo)topic0.partitions().get(1);
        Assert.assertEquals((long)2L, (long)topic0Partition1.leader().id());
        Assert.assertEquals((long)1L, (long)topic0Partition1.partition());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topic0Partition1.isr()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.id()), Buffer$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topic0Partition1.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id()), Buffer$.MODULE$.canBuildFrom()));
        TopicDescription topic1 = (TopicDescription)topicToDescription.get("mytopic2");
        Assert.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)topic1.isInternal()));
        Assert.assertEquals((Object)"mytopic2", (Object)topic1.name());
        Assert.assertEquals((long)3L, (long)topic1.partitions().size());
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, 3);
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                BaseAdminIntegrationTest.$anonfun$testCreateDeleteTopics$5(this, topic1, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        TopicDescription topic3 = (TopicDescription)topicToDescription.get("mytopic3");
        Assert.assertEquals((Object)"mytopic3", (Object)topic3.name());
        Assert.assertEquals((Object)((KafkaConfig)this.configs().head()).numPartitions(), (Object)BoxesRunTime.boxToInteger((int)topic3.partitions().size()));
        Assert.assertEquals((long)((KafkaConfig)this.configs().head()).defaultReplicationFactor(), (long)((TopicPartitionInfo)topic3.partitions().get(0)).replicas().size());
        this.client().deleteTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topics).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)Nil$.MODULE$, (Seq<String>)topics);
    }

    @Test
    public void testAuthorizedOperations() {
        this.client_$eq((Admin)AdminClient.create(this.createConfig()));
        DescribeClusterResult result = this.client().describeCluster();
        Assert.assertNull((Object)result.authorizedOperations().get());
        result = this.client().describeCluster(new DescribeClusterOptions().includeAuthorizedOperations(true));
        Assert.assertEquals((Object)((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter(this.configuredClusterPermissions()).asJava()), (Object)result.authorizedOperations().get());
        String topic = "mytopic";
        Seq newTopics = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic(topic, 3, (short)3)}));
        this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava()).all().get();
        this.waitForTopics(this.client(), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))), (Seq<String>)Nil$.MODULE$);
        TopicDescription topicResult = this.getTopicMetadata(this.client(), topic, this.getTopicMetadata$default$3(), this.getTopicMetadata$default$4());
        Assert.assertNull((Object)topicResult.authorizedOperations());
        topicResult = this.getTopicMetadata(this.client(), topic, new DescribeTopicsOptions().includeAuthorizedOperations(true), this.getTopicMetadata$default$4());
        Assert.assertEquals((Object)((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)AclEntry$.MODULE$.supportedOperations(ResourceType.TOPIC)).asJava()), (Object)topicResult.authorizedOperations());
    }

    public scala.collection.immutable.Set<AclOperation> configuredClusterPermissions() {
        return AclEntry$.MODULE$.supportedOperations(ResourceType.CLUSTER);
    }

    @Override
    public void modifyConfigs(Seq<Properties> configs) {
        super.modifyConfigs(configs);
        configs.foreach((Function1 & Serializable & scala.Serializable)config -> {
            config.setProperty(KafkaConfig$.MODULE$.DeleteTopicEnableProp(), "true");
            config.setProperty(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
            config.setProperty(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), "false");
            config.setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
            if (!config.containsKey(KafkaConfig$.MODULE$.SslTruststorePasswordProp())) {
                return config.setProperty(KafkaConfig$.MODULE$.SslTruststorePasswordProp(), "some.invalid.pass");
            }
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public java.util.Map<String, Object> createConfig() {
        void var1_1;
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("bootstrap.servers", this.brokerList());
        config.put("request.timeout.ms", "20000");
        Properties securityProps = TestUtils$.MODULE$.adminClientSecurityConfigs(this.securityProtocol(), this.trustStoreFile(), this.clientSaslProperties());
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)securityProps).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            Object key = x0$1._1();
            Object value = x0$1._2();
            Object object = config.put((String)key, (String)value);
            return object;
        });
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void waitForTopics(Admin client, Seq<String> expectedPresent, Seq<String> expectedMissing) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BaseAdminIntegrationTest.$anonfun$waitForTopics$1(client, expectedPresent, expectedMissing)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(BaseAdminIntegrationTest.$anonfun$waitForTopics$4(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    public TopicDescription getTopicMetadata(Admin client, String topic, DescribeTopicsOptions describeOptions, Option<Object> expectedNumPartitionsOpt) {
        ObjectRef result = ObjectRef.create(null);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BaseAdminIntegrationTest.$anonfun$getTopicMetadata$1(client, topic, describeOptions, result, expectedNumPartitionsOpt)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(BaseAdminIntegrationTest.$anonfun$getTopicMetadata$4(topic), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        return (TopicDescription)result.elem;
    }

    public DescribeTopicsOptions getTopicMetadata$default$3() {
        return new DescribeTopicsOptions();
    }

    public Option<Object> getTopicMetadata$default$4() {
        return None$.MODULE$;
    }

    private final void validateMetadataAndConfigs$1(CreateTopicsResult result) {
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)2), (Object)result.numPartitions("mytopic").get());
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)2), (Object)result.replicationFactor("mytopic").get());
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)3), (Object)result.numPartitions("mytopic2").get());
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)3), (Object)result.replicationFactor("mytopic2").get());
        Assert.assertEquals((Object)((KafkaConfig)this.configs().head()).numPartitions(), (Object)result.numPartitions("mytopic3").get());
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)((KafkaConfig)this.configs().head()).defaultReplicationFactor()), (Object)result.replicationFactor("mytopic3").get());
        Assert.assertFalse((boolean)((Config)result.config("mytopic").get()).entries().isEmpty());
    }

    public static final /* synthetic */ void $anonfun$testCreateDeleteTopics$6(BaseAdminIntegrationTest $this, Node replica) {
        Assert.assertTrue((replica.id() >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((replica.id() < $this.brokerCount() ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testCreateDeleteTopics$5(BaseAdminIntegrationTest $this, TopicDescription topic1$1, int partitionId) {
        TopicPartitionInfo partition = (TopicPartitionInfo)topic1$1.partitions().get(partitionId);
        Assert.assertEquals((long)partitionId, (long)partition.partition());
        Assert.assertEquals((long)3L, (long)partition.replicas().size());
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partition.replicas()).asScala()).foreach((Function1 & Serializable & scala.Serializable)replica -> {
            BaseAdminIntegrationTest.$anonfun$testCreateDeleteTopics$6($this, replica);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((String)"No duplicate replica ids", (long)partition.replicas().size(), (long)((SeqLike)((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partition.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.id()), Buffer$.MODULE$.canBuildFrom())).distinct()).size());
        Assert.assertEquals((long)3L, (long)partition.isr().size());
        Assert.assertEquals((Object)partition.replicas(), (Object)partition.isr());
        Assert.assertTrue((boolean)partition.replicas().contains(partition.leader()));
    }

    public static final /* synthetic */ boolean $anonfun$waitForTopics$3(java.util.Set topics$1, String topicName) {
        return !topics$1.contains(topicName);
    }

    public static final /* synthetic */ boolean $anonfun$waitForTopics$1(Admin client$1, Seq expectedPresent$1, Seq expectedMissing$1) {
        java.util.Set topics = (java.util.Set)client$1.listTopics().names().get();
        return expectedPresent$1.forall((Function1 & Serializable & scala.Serializable)topicName -> BoxesRunTime.boxToBoolean((boolean)topics.contains(topicName))) && expectedMissing$1.forall((Function1 & Serializable & scala.Serializable)topicName -> BoxesRunTime.boxToBoolean((boolean)BaseAdminIntegrationTest.$anonfun$waitForTopics$3(topics, topicName)));
    }

    public static final /* synthetic */ String $anonfun$waitForTopics$4() {
        return "timed out waiting for topics";
    }

    public static final /* synthetic */ boolean $anonfun$getTopicMetadata$2(ObjectRef result$1, int x$6) {
        return x$6 == ((TopicDescription)result$1.elem).partitions().size();
    }

    public static final /* synthetic */ boolean $anonfun$getTopicMetadata$3() {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$getTopicMetadata$1(Admin client$2, String topic$1, DescribeTopicsOptions describeOptions$1, ObjectRef result$1, Option expectedNumPartitionsOpt$1) {
        KafkaFuture topicResult = (KafkaFuture)client$2.describeTopics((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic$1}))).asJava(), describeOptions$1).values().get(topic$1);
        try {
            None$ none$;
            result$1.elem = (TopicDescription)topicResult.get();
            if (expectedNumPartitionsOpt$1 == null) {
                throw null;
            }
            if (expectedNumPartitionsOpt$1.isEmpty()) {
                none$ = None$.MODULE$;
            } else {
                int n = BoxesRunTime.unboxToInt((Object)expectedNumPartitionsOpt$1.get());
                none$ = new Some((Object)BoxesRunTime.boxToBoolean((boolean)BaseAdminIntegrationTest.$anonfun$getTopicMetadata$2(result$1, n)));
            }
            if (none$ == null) {
                throw null;
            }
            Object object = none$.isEmpty() ? BoxesRunTime.boxToBoolean((boolean)BaseAdminIntegrationTest.$anonfun$getTopicMetadata$3()) : none$.get();
            return BoxesRunTime.unboxToBoolean((Object)object);
        }
        catch (Throwable throwable) {
            if (!(throwable instanceof ExecutionException) || !(((ExecutionException)throwable).getCause() instanceof UnknownTopicOrPartitionException)) {
                throw throwable;
            }
            boolean bl = false;
            return bl;
        }
    }

    public static final /* synthetic */ String $anonfun$getTopicMetadata$4(String topic$1) {
        return new StringBuilder(35).append("Timed out waiting for metadata for ").append(topic$1).toString();
    }
}

