/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.ApiVersion;
import kafka.api.ApiVersion$;
import kafka.api.LeaderAndIsr;
import kafka.cluster.DelayedOperations;
import kafka.cluster.Partition;
import kafka.cluster.PartitionStateStore;
import kafka.log.AppendOrigin;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.Log;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.MetadataCache;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.utils.Logging;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\tMe\u0001\u0002\u00192\u0001YBQa\u0011\u0001\u0005\u0002\u0011Cqa\u0012\u0001C\u0002\u0013\u0005\u0001\n\u0003\u0004M\u0001\u0001\u0006I!\u0013\u0005\b\u001b\u0002\u0011\r\u0011\"\u0001I\u0011\u0019q\u0005\u0001)A\u0005\u0013\"9q\n\u0001b\u0001\n\u0003A\u0005B\u0002)\u0001A\u0003%\u0011\nC\u0004R\u0001\t\u0007I\u0011\u0001*\t\rY\u0003\u0001\u0015!\u0003T\u0011\u001d9\u0006A1A\u0005\u0002aCa!\u0019\u0001!\u0002\u0013I\u0006b\u00022\u0001\u0005\u0004%\t\u0001\u0017\u0005\u0007G\u0002\u0001\u000b\u0011B-\t\u000f\u0011\u0004!\u0019!C\u0001K\"1a\u000e\u0001Q\u0001\n\u0019Dqa\u001c\u0001C\u0002\u0013\u0005\u0001\u000f\u0003\u0004u\u0001\u0001\u0006I!\u001d\u0005\bk\u0002\u0011\r\u0011\"\u0001q\u0011\u00191\b\u0001)A\u0005c\"9q\u000f\u0001b\u0001\n\u0003A\bbBA\u0012\u0001\u0001\u0006I!\u001f\u0005\f\u0003K\u0001\u0001\u0019!a\u0001\n\u0003\t9\u0003C\u0006\u00026\u0001\u0001\r\u00111A\u0005\u0002\u0005]\u0002bCA\"\u0001\u0001\u0007\t\u0011)Q\u0005\u0003SA1\"!\u0012\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002H!Y\u0011q\n\u0001A\u0002\u0003\u0007I\u0011AA)\u0011-\t)\u0006\u0001a\u0001\u0002\u0003\u0006K!!\u0013\t\u000f\u0005]\u0003\u0001\"\u0001\u0002Z!9\u0011\u0011\u000e\u0001\u0005\u0002\u0005e\u0003bBA:\u0001\u0011\u0005\u0011\u0011\f\u0005\b\u0003{\u0002A\u0011AA-\u0011\u001d\t\t\t\u0001C\u0001\u00033Bq!!\"\u0001\t\u0013\tI\u0006C\u0004\u0002\b\u0002!I!!\u0017\t\u000f\u0005%\u0005\u0001\"\u0003\u0002\f\"9\u00111\u0019\u0001\u0005\n\u0005\u0015\u0007bBAl\u0001\u0011%\u0011\u0011\u001c\u0005\b\u0003\u007f\u0004A\u0011\u0002B\u0001\u0011\u001d\u0011y\u0001\u0001C\u0005\u0005#AqA!\u000e\u0001\t\u0013\u00119\u0004C\u0004\u0003B\u0001!IAa\u0011\u0007\r\tE\u0003\u0001\u0002B*\u0011)\tyC\u000bB\u0001B\u0003%!Q\u000b\u0005\t#*\u0012\t\u0011)A\u0005'\"AqN\u000bB\u0001B\u0003%\u0011\u000f\u0003\u0004DU\u0011\u0005!1\f\u0005\b\u0005ORC\u0011\tB5\u0005E\u0001\u0016M\u001d;ji&|g\u000eT8dWR+7\u000f\u001e\u0006\u0003eM\nqa\u00197vgR,'OC\u00015\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001A\u001c>!\tA4(D\u0001:\u0015\u0005Q\u0014!B:dC2\f\u0017B\u0001\u001f:\u0005\u0019\te.\u001f*fMB\u0011a(Q\u0007\u0002\u007f)\u0011\u0001iM\u0001\u0006kRLGn]\u0005\u0003\u0005~\u0012q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002\u000bB\u0011a\tA\u0007\u0002c\u0005\u0011b.^7SKBd\u0017nY1GKR\u001c\u0007.\u001a:t+\u0005I\u0005C\u0001\u001dK\u0013\tY\u0015HA\u0002J]R\f1C\\;n%\u0016\u0004H.[2b\r\u0016$8\r[3sg\u0002\nAB\\;n!J|G-^2feN\fQB\\;n!J|G-^2feN\u0004\u0013!\u00068v[J+7m\u001c:egB+'\u000f\u0015:pIV\u001cWM]\u0001\u0017]Vl'+Z2pe\u0012\u001c\b+\u001a:Qe>$WoY3sA\u0005AQn\\2l)&lW-F\u0001T!\tqD+\u0003\u0002V\u007f\tAQj\\2l)&lW-A\u0005n_\u000e\\G+[7fA\u00051A/\u001c9ESJ,\u0012!\u0017\t\u00035~k\u0011a\u0017\u0006\u00039v\u000b!![8\u000b\u0003y\u000bAA[1wC&\u0011\u0001m\u0017\u0002\u0005\r&dW-A\u0004u[B$\u0015N\u001d\u0011\u0002\r1|w\rR5s\u0003\u001dawn\u001a#je\u0002\nq\"\u001a=fGV$xN]*feZL7-Z\u000b\u0002MB\u0011q\r\\\u0007\u0002Q*\u0011\u0011N[\u0001\u000bG>t7-\u001e:sK:$(BA6^\u0003\u0011)H/\u001b7\n\u00055D'aD#yK\u000e,Ho\u001c:TKJ4\u0018nY3\u0002!\u0015DXmY;u_J\u001cVM\u001d<jG\u0016\u0004\u0013aD1qa\u0016tGmU3nCBDwN]3\u0016\u0003E\u0004\"a\u001a:\n\u0005MD'!C*f[\u0006\u0004\bn\u001c:f\u0003A\t\u0007\u000f]3oIN+W.\u00199i_J,\u0007%\u0001\ntQJLgn[%teN+W.\u00199i_J,\u0017aE:ie&t7.S:s'\u0016l\u0017\r\u001d5pe\u0016\u0004\u0013A\u00044pY2|w/\u001a:Rk\u0016,Xm]\u000b\u0002sB!!p`A\u0002\u001b\u0005Y(B\u0001?~\u0003%IW.\\;uC\ndWM\u0003\u0002\u007fs\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0007\u0005\u00051P\u0001\u0006J]\u0012,\u00070\u001a3TKF\u0004RaZA\u0003\u0003\u0013I1!a\u0002i\u0005I\t%O]1z\u00052|7m[5oOF+X-^3\u0011\t\u0005-\u0011qD\u0007\u0003\u0003\u001bQA!a\u0004\u0002\u0012\u00051!/Z2pe\u0012TA!a\u0005\u0002\u0016\u000511m\\7n_:T1\u0001NA\f\u0015\u0011\tI\"a\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\ti\"A\u0002pe\u001eLA!!\t\u0002\u000e\tiQ*Z7pef\u0014VmY8sIN\fqBZ8mY><XM])vKV,7\u000fI\u0001\u000bY><W*\u00198bO\u0016\u0014XCAA\u0015!\u0011\tY#!\r\u000e\u0005\u00055\"bAA\u0018g\u0005\u0019An\\4\n\t\u0005M\u0012Q\u0006\u0002\u000b\u0019><W*\u00198bO\u0016\u0014\u0018A\u00047pO6\u000bg.Y4fe~#S-\u001d\u000b\u0005\u0003s\ty\u0004E\u00029\u0003wI1!!\u0010:\u0005\u0011)f.\u001b;\t\u0013\u0005\u0005s#!AA\u0002\u0005%\u0012a\u0001=%c\u0005YAn\\4NC:\fw-\u001a:!\u0003%\u0001\u0018M\u001d;ji&|g.\u0006\u0002\u0002JA\u0019a)a\u0013\n\u0007\u00055\u0013GA\u0005QCJ$\u0018\u000e^5p]\u0006i\u0001/\u0019:uSRLwN\\0%KF$B!!\u000f\u0002T!I\u0011\u0011\t\u000e\u0002\u0002\u0003\u0007\u0011\u0011J\u0001\u000ba\u0006\u0014H/\u001b;j_:\u0004\u0013!B:fiV\u0003HCAA\u001dQ\ra\u0012Q\f\t\u0005\u0003?\n)'\u0004\u0002\u0002b)!\u00111MA\u000e\u0003\u0015QWO\\5u\u0013\u0011\t9'!\u0019\u0003\r\t+gm\u001c:f\u0003!!X-\u0019:E_^t\u0007fA\u000f\u0002nA!\u0011qLA8\u0013\u0011\t\t(!\u0019\u0003\u000b\u00053G/\u001a:\u0002IQ,7\u000f\u001e(p\u0019>\u001c7nQ8oi\u0016tG/[8o/&$\bn\\;u\u0013N\u0014X\u000b\u001d3bi\u0016D3AHA<!\u0011\ty&!\u001f\n\t\u0005m\u0014\u0011\r\u0002\u0005)\u0016\u001cH/\u0001\u001buKN$\u0018\t\u001d9f]\u0012\u0014V\r\u001d7jG\u00064U\r^2i/&$\bnU2iK\u0012,H.\u001a:DQ\u0016\u001c7NR8s'\"\u0014\u0018N\\6JgJD3aHA<\u0003\r\"Xm\u001d;BaB,g\u000e\u001a*fa2L7-\u0019$fi\u000eDw+\u001b;i+B$\u0017\r^3JgJD3\u0001IA<\u0003\u0019\u001awN\\2veJ,g\u000e\u001e)s_\u0012,8-\u001a$fi\u000eDw+\u001b;i%\u0016\fG\rT8dW>sG._\u0001$G>t7-\u001e:sK:$\bK]8ek\u000e,g)\u001a;dQ^KG\u000f[,sSR,Gj\\2l\u0003=\u00198\r[3ek2,\u0017\t\u001d9f]\u0012\u001cHCAAG!\u0019\ty)a(\u0002&:!\u0011\u0011SAN\u001d\u0011\t\u0019*!'\u000e\u0005\u0005U%bAALk\u00051AH]8pizJ\u0011AO\u0005\u0004\u0003;K\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003C\u000b\u0019KA\u0002TKFT1!!(:a\u0011\t9+!-\u0011\u000b\u001d\fI+!,\n\u0007\u0005-\u0006N\u0001\u0004GkR,(/\u001a\t\u0005\u0003_\u000b\t\f\u0004\u0001\u0005\u0017\u0005M6%!A\u0001\u0002\u000b\u0005\u0011Q\u0017\u0002\u0004?\u0012\n\u0014\u0003BA\\\u0003{\u00032\u0001OA]\u0013\r\tY,\u000f\u0002\b\u001d>$\b.\u001b8h!\rA\u0014qX\u0005\u0004\u0003\u0003L$aA!os\u000692o\u00195fIVdW-\u00169eCR,gi\u001c7m_^,'o\u001d\u000b\u0005\u0003\u000f\f\u0019\u000e\u0005\u0004\u0002\u0010\u0006}\u0015\u0011\u001a\u0019\u0005\u0003\u0017\fy\rE\u0003h\u0003S\u000bi\r\u0005\u0003\u00020\u0006=GaCAiI\u0005\u0005\t\u0011!B\u0001\u0003k\u00131a\u0018\u00133\u0011\u0019\t)\u000e\na\u0001\u0013\u0006Qa.^7SK\u000e|'\u000fZ:\u0002#M\u001c\u0007.\u001a3vY\u0016\u001c\u0006N]5oW&\u001b(\u000f\u0006\u0004\u0002\\\u0006\u0015\u0018Q\u001f\u0019\u0005\u0003;\f\t\u000fE\u0003h\u0003S\u000by\u000e\u0005\u0003\u00020\u0006\u0005HaCArK\u0005\u0005\t\u0011!B\u0001\u0003k\u00131a\u0018\u00134\u0011\u001d\t9/\na\u0001\u0003S\f!\"Y2uSZ,g\t\\1h!\u0011\tY/!=\u000e\u0005\u00055(bAAxQ\u00061\u0011\r^8nS\u000eLA!a=\u0002n\ni\u0011\t^8nS\u000e\u0014un\u001c7fC:Dq!a>&\u0001\u0004\tI0A\bn_\u000e\\G+[7f'2,W\r]'t!\rA\u00141`\u0005\u0004\u0003{L$\u0001\u0002'p]\u001e\fqc]3ukB\u0004\u0016M\u001d;ji&|gnV5uQ6{7m[:\u0015\r\u0005%#1\u0001B\u0003\u0011\u001d\t)C\na\u0001\u0003SAqAa\u0002'\u0001\u0004\u0011I!A\u0005m_\u001e\u001cuN\u001c4jOB!\u00111\u0006B\u0006\u0013\u0011\u0011i!!\f\u0003\u00131{wmQ8oM&<\u0017aE2sK\u0006$X\rT8h!J|\u0007/\u001a:uS\u0016\u001cH\u0003\u0002B\n\u00057\u0001BA!\u0006\u0003\u00185\t!.C\u0002\u0003\u001a)\u0014!\u0002\u0015:pa\u0016\u0014H/[3t\u0011\u001d\u0011ib\na\u0001\u0005?\t\u0011b\u001c<feJLG-Z:\u0011\u0011\t\u0005\"\u0011\u0006B\u0018\u0005_qAAa\t\u0003&A\u0019\u00111S\u001d\n\u0007\t\u001d\u0012(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005W\u0011iCA\u0002NCBT1Aa\n:!\u0011\u0011\tC!\r\n\t\tM\"Q\u0006\u0002\u0007'R\u0014\u0018N\\4\u0002\r\u0005\u0004\b/\u001a8e)!\tID!\u000f\u0003<\tu\u0002bBA#Q\u0001\u0007\u0011\u0011\n\u0005\u0007\u0003+D\u0003\u0019A%\t\r]D\u0003\u0019\u0001B !\u0019\ty)a(\u0002\u0004\u0005AR\u000f\u001d3bi\u00164u\u000e\u001c7po\u0016\u0014h)\u001a;dQN#\u0018\r^3\u0015\u0015\u0005e\"Q\tB$\u0005\u0017\u0012i\u0005C\u0004\u0002F%\u0002\r!!\u0013\t\r\t%\u0013\u00061\u0001J\u0003)1w\u000e\u001c7po\u0016\u0014\u0018\n\u001a\u0005\u0007\u0003+L\u0003\u0019A%\t\u000f\t=\u0013\u00061\u0001\u0002\u0004\u0005iam\u001c7m_^,'/U;fk\u0016\u0014qa\u00157po2{wmE\u0002+\u0005+\u0002B!a\u000b\u0003X%!!\u0011LA\u0017\u0005\raun\u001a\u000b\t\u0005;\u0012\tGa\u0019\u0003fA\u0019!q\f\u0016\u000e\u0003\u0001Aq!a\f/\u0001\u0004\u0011)\u0006C\u0003R]\u0001\u00071\u000bC\u0003p]\u0001\u0007\u0011/\u0001\bbaB,g\u000eZ!t\u0019\u0016\fG-\u001a:\u0015\u0015\t-$\u0011\u000fB;\u0005s\u0012\u0019\t\u0005\u0003\u0002,\t5\u0014\u0002\u0002B8\u0003[\u0011Q\u0002T8h\u0003B\u0004XM\u001c3J]\u001a|\u0007b\u0002B:_\u0001\u0007\u0011\u0011B\u0001\be\u0016\u001cwN\u001d3t\u0011\u0019\u00119h\fa\u0001\u0013\u0006YA.Z1eKJ,\u0005o\\2i\u0011%\u0011Yh\fI\u0001\u0002\u0004\u0011i(\u0001\u0004pe&<\u0017N\u001c\t\u0005\u0003W\u0011y(\u0003\u0003\u0003\u0002\u00065\"\u0001D!qa\u0016tGm\u0014:jO&t\u0007\"\u0003BC_A\u0005\t\u0019\u0001BD\u0003iIg\u000e^3s\u0005J|7.\u001a:Qe>$xnY8m-\u0016\u00148/[8o!\u0011\u0011IIa$\u000e\u0005\t-%b\u0001BGg\u0005\u0019\u0011\r]5\n\t\tE%1\u0012\u0002\u000b\u0003BLg+\u001a:tS>t\u0007")
public class PartitionLockTest
implements Logging {
    private final int numReplicaFetchers;
    private final int numProducers;
    private final int numRecordsPerProducer;
    private final MockTime mockTime;
    private final File tmpDir;
    private final File logDir;
    private final ExecutorService executorService;
    private final Semaphore appendSemaphore;
    private final Semaphore shrinkIsrSemaphore;
    private final IndexedSeq<ArrayBlockingQueue<MemoryRecords>> followerQueues;
    private LogManager logManager;
    private Partition partition;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int numReplicaFetchers() {
        return this.numReplicaFetchers;
    }

    public int numProducers() {
        return this.numProducers;
    }

    public int numRecordsPerProducer() {
        return this.numRecordsPerProducer;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public ExecutorService executorService() {
        return this.executorService;
    }

    public Semaphore appendSemaphore() {
        return this.appendSemaphore;
    }

    public Semaphore shrinkIsrSemaphore() {
        return this.shrinkIsrSemaphore;
    }

    public IndexedSeq<ArrayBlockingQueue<MemoryRecords>> followerQueues() {
        return this.followerQueues;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public Partition partition() {
        return this.partition;
    }

    public void partition_$eq(Partition x$1) {
        this.partition = x$1;
    }

    @Before
    public void setUp() {
        LogConfig logConfig = new LogConfig((Map)new Properties(), LogConfig$.MODULE$.$lessinit$greater$default$2());
        boolean x$1 = false;
        int x$2 = CleanerConfig$.MODULE$.apply$default$1();
        long x$3 = CleanerConfig$.MODULE$.apply$default$2();
        double x$4 = CleanerConfig$.MODULE$.apply$default$3();
        int x$5 = CleanerConfig$.MODULE$.apply$default$4();
        int x$6 = CleanerConfig$.MODULE$.apply$default$5();
        double x$7 = CleanerConfig$.MODULE$.apply$default$6();
        long x$8 = CleanerConfig$.MODULE$.apply$default$7();
        String x$9 = CleanerConfig$.MODULE$.apply$default$9();
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir()}))), logConfig, new CleanerConfig(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$1, x$9), this.mockTime()));
        this.partition_$eq(this.setupPartitionWithMocks(this.logManager(), logConfig));
    }

    @After
    public void tearDown() {
        this.executorService().shutdownNow();
        this.logManager().liveLogDirs().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            PartitionLockTest.$anonfun$tearDown$1(x$1);
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testNoLockContentionWithoutIsrUpdate() {
        this.concurrentProduceFetchWithReadLockOnly();
    }

    @Test
    public void testAppendReplicaFetchWithSchedulerCheckForShrinkIsr() {
        AtomicBoolean active = new AtomicBoolean(true);
        Future<?> future = this.scheduleShrinkIsr(active, 0L);
        this.concurrentProduceFetchWithReadLockOnly();
        active.set(false);
        future.get(15L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAppendReplicaFetchWithUpdateIsr() {
        AtomicBoolean active = new AtomicBoolean(true);
        Future<?> future = this.scheduleShrinkIsr(active, 10000L);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PartitionLockTest.$anonfun$testAppendReplicaFetchWithUpdateIsr$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(PartitionLockTest.$anonfun$testAppendReplicaFetchWithUpdateIsr$2(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension((long)waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        this.concurrentProduceFetchWithWriteLock();
        active.set(false);
        future.get(15L, TimeUnit.SECONDS);
    }

    private void concurrentProduceFetchWithReadLockOnly() {
        Seq<Future<?>> appendFutures = this.scheduleAppends();
        Seq<Future<?>> stateUpdateFutures = this.scheduleUpdateFollowers(this.numProducers() * this.numRecordsPerProducer() - 1);
        this.appendSemaphore().release(this.numProducers() * this.numRecordsPerProducer() - 1);
        stateUpdateFutures.foreach((Function1 & Serializable & scala.Serializable)x$2 -> x$2.get(15L, TimeUnit.SECONDS));
        this.appendSemaphore().release(1);
        this.scheduleUpdateFollowers(1).foreach((Function1 & Serializable & scala.Serializable)x$3 -> x$3.get(15L, TimeUnit.SECONDS));
        appendFutures.foreach((Function1 & Serializable & scala.Serializable)x$4 -> x$4.get(15L, TimeUnit.SECONDS));
    }

    private void concurrentProduceFetchWithWriteLock() {
        Seq<Future<?>> appendFutures = this.scheduleAppends();
        Seq<Future<?>> stateUpdateFutures = this.scheduleUpdateFollowers(this.numProducers() * this.numRecordsPerProducer());
        Assert.assertFalse((boolean)stateUpdateFutures.exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isDone())));
        this.appendSemaphore().release(this.numProducers() * this.numRecordsPerProducer());
        Assert.assertFalse((boolean)appendFutures.exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isDone())));
        this.shrinkIsrSemaphore().release();
        stateUpdateFutures.foreach((Function1 & Serializable & scala.Serializable)x$7 -> x$7.get(15L, TimeUnit.SECONDS));
        appendFutures.foreach((Function1 & Serializable & scala.Serializable)x$8 -> x$8.get(15L, TimeUnit.SECONDS));
    }

    private Seq<Future<?>> scheduleAppends() {
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        return (Seq)RichInt$.MODULE$.until$extension0(n, this.numProducers()).map((Function1 & Serializable & scala.Serializable)x$9 -> PartitionLockTest.$anonfun$scheduleAppends$1(this, BoxesRunTime.unboxToInt((Object)x$9)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Future<?>> scheduleUpdateFollowers(int numRecords) {
        void map_bf;
        void map_f;
        int n = 1;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0(n, this.numReplicaFetchers());
        CanBuildFrom canBuildFrom = IndexedSeq$.MODULE$.canBuildFrom();
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)index -> PartitionLockTest.$anonfun$scheduleUpdateFollowers$1(this, numRecords, BoxesRunTime.unboxToInt((Object)index));
        if (inclusive == null) {
            throw null;
        }
        return (Seq)TraversableLike.map$((TraversableLike)inclusive, (Function1)map_f, (CanBuildFrom)map_bf);
    }

    private Future<?> scheduleShrinkIsr(AtomicBoolean activeFlag, long mockTimeSleepMs) {
        return this.executorService().submit(new Runnable(this, activeFlag, mockTimeSleepMs){
            private final /* synthetic */ PartitionLockTest $outer;
            private final AtomicBoolean activeFlag$1;
            private final long mockTimeSleepMs$1;

            public void run() {
                while (this.activeFlag$1.get()) {
                    if (this.mockTimeSleepMs$1 > 0L) {
                        this.$outer.mockTime().sleep(this.mockTimeSleepMs$1);
                    }
                    this.$outer.partition().maybeShrinkIsr();
                    Thread.sleep(1L);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.activeFlag$1 = activeFlag$1;
                this.mockTimeSleepMs$1 = mockTimeSleepMs$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private Partition setupPartitionWithMocks(LogManager logManager, LogConfig logConfig) {
        void map_bf;
        void map_f;
        int leaderEpoch = 1;
        int brokerId = 0;
        TopicPartition topicPartition = new TopicPartition("test-topic", 0);
        PartitionStateStore stateStore = (PartitionStateStore)Mockito.mock(PartitionStateStore.class);
        DelayedOperations delayedOperations = (DelayedOperations)Mockito.mock(DelayedOperations.class);
        MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
        OffsetCheckpoints offsetCheckpoints = (OffsetCheckpoints)Mockito.mock(OffsetCheckpoints.class);
        logManager.startup();
        Partition partition = new Partition(this, topicPartition, brokerId, stateStore, delayedOperations, metadataCache, logManager){
            private final /* synthetic */ PartitionLockTest $outer;

            public void shrinkIsr(Set<Object> newIsr) {
                this.$outer.shrinkIsrSemaphore().acquire();
                try {
                    super.shrinkIsr(newIsr);
                }
                finally {
                    this.$outer.shrinkIsrSemaphore().release();
                }
            }

            public Log createLog(int replicaId, boolean isNew, boolean isFutureReplica, OffsetCheckpoints offsetCheckpoints) {
                Log log = super.createLog(replicaId, isNew, isFutureReplica, offsetCheckpoints);
                return new SlowLog(this.$outer, log, this.$outer.mockTime(), this.$outer.appendSemaphore());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(topicPartition$1, Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), brokerId$1, (Time)$outer.mockTime(), stateStore$1, delayedOperations$1, metadataCache$1, logManager$1);
            }
        };
        Mockito.when((Object)stateStore.fetchTopicConfig()).thenReturn((Object)this.createLogProperties((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty()));
        Mockito.when((Object)offsetCheckpoints.fetch(ArgumentMatchers.anyString(), (TopicPartition)ArgumentMatchers.eq((Object)topicPartition))).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)stateStore.shrinkIsr(ArgumentMatchers.anyInt(), (LeaderAndIsr)ArgumentMatchers.any())).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)2)));
        Mockito.when((Object)stateStore.expandIsr(ArgumentMatchers.anyInt(), (LeaderAndIsr)ArgumentMatchers.any())).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)2)));
        partition.createLogIfNotExists(brokerId, false, false, offsetCheckpoints);
        int controllerId = 0;
        int controllerEpoch = 0;
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0(n, this.numReplicaFetchers());
        CanBuildFrom canBuildFrom = IndexedSeq$.MODULE$.canBuildFrom();
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)i -> PartitionLockTest.$anonfun$setupPartitionWithMocks$1(brokerId, BoxesRunTime.unboxToInt((Object)i));
        if (inclusive == null) {
            throw null;
        }
        java.util.List replicas = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)TraversableLike.map$((TraversableLike)inclusive, (Function1)map_f, (CanBuildFrom)map_bf)).toList()).asJava();
        Assert.assertTrue((String)"Expected become leader transition to succeed", (boolean)partition.makeLeader(controllerId, new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(brokerId).setLeaderEpoch(leaderEpoch).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(true), 0, offsetCheckpoints));
        return partition;
    }

    /*
     * WARNING - void declaration
     */
    private Properties createLogProperties(scala.collection.immutable.Map<String, String> overrides) {
        void var2_2;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(512));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1000));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(999));
        overrides.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            Object object = logProps.put(k, v);
            return object;
        });
        return var2_2;
    }

    public void kafka$cluster$PartitionLockTest$$append(Partition partition, int numRecords, Seq<ArrayBlockingQueue<MemoryRecords>> followerQueues) {
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, numRecords);
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                PartitionLockTest.$anonfun$append$1(partition, followerQueues, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
    }

    public void kafka$cluster$PartitionLockTest$$updateFollowerFetchState(Partition partition, int followerId, int numRecords, ArrayBlockingQueue<MemoryRecords> followerQueue) {
        int n = 1;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range.Inclusive inclusive = RichInt$.MODULE$.to$extension0(n, numRecords);
        if (inclusive == null) {
            throw null;
        }
        Range.Inclusive foreach_this = inclusive;
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                PartitionLockTest.$anonfun$updateFollowerFetchState$1(this, followerQueue, partition, followerId, foreach_i);
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach_i += foreach_this.step();
            }
        }
    }

    public static final /* synthetic */ ArrayBlockingQueue $anonfun$followerQueues$1(int x$1) {
        return new ArrayBlockingQueue(2);
    }

    public static final /* synthetic */ void $anonfun$tearDown$1(File x$1) {
        Utils.delete((File)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$testAppendReplicaFetchWithUpdateIsr$1(PartitionLockTest $this) {
        return $this.shrinkIsrSemaphore().hasQueuedThreads();
    }

    public static final /* synthetic */ String $anonfun$testAppendReplicaFetchWithUpdateIsr$2() {
        return "shrinkIsr not invoked";
    }

    public static final /* synthetic */ Future $anonfun$scheduleAppends$1(PartitionLockTest $this, int x$9) {
        return $this.executorService().submit(new Runnable($this){
            private final /* synthetic */ PartitionLockTest $outer;

            public void run() {
                try {
                    this.$outer.kafka$cluster$PartitionLockTest$$append(this.$outer.partition(), this.$outer.numRecordsPerProducer(), (Seq<ArrayBlockingQueue<MemoryRecords>>)this.$outer.followerQueues());
                    return;
                }
                catch (Throwable e) {
                    this.$outer.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception during append", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    throw e;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(), $anonfun$run$2(java.lang.Throwable )}, serializedLambda);
            }
        });
    }

    public static final /* synthetic */ Future $anonfun$scheduleUpdateFollowers$1(PartitionLockTest $this, int numRecords$1, int index) {
        return $this.executorService().submit(new Runnable($this, index, numRecords$1){
            private final /* synthetic */ PartitionLockTest $outer;
            private final int index$1;
            private final int numRecords$1;

            public void run() {
                try {
                    this.$outer.kafka$cluster$PartitionLockTest$$updateFollowerFetchState(this.$outer.partition(), this.index$1, this.numRecords$1, (ArrayBlockingQueue)this.$outer.followerQueues().apply(this.index$1 - 1));
                    return;
                }
                catch (Throwable e) {
                    this.$outer.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception during updateFollowerFetchState", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    throw e;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.index$1 = index$1;
                this.numRecords$1 = numRecords$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$3(), $anonfun$run$4(java.lang.Throwable )}, serializedLambda);
            }
        });
    }

    public static final /* synthetic */ Integer $anonfun$setupPartitionWithMocks$1(int brokerId$1, int i) {
        return brokerId$1 + i;
    }

    public static final /* synthetic */ void $anonfun$append$1(Partition partition$1, Seq followerQueues$1, int x$10) {
        MemoryRecords batch = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
        partition$1.appendRecordsToLeader(batch, (AppendOrigin)AppendOrigin.Client$.MODULE$, 0);
        followerQueues$1.foreach((Function1 & Serializable & scala.Serializable)x$11 -> {
            x$11.put(batch);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$updateFollowerFetchState$1(PartitionLockTest $this, ArrayBlockingQueue followerQueue$1, Partition partition$2, int followerId$1, int i) {
        MemoryRecords batch = (MemoryRecords)followerQueue$1.poll(15L, TimeUnit.SECONDS);
        if (batch == null) {
            throw new RuntimeException(new StringBuilder(33).append("Timed out waiting for next batch ").append(i).toString());
        }
        List batches = ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(batch.batches().iterator()).asScala()).toList();
        Assert.assertEquals((long)1L, (long)batches.size());
        MutableRecordBatch recordBatch = (MutableRecordBatch)batches.head();
        return partition$2.updateFollowerFetchState(followerId$1, new LogOffsetMetadata(recordBatch.lastOffset() + 1L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, $this.mockTime().milliseconds(), partition$2.localLogOrException().logEndOffset(), partition$2.localLogOrException().highWatermark());
    }

    public PartitionLockTest() {
        Logging.$init$((Logging)this);
        this.numReplicaFetchers = 2;
        this.numProducers = 3;
        this.numRecordsPerProducer = 5;
        this.mockTime = new MockTime();
        this.tmpDir = TestUtils$.MODULE$.tempDir();
        this.logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
        this.executorService = Executors.newFixedThreadPool(this.numReplicaFetchers() + this.numProducers() + 1);
        this.appendSemaphore = new Semaphore(0);
        this.shrinkIsrSemaphore = new Semaphore(0);
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        this.followerQueues = (IndexedSeq)RichInt$.MODULE$.until$extension0(n, this.numReplicaFetchers()).map((Function1 & Serializable & scala.Serializable)x$1 -> PartitionLockTest.$anonfun$followerQueues$1(BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public class SlowLog
    extends Log {
        private final Semaphore appendSemaphore;
        public final /* synthetic */ PartitionLockTest $outer;

        public LogAppendInfo appendAsLeader(MemoryRecords records, int leaderEpoch, AppendOrigin origin, ApiVersion interBrokerProtocolVersion) {
            LogAppendInfo appendInfo = super.appendAsLeader(records, leaderEpoch, origin, interBrokerProtocolVersion);
            this.appendSemaphore.acquire();
            return appendInfo;
        }

        public /* synthetic */ PartitionLockTest kafka$cluster$PartitionLockTest$SlowLog$$$outer() {
            return this.$outer;
        }

        public SlowLog(PartitionLockTest $outer, Log log, MockTime mockTime, Semaphore appendSemaphore) {
            this.appendSemaphore = appendSemaphore;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(log.dir(), log.config(), log.logStartOffset(), log.recoveryPoint(), (Scheduler)mockTime.scheduler(), new BrokerTopicStats(), log.time(), log.maxProducerIdExpirationMs(), log.producerIdExpirationCheckIntervalMs(), log.topicPartition(), log.producerStateManager(), new LogDirFailureChannel(1));
        }
    }
}

