/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.common.RequestAndCompletionHandler;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.DelayedTxnMarker;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.TransactionMarkerChannelManager;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TxnMarkerQueue;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedOperationPurgatory$;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.utils.TestUtils$;
import kafka.utils.timer.MockTimer;
import kafka.utils.timer.Timer;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersResponse;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u0005b\u0001B\u001f?\u0001\u0015CQ\u0001\u0014\u0001\u0005\u00025Cq\u0001\u0015\u0001C\u0002\u0013%\u0011\u000b\u0003\u0004Y\u0001\u0001\u0006IA\u0015\u0005\b3\u0002\u0011\r\u0011\"\u0003[\u0011\u00191\u0007\u0001)A\u00057\"9q\r\u0001b\u0001\n\u0013A\u0007B\u00027\u0001A\u0003%\u0011\u000eC\u0004n\u0001\t\u0007I\u0011\u00028\t\rU\u0004\u0001\u0015!\u0003p\u0011\u001d1\bA1A\u0005\n9Daa\u001e\u0001!\u0002\u0013y\u0007b\u0002=\u0001\u0005\u0004%I!\u001f\u0005\u0007{\u0002\u0001\u000b\u0011\u0002>\t\u000fy\u0004!\u0019!C\u0005s\"1q\u0010\u0001Q\u0001\niD\u0011\"!\u0001\u0001\u0005\u0004%I!a\u0001\t\u0011\u0005U\u0001\u0001)A\u0005\u0003\u000bA\u0011\"a\u0006\u0001\u0005\u0004%I!a\u0001\t\u0011\u0005e\u0001\u0001)A\u0005\u0003\u000bA\u0011\"a\u0007\u0001\u0005\u0004%I!!\b\t\u0011\u0005\u0015\u0002\u0001)A\u0005\u0003?A\u0011\"a\n\u0001\u0005\u0004%I!!\b\t\u0011\u0005%\u0002\u0001)A\u0005\u0003?A\u0011\"a\u000b\u0001\u0005\u0004%I!!\f\t\u0011\u0005U\u0002\u0001)A\u0005\u0003_A\u0011\"a\u000e\u0001\u0005\u0004%I!!\f\t\u0011\u0005e\u0002\u0001)A\u0005\u0003_A\u0011\"a\u000f\u0001\u0005\u0004%I!!\u0010\t\u0011\u0005\u0015\u0003\u0001)A\u0005\u0003\u007fA\u0011\"a\u0012\u0001\u0005\u0004%I!!\u0010\t\u0011\u0005%\u0003\u0001)A\u0005\u0003\u007fA\u0011\"a\u0013\u0001\u0005\u0004%I!!\u0010\t\u0011\u00055\u0003\u0001)A\u0005\u0003\u007fA\u0011\"a\u0014\u0001\u0005\u0004%I!!\u0010\t\u0011\u0005E\u0003\u0001)A\u0005\u0003\u007fA\u0011\"a\u0015\u0001\u0005\u0004%I!!\u0016\t\u0011\u0005\r\u0004\u0001)A\u0005\u0003/B\u0011\"!\u001a\u0001\u0005\u0004%I!a\u001a\t\u0011\u0005=\u0004\u0001)A\u0005\u0003SB\u0011\"!\u001d\u0001\u0005\u0004%I!a\u001a\t\u0011\u0005M\u0004\u0001)A\u0005\u0003SB\u0011\"!\u001e\u0001\u0005\u0004%I!a\u001e\t\u0011\u0005u\u0005\u0001)A\u0005\u0003sB\u0011\"a(\u0001\u0005\u0004%I!!)\t\u0011\u0005=\u0006\u0001)A\u0005\u0003GC\u0011\"!-\u0001\u0005\u0004%I!a-\t\u0011\u0005\u0005\u0007\u0001)A\u0005\u0003kC\u0011\"a1\u0001\u0005\u0004%I!!2\t\u0011\u00055\u0007\u0001)A\u0005\u0003\u000fDq!a4\u0001\t\u0013\t\t\u000eC\u0004\u0002T\u0002!\t!!5\t\u000f\u0005\r\b\u0001\"\u0001\u0002R\"9\u0011q\u001d\u0001\u0005\u0002\u0005E\u0007bBAv\u0001\u0011\u0005\u0011\u0011\u001b\u0005\b\u0003_\u0004A\u0011AAi\u0011\u001d\t\u0019\u0010\u0001C\u0001\u0003#Dq!a>\u0001\t\u0003\t\t\u000eC\u0004\u0002|\u0002!\t!!5\t\u000f\u0005}\b\u0001\"\u0003\u0003\u0002!9!Q\u0004\u0001\u0005\u0002\u0005E'a\t+sC:\u001c\u0018m\u0019;j_:l\u0015M]6fe\u000eC\u0017M\u001c8fY6\u000bg.Y4feR+7\u000f\u001e\u0006\u0003\u007f\u0001\u000b1\u0002\u001e:b]N\f7\r^5p]*\u0011\u0011IQ\u0001\fG>|'\u000fZ5oCR|'OC\u0001D\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001$\u0011\u0005\u001dSU\"\u0001%\u000b\u0003%\u000bQa]2bY\u0006L!a\u0013%\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta\n\u0005\u0002P\u00015\ta(A\u0007nKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z\u000b\u0002%B\u00111KV\u0007\u0002)*\u0011QKQ\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005]#&!D'fi\u0006$\u0017\r^1DC\u000eDW-\u0001\bnKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a\u0011\u0002\u001b9,Go^8sW\u000ec\u0017.\u001a8u+\u0005Y\u0006C\u0001/e\u001b\u0005i&B\u00010`\u0003\u001d\u0019G.[3oiNT!a\u00111\u000b\u0005\u0005\u0014\u0017AB1qC\u000eDWMC\u0001d\u0003\ry'oZ\u0005\u0003Kv\u0013QBT3uo>\u00148n\u00117jK:$\u0018A\u00048fi^|'o[\"mS\u0016tG\u000fI\u0001\u0010ibt7\u000b^1uK6\u000bg.Y4feV\t\u0011\u000e\u0005\u0002PU&\u00111N\u0010\u0002\u0018)J\fgn]1di&|gn\u0015;bi\u0016l\u0015M\\1hKJ\f\u0001\u0003\u001e=o'R\fG/Z'b]\u0006<WM\u001d\u0011\u0002\u0015A\f'\u000f^5uS>t\u0017'F\u0001p!\t\u00018/D\u0001r\u0015\t\u0011x,\u0001\u0004d_6lwN\\\u0005\u0003iF\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\u0006qCJ$\u0018\u000e^5p]F\u0002\u0013A\u00039beRLG/[8oe\u0005Y\u0001/\u0019:uSRLwN\u001c\u001a!\u0003\u001d\u0011'o\\6feF*\u0012A\u001f\t\u0003anL!\u0001`9\u0003\t9{G-Z\u0001\tEJ|7.\u001a:2A\u00059!M]8lKJ\u0014\u0014\u0001\u00032s_.,'O\r\u0011\u0002!Q\u0014\u0018M\\:bGRLwN\\1m\u0013\u0012\fTCAA\u0003!\u0011\t9!!\u0005\u000e\u0005\u0005%!\u0002BA\u0006\u0003\u001b\tA\u0001\\1oO*\u0011\u0011qB\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0014\u0005%!AB*ue&tw-A\tue\u0006t7/Y2uS>t\u0017\r\\%ec\u0001\n\u0001\u0003\u001e:b]N\f7\r^5p]\u0006d\u0017\n\u001a\u001a\u0002#Q\u0014\u0018M\\:bGRLwN\\1m\u0013\u0012\u0014\u0004%A\u0006qe>$WoY3s\u0013\u0012\fTCAA\u0010!\r9\u0015\u0011E\u0005\u0004\u0003GA%\u0001\u0002'p]\u001e\fA\u0002\u001d:pIV\u001cWM]%ec\u0001\n1\u0002\u001d:pIV\u001cWM]%ee\u0005a\u0001O]8ek\u000e,'/\u001333A\u0005i\u0001O]8ek\u000e,'/\u00129pG\",\"!a\f\u0011\u0007\u001d\u000b\t$C\u0002\u00024!\u0013Qa\u00155peR\fa\u0002\u001d:pIV\u001cWM]#q_\u000eD\u0007%A\tmCN$\bK]8ek\u000e,'/\u00129pG\"\f!\u0003\\1tiB\u0013x\u000eZ;dKJ,\u0005o\\2iA\u0005\u0011B\u000f\u001f8U_BL7\rU1si&$\u0018n\u001c82+\t\ty\u0004E\u0002H\u0003\u0003J1!a\u0011I\u0005\rIe\u000e^\u0001\u0014ibtGk\u001c9jGB\u000b'\u000f^5uS>t\u0017\u0007I\u0001\u0013ibtGk\u001c9jGB\u000b'\u000f^5uS>t''A\nuq:$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u0014\u0004%\u0001\td_>\u0014H-\u001b8bi>\u0014X\t]8dQ\u0006\t2m\\8sI&t\u0017\r^8s\u000bB|7\r\u001b\u0011\u0002\u0019QDh\u000eV5nK>,H/T:\u0002\u001bQDh\u000eV5nK>,H/T:!\u0003%!\bP\u001c*fgVdG/\u0006\u0002\u0002XA!\u0011\u0011LA0\u001b\t\tYFC\u0002\u0002^E\f\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0003C\nYFA\tUe\u0006t7/Y2uS>t'+Z:vYR\f!\u0002\u001e=o%\u0016\u001cX\u000f\u001c;!\u00031!\bP\\'fi\u0006$\u0017\r^12+\t\tI\u0007E\u0002P\u0003WJ1!!\u001c?\u0005M!&/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;b\u00035!\bP\\'fi\u0006$\u0017\r^12A\u0005aA\u000f\u001f8NKR\fG-\u0019;be\u0005iA\u000f\u001f8NKR\fG-\u0019;be\u0001\nacY1qiV\u0014X\rZ#se>\u00148oQ1mY\n\f7m[\u000b\u0003\u0003s\u0002b!a\u001f\u0002\u0002\u0006\u0015UBAA?\u0015\r\tyHY\u0001\tK\u0006\u001c\u00180\\8dW&!\u00111QA?\u0005\u001d\u0019\u0015\r\u001d;ve\u0016\u0004raRAD\u0003\u0017\u000b9*C\u0002\u0002\n\"\u0013\u0011BR;oGRLwN\\\u0019\u0011\t\u00055\u00151S\u0007\u0003\u0003\u001fS1!!%r\u0003!\u0001(o\u001c;pG>d\u0017\u0002BAK\u0003\u001f\u0013a!\u0012:s_J\u001c\bcA$\u0002\u001a&\u0019\u00111\u0014%\u0003\tUs\u0017\u000e^\u0001\u0018G\u0006\u0004H/\u001e:fI\u0016\u0013(o\u001c:t\u0007\u0006dGNY1dW\u0002\n!\u0003\u001e=o\u001b\u0006\u00148.\u001a:QkJ<\u0017\r^8ssV\u0011\u00111\u0015\t\u0006'\u0006\u0015\u0016\u0011V\u0005\u0004\u0003O#&!\u0007#fY\u0006LX\rZ(qKJ\fG/[8o!V\u0014x-\u0019;pef\u00042aTAV\u0013\r\tiK\u0010\u0002\u0011\t\u0016d\u0017-_3e)btW*\u0019:lKJ\f1\u0003\u001e=o\u001b\u0006\u00148.\u001a:QkJ<\u0017\r^8ss\u0002\nA\u0001^5nKV\u0011\u0011Q\u0017\t\u0005\u0003o\u000bi,\u0004\u0002\u0002:*\u0019\u00111X9\u0002\u000bU$\u0018\u000e\\:\n\t\u0005}\u0016\u0011\u0018\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u0005q1\r[1o]\u0016dW*\u00198bO\u0016\u0014XCAAd!\ry\u0015\u0011Z\u0005\u0004\u0003\u0017t$a\b+sC:\u001c\u0018m\u0019;j_:l\u0015M]6fe\u000eC\u0017M\u001c8fY6\u000bg.Y4fe\u0006y1\r[1o]\u0016dW*\u00198bO\u0016\u0014\b%A\u0005n_\u000e\\7)Y2iKR\u0011\u0011qS\u00010g\"|W\u000f\u001c3HK:,'/\u0019;f\u000b6\u0004H/_'ba^CWM\u001c(p%\u0016\fX/Z:ug>+Ho\u001d;b]\u0012Lgn\u001a\u0015\u0004g\u0005]\u0007\u0003BAm\u0003?l!!a7\u000b\u0007\u0005u'-A\u0003kk:LG/\u0003\u0003\u0002b\u0006m'\u0001\u0002+fgR\f!f\u001d5pk2$w)\u001a8fe\u0006$XMU3rk\u0016\u001cH\u000fU3s!\u0006\u0014H/\u001b;j_:\u0004VM\u001d\"s_.,'\u000fK\u00025\u0003/\fqe\u001d5pk2$7k[5q'\u0016tG-T1sW\u0016\u00148o\u00165f]2+\u0017\rZ3s\u001d>$hi\\;oI\"\u001aQ'a6\u0002eMDw.\u001e7e'\u00064XMR8s\u0019\u0006$XM],iK:dU-\u00193feVs7N\\8x]\n+HOT8u\u0003Z\f\u0017\u000e\\1cY\u0016D3ANAl\u0003a\u001a\bn\\;mIJ+Wn\u001c<f\u001b\u0006\u00148.\u001a:t\r>\u0014H\u000b\u001f8QCJ$\u0018\u000e^5p]^CWM\u001c)beRLG/[8o\u000b6LwM]1uK\u0012D3aNAl\u0003]\u001a\bn\\;mI\u000e{W\u000e\u001d7fi\u0016\f\u0005\u000f]3oIR{Gj\\4P]\u0016sG\r\u0016=o/\",gnU3oI6\u000b'o[3sgN+8mY3fI\"\u001a\u0001(a6\u0002kMDw.\u001e7e\u0003\n|'\u000f^!qa\u0016tG\rV8M_\u001e|e.\u00128e)btw\u000b[3o\u001d>$8i\\8sI&t\u0017\r^8s\u000bJ\u0014xN\u001d\u0015\u0004s\u0005]\u0017AP:i_VdGMU3uef\f\u0005\u000f]3oIR{Gj\\4P]\u0016sG\r\u0016=o/\",gnQ8pe\u0012Lg.\u0019;pe:{G/\u0011<bS2\f'\r\\3FeJ|'\u000fK\u0002;\u0003/\f\u0011c\u0019:fCR,\u0007+\u001b3FeJ|'/T1q)\u0011\u0011\u0019A!\u0007\u0011\u0011\t\u0015!1\u0002B\b\u0005'i!Aa\u0002\u000b\t\t%\u0011QB\u0001\u0005kRLG.\u0003\u0003\u0003\u000e\t\u001d!a\u0002%bg\"l\u0015\r\u001d\t\u0005\u0003\u000f\u0011\t\"\u0003\u0003\u0002$\u0005%\u0001c\u0002B\u0003\u0005+y\u00171R\u0005\u0005\u0005/\u00119AA\u0002NCBDqAa\u0007<\u0001\u0004\tY)\u0001\u0004feJ|'o]\u0001\u001eg\"|W\u000f\u001c3De\u0016\fG/Z'fiJL7m](o'R\f'\u000f^5oO\"\u001aA(a6")
public class TransactionMarkerChannelManagerTest {
    private final MetadataCache metadataCache = (MetadataCache)EasyMock.createNiceMock(MetadataCache.class);
    private final NetworkClient networkClient = (NetworkClient)EasyMock.createNiceMock(NetworkClient.class);
    private final TransactionStateManager txnStateManager = (TransactionStateManager)EasyMock.createNiceMock(TransactionStateManager.class);
    private final TopicPartition partition1 = new TopicPartition("topic1", 0);
    private final TopicPartition partition2 = new TopicPartition("topic1", 1);
    private final Node broker1 = new Node(1, "host", 10);
    private final Node broker2 = new Node(2, "otherhost", 10);
    private final String transactionalId1;
    private final String transactionalId2;
    private final long producerId1;
    private final long producerId2;
    private final short producerEpoch = (short)0;
    private final short lastProducerEpoch = (short)-1;
    private final int txnTopicPartition1;
    private final int txnTopicPartition2;
    private final int coordinatorEpoch;
    private final int txnTimeoutMs;
    private final TransactionResult txnResult = TransactionResult.COMMIT;
    private final TransactionMetadata txnMetadata1 = new TransactionMetadata(this.transactionalId1(), this.producerId1(), this.producerId1(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), (TransactionState)PrepareCommit$.MODULE$, (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.partition1(), this.partition2()})), 0L, 0L);
    private final TransactionMetadata kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2 = new TransactionMetadata(this.transactionalId2(), this.producerId2(), this.producerId2(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), (TransactionState)PrepareCommit$.MODULE$, (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.partition1()})), 0L, 0L);
    private final Capture<Function1<Errors, BoxedUnit>> kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$capturedErrorsCallback = EasyMock.newCapture();
    private final DelayedOperationPurgatory<DelayedTxnMarker> txnMarkerPurgatory;
    private final MockTime time;
    private final TransactionMarkerChannelManager channelManager;

    private MetadataCache metadataCache() {
        return this.metadataCache;
    }

    private NetworkClient networkClient() {
        return this.networkClient;
    }

    private TransactionStateManager txnStateManager() {
        return this.txnStateManager;
    }

    private TopicPartition partition1() {
        return this.partition1;
    }

    private TopicPartition partition2() {
        return this.partition2;
    }

    private Node broker1() {
        return this.broker1;
    }

    private Node broker2() {
        return this.broker2;
    }

    private String transactionalId1() {
        return this.transactionalId1;
    }

    private String transactionalId2() {
        return this.transactionalId2;
    }

    private long producerId1() {
        return this.producerId1;
    }

    private long producerId2() {
        return this.producerId2;
    }

    private short producerEpoch() {
        return this.producerEpoch;
    }

    private short lastProducerEpoch() {
        return this.lastProducerEpoch;
    }

    private int txnTopicPartition1() {
        return this.txnTopicPartition1;
    }

    private int txnTopicPartition2() {
        return this.txnTopicPartition2;
    }

    private int coordinatorEpoch() {
        return this.coordinatorEpoch;
    }

    private int txnTimeoutMs() {
        return this.txnTimeoutMs;
    }

    private TransactionResult txnResult() {
        return this.txnResult;
    }

    private TransactionMetadata txnMetadata1() {
        return this.txnMetadata1;
    }

    public TransactionMetadata kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2() {
        return this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2;
    }

    public Capture<Function1<Errors, BoxedUnit>> kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$capturedErrorsCallback() {
        return this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$capturedErrorsCallback;
    }

    private DelayedOperationPurgatory<DelayedTxnMarker> txnMarkerPurgatory() {
        return this.txnMarkerPurgatory;
    }

    private MockTime time() {
        return this.time;
    }

    private TransactionMarkerChannelManager channelManager() {
        return this.channelManager;
    }

    private void mockCache() {
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)this.txnStateManager().partitionFor(this.transactionalId1()))).andReturn((Object)BoxesRunTime.boxToInteger((int)this.txnTopicPartition1())).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)this.txnStateManager().partitionFor(this.transactionalId2()))).andReturn((Object)BoxesRunTime.boxToInteger((int)this.txnTopicPartition2())).anyTimes();
        EasyMock.expect((Object)this.txnStateManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId1()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1())))).anyTimes();
        EasyMock.expect((Object)this.txnStateManager().getTransactionState((String)EasyMock.eq((Object)this.transactionalId2()))).andReturn((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2())))).anyTimes();
        ReentrantReadWriteLock stateLock = new ReentrantReadWriteLock();
        EasyMock.expect((Object)this.txnStateManager().stateReadLock()).andReturn((Object)stateLock.readLock()).anyTimes();
    }

    @Test
    public void shouldGenerateEmptyMapWhenNoRequestsOutstanding() {
        Assert.assertTrue((boolean)this.channelManager().generateRequests().isEmpty());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldGenerateRequestPerPartitionPerBroker() {
        void $minus$greater$extension_$this;
        void $minus$greater$extension_$this2;
        this.mockCache();
        EasyMock.replay((Object[])new Object[]{this.txnStateManager()});
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition1().topic()), EasyMock.eq((int)this.partition1().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker1())).anyTimes();
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition2().topic()), EasyMock.eq((int)this.partition2().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker2())).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.metadataCache()});
        this.channelManager().addTxnMarkersToSend(this.transactionalId1(), this.coordinatorEpoch(), this.txnResult(), this.txnMetadata1(), this.txnMetadata1().prepareComplete(this.time().milliseconds()));
        this.channelManager().addTxnMarkersToSend(this.transactionalId2(), this.coordinatorEpoch(), this.txnResult(), this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2(), this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2().prepareComplete(this.time().milliseconds()));
        Assert.assertEquals((long)2L, (long)this.txnMarkerPurgatory().watched());
        Assert.assertEquals((long)2L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers());
        Assert.assertEquals((long)1L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assert.assertEquals((long)1L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
        Assert.assertEquals((long)1L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers());
        Assert.assertEquals((long)1L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assert.assertEquals((long)0L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
        WriteTxnMarkersRequest expectedBroker1Request = (WriteTxnMarkersRequest)new WriteTxnMarkersRequest.Builder(Arrays.asList((Object[])new WriteTxnMarkersRequest.TxnMarkerEntry[]{new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId1(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Arrays.asList((Object[])new TopicPartition[]{this.partition1()})), new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId2(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Arrays.asList((Object[])new TopicPartition[]{this.partition1()}))})).build();
        WriteTxnMarkersRequest expectedBroker2Request = (WriteTxnMarkersRequest)new WriteTxnMarkersRequest.Builder(Arrays.asList((Object[])new WriteTxnMarkersRequest.TxnMarkerEntry[]{new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId1(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Arrays.asList((Object[])new TopicPartition[]{this.partition2()}))})).build();
        scala.collection.immutable.Map requests = ((TraversableOnce)this.channelManager().generateRequests().map((Function1 & Serializable & scala.Serializable)handler -> new Tuple2((Object)handler.destination(), (Object)((WriteTxnMarkersRequest.Builder)handler.request()).build()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Tuple2[] tuple2Array = new Tuple2[2];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.broker1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)expectedBroker1Request);
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)this.broker2());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this, (Object)expectedBroker2Request);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)), (Object)requests);
        Assert.assertTrue((boolean)this.channelManager().generateRequests().isEmpty());
    }

    @Test
    public void shouldSkipSendMarkersWhenLeaderNotFound() {
        this.mockCache();
        EasyMock.replay((Object[])new Object[]{this.txnStateManager()});
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition1().topic()), EasyMock.eq((int)this.partition1().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)None$.MODULE$).anyTimes();
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition2().topic()), EasyMock.eq((int)this.partition2().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker2())).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.metadataCache()});
        this.channelManager().addTxnMarkersToSend(this.transactionalId1(), this.coordinatorEpoch(), this.txnResult(), this.txnMetadata1(), this.txnMetadata1().prepareComplete(this.time().milliseconds()));
        this.channelManager().addTxnMarkersToSend(this.transactionalId2(), this.coordinatorEpoch(), this.txnResult(), this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2(), this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2().prepareComplete(this.time().milliseconds()));
        Assert.assertEquals((long)1L, (long)this.txnMarkerPurgatory().watched());
        Assert.assertEquals((long)1L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers());
        Assert.assertTrue((boolean)this.channelManager().queueForBroker(this.broker1().id()).isEmpty());
        Assert.assertEquals((long)1L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assert.assertEquals((long)0L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldSaveForLaterWhenLeaderUnknownButNotAvailable() {
        void $minus$greater$extension_$this;
        void $minus$greater$extension_$this2;
        this.mockCache();
        EasyMock.replay((Object[])new Object[]{this.txnStateManager()});
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition1().topic()), EasyMock.eq((int)this.partition1().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)Node.noNode())).andReturn((Object)new Some((Object)Node.noNode())).andReturn((Object)new Some((Object)Node.noNode())).andReturn((Object)new Some((Object)Node.noNode())).andReturn((Object)new Some((Object)this.broker1())).andReturn((Object)new Some((Object)this.broker1()));
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition2().topic()), EasyMock.eq((int)this.partition2().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker2())).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.metadataCache()});
        this.channelManager().addTxnMarkersToSend(this.transactionalId1(), this.coordinatorEpoch(), this.txnResult(), this.txnMetadata1(), this.txnMetadata1().prepareComplete(this.time().milliseconds()));
        this.channelManager().addTxnMarkersToSend(this.transactionalId2(), this.coordinatorEpoch(), this.txnResult(), this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2(), this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2().prepareComplete(this.time().milliseconds()));
        Assert.assertEquals((long)2L, (long)this.txnMarkerPurgatory().watched());
        Assert.assertEquals((long)1L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers());
        Assert.assertTrue((boolean)this.channelManager().queueForBroker(this.broker1().id()).isEmpty());
        Assert.assertEquals((long)1L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assert.assertEquals((long)0L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
        Assert.assertEquals((long)2L, (long)this.channelManager().queueForUnknownBroker().totalNumMarkers());
        Assert.assertEquals((long)1L, (long)this.channelManager().queueForUnknownBroker().totalNumMarkers(this.txnTopicPartition1()));
        Assert.assertEquals((long)1L, (long)this.channelManager().queueForUnknownBroker().totalNumMarkers(this.txnTopicPartition2()));
        WriteTxnMarkersRequest expectedBroker1Request = (WriteTxnMarkersRequest)new WriteTxnMarkersRequest.Builder(Arrays.asList((Object[])new WriteTxnMarkersRequest.TxnMarkerEntry[]{new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId1(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Arrays.asList((Object[])new TopicPartition[]{this.partition1()})), new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId2(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Arrays.asList((Object[])new TopicPartition[]{this.partition1()}))})).build();
        WriteTxnMarkersRequest expectedBroker2Request = (WriteTxnMarkersRequest)new WriteTxnMarkersRequest.Builder(Arrays.asList((Object[])new WriteTxnMarkersRequest.TxnMarkerEntry[]{new WriteTxnMarkersRequest.TxnMarkerEntry(this.producerId1(), this.producerEpoch(), this.coordinatorEpoch(), this.txnResult(), Arrays.asList((Object[])new TopicPartition[]{this.partition2()}))})).build();
        scala.collection.immutable.Map firstDrainedRequests = ((TraversableOnce)this.channelManager().generateRequests().map((Function1 & Serializable & scala.Serializable)handler -> new Tuple2((Object)handler.destination(), (Object)((WriteTxnMarkersRequest.Builder)handler.request()).build()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Tuple2[] tuple2Array = new Tuple2[1];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)this.broker2());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)expectedBroker2Request);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array)), (Object)firstDrainedRequests);
        scala.collection.immutable.Map secondDrainedRequests = ((TraversableOnce)this.channelManager().generateRequests().map((Function1 & Serializable & scala.Serializable)handler -> new Tuple2((Object)handler.destination(), (Object)((WriteTxnMarkersRequest.Builder)handler.request()).build()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Tuple2[] tuple2Array2 = new Tuple2[1];
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)this.broker1());
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)expectedBroker1Request);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2)), (Object)secondDrainedRequests);
    }

    @Test
    public void shouldRemoveMarkersForTxnPartitionWhenPartitionEmigrated() {
        this.mockCache();
        EasyMock.replay((Object[])new Object[]{this.txnStateManager()});
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition1().topic()), EasyMock.eq((int)this.partition1().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker1())).anyTimes();
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition2().topic()), EasyMock.eq((int)this.partition2().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker2())).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.metadataCache()});
        this.channelManager().addTxnMarkersToSend(this.transactionalId1(), this.coordinatorEpoch(), this.txnResult(), this.txnMetadata1(), this.txnMetadata1().prepareComplete(this.time().milliseconds()));
        this.channelManager().addTxnMarkersToSend(this.transactionalId2(), this.coordinatorEpoch(), this.txnResult(), this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2(), this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2().prepareComplete(this.time().milliseconds()));
        Assert.assertEquals((long)2L, (long)this.txnMarkerPurgatory().watched());
        Assert.assertEquals((long)2L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers());
        Assert.assertEquals((long)1L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assert.assertEquals((long)1L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
        Assert.assertEquals((long)1L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers());
        Assert.assertEquals((long)1L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assert.assertEquals((long)0L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
        this.channelManager().removeMarkersForTxnTopicPartition(this.txnTopicPartition1());
        Assert.assertEquals((long)1L, (long)this.txnMarkerPurgatory().watched());
        Assert.assertEquals((long)1L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers());
        Assert.assertEquals((long)0L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assert.assertEquals((long)1L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
        Assert.assertEquals((long)0L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers());
        Assert.assertEquals((long)0L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition1()));
        Assert.assertEquals((long)0L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker2().id()).get()).totalNumMarkers(this.txnTopicPartition2()));
    }

    @Test
    public void shouldCompleteAppendToLogOnEndTxnWhenSendMarkersSucceed() {
        this.mockCache();
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition1().topic()), EasyMock.eq((int)this.partition1().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker1())).anyTimes();
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition2().topic()), EasyMock.eq((int)this.partition2().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker2())).anyTimes();
        TxnTransitMetadata txnTransitionMetadata2 = this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2().prepareComplete(this.time().milliseconds());
        this.txnStateManager().appendTransactionToLog((String)EasyMock.eq((Object)this.transactionalId2()), EasyMock.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)EasyMock.eq((Object)txnTransitionMetadata2), (Function1)EasyMock.capture(this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$capturedErrorsCallback()), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, txnTransitionMetadata2){
            private final /* synthetic */ TransactionMarkerChannelManagerTest $outer;
            private final TxnTransitMetadata txnTransitionMetadata2$1;

            public void answer() {
                this.$outer.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2().completeTransitionTo(this.txnTransitionMetadata2$1);
                ((Function1)this.$outer.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$capturedErrorsCallback().getValue()).apply((Object)Errors.NONE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.txnTransitionMetadata2$1 = txnTransitionMetadata2$1;
            }
        }).once();
        EasyMock.replay((Object[])new Object[]{this.txnStateManager(), this.metadataCache()});
        this.channelManager().addTxnMarkersToSend(this.transactionalId2(), this.coordinatorEpoch(), this.txnResult(), this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2(), txnTransitionMetadata2);
        Iterable requestAndHandlers = this.channelManager().generateRequests();
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(this.createPidErrorMap(Errors.NONE));
        requestAndHandlers.foreach((Function1 & Serializable & scala.Serializable)requestAndHandler -> {
            TransactionMarkerChannelManagerTest.$anonfun$shouldCompleteAppendToLogOnEndTxnWhenSendMarkersSucceed$1(response, requestAndHandler);
            return BoxedUnit.UNIT;
        });
        EasyMock.verify((Object[])new Object[]{this.txnStateManager()});
        Assert.assertEquals((long)0L, (long)this.txnMarkerPurgatory().watched());
        Assert.assertEquals((long)0L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2().pendingState());
        Assert.assertEquals((Object)CompleteCommit$.MODULE$, (Object)this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2().state());
    }

    @Test
    public void shouldAbortAppendToLogOnEndTxnWhenNotCoordinatorError() {
        this.mockCache();
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition1().topic()), EasyMock.eq((int)this.partition1().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker1())).anyTimes();
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition2().topic()), EasyMock.eq((int)this.partition2().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker2())).anyTimes();
        TxnTransitMetadata txnTransitionMetadata2 = this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2().prepareComplete(this.time().milliseconds());
        this.txnStateManager().appendTransactionToLog((String)EasyMock.eq((Object)this.transactionalId2()), EasyMock.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)EasyMock.eq((Object)txnTransitionMetadata2), (Function1)EasyMock.capture(this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$capturedErrorsCallback()), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this){
            private final /* synthetic */ TransactionMarkerChannelManagerTest $outer;

            public void answer() {
                this.$outer.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2().pendingState_$eq((Option)None$.MODULE$);
                ((Function1)this.$outer.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$capturedErrorsCallback().getValue()).apply((Object)Errors.NOT_COORDINATOR);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).once();
        EasyMock.replay((Object[])new Object[]{this.txnStateManager(), this.metadataCache()});
        this.channelManager().addTxnMarkersToSend(this.transactionalId2(), this.coordinatorEpoch(), this.txnResult(), this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2(), txnTransitionMetadata2);
        Iterable requestAndHandlers = this.channelManager().generateRequests();
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(this.createPidErrorMap(Errors.NONE));
        requestAndHandlers.foreach((Function1 & Serializable & scala.Serializable)requestAndHandler -> {
            TransactionMarkerChannelManagerTest.$anonfun$shouldAbortAppendToLogOnEndTxnWhenNotCoordinatorError$1(response, requestAndHandler);
            return BoxedUnit.UNIT;
        });
        EasyMock.verify((Object[])new Object[]{this.txnStateManager()});
        Assert.assertEquals((long)0L, (long)this.txnMarkerPurgatory().watched());
        Assert.assertEquals((long)0L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2().pendingState());
        Assert.assertEquals((Object)PrepareCommit$.MODULE$, (Object)this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2().state());
    }

    @Test
    public void shouldRetryAppendToLogOnEndTxnWhenCoordinatorNotAvailableError() {
        this.mockCache();
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition1().topic()), EasyMock.eq((int)this.partition1().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker1())).anyTimes();
        EasyMock.expect((Object)this.metadataCache().getPartitionLeaderEndpoint((String)EasyMock.eq((Object)this.partition2().topic()), EasyMock.eq((int)this.partition2().partition()), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)this.broker2())).anyTimes();
        TxnTransitMetadata txnTransitionMetadata2 = this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2().prepareComplete(this.time().milliseconds());
        this.txnStateManager().appendTransactionToLog((String)EasyMock.eq((Object)this.transactionalId2()), EasyMock.eq((int)this.coordinatorEpoch()), (TxnTransitMetadata)EasyMock.eq((Object)txnTransitionMetadata2), (Function1)EasyMock.capture(this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$capturedErrorsCallback()), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this){
            private final /* synthetic */ TransactionMarkerChannelManagerTest $outer;

            public void answer() {
                ((Function1)this.$outer.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$capturedErrorsCallback().getValue()).apply((Object)Errors.COORDINATOR_NOT_AVAILABLE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, txnTransitionMetadata2){
            private final /* synthetic */ TransactionMarkerChannelManagerTest $outer;
            private final TxnTransitMetadata txnTransitionMetadata2$2;

            public void answer() {
                this.$outer.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2().completeTransitionTo(this.txnTransitionMetadata2$2);
                ((Function1)this.$outer.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$capturedErrorsCallback().getValue()).apply((Object)Errors.NONE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.txnTransitionMetadata2$2 = txnTransitionMetadata2$2;
            }
        });
        EasyMock.replay((Object[])new Object[]{this.txnStateManager(), this.metadataCache()});
        this.channelManager().addTxnMarkersToSend(this.transactionalId2(), this.coordinatorEpoch(), this.txnResult(), this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2(), txnTransitionMetadata2);
        Iterable requestAndHandlers = this.channelManager().generateRequests();
        WriteTxnMarkersResponse response = new WriteTxnMarkersResponse(this.createPidErrorMap(Errors.NONE));
        requestAndHandlers.foreach((Function1 & Serializable & scala.Serializable)requestAndHandler -> {
            TransactionMarkerChannelManagerTest.$anonfun$shouldRetryAppendToLogOnEndTxnWhenCoordinatorNotAvailableError$1(response, requestAndHandler);
            return BoxedUnit.UNIT;
        });
        this.channelManager().generateRequests();
        EasyMock.verify((Object[])new Object[]{this.txnStateManager()});
        Assert.assertEquals((long)0L, (long)this.txnMarkerPurgatory().watched());
        Assert.assertEquals((long)0L, (long)((TxnMarkerQueue)this.channelManager().queueForBroker(this.broker1().id()).get()).totalNumMarkers());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2().pendingState());
        Assert.assertEquals((Object)CompleteCommit$.MODULE$, (Object)this.kafka$coordinator$transaction$TransactionMarkerChannelManagerTest$$txnMetadata2().state());
    }

    /*
     * WARNING - void declaration
     */
    private HashMap<Long, Map<TopicPartition, Errors>> createPidErrorMap(Errors errors) {
        void var2_2;
        HashMap pidMap = new HashMap();
        HashMap<TopicPartition, Errors> errorsMap = new HashMap<TopicPartition, Errors>();
        errorsMap.put(this.partition1(), errors);
        pidMap.put(Predef$.MODULE$.long2Long(this.producerId2()), errorsMap);
        return var2_2;
    }

    @Test
    public void shouldCreateMetricsOnStarting() {
        scala.collection.mutable.Map metrics = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala();
        Assert.assertEquals((long)1L, (long)metrics.filterKeys((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManagerTest.$anonfun$shouldCreateMetricsOnStarting$1(x$1))).size());
        Assert.assertEquals((long)1L, (long)metrics.filterKeys((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerChannelManagerTest.$anonfun$shouldCreateMetricsOnStarting$2(x$2))).size());
    }

    public static final /* synthetic */ void $anonfun$shouldCompleteAppendToLogOnEndTxnWhenSendMarkersSucceed$1(WriteTxnMarkersResponse response$1, RequestAndCompletionHandler requestAndHandler) {
        requestAndHandler.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response$1));
    }

    public static final /* synthetic */ void $anonfun$shouldAbortAppendToLogOnEndTxnWhenNotCoordinatorError$1(WriteTxnMarkersResponse response$2, RequestAndCompletionHandler requestAndHandler) {
        requestAndHandler.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response$2));
    }

    public static final /* synthetic */ void $anonfun$shouldRetryAppendToLogOnEndTxnWhenCoordinatorNotAvailableError$1(WriteTxnMarkersResponse response$3, RequestAndCompletionHandler requestAndHandler) {
        requestAndHandler.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response$3));
    }

    public static final /* synthetic */ boolean $anonfun$shouldCreateMetricsOnStarting$1(MetricName x$1) {
        String string = x$1.getMBeanName();
        String string2 = "kafka.coordinator.transaction:type=TransactionMarkerChannelManager,name=UnknownDestinationQueueSize";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$shouldCreateMetricsOnStarting$2(MetricName x$2) {
        String string = x$2.getMBeanName();
        String string2 = "kafka.coordinator.transaction:type=TransactionMarkerChannelManager,name=LogAppendRetryQueueSize";
        return string != null && string.equals(string2);
    }

    public TransactionMarkerChannelManagerTest() {
        this.transactionalId1 = "txnId1";
        this.transactionalId2 = "txnId2";
        this.producerId1 = 0;
        this.producerId2 = 1;
        this.txnTopicPartition1 = 0;
        this.txnTopicPartition2 = 1;
        this.coordinatorEpoch = 0;
        this.txnTimeoutMs = 0;
        String x$1 = "txn-purgatory-name";
        MockTimer x$2 = new MockTimer();
        boolean x$3 = false;
        int x$4 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$5 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$6 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        this.txnMarkerPurgatory = new DelayedOperationPurgatory(x$1, (Timer)x$2, x$4, x$5, x$3, x$6);
        this.time = new MockTime();
        this.channelManager = new TransactionMarkerChannelManager(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:2181", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20())), this.metadataCache(), this.networkClient(), this.txnStateManager(), this.txnMarkerPurgatory(), (Time)this.time());
    }
}

