/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.LinkedList;
import java.util.Properties;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.admin.DelegationTokenCommand;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.CreateDelegationTokenOptions;
import org.apache.kafka.clients.admin.DescribeDelegationTokenOptions;
import org.apache.kafka.clients.admin.DescribeDelegationTokenResult;
import org.apache.kafka.clients.admin.ExpireDelegationTokenOptions;
import org.apache.kafka.clients.admin.RenewDelegationTokenOptions;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.token.delegation.DelegationToken;
import org.apache.kafka.common.security.token.delegation.TokenInformation;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class DelegationTokenCommand$
implements Logging {
    public static DelegationTokenCommand$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new DelegationTokenCommand$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void main(String[] args) {
        DelegationTokenCommand.DelegationTokenCommandOptions opts = new DelegationTokenCommand.DelegationTokenCommandOptions(args);
        CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(opts, "This tool helps to create, renew, expire, or describe delegation tokens.");
        if (((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpecBuilder[]{opts.createOpt(), opts.renewOpt(), opts.expiryOpt(), opts.describeOpt()}))).count(arg_0 -> DelegationTokenCommand$.$anonfun$main$1$adapted(opts.options(), arg_0)) != 1) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "Command must include exactly one action: --create, --renew, --expire or --describe");
        }
        opts.checkArgs();
        Admin adminClient = this.createAdminClient(opts);
        int exitCode = 0;
        try {
            try {
                if (opts.options().has((OptionSpec)opts.createOpt())) {
                    this.createToken(adminClient, opts);
                } else if (opts.options().has((OptionSpec)opts.renewOpt())) {
                    this.renewToken(adminClient, opts);
                } else if (opts.options().has((OptionSpec)opts.expiryOpt())) {
                    this.expireToken(adminClient, opts);
                } else if (opts.options().has((OptionSpec)opts.describeOpt())) {
                    this.describeToken(adminClient, opts);
                }
            }
            catch (Throwable e) {
                Predef$.MODULE$.println((Object)new StringBuilder(49).append("Error while executing delegation token command : ").append(e.getMessage()).toString());
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(this.msgWithLogIdent(DelegationTokenCommand$.$anonfun$main$2(e)));
                }
                exitCode = 1;
            }
        }
        catch (Throwable throwable) {
            adminClient.close();
            throw Exit$.MODULE$.exit(exitCode, Exit$.MODULE$.exit$default$2());
        }
        adminClient.close();
        throw Exit$.MODULE$.exit(exitCode, Exit$.MODULE$.exit$default$2());
    }

    public DelegationToken createToken(Admin adminClient, DelegationTokenCommand.DelegationTokenCommandOptions opts) {
        Option<java.util.List<KafkaPrincipal>> option = this.getPrincipals(opts, opts.renewPrincipalsOpt());
        if (option == null) {
            throw null;
        }
        Option<java.util.List<KafkaPrincipal>> getOrElse_this = option;
        Object object = getOrElse_this.isEmpty() ? DelegationTokenCommand$.$anonfun$createToken$1() : getOrElse_this.get();
        java.util.List renewerPrincipals = (java.util.List)object;
        long maxLifeTimeMs = BoxesRunTime.unboxToLong((Object)opts.options().valueOf(opts.maxLifeTimeOpt()));
        Predef$.MODULE$.println((Object)new StringBuilder(71).append("Calling create token operation with renewers :").append(renewerPrincipals).append(" , max-life-time-period :").append(maxLifeTimeMs).toString());
        CreateDelegationTokenOptions createDelegationTokenOptions = new CreateDelegationTokenOptions().maxlifeTimeMs(maxLifeTimeMs).renewers(renewerPrincipals);
        DelegationToken token = (DelegationToken)adminClient.createDelegationToken(createDelegationTokenOptions).delegationToken().get();
        String string = "Created delegation token with tokenId : %s";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Predef$.MODULE$.println((Object)new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{token.tokenInfo().tokenId()})));
        this.printToken((List<DelegationToken>)new .colon.colon((Object)token, (List)Nil$.MODULE$));
        return token;
    }

    public void printToken(List<DelegationToken> tokens) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
        String string = "\n%-15s %-30s %-15s %-25s %-15s %-15s %-15s";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Predef$.MODULE$.print((Object)new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"TOKENID", "HMAC", "OWNER", "RENEWERS", "ISSUEDATE", "EXPIRYDATE", "MAXDATE"})));
        if (tokens == null) {
            throw null;
        }
        List foreach_these = tokens;
        while (!foreach_these.isEmpty()) {
            DelegationToken delegationToken = (DelegationToken)foreach_these.head();
            DelegationTokenCommand$.$anonfun$printToken$1(dateFormat, delegationToken);
            foreach_these = (List)foreach_these.tail();
        }
    }

    private Option<java.util.List<KafkaPrincipal>> getPrincipals(DelegationTokenCommand.DelegationTokenCommandOptions opts, ArgumentAcceptingOptionSpec<String> principalOptionSpec) {
        if (opts.options().has(principalOptionSpec)) {
            return new Some(JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(principalOptionSpec)).asScala()).map((Function1 & Serializable & scala.Serializable)s -> SecurityUtils.parseKafkaPrincipal((String)s.trim()), Buffer$.MODULE$.canBuildFrom())).toList()).asJava());
        }
        return None$.MODULE$;
    }

    public long renewToken(Admin adminClient, DelegationTokenCommand.DelegationTokenCommandOptions opts) {
        String hmac = (String)opts.options().valueOf(opts.hmacOpt());
        long renewTimePeriodMs = BoxesRunTime.unboxToLong((Object)opts.options().valueOf(opts.renewTimePeriodOpt()));
        Predef$.MODULE$.println((Object)new StringBuilder(63).append("Calling renew token operation with hmac :").append(hmac).append(" , renew-time-period :").append(renewTimePeriodMs).toString());
        Long expiryTimeStamp = (Long)adminClient.renewDelegationToken(Base64.getDecoder().decode(hmac), new RenewDelegationTokenOptions().renewTimePeriodMs(renewTimePeriodMs)).expiryTimestamp().get();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
        String string = "Completed renew operation. New expiry date : %s";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Predef$.MODULE$.println((Object)new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dateFormat.format(expiryTimeStamp)})));
        return Predef$.MODULE$.Long2long(expiryTimeStamp);
    }

    public long expireToken(Admin adminClient, DelegationTokenCommand.DelegationTokenCommandOptions opts) {
        String hmac = (String)opts.options().valueOf(opts.hmacOpt());
        long expiryTimePeriodMs = BoxesRunTime.unboxToLong((Object)opts.options().valueOf(opts.expiryTimePeriodOpt()));
        Predef$.MODULE$.println((Object)new StringBuilder(66).append("Calling expire token operation with hmac :").append(hmac).append(" , expire-time-period : ").append(expiryTimePeriodMs).toString());
        Long expiryTimeStamp = (Long)adminClient.expireDelegationToken(Base64.getDecoder().decode(hmac), new ExpireDelegationTokenOptions().expiryTimePeriodMs(expiryTimePeriodMs)).expiryTimestamp().get();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
        String string = "Completed expire operation. New expiry date : %s";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Predef$.MODULE$.println((Object)new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dateFormat.format(expiryTimeStamp)})));
        return Predef$.MODULE$.Long2long(expiryTimeStamp);
    }

    public List<DelegationToken> describeToken(Admin adminClient, DelegationTokenCommand.DelegationTokenCommandOptions opts) {
        Option<java.util.List<KafkaPrincipal>> ownerPrincipals = this.getPrincipals(opts, opts.ownerPrincipalsOpt());
        if (ownerPrincipals.isEmpty()) {
            Predef$.MODULE$.println((Object)"Calling describe token operation for current user.");
        } else {
            Predef$.MODULE$.println((Object)new StringBuilder(45).append("Calling describe token operation for owners :").append(ownerPrincipals.get()).toString());
        }
        Predef.$less$colon$less orNull_ev = Predef$.MODULE$.$conforms();
        Object object = ownerPrincipals.isEmpty() ? Option.$anonfun$orNull$1((Predef.$less$colon$less)orNull_ev) : ownerPrincipals.get();
        DescribeDelegationTokenResult describeResult = adminClient.describeDelegationToken(new DescribeDelegationTokenOptions().owners((java.util.List)object));
        List tokens = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)describeResult.delegationTokens().get()).asScala()).toList();
        String string = "Total number of tokens : %s";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Predef$.MODULE$.println((Object)new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)tokens.size())})));
        this.printToken((List<DelegationToken>)tokens);
        return tokens;
    }

    private Admin createAdminClient(DelegationTokenCommand.DelegationTokenCommandOptions opts) {
        Properties props = Utils.loadProps((String)((String)opts.options().valueOf(opts.commandConfigOpt())));
        props.put("bootstrap.servers", opts.options().valueOf(opts.bootstrapServerOpt()));
        return AdminClient.create((Properties)props);
    }

    public static final /* synthetic */ String $anonfun$main$2(Throwable e$1) {
        return Utils.stackTrace((Throwable)e$1);
    }

    public static final /* synthetic */ LinkedList $anonfun$createToken$1() {
        return new LinkedList();
    }

    public static final /* synthetic */ void $anonfun$printToken$1(SimpleDateFormat dateFormat$1, DelegationToken token) {
        TokenInformation tokenInfo = token.tokenInfo();
        String string = "\n%-15s %-30s %-15s %-25s %-15s %-15s %-15s";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Predef$.MODULE$.print((Object)new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tokenInfo.tokenId(), token.hmacAsBase64String(), tokenInfo.owner(), tokenInfo.renewersAsString(), dateFormat$1.format(BoxesRunTime.boxToLong((long)tokenInfo.issueTimestamp())), dateFormat$1.format(BoxesRunTime.boxToLong((long)tokenInfo.expiryTimestamp())), dateFormat$1.format(BoxesRunTime.boxToLong((long)tokenInfo.maxTimestamp()))})));
        Predef$.MODULE$.println();
    }

    private DelegationTokenCommand$() {
        MODULE$ = this;
        Logging.$init$(this);
    }

    public static final /* synthetic */ Object $anonfun$main$1$adapted(OptionSet eta$0$1$1, OptionSpec x$1) {
        return BoxesRunTime.boxToBoolean((boolean)eta$0$1$1.has(x$1));
    }

    public static final /* synthetic */ Object $anonfun$printToken$1$adapted(SimpleDateFormat dateFormat$1, DelegationToken token) {
        DelegationTokenCommand$.$anonfun$printToken$1(dateFormat$1, token);
        return BoxedUnit.UNIT;
    }
}

