/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.TimeUnit;
import kafka.cluster.BrokerEndPoint;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.AbstractFetcherManager$;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerAndFetcherId;
import kafka.server.BrokerIdAndFetcherId;
import kafka.server.FailedPartitions;
import kafka.server.FetcherLagMetrics;
import kafka.server.InitialFetchState;
import kafka.server.OffsetAndEpoch;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichDouble$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rg!\u0002\u000f\u001e\u0003\u0003\u0011\u0003\u0002\u0003\u001c\u0001\u0005\u000b\u0007I\u0011A\u001c\t\u0011\r\u0003!\u0011!Q\u0001\naB\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\r\")\u0011\n\u0001C\u0001\u0015\"A1\f\u0001b\u0001\n\u0003iB\f\u0003\u0004i\u0001\u0001\u0006I!\u0018\u0005\bS\u0002\u0011\r\u0011\"\u0003k\u0011\u0019\u0019\b\u0001)A\u0005W\"9A\u000f\u0001a\u0001\n\u0013)\bb\u0002<\u0001\u0001\u0004%Ia\u001e\u0005\u0007{\u0002\u0001\u000b\u0015\u0002$\t\u000fy\u0004!\u0019!C\u0001\u007f\"A\u0011q\u0001\u0001!\u0002\u0013\t\t\u0001C\u0005\u0002\n\u0001\u0011\r\u0011\"\u0001\u0002\f!A\u00111\u0005\u0001!\u0002\u0013\ti\u0001C\u0004\u0002&\u0001!\t!H;\t\u000f\u0005\u001d\u0002\u0001\"\u0001\u0002*!A\u0011q\u0006\u0001\u0005\u0002u\t\t\u0004\u0003\u0005\u0002T\u0001!\t!HA+\u0011\u001d\tI\u0006\u0001C\u0001\u00037Bq!!\u001c\u0001\r\u0003\ty\u0007C\u0004\u0002\u0006\u0002!\t!a\"\t\u000f\u0005m\u0005\u0001\"\u0005\u0002\u001e\"9\u0011q\u0016\u0001\u0005\u0002\u0005E\u0006bBA_\u0001\u0011\u0005\u0011q\u0018\u0005\b\u0003\u0003\u0004A\u0011AA`\u0005Y\t%m\u001d;sC\u000e$h)\u001a;dQ\u0016\u0014X*\u00198bO\u0016\u0014(B\u0001\u0010 \u0003\u0019\u0019XM\u001d<fe*\t\u0001%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0016\u0005\rz5\u0003\u0002\u0001%UA\u0002\"!\n\u0015\u000e\u0003\u0019R\u0011aJ\u0001\u0006g\u000e\fG.Y\u0005\u0003S\u0019\u0012a!\u00118z%\u00164\u0007CA\u0016/\u001b\u0005a#BA\u0017 \u0003\u0015)H/\u001b7t\u0013\tyCFA\u0004M_\u001e<\u0017N\\4\u0011\u0005E\"T\"\u0001\u001a\u000b\u0005Mz\u0012aB7fiJL7m]\u0005\u0003kI\u0012\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q\u0003\u0011q\u0017-\\3\u0016\u0003a\u0002\"!\u000f!\u000f\u0005ir\u0004CA\u001e'\u001b\u0005a$BA\u001f\"\u0003\u0019a$o\\8u}%\u0011qHJ\u0001\u0007!J,G-\u001a4\n\u0005\u0005\u0013%AB*ue&twM\u0003\u0002@M\u0005)a.Y7fA\u0005A1\r\\5f]RLE-A\u0006ok64U\r^2iKJ\u001c\bCA\u0013H\u0013\tAeEA\u0002J]R\fa\u0001P5oSRtD\u0003B&Y3j\u00032\u0001\u0014\u0001N\u001b\u0005i\u0002C\u0001(P\u0019\u0001!Q\u0001\u0015\u0001C\u0002E\u0013\u0011\u0001V\t\u0003%V\u0003\"!J*\n\u0005Q3#a\u0002(pi\"Lgn\u001a\t\u0003\u0019ZK!aV\u000f\u0003+\u0005\u00137\u000f\u001e:bGR4U\r^2iKJ$\u0006N]3bI\")a'\u0002a\u0001q!)A)\u0002a\u0001q!)Q)\u0002a\u0001\r\u0006\u0001b-\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012l\u0015\r]\u000b\u0002;B!alY3N\u001b\u0005y&B\u00011b\u0003\u001diW\u000f^1cY\u0016T!A\u0019\u0014\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002e?\n9\u0001*Y:i\u001b\u0006\u0004\bC\u0001'g\u0013\t9WD\u0001\u000bCe>\\WM]%e\u0003:$g)\u001a;dQ\u0016\u0014\u0018\nZ\u0001\u0012M\u0016$8\r[3s)\"\u0014X-\u00193NCB\u0004\u0013\u0001\u00027pG.,\u0012a\u001b\t\u0003YFl\u0011!\u001c\u0006\u0003]>\fA\u0001\\1oO*\t\u0001/\u0001\u0003kCZ\f\u0017B\u0001:n\u0005\u0019y%M[3di\u0006)An\\2lA\u0005!b.^7GKR\u001c\u0007.\u001a:t!\u0016\u0014(I]8lKJ,\u0012AR\u0001\u0019]Vlg)\u001a;dQ\u0016\u00148\u000fU3s\u0005J|7.\u001a:`I\u0015\fHC\u0001=|!\t)\u00130\u0003\u0002{M\t!QK\\5u\u0011\u001da8\"!AA\u0002\u0019\u000b1\u0001\u001f\u00132\u0003UqW/\u001c$fi\u000eDWM]:QKJ\u0014%o\\6fe\u0002\n\u0001CZ1jY\u0016$\u0007+\u0019:uSRLwN\\:\u0016\u0005\u0005\u0005\u0001c\u0001'\u0002\u0004%\u0019\u0011QA\u000f\u0003!\u0019\u000b\u0017\u000e\\3e!\u0006\u0014H/\u001b;j_:\u001c\u0018!\u00054bS2,G\rU1si&$\u0018n\u001c8tA\u0005)b-Y5mK\u0012\u0004\u0016M\u001d;ji&|gn]\"pk:$XCAA\u0007!\u0015\ty!a\bG\u001b\t\t\tB\u0003\u0003\u0002\u0014\u0005U\u0011\u0001B2pe\u0016T1aMA\f\u0015\u0011\tI\"a\u0007\u0002\re\fW.\\3s\u0015\t\ti\"A\u0002d_6LA!!\t\u0002\u0012\t)q)Y;hK\u00061b-Y5mK\u0012\u0004\u0016M\u001d;ji&|gn]\"pk:$\b%A\beK\u0006$G\u000b\u001b:fC\u0012\u001cu.\u001e8u\u0003A\u0011Xm]5{KRC'/Z1e!>|G\u000eF\u0002y\u0003WAa!!\f\u0013\u0001\u00041\u0015a\u00028foNK'0Z\u0001\u000bO\u0016$h)\u001a;dQ\u0016\u0014H\u0003BA\u001a\u0003s\u0001B!JA\u001b\u001b&\u0019\u0011q\u0007\u0014\u0003\r=\u0003H/[8o\u0011\u001d\tYd\u0005a\u0001\u0003{\ta\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0003\u0002@\u0005=SBAA!\u0015\u0011\t\u0019%!\u0012\u0002\r\r|W.\\8o\u0015\r\u0001\u0013q\t\u0006\u0005\u0003\u0013\nY%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u001b\n1a\u001c:h\u0013\u0011\t\t&!\u0011\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006aq-\u001a;GKR\u001c\u0007.\u001a:JIR\u0019a)a\u0016\t\u000f\u0005mB\u00031\u0001\u0002>\u0005YR.\u0019:l!\u0006\u0014H/\u001b;j_:\u001chi\u001c:UeVt7-\u0019;j_:$r\u0001_A/\u0003C\n\u0019\u0007\u0003\u0004\u0002`U\u0001\rAR\u0001\tEJ|7.\u001a:JI\"9\u00111H\u000bA\u0002\u0005u\u0002bBA3+\u0001\u0007\u0011qM\u0001\u0011iJ,hnY1uS>twJ\u001a4tKR\u00042!JA5\u0013\r\tYG\n\u0002\u0005\u0019>tw-A\nde\u0016\fG/\u001a$fi\u000eDWM\u001d+ie\u0016\fG\rF\u0003N\u0003c\n)\b\u0003\u0004\u0002tY\u0001\rAR\u0001\nM\u0016$8\r[3s\u0013\u0012Dq!a\u001e\u0017\u0001\u0004\tI(\u0001\u0007t_V\u00148-\u001a\"s_.,'\u000f\u0005\u0003\u0002|\u0005\u0005UBAA?\u0015\r\tyhH\u0001\bG2,8\u000f^3s\u0013\u0011\t\u0019)! \u0003\u001d\t\u0013xn[3s\u000b:$\u0007k\\5oi\u00069\u0012\r\u001a3GKR\u001c\u0007.\u001a:G_J\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0004q\u0006%\u0005bBAF/\u0001\u0007\u0011QR\u0001\u0014a\u0006\u0014H/\u001b;j_:\fe\u000eZ(gMN,Go\u001d\t\t\u0003\u001f\u000b\t*!\u0010\u0002\u00166\t\u0011-C\u0002\u0002\u0014\u0006\u00141!T1q!\ra\u0015qS\u0005\u0004\u00033k\"!E%oSRL\u0017\r\u001c$fi\u000eD7\u000b^1uK\u0006a\u0012\r\u001a3QCJ$\u0018\u000e^5p]N$vNR3uG\",'\u000f\u00165sK\u0006$G#\u0002=\u0002 \u0006\r\u0006BBAQ1\u0001\u0007Q*A\u0007gKR\u001c\u0007.\u001a:UQJ,\u0017\r\u001a\u0005\b\u0003KC\u0002\u0019AAT\u0003YIg.\u001b;jC2|eMZ:fi\u0006sG-\u00129pG\"\u001c\b\u0003CAH\u0003#\u000bi$!+\u0011\u00071\u000bY+C\u0002\u0002.v\u0011ab\u00144gg\u0016$\u0018I\u001c3Fa>\u001c\u0007.\u0001\u000esK6|g/\u001a$fi\u000eDWM\u001d$peB\u000b'\u000f^5uS>t7\u000fF\u0002y\u0003gCq!!.\u001a\u0001\u0004\t9,\u0001\u0006qCJ$\u0018\u000e^5p]N\u0004b!a$\u0002:\u0006u\u0012bAA^C\n\u00191+\u001a;\u00025MDW\u000f\u001e3po:LE\r\\3GKR\u001c\u0007.\u001a:UQJ,\u0017\rZ:\u0015\u0003a\f\u0001c\u00197pg\u0016\fE\u000e\u001c$fi\u000eDWM]:")
public abstract class AbstractFetcherManager<T extends AbstractFetcherThread>
implements KafkaMetricsGroup {
    private final String name;
    private final HashMap<BrokerIdAndFetcherId, T> fetcherThreadMap;
    private final Object lock;
    private int numFetchersPerBroker;
    private final FailedPartitions failedPartitions;
    private final Gauge<Object> failedPartitionsCount;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String name() {
        return this.name;
    }

    public HashMap<BrokerIdAndFetcherId, T> fetcherThreadMap() {
        return this.fetcherThreadMap;
    }

    private Object lock() {
        return this.lock;
    }

    private int numFetchersPerBroker() {
        return this.numFetchersPerBroker;
    }

    private void numFetchersPerBroker_$eq(int x$1) {
        this.numFetchersPerBroker = x$1;
    }

    public FailedPartitions failedPartitions() {
        return this.failedPartitions;
    }

    public Gauge<Object> failedPartitionsCount() {
        return this.failedPartitionsCount;
    }

    public int deadThreadCount() {
        Object object = this.lock();
        synchronized (object) {
            int n = this.fetcherThreadMap().values().count((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isThreadFailed()));
            return n;
        }
    }

    public void resizeThreadPool(int newSize) {
        Object object = this.lock();
        synchronized (object) {
            int currentSize = this.numFetchersPerBroker();
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Resizing fetcher thread pool size from ").append(currentSize).append(" to ").append(newSize).toString());
            this.numFetchersPerBroker_$eq(newSize);
            if (newSize != currentSize) {
                this.migratePartitions$1(newSize);
            }
            this.shutdownIdleFetcherThreads();
            return;
        }
    }

    public Option<T> getFetcher(TopicPartition topicPartition) {
        Object object = this.lock();
        synchronized (object) {
            Option option = this.fetcherThreadMap().values().find((Function1 & Serializable & scala.Serializable)fetcherThread -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$getFetcher$1(topicPartition, fetcherThread)));
            return option;
        }
    }

    public int getFetcherId(TopicPartition topicPartition) {
        Object object = this.lock();
        synchronized (object) {
            int n = Utils.abs((int)(31 * topicPartition.topic().hashCode() + topicPartition.partition())) % this.numFetchersPerBroker();
            return n;
        }
    }

    public void markPartitionsForTruncation(int brokerId, TopicPartition topicPartition, long truncationOffset) {
        Object object = this.lock();
        synchronized (object) {
            int fetcherId = this.getFetcherId(topicPartition);
            BrokerIdAndFetcherId brokerIdAndFetcherId = new BrokerIdAndFetcherId(brokerId, fetcherId);
            Option option = this.fetcherThreadMap().get((Object)brokerIdAndFetcherId);
            if (option == null) {
                throw null;
            }
            Option foreach_this = option;
            if (!foreach_this.isEmpty()) {
                AbstractFetcherThread abstractFetcherThread = (AbstractFetcherThread)foreach_this.get();
                abstractFetcherThread.markPartitionsForTruncation(topicPartition, truncationOffset);
            }
            return;
        }
    }

    public abstract T createFetcherThread(int var1, BrokerEndPoint var2);

    public void addFetcherForPartitions(Map<TopicPartition, InitialFetchState> partitionAndOffsets) {
        Object object = this.lock();
        synchronized (object) {
            partitionAndOffsets.groupBy((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                TopicPartition topicPartition = (TopicPartition)x0$1._1();
                InitialFetchState brokerAndInitialFetchOffset = (InitialFetchState)x0$1._2();
                BrokerAndFetcherId brokerAndFetcherId = new BrokerAndFetcherId(brokerAndInitialFetchOffset.leader(), this.getFetcherId(topicPartition));
                return brokerAndFetcherId;
            }).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                AbstractFetcherManager.$anonfun$addFetcherForPartitions$3(this, x$3);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public void addPartitionsToFetcherThread(T fetcherThread, Map<TopicPartition, OffsetAndEpoch> initialOffsetAndEpochs) {
        ((AbstractFetcherThread)fetcherThread).addPartitions(initialOffsetAndEpochs);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Added fetcher to broker ").append(fetcherThread.sourceBroker().id()).append(" for partitions ").append(initialOffsetAndEpochs).toString());
    }

    public void removeFetcherForPartitions(Set<TopicPartition> partitions) {
        Object object = this.lock();
        synchronized (object) {
            this.fetcherThreadMap().values().foreach((Function1 & Serializable & scala.Serializable)fetcher -> {
                fetcher.removePartitions((Set<TopicPartition>)partitions);
                return BoxedUnit.UNIT;
            });
            this.failedPartitions().removeAll(partitions);
        }
        if (partitions.nonEmpty()) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Removed fetcher for partitions ").append(partitions).toString());
        }
    }

    public void shutdownIdleFetcherThreads() {
        Object object = this.lock();
        synchronized (object) {
            HashSet keysToBeRemoved = new HashSet();
            this.fetcherThreadMap().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$2 != null))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                BoxedUnit boxedUnit;
                if (x$4 != null) {
                    BrokerIdAndFetcherId key = (BrokerIdAndFetcherId)x$4._1();
                    AbstractFetcherThread fetcher = (AbstractFetcherThread)x$4._2();
                    if (fetcher.partitionCount() <= 0) {
                        fetcher.shutdown();
                        boxedUnit = keysToBeRemoved.$plus$eq((Object)key);
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    throw new MatchError(null);
                }
                BoxedUnit boxedUnit2 = boxedUnit;
                return boxedUnit2;
            });
            HashMap cfr_ignored_0 = (HashMap)this.fetcherThreadMap().$minus$minus$eq((TraversableOnce)keysToBeRemoved);
            return;
        }
    }

    public void closeAllFetchers() {
        Object object = this.lock();
        synchronized (object) {
            this.fetcherThreadMap().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$3 != null))).foreach((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$closeAllFetchers$2(x$5)));
            this.fetcherThreadMap().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$4 != null))).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                AbstractFetcherManager.$anonfun$closeAllFetchers$4(x$6);
                return BoxedUnit.UNIT;
            });
            this.fetcherThreadMap().clear();
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$resizeThreadPool$1(AbstractFetcherManager $this, int newSize$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            BrokerIdAndFetcherId id = (BrokerIdAndFetcherId)x0$1._1();
            AbstractFetcherThread thread = (AbstractFetcherThread)x0$1._2();
            Map<TopicPartition, InitialFetchState> removedPartitions = thread.partitionsAndOffsets();
            $this.removeFetcherForPartitions((Set<TopicPartition>)removedPartitions.keySet());
            if (id.fetcherId() >= newSize$1) {
                thread.shutdown();
            }
            $this.addFetcherForPartitions(removedPartitions);
            return;
        }
        throw new MatchError(null);
    }

    private final void migratePartitions$1(int newSize) {
        this.fetcherThreadMap().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AbstractFetcherManager.$anonfun$resizeThreadPool$1(this, newSize, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getFetcher$1(TopicPartition topicPartition$1, AbstractFetcherThread fetcherThread) {
        return fetcherThread.fetchState(topicPartition$1).isDefined();
    }

    /*
     * WARNING - void declaration
     */
    private final AbstractFetcherThread addAndStartFetcherThread$1(BrokerAndFetcherId brokerAndFetcherId, BrokerIdAndFetcherId brokerIdAndFetcherId) {
        void var3_3;
        T fetcherThread = this.createFetcherThread(brokerAndFetcherId.fetcherId(), brokerAndFetcherId.broker());
        this.fetcherThreadMap().put((Object)brokerIdAndFetcherId, fetcherThread);
        ((Thread)fetcherThread).start();
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Tuple2 $anonfun$addFetcherForPartitions$4(Tuple2 x0$2) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        if (x0$2 != null) {
            TopicPartition tp = (TopicPartition)x0$2._1();
            InitialFetchState brokerAndInitOffset = (InitialFetchState)x0$2._2();
            OffsetAndEpoch offsetAndEpoch = new OffsetAndEpoch(brokerAndInitOffset.initOffset(), brokerAndInitOffset.currentLeaderEpoch());
            Object object = Predef$.MODULE$.ArrowAssoc((Object)tp);
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
        } else {
            throw new MatchError(null);
        }
        Tuple2 tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        return tuple2;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$addFetcherForPartitions$3(AbstractFetcherManager $this, Tuple2 x$3) {
        block6: {
            if (x$3 == null) break block6;
            brokerAndFetcherId = (BrokerAndFetcherId)x$3._1();
            initialFetchOffsets = (Map)x$3._2();
            brokerIdAndFetcherId = new BrokerIdAndFetcherId(brokerAndFetcherId.broker().id(), brokerAndFetcherId.fetcherId());
            var6_5 = false;
            var7_6 = null;
            var8_7 = $this.fetcherThreadMap().get((Object)brokerIdAndFetcherId);
            if (!(var8_7 instanceof Some)) ** GOTO lbl-1000
            var6_5 = true;
            var7_6 = (Some)var8_7;
            currentFetcherThread = (AbstractFetcherThread)var7_6.value();
            v0 = currentFetcherThread.sourceBroker();
            var10_9 = brokerAndFetcherId.broker();
            if (!(v0 != null ? v0.equals(var10_9) == false : var10_9 != null)) {
                var2_10 = currentFetcherThread;
            } else if (var6_5) {
                ((AbstractFetcherThread)var7_6.value()).shutdown();
                var2_10 = $this.addAndStartFetcherThread$1(brokerAndFetcherId, brokerIdAndFetcherId);
            } else if (None$.MODULE$.equals(var8_7)) {
                var2_10 = $this.addAndStartFetcherThread$1(brokerAndFetcherId, brokerIdAndFetcherId);
            } else {
                throw new MatchError((Object)var8_7);
            }
            initialOffsetAndEpochs = (Map)initialFetchOffsets.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$addFetcherForPartitions$4(scala.Tuple2 ), (Lscala/Tuple2;)Lscala/Tuple2;)(), Map$.MODULE$.canBuildFrom());
            $this.addPartitionsToFetcherThread(var2_10, (Map<TopicPartition, OffsetAndEpoch>)initialOffsetAndEpochs);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$closeAllFetchers$2(Tuple2 x$5) {
        if (x$5 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((AbstractFetcherThread)x$5._2()).initiateShutdown();
        return bl;
    }

    public static final /* synthetic */ void $anonfun$closeAllFetchers$4(Tuple2 x$6) {
        if (x$6 != null) {
            ((AbstractFetcherThread)x$6._2()).shutdown();
            return;
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    public AbstractFetcherManager(String name, String clientId, int numFetchers) {
        void $minus$greater$extension_$this;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_$this4;
        this.name = name;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.fetcherThreadMap = new HashMap();
        this.lock = new Object();
        this.numFetchersPerBroker = numFetchers;
        this.failedPartitions = new FailedPartitions();
        this.logIdent_$eq(new StringBuilder(3).append("[").append(name).append("] ").toString());
        Tuple2[] tuple2Array = new Tuple2[1];
        Object object = Predef$.MODULE$.ArrowAssoc((Object)"clientId");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)clientId);
        this.newGauge("MaxLag", new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public long value() {
                return BoxesRunTime.unboxToLong((Object)this.$outer.fetcherThreadMap().foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable & scala.Serializable)(curMaxAll, fetcherThreadMapEntry) -> BoxesRunTime.boxToLong((long)$anon$1.$anonfun$value$1(BoxesRunTime.unboxToLong((Object)curMaxAll), fetcherThreadMapEntry))));
            }

            public static final /* synthetic */ long $anonfun$value$2(long curMaxThread, Tuple2 fetcherLagStatsEntry) {
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                return RichLong$.MODULE$.max$extension(curMaxThread, ((FetcherLagMetrics)fetcherLagStatsEntry._2()).lag());
            }

            public static final /* synthetic */ long $anonfun$value$1(long curMaxAll, Tuple2 fetcherThreadMapEntry) {
                long l = BoxesRunTime.unboxToLong((Object)((AbstractFetcherThread)fetcherThreadMapEntry._2()).fetcherLagStats().stats().foldLeft(BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable & scala.Serializable)(curMaxThread, fetcherLagStatsEntry) -> BoxesRunTime.boxToLong((long)$anon$1.$anonfun$value$2(BoxesRunTime.unboxToLong((Object)curMaxThread), fetcherLagStatsEntry))));
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                return RichLong$.MODULE$.max$extension(l, curMaxAll);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$1$adapted(java.lang.Object scala.Tuple2 ), $anonfun$value$2$adapted(java.lang.Object scala.Tuple2 )}, serializedLambda);
            }
        }, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))));
        Tuple2[] tuple2Array2 = new Tuple2[1];
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)"clientId");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)clientId);
        this.newGauge("MinFetchRate", new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public double value() {
                Option option = this.$outer.fetcherThreadMap().headOption();
                if (option == null) {
                    throw null;
                }
                Option map_this = option;
                Object object = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToDouble((double)$anon$2.$anonfun$value$3((Tuple2)map_this.get())));
                if (object == null) {
                    throw null;
                }
                Object object2 = object.isEmpty() ? BoxesRunTime.boxToDouble((double)$anon$2.$anonfun$value$4()) : object.get();
                double headRate = BoxesRunTime.unboxToDouble((Object)object2);
                return BoxesRunTime.unboxToDouble((Object)this.$outer.fetcherThreadMap().foldLeft((Object)BoxesRunTime.boxToDouble((double)headRate), (Function2 & Serializable & scala.Serializable)(curMinAll, fetcherThreadMapEntry) -> BoxesRunTime.boxToDouble((double)$anon$2.$anonfun$value$5(BoxesRunTime.unboxToDouble((Object)curMinAll), fetcherThreadMapEntry))));
            }

            public static final /* synthetic */ double $anonfun$value$3(Tuple2 x$1) {
                return ((AbstractFetcherThread)x$1._2()).fetcherStats().requestRate().oneMinuteRate();
            }

            public static final /* synthetic */ double $anonfun$value$4() {
                return 0.0;
            }

            public static final /* synthetic */ double $anonfun$value$5(double curMinAll, Tuple2 fetcherThreadMapEntry) {
                double d = ((AbstractFetcherThread)fetcherThreadMapEntry._2()).fetcherStats().requestRate().oneMinuteRate();
                if (Predef$.MODULE$ == null) {
                    throw null;
                }
                return RichDouble$.MODULE$.min$extension(d, curMinAll);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            public static final /* synthetic */ Object $anonfun$value$3$adapted(Tuple2 x$1) {
                return BoxesRunTime.boxToDouble((double)$anon$2.$anonfun$value$3(x$1));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$3$adapted(scala.Tuple2 ), $anonfun$value$4(), $anonfun$value$5$adapted(java.lang.Object scala.Tuple2 )}, serializedLambda);
            }
        }, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2))));
        Tuple2[] tuple2Array3 = new Tuple2[1];
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)"clientId");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array3[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)clientId);
        this.failedPartitionsCount = this.newGauge("FailedPartitionsCount", new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public int value() {
                return this.$outer.failedPartitions().size();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array3))));
        Tuple2[] tuple2Array4 = new Tuple2[1];
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)"clientId");
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array4[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)clientId);
        this.newGauge("DeadThreadCount", new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public int value() {
                return this.$outer.deadThreadCount();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array4))));
    }

    public static final /* synthetic */ Object $anonfun$markPartitionsForTruncation$1$adapted(TopicPartition topicPartition$2, long truncationOffset$1, AbstractFetcherThread thread) {
        thread.markPartitionsForTruncation(topicPartition$2, truncationOffset$1);
        return BoxedUnit.UNIT;
    }
}

