/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import kafka.admin.AdminOperationException;
import kafka.admin.TopicCommand;
import kafka.admin.TopicCommand$AdminClientTopicService$;
import kafka.admin.TopicCommand$ZookeeperTopicService$;
import kafka.common.AdminCommandFailedException;
import kafka.log.LogConfig$;
import kafka.utils.CoreUtils$;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import kafka.utils.Whitelist;
import org.apache.kafka.clients.admin.PartitionReassignment;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.utils.Utils;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.LinkedHashMap;
import scala.io.StdIn$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class TopicCommand$
implements Logging {
    public static TopicCommand$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new TopicCommand$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void main(String[] args) {
        TopicCommand.TopicCommandOptions opts = new TopicCommand.TopicCommandOptions(args);
        opts.checkArgs();
        TopicCommand.ZookeeperTopicService topicService = opts.zkConnect().isDefined() ? TopicCommand$ZookeeperTopicService$.MODULE$.apply(opts.zkConnect()) : TopicCommand$AdminClientTopicService$.MODULE$.apply(opts.commandConfig(), opts.bootstrapServer());
        int exitCode = 0;
        try {
            try {
                if (opts.hasCreateOption()) {
                    topicService.createTopic(opts);
                } else if (opts.hasAlterOption()) {
                    topicService.alterTopic(opts);
                } else if (opts.hasListOption()) {
                    topicService.listTopics(opts);
                } else if (opts.hasDescribeOption()) {
                    topicService.describeTopic(opts);
                } else if (opts.hasDeleteOption()) {
                    topicService.deleteTopic(opts);
                }
            }
            catch (Throwable e) {
                Predef$.MODULE$.println((Object)new StringBuilder(38).append("Error while executing topic command : ").append(e.getMessage()).toString());
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(this.msgWithLogIdent(TopicCommand$.$anonfun$main$1(e)));
                }
                exitCode = 1;
            }
        }
        catch (Throwable throwable) {
            topicService.close();
            throw Exit$.MODULE$.exit(exitCode, Exit$.MODULE$.exit$default$2());
        }
        topicService.close();
        throw Exit$.MODULE$.exit(exitCode, Exit$.MODULE$.exit$default$2());
    }

    public void kafka$admin$TopicCommand$$ensureTopicExists(Seq<String> foundTopics, Option<String> requestedTopic, boolean requireTopicExists) {
        if (requestedTopic.isDefined() && requireTopicExists && foundTopics.isEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(35).append("Topic '").append(requestedTopic.get()).append("' does not exist as expected").toString());
        }
    }

    public boolean kafka$admin$TopicCommand$$ensureTopicExists$default$3() {
        return true;
    }

    public Seq<String> kafka$admin$TopicCommand$$doGetTopics(Seq<String> allTopics, Option<String> topicWhitelist, boolean excludeInternalTopics) {
        if (topicWhitelist.isDefined()) {
            Whitelist topicsFilter = new Whitelist((String)topicWhitelist.get());
            return (Seq)allTopics.filter((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)topicsFilter.isTopicAllowed(x$16, excludeInternalTopics)));
        }
        return (Seq)allTopics.filterNot((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)TopicCommand$.$anonfun$doGetTopics$2(excludeInternalTopics, x$17)));
    }

    /*
     * WARNING - void declaration
     */
    public Properties parseTopicConfigsToBeAdded(TopicCommand.TopicCommandOptions opts) {
        void var3_6;
        void require_requirement;
        Option<java.util.List<String>> option = opts.topicConfig();
        if (option == null) {
            throw null;
        }
        Option<java.util.List<String>> getOrElse_this = option;
        Object object = getOrElse_this.isEmpty() ? TopicCommand$.$anonfun$parseTopicConfigsToBeAdded$1() : getOrElse_this.get();
        Buffer configsToBeAdded = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)object).asScala()).map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.split("\\s*=\\s*"), Buffer$.MODULE$.canBuildFrom());
        boolean bl = configsToBeAdded.forall((Function1 & Serializable & scala.Serializable)config -> BoxesRunTime.boxToBoolean((boolean)TopicCommand$.$anonfun$parseTopicConfigsToBeAdded$3(config)));
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        if (require_requirement == false) {
            throw new IllegalArgumentException(new StringBuilder(20).append("requirement failed: ").append((Object)TopicCommand$.$anonfun$parseTopicConfigsToBeAdded$4()).toString());
        }
        Properties props = new Properties();
        configsToBeAdded.foreach((Function1 & Serializable & scala.Serializable)pair -> props.setProperty(pair[0].trim(), pair[1].trim()));
        LogConfig$.MODULE$.validate(props);
        if (props.containsKey(LogConfig$.MODULE$.MessageFormatVersionProp())) {
            Predef$.MODULE$.println((Object)new StringBuilder(165).append("WARNING: The configuration ").append(LogConfig$.MODULE$.MessageFormatVersionProp()).append("=").append(props.getProperty(LogConfig$.MODULE$.MessageFormatVersionProp())).append(" is specified. ").append("This configuration will be ignored if the version is newer than the inter.broker.protocol.version specified in the broker.").toString());
        }
        return var3_6;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> parseTopicConfigsToBeDeleted(TopicCommand.TopicCommandOptions opts) {
        void var2_4;
        Option<java.util.List<String>> option = opts.configsToDelete();
        if (option == null) {
            throw null;
        }
        Option<java.util.List<String>> getOrElse_this = option;
        Object object = getOrElse_this.isEmpty() ? TopicCommand$.$anonfun$parseTopicConfigsToBeDeleted$1() : getOrElse_this.get();
        Buffer configsToBeDeleted = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)object).asScala()).map((Function1 & Serializable & scala.Serializable)x$19 -> x$19.trim(), Buffer$.MODULE$.canBuildFrom());
        Properties propsToBeDeleted = new Properties();
        configsToBeDeleted.foreach((Function1 & Serializable & scala.Serializable)x$20 -> propsToBeDeleted.setProperty((String)x$20, ""));
        LogConfig$.MODULE$.validateNames(propsToBeDeleted);
        return var2_4;
    }

    /*
     * WARNING - void declaration
     */
    public Map<Object, List<Object>> parseReplicaAssignment(String replicaAssignmentList) {
        void var3_3;
        String[] partitionList = replicaAssignmentList.split(",");
        LinkedHashMap ret = new LinkedHashMap();
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionList)).size());
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                TopicCommand$.$anonfun$parseReplicaAssignment$1(partitionList, ret, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        return var3_3;
    }

    public java.util.Map<Integer, java.util.List<Integer>> asJavaReplicaReassignment(Map<Object, List<Object>> original) {
        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)original.map((Function1 & Serializable & scala.Serializable)f -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_$this;
            Object object;
            void map_bf;
            Object object2 = Predef$.MODULE$.ArrowAssoc((Object)f._1$mcI$sp());
            List list = (List)f._2();
            CanBuildFrom canBuildFrom = List$.MODULE$.canBuildFrom();
            Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.unboxToInt((Object)e);
            if (list == null) {
                throw null;
            }
            List map_this = list;
            if (map_bf == List$.MODULE$.ReusableCBF()) {
                if (map_this == Nil$.MODULE$) {
                    object = Nil$.MODULE$;
                } else {
                    .colon.colon map_h;
                    .colon.colon map_t = map_h = new .colon.colon((Object)BoxesRunTime.unboxToInt((Object)map_this.head()), (List)Nil$.MODULE$);
                    for (List map_rest = (List)map_this.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                        .colon.colon map_nx = new .colon.colon((Object)BoxesRunTime.unboxToInt((Object)map_rest.head()), (List)Nil$.MODULE$);
                        map_t.tl_$eq((List)map_nx);
                        map_t = map_nx;
                    }
                    object = map_h;
                }
            } else {
                void map_f;
                object = TraversableLike.map$((TraversableLike)map_this, (Function1)map_f, (CanBuildFrom)map_bf);
            }
            Object object3 = JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)object).asJava();
            Object object4 = object2;
            if (Predef.ArrowAssoc$.MODULE$ == null) {
                throw null;
            }
            return new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        }, Map$.MODULE$.canBuildFrom())).asJava();
    }

    public int kafka$admin$TopicCommand$$getReplicationFactor(TopicPartitionInfo tpi, Option<PartitionReassignment> reassignment) {
        PartitionReassignment ra;
        int n = reassignment instanceof Some && TopicCommand$.isReassignmentInProgress$1(ra = (PartitionReassignment)((Some)reassignment).value(), tpi) ? ((SeqLike)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(ra.replicas()).asScala()).diff((GenSeq)JavaConverters$.MODULE$.asScalaBufferConverter(ra.addingReplicas()).asScala())).size() : tpi.replicas().size();
        return n;
    }

    public void askToProceed() {
        Predef$.MODULE$.println((Object)"Are you sure you want to continue? [y/n]");
        if (!StdIn$.MODULE$.readLine().equalsIgnoreCase("y")) {
            Predef$.MODULE$.println((Object)"Ending your session");
            throw Exit$.MODULE$.exit(0, Exit$.MODULE$.exit$default$2());
        }
    }

    public static final /* synthetic */ String $anonfun$main$1(Throwable e$1) {
        return Utils.stackTrace((Throwable)e$1);
    }

    public static final /* synthetic */ boolean $anonfun$doGetTopics$2(boolean excludeInternalTopics$1, String x$17) {
        return Topic.isInternal((String)x$17) && excludeInternalTopics$1;
    }

    public static final /* synthetic */ java.util.List $anonfun$parseTopicConfigsToBeAdded$1() {
        return Collections.emptyList();
    }

    public static final /* synthetic */ boolean $anonfun$parseTopicConfigsToBeAdded$3(String[] config) {
        return config.length == 2;
    }

    public static final /* synthetic */ String $anonfun$parseTopicConfigsToBeAdded$4() {
        return "Invalid topic config: all configs to be added must be in the format \"key=val\".";
    }

    public static final /* synthetic */ java.util.List $anonfun$parseTopicConfigsToBeDeleted$1() {
        return Collections.emptyList();
    }

    public static final /* synthetic */ int $anonfun$parseReplicaAssignment$2(String s) {
        String string = s.trim();
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        return new StringOps(string).toInt();
    }

    public static final /* synthetic */ void $anonfun$parseReplicaAssignment$1(String[] partitionList$1, LinkedHashMap ret$1, int i) {
        int[] brokerList = (int[])TraversableLike.map$((TraversableLike)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionList$1[i].split(":"))), (Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToInteger((int)TopicCommand$.$anonfun$parseReplicaAssignment$2(s)), (CanBuildFrom)Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        Iterable duplicateBrokers = CoreUtils$.MODULE$.duplicates(Predef$.MODULE$.wrapIntArray(brokerList));
        if (duplicateBrokers.nonEmpty()) {
            throw new AdminCommandFailedException(new StringBuilder(59).append("Partition replica lists may not contain duplicate entries: ").append(duplicateBrokers.mkString(",")).toString());
        }
        ret$1.put((Object)BoxesRunTime.boxToInteger((int)i), (Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(brokerList)).toList());
        if (((SeqLike)ret$1.apply((Object)BoxesRunTime.boxToInteger((int)i))).size() != ((SeqLike)ret$1.apply((Object)BoxesRunTime.boxToInteger((int)0))).size()) {
            throw new AdminOperationException(new StringBuilder(45).append("Partition ").append(i).append(" has different replication factor: ").append(brokerList).toString());
        }
    }

    public static final /* synthetic */ int $anonfun$getReplicationFactor$2(Object x) {
        return BoxesRunTime.unboxToInt((Object)x);
    }

    private static final boolean isReassignmentInProgress$1(PartitionReassignment ra, TopicPartitionInfo tpi$1) {
        Set allReplicaIds = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(tpi$1.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToInteger((int)x$21.id()), Buffer$.MODULE$.canBuildFrom())).toSet();
        Set removingReplicaIds = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(ra.removingReplicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToInteger((int)TopicCommand$.$anonfun$getReplicationFactor$2(x)), Buffer$.MODULE$.canBuildFrom())).toSet();
        return allReplicaIds.exists((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)elem -> removingReplicaIds.contains((Object)BoxesRunTime.boxToInteger((int)elem)));
    }

    private TopicCommand$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

