/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Properties;
import kafka.utils.Exit$;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.RichInt$;
import scala.util.Random;

public final class EndToEndLatency$ {
    public static EndToEndLatency$ MODULE$;
    private final long timeout;
    private final short defaultReplicationFactor;
    private final int defaultNumPartitions;

    static {
        new EndToEndLatency$();
    }

    private long timeout() {
        return this.timeout;
    }

    private short defaultReplicationFactor() {
        return this.defaultReplicationFactor;
    }

    private int defaultNumPartitions() {
        return this.defaultNumPartitions;
    }

    public void main(String[] args) {
        None$ propsFile;
        None$ none$;
        if (args.length != 5 && args.length != 6) {
            System.err.println(new StringBuilder(103).append("USAGE: java ").append(this.getClass().getName()).append(" broker_list topic num_messages producer_acks message_size_bytes [optional] properties_file").toString());
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
        String brokerList = args[0];
        String topic = args[1];
        String string = args[2];
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        int numMessages = new StringOps(string).toInt();
        String producerAcks = args[3];
        String string2 = args[4];
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        int messageLen = new StringOps(string2).toInt();
        if (args.length > 5) {
            Some filter_this = new Some((Object)args[5]);
            Object object = filter_this.isEmpty() || EndToEndLatency$.$anonfun$main$1((String)filter_this.get()) ? filter_this : None$.MODULE$;
            none$ = object;
        } else {
            none$ = propsFile = None$.MODULE$;
        }
        if (!new .colon.colon((Object)"1", (List)new .colon.colon((Object)"all", (List)Nil$.MODULE$)).contains((Object)producerAcks)) {
            throw new IllegalArgumentException("Latency testing requires synchronous acknowledgement. Please use 1 or all");
        }
        Properties consumerProps = EndToEndLatency$.loadPropsWithBootstrapServers$1((Option)propsFile, brokerList);
        consumerProps.put("group.id", new StringBuilder(11).append("test-group-").append(System.currentTimeMillis()).toString());
        consumerProps.put("enable.auto.commit", "false");
        consumerProps.put("auto.offset.reset", "latest");
        consumerProps.put("key.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        consumerProps.put("value.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
        consumerProps.put("fetch.max.wait.ms", "0");
        KafkaConsumer consumer = new KafkaConsumer(consumerProps);
        Properties producerProps = EndToEndLatency$.loadPropsWithBootstrapServers$1((Option)propsFile, brokerList);
        producerProps.put("linger.ms", "0");
        producerProps.put("max.block.ms", ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        producerProps.put("acks", producerAcks.toString());
        producerProps.put("key.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        producerProps.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        KafkaProducer producer = new KafkaProducer(producerProps);
        if (!consumer.listTopics().containsKey(topic)) {
            try {
                this.createTopic(topic, EndToEndLatency$.loadPropsWithBootstrapServers$1((Option)propsFile, brokerList));
            }
            catch (Throwable t) {
                EndToEndLatency$.finalise$1(consumer, producer);
                throw new RuntimeException(new StringBuilder(23).append("Failed to create topic ").append(topic).toString(), t);
            }
        }
        java.util.List topicPartitions = (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(consumer.partitionsFor(topic)).asScala()).map((Function1 & Serializable & scala.Serializable)p -> new TopicPartition(p.topic(), p.partition()), Buffer$.MODULE$.canBuildFrom())).asJava();
        consumer.assign((Collection)topicPartitions);
        consumer.seekToEnd((Collection)topicPartitions);
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(consumer.assignment()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)consumer.position(x$1)));
        DoubleRef totalTime = DoubleRef.create((double)0.0);
        long[] latencies = new long[numMessages];
        Random random = new Random(0);
        int n = 0;
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Range range = RichInt$.MODULE$.until$extension0(n, numMessages);
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                EndToEndLatency$.$anonfun$main$6(random, messageLen, producer, topic, consumer, totalTime, latencies, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        String string3 = "Avg latency: %.4f ms\n";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Predef$.MODULE$.println((Object)new StringOps(string3).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(totalTime.elem / (double)numMessages / 1000.0 / 1000.0))})));
        Arrays.sort(latencies);
        long p50 = latencies[(int)((double)latencies.length * 0.5)];
        long p99 = latencies[(int)((double)latencies.length * 0.99)];
        long p999 = latencies[(int)((double)latencies.length * 0.999)];
        String string4 = "Percentiles: 50th = %d, 99th = %d, 99.9th = %d";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Predef$.MODULE$.println((Object)new StringOps(string4).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)p50), BoxesRunTime.boxToLong((long)p99), BoxesRunTime.boxToLong((long)p999)})));
        EndToEndLatency$.finalise$1(consumer, producer);
    }

    /*
     * WARNING - void declaration
     */
    public byte[] randomBytesOfLen(Random random, int len) {
        void fill_evidence$9;
        Array$ array$ = Array$.MODULE$;
        ClassTag classTag = ClassTag$.MODULE$.Byte();
        if (array$ == null) {
            throw null;
        }
        ArrayBuilder fill_b = array$.newBuilder((ClassTag)fill_evidence$9);
        fill_b.sizeHint(len);
        for (int fill_i = 0; fill_i < len; ++fill_i) {
            fill_b.$plus$eq((Object)BoxesRunTime.boxToByte((byte)EndToEndLatency$.$anonfun$randomBytesOfLen$1(random)));
        }
        return (byte[])fill_b.result();
    }

    public void createTopic(String topic, Properties props) {
        String string = "Topic \"%s\" does not exist. Will create topic with %d partition(s) and replication factor = %d";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        Predef$.MODULE$.println((Object)new StringOps(string).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)this.defaultNumPartitions()), BoxesRunTime.boxToShort((short)this.defaultReplicationFactor())})));
        AdminClient adminClient = AdminClient.create((Properties)props);
        NewTopic newTopic = new NewTopic(topic, this.defaultNumPartitions(), this.defaultReplicationFactor());
        try {
            adminClient.createTopics(Collections.singleton(newTopic)).all().get();
        }
        finally {
            Utils.closeQuietly((AutoCloseable)adminClient, (String)"AdminClient");
        }
    }

    public static final /* synthetic */ boolean $anonfun$main$1(String x$1) {
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        return new StringOps(x$1).nonEmpty();
    }

    public static final /* synthetic */ Properties $anonfun$main$2(String x$1) {
        return Utils.loadProps((String)x$1);
    }

    public static final /* synthetic */ Properties $anonfun$main$3() {
        return new Properties();
    }

    /*
     * WARNING - void declaration
     */
    private static final Properties loadPropsWithBootstrapServers$1(Option propsFile$1, String brokerList$1) {
        void var2_4;
        if (propsFile$1 == null) {
            throw null;
        }
        Object object = propsFile$1.isEmpty() ? None$.MODULE$ : new Some((Object)EndToEndLatency$.$anonfun$main$2((String)propsFile$1.get()));
        if (object == null) {
            throw null;
        }
        Object object2 = object.isEmpty() ? EndToEndLatency$.$anonfun$main$3() : object.get();
        Properties props = (Properties)object2;
        props.put("bootstrap.servers", brokerList$1);
        return var2_4;
    }

    private static final void finalise$1(KafkaConsumer consumer$1, KafkaProducer producer$1) {
        consumer$1.commitSync();
        producer$1.close();
        consumer$1.close();
    }

    public static final /* synthetic */ void $anonfun$main$6(Random random$1, int messageLen$1, KafkaProducer producer$1, String topic$1, KafkaConsumer consumer$1, DoubleRef totalTime$1, long[] latencies$1, int i) {
        byte[] message = MODULE$.randomBytesOfLen(random$1, messageLen$1);
        long begin = System.nanoTime();
        producer$1.send(new ProducerRecord(topic$1, (Object)message)).get();
        Iterator recordIter = consumer$1.poll(Duration.ofMillis(MODULE$.timeout())).iterator();
        long elapsed = System.nanoTime() - begin;
        if (!recordIter.hasNext()) {
            EndToEndLatency$.finalise$1(consumer$1, producer$1);
            throw new RuntimeException(new StringBuilder(53).append("poll() timed out before finding a result (timeout:[").append(MODULE$.timeout()).append("])").toString());
        }
        String sent = new String(message, StandardCharsets.UTF_8);
        String read = new String((byte[])((ConsumerRecord)recordIter.next()).value(), StandardCharsets.UTF_8);
        if (!read.equals(sent)) {
            EndToEndLatency$.finalise$1(consumer$1, producer$1);
            throw new RuntimeException(new StringBuilder(53).append("The message read [").append(read).append("] did not match the message sent [").append(sent).append("]").toString());
        }
        if (recordIter.hasNext()) {
            int count = 1 + ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(recordIter).asScala()).size();
            throw new RuntimeException(new StringBuilder(58).append("Only one result was expected during this test. We found [").append(count).append("]").toString());
        }
        if (i % 1000 == 0) {
            Predef$.MODULE$.println((Object)new StringBuilder(1).append(i).append("\t").append((double)elapsed / 1000.0 / 1000.0).toString());
        }
        totalTime$1.elem += (double)elapsed;
        latencies$1[i] = elapsed / 1000L / 1000L;
    }

    public static final /* synthetic */ byte $anonfun$randomBytesOfLen$1(Random random$2) {
        return (byte)(random$2.nextInt(26) + 65);
    }

    private EndToEndLatency$() {
        MODULE$ = this;
        this.timeout = 60000L;
        this.defaultReplicationFactor = 1;
        this.defaultNumPartitions = 1;
    }

    public static final /* synthetic */ Object $anonfun$main$1$adapted(String x$1) {
        return BoxesRunTime.boxToBoolean((boolean)EndToEndLatency$.$anonfun$main$1(x$1));
    }
}

