/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.admin.ConsumerGroupCommand;
import kafka.admin.ConsumerGroupCommand$ConsumerGroupService$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Logging;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class ConsumerGroupCommand$
implements Logging {
    public static final ConsumerGroupCommand$ MODULE$ = new ConsumerGroupCommand$();
    private static final String MISSING_COLUMN_VALUE;
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$(MODULE$);
        MISSING_COLUMN_VALUE = "-";
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ConsumerGroupCommand$ consumerGroupCommand$ = this;
        synchronized (consumerGroupCommand$) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        return !bitmap$0 ? this.logger$lzycompute() : logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public void main(String[] args) {
        ConsumerGroupCommand.ConsumerGroupCommandOptions opts = new ConsumerGroupCommand.ConsumerGroupCommandOptions(args);
        CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(opts, "This tool helps to list all consumer groups, describe a consumer group, delete consumer group info, or reset consumer group offsets.");
        OptionSet optionSet = opts.options();
        int actions = Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OptionSpecBuilder[]{opts.listOpt(), opts.describeOpt(), opts.deleteOpt(), opts.resetOffsetsOpt(), opts.deleteOffsetsOpt()})).count((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)optionSet.has(x$1)));
        if (actions != 1) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "Command must include exactly one action: --list, --describe, --delete, --reset-offsets, --delete-offsets");
        }
        opts.checkArgs();
        try (ConsumerGroupCommand.ConsumerGroupService consumerGroupService = new ConsumerGroupCommand.ConsumerGroupService(opts, ConsumerGroupCommand$ConsumerGroupService$.MODULE$.$lessinit$greater$default$2());){
            try {
                if (opts.options().has((OptionSpec)opts.listOpt())) {
                    consumerGroupService.listGroups().foreach((Function1 & Serializable)x$1 -> {
                        Predef$.MODULE$.println((Object)x$1);
                        return BoxedUnit.UNIT;
                    });
                } else if (opts.options().has((OptionSpec)opts.describeOpt())) {
                    consumerGroupService.describeGroups();
                } else if (opts.options().has((OptionSpec)opts.deleteOpt())) {
                    consumerGroupService.deleteGroups();
                } else if (opts.options().has((OptionSpec)opts.resetOffsetsOpt())) {
                    Map<String, Map<TopicPartition, OffsetAndMetadata>> offsetsToReset = consumerGroupService.resetOffsets();
                    if (opts.options().has((OptionSpec)opts.exportOpt())) {
                        String exported = consumerGroupService.exportOffsetsToCsv(offsetsToReset);
                        Predef$.MODULE$.println((Object)exported);
                    } else {
                        this.printOffsetsToReset(offsetsToReset);
                    }
                } else if (opts.options().has((OptionSpec)opts.deleteOffsetsOpt())) {
                    consumerGroupService.deleteOffsets();
                }
            }
            catch (Throwable e) {
                this.printError(new StringBuilder(47).append("Executing consumer group command failed due to ").append(e.getMessage()).toString(), (Option<Throwable>)new Some((Object)e));
            }
        }
    }

    public String MISSING_COLUMN_VALUE() {
        return MISSING_COLUMN_VALUE;
    }

    public void printError(String msg, Option<Throwable> e) {
        Predef$.MODULE$.println((Object)new StringBuilder(8).append("\nError: ").append(msg).toString());
        e.foreach((Function1 & Serializable)x$2 -> {
            x$2.printStackTrace();
            return BoxedUnit.UNIT;
        });
    }

    public Option<Throwable> printError$default$2() {
        return None$.MODULE$;
    }

    public Long convertTimestamp(String timeString) {
        Date date;
        String string = timeString;
        String string2 = string.split("T")[1].contains("+") || string.split("T")[1].contains("-") || string.split("T")[1].contains("Z") ? string.toString() : new StringBuilder(1).append(string).append("Z").toString();
        String datetime = string2;
        try {
            date = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX").parse(datetime);
        }
        catch (ParseException parseException) {
            date = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX").parse(datetime);
        }
        Date date2 = date;
        return Predef$.MODULE$.long2Long(date2.getTime());
    }

    public void printOffsetsToReset(Map<String, Map<TopicPartition, OffsetAndMetadata>> groupAssignmentsToReset) {
        if (groupAssignmentsToReset.nonEmpty()) {
            Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\n%-30s %-30s %-10s %-15s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"GROUP", "TOPIC", "PARTITION", "NEW-OFFSET"})));
        }
        groupAssignmentsToReset.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ConsumerGroupCommand$.$anonfun$printOffsetsToReset$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$4 -> {
            ConsumerGroupCommand$.$anonfun$printOffsetsToReset$2(x$4);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$printOffsetsToReset$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$printOffsetsToReset$3(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$printOffsetsToReset$4(String groupId$1, Tuple2 x$3) {
        Tuple2 tuple2 = x$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition consumerAssignment = (TopicPartition)tuple2._1();
        OffsetAndMetadata offsetAndMetadata = (OffsetAndMetadata)tuple2._2();
        Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%-30s %-30s %-10s %-15s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{groupId$1, consumerAssignment.topic(), BoxesRunTime.boxToInteger((int)consumerAssignment.partition()), BoxesRunTime.boxToLong((long)offsetAndMetadata.offset())})));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$printOffsetsToReset$2(Tuple2 x$4) {
        Tuple2 tuple2 = x$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String groupId = (String)tuple2._1();
        Map assignment = (Map)tuple2._2();
        assignment.withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)ConsumerGroupCommand$.$anonfun$printOffsetsToReset$3(check$ifrefutable$2))).foreach((Function1 & Serializable)x$3 -> {
            ConsumerGroupCommand$.$anonfun$printOffsetsToReset$4(groupId, x$3);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private ConsumerGroupCommand$() {
    }
}

