/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.admin.ZkSecurityMigrator;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Logging;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public final class ZkSecurityMigrator$
implements Logging {
    public static final ZkSecurityMigrator$ MODULE$ = new ZkSecurityMigrator$();
    private static final String usageMessage;
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$(MODULE$);
        usageMessage = "ZooKeeper Migration Tool Help. This tool updates the ACLs of znodes as part of the process of setting up ZooKeeper authentication.";
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ZkSecurityMigrator$ zkSecurityMigrator$ = this;
        synchronized (zkSecurityMigrator$) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        return !bitmap$0 ? this.logger$lzycompute() : logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public String usageMessage() {
        return usageMessage;
    }

    public void run(String[] args) {
        boolean bl;
        String jaasFile = System.getProperty("java.security.auth.login.config");
        ZkSecurityMigrator.ZkSecurityMigratorOptions opts = new ZkSecurityMigrator.ZkSecurityMigratorOptions(args);
        CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(opts, this.usageMessage());
        if (jaasFile == null) {
            String errorMsg = new StringBuilder(82).append("No JAAS configuration file has been specified. Please make sure that you have set ").append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("the system property %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"java.security.auth.login.config"}))).toString();
            System.out.println(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("ERROR: %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{errorMsg})));
            throw new IllegalArgumentException("Incorrect configuration");
        }
        if (!JaasUtils.isZkSecurityEnabled()) {
            String errorMsg = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Security isn't enabled, most likely the file isn't set properly: %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{jaasFile}));
            System.out.println(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("ERROR: %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{errorMsg})));
            throw new IllegalArgumentException("Incorrect configuration");
        }
        String string = (String)opts.options().valueOf(opts.zkAclOpt());
        if ("secure".equals(string)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "zookeeper.acl option is secure");
            bl = true;
        } else if ("unsecure".equals(string)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "zookeeper.acl option is unsecure");
            bl = false;
        } else {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), this.usageMessage());
        }
        boolean zkAcl = bl;
        String zkUrl = (String)opts.options().valueOf(opts.zkUrlOpt());
        int zkSessionTimeout = (Integer)opts.options().valueOf(opts.zkSessionTimeoutOpt());
        int zkConnectionTimeout = (Integer)opts.options().valueOf(opts.zkConnectionTimeoutOpt());
        KafkaZkClient zkClient = KafkaZkClient$.MODULE$.apply(zkUrl, zkAcl, zkSessionTimeout, zkConnectionTimeout, Integer.MAX_VALUE, Time.SYSTEM, KafkaZkClient$.MODULE$.apply$default$7(), KafkaZkClient$.MODULE$.apply$default$8(), KafkaZkClient$.MODULE$.apply$default$9());
        ZkSecurityMigrator migrator = new ZkSecurityMigrator(zkClient);
        migrator.kafka$admin$ZkSecurityMigrator$$run();
    }

    public void main(String[] args) {
        try {
            this.run(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ZkSecurityMigrator$() {
    }
}

