/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.controller.ControllerContext;
import kafka.controller.DeletionClient;
import kafka.controller.NonExistentPartition$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.PartitionStateMachine;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaStateMachine;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\re\u0001B\u000e\u001d\u0001\u0005B\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\tk\u0001\u0011\t\u0011)A\u0005m!A!\b\u0001B\u0001B\u0003%1\b\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003@\u0011!\u0011\u0005A!A!\u0002\u0013\u0019\u0005\"\u0002$\u0001\t\u00039\u0005b\u0002(\u0001\u0005\u0004%\ta\u0014\u0005\u0007'\u0002\u0001\u000b\u0011\u0002)\t\u000bQ\u0003A\u0011A+\t\u000b9\u0004A\u0011A8\t\u000bA\u0004A\u0011A9\t\u000bQ\u0004A\u0011A;\t\u000f]\u0004\u0011\u0013!C\u0001q\"9\u0011q\u0001\u0001\u0005\u0002\u0005%\u0001bBA\f\u0001\u0011\u0005\u0011\u0011\u0004\u0005\b\u0003O\u0001A\u0011BA\u0015\u0011\u001d\ty\u0003\u0001C\u0005\u0003cAq!!\u000e\u0001\t\u0003\t9\u0004C\u0004\u0002<\u0001!\t!!\u0010\t\u000f\u0005\u0005\u0003\u0001\"\u0003\u0002D!9\u0011q\t\u0001\u0005\n\u0005%\u0003bBA'\u0001\u0011%\u0011q\n\u0005\b\u0003'\u0002A\u0011BA+\u0011\u001d\tI\u0006\u0001C\u0005\u00037Bq!!\u0019\u0001\t\u0013\t\u0019\u0007\u0003\u0004\u0002\u0002\u0002!Ia\u001c\u0002\u0015)>\u0004\u0018n\u0019#fY\u0016$\u0018n\u001c8NC:\fw-\u001a:\u000b\u0005uq\u0012AC2p]R\u0014x\u000e\u001c7fe*\tq$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001\u0011\u0003\u0006\u0005\u0002$M5\tAEC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9CE\u0001\u0004B]f\u0014VM\u001a\t\u0003S1j\u0011A\u000b\u0006\u0003Wy\tQ!\u001e;jYNL!!\f\u0016\u0003\u000f1{wmZ5oO\u000611m\u001c8gS\u001e\u0004\"\u0001M\u001a\u000e\u0003ER!A\r\u0010\u0002\rM,'O^3s\u0013\t!\u0014GA\u0006LC\u001a\\\u0017mQ8oM&<\u0017!E2p]R\u0014x\u000e\u001c7fe\u000e{g\u000e^3yiB\u0011q\u0007O\u0007\u00029%\u0011\u0011\b\b\u0002\u0012\u0007>tGO]8mY\u0016\u00148i\u001c8uKb$\u0018a\u0005:fa2L7-Y*uCR,W*Y2iS:,\u0007CA\u001c=\u0013\tiDDA\nSKBd\u0017nY1Ti\u0006$X-T1dQ&tW-A\u000bqCJ$\u0018\u000e^5p]N#\u0018\r^3NC\u000eD\u0017N\\3\u0011\u0005]\u0002\u0015BA!\u001d\u0005U\u0001\u0016M\u001d;ji&|gn\u0015;bi\u0016l\u0015m\u00195j]\u0016\faa\u00197jK:$\bCA\u001cE\u0013\t)ED\u0001\bEK2,G/[8o\u00072LWM\u001c;\u0002\rqJg.\u001b;?)\u0019A\u0015JS&M\u001bB\u0011q\u0007\u0001\u0005\u0006]\u0019\u0001\ra\f\u0005\u0006k\u0019\u0001\rA\u000e\u0005\u0006u\u0019\u0001\ra\u000f\u0005\u0006}\u0019\u0001\ra\u0010\u0005\u0006\u0005\u001a\u0001\raQ\u0001\u0015SN$U\r\\3uKR{\u0007/[2F]\u0006\u0014G.\u001a3\u0016\u0003A\u0003\"aI)\n\u0005I##a\u0002\"p_2,\u0017M\\\u0001\u0016SN$U\r\\3uKR{\u0007/[2F]\u0006\u0014G.\u001a3!\u0003\u0011Ig.\u001b;\u0015\u0007YKF\u000e\u0005\u0002$/&\u0011\u0001\f\n\u0002\u0005+:LG\u000fC\u0003[\u0013\u0001\u00071,\u0001\rj]&$\u0018.\u00197U_BL7m\u001d+p\u0005\u0016$U\r\\3uK\u0012\u00042\u0001X0b\u001b\u0005i&B\u00010%\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003Av\u00131aU3u!\t\u0011\u0017N\u0004\u0002dOB\u0011A\rJ\u0007\u0002K*\u0011a\rI\u0001\u0007yI|w\u000e\u001e \n\u0005!$\u0013A\u0002)sK\u0012,g-\u0003\u0002kW\n11\u000b\u001e:j]\u001eT!\u0001\u001b\u0013\t\u000b5L\u0001\u0019A.\u0002E%t\u0017\u000e^5bYR{\u0007/[2t\u0013:,G.[4jE2,gi\u001c:EK2,G/[8o\u0003A!(/\u001f+pa&\u001cG)\u001a7fi&|g\u000eF\u0001W\u0003a)g.];fk\u0016$v\u000e]5dg\u001a{'\u000fR3mKRLwN\u001c\u000b\u0003-JDQa]\u0006A\u0002m\u000ba\u0001^8qS\u000e\u001c\u0018a\u0006:fgVlW\rR3mKRLwN\u001c$peR{\u0007/[2t)\t1f\u000fC\u0004t\u0019A\u0005\t\u0019A.\u0002CI,7/^7f\t\u0016dW\r^5p]\u001a{'\u000fV8qS\u000e\u001cH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003eT#a\u0017>,\u0003m\u00042\u0001`A\u0002\u001b\u0005i(B\u0001@\u0000\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0002\u0011\n!\"\u00198o_R\fG/[8o\u0013\r\t)! \u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017a\u00054bS2\u0014V\r\u001d7jG\u0006$U\r\\3uS>tGc\u0001,\u0002\f!9\u0011Q\u0002\bA\u0002\u0005=\u0011\u0001\u0003:fa2L7-Y:\u0011\tq{\u0016\u0011\u0003\t\u0004o\u0005M\u0011bAA\u000b9\t\u0019\u0002+\u0019:uSRLwN\\!oIJ+\u0007\u000f\\5dC\u0006qR.\u0019:l)>\u0004\u0018nY%oK2Lw-\u001b2mK\u001a{'\u000fR3mKRLwN\u001c\u000b\u0006-\u0006m\u0011Q\u0004\u0005\u0006g>\u0001\ra\u0017\u0005\t\u0003?yA\u00111\u0001\u0002\"\u00051!/Z1t_:\u0004BaIA\u0012C&\u0019\u0011Q\u0005\u0013\u0003\u0011q\u0012\u0017P\\1nKz\nA$[:U_BL7-\u00138fY&<\u0017N\u00197f\r>\u0014H)\u001a7fi&|g\u000eF\u0002Q\u0003WAa!!\f\u0011\u0001\u0004\t\u0017!\u0002;pa&\u001c\u0017!G5t)>\u0004\u0018n\u0019#fY\u0016$\u0018n\u001c8J]B\u0013xn\u001a:fgN$2\u0001UA\u001a\u0011\u0019\ti#\u0005a\u0001C\u0006Q\u0012n\u001d+pa&\u001c\u0017+^3vK\u0012,\u0006OR8s\t\u0016dW\r^5p]R\u0019\u0001+!\u000f\t\r\u00055\"\u00031\u0001b\u0003]\u0019w.\u001c9mKR,'+\u001a9mS\u000e\fG)\u001a7fi&|g\u000eF\u0002W\u0003\u007fAq!!\u0004\u0014\u0001\u0004\ty!\u0001\u000ejgR{\u0007/[2FY&<\u0017N\u00197f\r>\u0014H)\u001a7fi&|g\u000eF\u0002Q\u0003\u000bBa!!\f\u0015\u0001\u0004\t\u0017A\t:fiJLH)\u001a7fi&|gNR8s\u0013:,G.[4jE2,'+\u001a9mS\u000e\f7\u000fF\u0002W\u0003\u0017Ba!!\f\u0016\u0001\u0004\t\u0017aE2p[BdW\r^3EK2,G/\u001a+pa&\u001cGc\u0001,\u0002R!1\u0011Q\u0006\fA\u0002\u0005\fqb\u001c8U_BL7\rR3mKRLwN\u001c\u000b\u0004-\u0006]\u0003\"B:\u0018\u0001\u0004Y\u0016\u0001F:uCJ$(+\u001a9mS\u000e\fG)\u001a7fi&|g\u000eF\u0002W\u0003;Bq!a\u0018\u0019\u0001\u0004\ty!\u0001\u000fsKBd\u0017nY1t\r>\u0014Hk\u001c9jGN$vNQ3EK2,G/\u001a3\u0002'=t\u0007+\u0019:uSRLwN\u001c#fY\u0016$\u0018n\u001c8\u0015\u0007Y\u000b)\u0007C\u0004\u0002he\u0001\r!!\u001b\u0002+A\f'\u000f^5uS>t7\u000fV8CK\u0012+G.\u001a;fIB!AlXA6!\u0011\ti'! \u000e\u0005\u0005=$\u0002BA9\u0003g\naaY8n[>t'bA\u0010\u0002v)!\u0011qOA=\u0003\u0019\t\u0007/Y2iK*\u0011\u00111P\u0001\u0004_J<\u0017\u0002BA@\u0003_\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\bsKN,X.\u001a#fY\u0016$\u0018n\u001c8t\u0001")
public class TopicDeletionManager
implements Logging {
    private final ControllerContext controllerContext;
    private final ReplicaStateMachine replicaStateMachine;
    private final PartitionStateMachine partitionStateMachine;
    private final DeletionClient client;
    private final boolean isDeleteTopicEnabled;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        TopicDeletionManager topicDeletionManager = this;
        synchronized (topicDeletionManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public boolean isDeleteTopicEnabled() {
        return this.isDeleteTopicEnabled;
    }

    public void init(Set<String> initialTopicsToBeDeleted, Set<String> initialTopicsIneligibleForDeletion) {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(47).append("Initializing manager with initial deletions: ").append(initialTopicsToBeDeleted).append(", ").toString()).append(new StringBuilder(30).append("initial ineligible deletions: ").append(initialTopicsIneligibleForDeletion).toString()).toString());
        if (this.isDeleteTopicEnabled()) {
            this.controllerContext.queueTopicDeletion(initialTopicsToBeDeleted);
            this.controllerContext.topicsIneligibleForDeletion().$plus$plus$eq((IterableOnce)initialTopicsIneligibleForDeletion.$amp(this.controllerContext.topicsToBeDeleted()));
        } else {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(40).append("Removing ").append(initialTopicsToBeDeleted).append(" since delete topic is disabled").toString());
            this.client.deleteTopicDeletions((scala.collection.immutable.Seq<String>)initialTopicsToBeDeleted.toSeq(), this.controllerContext.epochZkVersion());
        }
    }

    public void tryTopicDeletion() {
        block0: {
            if (!this.isDeleteTopicEnabled()) break block0;
            this.resumeDeletions();
        }
    }

    public void enqueueTopicsForDeletion(Set<String> topics) {
        block0: {
            if (!this.isDeleteTopicEnabled()) break block0;
            this.controllerContext.queueTopicDeletion(topics);
            this.resumeDeletions();
        }
    }

    public void resumeDeletionForTopics(Set<String> topics) {
        block0: {
            Set topicsToResumeDeletion;
            if (!this.isDeleteTopicEnabled() || !(topicsToResumeDeletion = (Set)topics.$amp(this.controllerContext.topicsToBeDeleted())).nonEmpty()) break block0;
            this.controllerContext.topicsIneligibleForDeletion().$minus$minus$eq((IterableOnce)topicsToResumeDeletion);
            this.resumeDeletions();
        }
    }

    public Set<String> resumeDeletionForTopics$default$1() {
        return (Set)Set$.MODULE$.empty();
    }

    public void failReplicaDeletion(Set<PartitionAndReplica> replicas) {
        block0: {
            Set replicasThatFailedToDelete;
            if (!this.isDeleteTopicEnabled() || !(replicasThatFailedToDelete = (Set)replicas.filter((Function1 & Serializable)r -> BoxesRunTime.boxToBoolean((boolean)this.isTopicQueuedUpForDeletion(r.topic())))).nonEmpty()) break block0;
            Set topics = (Set)replicasThatFailedToDelete.map((Function1 & Serializable)x$1 -> x$1.topic());
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(59).append("Deletion failed for replicas ").append(replicasThatFailedToDelete.mkString(",")).append(". Halting deletion for topics ").append(topics).toString());
            this.replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)replicasThatFailedToDelete.toSeq(), ReplicaDeletionIneligible$.MODULE$);
            this.markTopicIneligibleForDeletion((Set<String>)topics, (Function0<String>)(Function0 & Serializable)() -> "replica deletion failure");
            this.resumeDeletions();
        }
    }

    public void markTopicIneligibleForDeletion(Set<String> topics, Function0<String> reason) {
        block1: {
            if (!this.isDeleteTopicEnabled()) break block1;
            scala.collection.mutable.Set newTopicsToHaltDeletion = (scala.collection.mutable.Set)this.controllerContext.topicsToBeDeleted().$amp(topics);
            this.controllerContext.topicsIneligibleForDeletion().$plus$plus$eq((IterableOnce)newTopicsToHaltDeletion);
            if (newTopicsToHaltDeletion.nonEmpty()) {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(34).append("Halted deletion of topics ").append(newTopicsToHaltDeletion.mkString(",")).append(" due to ").append(reason.apply()).toString());
            }
        }
    }

    private boolean isTopicIneligibleForDeletion(String topic) {
        return this.isDeleteTopicEnabled() ? this.controllerContext.topicsIneligibleForDeletion().contains((Object)topic) : true;
    }

    private boolean isTopicDeletionInProgress(String topic) {
        return this.isDeleteTopicEnabled() ? this.controllerContext.isAnyReplicaInState(topic, ReplicaDeletionStarted$.MODULE$) : false;
    }

    public boolean isTopicQueuedUpForDeletion(String topic) {
        return this.isDeleteTopicEnabled() ? this.controllerContext.isTopicQueuedUpForDeletion(topic) : false;
    }

    public void completeReplicaDeletion(Set<PartitionAndReplica> replicas) {
        Set successfullyDeletedReplicas = (Set)replicas.filter((Function1 & Serializable)r -> BoxesRunTime.boxToBoolean((boolean)this.isTopicQueuedUpForDeletion(r.topic())));
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Deletion successfully completed for replicas ").append(successfullyDeletedReplicas.mkString(",")).toString());
        this.replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)successfullyDeletedReplicas.toSeq(), ReplicaDeletionSuccessful$.MODULE$);
        this.resumeDeletions();
    }

    private boolean isTopicEligibleForDeletion(String topic) {
        return this.controllerContext.isTopicQueuedUpForDeletion(topic) && !this.isTopicDeletionInProgress(topic) && !this.isTopicIneligibleForDeletion(topic);
    }

    private void retryDeletionForIneligibleReplicas(String topic) {
        Set<PartitionAndReplica> failedReplicas = this.controllerContext.replicasInState(topic, ReplicaDeletionIneligible$.MODULE$);
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(73).append("Retrying deletion of topic ").append(topic).append(" since replicas ").append(failedReplicas.mkString(",")).append(" were not successfully deleted").toString());
        this.replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)failedReplicas.toSeq(), OfflineReplica$.MODULE$);
    }

    private void completeDeleteTopic(String topic) {
        this.client.mutePartitionModifications(topic);
        Set<PartitionAndReplica> replicasForDeletedTopic = this.controllerContext.replicasInState(topic, ReplicaDeletionSuccessful$.MODULE$);
        this.replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)replicasForDeletedTopic.toSeq(), NonExistentReplica$.MODULE$);
        this.controllerContext.topicsToBeDeleted().$minus$eq((Object)topic);
        this.controllerContext.topicsWithDeletionStarted().$minus$eq((Object)topic);
        this.client.deleteTopic(topic, this.controllerContext.epochZkVersion());
        this.controllerContext.removeTopic(topic);
    }

    private void onTopicDeletion(Set<String> topics) {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(28).append("Topic deletion callback for ").append(topics.mkString(",")).toString());
        Set partitions = (Set)topics.flatMap((Function1 & Serializable)topic -> $this.controllerContext.partitionsForTopic((String)topic));
        Set unseenTopicsForDeletion = (Set)topics.$minus$minus(this.controllerContext.topicsWithDeletionStarted());
        if (unseenTopicsForDeletion.nonEmpty()) {
            Set unseenPartitionsForDeletion = (Set)unseenTopicsForDeletion.flatMap((Function1 & Serializable)topic -> $this.controllerContext.partitionsForTopic((String)topic));
            this.partitionStateMachine.handleStateChanges((Seq<TopicPartition>)unseenPartitionsForDeletion.toSeq(), OfflinePartition$.MODULE$);
            this.partitionStateMachine.handleStateChanges((Seq<TopicPartition>)unseenPartitionsForDeletion.toSeq(), NonExistentPartition$.MODULE$);
            this.controllerContext.beginTopicDeletion((Set<String>)unseenTopicsForDeletion);
        }
        this.client.sendMetadataUpdate((Set<TopicPartition>)partitions);
        topics.foreach((Function1 & Serializable)topic -> {
            this.onPartitionDeletion(this.controllerContext.partitionsForTopic(topic));
            return BoxedUnit.UNIT;
        });
    }

    private void startReplicaDeletion(Set<PartitionAndReplica> replicasForTopicsToBeDeleted) {
        replicasForTopicsToBeDeleted.groupBy((Function1 & Serializable)x$2 -> x$2.topic()).keys().foreach((Function1 & Serializable)topic -> {
            TopicDeletionManager.$anonfun$startReplicaDeletion$2(this, replicasForTopicsToBeDeleted, topic);
            return BoxedUnit.UNIT;
        });
    }

    private void onPartitionDeletion(Set<TopicPartition> partitionsToBeDeleted) {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(32).append("Partition deletion callback for ").append(partitionsToBeDeleted.mkString(",")).toString());
        Set<PartitionAndReplica> replicasPerPartition = this.controllerContext.replicasForPartition(partitionsToBeDeleted);
        this.startReplicaDeletion(replicasPerPartition);
    }

    private void resumeDeletions() {
        Set topicsQueuedForDeletion = (Set)((SetOps)Set$.MODULE$.empty()).$plus$plus(this.controllerContext.topicsToBeDeleted());
        if (topicsQueuedForDeletion.nonEmpty()) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(29).append("Handling deletion for topics ").append(topicsQueuedForDeletion.mkString(",")).toString());
        }
        topicsQueuedForDeletion.foreach((Function1 & Serializable)topic -> {
            TopicDeletionManager.$anonfun$resumeDeletions$2(this, topic);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$startReplicaDeletion$3(String topic$2, PartitionAndReplica p) {
        String string = p.topic();
        String string2 = topic$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$startReplicaDeletion$2(TopicDeletionManager $this, Set replicasForTopicsToBeDeleted$1, String topic) {
        block0: {
            Set aliveReplicasForTopic = (Set)$this.controllerContext.allLiveReplicas().filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TopicDeletionManager.$anonfun$startReplicaDeletion$3(topic, p)));
            Set deadReplicasForTopic = (Set)replicasForTopicsToBeDeleted$1.$minus$minus((IterableOnce)aliveReplicasForTopic);
            Set<PartitionAndReplica> successfullyDeletedReplicas = $this.controllerContext.replicasInState(topic, ReplicaDeletionSuccessful$.MODULE$);
            Set replicasForDeletionRetry = (Set)aliveReplicasForTopic.$minus$minus(successfullyDeletedReplicas);
            $this.replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)deadReplicasForTopic.toSeq(), ReplicaDeletionIneligible$.MODULE$);
            $this.replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)replicasForDeletionRetry.toSeq(), OfflineReplica$.MODULE$);
            $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("Deletion started for replicas ").append(replicasForDeletionRetry.mkString(",")).toString());
            $this.replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)replicasForDeletionRetry.toSeq(), ReplicaDeletionStarted$.MODULE$);
            if (!deadReplicasForTopic.nonEmpty()) break block0;
            $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Dead Replicas (").append(deadReplicasForTopic.mkString(",")).append(") found for topic ").append(topic).toString());
            $this.markTopicIneligibleForDeletion((Set<String>)((Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic}))), (Function0<String>)(Function0 & Serializable)() -> "offline replicas");
        }
    }

    public static final /* synthetic */ void $anonfun$resumeDeletions$2(TopicDeletionManager $this, String topic) {
        block3: {
            if ($this.controllerContext.areAllReplicasInState(topic, ReplicaDeletionSuccessful$.MODULE$)) {
                $this.completeDeleteTopic(topic);
                $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(41).append("Deletion of topic ").append(topic).append(" successfully completed").toString());
            } else if (!$this.controllerContext.isAnyReplicaInState(topic, ReplicaDeletionStarted$.MODULE$) && $this.controllerContext.isAnyReplicaInState(topic, ReplicaDeletionIneligible$.MODULE$)) {
                $this.retryDeletionForIneligibleReplicas(topic);
            }
            if (!$this.isTopicEligibleForDeletion(topic)) break block3;
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("Deletion of topic ").append(topic).append(" (re)started").toString());
            $this.onTopicDeletion((Set<String>)((Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
        }
    }

    public TopicDeletionManager(KafkaConfig config, ControllerContext controllerContext, ReplicaStateMachine replicaStateMachine, PartitionStateMachine partitionStateMachine, DeletionClient client) {
        this.controllerContext = controllerContext;
        this.replicaStateMachine = replicaStateMachine;
        this.partitionStateMachine = partitionStateMachine;
        this.client = client;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(26).append("[Topic Deletion Manager ").append(config.brokerId()).append("] ").toString());
        this.isDeleteTopicEnabled = Predef$.MODULE$.Boolean2boolean(config.deleteTopicEnable());
    }
}

