/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.log.Log;
import kafka.log.LogSegment;
import kafka.utils.Logging;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Seq$;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class LogCleanerManager$
implements Logging {
    public static final LogCleanerManager$ MODULE$ = new LogCleanerManager$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$(MODULE$);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        LogCleanerManager$ logCleanerManager$ = this;
        synchronized (logCleanerManager$) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        return !bitmap$0 ? this.logger$lzycompute() : logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public boolean isCompactAndDelete(Log log) {
        return log.config().compact() && log.config().delete();
    }

    public long maxCompactionDelay(Log log, long firstDirtyOffset, long now) {
        Iterable<LogSegment> dirtyNonActiveSegments = log.nonActiveLogSegmentsFrom(firstDirtyOffset);
        Iterable firstBatchTimestamps = (Iterable)log.getFirstBatchTimestampForSegments(dirtyNonActiveSegments).filter((Function1)(JFunction1.mcZJ.sp & Serializable)x$5 -> x$5 > 0L);
        long earliestDirtySegmentTimestamp = firstBatchTimestamps.nonEmpty() ? BoxesRunTime.unboxToLong((Object)firstBatchTimestamps.min((Ordering)Ordering.Long$.MODULE$)) : Long.MAX_VALUE;
        long maxCompactionLagMs = package$.MODULE$.max(Predef$.MODULE$.Long2long(log.config().maxCompactionLagMs()), 0L);
        long cleanUntilTime = now - maxCompactionLagMs;
        return earliestDirtySegmentTimestamp < cleanUntilTime ? cleanUntilTime - earliestDirtySegmentTimestamp : 0L;
    }

    public Tuple2<Object, Object> cleanableOffsets(Log log, Option<Object> lastCleanOffset, long now) {
        None$ none$;
        long l;
        long logStartOffset = log.logStartOffset();
        long checkpointDirtyOffset = BoxesRunTime.unboxToLong((Object)lastCleanOffset.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> logStartOffset));
        if (checkpointDirtyOffset < logStartOffset) {
            if (!this.isCompactAndDelete(log)) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(54).append("Resetting first dirty offset of ").append(log.name()).append(" to log start offset ").append(logStartOffset).append(" ").toString()).append(new StringBuilder(42).append("since the checkpointed offset ").append(checkpointDirtyOffset).append(" is invalid.").toString()).toString());
            }
            l = logStartOffset;
        } else if (checkpointDirtyOffset > log.logEndOffset()) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(53).append("The last checkpoint dirty offset for partition ").append(log.name()).append(" is ").append(checkpointDirtyOffset).append(", ").toString()).append(new StringBuilder(77).append("which is larger than the log end offset ").append(log.logEndOffset()).append(". Resetting to the log start offset ").append(logStartOffset).append(".").toString()).toString());
            l = logStartOffset;
        } else {
            l = checkpointDirtyOffset;
        }
        long firstDirtyOffset = l;
        long minCompactionLagMs = package$.MODULE$.max(Predef$.MODULE$.Long2long(log.config().compactionLagMs()), 0L);
        Option[] optionArray = new Option[3];
        optionArray[0] = log.firstUnstableOffset();
        optionArray[1] = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)log.activeSegment().baseOffset()));
        if (minCompactionLagMs > 0L) {
            Iterable<LogSegment> dirtyNonActiveSegments = log.nonActiveLogSegmentsFrom(firstDirtyOffset);
            none$ = dirtyNonActiveSegments.find((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager$.$anonfun$cleanableOffsets$4(now, minCompactionLagMs, log, s))).map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.baseOffset()));
        } else {
            none$ = None$.MODULE$;
        }
        optionArray[2] = none$;
        long firstUncleanableDirtyOffset = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])optionArray)).flatten(Predef$.MODULE$.$conforms())).min((Ordering)Ordering.Long$.MODULE$));
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(64).append("Finding range of cleanable offsets for log=").append(log.name()).append(". Last clean offset=").append(lastCleanOffset).append(" ").toString()).append(new StringBuilder(50).append("now=").append(now).append(" => firstDirtyOffset=").append(firstDirtyOffset).append(" firstUncleanableOffset=").append(firstUncleanableDirtyOffset).append(" ").toString()).append(new StringBuilder(25).append("activeSegment.baseOffset=").append(log.activeSegment().baseOffset()).toString()).toString());
        return new Tuple2.mcJJ.sp(firstDirtyOffset, package$.MODULE$.max(firstDirtyOffset, firstUncleanableDirtyOffset));
    }

    public Tuple2<Object, Object> calculateCleanableBytes(Log log, long firstDirtyOffset, long uncleanableOffset) {
        LogSegment firstUncleanableSegment = (LogSegment)log.nonActiveLogSegmentsFrom(uncleanableOffset).headOption().getOrElse((Function0 & Serializable)() -> log.activeSegment());
        long firstUncleanableOffset = firstUncleanableSegment.baseOffset();
        long cleanableBytes = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)log.logSegments(firstDirtyOffset, package$.MODULE$.max(firstDirtyOffset, firstUncleanableOffset)).map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.size()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        return new Tuple2.mcJJ.sp(firstUncleanableOffset, cleanableBytes);
    }

    public static final /* synthetic */ boolean $anonfun$cleanableOffsets$4(long now$3, long minCompactionLagMs$1, Log log$2, LogSegment s) {
        boolean isUncleanable = s.largestTimestamp() > now$3 - minCompactionLagMs$1;
        MODULE$.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(67).append("Checking if log segment may be cleaned: log='").append(log$2.name()).append("' segment.baseOffset=").append(s.baseOffset()).append(" ").toString()).append(new StringBuilder(49).append("segment.largestTimestamp=").append(s.largestTimestamp()).append("; now - compactionLag=").append(now$3 - minCompactionLagMs$1).append("; ").toString()).append(new StringBuilder(15).append("is uncleanable=").append(isUncleanable).toString()).toString());
        return isUncleanable;
    }

    private LogCleanerManager$() {
    }
}

