/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.Serializable;
import java.util.Iterator;
import kafka.log.CompletedTxn;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateEntry$;
import kafka.log.TxnMetadata;
import kafka.log.TxnMetadata$;
import kafka.log.ValidationType;
import kafka.log.ValidationType$EpochOnly$;
import kafka.log.ValidationType$Full$;
import kafka.log.ValidationType$None$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTxnStateException;
import org.apache.kafka.common.errors.OutOfOrderSequenceException;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.errors.TransactionCoordinatorFencedException;
import org.apache.kafka.common.errors.UnknownProducerIdException;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005]e!\u0002\r\u001a\u0001ei\u0002\u0002\u0003\u0013\u0001\u0005\u000b\u0007I\u0011\u0001\u0014\t\u0011I\u0002!\u0011!Q\u0001\n\u001dB\u0001b\r\u0001\u0003\u0006\u0004%\t\u0001\u000e\u0005\tq\u0001\u0011\t\u0011)A\u0005k!A\u0011\b\u0001BC\u0002\u0013\u0005!\b\u0003\u0005@\u0001\t\u0005\t\u0015!\u0003<\u0011!\u0001\u0005A!b\u0001\n\u0003\t\u0005\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011\u0002\"\t\u000b\u0019\u0003A\u0011A$\t\u000f5\u0003!\u0019!C\u0005\u001d\"1!\f\u0001Q\u0001\n=Cqa\u0017\u0001C\u0002\u0013%!\b\u0003\u0004]\u0001\u0001\u0006Ia\u000f\u0005\u0006;\u0002!IA\u0018\u0005\u0006]\u0002!Ia\u001c\u0005\u0006e\u0002!Ia\u001d\u0005\u0006q\u0002!I!\u001f\u0005\b\u0003\u0007\u0001A\u0011AA\u0003\u0011\u001d\t\u0019\u0001\u0001C\u0001\u0003kAq!a\u0014\u0001\t\u0003\t\t\u0006\u0003\u0004\u0002f\u0001!\tA\u000f\u0005\b\u0003O\u0002A\u0011AA5\u0011\u001d\t\u0019\t\u0001C!\u0003\u000b\u0013!\u0003\u0015:pIV\u001cWM]!qa\u0016tG-\u00138g_*\u0011!dG\u0001\u0004Y><'\"\u0001\u000f\u0002\u000b-\fgm[1\u0014\u0005\u0001q\u0002CA\u0010#\u001b\u0005\u0001#\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0002#AB!osJ+g-\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0004\u0001U\tq\u0005\u0005\u0002)a5\t\u0011F\u0003\u0002+W\u000511m\\7n_:T!\u0001\b\u0017\u000b\u00055r\u0013AB1qC\u000eDWMC\u00010\u0003\ry'oZ\u0005\u0003c%\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\bu_BL7\rU1si&$\u0018n\u001c8!\u0003)\u0001(o\u001c3vG\u0016\u0014\u0018\nZ\u000b\u0002kA\u0011qDN\u0005\u0003o\u0001\u0012A\u0001T8oO\u0006Y\u0001O]8ek\u000e,'/\u00133!\u00031\u0019WO\u001d:f]R,e\u000e\u001e:z+\u0005Y\u0004C\u0001\u001f>\u001b\u0005I\u0012B\u0001 \u001a\u0005I\u0001&o\u001c3vG\u0016\u00148\u000b^1uK\u0016sGO]=\u0002\u001b\r,(O]3oi\u0016sGO]=!\u000391\u0018\r\\5eCRLwN\u001c+za\u0016,\u0012A\u0011\t\u0003y\rK!\u0001R\r\u0003\u001dY\u000bG.\u001b3bi&|g\u000eV=qK\u0006ya/\u00197jI\u0006$\u0018n\u001c8UsB,\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0006\u0011&S5\n\u0014\t\u0003y\u0001AQ\u0001J\u0005A\u0002\u001dBQaM\u0005A\u0002UBQ!O\u0005A\u0002mBQ\u0001Q\u0005A\u0002\t\u000bA\u0002\u001e:b]N\f7\r^5p]N,\u0012a\u0014\t\u0004!V;V\"A)\u000b\u0005I\u001b\u0016aB7vi\u0006\u0014G.\u001a\u0006\u0003)\u0002\n!bY8mY\u0016\u001cG/[8o\u0013\t1\u0016K\u0001\u0006MSN$()\u001e4gKJ\u0004\"\u0001\u0010-\n\u0005eK\"a\u0003+y]6+G/\u00193bi\u0006\fQ\u0002\u001e:b]N\f7\r^5p]N\u0004\u0013\u0001D;qI\u0006$X\rZ#oiJL\u0018!D;qI\u0006$X\rZ#oiJL\b%A\nnCf\u0014WMV1mS\u0012\fG/Z!qa\u0016tG\r\u0006\u0003`E\u001ed\u0007CA\u0010a\u0013\t\t\u0007E\u0001\u0003V]&$\b\"B2\u000f\u0001\u0004!\u0017!\u00049s_\u0012,8-\u001a:Fa>\u001c\u0007\u000e\u0005\u0002 K&\u0011a\r\t\u0002\u0006'\"|'\u000f\u001e\u0005\u0006Q:\u0001\r![\u0001\tM&\u00148\u000f^*fcB\u0011qD[\u0005\u0003W\u0002\u00121!\u00138u\u0011\u0015ig\u00021\u00016\u0003\u0019ygMZ:fi\u0006\u00112\r[3dWB\u0013x\u000eZ;dKJ,\u0005o\\2i)\ry\u0006/\u001d\u0005\u0006G>\u0001\r\u0001\u001a\u0005\u0006[>\u0001\r!N\u0001\u000eG\",7m[*fcV,gnY3\u0015\t}#Xo\u001e\u0005\u0006GB\u0001\r\u0001\u001a\u0005\u0006mB\u0001\r![\u0001\u000fCB\u0004XM\u001c3GSJ\u001cHoU3r\u0011\u0015i\u0007\u00031\u00016\u0003)IgnU3rk\u0016t7-\u001a\u000b\u0004uv|\bCA\u0010|\u0013\ta\bEA\u0004C_>dW-\u00198\t\u000by\f\u0002\u0019A5\u0002\u000f1\f7\u000f^*fc\"1\u0011\u0011A\tA\u0002%\fqA\\3yiN+\u0017/\u0001\u0004baB,g\u000e\u001a\u000b\u0007\u0003\u000f\t\u0019\"a\t\u0011\u000b}\tI!!\u0004\n\u0007\u0005-\u0001E\u0001\u0004PaRLwN\u001c\t\u0004y\u0005=\u0011bAA\t3\ta1i\\7qY\u0016$X\r\u001a+y]\"9\u0011Q\u0003\nA\u0002\u0005]\u0011!\u00022bi\u000eD\u0007\u0003BA\r\u0003?i!!a\u0007\u000b\u0007\u0005u\u0011&\u0001\u0004sK\u000e|'\u000fZ\u0005\u0005\u0003C\tYBA\u0006SK\u000e|'\u000f\u001a\"bi\u000eD\u0007bBA\u0013%\u0001\u0007\u0011qE\u0001\u0017M&\u00148\u000f^(gMN,G/T3uC\u0012\fG/Y(qiB)q$!\u0003\u0002*A!\u00111FA\u0019\u001b\t\tiCC\u0002\u00020m\taa]3sm\u0016\u0014\u0018\u0002BA\u001a\u0003[\u0011\u0011\u0003T8h\u001f\u001a47/\u001a;NKR\fG-\u0019;b)=y\u0016qGA\u001e\u0003{\ty$a\u0011\u0002H\u0005-\u0003BBA\u001d'\u0001\u0007A-A\u0003fa>\u001c\u0007\u000eC\u0003i'\u0001\u0007\u0011\u000eC\u0003\u007f'\u0001\u0007\u0011\u000e\u0003\u0004\u0002BM\u0001\r!N\u0001\u000eY\u0006\u001cH\u000fV5nKN$\u0018-\u001c9\t\u000f\u0005\u00153\u00031\u0001\u0002*\u0005\u0019b-\u001b:ti>3gm]3u\u001b\u0016$\u0018\rZ1uC\"1\u0011\u0011J\nA\u0002U\n!\u0002\\1ti>3gm]3u\u0011\u0019\tie\u0005a\u0001u\u0006y\u0011n\u001d+sC:\u001c\u0018m\u0019;j_:\fG.\u0001\nbaB,g\u000eZ#oIRCh.T1sW\u0016\u0014HCCA\u0007\u0003'\ni&a\u0018\u0002b!9\u0011Q\u000b\u000bA\u0002\u0005]\u0013\u0001D3oIRCh.T1sW\u0016\u0014\b\u0003BA\r\u00033JA!a\u0017\u0002\u001c\t!RI\u001c3Ue\u0006t7/Y2uS>tW*\u0019:lKJDQa\u0019\u000bA\u0002\u0011DQ!\u001c\u000bA\u0002UBa!a\u0019\u0015\u0001\u0004)\u0014!\u0003;j[\u0016\u001cH/Y7q\u0003\u001d!x.\u00128uef\f1c\u001d;beR,G\r\u0016:b]N\f7\r^5p]N,\"!a\u001b\u0011\u000b\u00055\u0014QP,\u000f\t\u0005=\u0014\u0011\u0010\b\u0005\u0003c\n9(\u0004\u0002\u0002t)\u0019\u0011QO\u0013\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0013bAA>A\u00059\u0001/Y2lC\u001e,\u0017\u0002BA@\u0003\u0003\u0013A\u0001T5ti*\u0019\u00111\u0010\u0011\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\"\u0011\t\u0005%\u0015\u0011\u0013\b\u0005\u0003\u0017\u000bi\tE\u0002\u0002r\u0001J1!a$!\u0003\u0019\u0001&/\u001a3fM&!\u00111SAK\u0005\u0019\u0019FO]5oO*\u0019\u0011q\u0012\u0011")
public class ProducerAppendInfo {
    private final TopicPartition topicPartition;
    private final long producerId;
    private final ProducerStateEntry currentEntry;
    private final ValidationType validationType;
    private final ListBuffer<TxnMetadata> transactions;
    private final ProducerStateEntry updatedEntry;

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public long producerId() {
        return this.producerId;
    }

    public ProducerStateEntry currentEntry() {
        return this.currentEntry;
    }

    public ValidationType validationType() {
        return this.validationType;
    }

    private ListBuffer<TxnMetadata> transactions() {
        return this.transactions;
    }

    private ProducerStateEntry updatedEntry() {
        return this.updatedEntry;
    }

    private void maybeValidateAppend(short producerEpoch, int firstSeq, long offset) {
        ValidationType validationType = this.validationType();
        if (ValidationType$None$.MODULE$.equals(validationType)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ValidationType$EpochOnly$.MODULE$.equals(validationType)) {
            this.checkProducerEpoch(producerEpoch, offset);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ValidationType$Full$.MODULE$.equals(validationType)) {
            this.checkProducerEpoch(producerEpoch, offset);
            this.checkSequence(producerEpoch, firstSeq, offset);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)validationType);
        }
    }

    private void checkProducerEpoch(short producerEpoch, long offset) {
        if (producerEpoch < this.updatedEntry().producerEpoch()) {
            throw new ProducerFencedException(new StringBuilder(0).append(new StringBuilder(50).append("Producer's epoch at offset ").append(offset).append(" is no longer valid in ").toString()).append(new StringBuilder(46).append("partition ").append(this.topicPartition()).append(": ").append(producerEpoch).append(" (request epoch), ").append(this.updatedEntry().producerEpoch()).append(" (current epoch)").toString()).toString());
        }
    }

    private void checkSequence(short producerEpoch, int appendFirstSeq, long offset) {
        if (producerEpoch != this.updatedEntry().producerEpoch()) {
            if (appendFirstSeq != 0) {
                if (this.updatedEntry().producerEpoch() != -1) {
                    throw new OutOfOrderSequenceException(new StringBuilder(0).append(new StringBuilder(52).append("Invalid sequence number for new epoch at offset ").append(offset).append(" in ").toString()).append(new StringBuilder(44).append("partition ").append(this.topicPartition()).append(": ").append(producerEpoch).append(" (request epoch), ").append(appendFirstSeq).append(" (seq. number)").toString()).toString());
                }
                throw new UnknownProducerIdException(new StringBuilder(48).append(new StringBuilder(55).append("Found no record of producerId=").append(this.producerId()).append(" on the broker at offset ").append(offset).toString()).append(new StringBuilder(77).append("in partition ").append(this.topicPartition()).append(". It is possible that the last message with the producerId=").append(this.producerId()).append(" has ").toString()).append("been removed due to hitting the retention limit.").toString());
            }
        } else {
            int currentLastSeq;
            int n = !this.updatedEntry().isEmpty() ? this.updatedEntry().lastSeq() : (currentLastSeq = producerEpoch == this.currentEntry().producerEpoch() ? this.currentEntry().lastSeq() : -1);
            if (currentLastSeq == -1 && appendFirstSeq != 0) {
                throw new UnknownProducerIdException(new StringBuilder(29).append(new StringBuilder(45).append("Local producer state matches expected epoch ").append(producerEpoch).append(" ").toString()).append(new StringBuilder(64).append("for producerId=").append(this.producerId()).append(" at offset ").append(offset).append(" in partition ").append(this.topicPartition()).append(", but the next expected ").toString()).append("sequence number is not known.").toString());
            }
            if (!this.inSequence(currentLastSeq, appendFirstSeq)) {
                throw new OutOfOrderSequenceException(new StringBuilder(0).append(new StringBuilder(48).append("Out of order sequence number for producerId ").append(this.producerId()).append(" at ").toString()).append(new StringBuilder(48).append("offset ").append(offset).append(" in partition ").append(this.topicPartition()).append(": ").append(appendFirstSeq).append(" (incoming seq. number), ").toString()).append(new StringBuilder(30).append(currentLastSeq).append(" (current end sequence number)").toString()).toString());
            }
        }
    }

    private boolean inSequence(int lastSeq, int nextSeq) {
        return (long)nextSeq == (long)lastSeq + 1L || nextSeq == 0 && lastSeq == Integer.MAX_VALUE;
    }

    public Option<CompletedTxn> append(RecordBatch batch, Option<LogOffsetMetadata> firstOffsetMetadataOpt) {
        None$ none$;
        if (batch.isControlBatch()) {
            Iterator recordIterator = batch.iterator();
            if (recordIterator.hasNext()) {
                Record record = (Record)recordIterator.next();
                EndTransactionMarker endTxnMarker = EndTransactionMarker.deserialize((Record)record);
                CompletedTxn completedTxn = this.appendEndTxnMarker(endTxnMarker, batch.producerEpoch(), batch.baseOffset(), record.timestamp());
                none$ = new Some((Object)completedTxn);
            } else {
                none$ = None$.MODULE$;
            }
        } else {
            LogOffsetMetadata firstOffsetMetadata = (LogOffsetMetadata)firstOffsetMetadataOpt.getOrElse((Function0 & Serializable)() -> new LogOffsetMetadata(batch.baseOffset(), LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
            this.append(batch.producerEpoch(), batch.baseSequence(), batch.lastSequence(), batch.maxTimestamp(), firstOffsetMetadata, batch.lastOffset(), batch.isTransactional());
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public void append(short epoch, int firstSeq, int lastSeq, long lastTimestamp, LogOffsetMetadata firstOffsetMetadata, long lastOffset, boolean isTransactional) {
        long firstOffset = firstOffsetMetadata.messageOffset();
        this.maybeValidateAppend(epoch, firstSeq, firstOffset);
        this.updatedEntry().addBatch(epoch, lastSeq, lastOffset, (int)(lastOffset - firstOffset), lastTimestamp);
        Option<Object> option = this.updatedEntry().currentTxnFirstOffset();
        if (option instanceof Some && !isTransactional) {
            throw new InvalidTxnStateException(new StringBuilder(0).append(new StringBuilder(47).append("Expected transactional write from producer ").append(this.producerId()).append(" at ").toString()).append(new StringBuilder(21).append("offset ").append(firstOffsetMetadata).append(" in partition ").append(this.topicPartition()).toString()).toString());
        }
        if (None$.MODULE$.equals(option) && isTransactional) {
            this.updatedEntry().currentTxnFirstOffset_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)firstOffset)));
            this.transactions().$plus$eq((Object)new TxnMetadata(this.producerId(), firstOffsetMetadata, TxnMetadata$.MODULE$.apply$default$3()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public CompletedTxn appendEndTxnMarker(EndTransactionMarker endTxnMarker, short producerEpoch, long offset, long timestamp) {
        long l;
        this.checkProducerEpoch(producerEpoch, offset);
        if (this.updatedEntry().coordinatorEpoch() > endTxnMarker.coordinatorEpoch()) {
            throw new TransactionCoordinatorFencedException(new StringBuilder(0).append(new StringBuilder(45).append("Invalid coordinator epoch for producerId ").append(this.producerId()).append(" at ").toString()).append(new StringBuilder(24).append("offset ").append(offset).append(" in partition ").append(this.topicPartition()).append(": ").append(endTxnMarker.coordinatorEpoch()).append(" ").toString()).append(new StringBuilder(20).append("(zombie), ").append(this.updatedEntry().coordinatorEpoch()).append(" (current)").toString()).toString());
        }
        this.updatedEntry().maybeUpdateEpoch(producerEpoch);
        Option<Object> option = this.updatedEntry().currentTxnFirstOffset();
        if (option instanceof Some) {
            long txnFirstOffset;
            Some some = (Some)option;
            l = txnFirstOffset = BoxesRunTime.unboxToLong((Object)some.value());
        } else if (None$.MODULE$.equals(option)) {
            this.transactions().$plus$eq((Object)new TxnMetadata(this.producerId(), offset));
            l = offset;
        } else {
            throw new MatchError(option);
        }
        long firstOffset = l;
        this.updatedEntry().currentTxnFirstOffset_$eq((Option<Object>)None$.MODULE$);
        this.updatedEntry().coordinatorEpoch_$eq(endTxnMarker.coordinatorEpoch());
        ControlRecordType controlRecordType = endTxnMarker.controlType();
        ControlRecordType controlRecordType2 = ControlRecordType.ABORT;
        return new CompletedTxn(this.producerId(), firstOffset, offset, !(controlRecordType != null ? !controlRecordType.equals(controlRecordType2) : controlRecordType2 != null));
    }

    public ProducerStateEntry toEntry() {
        return this.updatedEntry();
    }

    public List<TxnMetadata> startedTransactions() {
        return this.transactions().toList();
    }

    public String toString() {
        return new StringBuilder(19).append("ProducerAppendInfo(").append(new StringBuilder(13).append("producerId=").append(this.producerId()).append(", ").toString()).append(new StringBuilder(16).append("producerEpoch=").append(this.updatedEntry().producerEpoch()).append(", ").toString()).append(new StringBuilder(16).append("firstSequence=").append(this.updatedEntry().firstSeq()).append(", ").toString()).append(new StringBuilder(15).append("lastSequence=").append(this.updatedEntry().lastSeq()).append(", ").toString()).append(new StringBuilder(24).append("currentTxnFirstOffset=").append(this.updatedEntry().currentTxnFirstOffset()).append(", ").toString()).append(new StringBuilder(19).append("coordinatorEpoch=").append(this.updatedEntry().coordinatorEpoch()).append(", ").toString()).append(new StringBuilder(21).append("startedTransactions=").append(this.transactions()).append(")").toString()).toString();
    }

    public ProducerAppendInfo(TopicPartition topicPartition, long producerId, ProducerStateEntry currentEntry, ValidationType validationType) {
        this.topicPartition = topicPartition;
        this.producerId = producerId;
        this.currentEntry = currentEntry;
        this.validationType = validationType;
        this.transactions = ListBuffer$.MODULE$.empty();
        this.updatedEntry = ProducerStateEntry$.MODULE$.empty(producerId);
        this.updatedEntry().producerEpoch_$eq(currentEntry.producerEpoch());
        this.updatedEntry().coordinatorEpoch_$eq(currentEntry.coordinatorEpoch());
        this.updatedEntry().currentTxnFirstOffset_$eq(currentEntry.currentTxnFirstOffset());
    }
}

