/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.util.Base64;
import java.util.Collection;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import kafka.utils.Json$;
import kafka.utils.json.DecodeJson$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeLong$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.token.delegation.DelegationToken;
import org.apache.kafka.common.security.token.delegation.TokenInformation;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.common.utils.SecurityUtils;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.mutable.Map$;
import scala.runtime.BoxesRunTime;

public final class DelegationTokenManager$ {
    public static final DelegationTokenManager$ MODULE$ = new DelegationTokenManager$();
    private static final String DefaultHmacAlgorithm = "HmacSHA512";
    private static final String OwnerKey = "owner";
    private static final String RenewersKey = "renewers";
    private static final String IssueTimestampKey = "issueTimestamp";
    private static final String MaxTimestampKey = "maxTimestamp";
    private static final String ExpiryTimestampKey = "expiryTimestamp";
    private static final String TokenIdKey = "tokenId";
    private static final String VersionKey = "version";
    private static final int CurrentVersion = 1;
    private static final int ErrorTimestamp = -1;

    public String DefaultHmacAlgorithm() {
        return DefaultHmacAlgorithm;
    }

    public String OwnerKey() {
        return OwnerKey;
    }

    public String RenewersKey() {
        return RenewersKey;
    }

    public String IssueTimestampKey() {
        return IssueTimestampKey;
    }

    public String MaxTimestampKey() {
        return MaxTimestampKey;
    }

    public String ExpiryTimestampKey() {
        return ExpiryTimestampKey;
    }

    public String TokenIdKey() {
        return TokenIdKey;
    }

    public String VersionKey() {
        return VersionKey;
    }

    public int CurrentVersion() {
        return CurrentVersion;
    }

    public int ErrorTimestamp() {
        return ErrorTimestamp;
    }

    public byte[] createHmac(String tokenId, String secretKey) {
        return this.createHmac(tokenId, this.createSecretKey(secretKey.getBytes(StandardCharsets.UTF_8)));
    }

    public SecretKey createSecretKey(byte[] keybytes) {
        return new SecretKeySpec(keybytes, this.DefaultHmacAlgorithm());
    }

    public String createBase64HMAC(String tokenId, SecretKey secretKey) {
        byte[] hmac = this.createHmac(tokenId, secretKey);
        return Base64.getEncoder().encodeToString(hmac);
    }

    public byte[] createHmac(String tokenId, SecretKey secretKey) {
        Mac mac = Mac.getInstance(this.DefaultHmacAlgorithm());
        try {
            mac.init(secretKey);
        }
        catch (InvalidKeyException ike) {
            throw new IllegalArgumentException("Invalid key to HMAC computation", ike);
        }
        return mac.doFinal(tokenId.getBytes(StandardCharsets.UTF_8));
    }

    public Map<String, Object> toJsonCompatibleMap(DelegationToken token) {
        TokenInformation tokenInfo = token.tokenInfo();
        scala.collection.mutable.Map tokenInfoMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        tokenInfoMap.update((Object)this.VersionKey(), (Object)BoxesRunTime.boxToInteger((int)this.CurrentVersion()));
        tokenInfoMap.update((Object)this.OwnerKey(), (Object)Sanitizer.sanitize((String)tokenInfo.ownerAsString()));
        tokenInfoMap.update((Object)this.RenewersKey(), JavaConverters$.MODULE$.asJavaIterableConverter((Iterable)((IterableOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(tokenInfo.renewersAsString()).asScala()).map((Function1 & Serializable)e -> Sanitizer.sanitize((String)e))).asJava());
        tokenInfoMap.update((Object)this.IssueTimestampKey(), (Object)BoxesRunTime.boxToLong((long)tokenInfo.issueTimestamp()));
        tokenInfoMap.update((Object)this.MaxTimestampKey(), (Object)BoxesRunTime.boxToLong((long)tokenInfo.maxTimestamp()));
        tokenInfoMap.update((Object)this.ExpiryTimestampKey(), (Object)BoxesRunTime.boxToLong((long)tokenInfo.expiryTimestamp()));
        tokenInfoMap.update((Object)this.TokenIdKey(), (Object)tokenInfo.tokenId());
        return tokenInfoMap.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Option<TokenInformation> fromBytes(byte[] bytes) {
        None$ none$;
        if (bytes == null || ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.byteArrayOps(bytes))) {
            return None$.MODULE$;
        }
        Option<JsonValue> option = Json$.MODULE$.parseBytes(bytes);
        if (option instanceof Some) {
            Some some = (Some)option;
            JsonValue js = (JsonValue)some.value();
            JsonObject mainJs = js.asJsonObject();
            Predef$.MODULE$.require(BoxesRunTime.unboxToInt((Object)mainJs.apply(this.VersionKey()).to(DecodeJson$DecodeInt$.MODULE$)) == this.CurrentVersion());
            KafkaPrincipal owner = SecurityUtils.parseKafkaPrincipal((String)Sanitizer.desanitize((String)mainJs.apply(this.OwnerKey()).to(DecodeJson$DecodeString$.MODULE$)));
            scala.collection.immutable.Seq renewerStr = (scala.collection.immutable.Seq)mainJs.apply(this.RenewersKey()).to(DecodeJson$.MODULE$.decodeSeq(DecodeJson$DecodeString$.MODULE$, Seq$.MODULE$.iterableFactory()));
            scala.collection.immutable.Seq renewers = (scala.collection.immutable.Seq)((IterableOps)renewerStr.map((Function1 & Serializable)x$1 -> Sanitizer.desanitize((String)x$1))).map((Function1 & Serializable)x$2 -> SecurityUtils.parseKafkaPrincipal((String)x$2));
            long issueTimestamp = BoxesRunTime.unboxToLong((Object)mainJs.apply(this.IssueTimestampKey()).to(DecodeJson$DecodeLong$.MODULE$));
            long expiryTimestamp = BoxesRunTime.unboxToLong((Object)mainJs.apply(this.ExpiryTimestampKey()).to(DecodeJson$DecodeLong$.MODULE$));
            long maxTimestamp = BoxesRunTime.unboxToLong((Object)mainJs.apply(this.MaxTimestampKey()).to(DecodeJson$DecodeLong$.MODULE$));
            String tokenId = mainJs.apply(this.TokenIdKey()).to(DecodeJson$DecodeString$.MODULE$);
            TokenInformation tokenInfo = new TokenInformation(tokenId, owner, (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)renewers).asJava(), issueTimestamp, maxTimestamp, expiryTimestamp);
            none$ = new Some((Object)tokenInfo);
        } else if (None$.MODULE$.equals(option)) {
            none$ = None$.MODULE$;
        } else {
            throw new MatchError(option);
        }
        return none$;
    }

    public boolean filterToken(KafkaPrincipal requestedPrincipal, Option<List<KafkaPrincipal>> owners, TokenInformation token, Function1<String, Object> authorizeToken) {
        boolean allow = !owners.isEmpty() && !((List)owners.get()).exists((Function1 & Serializable)owner -> BoxesRunTime.boxToBoolean((boolean)token.ownerOrRenewer(owner))) ? false : (token.ownerOrRenewer(requestedPrincipal) ? true : BoxesRunTime.unboxToBoolean((Object)authorizeToken.apply((Object)token.tokenId())));
        return allow;
    }

    private DelegationTokenManager$() {
    }
}

