/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.metrics.KafkaMetricsGroup;
import kafka.network.RequestChannel;
import kafka.server.KafkaApis;
import kafka.server.KafkaRequestHandler;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005\rc\u0001B\u000b\u0017\u0001mA\u0001B\f\u0001\u0003\u0006\u0004%\ta\f\u0005\tg\u0001\u0011\t\u0011)A\u0005a!AA\u0007\u0001BC\u0002\u0013\u0005Q\u0007\u0003\u0005=\u0001\t\u0005\t\u0015!\u00037\u0011!i\u0004A!b\u0001\n\u0003q\u0004\u0002C\"\u0001\u0005\u0003\u0005\u000b\u0011B \t\u0011\u0011\u0003!\u0011!Q\u0001\n\u0015C\u0001\"\u0015\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\t%\u0002\u0011\t\u0011)A\u0005'\"Aa\f\u0001B\u0001B\u0003%1\u000bC\u0003`\u0001\u0011\u0005\u0001\rC\u0004j\u0001\t\u0007I\u0011\u00026\t\r]\u0004\u0001\u0015!\u0003l\u0011\u001dA\bA1A\u0005\neDq!a\u0003\u0001A\u0003%!\u0010C\u0005\u0002\u000e\u0001\u0011\r\u0011\"\u0001\u0002\u0010!A\u0011q\u0005\u0001!\u0002\u0013\t\t\u0002C\u0004\u0002*\u0001!\t!a\u000b\t\u000f\u0005]\u0002\u0001\"\u0001\u0002:!9\u0011q\b\u0001\u0005\u0002\u0005\u0005#aF&bM.\f'+Z9vKN$\b*\u00198eY\u0016\u0014\bk\\8m\u0015\t9\u0002$\u0001\u0004tKJ4XM\u001d\u0006\u00023\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001\u001dE!\u0002\"!\b\u0011\u000e\u0003yQ\u0011aH\u0001\u0006g\u000e\fG.Y\u0005\u0003Cy\u0011a!\u00118z%\u00164\u0007CA\u0012'\u001b\u0005!#BA\u0013\u0019\u0003\u0015)H/\u001b7t\u0013\t9CEA\u0004M_\u001e<\u0017N\\4\u0011\u0005%bS\"\u0001\u0016\u000b\u0005-B\u0012aB7fiJL7m]\u0005\u0003[)\u0012\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q\u0003!\u0011'o\\6fe&#W#\u0001\u0019\u0011\u0005u\t\u0014B\u0001\u001a\u001f\u0005\rIe\u000e^\u0001\nEJ|7.\u001a:JI\u0002\naB]3rk\u0016\u001cHo\u00115b]:,G.F\u00017!\t9$(D\u00019\u0015\tI\u0004$A\u0004oKR<xN]6\n\u0005mB$A\u0004*fcV,7\u000f^\"iC:tW\r\\\u0001\u0010e\u0016\fX/Z:u\u0007\"\fgN\\3mA\u0005!\u0011\r]5t+\u0005y\u0004C\u0001!B\u001b\u00051\u0012B\u0001\"\u0017\u0005%Y\u0015MZ6b\u0003BL7/A\u0003ba&\u001c\b%\u0001\u0003uS6,\u0007C\u0001$P\u001b\u00059%BA\u0013I\u0015\tI%*\u0001\u0004d_6lwN\u001c\u0006\u00033-S!\u0001T'\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0015aA8sO&\u0011\u0001k\u0012\u0002\u0005)&lW-\u0001\u0006ok6$\u0006N]3bIN\fqD]3rk\u0016\u001cH\u000fS1oI2,'/\u0011<h\u0013\u0012dW-T3ue&\u001cg*Y7f!\t!6L\u0004\u0002V3B\u0011aKH\u0007\u0002/*\u0011\u0001LG\u0001\u0007yI|w\u000e\u001e \n\u0005is\u0012A\u0002)sK\u0012,g-\u0003\u0002];\n11\u000b\u001e:j]\u001eT!A\u0017\u0010\u0002-1|w-\u00118e)\"\u0014X-\u00193OC6,\u0007K]3gSb\fa\u0001P5oSRtD\u0003C1cG\u0012,gm\u001a5\u0011\u0005\u0001\u0003\u0001\"\u0002\u0018\f\u0001\u0004\u0001\u0004\"\u0002\u001b\f\u0001\u00041\u0004\"B\u001f\f\u0001\u0004y\u0004\"\u0002#\f\u0001\u0004)\u0005\"B)\f\u0001\u0004\u0001\u0004\"\u0002*\f\u0001\u0004\u0019\u0006\"\u00020\f\u0001\u0004\u0019\u0016A\u0004;ie\u0016\fG\rU8pYNK'0Z\u000b\u0002WB\u0011A.^\u0007\u0002[*\u0011an\\\u0001\u0007CR|W.[2\u000b\u0005A\f\u0018AC2p]\u000e,(O]3oi*\u0011!o]\u0001\u0005kRLGNC\u0001u\u0003\u0011Q\u0017M^1\n\u0005Yl'!D!u_6L7-\u00138uK\u001e,'/A\buQJ,\u0017\r\u001a)p_2\u001c\u0016N_3!\u0003I\twm\u001a:fO\u0006$X-\u00133mK6+G/\u001a:\u0016\u0003i\u00042a_A\u0004\u001b\u0005a(BA?\u007f\u0003\u0011\u0019wN]3\u000b\u0005-z(\u0002BA\u0001\u0003\u0007\ta!_1n[\u0016\u0014(BAA\u0003\u0003\r\u0019w.\\\u0005\u0004\u0003\u0013a(!B'fi\u0016\u0014\u0018aE1hOJ,w-\u0019;f\u0013\u0012dW-T3uKJ\u0004\u0013!\u0003:v]:\f'\r\\3t+\t\t\t\u0002\u0005\u0004\u0002\u0014\u0005u\u0011\u0011E\u0007\u0003\u0003+QA!a\u0006\u0002\u001a\u00059Q.\u001e;bE2,'bAA\u000e=\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005}\u0011Q\u0003\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000fE\u0002A\u0003GI1!!\n\u0017\u0005MY\u0015MZ6b%\u0016\fX/Z:u\u0011\u0006tG\r\\3s\u0003)\u0011XO\u001c8bE2,7\u000fI\u0001\u000eGJ,\u0017\r^3IC:$G.\u001a:\u0015\t\u00055\u00121\u0007\t\u0004;\u0005=\u0012bAA\u0019=\t!QK\\5u\u0011\u0019\t)D\u0005a\u0001a\u0005\u0011\u0011\u000eZ\u0001\u0011e\u0016\u001c\u0018N_3UQJ,\u0017\r\u001a)p_2$B!!\f\u0002<!1\u0011QH\nA\u0002A\nqA\\3x'&TX-\u0001\u0005tQV$Hm\\<o)\t\ti\u0003")
public class KafkaRequestHandlerPool
implements KafkaMetricsGroup {
    private final int brokerId;
    private final RequestChannel requestChannel;
    private final KafkaApis apis;
    private final Time time;
    private final String logAndThreadNamePrefix;
    private final AtomicInteger threadPoolSize;
    private final Meter aggregateIdleMeter;
    private final ArrayBuffer<KafkaRequestHandler> runnables;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        KafkaRequestHandlerPool kafkaRequestHandlerPool = this;
        synchronized (kafkaRequestHandlerPool) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    public KafkaApis apis() {
        return this.apis;
    }

    private AtomicInteger threadPoolSize() {
        return this.threadPoolSize;
    }

    private Meter aggregateIdleMeter() {
        return this.aggregateIdleMeter;
    }

    public ArrayBuffer<KafkaRequestHandler> runnables() {
        return this.runnables;
    }

    public synchronized void createHandler(int id) {
        this.runnables().$plus$eq((Object)new KafkaRequestHandler(id, this.brokerId(), this.aggregateIdleMeter(), this.threadPoolSize(), this.requestChannel(), this.apis(), this.time));
        KafkaThread.daemon((String)new StringBuilder(23).append(this.logAndThreadNamePrefix).append("-kafka-request-handler-").append(id).toString(), (Runnable)((Runnable)this.runnables().apply(id))).start();
    }

    public synchronized void resizeThreadPool(int newSize) {
        int currentSize = this.threadPoolSize().get();
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(51).append("Resizing request handler thread pool size from ").append(currentSize).append(" to ").append(newSize).toString());
        if (newSize > currentSize) {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(currentSize), newSize).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.createHandler(i));
        } else if (newSize < currentSize) {
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), currentSize - newSize).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> ((KafkaRequestHandler)this.runnables().remove(currentSize - i)).stop());
        }
        this.threadPoolSize().set(newSize);
    }

    public synchronized void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "shutting down");
        this.runnables().foreach((Function1 & Serializable)handler -> {
            handler.initiateShutdown();
            return BoxedUnit.UNIT;
        });
        this.runnables().foreach((Function1 & Serializable)handler -> {
            handler.awaitShutdown();
            return BoxedUnit.UNIT;
        });
        this.info((Function0<String>)(Function0 & Serializable)() -> "shut down completely");
    }

    public KafkaRequestHandlerPool(int brokerId, RequestChannel requestChannel, KafkaApis apis, Time time, int numThreads, String requestHandlerAvgIdleMetricName, String logAndThreadNamePrefix) {
        this.brokerId = brokerId;
        this.requestChannel = requestChannel;
        this.apis = apis;
        this.time = time;
        this.logAndThreadNamePrefix = logAndThreadNamePrefix;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.threadPoolSize = new AtomicInteger(numThreads);
        this.aggregateIdleMeter = this.newMeter(requestHandlerAvgIdleMetricName, "percent", TimeUnit.NANOSECONDS, this.newMeter$default$4());
        this.logIdent_$eq(new StringBuilder(37).append("[").append(logAndThreadNamePrefix).append(" Kafka Request Handler on Broker ").append(brokerId).append("], ").toString());
        this.runnables = new ArrayBuffer(numThreads);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numThreads).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.createHandler(i));
    }
}

