/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Optional;
import kafka.api.KAFKA_0_10_0_IV0$;
import kafka.api.KAFKA_0_10_1_IV1$;
import kafka.api.KAFKA_0_10_1_IV2$;
import kafka.api.KAFKA_0_11_0_IV0$;
import kafka.api.KAFKA_0_11_0_IV1$;
import kafka.api.KAFKA_0_11_0_IV2$;
import kafka.api.KAFKA_0_9_0$;
import kafka.api.KAFKA_1_1_IV0$;
import kafka.api.KAFKA_2_0_IV0$;
import kafka.api.KAFKA_2_0_IV1$;
import kafka.api.KAFKA_2_1_IV1$;
import kafka.api.KAFKA_2_1_IV2$;
import kafka.api.KAFKA_2_2_IV1$;
import kafka.api.KAFKA_2_3_IV1$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.log.Log;
import kafka.log.LogAppendInfo;
import kafka.server.AbstractFetcherThread;
import kafka.server.BlockingSend;
import kafka.server.FailedPartitions;
import kafka.server.KafkaConfig;
import kafka.server.OffsetAndEpoch;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.ReplicaFetcherBlockingSend;
import kafka.server.ReplicaFetcherThread$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.FetchSessionHandler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.ListOffsetRequest;
import org.apache.kafka.common.requests.ListOffsetResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\r\u0005a\u0001\u0002\u001e<\u0001\u0001C\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\t'\u0002\u0011\t\u0011)A\u0005)\"I\u0001\f\u0001B\u0001B\u0003%\u0011l\u0018\u0005\tA\u0002\u0011\t\u0011)A\u0005C\"AA\r\u0001B\u0001B\u0003%Q\r\u0003\u0005i\u0001\t\u0005\t\u0015!\u0003j\u0011!a\u0007A!A!\u0002\u0013i\u0007\u0002C=\u0001\u0005\u0003\u0005\u000b\u0011\u0002>\t\u0015\u0005\u0005\u0001A!A!\u0002\u0013\t\u0019\u0001\u0003\u0006\u0002\n\u0001\u0011\t\u0011)A\u0005\u0003\u0017Aq!a\u0006\u0001\t\u0003\tI\u0002C\u0005\u00022\u0001\u0011\r\u0011\"\u0003\u00024!9\u0011Q\u0007\u0001!\u0002\u0013!\u0006\"CA\u001c\u0001\t\u0007I\u0011BA\u001d\u0011!\t\t\u0005\u0001Q\u0001\n\u0005m\u0002\"CA\"\u0001\t\u0007I\u0011BA#\u0011!\t9\u0005\u0001Q\u0001\n\u0005E\u0001BCA%\u0001\t\u0007I\u0011A\u001e\u0002L!A\u00111\u000b\u0001!\u0002\u0013\ti\u0005\u0003\u0006\u0002V\u0001\u0011\r\u0011\"\u0001<\u0003\u0017B\u0001\"a\u0016\u0001A\u0003%\u0011Q\n\u0005\u000b\u00033\u0002!\u0019!C\u0001w\u0005-\u0003\u0002CA.\u0001\u0001\u0006I!!\u0014\t\u0013\u0005u\u0003A1A\u0005\n\u0005}\u0003\u0002CA9\u0001\u0001\u0006I!!\u0019\t\u0013\u0005M\u0004A1A\u0005\n\u0005}\u0003\u0002CA;\u0001\u0001\u0006I!!\u0019\t\u0013\u0005]\u0004A1A\u0005\n\u0005}\u0003\u0002CA=\u0001\u0001\u0006I!!\u0019\t\u0013\u0005m\u0004A1A\u0005\n\u0005}\u0003\u0002CA?\u0001\u0001\u0006I!!\u0019\t\u0013\u0005}\u0004A1A\u0005\n\u0005\u0005\u0005\u0002CAE\u0001\u0001\u0006I!a!\t\u0013\u0005-\u0005A1A\u0005\n\u00055\u0005\u0002CAN\u0001\u0001\u0006I!a$\t\u000f\u0005u\u0005\u0001\"\u0015\u0002 \"9\u0011q\u0016\u0001\u0005R\u0005E\u0006bBA^\u0001\u0011E\u0013Q\u0018\u0005\b\u0003\u001b\u0004A\u0011IAh\u0011\u001d\t\t\u000e\u0001C!\u0003'Dq!a7\u0001\t\u0003\ni\u000eC\u0004\u0002\u0000\u0002!\tA!\u0001\t\u000f\tU\u0001\u0001\"\u0015\u0003\u0018!9!\u0011\n\u0001\u0005R\t-\u0003b\u0002B*\u0001\u0011E#Q\u000b\u0005\b\u00057\u0002A\u0011\u0002B/\u0011\u001d\u00119\u0007\u0001C!\u0005SBqA!'\u0001\t\u0003\u0012Y\nC\u0004\u0003,\u0002!\tF!,\t\u000f\tU\u0006\u0001\"\u0011\u00038\"9!Q\u001a\u0001\u0005B\u0005\u0005\u0005b\u0002Bh\u0001\u0011%!\u0011\u001b\u0005\u000e\u0005/\u0004\u0001\u0013aA\u0001\u0002\u0013%!\u0011\\0\b\u0013\tm7(!A\t\u0002\tug\u0001\u0003\u001e<\u0003\u0003E\tAa8\t\u000f\u0005]q\u0007\"\u0001\u0003h\"I!\u0011^\u001c\u0012\u0002\u0013\u0005!1\u001e\u0002\u0015%\u0016\u0004H.[2b\r\u0016$8\r[3s)\"\u0014X-\u00193\u000b\u0005qj\u0014AB:feZ,'OC\u0001?\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A!\u0011\u0005\t\u001bU\"A\u001e\n\u0005\u0011[$!F!cgR\u0014\u0018m\u0019;GKR\u001c\u0007.\u001a:UQJ,\u0017\rZ\u0001\u0005]\u0006lW\r\u0005\u0002H!:\u0011\u0001J\u0014\t\u0003\u00132k\u0011A\u0013\u0006\u0003\u0017~\na\u0001\u0010:p_Rt$\"A'\u0002\u000bM\u001c\u0017\r\\1\n\u0005=c\u0015A\u0002)sK\u0012,g-\u0003\u0002R%\n11\u000b\u001e:j]\u001eT!a\u0014'\u0002\u0013\u0019,Go\u00195fe&#\u0007CA+W\u001b\u0005a\u0015BA,M\u0005\rIe\u000e^\u0001\rg>,(oY3Ce>\\WM\u001d\t\u00035vk\u0011a\u0017\u0006\u00039v\nqa\u00197vgR,'/\u0003\u0002_7\nq!I]8lKJ,e\u000e\u001a)pS:$\u0018B\u0001-D\u00031\u0011'o\\6fe\u000e{gNZ5h!\t\u0011%-\u0003\u0002dw\tY1*\u00194lC\u000e{gNZ5h\u0003A1\u0017-\u001b7fIB\u000b'\u000f^5uS>t7\u000f\u0005\u0002CM&\u0011qm\u000f\u0002\u0011\r\u0006LG.\u001a3QCJ$\u0018\u000e^5p]N\f!B]3qY&\u001c\u0017-T4s!\t\u0011%.\u0003\u0002lw\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018aB7fiJL7m\u001d\t\u0003]^l\u0011a\u001c\u0006\u0003YBT!!\u001d:\u0002\r\r|W.\\8o\u0015\tq4O\u0003\u0002uk\u00061\u0011\r]1dQ\u0016T\u0011A^\u0001\u0004_J<\u0017B\u0001=p\u0005\u001diU\r\u001e:jGN\fA\u0001^5nKB\u00111P`\u0007\u0002y*\u0011Q\u0010]\u0001\u0006kRLGn]\u0005\u0003\u007fr\u0014A\u0001V5nK\u0006)\u0011/^8uCB\u0019!)!\u0002\n\u0007\u0005\u001d1H\u0001\u0007SKBd\u0017nY1Rk>$\u0018-\u0001\u000emK\u0006$WM]#oIB|\u0017N\u001c;CY>\u001c7.\u001b8h'\u0016tG\rE\u0003V\u0003\u001b\t\t\"C\u0002\u0002\u00101\u0013aa\u00149uS>t\u0007c\u0001\"\u0002\u0014%\u0019\u0011QC\u001e\u0003\u0019\tcwnY6j]\u001e\u001cVM\u001c3\u0002\rqJg.\u001b;?)Y\tY\"!\b\u0002 \u0005\u0005\u00121EA\u0013\u0003O\tI#a\u000b\u0002.\u0005=\u0002C\u0001\"\u0001\u0011\u0015)5\u00021\u0001G\u0011\u0015\u00196\u00021\u0001U\u0011\u0015A6\u00021\u0001Z\u0011\u0015\u00017\u00021\u0001b\u0011\u0015!7\u00021\u0001f\u0011\u0015A7\u00021\u0001j\u0011\u0015a7\u00021\u0001n\u0011\u0015I8\u00021\u0001{\u0011\u001d\t\ta\u0003a\u0001\u0003\u0007A\u0011\"!\u0003\f!\u0003\u0005\r!a\u0003\u0002\u0013I,\u0007\u000f\\5dC&#W#\u0001+\u0002\u0015I,\u0007\u000f\\5dC&#\u0007%\u0001\u0006m_\u001e\u001cuN\u001c;fqR,\"!a\u000f\u0011\u0007m\fi$C\u0002\u0002@q\u0014!\u0002T8h\u0007>tG/\u001a=u\u0003-awnZ\"p]R,\u0007\u0010\u001e\u0011\u0002\u001d1,\u0017\rZ3s\u000b:$\u0007o\\5oiV\u0011\u0011\u0011C\u0001\u0010Y\u0016\fG-\u001a:F]\u0012\u0004x.\u001b8uA\u0005\u0019b-\u001a;dQJ+\u0017/^3tiZ+'o]5p]V\u0011\u0011Q\n\t\u0004+\u0006=\u0013bAA)\u0019\n)1\u000b[8si\u0006!b-\u001a;dQJ+\u0017/^3tiZ+'o]5p]\u0002\n!e\u001c4gg\u0016$hi\u001c:MK\u0006$WM]#q_\u000eD'+Z9vKN$h+\u001a:tS>t\u0017aI8gMN,GOR8s\u0019\u0016\fG-\u001a:Fa>\u001c\u0007NU3rk\u0016\u001cHOV3sg&|g\u000eI\u0001\u0019Y&\u001cHo\u00144gg\u0016$(+Z9vKN$h+\u001a:tS>t\u0017!\u00077jgR|eMZ:fiJ+\u0017/^3tiZ+'o]5p]\u0002\nq!\\1y/\u0006LG/\u0006\u0002\u0002bA!\u00111MA7\u001b\t\t)G\u0003\u0003\u0002h\u0005%\u0014\u0001\u00027b]\u001eT!!a\u001b\u0002\t)\fg/Y\u0005\u0005\u0003_\n)GA\u0004J]R,w-\u001a:\u0002\u00115\f\u0007pV1ji\u0002\n\u0001\"\\5o\u0005f$Xm]\u0001\n[&t')\u001f;fg\u0002\n\u0001\"\\1y\u0005f$Xm]\u0001\n[\u0006D()\u001f;fg\u0002\n\u0011BZ3uG\"\u001c\u0016N_3\u0002\u0015\u0019,Go\u00195TSj,\u0007%\u0001\u0011ce>\\WM]*vaB|'\u000f^:MK\u0006$WM]#q_\u000eD'+Z9vKN$XCAAB!\r)\u0016QQ\u0005\u0004\u0003\u000fc%a\u0002\"p_2,\u0017M\\\u0001\"EJ|7.\u001a:TkB\u0004xN\u001d;t\u0019\u0016\fG-\u001a:Fa>\u001c\u0007NU3rk\u0016\u001cH\u000fI\u0001\u0014M\u0016$8\r[*fgNLwN\u001c%b]\u0012dWM]\u000b\u0003\u0003\u001f\u0003B!!%\u0002\u00186\u0011\u00111\u0013\u0006\u0004\u0003+\u0013\u0018aB2mS\u0016tGo]\u0005\u0005\u00033\u000b\u0019JA\nGKR\u001c\u0007nU3tg&|g\u000eS1oI2,'/\u0001\u000bgKR\u001c\u0007nU3tg&|g\u000eS1oI2,'\u000fI\u0001\fY\u0006$Xm\u001d;Fa>\u001c\u0007\u000e\u0006\u0003\u0002\"\u0006\r\u0006\u0003B+\u0002\u000eQCq!!*%\u0001\u0004\t9+\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0011\t\u0005%\u00161V\u0007\u0002a&\u0019\u0011Q\u00169\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006aAn\\4F]\u0012|eMZ:fiR!\u00111WA]!\r)\u0016QW\u0005\u0004\u0003oc%\u0001\u0002'p]\u001eDq!!*&\u0001\u0004\t9+A\tf]\u0012|eMZ:fi\u001a{'/\u00129pG\"$b!a0\u0002H\u0006%\u0007#B+\u0002\u000e\u0005\u0005\u0007c\u0001\"\u0002D&\u0019\u0011QY\u001e\u0003\u001d=3gm]3u\u0003:$W\t]8dQ\"9\u0011Q\u0015\u0014A\u0002\u0005\u001d\u0006BBAfM\u0001\u0007A+A\u0003fa>\u001c\u0007.\u0001\tj]&$\u0018.\u0019;f'\",H\u000fZ8x]R\u0011\u00111Q\u0001\u000eC^\f\u0017\u000e^*ikR$wn\u001e8\u0015\u0005\u0005U\u0007cA+\u0002X&\u0019\u0011\u0011\u001c'\u0003\tUs\u0017\u000e^\u0001\u0015aJ|7-Z:t!\u0006\u0014H/\u001b;j_:$\u0015\r^1\u0015\u0011\u0005}\u0017Q^Ax\u0003g\u0004R!VA\u0007\u0003C\u0004B!a9\u0002j6\u0011\u0011Q\u001d\u0006\u0004\u0003Ol\u0014a\u00017pO&!\u00111^As\u00055aunZ!qa\u0016tG-\u00138g_\"9\u0011QU\u0015A\u0002\u0005\u001d\u0006bBAyS\u0001\u0007\u00111W\u0001\fM\u0016$8\r[(gMN,G\u000fC\u0004\u0002v&\u0002\r!a>\u0002\u001bA\f'\u000f^5uS>tG)\u0019;b!\u0011\tI0a?\u000e\u0003\u0001I1!!@D\u0005%1U\r^2i\t\u0006$\u0018-A\u000enCf\u0014WmV1s]&3wJ^3sg&TX\r\u001a*fG>\u0014Hm\u001d\u000b\u0007\u0003+\u0014\u0019Aa\u0005\t\u000f\t\u0015!\u00061\u0001\u0003\b\u00059!/Z2pe\u0012\u001c\b\u0003\u0002B\u0005\u0005\u001fi!Aa\u0003\u000b\u0007\t5\u0001/\u0001\u0004sK\u000e|'\u000fZ\u0005\u0005\u0005#\u0011YAA\u0007NK6|'/\u001f*fG>\u0014Hm\u001d\u0005\b\u0003KS\u0003\u0019AAT\u0003=1W\r^2i\rJ|W\u000eT3bI\u0016\u0014H\u0003\u0002B\r\u0005c\u0001bAa\u0007\u0003&\t-b\u0002\u0002B\u000f\u0005Cq1!\u0013B\u0010\u0013\u0005i\u0015b\u0001B\u0012\u0019\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002B\u0014\u0005S\u00111aU3r\u0015\r\u0011\u0019\u0003\u0014\t\b+\n5\u0012qUA|\u0013\r\u0011y\u0003\u0014\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\tM2\u00061\u0001\u00036\u0005aa-\u001a;dQJ+\u0017/^3tiB!!q\u0007B\"\u001d\u0011\u0011IDa\u0010\u000e\u0005\tm\"b\u0001B\u001fa\u0006A!/Z9vKN$8/\u0003\u0003\u0003B\tm\u0012\u0001\u0004$fi\u000eD'+Z9vKN$\u0018\u0002\u0002B#\u0005\u000f\u0012qAQ;jY\u0012,'O\u0003\u0003\u0003B\tm\u0012!\b4fi\u000eDW)\u0019:mS\u0016\u001cHo\u00144gg\u0016$hI]8n\u0019\u0016\fG-\u001a:\u0015\r\u0005M&Q\nB(\u0011\u001d\t)\u000b\fa\u0001\u0003OCaA!\u0015-\u0001\u0004!\u0016AE2veJ,g\u000e\u001e'fC\u0012,'/\u00129pG\"\f1DZ3uG\"d\u0015\r^3ti>3gm]3u\rJ|W\u000eT3bI\u0016\u0014HCBAZ\u0005/\u0012I\u0006C\u0004\u0002&6\u0002\r!a*\t\r\tES\u00061\u0001U\u0003U1W\r^2i\u001f\u001a47/\u001a;Ge>lG*Z1eKJ$\u0002\"a-\u0003`\t\u0005$1\r\u0005\b\u0003Ks\u0003\u0019AAT\u0011\u0019\u0011\tF\fa\u0001)\"9!Q\r\u0018A\u0002\u0005M\u0016\u0001E3be2LWm\u001d;Pe2\u000bG/Z:u\u0003)\u0011W/\u001b7e\r\u0016$8\r\u001b\u000b\u0005\u0005W\u0012\u0019\t\u0005\u0004\u0003n\tm$\u0011\u0011\b\u0005\u0005_\u00129H\u0004\u0003\u0003r\tUdbA%\u0003t%\ta(\u0003\u0002={%\u0019!\u0011P\u001e\u0002+\u0005\u00137\u000f\u001e:bGR4U\r^2iKJ$\u0006N]3bI&!!Q\u0010B@\u0005Q\u0011Vm];mi^KG\u000f\u001b)beRLG/[8og*\u0019!\u0011P\u001e\u0011\u000bU\u000biA!\u000e\t\u000f\t\u0015u\u00061\u0001\u0003\b\u0006a\u0001/\u0019:uSRLwN\\'baBA!\u0011\u0012BH\u0003O\u0013\u0019*\u0004\u0002\u0003\f*\u0019!Q\u0012'\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003\u0012\n-%aA'baB\u0019!I!&\n\u0007\t]5HA\nQCJ$\u0018\u000e^5p]\u001a+Go\u00195Ti\u0006$X-\u0001\u0005ueVt7-\u0019;f)\u0019\t)N!(\u0003\"\"9!q\u0014\u0019A\u0002\u0005\u001d\u0016A\u0001;q\u0011\u001d\u0011\u0019\u000b\ra\u0001\u0005K\u000bQc\u001c4gg\u0016$HK];oG\u0006$\u0018n\u001c8Ti\u0006$X\rE\u0002C\u0005OK1A!+<\u0005UyeMZ:fiR\u0013XO\\2bi&|gn\u0015;bi\u0016\fq\u0003\u001e:v]\u000e\fG/\u001a$vY2L\u0018I\u001c3Ti\u0006\u0014H/\u0011;\u0015\r\u0005U'q\u0016BY\u0011\u001d\t)+\ra\u0001\u0003OCqAa-2\u0001\u0004\t\u0019,\u0001\u0004pM\u001a\u001cX\r^\u0001\u0015M\u0016$8\r[#q_\u000eDWI\u001c3PM\u001a\u001cX\r^:\u0015\t\te&\u0011\u0019\t\t\u0005\u0013\u0013y)a*\u0003<B!!\u0011\bB_\u0013\u0011\u0011yLa\u000f\u0003\u001d\u0015\u0003xn\u00195F]\u0012|eMZ:fi\"9!1\u0019\u001aA\u0002\t\u0015\u0017A\u00039beRLG/[8ogBA!\u0011\u0012BH\u0003O\u00139\r\u0005\u0003\u0002z\n%\u0017b\u0001Bf\u0007\nIQ\t]8dQ\u0012\u000bG/Y\u0001 SN|eMZ:fi\u001a{'\u000fT3bI\u0016\u0014X\t]8dQN+\b\u000f]8si\u0016$\u0017AF:i_VdGMR8mY><XM\u001d+ie>$H\u000f\\3\u0015\r\u0005\r%1\u001bBk\u0011\u001d\t\t\u0001\u000ea\u0001\u0003\u0007Aq!!*5\u0001\u0004\t9+\u0001\ntkB,'\u000fJ:pkJ\u001cWM\u0011:pW\u0016\u0014X#A-\u0002)I+\u0007\u000f\\5dC\u001a+Go\u00195feRC'/Z1e!\t\u0011ugE\u00028\u0005C\u00042!\u0016Br\u0013\r\u0011)\u000f\u0014\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\tu\u0017\u0001\b\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013\u0007M\u000b\u0003\u0005[TC!a\u0003\u0003p.\u0012!\u0011\u001f\t\u0005\u0005g\u0014i0\u0004\u0002\u0003v*!!q\u001fB}\u0003%)hn\u00195fG.,GMC\u0002\u0003|2\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011yP!>\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class ReplicaFetcherThread
extends AbstractFetcherThread {
    private final int fetcherId;
    private final KafkaConfig brokerConfig;
    private final ReplicaManager replicaMgr;
    private final Metrics metrics;
    private final Time time;
    private final ReplicaQuota quota;
    private final int replicaId;
    private final LogContext logContext;
    private final BlockingSend leaderEndpoint;
    private final short fetchRequestVersion;
    private final short offsetForLeaderEpochRequestVersion;
    private final short listOffsetRequestVersion;
    private final Integer maxWait;
    private final Integer minBytes;
    private final Integer maxBytes;
    private final Integer fetchSize;
    private final boolean brokerSupportsLeaderEpochRequest;
    private final FetchSessionHandler fetchSessionHandler;

    public static Option<BlockingSend> $lessinit$greater$default$10() {
        return ReplicaFetcherThread$.MODULE$.$lessinit$greater$default$10();
    }

    private /* synthetic */ BrokerEndPoint super$sourceBroker() {
        return super.sourceBroker();
    }

    private int replicaId() {
        return this.replicaId;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private BlockingSend leaderEndpoint() {
        return this.leaderEndpoint;
    }

    public short fetchRequestVersion() {
        return this.fetchRequestVersion;
    }

    public short offsetForLeaderEpochRequestVersion() {
        return this.offsetForLeaderEpochRequestVersion;
    }

    public short listOffsetRequestVersion() {
        return this.listOffsetRequestVersion;
    }

    private Integer maxWait() {
        return this.maxWait;
    }

    private Integer minBytes() {
        return this.minBytes;
    }

    private Integer maxBytes() {
        return this.maxBytes;
    }

    private Integer fetchSize() {
        return this.fetchSize;
    }

    private boolean brokerSupportsLeaderEpochRequest() {
        return this.brokerSupportsLeaderEpochRequest;
    }

    private FetchSessionHandler fetchSessionHandler() {
        return this.fetchSessionHandler;
    }

    @Override
    public Option<Object> latestEpoch(TopicPartition topicPartition) {
        return this.replicaMgr.localLogOrException(topicPartition).latestEpoch();
    }

    @Override
    public long logEndOffset(TopicPartition topicPartition) {
        return this.replicaMgr.localLogOrException(topicPartition).logEndOffset();
    }

    @Override
    public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
        return this.replicaMgr.localLogOrException(topicPartition).endOffsetForEpoch(epoch);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean initiateShutdown() {
        void var1_1;
        block2: {
            boolean justShutdown = super.initiateShutdown();
            if (!justShutdown) break block2;
            try {
                this.leaderEndpoint().initiateClose();
            }
            catch (Throwable t) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(96).append("Failed to initiate shutdown of leader endpoint ").append(this.leaderEndpoint()).append(" after initiating replica fetcher thread shutdown").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
            }
        }
        return (boolean)var1_1;
    }

    @Override
    public void awaitShutdown() {
        super.awaitShutdown();
        try {
            this.leaderEndpoint().close();
        }
        catch (Throwable t) {
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(75).append("Failed to close leader endpoint ").append(this.leaderEndpoint()).append(" after shutting down replica fetcher thread").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
        }
    }

    @Override
    public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponse.PartitionData<Records> partitionData) {
        Partition partition = (Partition)this.replicaMgr.nonOfflinePartition(topicPartition).get();
        Log log = partition.localLogOrException();
        MemoryRecords records = this.toMemoryRecords((Records)partitionData.records);
        this.maybeWarnIfOversizedRecords(records, topicPartition);
        if (fetchOffset != log.logEndOffset()) {
            throw new IllegalStateException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Offset mismatch for partition %s: fetched offset = %d, log end offset = %d."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, BoxesRunTime.boxToLong((long)fetchOffset), BoxesRunTime.boxToLong((long)log.logEndOffset())})));
        }
        if (this.isTraceEnabled()) {
            this.trace((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Follower has replica log end offset %d for partition %s. Received %d messages and leader hw %d"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)log.logEndOffset()), topicPartition, BoxesRunTime.boxToInteger((int)records.sizeInBytes()), BoxesRunTime.boxToLong((long)partitionData$1.highWatermark)})));
        }
        Option<LogAppendInfo> logAppendInfo = partition.appendRecordsToFollowerOrFutureReplica(records, false);
        if (this.isTraceEnabled()) {
            this.trace((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Follower has replica log end offset %d after appending %d bytes of messages for partition %s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)log.logEndOffset()), BoxesRunTime.boxToInteger((int)records.sizeInBytes()), topicPartition})));
        }
        long leaderLogStartOffset = partitionData.logStartOffset;
        long followerHighWatermark = log.updateHighWatermark(partitionData.highWatermark);
        log.maybeIncrementLogStartOffset(leaderLogStartOffset);
        if (this.isTraceEnabled()) {
            this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(54).append("Follower set replica high watermark for partition ").append(topicPartition).append(" to ").append(followerHighWatermark).toString());
        }
        if (this.quota.isThrottled(topicPartition)) {
            this.quota.record(records.sizeInBytes());
        }
        this.replicaMgr.brokerTopicStats().updateReplicationBytesIn(records.sizeInBytes());
        return logAppendInfo;
    }

    public void maybeWarnIfOversizedRecords(MemoryRecords records, TopicPartition topicPartition) {
        block0: {
            if (this.fetchRequestVersion() > 2 || records.sizeInBytes() <= 0 || records.validBytes() > 0) break block0;
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(311).append(new StringBuilder(101).append("Replication is failing due to a message that is greater than replica.fetch.max.bytes for partition ").append(topicPartition).append(". ").toString()).append("This generally occurs when the max.message.bytes has been overridden to exceed this value and a suitably large ").append("message has also been sent. To fix this problem increase replica.fetch.max.bytes in your broker config to be ").append("equal or larger than your settings for max.message.bytes, both at a broker and topic level.").toString());
        }
    }

    public Seq<Tuple2<TopicPartition, FetchResponse.PartitionData<Records>>> fetchFromLeader(FetchRequest.Builder fetchRequest) {
        Object object;
        try {
            ClientResponse clientResponse = this.leaderEndpoint().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)fetchRequest);
            FetchResponse fetchResponse = (FetchResponse)clientResponse.responseBody();
            object = !this.fetchSessionHandler().handleResponse(fetchResponse) ? Nil$.MODULE$ : ((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)fetchResponse.responseData()).asScala()).toSeq();
        }
        catch (Throwable t) {
            this.fetchSessionHandler().handleError(t);
            throw t;
        }
        return object;
    }

    @Override
    public long fetchEarliestOffsetFromLeader(TopicPartition topicPartition, int currentLeaderEpoch) {
        return this.fetchOffsetFromLeader(topicPartition, currentLeaderEpoch, -2L);
    }

    @Override
    public long fetchLatestOffsetFromLeader(TopicPartition topicPartition, int currentLeaderEpoch) {
        return this.fetchOffsetFromLeader(topicPartition, currentLeaderEpoch, -1L);
    }

    private long fetchOffsetFromLeader(TopicPartition topicPartition, int currentLeaderEpoch, long earliestOrLatest) {
        ListOffsetRequest.PartitionData requestPartitionData = new ListOffsetRequest.PartitionData(earliestOrLatest, Optional.of(Predef$.MODULE$.int2Integer(currentLeaderEpoch)));
        Map requestPartitions = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)requestPartitionData)}));
        ListOffsetRequest.Builder requestBuilder = ListOffsetRequest.Builder.forReplica((short)this.listOffsetRequestVersion(), (int)this.replicaId()).setTargetTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(requestPartitions).asJava());
        ClientResponse clientResponse = this.leaderEndpoint().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)requestBuilder);
        ListOffsetResponse response = (ListOffsetResponse)clientResponse.responseBody();
        ListOffsetResponse.PartitionData responsePartitionData = (ListOffsetResponse.PartitionData)response.responseData().get(topicPartition);
        Errors errors = responsePartitionData.error;
        if (!Errors.NONE.equals(errors)) {
            throw errors.exception();
        }
        long l = this.brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV2$.MODULE$) ? Predef$.MODULE$.Long2long(responsePartitionData.offset) : Predef$.MODULE$.Long2long((Long)responsePartitionData.offsets.get(0));
        return l;
    }

    @Override
    public AbstractFetcherThread.ResultWithPartitions<Option<FetchRequest.Builder>> buildFetch(Map<TopicPartition, PartitionFetchState> partitionMap) {
        None$ none$;
        scala.collection.mutable.Set partitionsWithError = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        FetchSessionHandler.Builder builder = this.fetchSessionHandler().newBuilder();
        partitionMap.foreach((Function1 & Serializable)x0$1 -> {
            BoxedUnit boxedUnit;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                TopicPartition topicPartition = (TopicPartition)tuple2._1();
                PartitionFetchState fetchState = (PartitionFetchState)tuple2._2();
                if (fetchState.isReadyForFetch() && !this.shouldFollowerThrottle($this.quota, topicPartition)) {
                    try {
                        long logStartOffset = $this.replicaMgr.localLogOrException(topicPartition).logStartOffset();
                        builder.add(topicPartition, new FetchRequest.PartitionData(fetchState.fetchOffset(), logStartOffset, Predef$.MODULE$.Integer2int(this.fetchSize()), Optional.of(Predef$.MODULE$.int2Integer(fetchState.currentLeaderEpoch()))));
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    catch (KafkaStorageException kafkaStorageException) {
                        boxedUnit = partitionsWithError.$plus$eq((Object)topicPartition);
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            BoxedUnit boxedUnit2 = boxedUnit;
            return boxedUnit2;
        });
        FetchSessionHandler.FetchRequestData fetchData = builder.build();
        if (fetchData.sessionPartitions().isEmpty() && fetchData.toForget().isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            FetchRequest.Builder requestBuilder = FetchRequest.Builder.forReplica((short)this.fetchRequestVersion(), (int)this.replicaId(), (int)Predef$.MODULE$.Integer2int(this.maxWait()), (int)Predef$.MODULE$.Integer2int(this.minBytes()), (java.util.Map)fetchData.toSend()).setMaxBytes(Predef$.MODULE$.Integer2int(this.maxBytes())).toForget(fetchData.toForget()).metadata(fetchData.metadata());
            none$ = new Some((Object)requestBuilder);
        }
        None$ fetchRequestOpt = none$;
        return new AbstractFetcherThread.ResultWithPartitions<None$>(fetchRequestOpt, (Set<TopicPartition>)partitionsWithError);
    }

    @Override
    public void truncate(TopicPartition tp, OffsetTruncationState offsetTruncationState) {
        block1: {
            Partition partition = (Partition)this.replicaMgr.nonOfflinePartition(tp).get();
            Log log = partition.localLogOrException();
            partition.truncateTo(offsetTruncationState.offset(), false);
            if (offsetTruncationState.offset() < log.highWatermark()) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(44).append("Truncating ").append(tp).append(" to offset ").append(offsetTruncationState.offset()).append(" below high watermark ").toString()).append(String.valueOf(BoxesRunTime.boxToLong((long)log.highWatermark()))).toString());
            }
            if (!offsetTruncationState.truncationCompleted()) break block1;
            this.replicaMgr.replicaAlterLogDirsManager().markPartitionsForTruncation(this.brokerConfig.brokerId(), tp, offsetTruncationState.offset());
        }
    }

    @Override
    public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        Partition partition = (Partition)this.replicaMgr.nonOfflinePartition(topicPartition).get();
        partition.truncateFullyAndStartAt(offset, false);
    }

    @Override
    public Map<TopicPartition, EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> partitions) {
        Map map;
        if (partitions.isEmpty()) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Skipping leaderEpoch request since all partitions do not have an epoch");
            return (Map)Map$.MODULE$.empty();
        }
        OffsetsForLeaderEpochRequest.Builder epochRequest = OffsetsForLeaderEpochRequest.Builder.forFollower((short)this.offsetForLeaderEpochRequestVersion(), (java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(partitions).asJava()), (int)this.brokerConfig.brokerId());
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(40).append("Sending offset for leader epoch request ").append(epochRequest).toString());
        try {
            ClientResponse response = this.leaderEndpoint().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)epochRequest);
            OffsetsForLeaderEpochResponse responseBody = (OffsetsForLeaderEpochResponse)response.responseBody();
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("Received leaderEpoch response ").append(response).toString());
            map = (Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(responseBody.responses()).asScala();
        }
        catch (Throwable t) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Error when sending leader epoch request for ").append(partitions).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
            Errors error = Errors.forException((Throwable)t);
            map = (Map)partitions.map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition tp = (TopicPartition)tuple2._1();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new EpochEndOffset(error, -1, -1L));
                return tuple22;
            });
        }
        return map;
    }

    @Override
    public boolean isOffsetForLeaderEpochSupported() {
        return this.brokerSupportsLeaderEpochRequest();
    }

    private boolean shouldFollowerThrottle(ReplicaQuota quota, TopicPartition topicPartition) {
        boolean isReplicaInSync = this.fetcherLagStats().isReplicaInSync(topicPartition);
        return !isReplicaInSync && quota.isThrottled(topicPartition) && quota.isQuotaExceeded();
    }

    public ReplicaFetcherThread(String name, int fetcherId, BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, FailedPartitions failedPartitions, ReplicaManager replicaMgr, Metrics metrics, Time time, ReplicaQuota quota, Option<BlockingSend> leaderEndpointBlockingSend) {
        this.fetcherId = fetcherId;
        this.brokerConfig = brokerConfig;
        this.replicaMgr = replicaMgr;
        this.metrics = metrics;
        this.time = time;
        this.quota = quota;
        super(name, name, sourceBroker, failedPartitions, Predef$.MODULE$.Integer2int(brokerConfig.replicaFetchBackoffMs()), false);
        this.replicaId = brokerConfig.brokerId();
        this.logContext = new LogContext(new StringBuilder(0).append(new StringBuilder(39).append("[ReplicaFetcher replicaId=").append(this.replicaId()).append(", leaderId=").append(super.sourceBroker().id()).append(", ").toString()).append(new StringBuilder(12).append("fetcherId=").append(fetcherId).append("] ").toString()).toString());
        this.logIdent_$eq(this.logContext().logPrefix());
        this.leaderEndpoint = (BlockingSend)leaderEndpointBlockingSend.getOrElse((Function0 & Serializable)() -> new ReplicaFetcherBlockingSend(this.super$sourceBroker(), $this.brokerConfig, $this.metrics, $this.time, $this.fetcherId, new StringBuilder(16).append("broker-").append(this.replicaId()).append("-fetcher-").append($this.fetcherId).toString(), this.logContext()));
        this.fetchRequestVersion = (short)(brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_3_IV1$.MODULE$) ? 11 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_1_IV2$.MODULE$) ? 10 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_0_IV1$.MODULE$) ? 8 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_1_1_IV0$.MODULE$) ? 7 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV1$.MODULE$) ? 5 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV0$.MODULE$) ? 4 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV1$.MODULE$) ? 3 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_0_IV0$.MODULE$) ? 2 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_9_0$.MODULE$) ? 1 : 0)))))))));
        this.offsetForLeaderEpochRequestVersion = (short)(brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_3_IV1$.MODULE$) ? 3 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_1_IV1$.MODULE$) ? 2 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_0_IV0$.MODULE$) ? 1 : 0)));
        this.listOffsetRequestVersion = (short)(brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_2_IV1$.MODULE$) ? 5 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_1_IV1$.MODULE$) ? 4 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_0_IV1$.MODULE$) ? 3 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV0$.MODULE$) ? 2 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV2$.MODULE$) ? 1 : 0)))));
        this.maxWait = brokerConfig.replicaFetchWaitMaxMs();
        this.minBytes = brokerConfig.replicaFetchMinBytes();
        this.maxBytes = brokerConfig.replicaFetchResponseMaxBytes();
        this.fetchSize = brokerConfig.replicaFetchMaxBytes();
        this.brokerSupportsLeaderEpochRequest = brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV2$.MODULE$);
        this.fetchSessionHandler = new FetchSessionHandler(this.logContext(), super.sourceBroker().id());
    }
}

