/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.api.LeaderAndIsr;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.utils.Logging;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicPartitionStateZNode$;
import org.apache.kafka.common.TopicPartition;
import org.apache.zookeeper.data.Stat;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.runtime.BoxesRunTime;

public final class ReplicationUtils$
implements Logging {
    public static final ReplicationUtils$ MODULE$ = new ReplicationUtils$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$(MODULE$);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ReplicationUtils$ replicationUtils$ = this;
        synchronized (replicationUtils$) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        return !bitmap$0 ? this.logger$lzycompute() : logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public Tuple2<Object, Object> updateLeaderAndIsr(KafkaZkClient zkClient2, TopicPartition partition, LeaderAndIsr newLeaderAndIsr, int controllerEpoch) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(20).append("Updated ISR for ").append(partition).append(" to ").append(newLeaderAndIsr.isr().mkString(",")).toString());
        String path2 = TopicPartitionStateZNode$.MODULE$.path(partition);
        byte[] newLeaderData = TopicPartitionStateZNode$.MODULE$.encode(new LeaderIsrAndControllerEpoch(newLeaderAndIsr, controllerEpoch));
        Tuple2<Object, Object> updatePersistentPath = zkClient2.conditionalUpdatePath(path2, newLeaderData, newLeaderAndIsr.zkVersion(), (Option<Function3<KafkaZkClient, String, byte[], Tuple2<Object, Object>>>)new Some((Function3 & Serializable)(zkClient, path, expectedLeaderAndIsrInfo) -> MODULE$.checkLeaderAndIsrZkData((KafkaZkClient)zkClient, (String)path, (byte[])expectedLeaderAndIsrInfo)));
        return updatePersistentPath;
    }

    private Tuple2<Object, Object> checkLeaderAndIsrZkData(KafkaZkClient zkClient, String path, byte[] expectedLeaderAndIsrInfo) {
        Tuple2.mcZI.sp sp2;
        block4: {
            try {
                Tuple2<Option<byte[]>, Stat> tuple2 = zkClient.getDataAndStat(path);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Option writtenLeaderOpt = (Option)tuple2._1();
                Stat writtenStat = (Stat)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)writtenLeaderOpt, (Object)writtenStat);
                Tuple2 tuple23 = tuple22;
                Option writtenLeaderOpt2 = (Option)tuple23._1();
                Stat writtenStat2 = (Stat)tuple23._2();
                Option<LeaderIsrAndControllerEpoch> expectedLeaderOpt = TopicPartitionStateZNode$.MODULE$.decode(expectedLeaderAndIsrInfo, writtenStat2);
                boolean succeeded = writtenLeaderOpt2.exists((Function1 & Serializable)writtenData -> BoxesRunTime.boxToBoolean((boolean)ReplicationUtils$.$anonfun$checkLeaderAndIsrZkData$1(writtenStat2, expectedLeaderOpt, writtenData)));
                if (succeeded) {
                    sp2 = new Tuple2.mcZI.sp(true, writtenStat2.getVersion());
                    break block4;
                }
                sp2 = new Tuple2.mcZI.sp(false, -1);
            }
            catch (Exception exception) {
                sp2 = new Tuple2.mcZI.sp(false, -1);
            }
        }
        return sp2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$checkLeaderAndIsrZkData$1(Stat writtenStat$1, Option expectedLeaderOpt$1, byte[] writtenData) {
        Option<LeaderIsrAndControllerEpoch> writtenLeaderOpt = TopicPartitionStateZNode$.MODULE$.decode(writtenData, writtenStat$1);
        Tuple2 tuple2 = new Tuple2((Object)expectedLeaderOpt$1, writtenLeaderOpt);
        if (tuple2 == null) return false;
        Option option = (Option)tuple2._1();
        Option option2 = (Option)tuple2._2();
        if (!(option instanceof Some)) return false;
        Some some = (Some)option;
        LeaderIsrAndControllerEpoch expectedLeader = (LeaderIsrAndControllerEpoch)some.value();
        if (!(option2 instanceof Some)) return false;
        Some some2 = (Some)option2;
        LeaderIsrAndControllerEpoch writtenLeader = (LeaderIsrAndControllerEpoch)some2.value();
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = expectedLeader;
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch2 = writtenLeader;
        if (leaderIsrAndControllerEpoch != null) {
            if (!((Object)leaderIsrAndControllerEpoch).equals(leaderIsrAndControllerEpoch2)) return false;
            return true;
        }
        if (leaderIsrAndControllerEpoch2 == null) return true;
        return false;
    }

    private ReplicationUtils$() {
    }
}

