/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import kafka.log.AbortedTxn;
import kafka.log.BatchMetadata;
import kafka.log.Log$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogSegment;
import kafka.log.LogSegment$;
import kafka.log.LogUtils$;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateManager;
import kafka.log.RollParams;
import kafka.server.FetchDataInfo;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableFactory;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.SeqOps;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005uh\u0001B\u0014)\u00015BQ\u0001\u000e\u0001\u0005\u0002UBq\u0001\u000f\u0001C\u0002\u0013\u0005\u0011\b\u0003\u0004F\u0001\u0001\u0006IA\u000f\u0005\b\r\u0002\u0011\r\u0011\"\u0001H\u0011\u0019\u0019\u0006\u0001)A\u0005\u0011\"IA\u000b\u0001a\u0001\u0002\u0004%\t!\u0016\u0005\n=\u0002\u0001\r\u00111A\u0005\u0002}C\u0011\"\u001a\u0001A\u0002\u0003\u0005\u000b\u0015\u0002,\t\u000b\u0019\u0004A\u0011A4\t\u000fi\u0004\u0011\u0013!C\u0001w\"I\u0011Q\u0002\u0001\u0012\u0002\u0013\u0005\u0011q\u0002\u0005\b\u0003'\u0001A\u0011AA\u000b\u0011\u001d\t\u0019\u0005\u0001C\u0001\u0003\u000bBq!!\u0016\u0001\t\u0003\t)\u0005C\u0004\u0002`\u0001!\t!!\u0012\t\u000f\u0005%\u0004\u0001\"\u0001\u0002F!9\u0011Q\u000e\u0001\u0005\u0002\u0005\u0015\u0003bBA9\u0001\u0011\u0005\u0011Q\t\u0005\b\u0003k\u0002A\u0011AA#\u0011\u001d\tI\b\u0001C\u0001\u0003\u000bBq!! \u0001\t\u0003\t)\u0005C\u0004\u0002\u0002\u0002!\t!!\u0012\t\u000f\u0005\u0015\u0005\u0001\"\u0001\u0002F!9\u0011\u0011\u0012\u0001\u0005\u0002\u0005\u0015\u0003bBAG\u0001\u0011\u0005\u0011Q\t\u0005\b\u0003#\u0003A\u0011AA#\u0011\u001d\t)\n\u0001C\u0001\u0003\u000bBq!!'\u0001\t\u0013\tY\n\u0003\u0005\u0002D\u0002\t\n\u0011\"\u0003|\u0011!\t)\rAI\u0001\n\u0013Y\b\"CAd\u0001E\u0005I\u0011BAe\u0011\u001d\ti\r\u0001C\u0001\u0003\u000bBq!!5\u0001\t\u0003\t)\u0005\u0003\u0004g\u0001\u0011%\u0011Q\u001b\u0005\b\u0003[\u0004A\u0011AA#\u0011\u001d\t\t\u0010\u0001C\u0001\u0003\u000bBq!!>\u0001\t\u0003\t)\u0005C\u0004\u0002z\u0002!\t!!\u0012\u0003\u001d1{wmU3h[\u0016tG\u000fV3ti*\u0011\u0011FK\u0001\u0004Y><'\"A\u0016\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\f\t\u0003_Ij\u0011\u0001\r\u0006\u0002c\u0005)1oY1mC&\u00111\u0007\r\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u00051\u0004CA\u001c\u0001\u001b\u0005A\u0013A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\\u000b\u0002uA\u00111hQ\u0007\u0002y)\u0011QHP\u0001\u0007G>lWn\u001c8\u000b\u0005-z$B\u0001!B\u0003\u0019\t\u0007/Y2iK*\t!)A\u0002pe\u001eL!\u0001\u0012\u001f\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006yAo\u001c9jGB\u000b'\u000f^5uS>t\u0007%\u0001\u0005tK\u001elWM\u001c;t+\u0005A\u0005cA%O!6\t!J\u0003\u0002L\u0019\u00069Q.\u001e;bE2,'BA'1\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u001f*\u00131\"\u0011:sCf\u0014UO\u001a4feB\u0011q'U\u0005\u0003%\"\u0012!\u0002T8h'\u0016<W.\u001a8u\u0003%\u0019XmZ7f]R\u001c\b%\u0001\u0004m_\u001e$\u0015N]\u000b\u0002-B\u0011q\u000bX\u0007\u00021*\u0011\u0011LW\u0001\u0003S>T\u0011aW\u0001\u0005U\u00064\u0018-\u0003\u0002^1\n!a)\u001b7f\u0003)awn\u001a#je~#S-\u001d\u000b\u0003A\u000e\u0004\"aL1\n\u0005\t\u0004$\u0001B+oSRDq\u0001Z\u0004\u0002\u0002\u0003\u0007a+A\u0002yIE\nq\u0001\\8h\t&\u0014\b%A\u0007de\u0016\fG/Z*fO6,g\u000e\u001e\u000b\u0005!\"l'\u000fC\u0003j\u0013\u0001\u0007!.\u0001\u0004pM\u001a\u001cX\r\u001e\t\u0003_-L!\u0001\u001c\u0019\u0003\t1{gn\u001a\u0005\b]&\u0001\n\u00111\u0001p\u0003IIg\u000eZ3y\u0013:$XM\u001d<bY\nKH/Z:\u0011\u0005=\u0002\u0018BA91\u0005\rIe\u000e\u001e\u0005\bg&\u0001\n\u00111\u0001u\u0003\u0011!\u0018.\\3\u0011\u0005UDX\"\u0001<\u000b\u0005]d\u0014!B;uS2\u001c\u0018BA=w\u0005\u0011!\u0016.\\3\u0002/\r\u0014X-\u0019;f'\u0016<W.\u001a8uI\u0011,g-Y;mi\u0012\u0012T#\u0001?+\u0005=l8&\u0001@\u0011\u0007}\fI!\u0004\u0002\u0002\u0002)!\u00111AA\u0003\u0003%)hn\u00195fG.,GMC\u0002\u0002\bA\n!\"\u00198o_R\fG/[8o\u0013\u0011\tY!!\u0001\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\fde\u0016\fG/Z*fO6,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011\u0011\u0003\u0016\u0003iv\fqA]3d_J$7\u000f\u0006\u0004\u0002\u0018\u0005\r\u0012Q\u0005\t\u0005\u00033\ty\"\u0004\u0002\u0002\u001c)\u0019\u0011Q\u0004\u001f\u0002\rI,7m\u001c:e\u0013\u0011\t\t#a\u0007\u0003\u001b5+Wn\u001c:z%\u0016\u001cwN\u001d3t\u0011\u0015IG\u00021\u0001k\u0011\u001d\t\u0019\u0002\u0004a\u0001\u0003O\u0001RaLA\u0015\u0003[I1!a\u000b1\u0005)a$/\u001a9fCR,GM\u0010\t\u0005\u0003_\tiD\u0004\u0003\u00022\u0005e\u0002cAA\u001aa5\u0011\u0011Q\u0007\u0006\u0004\u0003oa\u0013A\u0002\u001fs_>$h(C\u0002\u0002<A\na\u0001\u0015:fI\u00164\u0017\u0002BA \u0003\u0003\u0012aa\u0015;sS:<'bAA\u001ea\u0005)1/\u001a;vaR\t\u0001\rK\u0002\u000e\u0003\u0013\u0002B!a\u0013\u0002R5\u0011\u0011Q\n\u0006\u0004\u0003\u001f\n\u0015!\u00026v]&$\u0018\u0002BA*\u0003\u001b\u0012aAQ3g_J,\u0017\u0001\u0003;fCJ$wn\u001e8)\u00079\tI\u0006\u0005\u0003\u0002L\u0005m\u0013\u0002BA/\u0003\u001b\u0012Q!\u00114uKJ\fa\u0003^3tiJ+\u0017\rZ(o\u000b6\u0004H/_*fO6,g\u000e\u001e\u0015\u0004\u001f\u0005\r\u0004\u0003BA&\u0003KJA!a\u001a\u0002N\t!A+Z:u\u0003e!Xm\u001d;SK\u0006$')\u001a4pe\u00164\u0015N]:u\u001f\u001a47/\u001a;)\u0007A\t\u0019'A\tuKN$(+Z1e\u0003\u001a$XM\u001d'bgRD3!EA2\u0003=!Xm\u001d;SK\u0006$gI]8n\u000f\u0006\u0004\bf\u0001\n\u0002d\u0005aA/Z:u)J,hnY1uK\"\u001a1#a\u0019\u00021Q,7\u000f\u001e+sk:\u001c\u0017\r^3F[B$\u0018pU3h[\u0016tG\u000fK\u0002\u0015\u0003G\na\u0007^3tiJ+Gn\\1e\u0019\u0006\u0014x-Z:u)&lWm\u001d;b[B\fe\u000e\u001a(fqR|eMZ:fi\u00063G/\u001a:UeVt7-\u0019;j_:D3!FA2\u0003A!Xm\u001d;UeVt7-\u0019;f\rVdG\u000eK\u0002\u0017\u0003G\n\u0011\u0004^3ti\u001aKg\u000eZ(gMN,GOQ=US6,7\u000f^1na\"\u001aq#a\u0019\u00023Q,7\u000f\u001e(fqR|eMZ:fi\u000e\u000bGnY;mCRLwN\u001c\u0015\u00041\u0005\r\u0014A\u0006;fgR\u001c\u0005.\u00198hK\u001aKG.Z*vM\u001aL\u00070Z:)\u0007e\t\u0019'A\u000fuKN$(+Z2pm\u0016\u0014\u0018PR5yKN\u001cuN\u001d:vaRLe\u000eZ3yQ\rQ\u00121M\u0001\u001ci\u0016\u001cHOU3d_Z,'\u000f\u0016:b]N\f7\r^5p]&sG-\u001a=)\u0007m\t\u0019'A\u0007f]\u0012$\u0006P\u001c*fG>\u0014Hm\u001d\u000b\u0011\u0003/\ti*a*\u0002,\u0006U\u0016qWA^\u0003\u007fCq!a(\u001d\u0001\u0004\t\t+A\td_:$(o\u001c7SK\u000e|'\u000f\u001a+za\u0016\u0004B!!\u0007\u0002$&!\u0011QUA\u000e\u0005E\u0019uN\u001c;s_2\u0014VmY8sIRK\b/\u001a\u0005\u0007\u0003Sc\u0002\u0019\u00016\u0002\u0015A\u0014x\u000eZ;dKJLE\rC\u0004\u0002.r\u0001\r!a,\u0002\u001bA\u0014x\u000eZ;dKJ,\u0005o\\2i!\ry\u0013\u0011W\u0005\u0004\u0003g\u0003$!B*i_J$\b\"B5\u001d\u0001\u0004Q\u0007\u0002CA]9A\u0005\t\u0019A8\u0002)A\f'\u000f^5uS>tG*Z1eKJ,\u0005o\\2i\u0011!\ti\f\bI\u0001\u0002\u0004y\u0017\u0001E2p_J$\u0017N\\1u_J,\u0005o\\2i\u0011!\t\t\r\bI\u0001\u0002\u0004Q\u0017!\u0003;j[\u0016\u001cH/Y7q\u0003])g\u000e\u001a+y]J+7m\u001c:eg\u0012\"WMZ1vYR$S'A\ff]\u0012$\u0006P\u001c*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%m\u00059RM\u001c3Uq:\u0014VmY8sIN$C-\u001a4bk2$HeN\u000b\u0003\u0003\u0017T#A[?\u0002CQ,7\u000f\u001e*fG>4XM]=GSb,7oQ8seV\u0004H\u000fV5nK&sG-\u001a=)\u0007\u0001\n\u0019'\u0001\u0010uKN$(+Z2pm\u0016\u0014\u0018pV5uQ\u000e{'O];qi6+7o]1hK\"\u001a\u0011%a\u0019\u0015\u0013A\u000b9.a7\u0002f\u0006%\bBBAmE\u0001\u0007!.\u0001\u0006cCN,wJ\u001a4tKRDq!!8#\u0001\u0004\ty.A\tgS2,\u0017\t\u001c:fC\u0012LX\t_5tiN\u00042aLAq\u0013\r\t\u0019\u000f\r\u0002\b\u0005>|G.Z1o\u0011\u0019\t9O\ta\u0001_\u0006a\u0011N\\5u\r&dWmU5{K\"9\u00111\u001e\u0012A\u0002\u0005}\u0017a\u00039sK\u0006dGn\\2bi\u0016\fq\u0005^3ti\u000e\u0013X-\u0019;f/&$\b.\u00138ji\u001aKG.Z*ju\u0016\f\u0005\u000f]3oI6+7o]1hK\"\u001a1%a\u0019\u0002OQ,7\u000f^\"sK\u0006$XmV5uQ&s\u0017\u000e\u001e$jY\u0016\u001c\u0016N_3DY\u0016\f'o\u00155vi\u0012|wO\u001c\u0015\u0004I\u0005\r\u0014AL:i_VdG\r\u0016:v]\u000e\fG/Z#wK:Lem\u00144gg\u0016$\bk\\5oiN$v.Q$ba&sG\u000b[3M_\u001eD3!JA2\u0003I!Xm\u001d;BaB,g\u000e\u001a$s_64\u0015\u000e\\3)\u0007\u0019\n\u0019\u0007")
public class LogSegmentTest {
    private final TopicPartition topicPartition = new TopicPartition("topic", 0);
    private final ArrayBuffer<LogSegment> segments = (ArrayBuffer)IterableFactory.apply$((IterableFactory)ArrayBuffer$.MODULE$, (Seq)Nil$.MODULE$);
    private File logDir;

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public ArrayBuffer<LogSegment> segments() {
        return this.segments;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public LogSegment createSegment(long offset, int indexIntervalBytes, Time time) {
        LogSegment seg = LogUtils$.MODULE$.createSegment(offset, this.logDir(), indexIntervalBytes, time);
        ArrayBuffer<LogSegment> arrayBuffer = this.segments();
        if (arrayBuffer == null) {
            throw null;
        }
        arrayBuffer.addOne((Object)seg);
        return seg;
    }

    /*
     * WARNING - void declaration
     */
    public MemoryRecords records(long offset, Seq<String> records) {
        void withRecords_records;
        void withRecords_timestampType;
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])((IterableOnceOps)records.map((Function1 & Serializable)s -> new SimpleRecord(offset * 10L, s.getBytes()))).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        TimestampType timestampType = TimestampType.CREATE_TIME;
        CompressionType withRecords_compressionType = CompressionType.NONE;
        return MemoryRecords.withRecords((byte)1, (long)offset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
    }

    @Before
    public void setup() {
        this.logDir_$eq(TestUtils.tempDirectory(null, null));
    }

    @After
    public void teardown() {
        this.segments().foreach((Function1 & Serializable)x$2 -> {
            x$2.close();
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)this.logDir());
    }

    @Test
    public void testReadOnEmptySegment() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        FetchDataInfo read = seg.read(40L, 300, seg.read$default$3(), seg.read$default$4());
        Assert.assertNull((String)"Read beyond the last offset in the segment should be null", (Object)read);
    }

    @Test
    public void testReadBeforeFirstOffset() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        MemoryRecords ms = this.records(50L, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "little", "bee"}));
        seg.append(53L, -1L, -1L, ms);
        Records read = seg.read(41L, 300, seg.read$default$3(), seg.read$default$4()).records();
        TestUtils$.MODULE$.checkEquals(ms.records().iterator(), read.records().iterator());
    }

    @Test
    public void testReadAfterLast() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        MemoryRecords ms = this.records(50L, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, -1L, -1L, ms);
        FetchDataInfo read = seg.read(52L, 200, seg.read$default$3(), seg.read$default$4());
        Assert.assertNull((String)"Read beyond the last offset in the segment should give null", (Object)read);
    }

    @Test
    public void testReadFromGap() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        MemoryRecords ms = this.records(50L, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, -1L, -1L, ms);
        MemoryRecords ms2 = this.records(60L, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(61L, -1L, -1L, ms2);
        FetchDataInfo read = seg.read(55L, 200, seg.read$default$3(), seg.read$default$4());
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), read.records().records().iterator());
    }

    @Test
    public void testTruncate() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        int n = 40;
        int n2 = 0;
        int until$extension_end = 30;
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n2, until$extension_end, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                MemoryRecords $anonfun$testTruncate$1_ms1 = this.records(n, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello"}));
                seg.append((long)n, -1L, -1L, $anonfun$testTruncate$1_ms1);
                MemoryRecords $anonfun$testTruncate$1_ms2 = this.records(n + 1, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello"}));
                seg.append((long)(n + 1), -1L, -1L, $anonfun$testTruncate$1_ms2);
                FetchDataInfo $anonfun$testTruncate$1_read = seg.read((long)n, 10000, seg.read$default$3(), seg.read$default$4());
                Assert.assertEquals((Object)new .colon.colon((Object)((Record)$anonfun$testTruncate$1_ms1.records().iterator().next()), (List)new .colon.colon((Object)((Record)$anonfun$testTruncate$1_ms2.records().iterator().next()), (List)Nil$.MODULE$)), (Object)AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)$anonfun$testTruncate$1_read.records().records()).asScala().toList());
                seg.truncateTo((long)(n + 1));
                FetchDataInfo $anonfun$testTruncate$1_read2 = seg.read((long)n, 10000, seg.read$default$3(), seg.read$default$4());
                Assert.assertEquals((long)1L, (long)AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)$anonfun$testTruncate$1_read2.records().records()).asScala().size());
                TestUtils$.MODULE$.checkEquals($anonfun$testTruncate$1_ms1.records().iterator(), $anonfun$testTruncate$1_read2.records().records().iterator());
                ++n;
                Object var6_7 = null;
                Object var7_8 = null;
                Object var8_9 = null;
                Object var9_10 = null;
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
    }

    @Test
    public void testTruncateEmptySegment() {
        int maxSegmentMs = 300000;
        MockTime time = new MockTime();
        int x$3 = this.createSegment$default$2();
        LogSegment seg = this.createSegment(0L, x$3, (Time)time);
        seg.timeIndex();
        seg.offsetIndex();
        seg.close();
        int x$6 = this.createSegment$default$2();
        LogSegment reopened = this.createSegment(0L, x$6, (Time)time);
        Assert.assertEquals((long)0L, (long)seg.timeIndex().sizeInBytes());
        Assert.assertEquals((long)0L, (long)seg.offsetIndex().sizeInBytes());
        time.sleep(500L);
        reopened.truncateTo(57L);
        Assert.assertEquals((long)0L, (long)reopened.timeWaitedForRoll(time.milliseconds(), -1L));
        Assert.assertFalse((boolean)reopened.timeIndex().isFull());
        Assert.assertFalse((boolean)reopened.offsetIndex().isFull());
        RollParams rollParams = new RollParams((long)maxSegmentMs, Integer.MAX_VALUE, -1L, 100L, 1024, time.milliseconds());
        Assert.assertFalse((boolean)reopened.shouldRoll(rollParams));
        time.sleep((long)(maxSegmentMs + 1));
        Assert.assertEquals((long)(maxSegmentMs + 1), (long)reopened.timeWaitedForRoll(time.milliseconds(), -1L));
        rollParams = new RollParams((long)maxSegmentMs, Integer.MAX_VALUE, -1L, 100L, 1024, time.milliseconds());
        Assert.assertFalse((boolean)reopened.shouldRoll(rollParams));
        rollParams = new RollParams((long)maxSegmentMs, Integer.MAX_VALUE, -1L, (long)Integer.MAX_VALUE + 200L, 1024, time.milliseconds());
        Assert.assertTrue((boolean)reopened.shouldRoll(rollParams));
    }

    @Test
    public void testReloadLargestTimestampAndNextOffsetAfterTruncation() {
        int numMessages = 30;
        LogSegment seg = this.createSegment(40L, 2 * this.records(0L, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello"})).sizeInBytes() - 1, this.createSegment$default$3());
        int n = 40;
        int n2 = 0;
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n2, numMessages, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                seg.append((long)n, (long)n, (long)n, this.records(n, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello"})));
                ++n;
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Object var5_5 = null;
        Assert.assertEquals((long)n, (long)seg.readNextOffset());
        int expectedNumEntries = numMessages / 2 - 1;
        Assert.assertEquals((String)new StringBuilder(25).append("Should have ").append(expectedNumEntries).append(" time indexes").toString(), (long)expectedNumEntries, (long)seg.timeIndex().entries());
        seg.truncateTo(41L);
        Assert.assertEquals((String)"Should have 0 time indexes", (long)0L, (long)seg.timeIndex().entries());
        Assert.assertEquals((String)"Largest timestamp should be 400", (long)400L, (long)seg.largestTimestamp());
        Assert.assertEquals((long)41L, (long)seg.readNextOffset());
    }

    @Test
    public void testTruncateFull() {
        MockTime time = new MockTime();
        int x$3 = this.createSegment$default$2();
        LogSegment seg = this.createSegment(40L, x$3, (Time)time);
        seg.append(41L, -1L, -1L, this.records(40L, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"})));
        time.sleep(500L);
        Assert.assertEquals((long)500L, (long)seg.timeWaitedForRoll(time.milliseconds(), -1L));
        seg.truncateTo(0L);
        Assert.assertEquals((long)0L, (long)seg.timeWaitedForRoll(time.milliseconds(), -1L));
        Assert.assertFalse((boolean)seg.timeIndex().isFull());
        Assert.assertFalse((boolean)seg.offsetIndex().isFull());
        Assert.assertNull((String)"Segment should be empty.", (Object)seg.read(0L, 1024, seg.read$default$3(), seg.read$default$4()));
        seg.append(41L, -1L, -1L, this.records(40L, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"})));
    }

    @Test
    public void testFindOffsetByTimestamp() {
        int messageSize = this.records(0L, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"msg00"})).sizeInBytes();
        LogSegment seg = this.createSegment(40L, messageSize * 2 - 1, this.createSegment$default$3());
        int n = 40;
        int until$extension_end = 50;
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                seg.append((long)foreach$mVc$sp_i, (long)(foreach$mVc$sp_i * 10), (long)foreach$mVc$sp_i, this.records(foreach$mVc$sp_i, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(3).append("msg").append(foreach$mVc$sp_i).toString()})));
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Object var4_5 = null;
        Assert.assertEquals((long)490L, (long)seg.largestTimestamp());
        Assert.assertEquals((long)42L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)420L, (long)seg.findOffsetByTimestamp$default$2()).get()).offset);
        Assert.assertEquals((long)43L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)421L, (long)seg.findOffsetByTimestamp$default$2()).get()).offset);
        Assert.assertEquals((long)43L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)430L, (long)seg.findOffsetByTimestamp$default$2()).get()).offset);
        Assert.assertEquals((long)44L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)431L, (long)seg.findOffsetByTimestamp$default$2()).get()).offset);
        Assert.assertEquals((Object)None$.MODULE$, (Object)seg.findOffsetByTimestamp(491L, seg.findOffsetByTimestamp$default$2()));
        Assert.assertEquals((long)41L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)401L, (long)seg.findOffsetByTimestamp$default$2()).get()).offset);
        Assert.assertEquals((long)40L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)399L, (long)seg.findOffsetByTimestamp$default$2()).get()).offset);
    }

    @Test
    public void testNextOffsetCalculation() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        Assert.assertEquals((long)40L, (long)seg.readNextOffset());
        seg.append(52L, -1L, -1L, this.records(50L, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "you"})));
        Assert.assertEquals((long)53L, (long)seg.readNextOffset());
    }

    @Test
    public void testChangeFileSuffixes() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        File logFile = seg.log().file();
        File indexFile = seg.lazyOffsetIndex().file();
        File timeIndexFile = seg.lazyTimeIndex().file();
        Assert.assertFalse((boolean)seg.lazyOffsetIndex().file().exists());
        Assert.assertFalse((boolean)seg.lazyTimeIndex().file().exists());
        seg.changeFileSuffixes("", ".deleted");
        Assert.assertFalse((boolean)seg.lazyOffsetIndex().file().exists());
        Assert.assertFalse((boolean)seg.lazyTimeIndex().file().exists());
        Assert.assertEquals((Object)new StringBuilder(8).append(logFile.getAbsolutePath()).append(".deleted").toString(), (Object)seg.log().file().getAbsolutePath());
        Assert.assertEquals((Object)new StringBuilder(8).append(indexFile.getAbsolutePath()).append(".deleted").toString(), (Object)seg.lazyOffsetIndex().file().getAbsolutePath());
        Assert.assertEquals((Object)new StringBuilder(8).append(timeIndexFile.getAbsolutePath()).append(".deleted").toString(), (Object)seg.lazyTimeIndex().file().getAbsolutePath());
        Assert.assertTrue((boolean)seg.log().file().exists());
        seg.lazyOffsetIndex().get();
        Assert.assertTrue((boolean)seg.lazyOffsetIndex().file().exists());
        seg.lazyTimeIndex().get();
        Assert.assertTrue((boolean)seg.lazyTimeIndex().file().exists());
    }

    @Test
    public void testRecoveryFixesCorruptIndex() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3());
        int n = 0;
        int until$extension_end = 100;
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                seg.append((long)foreach$mVc$sp_i, -1L, -1L, this.records(foreach$mVc$sp_i, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{((Object)foreach$mVc$sp_i).toString()})));
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Object var5_4 = null;
        File indexFile = seg.lazyOffsetIndex().file();
        TestUtils$.MODULE$.writeNonsenseToFile(indexFile, 5L, (int)indexFile.length());
        seg.recover(new ProducerStateManager(this.topicPartition(), this.logDir(), 3600000), seg.recover$default$2());
        int n2 = 0;
        int until$extension_end2 = 100;
        Range.Exclusive foreach$mVc$sp_this2 = new Range.Exclusive(n2, until$extension_end2, 1);
        if (!foreach$mVc$sp_this2.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this2.start();
            while (true) {
                LogSegmentTest.$anonfun$testRecoveryFixesCorruptIndex$2(seg, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this2.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this2.step();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecoverTransactionIndex() {
        void withRecords_records;
        void withRecords_compressionType;
        void withTransactionalRecords_records;
        void withTransactionalRecords_compressionType;
        void withTransactionalRecords_records2;
        void withTransactionalRecords_compressionType2;
        LogSegment segment = this.createSegment(100L, this.createSegment$default$2(), this.createSegment$default$3());
        short producerEpoch = (short)0;
        int partitionLeaderEpoch = 15;
        int sequence = 100;
        long pid1 = 5L;
        long pid2 = 10L;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())};
        CompressionType compressionType = CompressionType.NONE;
        long withTransactionalRecords_initialOffset = 100L;
        compressionType = null;
        simpleRecordArray = null;
        segment.append(101L, -1L, 100L, MemoryRecords.withRecords((byte)2, (long)withTransactionalRecords_initialOffset, (CompressionType)withTransactionalRecords_compressionType2, (TimestampType)TimestampType.CREATE_TIME, (long)pid1, (short)producerEpoch, (int)sequence, (int)partitionLeaderEpoch, (boolean)true, (SimpleRecord[])withTransactionalRecords_records2));
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())};
        CompressionType compressionType2 = CompressionType.NONE;
        long withTransactionalRecords_initialOffset2 = 102L;
        compressionType2 = null;
        simpleRecordArray2 = null;
        segment.append(103L, -1L, 102L, MemoryRecords.withRecords((byte)2, (long)withTransactionalRecords_initialOffset2, (CompressionType)withTransactionalRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)pid2, (short)producerEpoch, (int)sequence, (int)partitionLeaderEpoch, (boolean)true, (SimpleRecord[])withTransactionalRecords_records));
        SimpleRecord[] simpleRecordArray3 = new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())};
        CompressionType compressionType3 = CompressionType.NONE;
        long withRecords_initialOffset = 104L;
        compressionType3 = null;
        simpleRecordArray3 = null;
        segment.append(105L, -1L, 104L, MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records));
        segment.append(106L, -1L, 106L, this.endTxnRecords(ControlRecordType.ABORT, pid2, producerEpoch, 106L, 0, 0, -1L));
        segment.append(107L, -1L, 107L, this.endTxnRecords(ControlRecordType.COMMIT, pid1, producerEpoch, 107L, 0, 0, -1L));
        ProducerStateManager stateManager = new ProducerStateManager(this.topicPartition(), this.logDir(), 3600000);
        segment.recover(stateManager, segment.recover$default$2());
        Assert.assertEquals((long)108L, (long)stateManager.mapEndOffset());
        List abortedTxns = segment.txnIndex().allAbortedTxns();
        if (abortedTxns == null) {
            throw null;
        }
        Assert.assertEquals((long)1L, (long)SeqOps.size$((SeqOps)abortedTxns));
        AbortedTxn abortedTxn = (AbortedTxn)abortedTxns.head();
        Assert.assertEquals((long)pid2, (long)abortedTxn.producerId());
        Assert.assertEquals((long)102L, (long)abortedTxn.firstOffset());
        Assert.assertEquals((long)106L, (long)abortedTxn.lastOffset());
        Assert.assertEquals((long)100L, (long)abortedTxn.lastStableOffset());
        stateManager = new ProducerStateManager(this.topicPartition(), this.logDir(), 3600000);
        stateManager.loadProducerEntry(new ProducerStateEntry(pid2, (Queue)IterableFactory.apply$((IterableFactory)Queue$.MODULE$, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BatchMetadata[]{new BatchMetadata(10, 10L, 5, -1L)})), producerEpoch, 0, -1L, (Option)new Some((Object)75L)));
        segment.recover(stateManager, segment.recover$default$2());
        Assert.assertEquals((long)108L, (long)stateManager.mapEndOffset());
        abortedTxns = segment.txnIndex().allAbortedTxns();
        if (abortedTxns == null) {
            throw null;
        }
        Assert.assertEquals((long)1L, (long)SeqOps.size$((SeqOps)abortedTxns));
        abortedTxn = (AbortedTxn)abortedTxns.head();
        Assert.assertEquals((long)pid2, (long)abortedTxn.producerId());
        Assert.assertEquals((long)75L, (long)abortedTxn.firstOffset());
        Assert.assertEquals((long)106L, (long)abortedTxn.lastOffset());
        Assert.assertEquals((long)100L, (long)abortedTxn.lastStableOffset());
    }

    private MemoryRecords endTxnRecords(ControlRecordType controlRecordType, long producerId, short producerEpoch, long offset, int partitionLeaderEpoch, int coordinatorEpoch, long timestamp) {
        EndTransactionMarker marker = new EndTransactionMarker(controlRecordType, coordinatorEpoch);
        return MemoryRecords.withEndTransactionMarker((long)offset, (long)timestamp, (int)partitionLeaderEpoch, (long)producerId, (short)producerEpoch, (EndTransactionMarker)marker);
    }

    private int endTxnRecords$default$5() {
        return 0;
    }

    private int endTxnRecords$default$6() {
        return 0;
    }

    private long endTxnRecords$default$7() {
        return -1L;
    }

    @Test
    public void testRecoveryFixesCorruptTimeIndex() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3());
        int n = 0;
        int until$extension_end = 100;
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                seg.append((long)foreach$mVc$sp_i, (long)(foreach$mVc$sp_i * 10), (long)foreach$mVc$sp_i, this.records(foreach$mVc$sp_i, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{((Object)foreach$mVc$sp_i).toString()})));
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Object var5_4 = null;
        File timeIndexFile = seg.lazyTimeIndex().file();
        TestUtils$.MODULE$.writeNonsenseToFile(timeIndexFile, 5L, (int)timeIndexFile.length());
        seg.recover(new ProducerStateManager(this.topicPartition(), this.logDir(), 3600000), seg.recover$default$2());
        int n2 = 0;
        int until$extension_end2 = 100;
        Range.Exclusive foreach$mVc$sp_this2 = new Range.Exclusive(n2, until$extension_end2, 1);
        if (!foreach$mVc$sp_this2.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this2.start();
            while (true) {
                LogSegmentTest.$anonfun$testRecoveryFixesCorruptTimeIndex$2(seg, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this2.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this2.step();
            }
        }
    }

    @Test
    public void testRecoveryWithCorruptMessage() {
        int messagesAppended = 20;
        int n = 0;
        int until$extension_end = 10;
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                LogSegmentTest.$anonfun$testRecoveryWithCorruptMessage$1(this, messagesAppended, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private LogSegment createSegment(long baseOffset, boolean fileAlreadyExists, int initFileSize, boolean preallocate) {
        void $minus$greater$extension_y;
        Integer n;
        void $minus$greater$extension_y2;
        Integer n2;
        void $minus$greater$extension_y3;
        Integer n3;
        File file;
        File file2;
        File file3;
        File file4 = file3 = TestUtils.tempDirectory(null, null);
        file3 = null;
        File file5 = file2 = file4;
        file2 = null;
        File file6 = file = file5;
        file = null;
        File tempDir = file6;
        Object[] objectArray = new Tuple2[3];
        Integer n4 = n3 = Integer.valueOf(10);
        n3 = null;
        Integer n5 = n4;
        String $minus$greater$extension_$this = LogConfig$.MODULE$.IndexIntervalBytesProp();
        Object var9_11 = null;
        n5 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y3);
        Integer n6 = n2 = Integer.valueOf(1000);
        n2 = null;
        Integer n7 = n6;
        String $minus$greater$extension_$this2 = LogConfig$.MODULE$.SegmentIndexBytesProp();
        Object var11_14 = null;
        n7 = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        Integer n8 = n = Integer.valueOf(0);
        n = null;
        Integer n9 = n8;
        String $minus$greater$extension_$this3 = LogConfig$.MODULE$.SegmentJitterMsProp();
        Object var13_17 = null;
        n9 = null;
        objectArray[2] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y);
        LogConfig logConfig = new LogConfig(AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)))).asJava(), LogConfig$.MODULE$.apply$default$2());
        LogSegment seg = LogSegment$.MODULE$.open(tempDir, baseOffset, logConfig, Time.SYSTEM, fileAlreadyExists, initFileSize, preallocate, "");
        ArrayBuffer<LogSegment> arrayBuffer = this.segments();
        if (arrayBuffer == null) {
            throw null;
        }
        arrayBuffer.addOne((Object)seg);
        return seg;
    }

    public int createSegment$default$2() {
        return 10;
    }

    public Time createSegment$default$3() {
        return Time.SYSTEM;
    }

    @Test
    public void testCreateWithInitFileSizeAppendMessage() {
        LogSegment seg = this.createSegment(40L, false, 0x20000000, true);
        MemoryRecords ms = this.records(50L, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, -1L, -1L, ms);
        MemoryRecords ms2 = this.records(60L, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(61L, -1L, -1L, ms2);
        FetchDataInfo read = seg.read(55L, 200, seg.read$default$3(), seg.read$default$4());
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), read.records().records().iterator());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateWithInitFileSizeClearShutdown() {
        void $minus$greater$extension_y;
        Integer n;
        void $minus$greater$extension_y2;
        Integer n2;
        void $minus$greater$extension_y3;
        Integer n3;
        File file;
        File file2;
        File file3;
        File file4 = file3 = TestUtils.tempDirectory(null, null);
        file3 = null;
        File file5 = file2 = file4;
        file2 = null;
        File file6 = file = file5;
        file = null;
        File tempDir = file6;
        Object[] objectArray = new Tuple2[3];
        Integer n4 = n3 = Integer.valueOf(10);
        n3 = null;
        Integer n5 = n4;
        String $minus$greater$extension_$this = LogConfig$.MODULE$.IndexIntervalBytesProp();
        Object var19_7 = null;
        n5 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y3);
        Integer n6 = n2 = Integer.valueOf(1000);
        n2 = null;
        Integer n7 = n6;
        String $minus$greater$extension_$this2 = LogConfig$.MODULE$.SegmentIndexBytesProp();
        Object var21_10 = null;
        n7 = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        Integer n8 = n = Integer.valueOf(0);
        n = null;
        Integer n9 = n8;
        String $minus$greater$extension_$this3 = LogConfig$.MODULE$.SegmentJitterMsProp();
        Object var23_13 = null;
        n9 = null;
        objectArray[2] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y);
        LogConfig logConfig = new LogConfig(AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)))).asJava(), LogConfig$.MODULE$.apply$default$2());
        LogSegment seg = LogSegment$.MODULE$.open(tempDir, 40L, logConfig, Time.SYSTEM, false, 0x20000000, true, "");
        MemoryRecords ms = this.records(50L, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, -1L, -1L, ms);
        MemoryRecords ms2 = this.records(60L, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(61L, -1L, -1L, ms2);
        FetchDataInfo read = seg.read(55L, 200, seg.read$default$3(), seg.read$default$4());
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), read.records().records().iterator());
        int oldSize = seg.log().sizeInBytes();
        long oldPosition = seg.log().channel().position();
        long oldFileSize = seg.log().file().length();
        Assert.assertEquals((long)0x20000000L, (long)oldFileSize);
        seg.close();
        Assert.assertEquals((long)oldSize, (long)seg.log().file().length());
        LogSegment segReopen = LogSegment$.MODULE$.open(tempDir, 40L, logConfig, Time.SYSTEM, true, 0x20000000, true, "");
        ArrayBuffer<LogSegment> arrayBuffer = this.segments();
        if (arrayBuffer == null) {
            throw null;
        }
        arrayBuffer.addOne((Object)segReopen);
        FetchDataInfo readAgain = segReopen.read(55L, 200, segReopen.read$default$3(), segReopen.read$default$4());
        TestUtils$.MODULE$.checkEquals(ms2.records().iterator(), readAgain.records().records().iterator());
        int size = segReopen.log().sizeInBytes();
        long position = segReopen.log().channel().position();
        long fileSize = segReopen.log().file().length();
        Assert.assertEquals((long)oldPosition, (long)position);
        Assert.assertEquals((long)oldSize, (long)size);
        Assert.assertEquals((long)size, (long)fileSize);
    }

    @Test
    public void shouldTruncateEvenIfOffsetPointsToAGapInTheLog() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        int offset = 40;
        MemoryRecords ms1 = LogSegmentTest.records$1(offset, "first message");
        seg.append((long)offset, -1L, -1L, ms1);
        MemoryRecords ms2 = LogSegmentTest.records$1(offset + 3, "message after gap");
        seg.append((long)(offset + 3), -1L, -1L, ms2);
        seg.truncateTo((long)(offset + 1));
        FetchDataInfo log = seg.read((long)offset, 10000, seg.read$default$3(), seg.read$default$4());
        Assert.assertEquals((long)offset, (long)((RecordBatch)log.records().batches().iterator().next()).baseOffset());
        Assert.assertEquals((long)1L, (long)AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)log.records().batches()).asScala().size());
    }

    @Test
    public void testAppendFromFile() {
        File file;
        File file2;
        File file3;
        File file4 = file3 = TestUtils.tempDirectory(null, null);
        file3 = null;
        File file5 = file2 = file4;
        file2 = null;
        File file6 = file = file5;
        file = null;
        File tempDir = file6;
        File open_file = Log$.MODULE$.logFile(tempDir, 0L, "");
        boolean open_mutable = true;
        Object var11_5 = null;
        FileRecords fileRecords = FileRecords.open((File)open_file, (boolean)open_mutable, (boolean)false, (int)0, (boolean)false);
        fileRecords.append(LogSegmentTest.records$2(0L, 1024));
        fileRecords.append(LogSegmentTest.records$2(500L, 0x100001));
        int sizeBeforeOverflow = fileRecords.sizeInBytes();
        fileRecords.append(LogSegmentTest.records$2(0x80000004L, 1024));
        int sizeAfterOverflow = fileRecords.sizeInBytes();
        LogSegment segment = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3());
        int bytesAppended = segment.appendFromFile(fileRecords, 0);
        Assert.assertEquals((long)sizeBeforeOverflow, (long)bytesAppended);
        Assert.assertEquals((long)sizeBeforeOverflow, (long)segment.size());
        LogSegment overflowSegment = this.createSegment(Integer.MAX_VALUE, this.createSegment$default$2(), this.createSegment$default$3());
        int overflowBytesAppended = overflowSegment.appendFromFile(fileRecords, sizeBeforeOverflow);
        Assert.assertEquals((long)(sizeAfterOverflow - sizeBeforeOverflow), (long)overflowBytesAppended);
        Assert.assertEquals((long)overflowBytesAppended, (long)overflowSegment.size());
        Utils.delete((File)tempDir);
    }

    public static final /* synthetic */ void $anonfun$testTruncate$1(LogSegmentTest $this, IntRef offset$2, LogSegment seg$1, int x$3) {
        MemoryRecords ms1 = $this.records(offset$2.elem, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello"}));
        seg$1.append((long)offset$2.elem, -1L, -1L, ms1);
        MemoryRecords ms2 = $this.records(offset$2.elem + 1, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello"}));
        seg$1.append((long)(offset$2.elem + 1), -1L, -1L, ms2);
        FetchDataInfo read = seg$1.read((long)offset$2.elem, 10000, seg$1.read$default$3(), seg$1.read$default$4());
        Assert.assertEquals((Object)new .colon.colon((Object)((Record)ms1.records().iterator().next()), (List)new .colon.colon((Object)((Record)ms2.records().iterator().next()), (List)Nil$.MODULE$)), (Object)AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)read.records().records()).asScala().toList());
        seg$1.truncateTo((long)(offset$2.elem + 1));
        FetchDataInfo read2 = seg$1.read((long)offset$2.elem, 10000, seg$1.read$default$3(), seg$1.read$default$4());
        Assert.assertEquals((long)1L, (long)AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)read2.records().records()).asScala().size());
        TestUtils$.MODULE$.checkEquals(ms1.records().iterator(), read2.records().records().iterator());
        ++offset$2.elem;
    }

    public static final /* synthetic */ void $anonfun$testReloadLargestTimestampAndNextOffsetAfterTruncation$1(LogSegmentTest $this, LogSegment seg$2, IntRef offset$3, int x$4) {
        seg$2.append((long)offset$3.elem, (long)offset$3.elem, (long)offset$3.elem, $this.records(offset$3.elem, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"hello"})));
        ++offset$3.elem;
    }

    public static final /* synthetic */ void $anonfun$testRecoveryFixesCorruptIndex$2(LogSegment seg$4, int i) {
        long x$1 = i;
        long x$4 = seg$4.read$default$3();
        Iterable records = seg$4.read(x$1, 1, x$4, true).records().records();
        Assert.assertEquals((long)i, (long)((Record)records.iterator().next()).offset());
    }

    public static final /* synthetic */ void $anonfun$testRecoveryFixesCorruptTimeIndex$2(LogSegment seg$5, int i) {
        Assert.assertEquals((long)i, (long)((FileRecords.TimestampAndOffset)seg$5.findOffsetByTimestamp((long)((long)(i * 10)), (long)seg$5.findOffsetByTimestamp$default$2()).get()).offset);
        if (i < 99) {
            Assert.assertEquals((long)(i + 1), (long)((FileRecords.TimestampAndOffset)seg$5.findOffsetByTimestamp((long)((long)(i * 10 + 1)), (long)seg$5.findOffsetByTimestamp$default$2()).get()).offset);
        }
    }

    public static final /* synthetic */ void $anonfun$testRecoveryWithCorruptMessage$1(LogSegmentTest $this, int messagesAppended$1, int x$6) {
        LogSegment seg = $this.createSegment(0L, $this.createSegment$default$2(), $this.createSegment$default$3());
        int n = 0;
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, messagesAppended$1, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                seg.append((long)foreach$mVc$sp_i, -1L, -1L, $this.records(foreach$mVc$sp_i, (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{((Object)foreach$mVc$sp_i).toString()})));
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Object var8_5 = null;
        int offsetToBeginCorruption = TestUtils$.MODULE$.random().nextInt(messagesAppended$1);
        int position = seg.log().searchForOffsetWithSize((long)((long)offsetToBeginCorruption), (int)0).position + TestUtils$.MODULE$.random().nextInt(15);
        TestUtils$.MODULE$.writeNonsenseToFile(seg.log().file(), position, (int)(seg.log().file().length() - (long)position));
        seg.recover(new ProducerStateManager($this.topicPartition(), $this.logDir(), 3600000), seg.recover$default$2());
        int n2 = 0;
        Assert.assertEquals((String)"Should have truncated off bad messages.", (Object)new Range.Exclusive(n2, offsetToBeginCorruption, 1).toList(), (Object)((IterableOnceOps)AsScalaExtensions.IterableHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Iterable)seg.log().batches()).asScala().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.lastOffset()))).toList());
        seg.deleteIfExists();
    }

    /*
     * WARNING - void declaration
     */
    private static final MemoryRecords records$1(long offset, String record) {
        void withRecords_records;
        void withRecords_timestampType;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(offset * 1000L, record.getBytes())};
        TimestampType timestampType = TimestampType.CREATE_TIME;
        CompressionType withRecords_compressionType = CompressionType.NONE;
        return MemoryRecords.withRecords((byte)2, (long)offset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
    }

    /*
     * WARNING - void declaration
     */
    private static final MemoryRecords records$2(long offset, int size) {
        void withRecords_records;
        void withRecords_timestampType;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(new byte[size])};
        TimestampType timestampType = TimestampType.CREATE_TIME;
        CompressionType withRecords_compressionType = CompressionType.NONE;
        return MemoryRecords.withRecords((byte)2, (long)offset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
    }
}

