/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import kafka.server.CachedPartition;
import kafka.server.FetchContext;
import kafka.server.FetchSession;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function2;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0005\u0005ue\u0001B\r\u001b\u0001}A\u0001B\u000b\u0001\u0003\u0006\u0004%Ia\u000b\u0005\ts\u0001\u0011\t\u0011)A\u0005Y!A!\b\u0001BC\u0002\u0013%1\b\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003=\u0011!\u0019\u0005A!b\u0001\n\u0013!\u0005\u0002\u0003%\u0001\u0005\u0003\u0005\u000b\u0011B#\t\u000b%\u0003A\u0011\u0001&\t\u000b=\u0003A\u0011\t)\t\u000bu\u0003A\u0011\t0\u0007\t9\u0004Aa\u001c\u0005\n\u007f*\u0011)\u0019!C\u0001\u0003\u0003A\u0011\"a\u0001\u000b\u0005\u0003\u0005\u000b\u0011\u0002=\t\u0015\u0005\u0015!B!b\u0001\n\u0003\t9\u0001\u0003\u0006\u0002\u0010)\u0011\t\u0011)A\u0005\u0003\u0013Aa!\u0013\u0006\u0005\u0002\u0005E\u0001\"CA\u000e\u0015\u0001\u0007I\u0011AA\u000f\u0011%\tyE\u0003a\u0001\n\u0003\t\t\u0006\u0003\u0005\u0002X)\u0001\u000b\u0015BA\u0010\u0011\u001d\tIF\u0003C!\u00037Bq!!\u0018\u000b\t\u0003\ny\u0006C\u0004\u0002b)!\t%a\u0019\t\u000f\u0005-\u0004\u0001\"\u0011\u0002n!9\u0011\u0011\u0012\u0001\u0005B\u0005-\u0005bBAK\u0001\u0011\u0005\u0013q\u0013\u0002\u0018\u0013:\u001c'/Z7f]R\fGNR3uG\"\u001cuN\u001c;fqRT!a\u0007\u000f\u0002\rM,'O^3s\u0015\u0005i\u0012!B6bM.\f7\u0001A\n\u0004\u0001\u00012\u0003CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#AB!osJ+g\r\u0005\u0002(Q5\t!$\u0003\u0002*5\taa)\u001a;dQ\u000e{g\u000e^3yi\u0006!A/[7f+\u0005a\u0003CA\u00178\u001b\u0005q#BA\u00181\u0003\u0015)H/\u001b7t\u0015\t\t$'\u0001\u0004d_6lwN\u001c\u0006\u0003;MR!\u0001N\u001b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0014aA8sO&\u0011\u0001H\f\u0002\u0005)&lW-A\u0003uS6,\u0007%A\u0006sKFlU\r^1eCR\fW#\u0001\u001f\u0011\u0005u\u0002U\"\u0001 \u000b\u0005}\u0002\u0014\u0001\u0003:fcV,7\u000f^:\n\u0005\u0005s$!\u0004$fi\u000eDW*\u001a;bI\u0006$\u0018-\u0001\u0007sKFlU\r^1eCR\f\u0007%A\u0004tKN\u001c\u0018n\u001c8\u0016\u0003\u0015\u0003\"a\n$\n\u0005\u001dS\"\u0001\u0004$fi\u000eD7+Z:tS>t\u0017\u0001C:fgNLwN\u001c\u0011\u0002\rqJg.\u001b;?)\u0011YE*\u0014(\u0011\u0005\u001d\u0002\u0001\"\u0002\u0016\b\u0001\u0004a\u0003\"\u0002\u001e\b\u0001\u0004a\u0004\"B\"\b\u0001\u0004)\u0015AD4fi\u001a+Go\u00195PM\u001a\u001cX\r\u001e\u000b\u0003#^\u00032!\t*U\u0013\t\u0019&E\u0001\u0004PaRLwN\u001c\t\u0003CUK!A\u0016\u0012\u0003\t1{gn\u001a\u0005\u00061\"\u0001\r!W\u0001\u0003iB\u0004\"AW.\u000e\u0003AJ!\u0001\u0018\u0019\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006\u0001bm\u001c:fC\u000eD\u0007+\u0019:uSRLwN\u001c\u000b\u0003?\n\u0004\"!\t1\n\u0005\u0005\u0014#\u0001B+oSRDQaY\u0005A\u0002\u0011\f1AZ;o!\u0015\tS-W4`\u0013\t1'EA\u0005Gk:\u001cG/[8oeA\u0011\u0001n\u001b\b\u0003{%L!A\u001b \u0002\u0019\u0019+Go\u00195SKF,Xm\u001d;\n\u00051l'!\u0004)beRLG/[8o\t\u0006$\u0018M\u0003\u0002k}\t\t\u0002+\u0019:uSRLwN\\%uKJ\fGo\u001c:\u0014\u0007)\u0001\b\u0010\u0005\u0002rm6\t!O\u0003\u0002ti\u0006!A.\u00198h\u0015\u0005)\u0018\u0001\u00026bm\u0006L!a\u001e:\u0003\r=\u0013'.Z2u!\tIHP\u0004\u0002(u&\u00111PG\u0001\r\r\u0016$8\r[*fgNLwN\\\u0005\u0003{z\u0014QBU#T!~k\u0015\tU0J)\u0016\u0013&BA>\u001b\u0003\u0011IG/\u001a:\u0016\u0003a\fQ!\u001b;fe\u0002\nQ%\u001e9eCR,g)\u001a;dQ\u000e{g\u000e^3yi\u0006sGMU3n_Z,WK\\:fY\u0016\u001cG/\u001a3\u0016\u0005\u0005%\u0001cA\u0011\u0002\f%\u0019\u0011Q\u0002\u0012\u0003\u000f\t{w\u000e\\3b]\u00061S\u000f\u001d3bi\u00164U\r^2i\u0007>tG/\u001a=u\u0003:$'+Z7pm\u0016,fn]3mK\u000e$X\r\u001a\u0011\u0015\r\u0005M\u0011qCA\r!\r\t)BC\u0007\u0002\u0001!)qp\u0004a\u0001q\"9\u0011QA\bA\u0002\u0005%\u0011a\u00038fqR,E.Z7f]R,\"!a\b\u0011\u000f\u0005\u0005\u0012\u0011G-\u000289!\u00111EA\u0016\u001d\u0011\t)#a\n\u000e\u0003QL1!!\u000bu\u0003\u0011)H/\u001b7\n\t\u00055\u0012qF\u0001\u0004\u001b\u0006\u0004(bAA\u0015i&!\u00111GA\u001b\u0005\u0015)e\u000e\u001e:z\u0015\u0011\ti#a\f\u0011\r\u0005e\u0012qHA\"\u001d\ri\u00141H\u0005\u0004\u0003{q\u0014!\u0004$fi\u000eD'+Z:q_:\u001cX-C\u0002m\u0003\u0003R1!!\u0010?!\u0011\t)%a\u0013\u000e\u0005\u0005\u001d#bAA%a\u00051!/Z2pe\u0012LA!!\u0014\u0002H\t9!+Z2pe\u0012\u001c\u0018a\u00048fqR,E.Z7f]R|F%Z9\u0015\u0007}\u000b\u0019\u0006C\u0005\u0002VE\t\t\u00111\u0001\u0002 \u0005\u0019\u0001\u0010J\u0019\u0002\u00199,\u0007\u0010^#mK6,g\u000e\u001e\u0011\u0002\u000f!\f7OT3yiR\u0011\u0011\u0011B\u0001\u0005]\u0016DH\u000f\u0006\u0002\u0002 \u00051!/Z7pm\u0016$\"!!\u001a\u0011\u0007\u0005\n9'C\u0002\u0002j\t\u0012qAT8uQ&tw-A\bhKR\u0014Vm\u001d9p]N,7+\u001b>f)\u0019\ty'!\u001e\u0002\u0000A\u0019\u0011%!\u001d\n\u0007\u0005M$EA\u0002J]RDq!a\u001e\u0017\u0001\u0004\tI(A\u0004va\u0012\fG/Z:\u0011\u0007e\fY(C\u0002\u0002~y\u0014\u0001BU#T!~k\u0015\t\u0015\u0005\b\u0003\u00033\u0002\u0019AAB\u0003%1XM]:j_:LE\rE\u0002\"\u0003\u000bK1!a\"#\u0005\u0015\u0019\u0006n\u001c:u\u0003u)\b\u000fZ1uK\u0006sGmR3oKJ\fG/\u001a*fgB|gn]3ECR\fG\u0003BAG\u0003'\u0003R!PAH\u0003\u0007J1!!%?\u000551U\r^2i%\u0016\u001c\bo\u001c8tK\"9\u0011qO\fA\u0002\u0005e\u0014\u0001F4fiRC'o\u001c;uY\u0016$'+Z:q_:\u001cX\r\u0006\u0003\u0002\u000e\u0006e\u0005bBAN1\u0001\u0007\u0011qN\u0001\u000fi\"\u0014x\u000e\u001e;mKRKW.Z't\u0001")
public class IncrementalFetchContext
implements FetchContext {
    private final Time time;
    private final FetchMetadata reqMetadata;
    private final FetchSession kafka$server$IncrementalFetchContext$$session;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String partitionsToLogString(Collection<TopicPartition> partitions) {
        return FetchContext.partitionsToLogString$(this, partitions);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private Time time() {
        return this.time;
    }

    private FetchMetadata reqMetadata() {
        return this.reqMetadata;
    }

    public FetchSession kafka$server$IncrementalFetchContext$$session() {
        return this.kafka$server$IncrementalFetchContext$$session;
    }

    @Override
    public Option<Object> getFetchOffset(TopicPartition tp) {
        return this.kafka$server$IncrementalFetchContext$$session().getFetchOffset(tp);
    }

    @Override
    public void foreachPartition(Function2<TopicPartition, FetchRequest.PartitionData, BoxedUnit> fun) {
        FetchSession fetchSession = this.kafka$server$IncrementalFetchContext$$session();
        synchronized (fetchSession) {
            this.kafka$server$IncrementalFetchContext$$session().partitionMap().forEach(part -> fun.apply((Object)new TopicPartition(part.topic(), part.partition()), (Object)part.reqData()));
            return;
        }
    }

    @Override
    public int getResponseSize(LinkedHashMap<TopicPartition, FetchResponse.PartitionData<Records>> updates, short versionId) {
        FetchSession fetchSession = this.kafka$server$IncrementalFetchContext$$session();
        synchronized (fetchSession) {
            int expectedEpoch = FetchMetadata.nextEpoch((int)this.reqMetadata().epoch());
            int n = this.kafka$server$IncrementalFetchContext$$session().epoch() != expectedEpoch ? FetchResponse.sizeOf((short)versionId, new LinkedHashMap().entrySet().iterator()) : FetchResponse.sizeOf((short)versionId, (Iterator)new PartitionIterator(this, updates.entrySet().iterator(), false));
            return n;
        }
    }

    @Override
    public FetchResponse<Records> updateAndGenerateResponseData(LinkedHashMap<TopicPartition, FetchResponse.PartitionData<Records>> updates) {
        FetchSession fetchSession = this.kafka$server$IncrementalFetchContext$$session();
        synchronized (fetchSession) {
            FetchResponse fetchResponse;
            int expectedEpoch = FetchMetadata.nextEpoch((int)this.reqMetadata().epoch());
            if (this.kafka$server$IncrementalFetchContext$$session().epoch() != expectedEpoch) {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(48).append("Incremental fetch session ").append(this.kafka$server$IncrementalFetchContext$$session().id()).append(" expected epoch ").append(expectedEpoch).append(", but ").toString()).append(new StringBuilder(34).append("got ").append(this.kafka$server$IncrementalFetchContext$$session().epoch()).append(".  Possible duplicate request.").toString()).toString());
                fetchResponse = new FetchResponse(Errors.INVALID_FETCH_SESSION_EPOCH, new LinkedHashMap(), 0, this.kafka$server$IncrementalFetchContext$$session().id());
            } else {
                PartitionIterator partitionIter = new PartitionIterator(this, updates.entrySet().iterator(), true);
                while (partitionIter.hasNext()) {
                    partitionIter.next();
                }
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(53).append("Incremental fetch context with session id ").append(this.kafka$server$IncrementalFetchContext$$session().id()).append(" returning ").toString()).append(String.valueOf(this.partitionsToLogString(updates.keySet()))).toString());
                fetchResponse = new FetchResponse(Errors.NONE, updates, 0, this.kafka$server$IncrementalFetchContext$$session().id());
            }
            FetchResponse fetchResponse2 = fetchResponse;
            return fetchResponse2;
        }
    }

    @Override
    public FetchResponse<Records> getThrottledResponse(int throttleTimeMs) {
        FetchSession fetchSession = this.kafka$server$IncrementalFetchContext$$session();
        synchronized (fetchSession) {
            FetchResponse fetchResponse;
            int expectedEpoch = FetchMetadata.nextEpoch((int)this.reqMetadata().epoch());
            if (this.kafka$server$IncrementalFetchContext$$session().epoch() != expectedEpoch) {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(48).append("Incremental fetch session ").append(this.kafka$server$IncrementalFetchContext$$session().id()).append(" expected epoch ").append(expectedEpoch).append(", but ").toString()).append(new StringBuilder(34).append("got ").append(this.kafka$server$IncrementalFetchContext$$session().epoch()).append(".  Possible duplicate request.").toString()).toString());
                fetchResponse = new FetchResponse(Errors.INVALID_FETCH_SESSION_EPOCH, new LinkedHashMap(), throttleTimeMs, this.kafka$server$IncrementalFetchContext$$session().id());
            } else {
                fetchResponse = new FetchResponse(Errors.NONE, new LinkedHashMap(), throttleTimeMs, this.kafka$server$IncrementalFetchContext$$session().id());
            }
            FetchResponse fetchResponse2 = fetchResponse;
            return fetchResponse2;
        }
    }

    public IncrementalFetchContext(Time time, FetchMetadata reqMetadata, FetchSession session) {
        this.time = time;
        this.reqMetadata = reqMetadata;
        this.kafka$server$IncrementalFetchContext$$session = session;
    }

    public class PartitionIterator
    implements Iterator<Map.Entry<TopicPartition, FetchResponse.PartitionData<Records>>> {
        private final Iterator<Map.Entry<TopicPartition, FetchResponse.PartitionData<Records>>> iter;
        private final boolean updateFetchContextAndRemoveUnselected;
        private Map.Entry<TopicPartition, FetchResponse.PartitionData<Records>> nextElement;
        public final /* synthetic */ IncrementalFetchContext $outer;

        @Override
        public void forEachRemaining(Consumer<? super Map.Entry<TopicPartition, FetchResponse.PartitionData<Records>>> x$1) {
            Iterator.super.forEachRemaining(x$1);
        }

        public Iterator<Map.Entry<TopicPartition, FetchResponse.PartitionData<Records>>> iter() {
            return this.iter;
        }

        public boolean updateFetchContextAndRemoveUnselected() {
            return this.updateFetchContextAndRemoveUnselected;
        }

        public Map.Entry<TopicPartition, FetchResponse.PartitionData<Records>> nextElement() {
            return this.nextElement;
        }

        public void nextElement_$eq(Map.Entry<TopicPartition, FetchResponse.PartitionData<Records>> x$1) {
            this.nextElement = x$1;
        }

        @Override
        public boolean hasNext() {
            while (this.nextElement() == null && this.iter().hasNext()) {
                Map.Entry<TopicPartition, FetchResponse.PartitionData<Records>> element = this.iter().next();
                TopicPartition topicPart = element.getKey();
                FetchResponse.PartitionData<Records> respData = element.getValue();
                CachedPartition cachedPart = (CachedPartition)this.kafka$server$IncrementalFetchContext$PartitionIterator$$$outer().kafka$server$IncrementalFetchContext$$session().partitionMap().find((ImplicitLinkedHashCollection.Element)new CachedPartition(topicPart));
                if (cachedPart.maybeUpdateResponseData(respData, this.updateFetchContextAndRemoveUnselected())) {
                    this.nextElement_$eq(element);
                    if (!this.updateFetchContextAndRemoveUnselected()) continue;
                    this.kafka$server$IncrementalFetchContext$PartitionIterator$$$outer().kafka$server$IncrementalFetchContext$$session().partitionMap().remove((Object)cachedPart);
                    this.kafka$server$IncrementalFetchContext$PartitionIterator$$$outer().kafka$server$IncrementalFetchContext$$session().partitionMap().mustAdd((ImplicitLinkedHashCollection.Element)cachedPart);
                    continue;
                }
                if (!this.updateFetchContextAndRemoveUnselected()) continue;
                this.iter().remove();
            }
            return this.nextElement() != null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map.Entry<TopicPartition, FetchResponse.PartitionData<Records>> next() {
            void var1_1;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Map.Entry<TopicPartition, FetchResponse.PartitionData<Records>> element = this.nextElement();
            this.nextElement_$eq(null);
            return var1_1;
        }

        public Nothing$ remove() {
            throw new UnsupportedOperationException();
        }

        public /* synthetic */ IncrementalFetchContext kafka$server$IncrementalFetchContext$PartitionIterator$$$outer() {
            return this.$outer;
        }

        public PartitionIterator(IncrementalFetchContext $outer, Iterator<Map.Entry<TopicPartition, FetchResponse.PartitionData<Records>>> iter, boolean updateFetchContextAndRemoveUnselected) {
            this.iter = iter;
            this.updateFetchContextAndRemoveUnselected = updateFetchContextAndRemoveUnselected;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.nextElement = null;
        }
    }
}

