/*
 * Decompiled with CFR 0.152.
 */
package kafka;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.TestLinearWriteSpeed;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.message.CompressionCodec;
import kafka.message.CompressionCodec$;
import kafka.message.NoCompressionCodec$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Exit$;
import kafka.utils.KafkaScheduler;
import kafka.utils.Scheduler;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import scala.Console$;
import scala.None$;
import scala.Option;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;

public final class TestLinearWriteSpeed$ {
    public static final TestLinearWriteSpeed$ MODULE$ = new TestLinearWriteSpeed$();

    /*
     * WARNING - void declaration
     */
    public void main(String[] args) {
        MemoryRecords memoryRecords;
        SimpleRecord simpleRecord;
        OptionParser parser = new OptionParser(false);
        ArgumentAcceptingOptionSpec dirOpt = parser.accepts("dir", "The directory to write to.").withRequiredArg().describedAs("path").ofType(String.class).defaultsTo((Object)System.getProperty("java.io.tmpdir"), (Object[])new String[0]);
        ArgumentAcceptingOptionSpec bytesOpt = parser.accepts("bytes", "REQUIRED: The total number of bytes to write.").withRequiredArg().describedAs("num_bytes").ofType(Long.class);
        ArgumentAcceptingOptionSpec sizeOpt = parser.accepts("size", "REQUIRED: The size of each write.").withRequiredArg().describedAs("num_bytes").ofType(Integer.class);
        ArgumentAcceptingOptionSpec messageSizeOpt = parser.accepts("message-size", "REQUIRED: The size of each message in the message set.").withRequiredArg().describedAs("num_bytes").ofType(Integer.class).defaultsTo((Object)1024, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec filesOpt = parser.accepts("files", "REQUIRED: The number of logs or files.").withRequiredArg().describedAs("num_files").ofType(Integer.class).defaultsTo((Object)1, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec reportingIntervalOpt = parser.accepts("reporting-interval", "The number of ms between updates.").withRequiredArg().describedAs("ms").ofType(Long.class).defaultsTo((Object)1000L, (Object[])new Long[0]);
        ArgumentAcceptingOptionSpec maxThroughputOpt = parser.accepts("max-throughput-mb", "The maximum throughput.").withRequiredArg().describedAs("mb").ofType(Integer.class).defaultsTo((Object)Integer.MAX_VALUE, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec flushIntervalOpt = parser.accepts("flush-interval", "The number of messages between flushes").withRequiredArg().describedAs("message_count").ofType(Long.class).defaultsTo((Object)Long.MAX_VALUE, (Object[])new Long[0]);
        ArgumentAcceptingOptionSpec compressionCodecOpt = parser.accepts("compression", "The compression codec to use").withRequiredArg().describedAs("codec").ofType(String.class).defaultsTo((Object)NoCompressionCodec$.MODULE$.name(), (Object[])new String[0]);
        OptionSpecBuilder mmapOpt = parser.accepts("mmap", "Do writes to memory-mapped files.");
        OptionSpecBuilder channelOpt = parser.accepts("channel", "Do writes to file channels.");
        OptionSpecBuilder logOpt = parser.accepts("log", "Do writes to kafka logs.");
        OptionSet options = parser.parse(args);
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{bytesOpt, sizeOpt, filesOpt}));
        long l = (Long)options.valueOf((OptionSpec)bytesOpt);
        int bufferSize = (Integer)options.valueOf((OptionSpec)sizeOpt);
        int numFiles = (Integer)options.valueOf((OptionSpec)filesOpt);
        long reportingInterval = (Long)options.valueOf((OptionSpec)reportingIntervalOpt);
        String dir = (String)options.valueOf((OptionSpec)dirOpt);
        long maxThroughputBytes = (long)((Integer)options.valueOf((OptionSpec)maxThroughputOpt)).intValue() * 1024L * 1024L;
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        int messageSize = (Integer)options.valueOf((OptionSpec)messageSizeOpt);
        long flushInterval = (Long)options.valueOf((OptionSpec)flushIntervalOpt);
        CompressionCodec compressionCodec = CompressionCodec$.MODULE$.getCompressionCodec((String)options.valueOf((OptionSpec)compressionCodecOpt));
        Random rand = new Random();
        rand.nextBytes(buffer.array());
        int numMessages = bufferSize / (messageSize + 12);
        long createTime = System.currentTimeMillis();
        CompressionType compressionType = CompressionType.forId((int)compressionCodec.codec());
        int n = 0;
        Range.Exclusive map_this = new Range.Exclusive(n, numMessages, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        Iterator map_strictOptimizedMap_it = map_this.iterator();
        while (map_strictOptimizedMap_it.hasNext()) {
            void map_strictOptimizedMap_$plus$eq_elem;
            SimpleRecord simpleRecord2;
            SimpleRecord simpleRecord3;
            Integer cfr_ignored_0 = (Integer)map_strictOptimizedMap_it.next();
            SimpleRecord simpleRecord4 = simpleRecord3 = new SimpleRecord(createTime, null, new byte[messageSize]);
            simpleRecord3 = null;
            SimpleRecord simpleRecord5 = simpleRecord2 = simpleRecord4;
            simpleRecord2 = null;
            simpleRecord = simpleRecord5;
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            simpleRecord = null;
        }
        Object var70_31 = null;
        Object var71_32 = null;
        Object var72_33 = null;
        simpleRecord = null;
        SimpleRecord[] withRecords_records = (SimpleRecord[])((IndexedSeq)map_strictOptimizedMap_b.result()).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        MemoryRecords memoryRecords2 = memoryRecords = MemoryRecords.withRecords((byte)2, (CompressionType)compressionType, (SimpleRecord[])withRecords_records);
        Object var78_37 = null;
        memoryRecords = null;
        MemoryRecords messageSet = memoryRecords2;
        TestLinearWriteSpeed.Writable[] writables = new TestLinearWriteSpeed.Writable[numFiles];
        KafkaScheduler scheduler = new KafkaScheduler(1, "kafka-scheduler-", true);
        scheduler.startup();
        int n2 = 0;
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n2, numFiles, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                if (options.has((OptionSpec)mmapOpt)) {
                    writables[foreach$mVc$sp_i] = new TestLinearWriteSpeed.MmapWritable(new File(dir, new StringBuilder(15).append("kafka-test-").append(foreach$mVc$sp_i).append(".dat").toString()), l / (long)numFiles, buffer);
                } else if (options.has((OptionSpec)channelOpt)) {
                    writables[foreach$mVc$sp_i] = new TestLinearWriteSpeed.ChannelWritable(new File(dir, new StringBuilder(15).append("kafka-test-").append(foreach$mVc$sp_i).append(".dat").toString()), buffer);
                } else if (options.has((OptionSpec)logOpt)) {
                    int $anonfun$main$2_segmentSize = rand.nextInt(512) * 1024 * 1024 + 0x4000000;
                    Properties $anonfun$main$2_logProperties = new Properties();
                    $anonfun$main$2_logProperties.put(LogConfig$.MODULE$.SegmentBytesProp(), (Object)$anonfun$main$2_segmentSize);
                    $anonfun$main$2_logProperties.put(LogConfig$.MODULE$.FlushMessagesProp(), (Object)flushInterval);
                    writables[foreach$mVc$sp_i] = new TestLinearWriteSpeed.LogWritable(new File(dir, new StringBuilder(11).append("kafka-test-").append(foreach$mVc$sp_i).toString()), new LogConfig((Map)$anonfun$main$2_logProperties, LogConfig$.MODULE$.$lessinit$greater$default$2()), (Scheduler)scheduler, messageSet);
                } else {
                    System.err.println("Must specify what to write to with one of --log, --channel, or --mmap");
                    throw Exit$.MODULE$.exit(1, (Option)None$.MODULE$);
                }
                Object var85_46 = null;
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Object var74_43 = null;
        long l2 = l / (long)numFiles * (long)numFiles;
        String println_x = StringOps$.MODULE$.format$extension("%10s\t%10s\t%10s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"mb_sec", "avg_latency", "max_latency"}));
        Console$.MODULE$.println((Object)println_x);
        Object var80_48 = null;
        long beginTest = System.nanoTime();
        long maxLatency = 0L;
        long totalLatency = 0L;
        long count = 0L;
        long written = 0L;
        long totalWritten = 0L;
        long lastReport = beginTest;
        while (totalWritten + (long)bufferSize < l2) {
            long now;
            long lastReportMs;
            long sleepMs;
            long start = System.nanoTime();
            int n3 = (int)(count % (long)numFiles);
            int writeSize = writables[Math.abs(n3)].write();
            long ellapsed = System.nanoTime() - start;
            maxLatency = Math.max(ellapsed, maxLatency);
            totalLatency += ellapsed;
            written += (long)writeSize;
            ++count;
            totalWritten += (long)writeSize;
            if ((double)(start - lastReport) / 1000000.0 > Long.valueOf(reportingInterval).doubleValue()) {
                double ellapsedSecs = (double)(start - lastReport) / 1.0E9;
                double mb = (double)written / 1048576.0;
                String println_x2 = StringOps$.MODULE$.format$extension("%10.3f\t%10.3f\t%10.3f", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{mb / ellapsedSecs, (double)totalLatency / (double)count / 1000000.0, (double)maxLatency / 1000000.0}));
                Console$.MODULE$.println((Object)println_x2);
                Object var81_65 = null;
                lastReport = start;
                written = 0L;
                maxLatency = 0L;
                totalLatency = 0L;
                continue;
            }
            if (!((double)written > (double)maxThroughputBytes * ((double)reportingInterval / 1000.0)) || (sleepMs = (lastReportMs = lastReport / 1000000L) + reportingInterval - (now = System.nanoTime() / 1000000L)) <= 0L) continue;
            Thread.sleep(sleepMs);
        }
        double elapsedSecs = (double)(System.nanoTime() - beginTest) / 1.0E9;
        String println_x3 = new StringBuilder(11).append(((Object)((double)l2 / (1048576.0 * elapsedSecs))).toString()).append(" MB per sec").toString();
        Console$.MODULE$.println((Object)println_x3);
        Object var82_67 = null;
        scheduler.shutdown();
    }

    public static final /* synthetic */ SimpleRecord $anonfun$main$1(long createTime$1, int messageSize$1, int x$1) {
        return new SimpleRecord(createTime$1, null, new byte[messageSize$1]);
    }

    public static final /* synthetic */ void $anonfun$main$2(OptionSet options$1, OptionSpecBuilder mmapOpt$1, TestLinearWriteSpeed.Writable[] writables$1, String dir$1, LongRef bytesToWrite$1, int numFiles$1, ByteBuffer buffer$1, OptionSpecBuilder channelOpt$1, OptionSpecBuilder logOpt$1, Random rand$1, long flushInterval$1, KafkaScheduler scheduler$1, MemoryRecords messageSet$1, int i) {
        if (options$1.has((OptionSpec)mmapOpt$1)) {
            writables$1[i] = new TestLinearWriteSpeed.MmapWritable(new File(dir$1, new StringBuilder(15).append("kafka-test-").append(i).append(".dat").toString()), bytesToWrite$1.elem / (long)numFiles$1, buffer$1);
            return;
        }
        if (options$1.has((OptionSpec)channelOpt$1)) {
            writables$1[i] = new TestLinearWriteSpeed.ChannelWritable(new File(dir$1, new StringBuilder(15).append("kafka-test-").append(i).append(".dat").toString()), buffer$1);
            return;
        }
        if (options$1.has((OptionSpec)logOpt$1)) {
            int segmentSize = rand$1.nextInt(512) * 1024 * 1024 + 0x4000000;
            Properties logProperties = new Properties();
            logProperties.put(LogConfig$.MODULE$.SegmentBytesProp(), (Object)segmentSize);
            logProperties.put(LogConfig$.MODULE$.FlushMessagesProp(), (Object)flushInterval$1);
            writables$1[i] = new TestLinearWriteSpeed.LogWritable(new File(dir$1, new StringBuilder(11).append("kafka-test-").append(i).toString()), new LogConfig((Map)logProperties, LogConfig$.MODULE$.$lessinit$greater$default$2()), (Scheduler)scheduler$1, messageSet$1);
            return;
        }
        System.err.println("Must specify what to write to with one of --log, --channel, or --mmap");
        throw Exit$.MODULE$.exit(1, (Option)None$.MODULE$);
    }

    private TestLinearWriteSpeed$() {
    }

    public static final /* synthetic */ SimpleRecord $anonfun$main$1$adapted(long createTime$1, int messageSize$1, Object x$1) {
        return TestLinearWriteSpeed$.$anonfun$main$1(createTime$1, messageSize$1, BoxesRunTime.unboxToInt((Object)x$1));
    }
}

