/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import kafka.log.CleanerConfig;
import kafka.log.Log;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.log.LogManager$;
import kafka.log.LogMetricNames$;
import kafka.log.LogSegment;
import kafka.log.TimeIndex;
import kafka.metrics.KafkaYammerMetrics;
import kafka.server.FetchDataInfo;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.util.Failure;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\t]b\u0001B\u001b7\u0001mBQA\u0011\u0001\u0005\u0002\rCqA\u0012\u0001C\u0002\u0013\u0005q\t\u0003\u0004O\u0001\u0001\u0006I\u0001\u0013\u0005\b\u001f\u0002\u0011\r\u0011\"\u0001Q\u0011\u0019!\u0006\u0001)A\u0005#\"9Q\u000b\u0001b\u0001\n\u0003\u0001\u0006B\u0002,\u0001A\u0003%\u0011\u000bC\u0004X\u0001\t\u0007I\u0011\u0001-\t\r\u0005\u0004\u0001\u0015!\u0003Z\u0011\u001d\u0011\u0007A1A\u0005\u0002\rDaa\u001a\u0001!\u0002\u0013!\u0007b\u00025\u0001\u0001\u0004%\t!\u001b\u0005\ba\u0002\u0001\r\u0011\"\u0001r\u0011\u00199\b\u0001)Q\u0005U\"9\u0001\u0010\u0001a\u0001\n\u0003I\bbB?\u0001\u0001\u0004%\tA \u0005\b\u0003\u0003\u0001\u0001\u0015)\u0003{\u0011%\t\u0019\u0001\u0001b\u0001\n\u0003\t)\u0001\u0003\u0005\u0002\u0014\u0001\u0001\u000b\u0011BA\u0004\u0011%\t)\u0002\u0001b\u0001\n\u0003\t9\u0002\u0003\u0005\u0002 \u0001\u0001\u000b\u0011BA\r\u0011\u001d\t\t\u0003\u0001C\u0001\u0003GAq!a\u000e\u0001\t\u0003\t\u0019\u0003C\u0004\u0002B\u0001!\t!a\t\t\u000f\u0005-\u0003\u0001\"\u0001\u0002$!9\u0011q\n\u0001\u0005\u0002\u0005\r\u0002bBA*\u0001\u0011\u0005\u00111\u0005\u0005\b\u0003/\u0002A\u0011AA\u0012\u0011\u001d\tY\u0006\u0001C\u0001\u0003GAq!a\u0018\u0001\t\u0003\t\u0019\u0003C\u0004\u0002d\u0001!\t!a\t\t\u000f\u0005\u001d\u0004\u0001\"\u0003\u0002j!9\u00111\u0011\u0001\u0005\u0002\u0005\r\u0002bBAD\u0001\u0011\u0005\u00111\u0005\u0005\b\u0003\u0017\u0003A\u0011AA\u0012\u0011\u001d\ty\t\u0001C\u0001\u0003GAq!a%\u0001\t\u0003\t\u0019\u0003C\u0004\u0002\u0018\u0002!\t!a\t\t\u000f\u0005m\u0005\u0001\"\u0003\u0002\u001e\"9\u00111\u001a\u0001\u0005\n\u00055\u0007\"CAk\u0001E\u0005I\u0011BAl\u0011\u001d\ti\u000f\u0001C\u0001\u0003GAq!!=\u0001\t\u0003\t\u0019\u0003C\u0004\u0002v\u0002!\t!a\t\t\u000f\u0005e\b\u0001\"\u0003\u0002|\"I!\u0011\u0004\u0001\u0012\u0002\u0013%!1\u0004\u0005\b\u0005?\u0001A\u0011AA\u0012\u0011\u001d\u0011\u0019\u0003\u0001C\u0001\u0003GAqAa\n\u0001\t\u0003\t\u0019\u0003C\u0004\u0003,\u0001!\t!a\t\t\u000f\t=\u0002\u0001\"\u0001\u0002$!9!1\u0007\u0001\u0005\u0002\u0005\r\"A\u0004'pO6\u000bg.Y4feR+7\u000f\u001e\u0006\u0003oa\n1\u0001\\8h\u0015\u0005I\u0014!B6bM.\f7\u0001A\n\u0003\u0001q\u0002\"!\u0010!\u000e\u0003yR\u0011aP\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0003z\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001E!\t)\u0005!D\u00017\u0003\u0011!\u0018.\\3\u0016\u0003!\u0003\"!\u0013'\u000e\u0003)S!a\u0013\u001d\u0002\u000bU$\u0018\u000e\\:\n\u00055S%\u0001C'pG.$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\u001f5\f\u0007PU8mY&sG/\u001a:wC2,\u0012!\u0015\t\u0003{IK!a\u0015 \u0003\u0007%sG/\u0001\tnCb\u0014v\u000e\u001c7J]R,'O^1mA\u0005YQ.\u0019=M_\u001e\fu-Z't\u00031i\u0017\r\u001f'pO\u0006;W-T:!\u0003!awn\u001a)s_B\u001cX#A-\u0011\u0005i{V\"A.\u000b\u0005qk\u0016\u0001B;uS2T\u0011AX\u0001\u0005U\u00064\u0018-\u0003\u0002a7\nQ\u0001K]8qKJ$\u0018.Z:\u0002\u00131|w\r\u0015:paN\u0004\u0013!\u00037pO\u000e{gNZ5h+\u0005!\u0007CA#f\u0013\t1gGA\u0005M_\u001e\u001cuN\u001c4jO\u0006QAn\\4D_:4\u0017n\u001a\u0011\u0002\r1|w\rR5s+\u0005Q\u0007CA6o\u001b\u0005a'BA7^\u0003\tIw.\u0003\u0002pY\n!a)\u001b7f\u0003)awn\u001a#je~#S-\u001d\u000b\u0003eV\u0004\"!P:\n\u0005Qt$\u0001B+oSRDqA^\u0007\u0002\u0002\u0003\u0007!.A\u0002yIE\nq\u0001\\8h\t&\u0014\b%\u0001\u0006m_\u001el\u0015M\\1hKJ,\u0012A\u001f\t\u0003\u000bnL!\u0001 \u001c\u0003\u00151{w-T1oC\u001e,'/\u0001\bm_\u001el\u0015M\\1hKJ|F%Z9\u0015\u0005I|\bb\u0002<\u0011\u0003\u0003\u0005\rA_\u0001\fY><W*\u00198bO\u0016\u0014\b%\u0001\u0003oC6,WCAA\u0004!\u0011\tI!a\u0004\u000e\u0005\u0005-!bAA\u0007;\u0006!A.\u00198h\u0013\u0011\t\t\"a\u0003\u0003\rM#(/\u001b8h\u0003\u0015q\u0017-\\3!\u0003e1XM]=MCJ<W\rT8h\r2,8\u000f[%oi\u0016\u0014h/\u00197\u0016\u0005\u0005e\u0001cA\u001f\u0002\u001c%\u0019\u0011Q\u0004 \u0003\t1{gnZ\u0001\u001bm\u0016\u0014\u0018\u0010T1sO\u0016dun\u001a$mkND\u0017J\u001c;feZ\fG\u000eI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002e\"\u001aa#a\n\u0011\t\u0005%\u00121G\u0007\u0003\u0003WQA!!\f\u00020\u0005)!.\u001e8ji*\u0011\u0011\u0011G\u0001\u0004_J<\u0017\u0002BA\u001b\u0003W\u0011aAQ3g_J,\u0017\u0001\u0003;fCJ$un\u001e8)\u0007]\tY\u0004\u0005\u0003\u0002*\u0005u\u0012\u0002BA \u0003W\u0011Q!\u00114uKJ\fQ\u0002^3ti\u000e\u0013X-\u0019;f\u0019><\u0007f\u0001\r\u0002FA!\u0011\u0011FA$\u0013\u0011\tI%a\u000b\u0003\tQ+7\u000f^\u0001\u001fi\u0016\u001cHo\u0011:fCR,Gj\\4XSRD\u0017J\u001c<bY&$Gj\\4ESJD3!GA#\u0003}!Xm\u001d;De\u0016\fG/\u001a'pO^KG\u000f\u001b'pO\u0012K'OR1mY\n\f7m\u001b\u0015\u00045\u0005\u0015\u0013!\u0006;fgR<U\r\u001e(p]\u0016C\u0018n\u001d;f]Rdun\u001a\u0015\u00047\u0005\u0015\u0013A\u0007;fgR\u001cE.Z1okB,\u0005\u0010]5sK\u0012\u001cVmZ7f]R\u001c\bf\u0001\u000f\u0002F\u0005\tC/Z:u\u00072,\u0017M\\;q'\u0016<W.\u001a8ugR{W*Y5oi\u0006LgnU5{K\"\u001aQ$!\u0012\u0002UQ,7\u000f\u001e#pKNtGo\u00117fC:dunZ:XSRD7i\\7qC\u000e$H)\u001a7fi\u0016\u0004v\u000e\\5ds\"\u001aa$!\u0012\u0002IQ,7\u000f\u001e#pKNtGo\u00117fC:dunZ:XSRD7i\\7qC\u000e$\bk\u001c7jGfD3aHA#\u0003M!Xm\u001d;E_\u0016\u001ch\u000e^\"mK\u0006tGj\\4t)\r\u0011\u00181\u000e\u0005\b\u0003[\u0002\u0003\u0019AA8\u0003\u0019\u0001x\u000e\\5dsB!\u0011\u0011OA@\u001d\u0011\t\u0019(a\u001f\u0011\u0007\u0005Ud(\u0004\u0002\u0002x)\u0019\u0011\u0011\u0010\u001e\u0002\rq\u0012xn\u001c;?\u0013\r\tiHP\u0001\u0007!J,G-\u001a4\n\t\u0005E\u0011\u0011\u0011\u0006\u0004\u0003{r\u0014A\u0005;fgR$\u0016.\\3CCN,GM\u00127vg\"D3!IA#\u0003e!Xm\u001d;MK\u0006\u001cH\u000fT8bI\u0016$\u0017i]:jO:lWM\u001c;)\u0007\t\n)%A\u0012uKN$Hk^8M_\u001el\u0015M\\1hKJ\u001cXk]5oON\u000bW.\u001a#je\u001a\u000b\u0017\u000e\\:)\u0007\r\n)%\u0001\u000fuKN$8\t[3dWB|\u0017N\u001c;SK\u000e|g/\u001a:z!>Lg\u000e^:)\u0007\u0011\n)%A\u0017uKN$(+Z2pm\u0016\u0014\u0018\u0010R5sK\u000e$xN]=NCB\u0004\u0018N\\4XSRDGK]1jY&twm\u00157bg\"D3!JA#\u0003E\"Xm\u001d;SK\u000e|g/\u001a:z\t&\u0014Xm\u0019;pefl\u0015\r\u001d9j]\u001e<\u0016\u000e\u001e5SK2\fG/\u001b<f\t&\u0014Xm\u0019;pefD3AJA#\u0003a1XM]5gs\u000eCWmY6q_&tGOU3d_Z,'/\u001f\u000b\be\u0006}\u0015qYAe\u0011\u001d\t\tk\na\u0001\u0003G\u000bq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\t\u0007\u0003K\u000by+!.\u000f\t\u0005\u001d\u00161\u0016\b\u0005\u0003k\nI+C\u0001@\u0013\r\tiKP\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t,a-\u0003\u0007M+\u0017OC\u0002\u0002.z\u0002B!a.\u0002D6\u0011\u0011\u0011\u0018\u0006\u0005\u0003w\u000bi,\u0001\u0004d_6lwN\u001c\u0006\u0004s\u0005}&\u0002BAa\u0003_\ta!\u00199bG\",\u0017\u0002BAc\u0003s\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0003yO\u0001\u0007!\u0010C\u0003iO\u0001\u0007!.\u0001\tde\u0016\fG/\u001a'pO6\u000bg.Y4feR\u0019!0a4\t\u0013\u0005E\u0007\u0006%AA\u0002\u0005M\u0017a\u00027pO\u0012K'o\u001d\t\u0006\u0003K\u000byK[\u0001\u001bGJ,\u0017\r^3M_\u001el\u0015M\\1hKJ$C-\u001a4bk2$H%M\u000b\u0003\u00033TC!a5\u0002\\.\u0012\u0011Q\u001c\t\u0005\u0003?\fI/\u0004\u0002\u0002b*!\u00111]As\u0003%)hn\u00195fG.,GMC\u0002\u0002hz\n!\"\u00198o_R\fG/[8o\u0013\u0011\tY/!9\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0012uKN$h)\u001b7f%\u00164WM]3oG\u0016\u001c\u0018I\u001a;fe\u0006\u001b\u0018P\\2EK2,G/\u001a\u0015\u0004U\u0005\u0015\u0013A\t;fgR\u001c%/Z1uK\u0006sG\rR3mKR,wJ^3sYfduN\\4U_BL7\rK\u0002,\u0003\u000b\n\u0011\u0005^3ti\u000eCWmY6q_&tGOR8s\u001f:d\u00170\u00114gK\u000e$X\r\u001a'pOND3\u0001LA#\u0003\u001d\u0011X-\u00193M_\u001e$\u0002\"!@\u0003\n\tE!Q\u0003\t\u0005\u0003\u007f\u0014)!\u0004\u0002\u0003\u0002)\u0019!1\u0001\u001d\u0002\rM,'O^3s\u0013\u0011\u00119A!\u0001\u0003\u001b\u0019+Go\u00195ECR\f\u0017J\u001c4p\u0011\u00199T\u00061\u0001\u0003\fA\u0019QI!\u0004\n\u0007\t=aGA\u0002M_\u001eDqAa\u0005.\u0001\u0004\tI\"\u0001\u0004pM\u001a\u001cX\r\u001e\u0005\t\u0005/i\u0003\u0013!a\u0001#\u0006IQ.\u0019=MK:<G\u000f[\u0001\u0012e\u0016\fG\rT8hI\u0011,g-Y;mi\u0012\u001aTC\u0001B\u000fU\r\t\u00161\\\u0001&i\u0016\u001cH\u000fV8qS\u000e\u001cuN\u001c4jO\u000eC\u0017M\\4f+B$\u0017\r^3t\u0019><7i\u001c8gS\u001eD3aLA#\u0003u!Xm\u001d;D_:4\u0017nZ\"iC:<WmR3ug\u000ecW-\u00198fIV\u0003\bf\u0001\u0019\u0002F\u0005AC/Z:u\u0005J|7.\u001a:D_:4\u0017nZ\"iC:<W\rR3mSZ,'/\u001a3U_\u0006cG\u000eT8hg\"\u001a\u0011'!\u0012\u0002YQ,7\u000f^\"p]\u001aLwm\u00115b]\u001e,7oV5uQ:{Gj\\4HKR$\u0018N\\4J]&$\u0018.\u00197ju\u0016$\u0007f\u0001\u001a\u0002F\u0005\u0001D/Z:u\u001b\u0016$(/[2t\u000bbL7\u000f^,iK:dunZ%t%\u0016\u001c'/Z1uK\u0012\u0014UMZ8sK\u0012+G.\u001a;j_:D3aMA#\u0003E\"Xm\u001d;NKR\u0014\u0018nY:Be\u0016\u0014V-\\8wK\u0012<\u0006.\u001a8N_ZLgnZ\"veJ,g\u000e\u001e+p\rV$XO]3M_\u001eD3\u0001NA#\u0001")
public class LogManagerTest {
    private final MockTime time = new MockTime();
    private final int maxRollInterval;
    private final int maxLogAgeMs;
    private final Properties logProps = new Properties();
    private final LogConfig logConfig;
    private File logDir;
    private LogManager logManager;
    private final String name;
    private final long veryLargeLogFlushInterval;

    public MockTime time() {
        return this.time;
    }

    public int maxRollInterval() {
        return this.maxRollInterval;
    }

    public int maxLogAgeMs() {
        return this.maxLogAgeMs;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public String name() {
        return this.name;
    }

    public long veryLargeLogFlushInterval() {
        return this.veryLargeLogFlushInterval;
    }

    @Before
    public void setUp() {
        this.logDir_$eq(TestUtils.tempDirectory(null, null));
        this.logManager_$eq(this.createLogManager(this.createLogManager$default$1()));
        this.logManager().startup();
    }

    @After
    public void tearDown() {
        if (this.logManager() != null) {
            this.logManager().shutdown();
        }
        Utils.delete((File)this.logDir());
        this.logManager().liveLogDirs().foreach((Function1 & Serializable)x$1 -> {
            LogManagerTest.$anonfun$tearDown$1(x$1);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCreateLog() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        Function0 & Serializable x$2 = (Function0 & Serializable)() -> this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, (Function0)x$2, x$3, x$4);
        Seq seq = this.logManager().liveLogDirs();
        if (seq == null) {
            throw null;
        }
        Assert.assertEquals((long)1L, (long)seq.length());
        Assert.assertTrue((boolean)new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-0").toString()).exists());
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
    }

    @Test
    public void testCreateLogWithInvalidLogDir() {
        .colon.colon dirs = new .colon.colon((Object)this.logDir(), (List)new .colon.colon((Object)new File("\u0000"), (List)Nil$.MODULE$));
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)dirs));
        this.logManager().startup();
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        Function0 & Serializable x$2 = (Function0 & Serializable)() -> this.logConfig();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, (Function0)x$2, true, x$4);
        Assert.assertTrue((boolean)new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-0").toString()).exists());
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateLogWithLogDirFallback() {
        String string;
        int n = 0;
        int to$extension_end = 4;
        Range.Inclusive map_this = new Range.Inclusive(n, to$extension_end, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        Iterator map_strictOptimizedMap_it = map_this.iterator();
        while (map_strictOptimizedMap_it.hasNext()) {
            void map_strictOptimizedMap_$plus$eq_elem;
            String string2;
            String string3;
            String string4 = string3 = ((Object)BoxesRunTime.unboxToInt((Object)map_strictOptimizedMap_it.next())).toString();
            string3 = null;
            String string5 = string2 = string4;
            string2 = null;
            string = string5;
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            string = null;
        }
        Object var9_3 = null;
        Object var10_4 = null;
        Object var11_5 = null;
        string = null;
        IndexedSeq dirs = (IndexedSeq)((IndexedSeq)map_strictOptimizedMap_b.result()).map((Function1 & Serializable)x$2 -> this.logDir().toPath().resolve((String)x$2).toFile());
        this.logManager().shutdown();
        this.logManager_$eq((LogManager)Mockito.spy((Object)this.createLogManager((scala.collection.immutable.Seq<File>)dirs)));
        Set brokenDirs = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        ((LogManager)Mockito.doAnswer(invocation -> {
            File logDir = (File)invocation.getArgument(0);
            if (brokenDirs.contains((Object)logDir) || brokenDirs.size() < dirs.length() / 2) {
                brokenDirs.add((Object)logDir);
                return new Failure(new Throwable("broken dir"));
            }
            return (Try)invocation.callRealMethod();
        }).when((Object)this.logManager())).createLogDirectory((File)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        this.logManager().startup();
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        Function0 & Serializable x$22 = (Function0 & Serializable)() -> this.logConfig();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        qual$1.getOrCreateLog(x$1, (Function0)x$22, true, x$4);
        Assert.assertEquals((long)(dirs.length() / 2), (long)brokenDirs.size());
        Function1 & Serializable containsLogFile = (Function1 & Serializable)dir -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testCreateLogWithLogDirFallback$5(this, dir));
        Assert.assertEquals((String)"More than one log file created", (long)1L, (long)dirs.count((Function1)containsLogFile));
        Assert.assertFalse((boolean)brokenDirs.exists((Function1)containsLogFile));
    }

    @Test
    public void testGetNonExistentLog() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        boolean x$2 = qual$1.getLog$default$2();
        Option log = qual$1.getLog(x$1, x$2);
        Assert.assertEquals((String)"No log should be found.", (Object)None$.MODULE$, (Object)log);
        Assert.assertTrue((!new File(this.logDir(), new StringBuilder(2).append(this.name()).append("-0").toString()).exists() ? 1 : 0) != 0);
    }

    @Test
    public void testCleanupExpiredSegments() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        Function0 & Serializable x$2 = (Function0 & Serializable)() -> this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$42 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, (Function0)x$2, x$3, x$42);
        long l = 0L;
        int n = 0;
        int until$extension_end = 200;
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                MemoryRecords $anonfun$testCleanupExpiredSegments$2_set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2);
                l = log.appendAsLeader($anonfun$testCleanupExpiredSegments$2_set, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4()).lastOffset();
                Object var17_12 = null;
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Object var8_10 = null;
        Assert.assertTrue((String)"There should be more than one segment now.", (log.numberOfSegments() > 1 ? 1 : 0) != 0);
        log.updateHighWatermark(log.logEndOffset());
        log.logSegments().foreach((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testCleanupExpiredSegments$3(this, x$4)));
        this.time().sleep(this.maxLogAgeMs() + 1);
        Assert.assertEquals((String)"Now there should only be only one segment in the index.", (long)1L, (long)log.numberOfSegments());
        this.time().sleep(BoxesRunTime.unboxToLong((Object)log.config().fileDeleteDelayMs()) + 1L);
        log.logSegments().foreach((Function1 & Serializable)s -> {
            s.lazyOffsetIndex().get();
            return (TimeIndex)s.lazyTimeIndex().get();
        });
        Assert.assertEquals((String)"Files should have been deleted", (long)(log.numberOfSegments() * 4 + 1), (long)log.dir().list().length);
        int n2 = 1024;
        long readLog_offset = l + 1L;
        Assert.assertEquals((String)"Should get empty fetch off new log.", (long)0L, (long)log.read(readLog_offset, n2, (FetchIsolation)FetchLogEnd$.MODULE$, true).records().sizeInBytes());
        try {
            int n3 = 1024;
            long readLog_offset2 = 0L;
            log.read(readLog_offset2, n3, (FetchIsolation)FetchLogEnd$.MODULE$, true);
            Assert.fail((String)"Should get exception from fetching earlier.");
        }
        catch (OffsetOutOfRangeException offsetOutOfRangeException) {}
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
    }

    @Test
    public void testCleanupSegmentsToMaintainSize() {
        int setSize = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2).sizeInBytes();
        this.logManager().shutdown();
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), (Object)(10 * setSize));
        logProps.put(LogConfig$.MODULE$.RetentionBytesProp(), (Object)(50L * (long)setSize + 10L));
        LogConfig config = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        this.logManager_$eq(this.createLogManager(this.createLogManager$default$1()));
        this.logManager().startup();
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        Function0 & Serializable x$2 = (Function0 & Serializable)() -> config;
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, (Function0)x$2, x$3, x$4);
        long l = 0L;
        int numMessages = 200;
        int n = 0;
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, numMessages, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                MemoryRecords $anonfun$testCleanupSegmentsToMaintainSize$2_set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2);
                l = BoxesRunTime.unboxToLong((Object)log.appendAsLeader($anonfun$testCleanupSegmentsToMaintainSize$2_set, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4()).firstOffset().get());
                Object var20_15 = null;
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Object var12_13 = null;
        log.updateHighWatermark(log.logEndOffset());
        Assert.assertEquals((String)"Check we have the expected number of segments.", (long)(numMessages * setSize / BoxesRunTime.unboxToInt((Object)config.segmentSize())), (long)log.numberOfSegments());
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assert.assertEquals((String)"Now there should be exactly 6 segments", (long)6L, (long)log.numberOfSegments());
        this.time().sleep(BoxesRunTime.unboxToLong((Object)log.config().fileDeleteDelayMs()) + 1L);
        Assert.assertEquals((String)"Files should have been deleted", (long)(log.numberOfSegments() * 3 + 3), (long)log.dir().list().length);
        int n2 = 1024;
        long readLog_offset = l + 1L;
        Assert.assertEquals((String)"Should get empty fetch off new log.", (long)0L, (long)log.read(readLog_offset, n2, (FetchIsolation)FetchLogEnd$.MODULE$, true).records().sizeInBytes());
        try {
            int n3 = 1024;
            long readLog_offset2 = 0L;
            log.read(readLog_offset2, n3, (FetchIsolation)FetchLogEnd$.MODULE$, true);
            Assert.fail((String)"Should get exception from fetching earlier.");
        }
        catch (OffsetOutOfRangeException offsetOutOfRangeException) {}
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
    }

    @Test
    public void testDoesntCleanLogsWithCompactDeletePolicy() {
        this.testDoesntCleanLogs(new StringBuilder(1).append(LogConfig$.MODULE$.Compact()).append(",").append(LogConfig$.MODULE$.Delete()).toString());
    }

    @Test
    public void testDoesntCleanLogsWithCompactPolicy() {
        this.testDoesntCleanLogs(LogConfig$.MODULE$.Compact());
    }

    private void testDoesntCleanLogs(String policy) {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), policy);
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        Function0 & Serializable x$2 = (Function0 & Serializable)() -> LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, (Function0)x$2, x$3, x$4);
        int n = 0;
        int until$extension_end = 200;
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                MemoryRecords $anonfun$testDoesntCleanLogs$2_set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
                log.appendAsLeader($anonfun$testDoesntCleanLogs$2_set, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4()).lastOffset();
                Object var14_13 = null;
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Object var11_11 = null;
        int numSegments = log.numberOfSegments();
        Assert.assertTrue((String)"There should be more than one segment now.", (log.numberOfSegments() > 1 ? 1 : 0) != 0);
        log.logSegments().foreach((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testDoesntCleanLogs$3(this, x$7)));
        this.time().sleep(this.maxLogAgeMs() + 1);
        Assert.assertEquals((String)"number of segments shouldn't have changed", (long)numSegments, (long)log.numberOfSegments());
    }

    @Test
    public void testTimeBasedFlush() {
        this.logManager().shutdown();
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.FlushMsProp(), (Object)1000);
        LogConfig config = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        this.logManager_$eq(this.createLogManager(this.createLogManager$default$1()));
        this.logManager().startup();
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        Function0 & Serializable x$2 = (Function0 & Serializable)() -> config;
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        Log log = qual$1.getOrCreateLog(x$1, (Function0)x$2, x$3, x$4);
        long lastFlush = log.lastFlushTime();
        int n = 0;
        int until$extension_end = 200;
        Range.Exclusive foreach_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                LogManagerTest.$anonfun$testTimeBasedFlush$2(log, foreach_i);
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement) break;
                foreach_i += foreach_this.step();
            }
        }
        Object var12_12 = null;
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assert.assertTrue((String)"Time based flush should have been triggered", (lastFlush != log.lastFlushTime() ? 1 : 0) != 0);
    }

    @Test
    public void testLeastLoadedAssignment() {
        .colon.colon dirs = new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)new .colon.colon((Object)TestUtils.tempDirectory(null, null), (List)Nil$.MODULE$)));
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)dirs));
        int n = 0;
        int until$extension_end = 20;
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                LogManagerTest.$anonfun$testLeastLoadedAssignment$1(this, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
    }

    @Test
    public void testTwoLogManagersUsingSameDirFails() {
        try {
            this.createLogManager(this.createLogManager$default$1());
            Assert.fail((String)"Should not be able to create a second log manager instance with the same data directory");
            return;
        }
        catch (KafkaException kafkaException) {
            return;
        }
    }

    @Test
    public void testCheckpointRecoveryPoints() {
        this.verifyCheckpointRecovery((scala.collection.immutable.Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("test-a", 1), (List)new .colon.colon((Object)new TopicPartition("test-b", 1), (List)Nil$.MODULE$)), this.logManager(), this.logDir());
    }

    @Test
    public void testRecoveryDirectoryMappingWithTrailingSlash() {
        this.logManager().shutdown();
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)new .colon.colon((Object)new File(new StringBuilder(0).append(TestUtils.tempDirectory(null, null).getAbsolutePath()).append(File.separator).toString()), (List)Nil$.MODULE$), LogConfig$.MODULE$.apply(), TestUtils$.MODULE$.createLogManager$default$3(), new MockTime()));
        this.logManager().startup();
        this.verifyCheckpointRecovery((scala.collection.immutable.Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("test-a", 1), (List)Nil$.MODULE$), this.logManager(), (File)this.logManager().liveLogDirs().head());
    }

    @Test
    public void testRecoveryDirectoryMappingWithRelativeDirectory() {
        this.logManager().shutdown();
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)new .colon.colon((Object)new File("data", this.logDir().getName()).getAbsoluteFile(), (List)Nil$.MODULE$)));
        this.logManager().startup();
        this.verifyCheckpointRecovery((scala.collection.immutable.Seq<TopicPartition>)new .colon.colon((Object)new TopicPartition("test-a", 1), (List)Nil$.MODULE$), this.logManager(), (File)this.logManager().liveLogDirs().head());
    }

    private void verifyCheckpointRecovery(scala.collection.immutable.Seq<TopicPartition> topicPartitions, LogManager logManager, File logDir) {
        scala.collection.immutable.Seq logs = (scala.collection.immutable.Seq)topicPartitions.map((Function1 & Serializable)x$11 -> logManager.getOrCreateLog(x$11, (Function0 & Serializable)() -> this.logConfig(), logManager.getOrCreateLog$default$3(), logManager.getOrCreateLog$default$4()));
        logs.foreach((Function1 & Serializable)log -> {
            LogManagerTest.$anonfun$verifyCheckpointRecovery$3(log);
            return BoxedUnit.UNIT;
        });
        logManager.checkpointLogRecoveryOffsets();
        Map checkpoints = new OffsetCheckpointFile(new File(logDir, LogManager$.MODULE$.RecoveryPointCheckpointFile()), null).read();
        ((IterableOnceOps)topicPartitions.zip((IterableOnce)logs)).foreach((Function1 & Serializable)x0$1 -> {
            LogManagerTest.$anonfun$verifyCheckpointRecovery$5(checkpoints, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private LogManager createLogManager(scala.collection.immutable.Seq<File> logDirs) {
        LogConfig x$1 = this.logConfig();
        MockTime x$3 = this.time();
        CleanerConfig x$4 = TestUtils$.MODULE$.createLogManager$default$3();
        return TestUtils$.MODULE$.createLogManager((Seq<File>)logDirs, x$1, x$4, x$3);
    }

    private scala.collection.immutable.Seq<File> createLogManager$default$1() {
        return new .colon.colon((Object)this.logDir(), (List)Nil$.MODULE$);
    }

    @Test
    public void testFileReferencesAfterAsyncDelete() {
        Object object;
        File[] fileArray;
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(this.name(), 0);
        Function0 & Serializable x$2 = (Function0 & Serializable)() -> this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        LogSegment activeSegment = qual$1.getOrCreateLog(x$1, (Function0)x$2, x$3, x$4).activeSegment();
        String logName = activeSegment.log().file().getName();
        String indexName = activeSegment.offsetIndex().file().getName();
        String timeIndexName = activeSegment.timeIndex().file().getName();
        String txnIndexName = activeSegment.txnIndex().file().getName();
        File[] fileArray2 = fileArray = activeSegment.log().file().getParentFile().listFiles();
        fileArray = null;
        File[] filter$extension_$this = fileArray2;
        ClassTag filter$extension_make_evidence$1 = ClassTag$.MODULE$.apply(filter$extension_$this.getClass().getComponentType());
        Class clazz = filter$extension_make_evidence$1.runtimeClass();
        Class<Byte> clazz2 = Byte.TYPE;
        if (!(clazz2 != null ? !clazz2.equals(clazz) : clazz != null)) {
            object = new ArrayBuilder.ofByte();
        } else {
            Class<Short> clazz3 = Short.TYPE;
            if (!(clazz3 != null ? !clazz3.equals(clazz) : clazz != null)) {
                object = new ArrayBuilder.ofShort();
            } else {
                Class<Character> clazz4 = Character.TYPE;
                if (!(clazz4 != null ? !clazz4.equals(clazz) : clazz != null)) {
                    object = new ArrayBuilder.ofChar();
                } else {
                    Class<Integer> clazz5 = Integer.TYPE;
                    if (!(clazz5 != null ? !clazz5.equals(clazz) : clazz != null)) {
                        object = new ArrayBuilder.ofInt();
                    } else {
                        Class<Long> clazz6 = Long.TYPE;
                        if (!(clazz6 != null ? !clazz6.equals(clazz) : clazz != null)) {
                            object = new ArrayBuilder.ofLong();
                        } else {
                            Class<Float> clazz7 = Float.TYPE;
                            if (!(clazz7 != null ? !clazz7.equals(clazz) : clazz != null)) {
                                object = new ArrayBuilder.ofFloat();
                            } else {
                                Class<Double> clazz8 = Double.TYPE;
                                if (!(clazz8 != null ? !clazz8.equals(clazz) : clazz != null)) {
                                    object = new ArrayBuilder.ofDouble();
                                } else {
                                    Class<Boolean> clazz9 = Boolean.TYPE;
                                    if (!(clazz9 != null ? !clazz9.equals(clazz) : clazz != null)) {
                                        object = new ArrayBuilder.ofBoolean();
                                    } else {
                                        Class<Void> clazz10 = Void.TYPE;
                                        object = !(clazz10 != null ? !clazz10.equals(clazz) : clazz != null) ? new ArrayBuilder.ofUnit() : new ArrayBuilder.ofRef(filter$extension_make_evidence$1);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        ArrayBuilder.ofByte ofByte2 = object;
        Object var24_13 = null;
        object = null;
        clazz = null;
        ArrayBuilder.ofByte filter$extension_res = ofByte2;
        for (int filter$extension_i = 0; filter$extension_i < filter$extension_$this.length; ++filter$extension_i) {
            File filter$extension_x = filter$extension_$this[filter$extension_i];
            if (!LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$2(filter$extension_x)) continue;
            filter$extension_res.addOne((Object)filter$extension_x);
        }
        Object var20_12 = null;
        Object var21_16 = null;
        Object var23_18 = null;
        File[] indexFilesOnDiskBeforeDelete = (File[])filter$extension_res.result();
        LogManager qual$2 = this.logManager();
        TopicPartition x$5 = new TopicPartition(this.name(), 0);
        boolean x$6 = qual$2.asyncDelete$default$2();
        boolean x$7 = qual$2.asyncDelete$default$3();
        Log removedLog = (Log)qual$2.asyncDelete(x$5, x$6, x$7).get();
        LogSegment removedSegment = removedLog.activeSegment();
        .colon.colon indexFilesAfterDelete = new .colon.colon((Object)removedSegment.lazyOffsetIndex().file(), (List)new .colon.colon((Object)removedSegment.lazyTimeIndex().file(), (List)new .colon.colon((Object)removedSegment.txnIndex().file(), (List)Nil$.MODULE$)));
        Assert.assertEquals((Object)new File(removedLog.dir(), logName), (Object)removedSegment.log().file());
        Assert.assertEquals((Object)new File(removedLog.dir(), indexName), (Object)removedSegment.lazyOffsetIndex().file());
        Assert.assertEquals((Object)new File(removedLog.dir(), timeIndexName), (Object)removedSegment.lazyTimeIndex().file());
        Assert.assertEquals((Object)new File(removedLog.dir(), txnIndexName), (Object)removedSegment.txnIndex().file());
        for (File file : indexFilesOnDiskBeforeDelete) {
            LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$3((scala.collection.immutable.Seq)indexFilesAfterDelete, file);
        }
        this.time().sleep(this.logManager().InitialTaskDelayMs());
        Assert.assertTrue((String)"Logs deleted too early", (boolean)this.logManager().hasLogsToBeDeleted());
        this.time().sleep(BoxesRunTime.unboxToLong((Object)this.logManager().currentDefaultConfig().fileDeleteDelayMs()) - (long)this.logManager().InitialTaskDelayMs());
        Assert.assertFalse((String)"Logs not deleted", (boolean)this.logManager().hasLogsToBeDeleted());
    }

    @Test
    public void testCreateAndDeleteOverlyLongTopic() {
        String invalidTopicName = String.join((CharSequence)"", Collections.nCopies(253, "x"));
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = new TopicPartition(invalidTopicName, 0);
        Function0 & Serializable x$2 = (Function0 & Serializable)() -> this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        qual$1.getOrCreateLog(x$1, (Function0)x$2, x$3, x$4);
        LogManager qual$2 = this.logManager();
        TopicPartition x$5 = new TopicPartition(invalidTopicName, 0);
        boolean x$6 = qual$2.asyncDelete$default$2();
        boolean x$7 = qual$2.asyncDelete$default$3();
        qual$2.asyncDelete(x$5, x$6, x$7);
    }

    @Test
    public void testCheckpointForOnlyAffectedLogs() {
        .colon.colon tps = new .colon.colon((Object)new TopicPartition("test-a", 0), (List)new .colon.colon((Object)new TopicPartition("test-a", 1), (List)new .colon.colon((Object)new TopicPartition("test-a", 2), (List)new .colon.colon((Object)new TopicPartition("test-b", 0), (List)new .colon.colon((Object)new TopicPartition("test-b", 1), (List)Nil$.MODULE$)))));
        scala.collection.immutable.Seq allLogs = (scala.collection.immutable.Seq)tps.map((Function1 & Serializable)x$16 -> {
            LogManager qual$1 = this.logManager();
            Function0 & Serializable x$2 = (Function0 & Serializable)() -> this.logConfig();
            boolean x$3 = qual$1.getOrCreateLog$default$3();
            boolean x$4 = qual$1.getOrCreateLog$default$4();
            return qual$1.getOrCreateLog(x$16, (Function0)x$2, x$3, x$4);
        });
        allLogs.foreach((Function1 & Serializable)log -> {
            LogManagerTest.$anonfun$testCheckpointForOnlyAffectedLogs$3(log);
            return BoxedUnit.UNIT;
        });
        this.logManager().checkpointRecoveryOffsetsAndCleanSnapshotsInDir(this.logDir(), (Seq)allLogs.filter((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testCheckpointForOnlyAffectedLogs$5(x$18))));
        Map checkpoints = new OffsetCheckpointFile(new File(this.logDir(), LogManager$.MODULE$.RecoveryPointCheckpointFile()), null).read();
        ((IterableOnceOps)tps.zip((IterableOnce)allLogs)).foreach((Function1 & Serializable)x0$1 -> {
            LogManagerTest.$anonfun$testCheckpointForOnlyAffectedLogs$6(checkpoints, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private FetchDataInfo readLog(Log log, long offset, int maxLength) {
        return log.read(offset, maxLength, (FetchIsolation)FetchLogEnd$.MODULE$, true);
    }

    private int readLog$default$3() {
        return 1024;
    }

    @Test
    public void testTopicConfigChangeUpdatesLogConfig() {
        BooleanRef booleanRef;
        BooleanRef booleanRef2;
        String testTopicOne = "test-topic-one";
        String testTopicTwo = "test-topic-two";
        TopicPartition testTopicOnePartition = new TopicPartition(testTopicOne, 1);
        TopicPartition testTopicTwoPartition = new TopicPartition(testTopicTwo, 1);
        Log mockLog = (Log)EasyMock.mock(Log.class);
        this.logManager().initializingLog(testTopicOnePartition);
        this.logManager().initializingLog(testTopicTwoPartition);
        this.logManager().topicConfigUpdated(testTopicOne);
        boolean create_e = false;
        BooleanRef booleanRef3 = booleanRef2 = new BooleanRef(create_e);
        booleanRef2 = null;
        BooleanRef configUpdated = booleanRef3;
        this.logManager().finishedInitializingLog(testTopicOnePartition, (Option)new Some((Object)mockLog), () -> LogManagerTest.$anonfun$testTopicConfigChangeUpdatesLogConfig$1(configUpdated, null));
        Assert.assertTrue((boolean)configUpdated.elem);
        boolean create_e2 = true;
        BooleanRef booleanRef4 = booleanRef = new BooleanRef(create_e2);
        booleanRef = null;
        BooleanRef configNotUpdated = booleanRef4;
        this.logManager().finishedInitializingLog(testTopicTwoPartition, (Option)new Some((Object)mockLog), () -> LogManagerTest.$anonfun$testTopicConfigChangeUpdatesLogConfig$2(configNotUpdated, null));
        Assert.assertTrue((boolean)configNotUpdated.elem);
    }

    @Test
    public void testConfigChangeGetsCleanedUp() {
        BooleanRef booleanRef;
        TopicPartition testTopicPartition = new TopicPartition("test-topic", 1);
        this.logManager().initializingLog(testTopicPartition);
        boolean create_e = true;
        BooleanRef booleanRef2 = booleanRef = new BooleanRef(create_e);
        booleanRef = null;
        BooleanRef configUpdateNotCalled = booleanRef2;
        this.logManager().finishedInitializingLog(testTopicPartition, (Option)None$.MODULE$, () -> LogManagerTest.$anonfun$testConfigChangeGetsCleanedUp$1(configUpdateNotCalled, null));
        Assert.assertTrue((boolean)this.logManager().partitionsInitializing().isEmpty());
        Assert.assertTrue((boolean)configUpdateNotCalled.elem);
    }

    @Test
    public void testBrokerConfigChangeDeliveredToAllLogs() {
        IntRef intRef;
        String testTopicOne = "test-topic-one";
        String testTopicTwo = "test-topic-two";
        TopicPartition testTopicOnePartition = new TopicPartition(testTopicOne, 1);
        TopicPartition testTopicTwoPartition = new TopicPartition(testTopicTwo, 1);
        Log mockLog = (Log)EasyMock.mock(Log.class);
        this.logManager().initializingLog(testTopicOnePartition);
        this.logManager().initializingLog(testTopicTwoPartition);
        this.logManager().brokerConfigUpdated();
        int create_e = 0;
        IntRef intRef2 = intRef = new IntRef(create_e);
        intRef = null;
        IntRef totalChanges = intRef2;
        this.logManager().finishedInitializingLog(testTopicOnePartition, (Option)new Some((Object)mockLog), () -> LogManagerTest.$anonfun$testBrokerConfigChangeDeliveredToAllLogs$1(totalChanges, null));
        this.logManager().finishedInitializingLog(testTopicTwoPartition, (Option)new Some((Object)mockLog), () -> LogManagerTest.$anonfun$testBrokerConfigChangeDeliveredToAllLogs$2(totalChanges, null));
        Assert.assertEquals((long)2L, (long)totalChanges.elem);
    }

    @Test
    public void testConfigChangesWithNoLogGettingInitialized() {
        this.logManager().brokerConfigUpdated();
        this.logManager().topicConfigUpdated("test-topic");
        Assert.assertTrue((boolean)this.logManager().partitionsInitializing().isEmpty());
    }

    @Test
    public void testMetricsExistWhenLogIsRecreatedBeforeDeletion() {
        String topicName = "metric-test";
        TopicPartition tp = new TopicPartition(topicName, 0);
        String metricTag = new StringBuilder(17).append("topic=").append(tp.topic()).append(",partition=").append(tp.partition()).toString();
        LogManager qual$1 = this.logManager();
        Function0 & Serializable x$2 = (Function0 & Serializable)() -> this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        qual$1.getOrCreateLog(tp, (Function0)x$2, x$3, x$4);
        LogManagerTest.verifyMetrics$1(metricTag, topicName);
        LogManager qual$2 = this.logManager();
        boolean x$6 = qual$2.asyncDelete$default$2();
        boolean x$7 = qual$2.asyncDelete$default$3();
        Log removedLog = (Log)qual$2.asyncDelete(tp, x$6, x$7).get();
        Assert.assertTrue((boolean)LogManagerTest.logMetrics$1(topicName).isEmpty());
        LogManager qual$3 = this.logManager();
        Function0 & Serializable x$9 = (Function0 & Serializable)() -> this.logConfig();
        boolean x$10 = qual$3.getOrCreateLog$default$3();
        boolean x$11 = qual$3.getOrCreateLog$default$4();
        qual$3.getOrCreateLog(tp, (Function0)x$9, x$10, x$11);
        LogManagerTest.verifyMetrics$1(metricTag, topicName);
        this.time().sleep(BoxesRunTime.unboxToLong((Object)this.logConfig().fileDeleteDelayMs()) + 1L);
        Assert.assertTrue((boolean)removedLog.logSegments().isEmpty());
        LogManagerTest.verifyMetrics$1(metricTag, topicName);
    }

    @Test
    public void testMetricsAreRemovedWhenMovingCurrentToFutureLog() {
        File file;
        File file2;
        File file3;
        File file4;
        File file5;
        File file6;
        File file7 = file6 = TestUtils.tempDirectory(null, null);
        file6 = null;
        File file8 = file5 = file7;
        file5 = null;
        File file9 = file4 = file8;
        file4 = null;
        File dir1 = file9;
        File file10 = file3 = TestUtils.tempDirectory(null, null);
        file3 = null;
        File file11 = file2 = file10;
        file2 = null;
        File file12 = file = file11;
        file = null;
        File dir2 = file12;
        this.logManager_$eq(this.createLogManager((scala.collection.immutable.Seq<File>)new .colon.colon((Object)dir1, (List)new .colon.colon((Object)dir2, (List)Nil$.MODULE$))));
        this.logManager().startup();
        String topicName = "future-log";
        TopicPartition tp = new TopicPartition(topicName, 0);
        String metricTag = new StringBuilder(17).append("topic=").append(tp.topic()).append(",partition=").append(tp.partition()).toString();
        this.logManager().maybeUpdatePreferredLogDir(tp, dir1.getAbsolutePath());
        LogManager qual$1 = this.logManager();
        Function0 & Serializable x$2 = (Function0 & Serializable)() -> this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        qual$1.getOrCreateLog(tp, (Function0)x$2, x$3, x$4);
        this.logManager().maybeUpdatePreferredLogDir(tp, dir2.getAbsolutePath());
        LogManager qual$2 = this.logManager();
        Function0 & Serializable x$6 = (Function0 & Serializable)() -> this.logConfig();
        boolean x$8 = qual$2.getOrCreateLog$default$3();
        qual$2.getOrCreateLog(tp, (Function0)x$6, x$8, true);
        LogManagerTest.verifyMetrics$2(2, metricTag, topicName);
        this.logManager().replaceCurrentWithFutureLog(tp);
        LogManagerTest.verifyMetrics$2(1, metricTag, topicName);
        this.time().sleep(BoxesRunTime.unboxToLong((Object)this.logConfig().fileDeleteDelayMs()) + 1L);
        LogManagerTest.verifyMetrics$2(1, metricTag, topicName);
    }

    public static final /* synthetic */ void $anonfun$tearDown$1(File x$1) {
        Utils.delete((File)x$1);
    }

    public static final /* synthetic */ String $anonfun$testCreateLogWithLogDirFallback$1(int x$1) {
        return ((Object)BoxesRunTime.boxToInteger((int)x$1)).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testCreateLogWithLogDirFallback$5(LogManagerTest $this, File dir) {
        return new File(dir, new StringBuilder(2).append($this.name()).append("-0").toString()).exists();
    }

    public static final /* synthetic */ void $anonfun$testCleanupExpiredSegments$2(Log log$1, LongRef offset$1, int x$3) {
        MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2);
        LogAppendInfo info = log$1.appendAsLeader(set, 0, log$1.appendAsLeader$default$3(), log$1.appendAsLeader$default$4());
        offset$1.elem = info.lastOffset();
    }

    public static final /* synthetic */ boolean $anonfun$testCleanupExpiredSegments$3(LogManagerTest $this, LogSegment x$4) {
        return x$4.log().file().setLastModified($this.time().milliseconds());
    }

    public static final /* synthetic */ void $anonfun$testCleanupSegmentsToMaintainSize$2(Log log$2, LongRef offset$2, int x$5) {
        MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2);
        LogAppendInfo info = log$2.appendAsLeader(set, 0, log$2.appendAsLeader$default$3(), log$2.appendAsLeader$default$4());
        offset$2.elem = BoxesRunTime.unboxToLong((Object)info.firstOffset().get());
    }

    public static final /* synthetic */ void $anonfun$testDoesntCleanLogs$2(Log log$3, LongRef offset$3, int x$6) {
        MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        LogAppendInfo info = log$3.appendAsLeader(set, 0, log$3.appendAsLeader$default$3(), log$3.appendAsLeader$default$4());
        offset$3.elem = info.lastOffset();
    }

    public static final /* synthetic */ boolean $anonfun$testDoesntCleanLogs$3(LogManagerTest $this, LogSegment x$7) {
        return x$7.log().file().setLastModified($this.time().milliseconds());
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testTimeBasedFlush$2(Log log$4, int x$8) {
        MemoryRecords set = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2);
        return log$4.appendAsLeader(set, 0, log$4.appendAsLeader$default$3(), log$4.appendAsLeader$default$4());
    }

    public static final /* synthetic */ void $anonfun$testLeastLoadedAssignment$1(LogManagerTest $this, int partition) {
        LogManager qual$1 = $this.logManager();
        TopicPartition x$1 = new TopicPartition("test", partition);
        Function0 & Serializable x$2 = (Function0 & Serializable)() -> $this.logConfig();
        boolean x$3 = qual$1.getOrCreateLog$default$3();
        boolean x$4 = qual$1.getOrCreateLog$default$4();
        qual$1.getOrCreateLog(x$1, (Function0)x$2, x$3, x$4);
        Assert.assertEquals((String)"We should have created the right number of logs", (long)(partition + 1), (long)$this.logManager().allLogs().size());
        Iterable counts = (Iterable)$this.logManager().allLogs().groupBy((Function1 & Serializable)x$9 -> x$9.dir().getParent()).values().map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.size()));
        Assert.assertTrue((String)"Load should balance evenly", (BoxesRunTime.unboxToInt((Object)counts.max((Ordering)Ordering.Int$.MODULE$)) <= BoxesRunTime.unboxToInt((Object)counts.min((Ordering)Ordering.Int$.MODULE$)) + 1 ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$verifyCheckpointRecovery$3(Log log) {
        int n = 0;
        int until$extension_end = 50;
        Range.Exclusive foreach_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement) break;
                foreach_i += foreach_this.step();
            }
        }
        Object var2_3 = null;
        log.flush();
    }

    public static final /* synthetic */ void $anonfun$verifyCheckpointRecovery$5(Map checkpoints$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            Log log = (Log)x0$1._2();
            Assert.assertEquals((String)"Recovery point should equal checkpoint", (long)BoxesRunTime.unboxToLong((Object)checkpoints$1.apply((Object)tp)), (long)log.recoveryPoint());
            Assert.assertEquals((Object)new Some((Object)log.minSnapshotsOffsetToRetain()), (Object)log.oldestProducerSnapshotOffset());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testFileReferencesAfterAsyncDelete$2(File x$13) {
        return x$13.getName().endsWith("index");
    }

    public static final /* synthetic */ boolean $anonfun$testFileReferencesAfterAsyncDelete$4(File fileBeforeDelete$1, File x$14) {
        String string = x$14.getName();
        String string2 = fileBeforeDelete$1.getName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ String $anonfun$testFileReferencesAfterAsyncDelete$5(File x$15) {
        return x$15.getName();
    }

    public static final /* synthetic */ void $anonfun$testFileReferencesAfterAsyncDelete$3(scala.collection.immutable.Seq indexFilesAfterDelete$1, File fileBeforeDelete) {
        Option fileInIndex = indexFilesAfterDelete$1.find((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$4(fileBeforeDelete, x$14)));
        if (fileInIndex == null) {
            throw null;
        }
        Object object = fileInIndex.isEmpty() ? None$.MODULE$ : new Some((Object)((File)fileInIndex.get()).getName());
        None$ none$ = object;
        object = null;
        Assert.assertEquals((String)new StringBuilder(51).append("Could not find index file ").append(fileBeforeDelete.getName()).append(" in indexFilesAfterDelete").toString(), (Object)new Some((Object)fileBeforeDelete.getName()), (Object)none$);
        Assert.assertNotEquals((String)"File reference was not updated in index", (Object)fileBeforeDelete.getAbsolutePath(), (Object)((File)fileInIndex.get()).getAbsolutePath());
    }

    public static final /* synthetic */ void $anonfun$testCheckpointForOnlyAffectedLogs$3(Log log) {
        int n = 0;
        int until$extension_end = 50;
        Range.Exclusive foreach_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement) break;
                foreach_i += foreach_this.step();
            }
        }
        Object var2_3 = null;
        log.flush();
    }

    public static final /* synthetic */ boolean $anonfun$testCheckpointForOnlyAffectedLogs$5(Log x$18) {
        return x$18.dir().getName().contains("test-a");
    }

    public static final /* synthetic */ void $anonfun$testCheckpointForOnlyAffectedLogs$6(Map checkpoints$2, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            Log log = (Log)x0$1._2();
            Assert.assertEquals((String)"Recovery point should equal checkpoint", (long)BoxesRunTime.unboxToLong((Object)checkpoints$2.apply((Object)tp)), (long)log.recoveryPoint());
            if (tp.topic().equals("test-a")) {
                Assert.assertEquals((Object)new Some((Object)log.minSnapshotsOffsetToRetain()), (Object)log.oldestProducerSnapshotOffset());
                return;
            }
            Assert.assertNotEquals((Object)new Some((Object)log.minSnapshotsOffsetToRetain()), (Object)log.oldestProducerSnapshotOffset());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ LogConfig $anonfun$testTopicConfigChangeUpdatesLogConfig$1(BooleanRef configUpdated$1, LogConfig logConfig$1) {
        configUpdated$1.elem = true;
        return logConfig$1;
    }

    public static final /* synthetic */ LogConfig $anonfun$testTopicConfigChangeUpdatesLogConfig$2(BooleanRef configNotUpdated$1, LogConfig logConfig$1) {
        configNotUpdated$1.elem = false;
        return logConfig$1;
    }

    public static final /* synthetic */ LogConfig $anonfun$testConfigChangeGetsCleanedUp$1(BooleanRef configUpdateNotCalled$1, LogConfig logConfig$2) {
        configUpdateNotCalled$1.elem = false;
        return logConfig$2;
    }

    public static final /* synthetic */ LogConfig $anonfun$testBrokerConfigChangeDeliveredToAllLogs$1(IntRef totalChanges$1, LogConfig logConfig$3) {
        ++totalChanges$1.elem;
        return logConfig$3;
    }

    public static final /* synthetic */ LogConfig $anonfun$testBrokerConfigChangeDeliveredToAllLogs$2(IntRef totalChanges$1, LogConfig logConfig$3) {
        ++totalChanges$1.elem;
        return logConfig$3;
    }

    public static final /* synthetic */ boolean $anonfun$testMetricsExistWhenLogIsRecreatedBeforeDeletion$1(String topicName$1, MetricName metric) {
        String string = metric.getType();
        String string2 = "Log";
        return string != null && string.equals(string2) && metric.getScope().contains(topicName$1);
    }

    private static final Set logMetrics$1(String topicName$1) {
        return (Set)AsScalaExtensions.SetHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala().filter((Function1 & Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testMetricsExistWhenLogIsRecreatedBeforeDeletion$1(topicName$1, metric)));
    }

    public static final /* synthetic */ void $anonfun$testMetricsExistWhenLogIsRecreatedBeforeDeletion$2(String metricTag$1, MetricName metric) {
        Assert.assertTrue((boolean)metric.getMBeanName().contains(metricTag$1));
    }

    private static final void verifyMetrics$1(String metricTag$1, String topicName$1) {
        List list = LogMetricNames$.MODULE$.allMetricNames();
        if (list == null) {
            throw null;
        }
        Assert.assertEquals((long)SeqOps.size$((SeqOps)list), (long)LogManagerTest.logMetrics$1(topicName$1).size());
        LogManagerTest.logMetrics$1(topicName$1).foreach((Function1 & Serializable)metric -> {
            LogManagerTest.$anonfun$testMetricsExistWhenLogIsRecreatedBeforeDeletion$2(metricTag$1, metric);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$1(String topicName$2, MetricName metric) {
        String string = metric.getType();
        String string2 = "Log";
        return string != null && string.equals(string2) && metric.getScope().contains(topicName$2);
    }

    private static final Set logMetrics$2(String topicName$2) {
        return (Set)AsScalaExtensions.SetHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, KafkaYammerMetrics.defaultRegistry().allMetrics().keySet()).asScala().filter((Function1 & Serializable)metric -> BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$1(topicName$2, metric)));
    }

    public static final /* synthetic */ void $anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$2(String metricTag$2, MetricName metric) {
        Assert.assertTrue((boolean)metric.getMBeanName().contains(metricTag$2));
    }

    private static final void verifyMetrics$2(int logCount, String metricTag$2, String topicName$2) {
        List list = LogMetricNames$.MODULE$.allMetricNames();
        if (list == null) {
            throw null;
        }
        Assert.assertEquals((long)(SeqOps.size$((SeqOps)list) * logCount), (long)LogManagerTest.logMetrics$2(topicName$2).size());
        LogManagerTest.logMetrics$2(topicName$2).foreach((Function1 & Serializable)metric -> {
            LogManagerTest.$anonfun$testMetricsAreRemovedWhenMovingCurrentToFutureLog$2(metricTag$2, metric);
            return BoxedUnit.UNIT;
        });
    }

    public LogManagerTest() {
        this.maxRollInterval = 100;
        this.maxLogAgeMs = 600000;
        this.logProps().put(LogConfig$.MODULE$.SegmentBytesProp(), (Object)1024);
        this.logProps().put(LogConfig$.MODULE$.SegmentIndexBytesProp(), (Object)4096);
        this.logProps().put(LogConfig$.MODULE$.RetentionMsProp(), (Object)this.maxLogAgeMs());
        this.logProps().put(LogConfig$.MODULE$.MessageTimestampDifferenceMaxMsProp(), ((Object)Long.MAX_VALUE).toString());
        this.logConfig = new LogConfig((java.util.Map)this.logProps(), LogConfig$.MODULE$.apply$default$2());
        this.logDir = null;
        this.logManager = null;
        this.name = "kafka";
        this.veryLargeLogFlushInterval = 10000000L;
    }

    public static final /* synthetic */ String $anonfun$testCreateLogWithLogDirFallback$1$adapted(Object x$1) {
        return LogManagerTest.$anonfun$testCreateLogWithLogDirFallback$1(BoxesRunTime.unboxToInt((Object)x$1));
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testTimeBasedFlush$2$adapted(Log log$4, Object x$8) {
        return LogManagerTest.$anonfun$testTimeBasedFlush$2(log$4, BoxesRunTime.unboxToInt((Object)x$8));
    }

    public static final /* synthetic */ Object $anonfun$testFileReferencesAfterAsyncDelete$2$adapted(File x$13) {
        return BoxesRunTime.boxToBoolean((boolean)LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$2(x$13));
    }

    public static final /* synthetic */ Object $anonfun$testFileReferencesAfterAsyncDelete$3$adapted(scala.collection.immutable.Seq indexFilesAfterDelete$1, File fileBeforeDelete) {
        LogManagerTest.$anonfun$testFileReferencesAfterAsyncDelete$3(indexFilesAfterDelete$1, fileBeforeDelete);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$verifyCheckpointRecovery$4$adapted(Log log$5, Object x$12) {
        return log$5.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log$5.appendAsLeader$default$3(), log$5.appendAsLeader$default$4());
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testCheckpointForOnlyAffectedLogs$4$adapted(Log log$6, Object x$17) {
        return log$6.appendAsLeader(TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log$6.appendAsLeader$default$3(), log$6.appendAsLeader$default$4());
    }
}

