/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.network.RequestChannel;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientSensors;
import kafka.server.ControllerMutationQuota;
import kafka.server.ControllerMutationQuotaManager$;
import kafka.server.PermissiveControllerMutationQuota;
import kafka.server.QuotaType$ControllerMutation$;
import kafka.server.StrictControllerMutationQuota;
import kafka.server.UnboundedControllerMutationQuota$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.TokenBucket;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import scala.Function0;
import scala.Option;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005%v!B\u000e\u001d\u0011\u0003\tc!B\u0012\u001d\u0011\u0003!\u0003\"B\u0016\u0002\t\u0003a\u0003bB\u0017\u0002\u0005\u0004%\tA\f\u0005\u0007e\u0005\u0001\u000b\u0011B\u0018\t\u000bM\nA\u0011\u0001\u001b\u0007\t\rb\u0002!\u0013\u0005\t\u001b\u001a\u0011)\u0019!C\u0005\u001d\"A!K\u0002B\u0001B\u0003%q\n\u0003\u0005>\r\t\u0015\r\u0011\"\u0003T\u0011!9fA!A!\u0002\u0013!\u0006\u0002\u0003-\u0007\u0005\u000b\u0007I\u0011B-\t\u0011\u00014!\u0011!Q\u0001\niC\u0001\"\u0019\u0004\u0003\u0006\u0004%IA\u0019\u0005\t]\u001a\u0011\t\u0011)A\u0005G\"AqN\u0002BC\u0002\u0013%\u0001\u000f\u0003\u0005|\r\t\u0005\t\u0015!\u0003r\u0011\u0015Yc\u0001\"\u0001}\u0011\u001d\t9A\u0002C)\u0003\u0013Aq!!\b\u0007\t\u0013\ty\u0002C\u0004\u0002$\u0019!\t&!\n\t\u000f\u0005ub\u0001\"\u0011\u0002@!9\u0011q\u000e\u0004\u0005\u0002\u0005E\u0004bBA8\r\u0011\u0005\u0011Q\u0010\u0005\b\u0003\u001b3A\u0011AAH\u0011\u001d\tiI\u0002C\u0001\u0003+Cq!!'\u0007\t\u0003\tY*\u0001\u0010D_:$(o\u001c7mKJlU\u000f^1uS>t\u0017+^8uC6\u000bg.Y4fe*\u0011QDH\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003}\tQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002#\u00035\tAD\u0001\u0010D_:$(o\u001c7mKJlU\u000f^1uS>t\u0017+^8uC6\u000bg.Y4feN\u0011\u0011!\n\t\u0003M%j\u0011a\n\u0006\u0002Q\u0005)1oY1mC&\u0011!f\n\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005\t\u0013AH)v_R\f7i\u001c8ue>dG.\u001a:NkR\fG/[8o\t\u00164\u0017-\u001e7u+\u0005y\u0003C\u0001\u00141\u0013\t\ttE\u0001\u0004E_V\u0014G.Z\u0001 #V|G/Y\"p]R\u0014x\u000e\u001c7fe6+H/\u0019;j_:$UMZ1vYR\u0004\u0013A\u0004;ie>$H\u000f\\3US6,Wj\u001d\u000b\u0004ka:\u0005C\u0001\u00147\u0013\t9tE\u0001\u0003M_:<\u0007\"B\u001d\u0006\u0001\u0004Q\u0014!A3\u0011\u0005m*U\"\u0001\u001f\u000b\u0005ur\u0014aB7fiJL7m\u001d\u0006\u0003\u007f\u0001\u000baaY8n[>t'BA\u0010B\u0015\t\u00115)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\t\u0006\u0019qN]4\n\u0005\u0019c$aF)v_R\fg+[8mCRLwN\\#yG\u0016\u0004H/[8o\u0011\u0015AU\u00011\u00016\u0003\u0019!\u0018.\\3NgN\u0011aA\u0013\t\u0003E-K!\u0001\u0014\u000f\u0003%\rc\u0017.\u001a8u#V|G/Y'b]\u0006<WM]\u0001\u0007G>tg-[4\u0016\u0003=\u0003\"A\t)\n\u0005Ec\"\u0001G\"mS\u0016tG/U;pi\u0006l\u0015M\\1hKJ\u001cuN\u001c4jO\u000691m\u001c8gS\u001e\u0004S#\u0001+\u0011\u0005m*\u0016B\u0001,=\u0005\u001diU\r\u001e:jGN\f\u0001\"\\3ue&\u001c7\u000fI\u0001\u0005i&lW-F\u0001[!\tYf,D\u0001]\u0015\tif(A\u0003vi&d7/\u0003\u0002`9\n!A+[7f\u0003\u0015!\u0018.\\3!\u0003A!\bN]3bI:\u000bW.\u001a)sK\u001aL\u00070F\u0001d!\t!7N\u0004\u0002fSB\u0011amJ\u0007\u0002O*\u0011\u0001\u000eI\u0001\u0007yI|w\u000e\u001e \n\u0005)<\u0013A\u0002)sK\u0012,g-\u0003\u0002m[\n11\u000b\u001e:j]\u001eT!A[\u0014\u0002#QD'/Z1e\u001d\u0006lW\r\u0015:fM&D\b%A\u0007rk>$\u0018mQ1mY\n\f7m[\u000b\u0002cB\u0019aE\u001d;\n\u0005M<#AB(qi&|g\u000e\u0005\u0002vs6\taO\u0003\u0002xq\u0006)\u0011/^8uC*\u0011Q\u0004Q\u0005\u0003uZ\u00141c\u00117jK:$\u0018+^8uC\u000e\u000bG\u000e\u001c2bG.\fa\"];pi\u0006\u001c\u0015\r\u001c7cC\u000e\\\u0007\u0005F\u0005~}~\f\t!a\u0001\u0002\u0006A\u0011!E\u0002\u0005\u0006\u001bF\u0001\ra\u0014\u0005\u0006{E\u0001\r\u0001\u0016\u0005\u00061F\u0001\rA\u0017\u0005\u0006CF\u0001\ra\u0019\u0005\u0006_F\u0001\r!]\u0001\u0016G2LWM\u001c;Rk>$\u0018-T3ue&\u001cg*Y7f)\u0011\tY!a\u0005\u0011\t\u00055\u0011qB\u0007\u0002}%\u0019\u0011\u0011\u0003 \u0003\u00155+GO]5d\u001d\u0006lW\rC\u0004\u0002\u0016I\u0001\r!a\u0006\u0002\u001fE,x\u000e^1NKR\u0014\u0018n\u0019+bON\u0004R\u0001ZA\rG\u000eL1!a\u0007n\u0005\ri\u0015\r]\u0001\u0015G2LWM\u001c;SCR,W*\u001a;sS\u000et\u0015-\\3\u0015\t\u0005-\u0011\u0011\u0005\u0005\b\u0003+\u0019\u0002\u0019AA\f\u0003Q\u0011XmZ5ti\u0016\u0014\u0018+^8uC6+GO]5dgR!\u0011qEA\u001d)\u0011\tI#a\f\u0011\u0007\u0019\nY#C\u0002\u0002.\u001d\u0012A!\u00168ji\"9\u0011\u0011\u0007\u000bA\u0002\u0005M\u0012AB:f]N|'\u000fE\u0002<\u0003kI1!a\u000e=\u0005\u0019\u0019VM\\:pe\"9\u00111\b\u000bA\u0002\u0005]\u0011AC7fiJL7\rV1hg\u0006Q\"/Z2pe\u0012\fe\u000eZ$fiRC'o\u001c;uY\u0016$\u0016.\\3NgRQ\u0011\u0011IA$\u0003K\nI'!\u001c\u0011\u0007\u0019\n\u0019%C\u0002\u0002F\u001d\u00121!\u00138u\u0011\u001d\tI%\u0006a\u0001\u0003\u0017\nqa]3tg&|g\u000e\u0005\u0003\u0002N\u0005}c\u0002BA(\u00033rA!!\u0015\u0002V9\u0019a-a\u0015\n\u0003}I1!a\u0016\u001f\u0003\u001dqW\r^<pe.LA!a\u0017\u0002^\u0005q!+Z9vKN$8\t[1o]\u0016d'bAA,=%!\u0011\u0011MA2\u0005\u001d\u0019Vm]:j_:TA!a\u0017\u0002^!1\u0011qM\u000bA\u0002\r\f\u0001b\u00197jK:$\u0018\n\u001a\u0005\u0007\u0003W*\u0002\u0019A\u0018\u0002\u000bY\fG.^3\t\u000b!+\u0002\u0019A\u001b\u0002#9,wo\u0015;sS\u000e$\u0018+^8uC\u001a{'\u000f\u0006\u0004\u0002t\u0005e\u00141\u0010\t\u0004E\u0005U\u0014bAA<9\t92i\u001c8ue>dG.\u001a:NkR\fG/[8o#V|G/\u0019\u0005\b\u0003\u00132\u0002\u0019AA&\u0011\u0019\t9G\u0006a\u0001GR!\u00111OA@\u0011\u001d\t\ti\u0006a\u0001\u0003\u0007\u000bqA]3rk\u0016\u001cH\u000f\u0005\u0003\u0002\u0006\u0006%e\u0002BAD\u00033j!!!\u0018\n\t\u0005-\u00151\r\u0002\b%\u0016\fX/Z:u\u0003UqWm\u001e)fe6L7o]5wKF+x\u000e^1G_J$b!a\u001d\u0002\u0012\u0006M\u0005bBA%1\u0001\u0007\u00111\n\u0005\u0007\u0003OB\u0002\u0019A2\u0015\t\u0005M\u0014q\u0013\u0005\b\u0003\u0003K\u0002\u0019AAB\u0003-qWm^)v_R\fgi\u001c:\u0015\r\u0005M\u0014QTAP\u0011\u001d\t\tI\u0007a\u0001\u0003\u0007Cq!!)\u001b\u0001\u0004\t\u0019+\u0001\ntiJL7\r^*j]\u000e,g+\u001a:tS>t\u0007c\u0001\u0014\u0002&&\u0019\u0011qU\u0014\u0003\u000bMCwN\u001d;")
public class ControllerMutationQuotaManager
extends ClientQuotaManager {
    private final ClientQuotaManagerConfig config;
    private final Metrics metrics;
    private final Time time;
    private final String threadNamePrefix;
    private final Option<ClientQuotaCallback> quotaCallback;

    public static long throttleTimeMs(QuotaViolationException quotaViolationException, long l) {
        return ControllerMutationQuotaManager$.MODULE$.throttleTimeMs(quotaViolationException, l);
    }

    public static double QuotaControllerMutationDefault() {
        return ControllerMutationQuotaManager$.MODULE$.QuotaControllerMutationDefault();
    }

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private Time time() {
        return this.time;
    }

    private String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private Option<ClientQuotaCallback> quotaCallback() {
        return this.quotaCallback;
    }

    @Override
    public MetricName clientQuotaMetricName(Map<String, String> quotaMetricTags) {
        return this.metrics().metricName("tokens", "ControllerMutation", "Tracking remaining tokens in the token bucket per user/client-id", AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, quotaMetricTags).asJava());
    }

    private MetricName clientRateMetricName(Map<String, String> quotaMetricTags) {
        return this.metrics().metricName("mutation-rate", "ControllerMutation", "Tracking mutation-rate per user/client-id", AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, quotaMetricTags).asJava());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void registerQuotaMetrics(Map<String, String> metricTags, Sensor sensor) {
        void add_stat;
        void add_metricName;
        Rate rate = new Rate();
        MetricName metricName = this.clientRateMetricName(metricTags);
        if (sensor == null) {
            throw null;
        }
        sensor.add((MetricName)add_metricName, (MeasurableStat)add_stat, null);
        metricName = null;
        rate = null;
        sensor.add(this.clientQuotaMetricName(metricTags), (MeasurableStat)new TokenBucket(), this.getQuotaMetricConfig(metricTags));
    }

    @Override
    public int recordAndGetThrottleTimeMs(RequestChannel.Session session, String clientId, double value, long timeMs) {
        Sensor quotaSensor = this.getOrCreateQuotaSensors(session, clientId).quotaSensor();
        try {
            synchronized (quotaSensor) {
                quotaSensor.checkQuotas(timeMs);
                quotaSensor.record(value, timeMs, false);
            }
            return 0;
        }
        catch (QuotaViolationException e) {
            int throttleTimeMs = (int)ControllerMutationQuotaManager$.MODULE$.throttleTimeMs(e, timeMs);
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Quota violated for sensor (").append(quotaSensor.name()).append("). Delay time: (").append(throttleTimeMs).append(")").toString());
            return throttleTimeMs;
        }
    }

    public ControllerMutationQuota newStrictQuotaFor(RequestChannel.Session session, String clientId) {
        if (this.quotasEnabled()) {
            ClientSensors clientSensors = this.getOrCreateQuotaSensors(session, clientId);
            return new StrictControllerMutationQuota(this.time(), clientSensors.quotaSensor());
        }
        return UnboundedControllerMutationQuota$.MODULE$;
    }

    public ControllerMutationQuota newStrictQuotaFor(RequestChannel.Request request) {
        return this.newStrictQuotaFor(request.session(), request.header().clientId());
    }

    public ControllerMutationQuota newPermissiveQuotaFor(RequestChannel.Session session, String clientId) {
        if (this.quotasEnabled()) {
            ClientSensors clientSensors = this.getOrCreateQuotaSensors(session, clientId);
            return new PermissiveControllerMutationQuota(this.time(), clientSensors.quotaSensor());
        }
        return UnboundedControllerMutationQuota$.MODULE$;
    }

    public ControllerMutationQuota newPermissiveQuotaFor(RequestChannel.Request request) {
        return this.newPermissiveQuotaFor(request.session(), request.header().clientId());
    }

    public ControllerMutationQuota newQuotaFor(RequestChannel.Request request, short strictSinceVersion) {
        if (request.header().apiVersion() >= strictSinceVersion) {
            return this.newStrictQuotaFor(request);
        }
        return this.newPermissiveQuotaFor(request);
    }

    public ControllerMutationQuotaManager(ClientQuotaManagerConfig config, Metrics metrics, Time time, String threadNamePrefix, Option<ClientQuotaCallback> quotaCallback) {
        this.config = config;
        this.metrics = metrics;
        this.time = time;
        this.threadNamePrefix = threadNamePrefix;
        this.quotaCallback = quotaCallback;
        super(config, metrics, QuotaType$ControllerMutation$.MODULE$, time, threadNamePrefix, quotaCallback);
    }
}

