/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kafka.server.CachedPartition;
import kafka.server.FetchContext;
import kafka.server.FetchManager;
import kafka.server.FetchSession;
import kafka.server.FetchSessionCache;
import kafka.server.FullFetchContext;
import kafka.server.IncrementalFetchContext;
import kafka.server.SessionErrorContext;
import kafka.server.SessionlessFetchContext;
import kafka.utils.MockTime;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableFactory;
import scala.collection.Iterator;
import scala.collection.MapFactory;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.MapBuilderImpl;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Builder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005}4AAE\n\u00011!)q\u0004\u0001C\u0001A!)1\u0005\u0001C\u0001I!)A\u0007\u0001C\u0001k!)Q\b\u0001C\u0001}!)A\n\u0001C\u0005\u001b\")q\u000b\u0001C\u0001k!)\u0011\f\u0001C\u0001k!91\f\u0001b\u0001\n\u0003a\u0006B\u00028\u0001A\u0003%Q\fC\u0003p\u0001\u0011\u0005Q\u0007C\u0003r\u0001\u0011\u0005Q\u0007C\u0003t\u0001\u0011\u0005Q\u0007C\u0003v\u0001\u0011\u0005Q\u0007C\u0003x\u0001\u0011\u0005Q\u0007C\u0003z\u0001\u0011\u0005Q\u0007C\u0003|\u0001\u0011\u0005Q\u0007C\u0003~\u0001\u0011\u0005QG\u0001\tGKR\u001c\u0007nU3tg&|g\u000eV3ti*\u0011A#F\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003Y\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u00013A\u0011!$H\u0007\u00027)\tA$A\u0003tG\u0006d\u0017-\u0003\u0002\u001f7\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u0011\u0011\u0005\t\u0002Q\"A\n\u0002\u001b\u001ddwNY1m)&lWm\\;u+\u0005)\u0003C\u0001\u0014.\u001b\u00059#B\u0001\u0015*\u0003\u0015\u0011X\u000f\\3t\u0015\tQ3&A\u0003kk:LGOC\u0001-\u0003\ry'oZ\u0005\u0003]\u001d\u0012q\u0001V5nK>,H\u000f\u000b\u0002\u0003aA\u0011\u0011GM\u0007\u0002S%\u00111'\u000b\u0002\u0005%VdW-\u0001\tuKN$h*Z<TKN\u001c\u0018n\u001c8JIR\ta\u0007\u0005\u0002\u001bo%\u0011\u0001h\u0007\u0002\u0005+:LG\u000f\u000b\u0002\u0004uA\u0011\u0011gO\u0005\u0003y%\u0012A\u0001V3ti\u0006\u0019\u0012m]:feR\u001c\u0015m\u00195f\u0007>tG/Y5ogR\u0019ag\u0010#\t\u000b\u0001#\u0001\u0019A!\u0002\u000b\r\f7\r[3\u0011\u0005\t\u0012\u0015BA\"\u0014\u0005E1U\r^2i'\u0016\u001c8/[8o\u0007\u0006\u001c\u0007.\u001a\u0005\u0006\u000b\u0012\u0001\rAR\u0001\u000bg\u0016\u001c8/[8o\u0013\u0012\u001c\bc\u0001\u000eH\u0013&\u0011\u0001j\u0007\u0002\u000byI,\u0007/Z1uK\u0012t\u0004C\u0001\u000eK\u0013\tY5DA\u0002J]R\f1\u0002Z;n[f\u001c%/Z1uKR\u0011a*\u0016\t\u0003\u001fJs!A\t)\n\u0005E\u001b\u0012\u0001\u0004$fi\u000eD7+Z:tS>t\u0017BA*U\u0005%\u0019\u0015i\u0011%F?6\u000b\u0005K\u0003\u0002R'!)a+\u0002a\u0001\u0013\u0006!1/\u001b>f\u0003A!Xm\u001d;TKN\u001c\u0018n\u001c8DC\u000eDW\r\u000b\u0002\u0007u\u0005AB/Z:u%\u0016\u001c\u0018N_3DC\u000eDW\rZ*fgNLwN\\:)\u0005\u001dQ\u0014aD#N!RKv\fU!S)~c\u0015j\u0015+\u0016\u0003u\u00032AX2f\u001b\u0005y&B\u00011b\u0003\u0011)H/\u001b7\u000b\u0003\t\fAA[1wC&\u0011Am\u0018\u0002\u0005\u0019&\u001cH\u000f\u0005\u0002gY6\tqM\u0003\u0002iS\u000611m\\7n_:T!A\u00066\u000b\u0005-\\\u0013AB1qC\u000eDW-\u0003\u0002nO\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017\u0001E#N!RKv\fU!S)~c\u0015j\u0015+!\u0003U!Xm\u001d;DC\u000eDW\r\u001a'fC\u0012,'/\u00129pG\"D#A\u0003\u001e\u0002)Q,7\u000f\u001e'bgR4U\r^2iK\u0012,\u0005o\\2iQ\tY!(A\tuKN$h)\u001a;dQJ+\u0017/^3tiND#\u0001\u0004\u001e\u00027Q,7\u000f^%oGJ,W.\u001a8uC24U\r^2i'\u0016\u001c8/[8oQ\ti!(\u0001\u000euKN$h)\u001a;dQN+7o]5p]\u0016C\b/\u001b:bi&|g\u000e\u000b\u0002\u000fu\u0005iB/Z:u!JLg/\u001b7fO\u0016$7+Z:tS>t\u0007*\u00198eY&tw\r\u000b\u0002\u0010u\u0005AB/Z:u5\u0016\u0014xnU5{K\u001a+Go\u00195TKN\u001c\u0018n\u001c8)\u0005AQ\u0014A\u0005;fgR$\u0015N^3sO&tw-\u00129pG\"D#!\u0005\u001e")
public class FetchSessionTest {
    private final List<TopicPartition> EMPTY_PART_LIST = Collections.unmodifiableList(new ArrayList());

    @Rule
    public Timeout globalTimeout() {
        return Timeout.millis((long)120000L);
    }

    @Test
    public void testNewSessionId() {
        FetchSessionCache cache = new FetchSessionCache(3, 100L);
        int n = 0;
        int to$extension_end = 10000;
        Range.Inclusive foreach$mVc$sp_this = new Range.Inclusive(n, to$extension_end, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                FetchSessionTest.$anonfun$testNewSessionId$1(cache, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
    }

    public void assertCacheContains(FetchSessionCache cache, Seq<Object> sessionIds) {
        IntRef intRef;
        int create_e = 0;
        IntRef intRef2 = intRef = new IntRef(create_e);
        intRef = null;
        IntRef i = intRef2;
        sessionIds.foreach((Function1)(JFunction1.mcVI.sp & Serializable)sessionId -> {
            ++i$1.elem;
            if (sessionIds == null) {
                throw null;
            }
            Assert.assertTrue((String)new StringBuilder(26).append("Missing session ").append(i$1.elem).append(" out of ").append(sessionIds.length()).append("(").append(sessionId).append(")").toString(), (boolean)cache.get(sessionId).isDefined());
        });
        Assert.assertEquals((long)sessionIds.length(), (long)cache.size());
    }

    /*
     * WARNING - void declaration
     */
    private ImplicitLinkedHashCollection<CachedPartition> dummyCreate(int size) {
        void var2_2;
        ImplicitLinkedHashCollection cacheMap = new ImplicitLinkedHashCollection(size);
        int n = 0;
        Range.Exclusive foreach_this = new Range.Exclusive(n, size, 1);
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                cacheMap.add((ImplicitLinkedHashCollection.Element)new CachedPartition("test", foreach_i));
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement) break;
                foreach_i += foreach_this.step();
            }
        }
        return var2_2;
    }

    @Test
    public void testSessionCache() {
        FetchSessionCache cache = new FetchSessionCache(3, 100L);
        Assert.assertEquals((long)0L, (long)cache.size());
        int id1 = cache.maybeCreateSession(0L, false, 10, (Function0 & Serializable)() -> this.dummyCreate(10));
        int id2 = cache.maybeCreateSession(10L, false, 20, (Function0 & Serializable)() -> this.dummyCreate(20));
        int id3 = cache.maybeCreateSession(20L, false, 30, (Function0 & Serializable)() -> this.dummyCreate(30));
        Assert.assertEquals((long)0L, (long)cache.maybeCreateSession(30L, false, 40, (Function0 & Serializable)() -> this.dummyCreate(40)));
        Assert.assertEquals((long)0L, (long)cache.maybeCreateSession(40L, false, 5, (Function0 & Serializable)() -> this.dummyCreate(5)));
        this.assertCacheContains(cache, (Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{id1, id2, id3}));
        cache.touch((FetchSession)cache.get(id1).get(), 200L);
        int id4 = cache.maybeCreateSession(210L, false, 11, (Function0 & Serializable)() -> this.dummyCreate(11));
        this.assertCacheContains(cache, (Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{id1, id3, id4}));
        cache.touch((FetchSession)cache.get(id1).get(), 400L);
        cache.touch((FetchSession)cache.get(id3).get(), 390L);
        cache.touch((FetchSession)cache.get(id4).get(), 400L);
        int id5 = cache.maybeCreateSession(410L, false, 50, (Function0 & Serializable)() -> this.dummyCreate(50));
        this.assertCacheContains(cache, (Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{id3, id4, id5}));
        Assert.assertEquals((long)0L, (long)cache.maybeCreateSession(410L, false, 5, (Function0 & Serializable)() -> this.dummyCreate(5)));
        int id6 = cache.maybeCreateSession(410L, true, 5, (Function0 & Serializable)() -> this.dummyCreate(5));
        this.assertCacheContains(cache, (Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{id3, id5, id6}));
    }

    @Test
    public void testResizeCachedSessions() {
        FetchSessionCache cache = new FetchSessionCache(2, 100L);
        Assert.assertEquals((long)0L, (long)cache.totalPartitions());
        Assert.assertEquals((long)0L, (long)cache.size());
        Assert.assertEquals((long)0L, (long)cache.evictionsMeter().count());
        int id1 = cache.maybeCreateSession(0L, false, 2, (Function0 & Serializable)() -> this.dummyCreate(2));
        Assert.assertTrue((id1 > 0 ? 1 : 0) != 0);
        this.assertCacheContains(cache, (Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{id1}));
        FetchSession session1 = (FetchSession)cache.get(id1).get();
        Assert.assertEquals((long)2L, (long)session1.size());
        Assert.assertEquals((long)2L, (long)cache.totalPartitions());
        Assert.assertEquals((long)1L, (long)cache.size());
        Assert.assertEquals((long)0L, (long)cache.evictionsMeter().count());
        int id2 = cache.maybeCreateSession(0L, false, 4, (Function0 & Serializable)() -> this.dummyCreate(4));
        FetchSession session2 = (FetchSession)cache.get(id2).get();
        Assert.assertTrue((id2 > 0 ? 1 : 0) != 0);
        this.assertCacheContains(cache, (Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{id1, id2}));
        Assert.assertEquals((long)6L, (long)cache.totalPartitions());
        Assert.assertEquals((long)2L, (long)cache.size());
        Assert.assertEquals((long)0L, (long)cache.evictionsMeter().count());
        cache.touch(session1, 200L);
        cache.touch(session2, 200L);
        int id3 = cache.maybeCreateSession(200L, false, 5, (Function0 & Serializable)() -> this.dummyCreate(5));
        Assert.assertTrue((id3 > 0 ? 1 : 0) != 0);
        this.assertCacheContains(cache, (Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{id2, id3}));
        Assert.assertEquals((long)9L, (long)cache.totalPartitions());
        Assert.assertEquals((long)2L, (long)cache.size());
        Assert.assertEquals((long)1L, (long)cache.evictionsMeter().count());
        cache.remove(id3);
        this.assertCacheContains(cache, (Seq<Object>)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{id2}));
        Assert.assertEquals((long)1L, (long)cache.size());
        Assert.assertEquals((long)1L, (long)cache.evictionsMeter().count());
        Assert.assertEquals((long)4L, (long)cache.totalPartitions());
        java.util.Iterator iter = session2.partitionMap().iterator();
        iter.next();
        iter.remove();
        Assert.assertEquals((long)3L, (long)session2.size());
        Assert.assertEquals((long)4L, (long)session2.cachedSize());
        cache.touch(session2, session2.lastUsedMs());
        Assert.assertEquals((long)3L, (long)cache.totalPartitions());
    }

    public List<TopicPartition> EMPTY_PART_LIST() {
        return this.EMPTY_PART_LIST;
    }

    @Test
    public void testCachedLeaderEpoch() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        TopicPartition tp0 = new TopicPartition("foo", 0);
        TopicPartition tp1 = new TopicPartition("foo", 1);
        TopicPartition tp2 = new TopicPartition("bar", 1);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> request1 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        request1.put(tp0, new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
        request1.put(tp1, new FetchRequest.PartitionData(10L, 0L, 100, Optional.of(1)));
        request1.put(tp2, new FetchRequest.PartitionData(10L, 0L, 100, Optional.of(2)));
        FetchContext context1 = fetchManager.newContext(FetchMetadata.INITIAL, request1, this.EMPTY_PART_LIST(), false);
        Map epochs1 = FetchSessionTest.cachedLeaderEpochs$1(context1);
        Assert.assertEquals(Optional.empty(), (Object)epochs1.apply((Object)tp0));
        Assert.assertEquals(Optional.of(1), (Object)epochs1.apply((Object)tp1));
        Assert.assertEquals(Optional.of(2), (Object)epochs1.apply((Object)tp2));
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> response = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        response.put(tp0, new FetchResponse.PartitionData(Errors.NONE, 100L, 100L, 100L, null, null));
        response.put(tp1, new FetchResponse.PartitionData(Errors.NONE, 10L, 10L, 10L, null, null));
        response.put(tp2, new FetchResponse.PartitionData(Errors.NONE, 5L, 5L, 5L, null, null));
        int sessionId = context1.updateAndGenerateResponseData(response).sessionId();
        LinkedHashMap request2 = new LinkedHashMap();
        FetchContext context2 = fetchManager.newContext(new FetchMetadata(sessionId, 1), request2, this.EMPTY_PART_LIST(), false);
        Map epochs2 = FetchSessionTest.cachedLeaderEpochs$1(context2);
        Assert.assertEquals(Optional.empty(), (Object)epochs1.apply((Object)tp0));
        Assert.assertEquals(Optional.of(1), (Object)epochs2.apply((Object)tp1));
        Assert.assertEquals(Optional.of(2), (Object)epochs2.apply((Object)tp2));
        context2.updateAndGenerateResponseData(response).sessionId();
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> request3 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        request3.put(tp0, new FetchRequest.PartitionData(0L, 0L, 100, Optional.of(6)));
        request3.put(tp1, new FetchRequest.PartitionData(10L, 0L, 100, Optional.empty()));
        request3.put(tp2, new FetchRequest.PartitionData(10L, 0L, 100, Optional.of(3)));
        Map epochs3 = FetchSessionTest.cachedLeaderEpochs$1(fetchManager.newContext(new FetchMetadata(sessionId, 2), request3, this.EMPTY_PART_LIST(), false));
        Assert.assertEquals(Optional.of(6), (Object)epochs3.apply((Object)tp0));
        Assert.assertEquals(Optional.empty(), (Object)epochs3.apply((Object)tp1));
        Assert.assertEquals(Optional.of(3), (Object)epochs3.apply((Object)tp2));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLastFetchedEpoch() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        void apply_elems4;
        void apply_elems5;
        void apply_elems6;
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        TopicPartition tp0 = new TopicPartition("foo", 0);
        TopicPartition tp1 = new TopicPartition("foo", 1);
        TopicPartition tp2 = new TopicPartition("bar", 1);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> request1 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        request1.put(tp0, new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty(), Optional.empty()));
        request1.put(tp1, new FetchRequest.PartitionData(10L, 0L, 100, Optional.of(1), Optional.empty()));
        request1.put(tp2, new FetchRequest.PartitionData(10L, 0L, 100, Optional.of(2), Optional.of(1)));
        FetchContext context1 = fetchManager.newContext(FetchMetadata.INITIAL, request1, this.EMPTY_PART_LIST(), false);
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[3];
        Optional $minus$greater$extension_y = Optional.empty();
        Object var15_9 = null;
        objectArray[0] = new Tuple2((Object)tp0, $minus$greater$extension_y);
        Optional<Integer> $minus$greater$extension_y2 = Optional.of(1);
        Object var16_10 = null;
        objectArray[1] = new Tuple2((Object)tp1, $minus$greater$extension_y2);
        Optional<Integer> $minus$greater$extension_y3 = Optional.of(2);
        Object var17_11 = null;
        objectArray[2] = new Tuple2((Object)tp2, $minus$greater$extension_y3);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        Assert.assertEquals((Object)MapFactory.apply$((MapFactory)map$, (Seq)apply_elems6), (Object)FetchSessionTest.cachedLeaderEpochs$2(context1));
        Map$ map$2 = Predef$.MODULE$.Map();
        Object[] objectArray2 = new Tuple2[3];
        Optional $minus$greater$extension_y4 = Optional.empty();
        Object var18_13 = null;
        objectArray2[0] = new Tuple2((Object)tp0, $minus$greater$extension_y4);
        Optional $minus$greater$extension_y5 = Optional.empty();
        Object var19_14 = null;
        objectArray2[1] = new Tuple2((Object)tp1, $minus$greater$extension_y5);
        Optional<Integer> $minus$greater$extension_y6 = Optional.of(1);
        Object var20_15 = null;
        objectArray2[2] = new Tuple2((Object)tp2, $minus$greater$extension_y6);
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray2);
        if (map$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        Assert.assertEquals((Object)MapFactory.apply$((MapFactory)map$2, (Seq)apply_elems5), (Object)FetchSessionTest.cachedLastFetchedEpochs$1(context1));
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> response = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        response.put(tp0, new FetchResponse.PartitionData(Errors.NONE, 100L, 100L, 100L, null, null));
        response.put(tp1, new FetchResponse.PartitionData(Errors.NONE, 10L, 10L, 10L, null, null));
        response.put(tp2, new FetchResponse.PartitionData(Errors.NONE, 5L, 5L, 5L, null, null));
        int sessionId = context1.updateAndGenerateResponseData(response).sessionId();
        LinkedHashMap request2 = new LinkedHashMap();
        FetchContext context2 = fetchManager.newContext(new FetchMetadata(sessionId, 1), request2, this.EMPTY_PART_LIST(), false);
        Map$ map$3 = Predef$.MODULE$.Map();
        Object[] objectArray3 = new Tuple2[3];
        Optional $minus$greater$extension_y7 = Optional.empty();
        Object var21_21 = null;
        objectArray3[0] = new Tuple2((Object)tp0, $minus$greater$extension_y7);
        Optional<Integer> $minus$greater$extension_y8 = Optional.of(1);
        Object var22_22 = null;
        objectArray3[1] = new Tuple2((Object)tp1, $minus$greater$extension_y8);
        Optional<Integer> $minus$greater$extension_y9 = Optional.of(2);
        Object var23_23 = null;
        objectArray3[2] = new Tuple2((Object)tp2, $minus$greater$extension_y9);
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray3);
        if (map$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        Assert.assertEquals((Object)MapFactory.apply$((MapFactory)map$3, (Seq)apply_elems4), (Object)FetchSessionTest.cachedLeaderEpochs$2(context2));
        Map$ map$4 = Predef$.MODULE$.Map();
        Object[] objectArray4 = new Tuple2[3];
        Optional $minus$greater$extension_y10 = Optional.empty();
        Object var24_25 = null;
        objectArray4[0] = new Tuple2((Object)tp0, $minus$greater$extension_y10);
        Optional $minus$greater$extension_y11 = Optional.empty();
        Object var25_26 = null;
        objectArray4[1] = new Tuple2((Object)tp1, $minus$greater$extension_y11);
        Optional<Integer> $minus$greater$extension_y12 = Optional.of(1);
        Object var26_27 = null;
        objectArray4[2] = new Tuple2((Object)tp2, $minus$greater$extension_y12);
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray4);
        if (map$4 == null) {
            throw null;
        }
        arraySeq4 = null;
        Assert.assertEquals((Object)MapFactory.apply$((MapFactory)map$4, (Seq)apply_elems3), (Object)FetchSessionTest.cachedLastFetchedEpochs$1(context2));
        context2.updateAndGenerateResponseData(response).sessionId();
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> request3 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        request3.put(tp0, new FetchRequest.PartitionData(0L, 0L, 100, Optional.of(6), Optional.of(5)));
        request3.put(tp1, new FetchRequest.PartitionData(10L, 0L, 100, Optional.empty(), Optional.empty()));
        request3.put(tp2, new FetchRequest.PartitionData(10L, 0L, 100, Optional.of(3), Optional.of(3)));
        FetchContext context3 = fetchManager.newContext(new FetchMetadata(sessionId, 2), request3, this.EMPTY_PART_LIST(), false);
        Map$ map$5 = Predef$.MODULE$.Map();
        Object[] objectArray5 = new Tuple2[3];
        Optional<Integer> $minus$greater$extension_y13 = Optional.of(6);
        Object var27_31 = null;
        objectArray5[0] = new Tuple2((Object)tp0, $minus$greater$extension_y13);
        Optional $minus$greater$extension_y14 = Optional.empty();
        Object var28_32 = null;
        objectArray5[1] = new Tuple2((Object)tp1, $minus$greater$extension_y14);
        Optional<Integer> $minus$greater$extension_y15 = Optional.of(3);
        Object var29_33 = null;
        objectArray5[2] = new Tuple2((Object)tp2, $minus$greater$extension_y15);
        ArraySeq arraySeq5 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray5);
        if (map$5 == null) {
            throw null;
        }
        arraySeq5 = null;
        Assert.assertEquals((Object)MapFactory.apply$((MapFactory)map$5, (Seq)apply_elems2), (Object)FetchSessionTest.cachedLeaderEpochs$2(context3));
        Map$ map$6 = Predef$.MODULE$.Map();
        Object[] objectArray6 = new Tuple2[3];
        Optional<Integer> $minus$greater$extension_y16 = Optional.of(5);
        Object var30_35 = null;
        objectArray6[0] = new Tuple2((Object)tp0, $minus$greater$extension_y16);
        Optional $minus$greater$extension_y17 = Optional.empty();
        Object var31_36 = null;
        objectArray6[1] = new Tuple2((Object)tp1, $minus$greater$extension_y17);
        Optional<Integer> $minus$greater$extension_y18 = Optional.of(3);
        Object var32_37 = null;
        objectArray6[2] = new Tuple2((Object)tp2, $minus$greater$extension_y18);
        ArraySeq arraySeq6 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray6);
        if (map$6 == null) {
            throw null;
        }
        arraySeq6 = null;
        Assert.assertEquals((Object)MapFactory.apply$((MapFactory)map$6, (Seq)apply_elems), (Object)FetchSessionTest.cachedLastFetchedEpochs$1(context2));
    }

    @Test
    public void testFetchRequests() {
        FetchResponse resp8;
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        FetchContext context = fetchManager.newContext(FetchMetadata.LEGACY, new HashMap(), this.EMPTY_PART_LIST(), true);
        Assert.assertEquals(SessionlessFetchContext.class, context.getClass());
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData2 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        reqData2.put(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
        reqData2.put(new TopicPartition("foo", 1), new FetchRequest.PartitionData(10L, 0L, 100, Optional.empty()));
        FetchContext context2 = fetchManager.newContext(FetchMetadata.INITIAL, reqData2, this.EMPTY_PART_LIST(), false);
        Assert.assertEquals(FullFetchContext.class, context2.getClass());
        java.util.Iterator reqData2Iter = reqData2.entrySet().iterator();
        context2.foreachPartition((Function2 & Serializable)(topicPart, data) -> {
            FetchSessionTest.$anonfun$testFetchRequests$1(reqData2Iter, topicPart, data);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)0L, (long)BoxesRunTime.unboxToLong((Object)context2.getFetchOffset(new TopicPartition("foo", 0)).get()));
        Assert.assertEquals((long)10L, (long)BoxesRunTime.unboxToLong((Object)context2.getFetchOffset(new TopicPartition("foo", 1)).get()));
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> respData2 = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        respData2.put(new TopicPartition("foo", 0), new FetchResponse.PartitionData(Errors.NONE, 100L, 100L, 100L, null, null));
        respData2.put(new TopicPartition("foo", 1), new FetchResponse.PartitionData(Errors.NONE, 10L, 10L, 10L, null, null));
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData2);
        Assert.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assert.assertTrue((resp2.sessionId() != 0 ? 1 : 0) != 0);
        Assert.assertEquals(respData2, (Object)resp2.responseData());
        FetchContext context3 = fetchManager.newContext(new FetchMetadata(resp2.sessionId(), 5), reqData2, this.EMPTY_PART_LIST(), false);
        Assert.assertEquals(SessionErrorContext.class, context3.getClass());
        Assert.assertEquals((Object)Errors.INVALID_FETCH_SESSION_EPOCH, (Object)context3.updateAndGenerateResponseData(respData2).error());
        FetchContext context4 = fetchManager.newContext(new FetchMetadata(resp2.sessionId() + 1, 1), reqData2, this.EMPTY_PART_LIST(), false);
        Assert.assertEquals(SessionErrorContext.class, context4.getClass());
        Assert.assertEquals((Object)Errors.FETCH_SESSION_ID_NOT_FOUND, (Object)context4.updateAndGenerateResponseData(respData2).error());
        LinkedHashMap reqData5 = new LinkedHashMap();
        FetchContext context5 = fetchManager.newContext(new FetchMetadata(resp2.sessionId(), 1), reqData5, this.EMPTY_PART_LIST(), false);
        Assert.assertEquals(IncrementalFetchContext.class, context5.getClass());
        java.util.Iterator reqData5Iter = reqData2.entrySet().iterator();
        context5.foreachPartition((Function2 & Serializable)(topicPart, data) -> {
            FetchSessionTest.$anonfun$testFetchRequests$2(reqData5Iter, topicPart, data);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)10L, (long)BoxesRunTime.unboxToLong((Object)context5.getFetchOffset(new TopicPartition("foo", 1)).get()));
        FetchResponse resp5 = context5.updateAndGenerateResponseData(respData2);
        Assert.assertEquals((Object)Errors.NONE, (Object)resp5.error());
        Assert.assertEquals((long)resp2.sessionId(), (long)resp5.sessionId());
        Assert.assertEquals((long)0L, (long)resp5.responseData().size());
        FetchContext context6 = fetchManager.newContext(new FetchMetadata(resp2.sessionId(), 5), reqData2, this.EMPTY_PART_LIST(), false);
        Assert.assertEquals(SessionErrorContext.class, context6.getClass());
        Assert.assertEquals((Object)Errors.INVALID_FETCH_SESSION_EPOCH, (Object)context6.updateAndGenerateResponseData(respData2).error());
        LinkedHashMap reqData7 = new LinkedHashMap();
        FetchResponse resp7 = fetchManager.newContext(new FetchMetadata(resp2.sessionId(), 2), reqData7, this.EMPTY_PART_LIST(), false).getThrottledResponse(100);
        Assert.assertEquals((Object)Errors.NONE, (Object)resp7.error());
        Assert.assertEquals((long)resp2.sessionId(), (long)resp7.sessionId());
        Assert.assertEquals((long)100L, (long)resp7.throttleTimeMs());
        int prevSessionId = resp5.sessionId();
        do {
            LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData8 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
            reqData8.put(new TopicPartition("bar", 0), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
            reqData8.put(new TopicPartition("bar", 1), new FetchRequest.PartitionData(10L, 0L, 100, Optional.empty()));
            FetchContext context8 = fetchManager.newContext(new FetchMetadata(prevSessionId, -1), reqData8, this.EMPTY_PART_LIST(), false);
            Assert.assertEquals(SessionlessFetchContext.class, context8.getClass());
            Assert.assertEquals((long)0L, (long)cache.size());
            LinkedHashMap<TopicPartition, FetchResponse.PartitionData> respData8 = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
            respData8.put(new TopicPartition("bar", 0), new FetchResponse.PartitionData(Errors.NONE, 100L, 100L, 100L, null, null));
            respData8.put(new TopicPartition("bar", 1), new FetchResponse.PartitionData(Errors.NONE, 100L, 100L, 100L, null, null));
            resp8 = context8.updateAndGenerateResponseData(respData8);
            Assert.assertEquals((Object)Errors.NONE, (Object)resp8.error());
        } while (resp8.sessionId() == prevSessionId);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testIncrementalFetchSession() {
        void apply_elems;
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData1 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        reqData1.put(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
        reqData1.put(new TopicPartition("foo", 1), new FetchRequest.PartitionData(10L, 0L, 100, Optional.empty()));
        FetchContext context1 = fetchManager.newContext(FetchMetadata.INITIAL, reqData1, this.EMPTY_PART_LIST(), false);
        Assert.assertEquals(FullFetchContext.class, context1.getClass());
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> respData1 = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        respData1.put(new TopicPartition("foo", 0), new FetchResponse.PartitionData(Errors.NONE, 100L, 100L, 100L, null, null));
        respData1.put(new TopicPartition("foo", 1), new FetchResponse.PartitionData(Errors.NONE, 10L, 10L, 10L, null, null));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData1);
        Assert.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assert.assertTrue((resp1.sessionId() != 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)resp1.responseData().size());
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData2 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        reqData2.put(new TopicPartition("bar", 0), new FetchRequest.PartitionData(15L, 0L, 0, Optional.empty()));
        ArrayList<TopicPartition> removed2 = new ArrayList<TopicPartition>();
        removed2.add(new TopicPartition("foo", 0));
        FetchContext context2 = fetchManager.newContext(new FetchMetadata(resp1.sessionId(), 1), reqData2, removed2, false);
        Assert.assertEquals(IncrementalFetchContext.class, context2.getClass());
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("foo", 1), new TopicPartition("bar", 0)});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Iterator reqData2Iter = ((Set)IterableFactory.apply$((IterableFactory)set$, (Seq)apply_elems)).iterator();
        context2.foreachPartition((Function2 & Serializable)(topicPart, data) -> {
            FetchSessionTest.$anonfun$testIncrementalFetchSession$1(reqData2Iter, topicPart, data);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)None$.MODULE$, (Object)context2.getFetchOffset(new TopicPartition("foo", 0)));
        Assert.assertEquals((long)10L, (long)BoxesRunTime.unboxToLong((Object)context2.getFetchOffset(new TopicPartition("foo", 1)).get()));
        Assert.assertEquals((long)15L, (long)BoxesRunTime.unboxToLong((Object)context2.getFetchOffset(new TopicPartition("bar", 0)).get()));
        Assert.assertEquals((Object)None$.MODULE$, (Object)context2.getFetchOffset(new TopicPartition("bar", 2)));
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> respData2 = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        respData2.put(new TopicPartition("foo", 1), new FetchResponse.PartitionData(Errors.NONE, 10L, 10L, 10L, null, null));
        respData2.put(new TopicPartition("bar", 0), new FetchResponse.PartitionData(Errors.NONE, 10L, 10L, 10L, null, null));
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData2);
        Assert.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assert.assertEquals((long)1L, (long)resp2.responseData().size());
        Assert.assertTrue((resp2.sessionId() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testFetchSessionExpiration() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(2, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> session1req = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        session1req.put(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
        session1req.put(new TopicPartition("foo", 1), new FetchRequest.PartitionData(10L, 0L, 100, Optional.empty()));
        FetchContext session1context1 = fetchManager.newContext(FetchMetadata.INITIAL, session1req, this.EMPTY_PART_LIST(), false);
        Assert.assertEquals(FullFetchContext.class, session1context1.getClass());
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> respData1 = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        respData1.put(new TopicPartition("foo", 0), new FetchResponse.PartitionData(Errors.NONE, 100L, 100L, 100L, null, null));
        respData1.put(new TopicPartition("foo", 1), new FetchResponse.PartitionData(Errors.NONE, 10L, 10L, 10L, null, null));
        FetchResponse session1resp = session1context1.updateAndGenerateResponseData(respData1);
        Assert.assertEquals((Object)Errors.NONE, (Object)session1resp.error());
        Assert.assertTrue((session1resp.sessionId() != 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)session1resp.responseData().size());
        Assert.assertTrue((boolean)cache.get(session1resp.sessionId()).isDefined());
        time.sleep(500L);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> session2req = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        session2req.put(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
        session2req.put(new TopicPartition("foo", 1), new FetchRequest.PartitionData(10L, 0L, 100, Optional.empty()));
        FetchContext session2context = fetchManager.newContext(FetchMetadata.INITIAL, session1req, this.EMPTY_PART_LIST(), false);
        Assert.assertEquals(FullFetchContext.class, session2context.getClass());
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> session2RespData = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        session2RespData.put(new TopicPartition("foo", 0), new FetchResponse.PartitionData(Errors.NONE, 100L, 100L, 100L, null, null));
        session2RespData.put(new TopicPartition("foo", 1), new FetchResponse.PartitionData(Errors.NONE, 10L, 10L, 10L, null, null));
        FetchResponse session2resp = session2context.updateAndGenerateResponseData(respData1);
        Assert.assertEquals((Object)Errors.NONE, (Object)session2resp.error());
        Assert.assertTrue((session2resp.sessionId() != 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)session2resp.responseData().size());
        Assert.assertTrue((boolean)cache.get(session1resp.sessionId()).isDefined());
        Assert.assertTrue((boolean)cache.get(session2resp.sessionId()).isDefined());
        time.sleep(500L);
        FetchContext context1v2 = fetchManager.newContext(new FetchMetadata(session1resp.sessionId(), 1), new LinkedHashMap(), new ArrayList(), false);
        Assert.assertEquals(IncrementalFetchContext.class, context1v2.getClass());
        time.sleep(501L);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> session3req = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        session3req.put(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
        session3req.put(new TopicPartition("foo", 1), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
        FetchContext session3context = fetchManager.newContext(FetchMetadata.INITIAL, session3req, this.EMPTY_PART_LIST(), false);
        Assert.assertEquals(FullFetchContext.class, session3context.getClass());
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> respData3 = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        respData3.put(new TopicPartition("foo", 0), new FetchResponse.PartitionData(Errors.NONE, 100L, 100L, 100L, null, null));
        respData3.put(new TopicPartition("foo", 1), new FetchResponse.PartitionData(Errors.NONE, 10L, 10L, 10L, null, null));
        FetchResponse session3resp = session3context.updateAndGenerateResponseData(respData3);
        Assert.assertEquals((Object)Errors.NONE, (Object)session3resp.error());
        Assert.assertTrue((session3resp.sessionId() != 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)session3resp.responseData().size());
        Assert.assertTrue((boolean)cache.get(session1resp.sessionId()).isDefined());
        Assert.assertFalse((String)"session 2 should have been evicted by latest session, as session 1 was used more recently", (boolean)cache.get(session2resp.sessionId()).isDefined());
        Assert.assertTrue((boolean)cache.get(session3resp.sessionId()).isDefined());
    }

    @Test
    public void testPrivilegedSessionHandling() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(2, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> session1req = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        session1req.put(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
        session1req.put(new TopicPartition("foo", 1), new FetchRequest.PartitionData(10L, 0L, 100, Optional.empty()));
        FetchContext session1context = fetchManager.newContext(FetchMetadata.INITIAL, session1req, this.EMPTY_PART_LIST(), true);
        Assert.assertEquals(FullFetchContext.class, session1context.getClass());
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> respData1 = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        respData1.put(new TopicPartition("foo", 0), new FetchResponse.PartitionData(Errors.NONE, 100L, 100L, 100L, null, null));
        respData1.put(new TopicPartition("foo", 1), new FetchResponse.PartitionData(Errors.NONE, 10L, 10L, 10L, null, null));
        FetchResponse session1resp = session1context.updateAndGenerateResponseData(respData1);
        Assert.assertEquals((Object)Errors.NONE, (Object)session1resp.error());
        Assert.assertTrue((session1resp.sessionId() != 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)session1resp.responseData().size());
        Assert.assertEquals((long)1L, (long)cache.size());
        time.sleep(500L);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> session2req = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        session2req.put(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
        session2req.put(new TopicPartition("foo", 1), new FetchRequest.PartitionData(10L, 0L, 100, Optional.empty()));
        FetchContext session2context = fetchManager.newContext(FetchMetadata.INITIAL, session1req, this.EMPTY_PART_LIST(), false);
        Assert.assertEquals(FullFetchContext.class, session2context.getClass());
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> session2RespData = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        session2RespData.put(new TopicPartition("foo", 0), new FetchResponse.PartitionData(Errors.NONE, 100L, 100L, 100L, null, null));
        session2RespData.put(new TopicPartition("foo", 1), new FetchResponse.PartitionData(Errors.NONE, 10L, 10L, 10L, null, null));
        FetchResponse session2resp = session2context.updateAndGenerateResponseData(respData1);
        Assert.assertEquals((Object)Errors.NONE, (Object)session2resp.error());
        Assert.assertTrue((session2resp.sessionId() != 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)session2resp.responseData().size());
        Assert.assertTrue((boolean)cache.get(session1resp.sessionId()).isDefined());
        Assert.assertTrue((boolean)cache.get(session2resp.sessionId()).isDefined());
        Assert.assertEquals((long)2L, (long)cache.size());
        time.sleep(500L);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> session3req = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        session3req.put(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
        session3req.put(new TopicPartition("foo", 1), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
        FetchContext session3context = fetchManager.newContext(FetchMetadata.INITIAL, session3req, this.EMPTY_PART_LIST(), true);
        Assert.assertEquals(FullFetchContext.class, session3context.getClass());
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> respData3 = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        respData3.put(new TopicPartition("foo", 0), new FetchResponse.PartitionData(Errors.NONE, 100L, 100L, 100L, null, null));
        respData3.put(new TopicPartition("foo", 1), new FetchResponse.PartitionData(Errors.NONE, 10L, 10L, 10L, null, null));
        FetchResponse session3resp = session3context.updateAndGenerateResponseData(respData3);
        Assert.assertEquals((Object)Errors.NONE, (Object)session3resp.error());
        Assert.assertTrue((session3resp.sessionId() != 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)session3resp.responseData().size());
        Assert.assertTrue((boolean)cache.get(session1resp.sessionId()).isDefined());
        Assert.assertFalse((String)"session 2 should have been evicted by session 3", (boolean)cache.get(session2resp.sessionId()).isDefined());
        Assert.assertTrue((boolean)cache.get(session3resp.sessionId()).isDefined());
        Assert.assertEquals((long)2L, (long)cache.size());
        time.sleep(501L);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> session4req = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        session4req.put(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
        session4req.put(new TopicPartition("foo", 1), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
        FetchContext session4context = fetchManager.newContext(FetchMetadata.INITIAL, session4req, this.EMPTY_PART_LIST(), true);
        Assert.assertEquals(FullFetchContext.class, session4context.getClass());
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> respData4 = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        respData4.put(new TopicPartition("foo", 0), new FetchResponse.PartitionData(Errors.NONE, 100L, 100L, 100L, null, null));
        respData4.put(new TopicPartition("foo", 1), new FetchResponse.PartitionData(Errors.NONE, 10L, 10L, 10L, null, null));
        FetchResponse session4resp = session3context.updateAndGenerateResponseData(respData4);
        Assert.assertEquals((Object)Errors.NONE, (Object)session4resp.error());
        Assert.assertTrue((session4resp.sessionId() != 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)session4resp.responseData().size());
        Assert.assertFalse((String)"session 1 should have been evicted by session 4 even though it is privileged as it has hit eviction time", (boolean)cache.get(session1resp.sessionId()).isDefined());
        Assert.assertTrue((boolean)cache.get(session3resp.sessionId()).isDefined());
        Assert.assertTrue((boolean)cache.get(session4resp.sessionId()).isDefined());
        Assert.assertEquals((long)2L, (long)cache.size());
    }

    @Test
    public void testZeroSizeFetchSession() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData1 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        reqData1.put(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
        reqData1.put(new TopicPartition("foo", 1), new FetchRequest.PartitionData(10L, 0L, 100, Optional.empty()));
        FetchContext context1 = fetchManager.newContext(FetchMetadata.INITIAL, reqData1, this.EMPTY_PART_LIST(), false);
        Assert.assertEquals(FullFetchContext.class, context1.getClass());
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> respData1 = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        respData1.put(new TopicPartition("foo", 0), new FetchResponse.PartitionData(Errors.NONE, 100L, 100L, 100L, null, null));
        respData1.put(new TopicPartition("foo", 1), new FetchResponse.PartitionData(Errors.NONE, 10L, 10L, 10L, null, null));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData1);
        Assert.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assert.assertTrue((resp1.sessionId() != 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)resp1.responseData().size());
        LinkedHashMap reqData2 = new LinkedHashMap();
        ArrayList<TopicPartition> removed2 = new ArrayList<TopicPartition>();
        removed2.add(new TopicPartition("foo", 0));
        removed2.add(new TopicPartition("foo", 1));
        FetchContext context2 = fetchManager.newContext(new FetchMetadata(resp1.sessionId(), 1), reqData2, removed2, false);
        Assert.assertEquals(SessionlessFetchContext.class, context2.getClass());
        LinkedHashMap respData2 = new LinkedHashMap();
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData2);
        Assert.assertEquals((long)0L, (long)resp2.sessionId());
        Assert.assertTrue((boolean)resp2.responseData().isEmpty());
        Assert.assertEquals((long)0L, (long)cache.size());
    }

    @Test
    public void testDivergingEpoch() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        TopicPartition tp1 = new TopicPartition("foo", 1);
        TopicPartition tp2 = new TopicPartition("bar", 2);
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        reqData.put(tp1, new FetchRequest.PartitionData(100L, 0L, 1000, Optional.of(5), Optional.of(4)));
        reqData.put(tp2, new FetchRequest.PartitionData(100L, 0L, 1000, Optional.of(5), Optional.of(4)));
        FetchContext context1 = fetchManager.newContext(FetchMetadata.INITIAL, reqData, this.EMPTY_PART_LIST(), false);
        Assert.assertEquals(FullFetchContext.class, context1.getClass());
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> respData = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        respData.put(tp1, new FetchResponse.PartitionData(Errors.NONE, 105L, 105L, 0L, Optional.empty(), Collections.emptyList(), Optional.empty(), null));
        Optional<FetchResponseData.EpochEndOffset> divergingEpoch = Optional.of(new FetchResponseData.EpochEndOffset().setEpoch(3).setEndOffset(90L));
        respData.put(tp2, new FetchResponse.PartitionData(Errors.NONE, 105L, 105L, 0L, Optional.empty(), Collections.emptyList(), divergingEpoch, null));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData);
        Assert.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assert.assertNotEquals((long)0L, (long)resp1.sessionId());
        Assert.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{tp1, tp2}), resp1.responseData().keySet());
        FetchContext context2 = fetchManager.newContext(new FetchMetadata(resp1.sessionId(), 1), reqData, this.EMPTY_PART_LIST(), false);
        Assert.assertEquals(IncrementalFetchContext.class, context2.getClass());
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData);
        Assert.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assert.assertEquals((long)resp1.sessionId(), (long)resp2.sessionId());
        Assert.assertEquals(Collections.singleton(tp2), resp2.responseData().keySet());
        respData.put(tp1, new FetchResponse.PartitionData(Errors.NONE, 105L, 105L, 0L, Optional.empty(), Collections.emptyList(), divergingEpoch, null));
        FetchResponse resp3 = context2.updateAndGenerateResponseData(respData);
        Assert.assertEquals((Object)Errors.NONE, (Object)resp3.error());
        Assert.assertEquals((long)resp1.sessionId(), (long)resp3.sessionId());
        Assert.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{tp1, tp2}), resp3.responseData().keySet());
        respData.put(tp1, new FetchResponse.PartitionData(Errors.NONE, 110L, 110L, 0L, Optional.empty(), Collections.emptyList(), Optional.empty(), null));
        FetchResponse resp4 = context2.updateAndGenerateResponseData(respData);
        Assert.assertEquals((Object)Errors.NONE, (Object)resp4.error());
        Assert.assertEquals((long)resp1.sessionId(), (long)resp4.sessionId());
        Assert.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{tp1, tp2}), resp4.responseData().keySet());
    }

    public static final /* synthetic */ void $anonfun$testNewSessionId$1(FetchSessionCache cache$1, int i) {
        Assert.assertTrue((cache$1.newSessionId() > 0 ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testCachedLeaderEpoch$1(Builder mapBuilder$1, TopicPartition tp, FetchRequest.PartitionData data) {
        Tuple2 tuple2;
        Optional $minus$greater$extension_y = data.currentLeaderEpoch;
        Tuple2 tuple22 = tuple2 = new Tuple2((Object)tp, (Object)$minus$greater$extension_y);
        Object var3_3 = null;
        tuple2 = null;
        Tuple2 $plus$eq_elem = tuple22;
        mapBuilder$1.addOne((Object)$plus$eq_elem);
    }

    private static final Map cachedLeaderEpochs$1(FetchContext context) {
        MapBuilderImpl mapBuilderImpl;
        if (Predef$.MODULE$.Map() == null) {
            throw null;
        }
        MapBuilderImpl mapBuilderImpl2 = mapBuilderImpl = new MapBuilderImpl();
        mapBuilderImpl = null;
        MapBuilderImpl mapBuilder = mapBuilderImpl2;
        context.foreachPartition((arg_0, arg_1) -> FetchSessionTest.$anonfun$testCachedLeaderEpoch$1$adapted((Builder)mapBuilder, arg_0, arg_1));
        return mapBuilder.result();
    }

    public static final /* synthetic */ void $anonfun$testLastFetchedEpoch$1(Builder mapBuilder$2, TopicPartition tp, FetchRequest.PartitionData data) {
        Tuple2 tuple2;
        Optional $minus$greater$extension_y = data.currentLeaderEpoch;
        Tuple2 tuple22 = tuple2 = new Tuple2((Object)tp, (Object)$minus$greater$extension_y);
        Object var3_3 = null;
        tuple2 = null;
        Tuple2 $plus$eq_elem = tuple22;
        mapBuilder$2.addOne((Object)$plus$eq_elem);
    }

    private static final Map cachedLeaderEpochs$2(FetchContext context) {
        MapBuilderImpl mapBuilderImpl;
        if (Predef$.MODULE$.Map() == null) {
            throw null;
        }
        MapBuilderImpl mapBuilderImpl2 = mapBuilderImpl = new MapBuilderImpl();
        mapBuilderImpl = null;
        MapBuilderImpl mapBuilder = mapBuilderImpl2;
        context.foreachPartition((arg_0, arg_1) -> FetchSessionTest.$anonfun$testLastFetchedEpoch$1$adapted((Builder)mapBuilder, arg_0, arg_1));
        return mapBuilder.result();
    }

    public static final /* synthetic */ void $anonfun$testLastFetchedEpoch$2(Builder mapBuilder$3, TopicPartition tp, FetchRequest.PartitionData data) {
        Tuple2 tuple2;
        Optional $minus$greater$extension_y = data.lastFetchedEpoch;
        Tuple2 tuple22 = tuple2 = new Tuple2((Object)tp, (Object)$minus$greater$extension_y);
        Object var3_3 = null;
        tuple2 = null;
        Tuple2 $plus$eq_elem = tuple22;
        mapBuilder$3.addOne((Object)$plus$eq_elem);
    }

    private static final Map cachedLastFetchedEpochs$1(FetchContext context) {
        MapBuilderImpl mapBuilderImpl;
        if (Predef$.MODULE$.Map() == null) {
            throw null;
        }
        MapBuilderImpl mapBuilderImpl2 = mapBuilderImpl = new MapBuilderImpl();
        mapBuilderImpl = null;
        MapBuilderImpl mapBuilder = mapBuilderImpl2;
        context.foreachPartition((arg_0, arg_1) -> FetchSessionTest.$anonfun$testLastFetchedEpoch$2$adapted((Builder)mapBuilder, arg_0, arg_1));
        return mapBuilder.result();
    }

    public static final /* synthetic */ void $anonfun$testFetchRequests$1(java.util.Iterator reqData2Iter$1, TopicPartition topicPart, FetchRequest.PartitionData data) {
        Map.Entry entry = (Map.Entry)reqData2Iter$1.next();
        Assert.assertEquals(entry.getKey(), (Object)topicPart);
        Assert.assertEquals(entry.getValue(), (Object)data);
    }

    public static final /* synthetic */ void $anonfun$testFetchRequests$2(java.util.Iterator reqData5Iter$1, TopicPartition topicPart, FetchRequest.PartitionData data) {
        Map.Entry entry = (Map.Entry)reqData5Iter$1.next();
        Assert.assertEquals(entry.getKey(), (Object)topicPart);
        Assert.assertEquals(entry.getValue(), (Object)data);
    }

    public static final /* synthetic */ void $anonfun$testIncrementalFetchSession$1(Iterator reqData2Iter$2, TopicPartition topicPart, FetchRequest.PartitionData data) {
        Assert.assertEquals((Object)reqData2Iter$2.next(), (Object)topicPart);
    }

    public static final /* synthetic */ Object $anonfun$testCachedLeaderEpoch$1$adapted(Builder mapBuilder$1, TopicPartition tp, FetchRequest.PartitionData data) {
        FetchSessionTest.$anonfun$testCachedLeaderEpoch$1(mapBuilder$1, tp, data);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testLastFetchedEpoch$1$adapted(Builder mapBuilder$2, TopicPartition tp, FetchRequest.PartitionData data) {
        FetchSessionTest.$anonfun$testLastFetchedEpoch$1(mapBuilder$2, tp, data);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testLastFetchedEpoch$2$adapted(Builder mapBuilder$3, TopicPartition tp, FetchRequest.PartitionData data) {
        FetchSessionTest.$anonfun$testLastFetchedEpoch$2(mapBuilder$3, tp, data);
        return BoxedUnit.UNIT;
    }
}

