/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.authorizer;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kafka.network.RequestChannel;
import kafka.security.auth.Acl;
import kafka.security.auth.Authorizer;
import kafka.security.auth.Operation;
import kafka.security.auth.Operation$;
import kafka.security.auth.Resource;
import kafka.security.auth.Resource$;
import kafka.security.auth.SimpleAclAuthorizer;
import kafka.security.authorizer.AclAuthorizer$;
import kafka.security.authorizer.AclEntry$;
import kafka.security.authorizer.AuthorizerWrapper$;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Growable;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\t\u001dt!B\r\u001b\u0011\u0003\tc!B\u0012\u001b\u0011\u0003!\u0003\"B\u0016\u0002\t\u0003a\u0003\"B\u0017\u0002\t\u0003q\u0003\"\u0002/\u0002\t\u0003i\u0006\"\u00023\u0002\t\u0003)\u0007\"\u00026\u0002\t\u0003Y\u0007\"\u00028\u0002\t\u0003yg!B\u0012\u001b\u0001\u0005\r\u0001bCA\u0012\u0011\t\u0015\r\u0011\"\u0001\u001f\u0003KA!\"a\u000b\t\u0005\u0003\u0005\u000b\u0011BA\u0014\u0011\u0019Y\u0003\u0002\"\u0001\u0002.!I\u00111\u0007\u0005A\u0002\u0013\u0005\u0011Q\u0007\u0005\n\u0003{A\u0001\u0019!C\u0001\u0003\u007fA\u0001\"a\u0013\tA\u0003&\u0011q\u0007\u0005\b\u0003\u001bBA\u0011IA(\u0011\u001d\tI\t\u0003C!\u0003\u0017Cq!!0\t\t\u0003\ny\fC\u0004\u0002d\"!\t%!:\t\u000f\t\r\u0001\u0002\"\u0011\u0003\u0006!9!1\u0005\u0005\u0005B\t\u0015\u0002b\u0002B\u0018\u0011\u0011\u0005#\u0011\u0007\u0005\b\u0005gAA\u0011\tB\u001b\u0011\u001d\u0011i\u0005\u0003C\u0005\u0005\u001fBqAa\u0016\t\t\u0013\u0011I&A\tBkRDwN]5{KJ<&/\u00199qKJT!a\u0007\u000f\u0002\u0015\u0005,H\u000f[8sSj,'O\u0003\u0002\u001e=\u0005A1/Z2ve&$\u0018PC\u0001 \u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"AI\u0001\u000e\u0003i\u0011\u0011#Q;uQ>\u0014\u0018N_3s/J\f\u0007\u000f]3s'\t\tQ\u0005\u0005\u0002'S5\tqEC\u0001)\u0003\u0015\u00198-\u00197b\u0013\tQsE\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0005\nqcY8om\u0016\u0014H\u000fV8SKN|WO]2f\u0003:$\u0017i\u00197\u0015\u0005=\"\u0006\u0003\u0002\u00199w!s!!\r\u001c\u000f\u0005I*T\"A\u001a\u000b\u0005Q\u0002\u0013A\u0002\u001fs_>$h(C\u0001)\u0013\t9t%A\u0004qC\u000e\\\u0017mZ3\n\u0005eR$AB#ji\",'O\u0003\u00028OA\u0011AHR\u0007\u0002{)\u0011ahP\u0001\te\u0016\fX/Z:ug*\u0011\u0001)Q\u0001\u0007G>lWn\u001c8\u000b\u0005}\u0011%BA\"E\u0003\u0019\t\u0007/Y2iK*\tQ)A\u0002pe\u001eL!aR\u001f\u0003\u0011\u0005\u0003\u0018.\u0012:s_J\u0004BAJ%L#&\u0011!j\n\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u00051{U\"A'\u000b\u00059c\u0012\u0001B1vi\"L!\u0001U'\u0003\u0011I+7o\\;sG\u0016\u0004\"\u0001\u0014*\n\u0005Mk%aA!dY\")Qk\u0001a\u0001-\u00061a-\u001b7uKJ\u0004\"a\u0016.\u000e\u0003aS!!W \u0002\u0007\u0005\u001cG.\u0003\u0002\\1\n\u0001\u0012i\u00197CS:$\u0017N\\4GS2$XM]\u0001\u0014G>tg/\u001a:u)>\f5\r\u001c\"j]\u0012Lgn\u001a\u000b\u0004=\u0006\u001c\u0007CA,`\u0013\t\u0001\u0007L\u0001\u0006BG2\u0014\u0015N\u001c3j]\u001eDQA\u0019\u0003A\u0002-\u000b\u0001B]3t_V\u00148-\u001a\u0005\u00063\u0012\u0001\r!U\u0001\u001cG>tg/\u001a:u)>\f5mY3tg\u000e{g\u000e\u001e:pY\u0016sGO]=\u0015\u0005\u0019L\u0007CA,h\u0013\tA\u0007L\u0001\nBG\u000e,7o]\"p]R\u0014x\u000e\\#oiJL\b\"B-\u0006\u0001\u0004\t\u0016\u0001D2p]Z,'\u000f\u001e+p\u0003\u000edGCA)m\u0011\u0015ig\u00011\u0001g\u0003\r\t7-Z\u0001\u0012G>tg/\u001a:u)>\u0014Vm]8ve\u000e,GCA&q\u0011\u0015\tx\u00011\u0001s\u0003=\u0011Xm]8ve\u000e,\u0007+\u0019;uKJt\u0007CA:v\u001b\u0005!(B\u00012@\u0013\t1HOA\bSKN|WO]2f!\u0006$H/\u001a:oQ\u0011\t\u0001p_?\u0011\u0005\u0019J\u0018B\u0001>(\u0005)!W\r\u001d:fG\u0006$X\rZ\u0011\u0002y\u0006YSk]3!W\u000647.\u0019\u0018tK\u000e,(/\u001b;z]\u0005,H\u000f[8sSj,'OL!dY\u0006+H\u000f[8sSj,'/I\u0001\u007f\u0003%\u0019\u0016N\\2fAIrS\u0007\u000b\u0003\u0002qnl\b\u0006\u0002\u0001ywv\u001cR\u0001CA\u0003\u0003+\u0001B!a\u0002\u0002\u00125\u0011\u0011\u0011\u0002\u0006\u0005\u0003\u0017\ti!\u0001\u0003mC:<'BAA\b\u0003\u0011Q\u0017M^1\n\t\u0005M\u0011\u0011\u0002\u0002\u0007\u001f\nTWm\u0019;\u0011\t\u0005]\u0011qD\u0007\u0003\u00033Q1aGA\u000e\u0015\r\ti\"Q\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005\u0005\u0012\u0011\u0004\u0002\u000b\u0003V$\bn\u001c:ju\u0016\u0014\u0018A\u00042bg\u0016\fU\u000f\u001e5pe&TXM]\u000b\u0003\u0003O\u00012\u0001TA\u0015\u0013\r\t\t#T\u0001\u0010E\u0006\u001cX-Q;uQ>\u0014\u0018N_3sAQ!\u0011qFA\u0019!\t\u0011\u0003\u0002C\u0004\u0002$-\u0001\r!a\n\u0002CMDw.\u001e7e\u00032dwn^#wKJLxN\\3JM:{\u0017i\u00197Jg\u001a{WO\u001c3\u0016\u0005\u0005]\u0002c\u0001\u0014\u0002:%\u0019\u00111H\u0014\u0003\u000f\t{w\u000e\\3b]\u0006)3\u000f[8vY\u0012\fE\u000e\\8x\u000bZ,'/_8oK&3gj\\!dY&\u001bhi\\;oI~#S-\u001d\u000b\u0005\u0003\u0003\n9\u0005E\u0002'\u0003\u0007J1!!\u0012(\u0005\u0011)f.\u001b;\t\u0013\u0005%S\"!AA\u0002\u0005]\u0012a\u0001=%c\u0005\u00113\u000f[8vY\u0012\fE\u000e\\8x\u000bZ,'/_8oK&3gj\\!dY&\u001bhi\\;oI\u0002\n\u0011bY8oM&<WO]3\u0015\t\u0005\u0005\u0013\u0011\u000b\u0005\b\u0003'z\u0001\u0019AA+\u0003\u001d\u0019wN\u001c4jON\u0004D!a\u0016\u0002xAA\u0011\u0011LA0\u0003G\n\u0019(\u0004\u0002\u0002\\)!\u0011QLA\u0007\u0003\u0011)H/\u001b7\n\t\u0005\u0005\u00141\f\u0002\u0004\u001b\u0006\u0004\b\u0003BA3\u0003[rA!a\u001a\u0002jA\u0011!gJ\u0005\u0004\u0003W:\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002p\u0005E$AB*ue&twMC\u0002\u0002l\u001d\u0002B!!\u001e\u0002x1\u0001A\u0001DA=\u0003#\n\t\u0011!A\u0003\u0002\u0005m$aA0%cE!\u0011QPAB!\r1\u0013qP\u0005\u0004\u0003\u0003;#a\u0002(pi\"Lgn\u001a\t\u0004M\u0005\u0015\u0015bAADO\t\u0019\u0011I\\=\u0002\u000bM$\u0018M\u001d;\u0015\t\u00055\u00151\u0017\u0019\u0005\u0003\u001f\u000bY\n\u0005\u0005\u0002Z\u0005}\u0013\u0011SAM!\u0011\t\u0019*!&\u000e\u0003}J1!a&@\u0005!)e\u000e\u001a9pS:$\b\u0003BA;\u00037#1\"!(\u0011\u0003\u0003\u0005\tQ!\u0001\u0002 \n\u0019q\f\n\u001a\u0012\t\u0005u\u0014\u0011\u0015\t\u0007\u0003G\u000bI+!,\u000e\u0005\u0005\u0015&\u0002BAT\u00037\n!bY8oGV\u0014(/\u001a8u\u0013\u0011\tY+!*\u0003\u001f\r{W\u000e\u001d7fi&|gn\u0015;bO\u0016\u0004B!a\u0002\u00020&!\u0011\u0011WA\u0005\u0005\u00111v.\u001b3\t\u000f\u0005U\u0006\u00031\u0001\u00028\u0006Q1/\u001a:wKJLeNZ8\u0011\t\u0005]\u0011\u0011X\u0005\u0005\u0003w\u000bIB\u0001\u000bBkRDwN]5{KJ\u001cVM\u001d<fe&sgm\\\u0001\nCV$\bn\u001c:ju\u0016$b!!1\u0002N\u0006]\u0007CBA-\u0003\u0007\f9-\u0003\u0003\u0002F\u0006m#\u0001\u0002'jgR\u0004B!a\u0006\u0002J&!\u00111ZA\r\u0005M\tU\u000f\u001e5pe&T\u0018\r^5p]J+7/\u001e7u\u0011\u001d\ty-\u0005a\u0001\u0003#\faB]3rk\u0016\u001cHoQ8oi\u0016DH\u000f\u0005\u0003\u0002\u0018\u0005M\u0017\u0002BAk\u00033\u0011!$Q;uQ>\u0014\u0018N_1cY\u0016\u0014V-];fgR\u001cuN\u001c;fqRDq!!7\u0012\u0001\u0004\tY.A\u0004bGRLwN\\:\u0011\r\u0005e\u00131YAo!\u0011\t9\"a8\n\t\u0005\u0005\u0018\u0011\u0004\u0002\u0007\u0003\u000e$\u0018n\u001c8\u0002\u0015\r\u0014X-\u0019;f\u0003\u000ed7\u000f\u0006\u0004\u0002h\u0006m\u0018Q \u0019\u0005\u0003S\fi\u000f\u0005\u0004\u0002Z\u0005\r\u00171\u001e\t\u0005\u0003k\ni\u000fB\u0006\u0002pJ\t\t\u0011!A\u0003\u0002\u0005E(aA0%gE!\u0011QPAz!\u0019\t\u0019+!+\u0002vB!\u0011qCA|\u0013\u0011\tI0!\u0007\u0003\u001f\u0005\u001bGn\u0011:fCR,'+Z:vYRDq!a4\u0013\u0001\u0004\t\t\u000eC\u0004\u0002\u0000J\u0001\rA!\u0001\u0002\u0017\u0005\u001cGNQ5oI&twm\u001d\t\u0006\u00033\n\u0019MX\u0001\u000bI\u0016dW\r^3BG2\u001cHC\u0002B\u0004\u00057\u0011i\u0002\r\u0003\u0003\n\t5\u0001CBA-\u0003\u0007\u0014Y\u0001\u0005\u0003\u0002v\t5Aa\u0003B\b'\u0005\u0005\t\u0011!B\u0001\u0005#\u00111a\u0018\u00135#\u0011\tiHa\u0005\u0011\r\u0005\r\u0016\u0011\u0016B\u000b!\u0011\t9Ba\u0006\n\t\te\u0011\u0011\u0004\u0002\u0010\u0003\u000edG)\u001a7fi\u0016\u0014Vm];mi\"9\u0011qZ\nA\u0002\u0005E\u0007b\u0002B\u0010'\u0001\u0007!\u0011E\u0001\u0012C\u000ed')\u001b8eS:<g)\u001b7uKJ\u001c\b#BA-\u0003\u00074\u0016\u0001B1dYN$BAa\n\u0003.A)\u0011q\u0001B\u0015=&!!1FA\u0005\u0005!IE/\u001a:bE2,\u0007\"B+\u0015\u0001\u00041\u0016!B2m_N,GCAA!\u0003]\tW\u000f\u001e5pe&TXMQ=SKN|WO]2f)f\u0004X\r\u0006\u0005\u0002H\n]\"\u0011\bB\"\u0011\u001d\tyM\u0006a\u0001\u0003#DqAa\u000f\u0017\u0001\u0004\u0011i$\u0001\u0002paB\u0019qKa\u0010\n\u0007\t\u0005\u0003L\u0001\u0007BG2|\u0005/\u001a:bi&|g\u000eC\u0004\u0003FY\u0001\rAa\u0012\u0002\u0019I,7o\\;sG\u0016$\u0016\u0010]3\u0011\u0007M\u0014I%C\u0002\u0003LQ\u0014ABU3t_V\u00148-\u001a+za\u0016\fq\u0002Z3os\u0006cGNU3t_V\u00148-\u001a\u000b\t\u0003o\u0011\tFa\u0015\u0003V!9\u0011qZ\fA\u0002\u0005E\u0007b\u0002B\u001e/\u0001\u0007!Q\b\u0005\b\u0005\u000b:\u0002\u0019\u0001B$\u0003I\u0001(/\u001b8dSB\fG\u000eS8ti6\u000bGo\u00195\u0015\u0011\u0005]\"1\fB/\u0005CBQ!\u001c\rA\u0002\u0019DqAa\u0018\u0019\u0001\u0004\t\u0019'A\u0005qe&t7-\u001b9bY\"9!1\r\rA\u0002\u0005\r\u0014\u0001\u00025pgRDC\u0001\u0003=|{\u0002")
public class AuthorizerWrapper
implements org.apache.kafka.server.authorizer.Authorizer {
    private final Authorizer baseAuthorizer;
    private boolean shouldAllowEveryoneIfNoAclIsFound;

    public static Resource convertToResource(ResourcePattern resourcePattern) {
        return AuthorizerWrapper$.MODULE$.convertToResource(resourcePattern);
    }

    public static Acl convertToAcl(AccessControlEntry accessControlEntry) {
        return AuthorizerWrapper$.MODULE$.convertToAcl(accessControlEntry);
    }

    public static AccessControlEntry convertToAccessControlEntry(Acl acl) {
        return AuthorizerWrapper$.MODULE$.convertToAccessControlEntry(acl);
    }

    public static AclBinding convertToAclBinding(Resource resource, Acl acl) {
        return AuthorizerWrapper$.MODULE$.convertToAclBinding(resource, acl);
    }

    public static Either<ApiError, Tuple2<Resource, Acl>> convertToResourceAndAcl(AclBindingFilter aclBindingFilter) {
        return AuthorizerWrapper$.MODULE$.convertToResourceAndAcl(aclBindingFilter);
    }

    public Authorizer baseAuthorizer() {
        return this.baseAuthorizer;
    }

    public boolean shouldAllowEveryoneIfNoAclIsFound() {
        return this.shouldAllowEveryoneIfNoAclIsFound;
    }

    public void shouldAllowEveryoneIfNoAclIsFound_$eq(boolean x$1) {
        this.shouldAllowEveryoneIfNoAclIsFound = x$1;
    }

    public void configure(java.util.Map<String, ?> configs) {
        this.baseAuthorizer().configure(configs);
        this.shouldAllowEveryoneIfNoAclIsFound_$eq(CollectionConverters$.MODULE$.MapHasAsScala(configs).asScala().get((Object)AclAuthorizer$.MODULE$.AllowEveryoneIfNoAclIsFoundProp()).exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(x$2.toString())))) && this.baseAuthorizer() instanceof SimpleAclAuthorizer);
    }

    public java.util.Map<Endpoint, ? extends CompletionStage<Void>> start(AuthorizerServerInfo serverInfo) {
        return CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(serverInfo.endpoints()).asScala().map((Function1 & Serializable)endpoint -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(endpoint), CompletableFuture.completedFuture(null)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
    }

    public List<AuthorizationResult> authorize(AuthorizableRequestContext requestContext, List<Action> actions) {
        RequestChannel.Session session = new RequestChannel.Session(requestContext.principal(), requestContext.clientAddress());
        return CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(actions).asScala().map((Function1 & Serializable)action -> {
            Operation operation = Operation$.MODULE$.fromJava(action.operation());
            if (this.baseAuthorizer().authorize(session, operation, AuthorizerWrapper$.MODULE$.convertToResource(action.resourcePattern()))) {
                return AuthorizationResult.ALLOWED;
            }
            return AuthorizationResult.DENIED;
        })).asJava();
    }

    public List<? extends CompletionStage<AclCreateResult>> createAcls(AuthorizableRequestContext requestContext, List<AclBinding> aclBindings) {
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(aclBindings).asScala().map((Function1 & Serializable)aclBinding -> {
            Tuple2 tuple2;
            AclCreateResult aclCreateResult;
            Either<ApiError, Tuple2<Resource, Acl>> either = AuthorizerWrapper$.MODULE$.convertToResourceAndAcl(aclBinding.toFilter());
            if (either instanceof Left) {
                ApiError apiError = (ApiError)((Left)either).value();
                aclCreateResult = new AclCreateResult(apiError.exception());
            } else if (either instanceof Right && (tuple2 = (Tuple2)((Right)either).value()) != null) {
                AclCreateResult aclCreateResult2;
                Resource resource = (Resource)tuple2._1();
                Acl acl = (Acl)tuple2._2();
                try {
                    this.baseAuthorizer().addAcls((Set<Acl>)((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Acl[]{acl}))), resource);
                    aclCreateResult2 = AclCreateResult.SUCCESS;
                }
                catch (ApiException e) {
                    aclCreateResult2 = new AclCreateResult(e);
                }
                catch (Throwable e) {
                    aclCreateResult2 = new AclCreateResult((ApiException)((Object)((Object)((Object)new InvalidRequestException("Failed to create ACL", e)))));
                }
                aclCreateResult = aclCreateResult2;
            } else {
                throw new MatchError(either);
            }
            return aclCreateResult;
        })).toList().map((Function1 & Serializable)x$1 -> CompletableFuture.completedFuture(x$1))).asJava();
    }

    public List<? extends CompletionStage<AclDeleteResult>> deleteAcls(AuthorizableRequestContext requestContext, List<AclBindingFilter> aclBindingFilters) {
        Buffer filters = CollectionConverters$.MODULE$.ListHasAsScala(aclBindingFilters).asScala();
        scala.collection.mutable.Map results = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        scala.collection.mutable.Map toDelete = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        if (filters.forall((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.matchesAtMostOne()))) {
            ((IterableOps)filters.zipWithIndex()).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable)x$4 -> {
                if (x$4 == null) throw new MatchError(null);
                AclBindingFilter filter = (AclBindingFilter)x$4._1();
                int i = x$4._2$mcI$sp();
                Either<ApiError, Tuple2<Resource, Acl>> either = AuthorizerWrapper$.MODULE$.convertToResourceAndAcl(filter);
                if (either instanceof Left) {
                    ApiError apiError = (ApiError)((Left)either).value();
                    return results.put((Object)BoxesRunTime.boxToInteger((int)i), (Object)new AclDeleteResult(apiError.exception()));
                }
                if (!(either instanceof Right)) throw new MatchError(either);
                Tuple2 binding = (Tuple2)((Right)either).value();
                return toDelete.put((Object)BoxesRunTime.boxToInteger((int)i), ArrayBuffer$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{binding})));
            });
        } else {
            scala.collection.immutable.Map<Resource, Set<Acl>> aclMap = this.baseAuthorizer().getAcls();
            Buffer filtersWithIndex = (Buffer)filters.zipWithIndex();
            aclMap.withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$2 != null))).foreach((Function1 & Serializable)x$7 -> {
                AuthorizerWrapper.$anonfun$deleteAcls$5(filtersWithIndex, toDelete, x$7);
                return BoxedUnit.UNIT;
            });
        }
        toDelete.withFilter((Function1 & Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$4 != null))).foreach((Function1 & Serializable)x$8 -> {
            if (x$8 == null) {
                throw new MatchError(null);
            }
            int i = x$8._1$mcI$sp();
            ArrayBuffer acls = (ArrayBuffer)x$8._2();
            List deletionResults = CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)acls.flatMap((Function1 & Serializable)x0$1 -> {
                Object object;
                if (x0$1 != null) {
                    Resource resource = (Resource)x0$1._1();
                    Acl acl = (Acl)x0$1._2();
                    AclBinding aclBinding = AuthorizerWrapper$.MODULE$.convertToAclBinding(resource, acl);
                    try {
                        object = this.baseAuthorizer().removeAcls((Set<Acl>)((Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Acl[]{acl}))), resource) ? new Some((Object)new AclDeleteResult.AclBindingDeleteResult(aclBinding)) : None$.MODULE$;
                    }
                    catch (Throwable throwable) {
                        object = new Some((Object)new AclDeleteResult.AclBindingDeleteResult(aclBinding, ApiError.fromThrowable((Throwable)throwable).exception()));
                    }
                } else {
                    throw new MatchError(null);
                }
                Some some = object;
                return some;
            })).asJava();
            Option option = results.put((Object)BoxesRunTime.boxToInteger((int)i), (Object)new AclDeleteResult((Collection)deletionResults));
            return option;
        });
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)filters.indices().map((Function1 & Serializable)i -> AuthorizerWrapper.$anonfun$deleteAcls$14(results, BoxesRunTime.unboxToInt((Object)i))).map((Function1 & Serializable)x$1 -> CompletableFuture.completedFuture(x$1))).asJava();
    }

    public java.lang.Iterable<AclBinding> acls(AclBindingFilter filter) {
        return CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)this.baseAuthorizer().getAcls().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            Resource resource = (Resource)x0$1._1();
            Set set = (Set)((IterableOps)((Set)x0$1._2()).map((Function1 & Serializable)acl -> AuthorizerWrapper$.MODULE$.convertToAclBinding(resource, (Acl)acl))).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filter.matches(x$1)));
            return set;
        })).asJava();
    }

    public void close() {
        this.baseAuthorizer().close();
    }

    public AuthorizationResult authorizeByResourceType(AuthorizableRequestContext requestContext, AclOperation op, ResourceType resourceType) {
        SecurityUtils.authorizeByResourceTypeCheckArgs((AclOperation)op, (ResourceType)resourceType);
        AuthorizationResult authorizationResult = super.authorizeByResourceType(requestContext, op, resourceType);
        AuthorizationResult authorizationResult2 = AuthorizationResult.ALLOWED;
        if (!(authorizationResult != null ? !authorizationResult.equals(authorizationResult2) : authorizationResult2 != null)) {
            return AuthorizationResult.ALLOWED;
        }
        if (this.denyAllResource(requestContext, op, resourceType) || !this.shouldAllowEveryoneIfNoAclIsFound()) {
            return AuthorizationResult.DENIED;
        }
        return AuthorizationResult.ALLOWED;
    }

    private boolean denyAllResource(AuthorizableRequestContext requestContext, AclOperation op, ResourceType resourceType) {
        ResourcePatternFilter resourceTypeFilter = new ResourcePatternFilter(resourceType, Resource$.MODULE$.WildCardResource(), PatternType.LITERAL);
        String principal = new KafkaPrincipal(requestContext.principal().getPrincipalType(), requestContext.principal().getName()).toString();
        String host = requestContext.clientAddress().getHostAddress();
        AccessControlEntryFilter entryFilter = new AccessControlEntryFilter(null, null, op, AclPermissionType.DENY);
        AccessControlEntryFilter entryFilterAllOp = new AccessControlEntryFilter(null, null, AclOperation.ALL, AclPermissionType.DENY);
        AclBindingFilter aclFilter = new AclBindingFilter(resourceTypeFilter, entryFilter);
        AclBindingFilter aclFilterAllOp = new AclBindingFilter(resourceTypeFilter, entryFilterAllOp);
        return CollectionConverters$.MODULE$.IterableHasAsScala(this.acls(aclFilter)).asScala().exists((Function1 & Serializable)b -> BoxesRunTime.boxToBoolean((boolean)this.principalHostMatch(b.entry(), principal, host))) || CollectionConverters$.MODULE$.IterableHasAsScala(this.acls(aclFilterAllOp)).asScala().exists((Function1 & Serializable)b -> BoxesRunTime.boxToBoolean((boolean)this.principalHostMatch(b.entry(), principal, host)));
    }

    private boolean principalHostMatch(AccessControlEntry ace, String principal, String host) {
        block3: {
            block4: {
                block2: {
                    String string = ace.host();
                    String string2 = AclEntry$.MODULE$.WildcardHost();
                    if (!(string == null ? string2 != null : !string.equals(string2))) break block2;
                    String string3 = ace.host();
                    if (string3 != null ? !string3.equals(host) : host != null) break block3;
                }
                String string = ace.principal();
                String string4 = AclEntry$.MODULE$.WildcardPrincipalString();
                if (!(string == null ? string4 != null : !string.equals(string4))) break block4;
                String string5 = ace.principal();
                if (string5 != null ? !string5.equals(principal) : principal != null) break block3;
            }
            return true;
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$deleteAcls$8(AclBinding binding$1, Tuple2 x$5) {
        if (x$5 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((AclBindingFilter)x$5._1()).matches(binding$1);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$deleteAcls$6(Resource resource$1, Buffer filtersWithIndex$1, scala.collection.mutable.Map toDelete$1, Acl acl) {
        AclBinding binding = new AclBinding(new ResourcePattern(resource$1.resourceType().toJava(), resource$1.name(), resource$1.patternType()), new AccessControlEntry(acl.principal().toString(), acl.host().toString(), acl.operation().toJava(), acl.permissionType().toJava()));
        filtersWithIndex$1.withFilter((Function1 & Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$3 != null))).withFilter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)AuthorizerWrapper.$anonfun$deleteAcls$8(binding, x$5))).foreach((Function1 & Serializable)x$6 -> {
            if (x$6 == null) {
                throw new MatchError(null);
            }
            int i = x$6._2$mcI$sp();
            ArrayBuffer arrayBuffer = (ArrayBuffer)((Growable)toDelete$1.getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)i), (Function0 & Serializable)() -> ArrayBuffer$.MODULE$.empty())).$plus$eq((Object)new Tuple2((Object)resource$1, (Object)acl));
            return arrayBuffer;
        });
    }

    public static final /* synthetic */ void $anonfun$deleteAcls$5(Buffer filtersWithIndex$1, scala.collection.mutable.Map toDelete$1, Tuple2 x$7) {
        if (x$7 != null) {
            Resource resource = (Resource)x$7._1();
            ((Set)x$7._2()).foreach((Function1 & Serializable)acl -> {
                AuthorizerWrapper.$anonfun$deleteAcls$6(resource, filtersWithIndex$1, toDelete$1, acl);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ AclDeleteResult $anonfun$deleteAcls$14(scala.collection.mutable.Map results$1, int i) {
        return (AclDeleteResult)results$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)i), (Function0 & Serializable)() -> new AclDeleteResult((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Seq$.MODULE$.empty()).asJava()));
    }

    public AuthorizerWrapper(Authorizer baseAuthorizer) {
        this.baseAuthorizer = baseAuthorizer;
        this.shouldAllowEveryoneIfNoAclIsFound = false;
    }
}

