/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import kafka.log.Defaults$;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.log.LogSegment;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

public final class LogTest$ {
    public static final LogTest$ MODULE$ = new LogTest$();

    public LogConfig createLogConfig(long segmentMs, int segmentBytes, long retentionMs, long retentionBytes, long segmentJitterMs, String cleanupPolicy, int maxMessageBytes, int indexIntervalBytes, int segmentIndexBytes, String messageFormatVersion, long fileDeleteDelayMs) {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentMsProp(), Predef$.MODULE$.long2Long(segmentMs));
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(segmentBytes));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.long2Long(retentionMs));
        logProps.put(LogConfig$.MODULE$.RetentionBytesProp(), Predef$.MODULE$.long2Long(retentionBytes));
        logProps.put(LogConfig$.MODULE$.SegmentJitterMsProp(), Predef$.MODULE$.long2Long(segmentJitterMs));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), cleanupPolicy);
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(maxMessageBytes));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(indexIntervalBytes));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(segmentIndexBytes));
        logProps.put(LogConfig$.MODULE$.MessageFormatVersionProp(), messageFormatVersion);
        logProps.put(LogConfig$.MODULE$.FileDeleteDelayMsProp(), Predef$.MODULE$.long2Long(fileDeleteDelayMs));
        return new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
    }

    public Log createLog(File dir, LogConfig config, BrokerTopicStats brokerTopicStats, Scheduler scheduler, Time time, long logStartOffset, long recoveryPoint, int maxProducerIdExpirationMs, int producerIdExpirationCheckIntervalMs, boolean lastShutdownClean, boolean keepPartitionMetadataFile) {
        return Log$.MODULE$.apply(dir, config, logStartOffset, recoveryPoint, scheduler, brokerTopicStats, time, maxProducerIdExpirationMs, producerIdExpirationCheckIntervalMs, new LogDirFailureChannel(10), lastShutdownClean, keepPartitionMetadataFile);
    }

    public long createLogConfig$default$1() {
        return Defaults$.MODULE$.SegmentMs();
    }

    public int createLogConfig$default$2() {
        return Defaults$.MODULE$.SegmentSize();
    }

    public long createLogConfig$default$3() {
        return Defaults$.MODULE$.RetentionMs();
    }

    public long createLogConfig$default$4() {
        return Defaults$.MODULE$.RetentionSize();
    }

    public long createLogConfig$default$5() {
        return Defaults$.MODULE$.SegmentJitterMs();
    }

    public String createLogConfig$default$6() {
        return Defaults$.MODULE$.CleanupPolicy();
    }

    public int createLogConfig$default$7() {
        return Defaults$.MODULE$.MaxMessageSize();
    }

    public int createLogConfig$default$8() {
        return Defaults$.MODULE$.IndexInterval();
    }

    public int createLogConfig$default$9() {
        return Defaults$.MODULE$.MaxIndexSize();
    }

    public String createLogConfig$default$10() {
        return Defaults$.MODULE$.MessageFormatVersion();
    }

    public long createLogConfig$default$11() {
        return Defaults$.MODULE$.FileDeleteDelayMs();
    }

    public long createLog$default$6() {
        return 0L;
    }

    public long createLog$default$7() {
        return 0L;
    }

    public int createLog$default$8() {
        return 3600000;
    }

    public int createLog$default$9() {
        return LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
    }

    public boolean createLog$default$10() {
        return true;
    }

    public boolean createLog$default$11() {
        return true;
    }

    public boolean hasOffsetOverflow(Log log) {
        return this.firstOverflowSegment(log).isDefined();
    }

    public Option<LogSegment> firstOverflowSegment(Log log) {
        Object object = new Object();
        try {
            log.logSegments().foreach((Function1 & Serializable)segment -> {
                LogTest$.$anonfun$firstOverflowSegment$1(object, segment);
                return BoxedUnit.UNIT;
            });
            return None$.MODULE$;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return (Option)ex.value();
            }
            throw ex;
        }
    }

    public FileRecords kafka$log$LogTest$$rawSegment(File logDir, long baseOffset) {
        File open_file = Log$.MODULE$.logFile(logDir, baseOffset, "");
        boolean open_mutable = true;
        return FileRecords.open((File)open_file, (boolean)open_mutable, (boolean)false, (int)0, (boolean)false);
    }

    public void initializeLogDirWithOverflowedSegment(File logDir) {
        long nextOffset = 0L;
        nextOffset = this.writeNormalSegment$1(nextOffset, logDir);
        nextOffset = this.writeOverflowSegment$1(nextOffset, logDir);
        this.writeNormalSegment$1(nextOffset, logDir);
    }

    public List<Record> allRecords(Log log) {
        ListBuffer recordsFound = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        log.logSegments().foreach((Function1 & Serializable)logSegment -> {
            LogTest$.$anonfun$allRecords$1(recordsFound, logSegment);
            return BoxedUnit.UNIT;
        });
        return recordsFound.toList();
    }

    public void verifyRecordsInLog(Log log, List<Record> expectedRecords) {
        Assertions.assertEquals(expectedRecords, this.allRecords(log));
    }

    public Iterable<Object> keysInLog(Log log) {
        return (Iterable)log.logSegments().flatMap((Function1 & Serializable)logSegment -> (Iterable)CollectionConverters$.MODULE$.IterableHasAsScala(logSegment.log().batches()).asScala().withFilter((Function1 & Serializable)batch -> BoxesRunTime.boxToBoolean((boolean)LogTest$.$anonfun$keysInLog$2(batch))).flatMap((Function1 & Serializable)batch -> (Iterable)CollectionConverters$.MODULE$.IterableHasAsScala((java.lang.Iterable)batch).asScala().withFilter((Function1 & Serializable)record -> BoxesRunTime.boxToBoolean((boolean)LogTest$.$anonfun$keysInLog$4(record))).map((Function1 & Serializable)record -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.key(), TestUtils$.MODULE$.readString$default$2())))))));
    }

    public Log recoverAndCheck(File logDir, LogConfig config, Iterable<Object> expectedKeys, BrokerTopicStats brokerTopicStats, Time time, Scheduler scheduler) {
        long l = 0L;
        long l2 = 0L;
        int n = 3600000;
        int n2 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        boolean bl = true;
        Log recoveredLog = this.createLog(logDir, config, brokerTopicStats, scheduler, time, l, l2, n, n2, false, bl);
        time.sleep(Predef$.MODULE$.Long2long(config.fileDeleteDelayMs()) + 1L);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])logDir.listFiles()), (Function1 & Serializable)file -> {
            LogTest$.$anonfun$recoverAndCheck$1(file);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals(expectedKeys, this.keysInLog(recoveredLog));
        Assertions.assertFalse((boolean)this.hasOffsetOverflow(recoveredLog));
        return recoveredLog;
    }

    private static final boolean hasOverflow$1(long baseOffset, RecordBatch batch) {
        return batch.lastOffset() > baseOffset + Integer.MAX_VALUE || batch.baseOffset() < baseOffset;
    }

    public static final /* synthetic */ void $anonfun$firstOverflowSegment$1(Object nonLocalReturnKey1$1, LogSegment segment) {
        if (CollectionConverters$.MODULE$.IterableHasAsScala(segment.log().batches()).asScala().find((Function1 & Serializable)batch -> BoxesRunTime.boxToBoolean((boolean)LogTest$.hasOverflow$1(segment.baseOffset(), (RecordBatch)batch))).isDefined()) {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)segment));
        }
    }

    private static final SimpleRecord record$1(long offset) {
        byte[] data = Long.toString(offset).getBytes();
        return new SimpleRecord(data, data);
    }

    /*
     * WARNING - void declaration
     */
    private static final long writeSampleBatches$1(long baseOffset, FileRecords segment, File logDir$2) {
        void withRecords_records;
        void withRecords_partitionLeaderEpoch;
        void withRecords_compressionType;
        void withRecords_records2;
        void withRecords_partitionLeaderEpoch2;
        void withRecords_compressionType2;
        void withRecords_records3;
        void withRecords_partitionLeaderEpoch3;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{LogTest$.record$1(baseOffset)};
        boolean bl = false;
        CompressionType withRecords_compressionType3 = CompressionType.NONE;
        Object var4_5 = null;
        simpleRecordArray = null;
        segment.append(MemoryRecords.withRecords((byte)2, (long)baseOffset, (CompressionType)withRecords_compressionType3, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch3, (boolean)false, (SimpleRecord[])withRecords_records3));
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{LogTest$.record$1(baseOffset + 1L), LogTest$.record$1(baseOffset + 2L)};
        boolean bl2 = false;
        CompressionType compressionType = CompressionType.NONE;
        long withRecords_initialOffset = baseOffset + 1L;
        compressionType = null;
        simpleRecordArray2 = null;
        segment.append(MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType2, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch2, (boolean)false, (SimpleRecord[])withRecords_records2));
        SimpleRecord[] simpleRecordArray3 = new SimpleRecord[]{LogTest$.record$1(baseOffset + Integer.MAX_VALUE - 1L)};
        boolean bl3 = false;
        CompressionType compressionType2 = CompressionType.NONE;
        long withRecords_initialOffset2 = baseOffset + Integer.MAX_VALUE - 1L;
        compressionType2 = null;
        simpleRecordArray3 = null;
        segment.append(MemoryRecords.withRecords((byte)2, (long)withRecords_initialOffset2, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records));
        Log$.MODULE$.offsetIndexFile(logDir$2, baseOffset, "").createNewFile();
        Log$.MODULE$.timeIndexFile(logDir$2, baseOffset, "").createNewFile();
        return baseOffset + Integer.MAX_VALUE;
    }

    private final long writeNormalSegment$1(long baseOffset, File logDir$2) {
        long l;
        try (FileRecords segment = this.kafka$log$LogTest$$rawSegment(logDir$2, baseOffset);){
            l = LogTest$.writeSampleBatches$1(baseOffset, segment, logDir$2);
        }
        return l;
    }

    private final long writeOverflowSegment$1(long baseOffset, File logDir$2) {
        long l;
        try (FileRecords segment = this.kafka$log$LogTest$$rawSegment(logDir$2, baseOffset);){
            l = LogTest$.writeSampleBatches$1(LogTest$.writeSampleBatches$1(baseOffset, segment, logDir$2), segment, logDir$2);
        }
        return l;
    }

    public static final /* synthetic */ void $anonfun$allRecords$1(ListBuffer recordsFound$1, LogSegment logSegment) {
        CollectionConverters$.MODULE$.IterableHasAsScala(logSegment.log().batches()).asScala().foreach((Function1 & Serializable)batch -> (ListBuffer)recordsFound$1.$plus$plus$eq((IterableOnce)CollectionConverters$.MODULE$.IteratorHasAsScala(batch.iterator()).asScala()));
    }

    public static final /* synthetic */ boolean $anonfun$keysInLog$2(FileLogInputStream.FileChannelRecordBatch batch) {
        return !batch.isControlBatch();
    }

    public static final /* synthetic */ boolean $anonfun$keysInLog$4(Record record) {
        return record.hasValue() && record.hasKey();
    }

    public static final /* synthetic */ void $anonfun$recoverAndCheck$1(File file) {
        Assertions.assertFalse((boolean)file.getName().endsWith(Log$.MODULE$.DeletedFileSuffix()), (String)"Unexpected .deleted file after recovery");
        Assertions.assertFalse((boolean)file.getName().endsWith(Log$.MODULE$.CleanedFileSuffix()), (String)"Unexpected .cleaned file after recovery");
        Assertions.assertFalse((boolean)file.getName().endsWith(Log$.MODULE$.SwapFileSuffix()), (String)"Unexpected .swap file after recovery");
    }

    private LogTest$() {
    }
}

