/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.authorizer;

import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Properties;
import java.util.UUID;
import kafka.security.auth.Authorizer;
import kafka.security.auth.SimpleAclAuthorizer;
import kafka.security.auth.SimpleAclAuthorizer$;
import kafka.security.authorizer.AclAuthorizer$;
import kafka.security.authorizer.AclEntry$;
import kafka.security.authorizer.AuthorizerWrapper;
import kafka.security.authorizer.BaseAuthorizerTest;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zookeeper.ZooKeeperClient;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005a3A\u0001D\u0007\u0001)!)q\u0004\u0001C\u0001A!9!\u0005\u0001b\u0001\n\u0013\u0019\u0003BB\u0014\u0001A\u0003%A\u0005C\u0004)\u0001\t\u0007I\u0011B\u0012\t\r%\u0002\u0001\u0015!\u0003%\u0011\u0015q\u0001\u0001\"\u0011+\u0011\u00159\u0004\u0001\"\u00119\u0011\u0015Q\u0005\u0001\"\u00119\u0011\u0015y\u0005\u0001\"\u00019\u0011\u0015y\u0005\u0001\"\u0003U\u0011\u00151\u0006\u0001\"\u00019\u0005U\tU\u000f\u001e5pe&TXM],sCB\u0004XM\u001d+fgRT!AD\b\u0002\u0015\u0005,H\u000f[8sSj,'O\u0003\u0002\u0011#\u0005A1/Z2ve&$\u0018PC\u0001\u0013\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001A\u000b\u001c!\t1\u0012$D\u0001\u0018\u0015\tA\u0012#\u0001\u0002{W&\u0011!d\u0006\u0002\u00155>|7*Z3qKJ$Vm\u001d;ICJtWm]:\u0011\u0005qiR\"A\u0007\n\u0005yi!A\u0005\"bg\u0016\fU\u000f\u001e5pe&TXM\u001d+fgR\fa\u0001P5oSRtD#A\u0011\u0011\u0005q\u0001\u0011aF<sCB\u0004X\rZ*j[BdW-Q;uQ>\u0014\u0018N_3s+\u0005!\u0003C\u0001\u000f&\u0013\t1SBA\tBkRDwN]5{KJ<&/\u00199qKJ\f\u0001d\u001e:baB,GmU5na2,\u0017)\u001e;i_JL'0\u001a:!\u0003\u0011:(/\u00199qK\u0012\u001c\u0016.\u001c9mK\u0006+H\u000f[8sSj,'/\u00117m_^,e/\u001a:z_:,\u0017!J<sCB\u0004X\rZ*j[BdW-Q;uQ>\u0014\u0018N_3s\u00032dwn^#wKJLxN\\3!+\u0005Y\u0003C\u0001\u00176\u001b\u0005i#B\u0001\b/\u0015\ty\u0003'\u0001\u0004tKJ4XM\u001d\u0006\u0003%ER!AM\u001a\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0014aA8sO&\u0011a'\f\u0002\u000b\u0003V$\bn\u001c:ju\u0016\u0014\u0018!B:fiV\u0003H#A\u001d\u0011\u0005ijT\"A\u001e\u000b\u0003q\nQa]2bY\u0006L!AP\u001e\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u000f\u0001\u0003\"!\u0011%\u000e\u0003\tS!a\u0011#\u0002\u0007\u0005\u0004\u0018N\u0003\u0002F\r\u00069!.\u001e9ji\u0016\u0014(BA$4\u0003\u0015QWO\\5u\u0013\tI%I\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0003\u00111\u0003\"!Q'\n\u00059\u0013%!C!gi\u0016\u0014X)Y2i\u00039\"Xm\u001d;BkRDwN]5{K\nK(+Z:pkJ\u001cW\rV=qK\u0016s\u0017M\u00197f\u00032dwn^#wKJLxJ\\3)\u0005%\t\u0006CA!S\u0013\t\u0019&I\u0001\u0003UKN$HCA\u001dV\u0011\u0015q!\u00021\u0001,\u0003]\"Xm\u001d;BkRDwN]5{K\nK(+Z:pkJ\u001cW\rV=qK\u0012K7/\u00192mK\u0006cGn\\<Fm\u0016\u0014\u0018p\u001c8f\u001fZ,'O]5eK\"\u00121\"\u0015")
public class AuthorizerWrapperTest
extends ZooKeeperTestHarness
implements BaseAuthorizerTest {
    private final AuthorizerWrapper wrappedSimpleAuthorizer;
    private final AuthorizerWrapper wrappedSimpleAuthorizerAllowEveryone;
    private String superUsers;
    private String username;
    private KafkaPrincipal principal;
    private RequestContext requestContext;
    private String superUserName;
    private KafkaConfig config;
    private ZooKeeperClient zooKeeperClient;
    private ResourcePattern resource;

    @Override
    @Test
    public void testAuthorizeByResourceTypeMultipleAddAndRemove() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeMultipleAddAndRemove$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypeIsolationUnrelatedDenyWontDominateAllow() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeIsolationUnrelatedDenyWontDominateAllow$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypeDenyTakesPrecedence() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeDenyTakesPrecedence$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypePrefixedResourceDenyDominate() {
        BaseAuthorizerTest.testAuthorizeByResourceTypePrefixedResourceDenyDominate$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypeWildcardResourceDenyDominate() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeWildcardResourceDenyDominate$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypeWithAllOperationAce() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeWithAllOperationAce$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypeWithAllHostAce() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeWithAllHostAce$(this);
    }

    @Override
    @Test
    public void testAuthorizeByResourceTypeWithAllPrincipalAce() {
        BaseAuthorizerTest.testAuthorizeByResourceTypeWithAllPrincipalAce$(this);
    }

    @Override
    @Test
    public void testAuthorzeByResourceTypeSuperUserHasAccess() {
        BaseAuthorizerTest.testAuthorzeByResourceTypeSuperUserHasAccess$(this);
    }

    @Override
    public RequestContext newRequestContext(KafkaPrincipal principal, InetAddress clientAddress, ApiKeys apiKey) {
        return BaseAuthorizerTest.newRequestContext$(this, principal, clientAddress, apiKey);
    }

    @Override
    public ApiKeys newRequestContext$default$3() {
        return BaseAuthorizerTest.newRequestContext$default$3$(this);
    }

    @Override
    public boolean authorizeByResourceType(org.apache.kafka.server.authorizer.Authorizer authorizer, RequestContext requestContext, AclOperation operation, ResourceType resourceType) {
        return BaseAuthorizerTest.authorizeByResourceType$(this, authorizer, requestContext, operation, resourceType);
    }

    @Override
    public void addAcls(org.apache.kafka.server.authorizer.Authorizer authorizer, Set<AccessControlEntry> aces, ResourcePattern resourcePattern) {
        BaseAuthorizerTest.addAcls$(this, authorizer, aces, resourcePattern);
    }

    @Override
    public boolean removeAcls(org.apache.kafka.server.authorizer.Authorizer authorizer, Set<AccessControlEntry> aces, ResourcePattern resourcePattern) {
        return BaseAuthorizerTest.removeAcls$(this, authorizer, aces, resourcePattern);
    }

    @Override
    public String superUsers() {
        return this.superUsers;
    }

    @Override
    public String username() {
        return this.username;
    }

    @Override
    public KafkaPrincipal principal() {
        return this.principal;
    }

    @Override
    public RequestContext requestContext() {
        return this.requestContext;
    }

    @Override
    public String superUserName() {
        return this.superUserName;
    }

    @Override
    public KafkaConfig config() {
        return this.config;
    }

    @Override
    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    @Override
    public ZooKeeperClient zooKeeperClient() {
        return this.zooKeeperClient;
    }

    @Override
    public void zooKeeperClient_$eq(ZooKeeperClient x$1) {
        this.zooKeeperClient = x$1;
    }

    @Override
    public ResourcePattern resource() {
        return this.resource;
    }

    @Override
    public void resource_$eq(ResourcePattern x$1) {
        this.resource = x$1;
    }

    @Override
    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$superUsers_$eq(String x$1) {
        this.superUsers = x$1;
    }

    @Override
    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$username_$eq(String x$1) {
        this.username = x$1;
    }

    @Override
    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$principal_$eq(KafkaPrincipal x$1) {
        this.principal = x$1;
    }

    @Override
    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$requestContext_$eq(RequestContext x$1) {
        this.requestContext = x$1;
    }

    @Override
    public void kafka$security$authorizer$BaseAuthorizerTest$_setter_$superUserName_$eq(String x$1) {
        this.superUserName = x$1;
    }

    private AuthorizerWrapper wrappedSimpleAuthorizer() {
        return this.wrappedSimpleAuthorizer;
    }

    private AuthorizerWrapper wrappedSimpleAuthorizerAllowEveryone() {
        return this.wrappedSimpleAuthorizerAllowEveryone;
    }

    @Override
    public org.apache.kafka.server.authorizer.Authorizer authorizer() {
        return this.wrappedSimpleAuthorizer();
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        props.put(AclAuthorizer$.MODULE$.SuperUsersProp(), this.superUsers());
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
        this.wrappedSimpleAuthorizer().configure(this.config().originals());
        props.put(SimpleAclAuthorizer$.MODULE$.AllowEveryoneIfNoAclIsFoundProp(), "true");
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
        this.wrappedSimpleAuthorizerAllowEveryone().configure(this.config().originals());
        this.resource_$eq(new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.LITERAL));
        this.zooKeeperClient_$eq(new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), this.zkMaxInFlightRequests(), Time.SYSTEM, "kafka.test", "AuthorizerWrapperTest"));
    }

    @Override
    @AfterEach
    public void tearDown() {
        ((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AuthorizerWrapper[]{this.wrappedSimpleAuthorizer(), this.wrappedSimpleAuthorizerAllowEveryone()}))).foreach((Function1 & Serializable)a -> {
            a.close();
            return BoxedUnit.UNIT;
        });
        this.zooKeeperClient().close();
        super.tearDown();
    }

    @Test
    public void testAuthorizeByResourceTypeEnableAllowEveryOne() {
        this.testAuthorizeByResourceTypeEnableAllowEveryOne((org.apache.kafka.server.authorizer.Authorizer)this.wrappedSimpleAuthorizer());
    }

    private void testAuthorizeByResourceTypeEnableAllowEveryOne(org.apache.kafka.server.authorizer.Authorizer authorizer) {
        Assertions.assertTrue((boolean)this.authorizeByResourceType((org.apache.kafka.server.authorizer.Authorizer)this.wrappedSimpleAuthorizerAllowEveryone(), this.requestContext(), AclOperation.READ, this.resource().resourceType()), (String)"If allow.everyone.if.no.acl.found = true, caller should have read access to at least one topic");
        String allUser = AclEntry$.MODULE$.WildcardPrincipalString();
        String allHost = AclEntry$.MODULE$.WildcardHost();
        AccessControlEntry denyAll = new AccessControlEntry(allUser, allHost, AclOperation.ALL, AclPermissionType.DENY);
        ResourcePattern wildcardResource = new ResourcePattern(this.resource().resourceType(), AclEntry$.MODULE$.WildcardResource(), PatternType.LITERAL);
        this.addAcls((org.apache.kafka.server.authorizer.Authorizer)this.wrappedSimpleAuthorizerAllowEveryone(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAll}))), this.resource());
        Assertions.assertTrue((boolean)this.authorizeByResourceType((org.apache.kafka.server.authorizer.Authorizer)this.wrappedSimpleAuthorizerAllowEveryone(), this.requestContext(), AclOperation.READ, this.resource().resourceType()), (String)"Should still allow since the deny only apply on the specific resource");
        this.addAcls((org.apache.kafka.server.authorizer.Authorizer)this.wrappedSimpleAuthorizerAllowEveryone(), (Set<AccessControlEntry>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAll}))), wildcardResource);
        Assertions.assertFalse((boolean)this.authorizeByResourceType((org.apache.kafka.server.authorizer.Authorizer)this.wrappedSimpleAuthorizerAllowEveryone(), this.requestContext(), AclOperation.READ, this.resource().resourceType()), (String)"When an ACL binding which can deny all users and hosts exists, even if allow.everyone.if.no.acl.found = true, caller shouldn't have read access any topic");
    }

    @Test
    public void testAuthorizeByResourceTypeDisableAllowEveryoneOverride() {
        Assertions.assertFalse((boolean)this.authorizeByResourceType((org.apache.kafka.server.authorizer.Authorizer)this.wrappedSimpleAuthorizer(), this.requestContext(), AclOperation.READ, this.resource().resourceType()), (String)"If allow.everyone.if.no.acl.found = false, caller shouldn't have read access to any topic");
    }

    public AuthorizerWrapperTest() {
        BaseAuthorizerTest.$init$(this);
        this.wrappedSimpleAuthorizer = new AuthorizerWrapper((Authorizer)new SimpleAclAuthorizer());
        this.wrappedSimpleAuthorizerAllowEveryone = new AuthorizerWrapper((Authorizer)new SimpleAclAuthorizer());
        Statics.releaseFence();
    }
}

