/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import java.io.Serializable;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import kafka.server.metadata.MetadataBroker;
import kafka.server.metadata.MetadataBrokers;
import kafka.server.metadata.MetadataBrokersBuilder;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.mutable.HashSet;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Timeout(value=120000L, unit=TimeUnit.MILLISECONDS)
@ScalaSignature(bytes="\u0006\u0005M3A!\u0003\u0006\u0001#!)\u0001\u0004\u0001C\u00013!9A\u0004\u0001b\u0001\n\u0013i\u0002B\u0002\u0014\u0001A\u0003%a\u0004C\u0004(\u0001\t\u0007I\u0011\u0001\u0015\t\r1\u0002\u0001\u0015!\u0003*\u0011\u0015i\u0003\u0001\"\u0001/\u0011\u0015i\u0004\u0001\"\u0001/\u0011\u0015y\u0004\u0001\"\u0001/\u0005MiU\r^1eCR\f'I]8lKJ\u001cH+Z:u\u0015\tYA\"\u0001\u0005nKR\fG-\u0019;b\u0015\tia\"\u0001\u0004tKJ4XM\u001d\u0006\u0002\u001f\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0013!\t\u0019b#D\u0001\u0015\u0015\u0005)\u0012!B:dC2\f\u0017BA\f\u0015\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012A\u0007\t\u00037\u0001i\u0011AC\u0001\u0004Y><W#\u0001\u0010\u0011\u0005}!S\"\u0001\u0011\u000b\u0005\u0005\u0012\u0013!B:mMRR'\"A\u0012\u0002\u0007=\u0014x-\u0003\u0002&A\t1Aj\\4hKJ\fA\u0001\\8hA\u0005aQ-\u001c9us\n\u0013xn[3sgV\t\u0011\u0006\u0005\u0002\u001cU%\u00111F\u0003\u0002\u0010\u001b\u0016$\u0018\rZ1uC\n\u0013xn[3sg\u0006iQ-\u001c9us\n\u0013xn[3sg\u0002\n\u0001\u0003^3ti\n+\u0018\u000e\u001c3Ce>\\WM]:\u0015\u0003=\u0002\"a\u0005\u0019\n\u0005E\"\"\u0001B+oSRD#AB\u001a\u0011\u0005QZT\"A\u001b\u000b\u0005Y:\u0014aA1qS*\u0011\u0001(O\u0001\bUV\u0004\u0018\u000e^3s\u0015\tQ$%A\u0003kk:LG/\u0003\u0002=k\t!A+Z:u\u0003E!Xm\u001d;DQ\u0006tw-\u001a$f]\u000eLgn\u001a\u0015\u0003\u000fM\n\u0001\u0003^3ti\u0006c\u0017N^3Ce>\\WM]:)\u0005!\u0019\u0004F\u0002\u0001C\u000b\u001a;\u0005\n\u0005\u00025\u0007&\u0011A)\u000e\u0002\b)&lWm\\;u\u0003\u00151\u0018\r\\;f=\r\tA\u001bq\u0001\u0005k:LG\u000fJ\u0001J\u0013\tQ5*\u0001\u0007N\u00132c\u0015jU#D\u001f:#5K\u0003\u0002M\u001b\u0006AA+[7f+:LGO\u0003\u0002O\u001f\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005A\u000b\u0016\u0001B;uS2T\u0011AU\u0001\u0005U\u00064\u0018\r")
public class MetadataBrokersTest {
    private final Logger log = LoggerFactory.getLogger(MetadataBrokersTest.class);
    private final MetadataBrokers emptyBrokers = new MetadataBrokers(Collections.emptyList(), Collections.emptyMap());

    private Logger log() {
        return this.log;
    }

    public MetadataBrokers emptyBrokers() {
        return this.emptyBrokers;
    }

    @Test
    public void testBuildBrokers() {
        MetadataBrokersBuilder builder = new MetadataBrokersBuilder(this.log(), this.emptyBrokers());
        builder.add(TestUtils$.MODULE$.createMetadataBroker(0, "localhost", 9092, SecurityProtocol.PLAINTEXT, (Option<String>)None$.MODULE$, false));
        builder.add(TestUtils$.MODULE$.createMetadataBroker(1, "localhost", 9092, SecurityProtocol.PLAINTEXT, (Option<String>)None$.MODULE$, false));
        builder.add(TestUtils$.MODULE$.createMetadataBroker(2, "localhost", 9092, SecurityProtocol.PLAINTEXT, (Option<String>)None$.MODULE$, false));
        builder.add(TestUtils$.MODULE$.createMetadataBroker(3, "localhost", 9092, SecurityProtocol.PLAINTEXT, (Option<String>)None$.MODULE$, false));
        builder.remove(0);
        MetadataBrokers brokers = builder.build();
        HashSet found = new HashSet();
        brokers.iterator().foreach((Function1 & Serializable)x$1 -> (HashSet)found.$plus$eq(x$1));
        HashSet expected = new HashSet();
        expected.$plus$eq((Object)TestUtils$.MODULE$.createMetadataBroker(1, "localhost", 9092, SecurityProtocol.PLAINTEXT, (Option<String>)None$.MODULE$, false));
        expected.$plus$eq((Object)TestUtils$.MODULE$.createMetadataBroker(2, "localhost", 9092, SecurityProtocol.PLAINTEXT, (Option<String>)None$.MODULE$, false));
        expected.$plus$eq((Object)TestUtils$.MODULE$.createMetadataBroker(3, "localhost", 9092, SecurityProtocol.PLAINTEXT, (Option<String>)None$.MODULE$, false));
        Assertions.assertEquals((Object)expected, (Object)found);
    }

    @Test
    public void testChangeFencing() {
        None$ none$;
        SecurityProtocol securityProtocol;
        String string;
        MetadataBrokersBuilder builder = new MetadataBrokersBuilder(this.log(), this.emptyBrokers());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)builder.get(0));
        Assertions.assertThrows(RuntimeException.class, () -> builder.changeFencing(0, false));
        String string2 = string = "localhost";
        string = null;
        String x$3 = string2;
        int n = 9092;
        SecurityProtocol securityProtocol2 = securityProtocol = SecurityProtocol.PLAINTEXT;
        securityProtocol = null;
        SecurityProtocol x$5 = securityProtocol2;
        None$ none$2 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$6 = none$2;
        builder.add(TestUtils$.MODULE$.createMetadataBroker(0, x$3, n, x$5, (Option<String>)x$6, true));
        Assertions.assertTrue((boolean)((MetadataBroker)builder.get(0).get()).fenced());
        builder.changeFencing(0, false);
        Assertions.assertFalse((boolean)((MetadataBroker)builder.get(0).get()).fenced());
        Assertions.assertTrue((boolean)builder.build().aliveBroker(0).isDefined());
    }

    @Test
    public void testAliveBrokers() {
        None$ none$;
        SecurityProtocol securityProtocol;
        String string;
        MetadataBrokersBuilder builder = new MetadataBrokersBuilder(this.log(), this.emptyBrokers());
        builder.add(TestUtils$.MODULE$.createMetadataBroker(0, "localhost", 9092, SecurityProtocol.PLAINTEXT, (Option<String>)None$.MODULE$, false));
        builder.add(TestUtils$.MODULE$.createMetadataBroker(1, "localhost", 9092, SecurityProtocol.PLAINTEXT, (Option<String>)None$.MODULE$, false));
        builder.add(TestUtils$.MODULE$.createMetadataBroker(2, "localhost", 9092, SecurityProtocol.PLAINTEXT, (Option<String>)None$.MODULE$, false));
        builder.changeFencing(1, true);
        MetadataBrokers brokers = builder.build();
        Assertions.assertEquals((int)2, (int)brokers.aliveBrokers().size());
        Assertions.assertTrue((boolean)brokers.aliveBrokers().exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)MetadataBrokersTest.$anonfun$testAliveBrokers$1(x$2))));
        Assertions.assertTrue((!brokers.aliveBrokers().exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MetadataBrokersTest.$anonfun$testAliveBrokers$2(x$3))) ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)brokers.aliveBrokers().exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)MetadataBrokersTest.$anonfun$testAliveBrokers$3(x$4))));
        while (!brokers.randomAliveBrokerId().contains((Object)BoxesRunTime.boxToInteger((int)0))) {
        }
        while (!brokers.randomAliveBrokerId().contains((Object)BoxesRunTime.boxToInteger((int)2))) {
        }
        Assertions.assertEquals((int)3, (int)brokers.size());
        Assertions.assertEquals((Object)new Some((Object)TestUtils$.MODULE$.createMetadataBroker(0, "localhost", 9092, SecurityProtocol.PLAINTEXT, (Option<String>)None$.MODULE$, false)), (Object)brokers.get(0));
        String string2 = string = "localhost";
        string = null;
        String x$32 = string2;
        int n = 9092;
        SecurityProtocol securityProtocol2 = securityProtocol = SecurityProtocol.PLAINTEXT;
        securityProtocol = null;
        SecurityProtocol x$5 = securityProtocol2;
        None$ none$2 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$6 = none$2;
        Assertions.assertEquals((Object)new Some((Object)TestUtils$.MODULE$.createMetadataBroker(1, x$32, n, x$5, (Option<String>)x$6, true)), (Object)brokers.get(1));
        Assertions.assertEquals((Object)new Some((Object)TestUtils$.MODULE$.createMetadataBroker(2, "localhost", 9092, SecurityProtocol.PLAINTEXT, (Option<String>)None$.MODULE$, false)), (Object)brokers.get(2));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)brokers.get(3));
        Assertions.assertEquals((Object)new Some((Object)TestUtils$.MODULE$.createMetadataBroker(0, "localhost", 9092, SecurityProtocol.PLAINTEXT, (Option<String>)None$.MODULE$, false)), (Object)brokers.aliveBroker(0));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)brokers.aliveBroker(1));
    }

    public static final /* synthetic */ boolean $anonfun$testAliveBrokers$1(MetadataBroker x$2) {
        return x$2.id() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testAliveBrokers$2(MetadataBroker x$3) {
        return x$3.id() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testAliveBrokers$3(MetadataBroker x$4) {
        return x$4.id() == 2;
    }
}

